/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.BootModeValues;
import software.amazon.awssdk.services.ec2.model.ClientData;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.ImageDiskContainer;
import software.amazon.awssdk.services.ec2.model.ImageDiskContainerListCopier;
import software.amazon.awssdk.services.ec2.model.ImportImageLicenseConfigurationRequest;
import software.amazon.awssdk.services.ec2.model.ImportImageLicenseSpecificationListRequestCopier;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportImageRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ImportImageRequest> {
    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Architecture").getter(ImportImageRequest.getter(ImportImageRequest::architecture)).setter(ImportImageRequest.setter(Builder::architecture)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Architecture").unmarshallLocationName("Architecture").build()}).build();
    private static final SdkField<ClientData> CLIENT_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ClientData").getter(ImportImageRequest.getter(ImportImageRequest::clientData)).setter(ImportImageRequest.setter(Builder::clientData)).constructor(ClientData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientData").unmarshallLocationName("ClientData").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(ImportImageRequest.getter(ImportImageRequest::clientToken)).setter(ImportImageRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ImportImageRequest.getter(ImportImageRequest::description)).setter(ImportImageRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<List<ImageDiskContainer>> DISK_CONTAINERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DiskContainers").getter(ImportImageRequest.getter(ImportImageRequest::diskContainers)).setter(ImportImageRequest.setter(Builder::diskContainers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskContainer").unmarshallLocationName("DiskContainer").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImageDiskContainer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Encrypted").getter(ImportImageRequest.getter(ImportImageRequest::encrypted)).setter(ImportImageRequest.setter(Builder::encrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").unmarshallLocationName("Encrypted").build()}).build();
    private static final SdkField<String> HYPERVISOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Hypervisor").getter(ImportImageRequest.getter(ImportImageRequest::hypervisor)).setter(ImportImageRequest.setter(Builder::hypervisor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hypervisor").unmarshallLocationName("Hypervisor").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(ImportImageRequest.getter(ImportImageRequest::kmsKeyId)).setter(ImportImageRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").unmarshallLocationName("KmsKeyId").build()}).build();
    private static final SdkField<String> LICENSE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseType").getter(ImportImageRequest.getter(ImportImageRequest::licenseType)).setter(ImportImageRequest.setter(Builder::licenseType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseType").unmarshallLocationName("LicenseType").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Platform").getter(ImportImageRequest.getter(ImportImageRequest::platform)).setter(ImportImageRequest.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform").unmarshallLocationName("Platform").build()}).build();
    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleName").getter(ImportImageRequest.getter(ImportImageRequest::roleName)).setter(ImportImageRequest.setter(Builder::roleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleName").unmarshallLocationName("RoleName").build()}).build();
    private static final SdkField<List<ImportImageLicenseConfigurationRequest>> LICENSE_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LicenseSpecifications").getter(ImportImageRequest.getter(ImportImageRequest::licenseSpecifications)).setter(ImportImageRequest.setter(Builder::licenseSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseSpecifications").unmarshallLocationName("LicenseSpecifications").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImportImageLicenseConfigurationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(ImportImageRequest.getter(ImportImageRequest::tagSpecifications)).setter(ImportImageRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> USAGE_OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UsageOperation").getter(ImportImageRequest.getter(ImportImageRequest::usageOperation)).setter(ImportImageRequest.setter(Builder::usageOperation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageOperation").unmarshallLocationName("UsageOperation").build()}).build();
    private static final SdkField<String> BOOT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BootMode").getter(ImportImageRequest.getter(ImportImageRequest::bootModeAsString)).setter(ImportImageRequest.setter(Builder::bootMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BootMode").unmarshallLocationName("BootMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHITECTURE_FIELD, CLIENT_DATA_FIELD, CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, DISK_CONTAINERS_FIELD, ENCRYPTED_FIELD, HYPERVISOR_FIELD, KMS_KEY_ID_FIELD, LICENSE_TYPE_FIELD, PLATFORM_FIELD, ROLE_NAME_FIELD, LICENSE_SPECIFICATIONS_FIELD, TAG_SPECIFICATIONS_FIELD, USAGE_OPERATION_FIELD, BOOT_MODE_FIELD));
    private final String architecture;
    private final ClientData clientData;
    private final String clientToken;
    private final String description;
    private final List<ImageDiskContainer> diskContainers;
    private final Boolean encrypted;
    private final String hypervisor;
    private final String kmsKeyId;
    private final String licenseType;
    private final String platform;
    private final String roleName;
    private final List<ImportImageLicenseConfigurationRequest> licenseSpecifications;
    private final List<TagSpecification> tagSpecifications;
    private final String usageOperation;
    private final String bootMode;

    private ImportImageRequest(BuilderImpl builder) {
        super(builder);
        this.architecture = builder.architecture;
        this.clientData = builder.clientData;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.diskContainers = builder.diskContainers;
        this.encrypted = builder.encrypted;
        this.hypervisor = builder.hypervisor;
        this.kmsKeyId = builder.kmsKeyId;
        this.licenseType = builder.licenseType;
        this.platform = builder.platform;
        this.roleName = builder.roleName;
        this.licenseSpecifications = builder.licenseSpecifications;
        this.tagSpecifications = builder.tagSpecifications;
        this.usageOperation = builder.usageOperation;
        this.bootMode = builder.bootMode;
    }

    public final String architecture() {
        return this.architecture;
    }

    public final ClientData clientData() {
        return this.clientData;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasDiskContainers() {
        return this.diskContainers != null && !(this.diskContainers instanceof SdkAutoConstructList);
    }

    public final List<ImageDiskContainer> diskContainers() {
        return this.diskContainers;
    }

    public final Boolean encrypted() {
        return this.encrypted;
    }

    public final String hypervisor() {
        return this.hypervisor;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String licenseType() {
        return this.licenseType;
    }

    public final String platform() {
        return this.platform;
    }

    public final String roleName() {
        return this.roleName;
    }

    public final boolean hasLicenseSpecifications() {
        return this.licenseSpecifications != null && !(this.licenseSpecifications instanceof SdkAutoConstructList);
    }

    public final List<ImportImageLicenseConfigurationRequest> licenseSpecifications() {
        return this.licenseSpecifications;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final String usageOperation() {
        return this.usageOperation;
    }

    public final BootModeValues bootMode() {
        return BootModeValues.fromValue(this.bootMode);
    }

    public final String bootModeAsString() {
        return this.bootMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.architecture());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientData());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDiskContainers() ? this.diskContainers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.hypervisor());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseType());
        hashCode = 31 * hashCode + Objects.hashCode(this.platform());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLicenseSpecifications() ? this.licenseSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.usageOperation());
        hashCode = 31 * hashCode + Objects.hashCode(this.bootModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportImageRequest)) {
            return false;
        }
        ImportImageRequest other = (ImportImageRequest)((Object)obj);
        return Objects.equals(this.architecture(), other.architecture()) && Objects.equals(this.clientData(), other.clientData()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.description(), other.description()) && this.hasDiskContainers() == other.hasDiskContainers() && Objects.equals(this.diskContainers(), other.diskContainers()) && Objects.equals(this.encrypted(), other.encrypted()) && Objects.equals(this.hypervisor(), other.hypervisor()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.licenseType(), other.licenseType()) && Objects.equals(this.platform(), other.platform()) && Objects.equals(this.roleName(), other.roleName()) && this.hasLicenseSpecifications() == other.hasLicenseSpecifications() && Objects.equals(this.licenseSpecifications(), other.licenseSpecifications()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.usageOperation(), other.usageOperation()) && Objects.equals(this.bootModeAsString(), other.bootModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ImportImageRequest").add("Architecture", (Object)this.architecture()).add("ClientData", (Object)this.clientData()).add("ClientToken", (Object)this.clientToken()).add("Description", (Object)this.description()).add("DiskContainers", this.hasDiskContainers() ? this.diskContainers() : null).add("Encrypted", (Object)this.encrypted()).add("Hypervisor", (Object)this.hypervisor()).add("KmsKeyId", (Object)this.kmsKeyId()).add("LicenseType", (Object)this.licenseType()).add("Platform", (Object)this.platform()).add("RoleName", (Object)this.roleName()).add("LicenseSpecifications", this.hasLicenseSpecifications() ? this.licenseSpecifications() : null).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("UsageOperation", (Object)this.usageOperation()).add("BootMode", (Object)this.bootModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Architecture": {
                return Optional.ofNullable(clazz.cast(this.architecture()));
            }
            case "ClientData": {
                return Optional.ofNullable(clazz.cast(this.clientData()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DiskContainers": {
                return Optional.ofNullable(clazz.cast(this.diskContainers()));
            }
            case "Encrypted": {
                return Optional.ofNullable(clazz.cast(this.encrypted()));
            }
            case "Hypervisor": {
                return Optional.ofNullable(clazz.cast(this.hypervisor()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "LicenseType": {
                return Optional.ofNullable(clazz.cast(this.licenseType()));
            }
            case "Platform": {
                return Optional.ofNullable(clazz.cast(this.platform()));
            }
            case "RoleName": {
                return Optional.ofNullable(clazz.cast(this.roleName()));
            }
            case "LicenseSpecifications": {
                return Optional.ofNullable(clazz.cast(this.licenseSpecifications()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "UsageOperation": {
                return Optional.ofNullable(clazz.cast(this.usageOperation()));
            }
            case "BootMode": {
                return Optional.ofNullable(clazz.cast(this.bootModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportImageRequest, T> g) {
        return obj -> g.apply((ImportImageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String architecture;
        private ClientData clientData;
        private String clientToken;
        private String description;
        private List<ImageDiskContainer> diskContainers = DefaultSdkAutoConstructList.getInstance();
        private Boolean encrypted;
        private String hypervisor;
        private String kmsKeyId;
        private String licenseType;
        private String platform;
        private String roleName;
        private List<ImportImageLicenseConfigurationRequest> licenseSpecifications = DefaultSdkAutoConstructList.getInstance();
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private String usageOperation;
        private String bootMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportImageRequest model) {
            super(model);
            this.architecture(model.architecture);
            this.clientData(model.clientData);
            this.clientToken(model.clientToken);
            this.description(model.description);
            this.diskContainers(model.diskContainers);
            this.encrypted(model.encrypted);
            this.hypervisor(model.hypervisor);
            this.kmsKeyId(model.kmsKeyId);
            this.licenseType(model.licenseType);
            this.platform(model.platform);
            this.roleName(model.roleName);
            this.licenseSpecifications(model.licenseSpecifications);
            this.tagSpecifications(model.tagSpecifications);
            this.usageOperation(model.usageOperation);
            this.bootMode(model.bootMode);
        }

        public final String getArchitecture() {
            return this.architecture;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        public final ClientData.Builder getClientData() {
            return this.clientData != null ? this.clientData.toBuilder() : null;
        }

        public final void setClientData(ClientData.BuilderImpl clientData) {
            this.clientData = clientData != null ? clientData.build() : null;
        }

        @Override
        public final Builder clientData(ClientData clientData) {
            this.clientData = clientData;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<ImageDiskContainer.Builder> getDiskContainers() {
            List<ImageDiskContainer.Builder> result = ImageDiskContainerListCopier.copyToBuilder(this.diskContainers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDiskContainers(Collection<ImageDiskContainer.BuilderImpl> diskContainers) {
            this.diskContainers = ImageDiskContainerListCopier.copyFromBuilder(diskContainers);
        }

        @Override
        public final Builder diskContainers(Collection<ImageDiskContainer> diskContainers) {
            this.diskContainers = ImageDiskContainerListCopier.copy(diskContainers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder diskContainers(ImageDiskContainer ... diskContainers) {
            this.diskContainers(Arrays.asList(diskContainers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder diskContainers(Consumer<ImageDiskContainer.Builder> ... diskContainers) {
            this.diskContainers(Stream.of(diskContainers).map(c -> (ImageDiskContainer)((ImageDiskContainer.Builder)ImageDiskContainer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final String getHypervisor() {
            return this.hypervisor;
        }

        public final void setHypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
        }

        @Override
        public final Builder hypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getLicenseType() {
            return this.licenseType;
        }

        public final void setLicenseType(String licenseType) {
            this.licenseType = licenseType;
        }

        @Override
        public final Builder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        public final String getPlatform() {
            return this.platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final String getRoleName() {
            return this.roleName;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final List<ImportImageLicenseConfigurationRequest.Builder> getLicenseSpecifications() {
            List<ImportImageLicenseConfigurationRequest.Builder> result = ImportImageLicenseSpecificationListRequestCopier.copyToBuilder(this.licenseSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLicenseSpecifications(Collection<ImportImageLicenseConfigurationRequest.BuilderImpl> licenseSpecifications) {
            this.licenseSpecifications = ImportImageLicenseSpecificationListRequestCopier.copyFromBuilder(licenseSpecifications);
        }

        @Override
        public final Builder licenseSpecifications(Collection<ImportImageLicenseConfigurationRequest> licenseSpecifications) {
            this.licenseSpecifications = ImportImageLicenseSpecificationListRequestCopier.copy(licenseSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseSpecifications(ImportImageLicenseConfigurationRequest ... licenseSpecifications) {
            this.licenseSpecifications(Arrays.asList(licenseSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseSpecifications(Consumer<ImportImageLicenseConfigurationRequest.Builder> ... licenseSpecifications) {
            this.licenseSpecifications(Stream.of(licenseSpecifications).map(c -> (ImportImageLicenseConfigurationRequest)((ImportImageLicenseConfigurationRequest.Builder)ImportImageLicenseConfigurationRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getUsageOperation() {
            return this.usageOperation;
        }

        public final void setUsageOperation(String usageOperation) {
            this.usageOperation = usageOperation;
        }

        @Override
        public final Builder usageOperation(String usageOperation) {
            this.usageOperation = usageOperation;
            return this;
        }

        public final String getBootMode() {
            return this.bootMode;
        }

        public final void setBootMode(String bootMode) {
            this.bootMode = bootMode;
        }

        @Override
        public final Builder bootMode(String bootMode) {
            this.bootMode = bootMode;
            return this;
        }

        @Override
        public final Builder bootMode(BootModeValues bootMode) {
            this.bootMode(bootMode == null ? null : bootMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportImageRequest build() {
            return new ImportImageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ImportImageRequest> {
        public Builder architecture(String var1);

        public Builder clientData(ClientData var1);

        default public Builder clientData(Consumer<ClientData.Builder> clientData) {
            return this.clientData((ClientData)((ClientData.Builder)ClientData.builder().applyMutation(clientData)).build());
        }

        public Builder clientToken(String var1);

        public Builder description(String var1);

        public Builder diskContainers(Collection<ImageDiskContainer> var1);

        public Builder diskContainers(ImageDiskContainer ... var1);

        public Builder diskContainers(Consumer<ImageDiskContainer.Builder> ... var1);

        public Builder encrypted(Boolean var1);

        public Builder hypervisor(String var1);

        public Builder kmsKeyId(String var1);

        public Builder licenseType(String var1);

        public Builder platform(String var1);

        public Builder roleName(String var1);

        public Builder licenseSpecifications(Collection<ImportImageLicenseConfigurationRequest> var1);

        public Builder licenseSpecifications(ImportImageLicenseConfigurationRequest ... var1);

        public Builder licenseSpecifications(Consumer<ImportImageLicenseConfigurationRequest.Builder> ... var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder usageOperation(String var1);

        public Builder bootMode(String var1);

        public Builder bootMode(BootModeValues var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

