/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCoipCidrResponse extends Ec2Response implements
        ToCopyableBuilder<CreateCoipCidrResponse.Builder, CreateCoipCidrResponse> {
    private static final SdkField<CoipCidr> COIP_CIDR_FIELD = SdkField
            .<CoipCidr> builder(MarshallingType.SDK_POJO)
            .memberName("CoipCidr")
            .getter(getter(CreateCoipCidrResponse::coipCidr))
            .setter(setter(Builder::coipCidr))
            .constructor(CoipCidr::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoipCidr")
                    .unmarshallLocationName("coipCidr").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COIP_CIDR_FIELD));

    private final CoipCidr coipCidr;

    private CreateCoipCidrResponse(BuilderImpl builder) {
        super(builder);
        this.coipCidr = builder.coipCidr;
    }

    /**
     * <p>
     * Information about a range of customer-owned IP addresses.
     * </p>
     * 
     * @return Information about a range of customer-owned IP addresses.
     */
    public final CoipCidr coipCidr() {
        return coipCidr;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(coipCidr());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCoipCidrResponse)) {
            return false;
        }
        CreateCoipCidrResponse other = (CreateCoipCidrResponse) obj;
        return Objects.equals(coipCidr(), other.coipCidr());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCoipCidrResponse").add("CoipCidr", coipCidr()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CoipCidr":
            return Optional.ofNullable(clazz.cast(coipCidr()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCoipCidrResponse, T> g) {
        return obj -> g.apply((CreateCoipCidrResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateCoipCidrResponse> {
        /**
         * <p>
         * Information about a range of customer-owned IP addresses.
         * </p>
         * 
         * @param coipCidr
         *        Information about a range of customer-owned IP addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coipCidr(CoipCidr coipCidr);

        /**
         * <p>
         * Information about a range of customer-owned IP addresses.
         * </p>
         * This is a convenience method that creates an instance of the {@link CoipCidr.Builder} avoiding the need to
         * create one manually via {@link CoipCidr#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CoipCidr.Builder#build()} is called immediately and its result is
         * passed to {@link #coipCidr(CoipCidr)}.
         * 
         * @param coipCidr
         *        a consumer that will call methods on {@link CoipCidr.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #coipCidr(CoipCidr)
         */
        default Builder coipCidr(Consumer<CoipCidr.Builder> coipCidr) {
            return coipCidr(CoipCidr.builder().applyMutation(coipCidr).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private CoipCidr coipCidr;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCoipCidrResponse model) {
            super(model);
            coipCidr(model.coipCidr);
        }

        public final CoipCidr.Builder getCoipCidr() {
            return coipCidr != null ? coipCidr.toBuilder() : null;
        }

        public final void setCoipCidr(CoipCidr.BuilderImpl coipCidr) {
            this.coipCidr = coipCidr != null ? coipCidr.build() : null;
        }

        @Override
        public final Builder coipCidr(CoipCidr coipCidr) {
            this.coipCidr = coipCidr;
            return this;
        }

        @Override
        public CreateCoipCidrResponse build() {
            return new CreateCoipCidrResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
