/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.protocols.query.interceptor.QueryParametersToBodyInterceptor;
import software.amazon.awssdk.services.ec2.endpoints.Ec2EndpointProvider;
import software.amazon.awssdk.services.ec2.transform.internal.GeneratePreSignUrlInterceptor;
import software.amazon.awssdk.services.ec2.transform.internal.TimestampFormatInterceptor;
import software.amazon.awssdk.utils.CollectionUtils;

/**
 * Internal implementation of {@link Ec2AsyncClientBuilder}.
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultEc2AsyncClientBuilder extends DefaultEc2BaseClientBuilder<Ec2AsyncClientBuilder, Ec2AsyncClient> implements
        Ec2AsyncClientBuilder {
    @Override
    public DefaultEc2AsyncClientBuilder endpointProvider(Ec2EndpointProvider endpointProvider) {
        clientConfiguration.option(SdkClientOption.ENDPOINT_PROVIDER, endpointProvider);
        return this;
    }

    @Override
    protected final Ec2AsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        List<ExecutionInterceptor> interceptors = clientConfiguration.option(SdkClientOption.EXECUTION_INTERCEPTORS);
        List<ExecutionInterceptor> queryParamsToBodyInterceptor = Collections
                .singletonList(new QueryParametersToBodyInterceptor());
        List<ExecutionInterceptor> customizationInterceptors = new ArrayList<>();
        customizationInterceptors.add(new GeneratePreSignUrlInterceptor());
        customizationInterceptors.add(new TimestampFormatInterceptor());
        interceptors = CollectionUtils.mergeLists(queryParamsToBodyInterceptor, interceptors);
        interceptors = CollectionUtils.mergeLists(customizationInterceptors, interceptors);
        clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.EXECUTION_INTERCEPTORS, interceptors)
                .build();
        this.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option(SdkClientOption.ENDPOINT_OVERRIDDEN) != null
                && Boolean.TRUE.equals(clientConfiguration.option(SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = clientConfiguration.option(SdkClientOption.ENDPOINT);
        }
        Ec2ServiceClientConfiguration serviceClientConfiguration = Ec2ServiceClientConfiguration.builder()
                .overrideConfiguration(overrideConfiguration()).region(clientConfiguration.option(AwsClientOption.AWS_REGION))
                .endpointOverride(endpointOverride).build();
        return new DefaultEc2AsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}
