/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeReplaceRootVolumeTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeReplaceRootVolumeTasksResponse;
import software.amazon.awssdk.services.ec2.model.ReplaceRootVolumeTask;

public class DescribeReplaceRootVolumeTasksIterable
implements SdkIterable<DescribeReplaceRootVolumeTasksResponse> {
    private final Ec2Client client;
    private final DescribeReplaceRootVolumeTasksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeReplaceRootVolumeTasksIterable(Ec2Client client, DescribeReplaceRootVolumeTasksRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeReplaceRootVolumeTasksResponseFetcher();
    }

    public Iterator<DescribeReplaceRootVolumeTasksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ReplaceRootVolumeTask> replaceRootVolumeTasks() {
        Function<DescribeReplaceRootVolumeTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.replaceRootVolumeTasks() != null) {
                return response.replaceRootVolumeTasks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeReplaceRootVolumeTasksResponseFetcher
    implements SyncPageFetcher<DescribeReplaceRootVolumeTasksResponse> {
        private DescribeReplaceRootVolumeTasksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReplaceRootVolumeTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeReplaceRootVolumeTasksResponse nextPage(DescribeReplaceRootVolumeTasksResponse previousPage) {
            if (previousPage == null) {
                return DescribeReplaceRootVolumeTasksIterable.this.client.describeReplaceRootVolumeTasks(DescribeReplaceRootVolumeTasksIterable.this.firstRequest);
            }
            return DescribeReplaceRootVolumeTasksIterable.this.client.describeReplaceRootVolumeTasks((DescribeReplaceRootVolumeTasksRequest)((Object)DescribeReplaceRootVolumeTasksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

