/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AllocateHostsRequest extends Ec2Request implements
        ToCopyableBuilder<AllocateHostsRequest.Builder, AllocateHostsRequest> {
    private static final SdkField<String> AUTO_PLACEMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AutoPlacement")
            .getter(getter(AllocateHostsRequest::autoPlacementAsString))
            .setter(setter(Builder::autoPlacement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoPlacement")
                    .unmarshallLocationName("autoPlacement").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone")
            .getter(getter(AllocateHostsRequest::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("availabilityZone").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(AllocateHostsRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("clientToken").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceType")
            .getter(getter(AllocateHostsRequest::instanceType))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType")
                    .unmarshallLocationName("instanceType").build()).build();

    private static final SdkField<String> INSTANCE_FAMILY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceFamily")
            .getter(getter(AllocateHostsRequest::instanceFamily))
            .setter(setter(Builder::instanceFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFamily")
                    .unmarshallLocationName("InstanceFamily").build()).build();

    private static final SdkField<Integer> QUANTITY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Quantity")
            .getter(getter(AllocateHostsRequest::quantity))
            .setter(setter(Builder::quantity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quantity")
                    .unmarshallLocationName("quantity").build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(AllocateHostsRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> HOST_RECOVERY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HostRecovery")
            .getter(getter(AllocateHostsRequest::hostRecoveryAsString))
            .setter(setter(Builder::hostRecovery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostRecovery")
                    .unmarshallLocationName("HostRecovery").build()).build();

    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OutpostArn")
            .getter(getter(AllocateHostsRequest::outpostArn))
            .setter(setter(Builder::outpostArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn")
                    .unmarshallLocationName("OutpostArn").build()).build();

    private static final SdkField<String> HOST_MAINTENANCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HostMaintenance")
            .getter(getter(AllocateHostsRequest::hostMaintenanceAsString))
            .setter(setter(Builder::hostMaintenance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostMaintenance")
                    .unmarshallLocationName("HostMaintenance").build()).build();

    private static final SdkField<List<String>> ASSET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AssetIds")
            .getter(getter(AllocateHostsRequest::assetIds))
            .setter(setter(Builder::assetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetId")
                    .unmarshallLocationName("AssetId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_PLACEMENT_FIELD,
            AVAILABILITY_ZONE_FIELD, CLIENT_TOKEN_FIELD, INSTANCE_TYPE_FIELD, INSTANCE_FAMILY_FIELD, QUANTITY_FIELD,
            TAG_SPECIFICATIONS_FIELD, HOST_RECOVERY_FIELD, OUTPOST_ARN_FIELD, HOST_MAINTENANCE_FIELD, ASSET_IDS_FIELD));

    private final String autoPlacement;

    private final String availabilityZone;

    private final String clientToken;

    private final String instanceType;

    private final String instanceFamily;

    private final Integer quantity;

    private final List<TagSpecification> tagSpecifications;

    private final String hostRecovery;

    private final String outpostArn;

    private final String hostMaintenance;

    private final List<String> assetIds;

    private AllocateHostsRequest(BuilderImpl builder) {
        super(builder);
        this.autoPlacement = builder.autoPlacement;
        this.availabilityZone = builder.availabilityZone;
        this.clientToken = builder.clientToken;
        this.instanceType = builder.instanceType;
        this.instanceFamily = builder.instanceFamily;
        this.quantity = builder.quantity;
        this.tagSpecifications = builder.tagSpecifications;
        this.hostRecovery = builder.hostRecovery;
        this.outpostArn = builder.outpostArn;
        this.hostMaintenance = builder.hostMaintenance;
        this.assetIds = builder.assetIds;
    }

    /**
     * <p>
     * Indicates whether the host accepts any untargeted instance launches that match its instance type configuration,
     * or if it only accepts Host tenancy instance launches that specify its unique host ID. For more information, see
     * <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/how-dedicated-hosts-work.html#dedicated-hosts-understanding"
     * > Understanding auto-placement and affinity</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * Default: <code>on</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoPlacement}
     * will return {@link AutoPlacement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #autoPlacementAsString}.
     * </p>
     * 
     * @return Indicates whether the host accepts any untargeted instance launches that match its instance type
     *         configuration, or if it only accepts Host tenancy instance launches that specify its unique host ID. For
     *         more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/how-dedicated-hosts-work.html#dedicated-hosts-understanding"
     *         > Understanding auto-placement and affinity</a> in the <i>Amazon EC2 User Guide</i>.</p>
     *         <p>
     *         Default: <code>on</code>
     * @see AutoPlacement
     */
    public final AutoPlacement autoPlacement() {
        return AutoPlacement.fromValue(autoPlacement);
    }

    /**
     * <p>
     * Indicates whether the host accepts any untargeted instance launches that match its instance type configuration,
     * or if it only accepts Host tenancy instance launches that specify its unique host ID. For more information, see
     * <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/how-dedicated-hosts-work.html#dedicated-hosts-understanding"
     * > Understanding auto-placement and affinity</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * Default: <code>on</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoPlacement}
     * will return {@link AutoPlacement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #autoPlacementAsString}.
     * </p>
     * 
     * @return Indicates whether the host accepts any untargeted instance launches that match its instance type
     *         configuration, or if it only accepts Host tenancy instance launches that specify its unique host ID. For
     *         more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/how-dedicated-hosts-work.html#dedicated-hosts-understanding"
     *         > Understanding auto-placement and affinity</a> in the <i>Amazon EC2 User Guide</i>.</p>
     *         <p>
     *         Default: <code>on</code>
     * @see AutoPlacement
     */
    public final String autoPlacementAsString() {
        return autoPlacement;
    }

    /**
     * <p>
     * The Availability Zone in which to allocate the Dedicated Host.
     * </p>
     * 
     * @return The Availability Zone in which to allocate the Dedicated Host.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         Idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Specifies the instance type to be supported by the Dedicated Hosts. If you specify an instance type, the
     * Dedicated Hosts support instances of the specified instance type only.
     * </p>
     * <p>
     * If you want the Dedicated Hosts to support multiple instance types in a specific instance family, omit this
     * parameter and specify <b>InstanceFamily</b> instead. You cannot specify <b>InstanceType</b> and
     * <b>InstanceFamily</b> in the same request.
     * </p>
     * 
     * @return Specifies the instance type to be supported by the Dedicated Hosts. If you specify an instance type, the
     *         Dedicated Hosts support instances of the specified instance type only.</p>
     *         <p>
     *         If you want the Dedicated Hosts to support multiple instance types in a specific instance family, omit
     *         this parameter and specify <b>InstanceFamily</b> instead. You cannot specify <b>InstanceType</b> and
     *         <b>InstanceFamily</b> in the same request.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * Specifies the instance family to be supported by the Dedicated Hosts. If you specify an instance family, the
     * Dedicated Hosts support multiple instance types within that instance family.
     * </p>
     * <p>
     * If you want the Dedicated Hosts to support a specific instance type only, omit this parameter and specify
     * <b>InstanceType</b> instead. You cannot specify <b>InstanceFamily</b> and <b>InstanceType</b> in the same
     * request.
     * </p>
     * 
     * @return Specifies the instance family to be supported by the Dedicated Hosts. If you specify an instance family,
     *         the Dedicated Hosts support multiple instance types within that instance family.</p>
     *         <p>
     *         If you want the Dedicated Hosts to support a specific instance type only, omit this parameter and specify
     *         <b>InstanceType</b> instead. You cannot specify <b>InstanceFamily</b> and <b>InstanceType</b> in the same
     *         request.
     */
    public final String instanceFamily() {
        return instanceFamily;
    }

    /**
     * <p>
     * The number of Dedicated Hosts to allocate to your account with these parameters. If you are allocating the
     * Dedicated Hosts on an Outpost, and you specify <b>AssetIds</b>, you can omit this parameter. In this case, Amazon
     * EC2 allocates a Dedicated Host on each specified hardware asset. If you specify both <b>AssetIds</b> and
     * <b>Quantity</b>, then the value that you specify for <b>Quantity</b> must be equal to the number of asset IDs
     * specified.
     * </p>
     * 
     * @return The number of Dedicated Hosts to allocate to your account with these parameters. If you are allocating
     *         the Dedicated Hosts on an Outpost, and you specify <b>AssetIds</b>, you can omit this parameter. In this
     *         case, Amazon EC2 allocates a Dedicated Host on each specified hardware asset. If you specify both
     *         <b>AssetIds</b> and <b>Quantity</b>, then the value that you specify for <b>Quantity</b> must be equal to
     *         the number of asset IDs specified.
     */
    public final Integer quantity() {
        return quantity;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagSpecifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to apply to the Dedicated Host during creation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagSpecifications} method.
     * </p>
     * 
     * @return The tags to apply to the Dedicated Host during creation.
     */
    public final List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    /**
     * <p>
     * Indicates whether to enable or disable host recovery for the Dedicated Host. Host recovery is disabled by
     * default. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html"> Host recovery</a> in
     * the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * Default: <code>off</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hostRecovery} will
     * return {@link HostRecovery#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hostRecoveryAsString}.
     * </p>
     * 
     * @return Indicates whether to enable or disable host recovery for the Dedicated Host. Host recovery is disabled by
     *         default. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html"> Host
     *         recovery</a> in the <i>Amazon EC2 User Guide</i>.</p>
     *         <p>
     *         Default: <code>off</code>
     * @see HostRecovery
     */
    public final HostRecovery hostRecovery() {
        return HostRecovery.fromValue(hostRecovery);
    }

    /**
     * <p>
     * Indicates whether to enable or disable host recovery for the Dedicated Host. Host recovery is disabled by
     * default. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html"> Host recovery</a> in
     * the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * Default: <code>off</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hostRecovery} will
     * return {@link HostRecovery#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hostRecoveryAsString}.
     * </p>
     * 
     * @return Indicates whether to enable or disable host recovery for the Dedicated Host. Host recovery is disabled by
     *         default. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html"> Host
     *         recovery</a> in the <i>Amazon EC2 User Guide</i>.</p>
     *         <p>
     *         Default: <code>off</code>
     * @see HostRecovery
     */
    public final String hostRecoveryAsString() {
        return hostRecovery;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Web Services Outpost on which to allocate the Dedicated Host. If you
     * specify <b>OutpostArn</b>, you can optionally specify <b>AssetIds</b>.
     * </p>
     * <p>
     * If you are allocating the Dedicated Host in a Region, omit this parameter.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Web Services Outpost on which to allocate the Dedicated
     *         Host. If you specify <b>OutpostArn</b>, you can optionally specify <b>AssetIds</b>.</p>
     *         <p>
     *         If you are allocating the Dedicated Host in a Region, omit this parameter.
     */
    public final String outpostArn() {
        return outpostArn;
    }

    /**
     * <p>
     * Indicates whether to enable or disable host maintenance for the Dedicated Host. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-maintenance.html">Host maintenance</a>
     * in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hostMaintenance}
     * will return {@link HostMaintenance#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #hostMaintenanceAsString}.
     * </p>
     * 
     * @return Indicates whether to enable or disable host maintenance for the Dedicated Host. For more information, see
     *         <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-maintenance.html">Host
     *         maintenance</a> in the <i>Amazon EC2 User Guide</i>.
     * @see HostMaintenance
     */
    public final HostMaintenance hostMaintenance() {
        return HostMaintenance.fromValue(hostMaintenance);
    }

    /**
     * <p>
     * Indicates whether to enable or disable host maintenance for the Dedicated Host. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-maintenance.html">Host maintenance</a>
     * in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hostMaintenance}
     * will return {@link HostMaintenance#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #hostMaintenanceAsString}.
     * </p>
     * 
     * @return Indicates whether to enable or disable host maintenance for the Dedicated Host. For more information, see
     *         <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-maintenance.html">Host
     *         maintenance</a> in the <i>Amazon EC2 User Guide</i>.
     * @see HostMaintenance
     */
    public final String hostMaintenanceAsString() {
        return hostMaintenance;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAssetIds() {
        return assetIds != null && !(assetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the Outpost hardware assets on which to allocate the Dedicated Hosts. Targeting specific hardware
     * assets on an Outpost can help to minimize latency between your workloads. This parameter is supported only if you
     * specify <b>OutpostArn</b>. If you are allocating the Dedicated Hosts in a Region, omit this parameter.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you specify this parameter, you can omit <b>Quantity</b>. In this case, Amazon EC2 allocates a Dedicated Host
     * on each specified hardware asset.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify both <b>AssetIds</b> and <b>Quantity</b>, then the value for <b>Quantity</b> must be equal to the
     * number of asset IDs specified.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssetIds} method.
     * </p>
     * 
     * @return The IDs of the Outpost hardware assets on which to allocate the Dedicated Hosts. Targeting specific
     *         hardware assets on an Outpost can help to minimize latency between your workloads. This parameter is
     *         supported only if you specify <b>OutpostArn</b>. If you are allocating the Dedicated Hosts in a Region,
     *         omit this parameter.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you specify this parameter, you can omit <b>Quantity</b>. In this case, Amazon EC2 allocates a
     *         Dedicated Host on each specified hardware asset.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you specify both <b>AssetIds</b> and <b>Quantity</b>, then the value for <b>Quantity</b> must be equal
     *         to the number of asset IDs specified.
     *         </p>
     *         </li>
     */
    public final List<String> assetIds() {
        return assetIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoPlacementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(instanceFamily());
        hashCode = 31 * hashCode + Objects.hashCode(quantity());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hostRecoveryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(outpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(hostMaintenanceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssetIds() ? assetIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllocateHostsRequest)) {
            return false;
        }
        AllocateHostsRequest other = (AllocateHostsRequest) obj;
        return Objects.equals(autoPlacementAsString(), other.autoPlacementAsString())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(instanceFamily(), other.instanceFamily()) && Objects.equals(quantity(), other.quantity())
                && hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications())
                && Objects.equals(hostRecoveryAsString(), other.hostRecoveryAsString())
                && Objects.equals(outpostArn(), other.outpostArn())
                && Objects.equals(hostMaintenanceAsString(), other.hostMaintenanceAsString())
                && hasAssetIds() == other.hasAssetIds() && Objects.equals(assetIds(), other.assetIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AllocateHostsRequest").add("AutoPlacement", autoPlacementAsString())
                .add("AvailabilityZone", availabilityZone()).add("ClientToken", clientToken())
                .add("InstanceType", instanceType()).add("InstanceFamily", instanceFamily()).add("Quantity", quantity())
                .add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null)
                .add("HostRecovery", hostRecoveryAsString()).add("OutpostArn", outpostArn())
                .add("HostMaintenance", hostMaintenanceAsString()).add("AssetIds", hasAssetIds() ? assetIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoPlacement":
            return Optional.ofNullable(clazz.cast(autoPlacementAsString()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "InstanceFamily":
            return Optional.ofNullable(clazz.cast(instanceFamily()));
        case "Quantity":
            return Optional.ofNullable(clazz.cast(quantity()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        case "HostRecovery":
            return Optional.ofNullable(clazz.cast(hostRecoveryAsString()));
        case "OutpostArn":
            return Optional.ofNullable(clazz.cast(outpostArn()));
        case "HostMaintenance":
            return Optional.ofNullable(clazz.cast(hostMaintenanceAsString()));
        case "AssetIds":
            return Optional.ofNullable(clazz.cast(assetIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AllocateHostsRequest, T> g) {
        return obj -> g.apply((AllocateHostsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, AllocateHostsRequest> {
        /**
         * <p>
         * Indicates whether the host accepts any untargeted instance launches that match its instance type
         * configuration, or if it only accepts Host tenancy instance launches that specify its unique host ID. For more
         * information, see <a href=
         * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/how-dedicated-hosts-work.html#dedicated-hosts-understanding"
         * > Understanding auto-placement and affinity</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * <p>
         * Default: <code>on</code>
         * </p>
         * 
         * @param autoPlacement
         *        Indicates whether the host accepts any untargeted instance launches that match its instance type
         *        configuration, or if it only accepts Host tenancy instance launches that specify its unique host ID.
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/how-dedicated-hosts-work.html#dedicated-hosts-understanding"
         *        > Understanding auto-placement and affinity</a> in the <i>Amazon EC2 User Guide</i>.</p>
         *        <p>
         *        Default: <code>on</code>
         * @see AutoPlacement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoPlacement
         */
        Builder autoPlacement(String autoPlacement);

        /**
         * <p>
         * Indicates whether the host accepts any untargeted instance launches that match its instance type
         * configuration, or if it only accepts Host tenancy instance launches that specify its unique host ID. For more
         * information, see <a href=
         * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/how-dedicated-hosts-work.html#dedicated-hosts-understanding"
         * > Understanding auto-placement and affinity</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * <p>
         * Default: <code>on</code>
         * </p>
         * 
         * @param autoPlacement
         *        Indicates whether the host accepts any untargeted instance launches that match its instance type
         *        configuration, or if it only accepts Host tenancy instance launches that specify its unique host ID.
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/how-dedicated-hosts-work.html#dedicated-hosts-understanding"
         *        > Understanding auto-placement and affinity</a> in the <i>Amazon EC2 User Guide</i>.</p>
         *        <p>
         *        Default: <code>on</code>
         * @see AutoPlacement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoPlacement
         */
        Builder autoPlacement(AutoPlacement autoPlacement);

        /**
         * <p>
         * The Availability Zone in which to allocate the Dedicated Host.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone in which to allocate the Dedicated Host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Specifies the instance type to be supported by the Dedicated Hosts. If you specify an instance type, the
         * Dedicated Hosts support instances of the specified instance type only.
         * </p>
         * <p>
         * If you want the Dedicated Hosts to support multiple instance types in a specific instance family, omit this
         * parameter and specify <b>InstanceFamily</b> instead. You cannot specify <b>InstanceType</b> and
         * <b>InstanceFamily</b> in the same request.
         * </p>
         * 
         * @param instanceType
         *        Specifies the instance type to be supported by the Dedicated Hosts. If you specify an instance type,
         *        the Dedicated Hosts support instances of the specified instance type only.</p>
         *        <p>
         *        If you want the Dedicated Hosts to support multiple instance types in a specific instance family, omit
         *        this parameter and specify <b>InstanceFamily</b> instead. You cannot specify <b>InstanceType</b> and
         *        <b>InstanceFamily</b> in the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * Specifies the instance family to be supported by the Dedicated Hosts. If you specify an instance family, the
         * Dedicated Hosts support multiple instance types within that instance family.
         * </p>
         * <p>
         * If you want the Dedicated Hosts to support a specific instance type only, omit this parameter and specify
         * <b>InstanceType</b> instead. You cannot specify <b>InstanceFamily</b> and <b>InstanceType</b> in the same
         * request.
         * </p>
         * 
         * @param instanceFamily
         *        Specifies the instance family to be supported by the Dedicated Hosts. If you specify an instance
         *        family, the Dedicated Hosts support multiple instance types within that instance family.</p>
         *        <p>
         *        If you want the Dedicated Hosts to support a specific instance type only, omit this parameter and
         *        specify <b>InstanceType</b> instead. You cannot specify <b>InstanceFamily</b> and <b>InstanceType</b>
         *        in the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceFamily(String instanceFamily);

        /**
         * <p>
         * The number of Dedicated Hosts to allocate to your account with these parameters. If you are allocating the
         * Dedicated Hosts on an Outpost, and you specify <b>AssetIds</b>, you can omit this parameter. In this case,
         * Amazon EC2 allocates a Dedicated Host on each specified hardware asset. If you specify both <b>AssetIds</b>
         * and <b>Quantity</b>, then the value that you specify for <b>Quantity</b> must be equal to the number of asset
         * IDs specified.
         * </p>
         * 
         * @param quantity
         *        The number of Dedicated Hosts to allocate to your account with these parameters. If you are allocating
         *        the Dedicated Hosts on an Outpost, and you specify <b>AssetIds</b>, you can omit this parameter. In
         *        this case, Amazon EC2 allocates a Dedicated Host on each specified hardware asset. If you specify both
         *        <b>AssetIds</b> and <b>Quantity</b>, then the value that you specify for <b>Quantity</b> must be equal
         *        to the number of asset IDs specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Integer quantity);

        /**
         * <p>
         * The tags to apply to the Dedicated Host during creation.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the Dedicated Host during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to apply to the Dedicated Host during creation.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the Dedicated Host during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to apply to the Dedicated Host during creation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.TagSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(java.util.Collection<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        /**
         * <p>
         * Indicates whether to enable or disable host recovery for the Dedicated Host. Host recovery is disabled by
         * default. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html"> Host recovery</a>
         * in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * <p>
         * Default: <code>off</code>
         * </p>
         * 
         * @param hostRecovery
         *        Indicates whether to enable or disable host recovery for the Dedicated Host. Host recovery is disabled
         *        by default. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html"> Host
         *        recovery</a> in the <i>Amazon EC2 User Guide</i>.</p>
         *        <p>
         *        Default: <code>off</code>
         * @see HostRecovery
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HostRecovery
         */
        Builder hostRecovery(String hostRecovery);

        /**
         * <p>
         * Indicates whether to enable or disable host recovery for the Dedicated Host. Host recovery is disabled by
         * default. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html"> Host recovery</a>
         * in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * <p>
         * Default: <code>off</code>
         * </p>
         * 
         * @param hostRecovery
         *        Indicates whether to enable or disable host recovery for the Dedicated Host. Host recovery is disabled
         *        by default. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html"> Host
         *        recovery</a> in the <i>Amazon EC2 User Guide</i>.</p>
         *        <p>
         *        Default: <code>off</code>
         * @see HostRecovery
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HostRecovery
         */
        Builder hostRecovery(HostRecovery hostRecovery);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Web Services Outpost on which to allocate the Dedicated Host. If
         * you specify <b>OutpostArn</b>, you can optionally specify <b>AssetIds</b>.
         * </p>
         * <p>
         * If you are allocating the Dedicated Host in a Region, omit this parameter.
         * </p>
         * 
         * @param outpostArn
         *        The Amazon Resource Name (ARN) of the Amazon Web Services Outpost on which to allocate the Dedicated
         *        Host. If you specify <b>OutpostArn</b>, you can optionally specify <b>AssetIds</b>.</p>
         *        <p>
         *        If you are allocating the Dedicated Host in a Region, omit this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostArn(String outpostArn);

        /**
         * <p>
         * Indicates whether to enable or disable host maintenance for the Dedicated Host. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-maintenance.html">Host
         * maintenance</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param hostMaintenance
         *        Indicates whether to enable or disable host maintenance for the Dedicated Host. For more information,
         *        see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-maintenance.html">Host
         *        maintenance</a> in the <i>Amazon EC2 User Guide</i>.
         * @see HostMaintenance
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HostMaintenance
         */
        Builder hostMaintenance(String hostMaintenance);

        /**
         * <p>
         * Indicates whether to enable or disable host maintenance for the Dedicated Host. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-maintenance.html">Host
         * maintenance</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param hostMaintenance
         *        Indicates whether to enable or disable host maintenance for the Dedicated Host. For more information,
         *        see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-maintenance.html">Host
         *        maintenance</a> in the <i>Amazon EC2 User Guide</i>.
         * @see HostMaintenance
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HostMaintenance
         */
        Builder hostMaintenance(HostMaintenance hostMaintenance);

        /**
         * <p>
         * The IDs of the Outpost hardware assets on which to allocate the Dedicated Hosts. Targeting specific hardware
         * assets on an Outpost can help to minimize latency between your workloads. This parameter is supported only if
         * you specify <b>OutpostArn</b>. If you are allocating the Dedicated Hosts in a Region, omit this parameter.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you specify this parameter, you can omit <b>Quantity</b>. In this case, Amazon EC2 allocates a Dedicated
         * Host on each specified hardware asset.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify both <b>AssetIds</b> and <b>Quantity</b>, then the value for <b>Quantity</b> must be equal to
         * the number of asset IDs specified.
         * </p>
         * </li>
         * </ul>
         * 
         * @param assetIds
         *        The IDs of the Outpost hardware assets on which to allocate the Dedicated Hosts. Targeting specific
         *        hardware assets on an Outpost can help to minimize latency between your workloads. This parameter is
         *        supported only if you specify <b>OutpostArn</b>. If you are allocating the Dedicated Hosts in a
         *        Region, omit this parameter.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you specify this parameter, you can omit <b>Quantity</b>. In this case, Amazon EC2 allocates a
         *        Dedicated Host on each specified hardware asset.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify both <b>AssetIds</b> and <b>Quantity</b>, then the value for <b>Quantity</b> must be
         *        equal to the number of asset IDs specified.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetIds(Collection<String> assetIds);

        /**
         * <p>
         * The IDs of the Outpost hardware assets on which to allocate the Dedicated Hosts. Targeting specific hardware
         * assets on an Outpost can help to minimize latency between your workloads. This parameter is supported only if
         * you specify <b>OutpostArn</b>. If you are allocating the Dedicated Hosts in a Region, omit this parameter.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you specify this parameter, you can omit <b>Quantity</b>. In this case, Amazon EC2 allocates a Dedicated
         * Host on each specified hardware asset.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify both <b>AssetIds</b> and <b>Quantity</b>, then the value for <b>Quantity</b> must be equal to
         * the number of asset IDs specified.
         * </p>
         * </li>
         * </ul>
         * 
         * @param assetIds
         *        The IDs of the Outpost hardware assets on which to allocate the Dedicated Hosts. Targeting specific
         *        hardware assets on an Outpost can help to minimize latency between your workloads. This parameter is
         *        supported only if you specify <b>OutpostArn</b>. If you are allocating the Dedicated Hosts in a
         *        Region, omit this parameter.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you specify this parameter, you can omit <b>Quantity</b>. In this case, Amazon EC2 allocates a
         *        Dedicated Host on each specified hardware asset.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify both <b>AssetIds</b> and <b>Quantity</b>, then the value for <b>Quantity</b> must be
         *        equal to the number of asset IDs specified.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetIds(String... assetIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String autoPlacement;

        private String availabilityZone;

        private String clientToken;

        private String instanceType;

        private String instanceFamily;

        private Integer quantity;

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private String hostRecovery;

        private String outpostArn;

        private String hostMaintenance;

        private List<String> assetIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AllocateHostsRequest model) {
            super(model);
            autoPlacement(model.autoPlacement);
            availabilityZone(model.availabilityZone);
            clientToken(model.clientToken);
            instanceType(model.instanceType);
            instanceFamily(model.instanceFamily);
            quantity(model.quantity);
            tagSpecifications(model.tagSpecifications);
            hostRecovery(model.hostRecovery);
            outpostArn(model.outpostArn);
            hostMaintenance(model.hostMaintenance);
            assetIds(model.assetIds);
        }

        public final String getAutoPlacement() {
            return autoPlacement;
        }

        public final void setAutoPlacement(String autoPlacement) {
            this.autoPlacement = autoPlacement;
        }

        @Override
        public final Builder autoPlacement(String autoPlacement) {
            this.autoPlacement = autoPlacement;
            return this;
        }

        @Override
        public final Builder autoPlacement(AutoPlacement autoPlacement) {
            this.autoPlacement(autoPlacement == null ? null : autoPlacement.toString());
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getInstanceFamily() {
            return instanceFamily;
        }

        public final void setInstanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
        }

        @Override
        public final Builder instanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
            return this;
        }

        public final Integer getQuantity() {
            return quantity;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getHostRecovery() {
            return hostRecovery;
        }

        public final void setHostRecovery(String hostRecovery) {
            this.hostRecovery = hostRecovery;
        }

        @Override
        public final Builder hostRecovery(String hostRecovery) {
            this.hostRecovery = hostRecovery;
            return this;
        }

        @Override
        public final Builder hostRecovery(HostRecovery hostRecovery) {
            this.hostRecovery(hostRecovery == null ? null : hostRecovery.toString());
            return this;
        }

        public final String getOutpostArn() {
            return outpostArn;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final String getHostMaintenance() {
            return hostMaintenance;
        }

        public final void setHostMaintenance(String hostMaintenance) {
            this.hostMaintenance = hostMaintenance;
        }

        @Override
        public final Builder hostMaintenance(String hostMaintenance) {
            this.hostMaintenance = hostMaintenance;
            return this;
        }

        @Override
        public final Builder hostMaintenance(HostMaintenance hostMaintenance) {
            this.hostMaintenance(hostMaintenance == null ? null : hostMaintenance.toString());
            return this;
        }

        public final Collection<String> getAssetIds() {
            if (assetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return assetIds;
        }

        public final void setAssetIds(Collection<String> assetIds) {
            this.assetIds = AssetIdListCopier.copy(assetIds);
        }

        @Override
        public final Builder assetIds(Collection<String> assetIds) {
            this.assetIds = AssetIdListCopier.copy(assetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetIds(String... assetIds) {
            assetIds(Arrays.asList(assetIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AllocateHostsRequest build() {
            return new AllocateHostsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
