/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyIpamPoolRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyIpamPoolRequest.Builder, ModifyIpamPoolRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(ModifyIpamPoolRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<String> IPAM_POOL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpamPoolId")
            .getter(getter(ModifyIpamPoolRequest::ipamPoolId))
            .setter(setter(Builder::ipamPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPoolId")
                    .unmarshallLocationName("IpamPoolId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(ModifyIpamPoolRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<Boolean> AUTO_IMPORT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoImport")
            .getter(getter(ModifyIpamPoolRequest::autoImport))
            .setter(setter(Builder::autoImport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoImport")
                    .unmarshallLocationName("AutoImport").build()).build();

    private static final SdkField<Integer> ALLOCATION_MIN_NETMASK_LENGTH_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("AllocationMinNetmaskLength")
            .getter(getter(ModifyIpamPoolRequest::allocationMinNetmaskLength))
            .setter(setter(Builder::allocationMinNetmaskLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationMinNetmaskLength")
                    .unmarshallLocationName("AllocationMinNetmaskLength").build()).build();

    private static final SdkField<Integer> ALLOCATION_MAX_NETMASK_LENGTH_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("AllocationMaxNetmaskLength")
            .getter(getter(ModifyIpamPoolRequest::allocationMaxNetmaskLength))
            .setter(setter(Builder::allocationMaxNetmaskLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationMaxNetmaskLength")
                    .unmarshallLocationName("AllocationMaxNetmaskLength").build()).build();

    private static final SdkField<Integer> ALLOCATION_DEFAULT_NETMASK_LENGTH_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("AllocationDefaultNetmaskLength")
            .getter(getter(ModifyIpamPoolRequest::allocationDefaultNetmaskLength))
            .setter(setter(Builder::allocationDefaultNetmaskLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationDefaultNetmaskLength")
                    .unmarshallLocationName("AllocationDefaultNetmaskLength").build()).build();

    private static final SdkField<Boolean> CLEAR_ALLOCATION_DEFAULT_NETMASK_LENGTH_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ClearAllocationDefaultNetmaskLength")
            .getter(getter(ModifyIpamPoolRequest::clearAllocationDefaultNetmaskLength))
            .setter(setter(Builder::clearAllocationDefaultNetmaskLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ClearAllocationDefaultNetmaskLength")
                    .unmarshallLocationName("ClearAllocationDefaultNetmaskLength").build()).build();

    private static final SdkField<List<RequestIpamResourceTag>> ADD_ALLOCATION_RESOURCE_TAGS_FIELD = SdkField
            .<List<RequestIpamResourceTag>> builder(MarshallingType.LIST)
            .memberName("AddAllocationResourceTags")
            .getter(getter(ModifyIpamPoolRequest::addAllocationResourceTags))
            .setter(setter(Builder::addAllocationResourceTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddAllocationResourceTag")
                    .unmarshallLocationName("AddAllocationResourceTag").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<RequestIpamResourceTag> builder(MarshallingType.SDK_POJO)
                                            .constructor(RequestIpamResourceTag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<RequestIpamResourceTag>> REMOVE_ALLOCATION_RESOURCE_TAGS_FIELD = SdkField
            .<List<RequestIpamResourceTag>> builder(MarshallingType.LIST)
            .memberName("RemoveAllocationResourceTags")
            .getter(getter(ModifyIpamPoolRequest::removeAllocationResourceTags))
            .setter(setter(Builder::removeAllocationResourceTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveAllocationResourceTag")
                    .unmarshallLocationName("RemoveAllocationResourceTag").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<RequestIpamResourceTag> builder(MarshallingType.SDK_POJO)
                                            .constructor(RequestIpamResourceTag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD,
            IPAM_POOL_ID_FIELD, DESCRIPTION_FIELD, AUTO_IMPORT_FIELD, ALLOCATION_MIN_NETMASK_LENGTH_FIELD,
            ALLOCATION_MAX_NETMASK_LENGTH_FIELD, ALLOCATION_DEFAULT_NETMASK_LENGTH_FIELD,
            CLEAR_ALLOCATION_DEFAULT_NETMASK_LENGTH_FIELD, ADD_ALLOCATION_RESOURCE_TAGS_FIELD,
            REMOVE_ALLOCATION_RESOURCE_TAGS_FIELD));

    private final Boolean dryRun;

    private final String ipamPoolId;

    private final String description;

    private final Boolean autoImport;

    private final Integer allocationMinNetmaskLength;

    private final Integer allocationMaxNetmaskLength;

    private final Integer allocationDefaultNetmaskLength;

    private final Boolean clearAllocationDefaultNetmaskLength;

    private final List<RequestIpamResourceTag> addAllocationResourceTags;

    private final List<RequestIpamResourceTag> removeAllocationResourceTags;

    private ModifyIpamPoolRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.ipamPoolId = builder.ipamPoolId;
        this.description = builder.description;
        this.autoImport = builder.autoImport;
        this.allocationMinNetmaskLength = builder.allocationMinNetmaskLength;
        this.allocationMaxNetmaskLength = builder.allocationMaxNetmaskLength;
        this.allocationDefaultNetmaskLength = builder.allocationDefaultNetmaskLength;
        this.clearAllocationDefaultNetmaskLength = builder.clearAllocationDefaultNetmaskLength;
        this.addAllocationResourceTags = builder.addAllocationResourceTags;
        this.removeAllocationResourceTags = builder.removeAllocationResourceTags;
    }

    /**
     * <p>
     * A check for whether you have the required permissions for the action without actually making the request and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return A check for whether you have the required permissions for the action without actually making the request
     *         and provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The ID of the IPAM pool you want to modify.
     * </p>
     * 
     * @return The ID of the IPAM pool you want to modify.
     */
    public final String ipamPoolId() {
        return ipamPoolId;
    }

    /**
     * <p>
     * The description of the IPAM pool you want to modify.
     * </p>
     * 
     * @return The description of the IPAM pool you want to modify.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * If true, IPAM will continuously look for resources within the CIDR range of this pool and automatically import
     * them as allocations into your IPAM. The CIDRs that will be allocated for these resources must not already be
     * allocated to other resources in order for the import to succeed. IPAM will import a CIDR regardless of its
     * compliance with the pool's allocation rules, so a resource might be imported and subsequently marked as
     * noncompliant. If IPAM discovers multiple CIDRs that overlap, IPAM will import the largest CIDR only. If IPAM
     * discovers multiple CIDRs with matching CIDRs, IPAM will randomly import one of them only.
     * </p>
     * <p>
     * A locale must be set on the pool for this feature to work.
     * </p>
     * 
     * @return If true, IPAM will continuously look for resources within the CIDR range of this pool and automatically
     *         import them as allocations into your IPAM. The CIDRs that will be allocated for these resources must not
     *         already be allocated to other resources in order for the import to succeed. IPAM will import a CIDR
     *         regardless of its compliance with the pool's allocation rules, so a resource might be imported and
     *         subsequently marked as noncompliant. If IPAM discovers multiple CIDRs that overlap, IPAM will import the
     *         largest CIDR only. If IPAM discovers multiple CIDRs with matching CIDRs, IPAM will randomly import one of
     *         them only. </p>
     *         <p>
     *         A locale must be set on the pool for this feature to work.
     */
    public final Boolean autoImport() {
        return autoImport;
    }

    /**
     * <p>
     * The minimum netmask length required for CIDR allocations in this IPAM pool to be compliant. Possible netmask
     * lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128. The minimum
     * netmask length must be less than the maximum netmask length.
     * </p>
     * 
     * @return The minimum netmask length required for CIDR allocations in this IPAM pool to be compliant. Possible
     *         netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128.
     *         The minimum netmask length must be less than the maximum netmask length.
     */
    public final Integer allocationMinNetmaskLength() {
        return allocationMinNetmaskLength;
    }

    /**
     * <p>
     * The maximum netmask length possible for CIDR allocations in this IPAM pool to be compliant. Possible netmask
     * lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128.The maximum
     * netmask length must be greater than the minimum netmask length.
     * </p>
     * 
     * @return The maximum netmask length possible for CIDR allocations in this IPAM pool to be compliant. Possible
     *         netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 -
     *         128.The maximum netmask length must be greater than the minimum netmask length.
     */
    public final Integer allocationMaxNetmaskLength() {
        return allocationMaxNetmaskLength;
    }

    /**
     * <p>
     * The default netmask length for allocations added to this pool. If, for example, the CIDR assigned to this pool is
     * 10.0.0.0/8 and you enter 16 here, new allocations will default to 10.0.0.0/16.
     * </p>
     * 
     * @return The default netmask length for allocations added to this pool. If, for example, the CIDR assigned to this
     *         pool is 10.0.0.0/8 and you enter 16 here, new allocations will default to 10.0.0.0/16.
     */
    public final Integer allocationDefaultNetmaskLength() {
        return allocationDefaultNetmaskLength;
    }

    /**
     * <p>
     * Clear the default netmask length allocation rule for this pool.
     * </p>
     * 
     * @return Clear the default netmask length allocation rule for this pool.
     */
    public final Boolean clearAllocationDefaultNetmaskLength() {
        return clearAllocationDefaultNetmaskLength;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddAllocationResourceTags property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAddAllocationResourceTags() {
        return addAllocationResourceTags != null && !(addAllocationResourceTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Add tag allocation rules to a pool. For more information about allocation rules, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/ipam/create-top-ipam.html">Create a top-level pool</a> in the
     * <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddAllocationResourceTags} method.
     * </p>
     * 
     * @return Add tag allocation rules to a pool. For more information about allocation rules, see <a
     *         href="https://docs.aws.amazon.com/vpc/latest/ipam/create-top-ipam.html">Create a top-level pool</a> in
     *         the <i>Amazon VPC IPAM User Guide</i>.
     */
    public final List<RequestIpamResourceTag> addAllocationResourceTags() {
        return addAllocationResourceTags;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoveAllocationResourceTags property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRemoveAllocationResourceTags() {
        return removeAllocationResourceTags != null && !(removeAllocationResourceTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Remove tag allocation rules from a pool.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveAllocationResourceTags} method.
     * </p>
     * 
     * @return Remove tag allocation rules from a pool.
     */
    public final List<RequestIpamResourceTag> removeAllocationResourceTags() {
        return removeAllocationResourceTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(ipamPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(autoImport());
        hashCode = 31 * hashCode + Objects.hashCode(allocationMinNetmaskLength());
        hashCode = 31 * hashCode + Objects.hashCode(allocationMaxNetmaskLength());
        hashCode = 31 * hashCode + Objects.hashCode(allocationDefaultNetmaskLength());
        hashCode = 31 * hashCode + Objects.hashCode(clearAllocationDefaultNetmaskLength());
        hashCode = 31 * hashCode + Objects.hashCode(hasAddAllocationResourceTags() ? addAllocationResourceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoveAllocationResourceTags() ? removeAllocationResourceTags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyIpamPoolRequest)) {
            return false;
        }
        ModifyIpamPoolRequest other = (ModifyIpamPoolRequest) obj;
        return Objects.equals(dryRun(), other.dryRun()) && Objects.equals(ipamPoolId(), other.ipamPoolId())
                && Objects.equals(description(), other.description()) && Objects.equals(autoImport(), other.autoImport())
                && Objects.equals(allocationMinNetmaskLength(), other.allocationMinNetmaskLength())
                && Objects.equals(allocationMaxNetmaskLength(), other.allocationMaxNetmaskLength())
                && Objects.equals(allocationDefaultNetmaskLength(), other.allocationDefaultNetmaskLength())
                && Objects.equals(clearAllocationDefaultNetmaskLength(), other.clearAllocationDefaultNetmaskLength())
                && hasAddAllocationResourceTags() == other.hasAddAllocationResourceTags()
                && Objects.equals(addAllocationResourceTags(), other.addAllocationResourceTags())
                && hasRemoveAllocationResourceTags() == other.hasRemoveAllocationResourceTags()
                && Objects.equals(removeAllocationResourceTags(), other.removeAllocationResourceTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyIpamPoolRequest").add("DryRun", dryRun()).add("IpamPoolId", ipamPoolId())
                .add("Description", description()).add("AutoImport", autoImport())
                .add("AllocationMinNetmaskLength", allocationMinNetmaskLength())
                .add("AllocationMaxNetmaskLength", allocationMaxNetmaskLength())
                .add("AllocationDefaultNetmaskLength", allocationDefaultNetmaskLength())
                .add("ClearAllocationDefaultNetmaskLength", clearAllocationDefaultNetmaskLength())
                .add("AddAllocationResourceTags", hasAddAllocationResourceTags() ? addAllocationResourceTags() : null)
                .add("RemoveAllocationResourceTags", hasRemoveAllocationResourceTags() ? removeAllocationResourceTags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "IpamPoolId":
            return Optional.ofNullable(clazz.cast(ipamPoolId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "AutoImport":
            return Optional.ofNullable(clazz.cast(autoImport()));
        case "AllocationMinNetmaskLength":
            return Optional.ofNullable(clazz.cast(allocationMinNetmaskLength()));
        case "AllocationMaxNetmaskLength":
            return Optional.ofNullable(clazz.cast(allocationMaxNetmaskLength()));
        case "AllocationDefaultNetmaskLength":
            return Optional.ofNullable(clazz.cast(allocationDefaultNetmaskLength()));
        case "ClearAllocationDefaultNetmaskLength":
            return Optional.ofNullable(clazz.cast(clearAllocationDefaultNetmaskLength()));
        case "AddAllocationResourceTags":
            return Optional.ofNullable(clazz.cast(addAllocationResourceTags()));
        case "RemoveAllocationResourceTags":
            return Optional.ofNullable(clazz.cast(removeAllocationResourceTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyIpamPoolRequest, T> g) {
        return obj -> g.apply((ModifyIpamPoolRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyIpamPoolRequest> {
        /**
         * <p>
         * A check for whether you have the required permissions for the action without actually making the request and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        A check for whether you have the required permissions for the action without actually making the
         *        request and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The ID of the IPAM pool you want to modify.
         * </p>
         * 
         * @param ipamPoolId
         *        The ID of the IPAM pool you want to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamPoolId(String ipamPoolId);

        /**
         * <p>
         * The description of the IPAM pool you want to modify.
         * </p>
         * 
         * @param description
         *        The description of the IPAM pool you want to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * If true, IPAM will continuously look for resources within the CIDR range of this pool and automatically
         * import them as allocations into your IPAM. The CIDRs that will be allocated for these resources must not
         * already be allocated to other resources in order for the import to succeed. IPAM will import a CIDR
         * regardless of its compliance with the pool's allocation rules, so a resource might be imported and
         * subsequently marked as noncompliant. If IPAM discovers multiple CIDRs that overlap, IPAM will import the
         * largest CIDR only. If IPAM discovers multiple CIDRs with matching CIDRs, IPAM will randomly import one of
         * them only.
         * </p>
         * <p>
         * A locale must be set on the pool for this feature to work.
         * </p>
         * 
         * @param autoImport
         *        If true, IPAM will continuously look for resources within the CIDR range of this pool and
         *        automatically import them as allocations into your IPAM. The CIDRs that will be allocated for these
         *        resources must not already be allocated to other resources in order for the import to succeed. IPAM
         *        will import a CIDR regardless of its compliance with the pool's allocation rules, so a resource might
         *        be imported and subsequently marked as noncompliant. If IPAM discovers multiple CIDRs that overlap,
         *        IPAM will import the largest CIDR only. If IPAM discovers multiple CIDRs with matching CIDRs, IPAM
         *        will randomly import one of them only. </p>
         *        <p>
         *        A locale must be set on the pool for this feature to work.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoImport(Boolean autoImport);

        /**
         * <p>
         * The minimum netmask length required for CIDR allocations in this IPAM pool to be compliant. Possible netmask
         * lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128. The minimum
         * netmask length must be less than the maximum netmask length.
         * </p>
         * 
         * @param allocationMinNetmaskLength
         *        The minimum netmask length required for CIDR allocations in this IPAM pool to be compliant. Possible
         *        netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 -
         *        128. The minimum netmask length must be less than the maximum netmask length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocationMinNetmaskLength(Integer allocationMinNetmaskLength);

        /**
         * <p>
         * The maximum netmask length possible for CIDR allocations in this IPAM pool to be compliant. Possible netmask
         * lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128.The maximum
         * netmask length must be greater than the minimum netmask length.
         * </p>
         * 
         * @param allocationMaxNetmaskLength
         *        The maximum netmask length possible for CIDR allocations in this IPAM pool to be compliant. Possible
         *        netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 -
         *        128.The maximum netmask length must be greater than the minimum netmask length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocationMaxNetmaskLength(Integer allocationMaxNetmaskLength);

        /**
         * <p>
         * The default netmask length for allocations added to this pool. If, for example, the CIDR assigned to this
         * pool is 10.0.0.0/8 and you enter 16 here, new allocations will default to 10.0.0.0/16.
         * </p>
         * 
         * @param allocationDefaultNetmaskLength
         *        The default netmask length for allocations added to this pool. If, for example, the CIDR assigned to
         *        this pool is 10.0.0.0/8 and you enter 16 here, new allocations will default to 10.0.0.0/16.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocationDefaultNetmaskLength(Integer allocationDefaultNetmaskLength);

        /**
         * <p>
         * Clear the default netmask length allocation rule for this pool.
         * </p>
         * 
         * @param clearAllocationDefaultNetmaskLength
         *        Clear the default netmask length allocation rule for this pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clearAllocationDefaultNetmaskLength(Boolean clearAllocationDefaultNetmaskLength);

        /**
         * <p>
         * Add tag allocation rules to a pool. For more information about allocation rules, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/ipam/create-top-ipam.html">Create a top-level pool</a> in the
         * <i>Amazon VPC IPAM User Guide</i>.
         * </p>
         * 
         * @param addAllocationResourceTags
         *        Add tag allocation rules to a pool. For more information about allocation rules, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/ipam/create-top-ipam.html">Create a top-level pool</a> in
         *        the <i>Amazon VPC IPAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addAllocationResourceTags(Collection<RequestIpamResourceTag> addAllocationResourceTags);

        /**
         * <p>
         * Add tag allocation rules to a pool. For more information about allocation rules, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/ipam/create-top-ipam.html">Create a top-level pool</a> in the
         * <i>Amazon VPC IPAM User Guide</i>.
         * </p>
         * 
         * @param addAllocationResourceTags
         *        Add tag allocation rules to a pool. For more information about allocation rules, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/ipam/create-top-ipam.html">Create a top-level pool</a> in
         *        the <i>Amazon VPC IPAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addAllocationResourceTags(RequestIpamResourceTag... addAllocationResourceTags);

        /**
         * <p>
         * Add tag allocation rules to a pool. For more information about allocation rules, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/ipam/create-top-ipam.html">Create a top-level pool</a> in the
         * <i>Amazon VPC IPAM User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.RequestIpamResourceTag.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ec2.model.RequestIpamResourceTag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.RequestIpamResourceTag.Builder#build()} is called
         * immediately and its result is passed to {@link #addAllocationResourceTags(List<RequestIpamResourceTag>)}.
         * 
         * @param addAllocationResourceTags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.RequestIpamResourceTag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addAllocationResourceTags(java.util.Collection<RequestIpamResourceTag>)
         */
        Builder addAllocationResourceTags(Consumer<RequestIpamResourceTag.Builder>... addAllocationResourceTags);

        /**
         * <p>
         * Remove tag allocation rules from a pool.
         * </p>
         * 
         * @param removeAllocationResourceTags
         *        Remove tag allocation rules from a pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeAllocationResourceTags(Collection<RequestIpamResourceTag> removeAllocationResourceTags);

        /**
         * <p>
         * Remove tag allocation rules from a pool.
         * </p>
         * 
         * @param removeAllocationResourceTags
         *        Remove tag allocation rules from a pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeAllocationResourceTags(RequestIpamResourceTag... removeAllocationResourceTags);

        /**
         * <p>
         * Remove tag allocation rules from a pool.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.RequestIpamResourceTag.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ec2.model.RequestIpamResourceTag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.RequestIpamResourceTag.Builder#build()} is called
         * immediately and its result is passed to {@link #removeAllocationResourceTags(List<RequestIpamResourceTag>)}.
         * 
         * @param removeAllocationResourceTags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.RequestIpamResourceTag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #removeAllocationResourceTags(java.util.Collection<RequestIpamResourceTag>)
         */
        Builder removeAllocationResourceTags(Consumer<RequestIpamResourceTag.Builder>... removeAllocationResourceTags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Boolean dryRun;

        private String ipamPoolId;

        private String description;

        private Boolean autoImport;

        private Integer allocationMinNetmaskLength;

        private Integer allocationMaxNetmaskLength;

        private Integer allocationDefaultNetmaskLength;

        private Boolean clearAllocationDefaultNetmaskLength;

        private List<RequestIpamResourceTag> addAllocationResourceTags = DefaultSdkAutoConstructList.getInstance();

        private List<RequestIpamResourceTag> removeAllocationResourceTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyIpamPoolRequest model) {
            super(model);
            dryRun(model.dryRun);
            ipamPoolId(model.ipamPoolId);
            description(model.description);
            autoImport(model.autoImport);
            allocationMinNetmaskLength(model.allocationMinNetmaskLength);
            allocationMaxNetmaskLength(model.allocationMaxNetmaskLength);
            allocationDefaultNetmaskLength(model.allocationDefaultNetmaskLength);
            clearAllocationDefaultNetmaskLength(model.clearAllocationDefaultNetmaskLength);
            addAllocationResourceTags(model.addAllocationResourceTags);
            removeAllocationResourceTags(model.removeAllocationResourceTags);
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getIpamPoolId() {
            return ipamPoolId;
        }

        public final void setIpamPoolId(String ipamPoolId) {
            this.ipamPoolId = ipamPoolId;
        }

        @Override
        public final Builder ipamPoolId(String ipamPoolId) {
            this.ipamPoolId = ipamPoolId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getAutoImport() {
            return autoImport;
        }

        public final void setAutoImport(Boolean autoImport) {
            this.autoImport = autoImport;
        }

        @Override
        public final Builder autoImport(Boolean autoImport) {
            this.autoImport = autoImport;
            return this;
        }

        public final Integer getAllocationMinNetmaskLength() {
            return allocationMinNetmaskLength;
        }

        public final void setAllocationMinNetmaskLength(Integer allocationMinNetmaskLength) {
            this.allocationMinNetmaskLength = allocationMinNetmaskLength;
        }

        @Override
        public final Builder allocationMinNetmaskLength(Integer allocationMinNetmaskLength) {
            this.allocationMinNetmaskLength = allocationMinNetmaskLength;
            return this;
        }

        public final Integer getAllocationMaxNetmaskLength() {
            return allocationMaxNetmaskLength;
        }

        public final void setAllocationMaxNetmaskLength(Integer allocationMaxNetmaskLength) {
            this.allocationMaxNetmaskLength = allocationMaxNetmaskLength;
        }

        @Override
        public final Builder allocationMaxNetmaskLength(Integer allocationMaxNetmaskLength) {
            this.allocationMaxNetmaskLength = allocationMaxNetmaskLength;
            return this;
        }

        public final Integer getAllocationDefaultNetmaskLength() {
            return allocationDefaultNetmaskLength;
        }

        public final void setAllocationDefaultNetmaskLength(Integer allocationDefaultNetmaskLength) {
            this.allocationDefaultNetmaskLength = allocationDefaultNetmaskLength;
        }

        @Override
        public final Builder allocationDefaultNetmaskLength(Integer allocationDefaultNetmaskLength) {
            this.allocationDefaultNetmaskLength = allocationDefaultNetmaskLength;
            return this;
        }

        public final Boolean getClearAllocationDefaultNetmaskLength() {
            return clearAllocationDefaultNetmaskLength;
        }

        public final void setClearAllocationDefaultNetmaskLength(Boolean clearAllocationDefaultNetmaskLength) {
            this.clearAllocationDefaultNetmaskLength = clearAllocationDefaultNetmaskLength;
        }

        @Override
        public final Builder clearAllocationDefaultNetmaskLength(Boolean clearAllocationDefaultNetmaskLength) {
            this.clearAllocationDefaultNetmaskLength = clearAllocationDefaultNetmaskLength;
            return this;
        }

        public final List<RequestIpamResourceTag.Builder> getAddAllocationResourceTags() {
            List<RequestIpamResourceTag.Builder> result = RequestIpamResourceTagListCopier
                    .copyToBuilder(this.addAllocationResourceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddAllocationResourceTags(Collection<RequestIpamResourceTag.BuilderImpl> addAllocationResourceTags) {
            this.addAllocationResourceTags = RequestIpamResourceTagListCopier.copyFromBuilder(addAllocationResourceTags);
        }

        @Override
        public final Builder addAllocationResourceTags(Collection<RequestIpamResourceTag> addAllocationResourceTags) {
            this.addAllocationResourceTags = RequestIpamResourceTagListCopier.copy(addAllocationResourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addAllocationResourceTags(RequestIpamResourceTag... addAllocationResourceTags) {
            addAllocationResourceTags(Arrays.asList(addAllocationResourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addAllocationResourceTags(Consumer<RequestIpamResourceTag.Builder>... addAllocationResourceTags) {
            addAllocationResourceTags(Stream.of(addAllocationResourceTags)
                    .map(c -> RequestIpamResourceTag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RequestIpamResourceTag.Builder> getRemoveAllocationResourceTags() {
            List<RequestIpamResourceTag.Builder> result = RequestIpamResourceTagListCopier
                    .copyToBuilder(this.removeAllocationResourceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRemoveAllocationResourceTags(
                Collection<RequestIpamResourceTag.BuilderImpl> removeAllocationResourceTags) {
            this.removeAllocationResourceTags = RequestIpamResourceTagListCopier.copyFromBuilder(removeAllocationResourceTags);
        }

        @Override
        public final Builder removeAllocationResourceTags(Collection<RequestIpamResourceTag> removeAllocationResourceTags) {
            this.removeAllocationResourceTags = RequestIpamResourceTagListCopier.copy(removeAllocationResourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeAllocationResourceTags(RequestIpamResourceTag... removeAllocationResourceTags) {
            removeAllocationResourceTags(Arrays.asList(removeAllocationResourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeAllocationResourceTags(
                Consumer<RequestIpamResourceTag.Builder>... removeAllocationResourceTags) {
            removeAllocationResourceTags(Stream.of(removeAllocationResourceTags)
                    .map(c -> RequestIpamResourceTag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyIpamPoolRequest build() {
            return new ModifyIpamPoolRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
