/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the memory available to the inference accelerator.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InferenceDeviceMemoryInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<InferenceDeviceMemoryInfo.Builder, InferenceDeviceMemoryInfo> {
    private static final SdkField<Integer> SIZE_IN_MIB_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("SizeInMiB")
            .getter(getter(InferenceDeviceMemoryInfo::sizeInMiB))
            .setter(setter(Builder::sizeInMiB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeInMiB")
                    .unmarshallLocationName("sizeInMiB").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIZE_IN_MIB_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer sizeInMiB;

    private InferenceDeviceMemoryInfo(BuilderImpl builder) {
        this.sizeInMiB = builder.sizeInMiB;
    }

    /**
     * <p>
     * The size of the memory available to the inference accelerator, in MiB.
     * </p>
     * 
     * @return The size of the memory available to the inference accelerator, in MiB.
     */
    public final Integer sizeInMiB() {
        return sizeInMiB;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sizeInMiB());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceDeviceMemoryInfo)) {
            return false;
        }
        InferenceDeviceMemoryInfo other = (InferenceDeviceMemoryInfo) obj;
        return Objects.equals(sizeInMiB(), other.sizeInMiB());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InferenceDeviceMemoryInfo").add("SizeInMiB", sizeInMiB()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SizeInMiB":
            return Optional.ofNullable(clazz.cast(sizeInMiB()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InferenceDeviceMemoryInfo, T> g) {
        return obj -> g.apply((InferenceDeviceMemoryInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InferenceDeviceMemoryInfo> {
        /**
         * <p>
         * The size of the memory available to the inference accelerator, in MiB.
         * </p>
         * 
         * @param sizeInMiB
         *        The size of the memory available to the inference accelerator, in MiB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeInMiB(Integer sizeInMiB);
    }

    static final class BuilderImpl implements Builder {
        private Integer sizeInMiB;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceDeviceMemoryInfo model) {
            sizeInMiB(model.sizeInMiB);
        }

        public final Integer getSizeInMiB() {
            return sizeInMiB;
        }

        public final void setSizeInMiB(Integer sizeInMiB) {
            this.sizeInMiB = sizeInMiB;
        }

        @Override
        public final Builder sizeInMiB(Integer sizeInMiB) {
            this.sizeInMiB = sizeInMiB;
            return this;
        }

        @Override
        public InferenceDeviceMemoryInfo build() {
            return new InferenceDeviceMemoryInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
