/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * In IPAM, an allocation is a CIDR assignment from an IPAM pool to another IPAM pool or to a resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IpamPoolAllocation implements SdkPojo, Serializable,
        ToCopyableBuilder<IpamPoolAllocation.Builder, IpamPoolAllocation> {
    private static final SdkField<String> CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Cidr")
            .getter(getter(IpamPoolAllocation::cidr))
            .setter(setter(Builder::cidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidr")
                    .unmarshallLocationName("cidr").build()).build();

    private static final SdkField<String> IPAM_POOL_ALLOCATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpamPoolAllocationId")
            .getter(getter(IpamPoolAllocation::ipamPoolAllocationId))
            .setter(setter(Builder::ipamPoolAllocationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPoolAllocationId")
                    .unmarshallLocationName("ipamPoolAllocationId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(IpamPoolAllocation::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceId")
            .getter(getter(IpamPoolAllocation::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId")
                    .unmarshallLocationName("resourceId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceType")
            .getter(getter(IpamPoolAllocation::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType")
                    .unmarshallLocationName("resourceType").build()).build();

    private static final SdkField<String> RESOURCE_REGION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceRegion")
            .getter(getter(IpamPoolAllocation::resourceRegion))
            .setter(setter(Builder::resourceRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceRegion")
                    .unmarshallLocationName("resourceRegion").build()).build();

    private static final SdkField<String> RESOURCE_OWNER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceOwner")
            .getter(getter(IpamPoolAllocation::resourceOwner))
            .setter(setter(Builder::resourceOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceOwner")
                    .unmarshallLocationName("resourceOwner").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_FIELD,
            IPAM_POOL_ALLOCATION_ID_FIELD, DESCRIPTION_FIELD, RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_REGION_FIELD,
            RESOURCE_OWNER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cidr;

    private final String ipamPoolAllocationId;

    private final String description;

    private final String resourceId;

    private final String resourceType;

    private final String resourceRegion;

    private final String resourceOwner;

    private IpamPoolAllocation(BuilderImpl builder) {
        this.cidr = builder.cidr;
        this.ipamPoolAllocationId = builder.ipamPoolAllocationId;
        this.description = builder.description;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.resourceRegion = builder.resourceRegion;
        this.resourceOwner = builder.resourceOwner;
    }

    /**
     * <p>
     * The CIDR for the allocation. A CIDR is a representation of an IP address and its associated network mask (or
     * netmask) and refers to a range of IP addresses. An IPv4 CIDR example is <code>10.24.34.0/23</code>. An IPv6 CIDR
     * example is <code>2001:DB8::/32</code>.
     * </p>
     * 
     * @return The CIDR for the allocation. A CIDR is a representation of an IP address and its associated network mask
     *         (or netmask) and refers to a range of IP addresses. An IPv4 CIDR example is <code>10.24.34.0/23</code>.
     *         An IPv6 CIDR example is <code>2001:DB8::/32</code>.
     */
    public final String cidr() {
        return cidr;
    }

    /**
     * <p>
     * The ID of an allocation.
     * </p>
     * 
     * @return The ID of an allocation.
     */
    public final String ipamPoolAllocationId() {
        return ipamPoolAllocationId;
    }

    /**
     * <p>
     * A description of the pool allocation.
     * </p>
     * 
     * @return A description of the pool allocation.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the resource.
     * </p>
     * 
     * @return The ID of the resource.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The type of the resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link IpamPoolAllocationResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of the resource.
     * @see IpamPoolAllocationResourceType
     */
    public final IpamPoolAllocationResourceType resourceType() {
        return IpamPoolAllocationResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of the resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link IpamPoolAllocationResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of the resource.
     * @see IpamPoolAllocationResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The Amazon Web Services Region of the resource.
     * </p>
     * 
     * @return The Amazon Web Services Region of the resource.
     */
    public final String resourceRegion() {
        return resourceRegion;
    }

    /**
     * <p>
     * The owner of the resource.
     * </p>
     * 
     * @return The owner of the resource.
     */
    public final String resourceOwner() {
        return resourceOwner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cidr());
        hashCode = 31 * hashCode + Objects.hashCode(ipamPoolAllocationId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(resourceOwner());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpamPoolAllocation)) {
            return false;
        }
        IpamPoolAllocation other = (IpamPoolAllocation) obj;
        return Objects.equals(cidr(), other.cidr()) && Objects.equals(ipamPoolAllocationId(), other.ipamPoolAllocationId())
                && Objects.equals(description(), other.description()) && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(resourceRegion(), other.resourceRegion())
                && Objects.equals(resourceOwner(), other.resourceOwner());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IpamPoolAllocation").add("Cidr", cidr()).add("IpamPoolAllocationId", ipamPoolAllocationId())
                .add("Description", description()).add("ResourceId", resourceId()).add("ResourceType", resourceTypeAsString())
                .add("ResourceRegion", resourceRegion()).add("ResourceOwner", resourceOwner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Cidr":
            return Optional.ofNullable(clazz.cast(cidr()));
        case "IpamPoolAllocationId":
            return Optional.ofNullable(clazz.cast(ipamPoolAllocationId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "ResourceRegion":
            return Optional.ofNullable(clazz.cast(resourceRegion()));
        case "ResourceOwner":
            return Optional.ofNullable(clazz.cast(resourceOwner()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IpamPoolAllocation, T> g) {
        return obj -> g.apply((IpamPoolAllocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IpamPoolAllocation> {
        /**
         * <p>
         * The CIDR for the allocation. A CIDR is a representation of an IP address and its associated network mask (or
         * netmask) and refers to a range of IP addresses. An IPv4 CIDR example is <code>10.24.34.0/23</code>. An IPv6
         * CIDR example is <code>2001:DB8::/32</code>.
         * </p>
         * 
         * @param cidr
         *        The CIDR for the allocation. A CIDR is a representation of an IP address and its associated network
         *        mask (or netmask) and refers to a range of IP addresses. An IPv4 CIDR example is
         *        <code>10.24.34.0/23</code>. An IPv6 CIDR example is <code>2001:DB8::/32</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidr(String cidr);

        /**
         * <p>
         * The ID of an allocation.
         * </p>
         * 
         * @param ipamPoolAllocationId
         *        The ID of an allocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamPoolAllocationId(String ipamPoolAllocationId);

        /**
         * <p>
         * A description of the pool allocation.
         * </p>
         * 
         * @param description
         *        A description of the pool allocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the resource.
         * </p>
         * 
         * @param resourceId
         *        The ID of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The type of the resource.
         * </p>
         * 
         * @param resourceType
         *        The type of the resource.
         * @see IpamPoolAllocationResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpamPoolAllocationResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of the resource.
         * </p>
         * 
         * @param resourceType
         *        The type of the resource.
         * @see IpamPoolAllocationResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpamPoolAllocationResourceType
         */
        Builder resourceType(IpamPoolAllocationResourceType resourceType);

        /**
         * <p>
         * The Amazon Web Services Region of the resource.
         * </p>
         * 
         * @param resourceRegion
         *        The Amazon Web Services Region of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceRegion(String resourceRegion);

        /**
         * <p>
         * The owner of the resource.
         * </p>
         * 
         * @param resourceOwner
         *        The owner of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceOwner(String resourceOwner);
    }

    static final class BuilderImpl implements Builder {
        private String cidr;

        private String ipamPoolAllocationId;

        private String description;

        private String resourceId;

        private String resourceType;

        private String resourceRegion;

        private String resourceOwner;

        private BuilderImpl() {
        }

        private BuilderImpl(IpamPoolAllocation model) {
            cidr(model.cidr);
            ipamPoolAllocationId(model.ipamPoolAllocationId);
            description(model.description);
            resourceId(model.resourceId);
            resourceType(model.resourceType);
            resourceRegion(model.resourceRegion);
            resourceOwner(model.resourceOwner);
        }

        public final String getCidr() {
            return cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final String getIpamPoolAllocationId() {
            return ipamPoolAllocationId;
        }

        public final void setIpamPoolAllocationId(String ipamPoolAllocationId) {
            this.ipamPoolAllocationId = ipamPoolAllocationId;
        }

        @Override
        public final Builder ipamPoolAllocationId(String ipamPoolAllocationId) {
            this.ipamPoolAllocationId = ipamPoolAllocationId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(IpamPoolAllocationResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getResourceRegion() {
            return resourceRegion;
        }

        public final void setResourceRegion(String resourceRegion) {
            this.resourceRegion = resourceRegion;
        }

        @Override
        public final Builder resourceRegion(String resourceRegion) {
            this.resourceRegion = resourceRegion;
            return this;
        }

        public final String getResourceOwner() {
            return resourceOwner;
        }

        public final void setResourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
        }

        @Override
        public final Builder resourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
            return this;
        }

        @Override
        public IpamPoolAllocation build() {
            return new IpamPoolAllocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
