/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyInstanceMetadataDefaultsRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyInstanceMetadataDefaultsRequest.Builder, ModifyInstanceMetadataDefaultsRequest> {
    private static final SdkField<String> HTTP_TOKENS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HttpTokens")
            .getter(getter(ModifyInstanceMetadataDefaultsRequest::httpTokensAsString))
            .setter(setter(Builder::httpTokens))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpTokens")
                    .unmarshallLocationName("HttpTokens").build()).build();

    private static final SdkField<Integer> HTTP_PUT_RESPONSE_HOP_LIMIT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("HttpPutResponseHopLimit")
            .getter(getter(ModifyInstanceMetadataDefaultsRequest::httpPutResponseHopLimit))
            .setter(setter(Builder::httpPutResponseHopLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpPutResponseHopLimit")
                    .unmarshallLocationName("HttpPutResponseHopLimit").build()).build();

    private static final SdkField<String> HTTP_ENDPOINT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HttpEndpoint")
            .getter(getter(ModifyInstanceMetadataDefaultsRequest::httpEndpointAsString))
            .setter(setter(Builder::httpEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpEndpoint")
                    .unmarshallLocationName("HttpEndpoint").build()).build();

    private static final SdkField<String> INSTANCE_METADATA_TAGS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceMetadataTags")
            .getter(getter(ModifyInstanceMetadataDefaultsRequest::instanceMetadataTagsAsString))
            .setter(setter(Builder::instanceMetadataTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMetadataTags")
                    .unmarshallLocationName("InstanceMetadataTags").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(ModifyInstanceMetadataDefaultsRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HTTP_TOKENS_FIELD,
            HTTP_PUT_RESPONSE_HOP_LIMIT_FIELD, HTTP_ENDPOINT_FIELD, INSTANCE_METADATA_TAGS_FIELD, DRY_RUN_FIELD));

    private final String httpTokens;

    private final Integer httpPutResponseHopLimit;

    private final String httpEndpoint;

    private final String instanceMetadataTags;

    private final Boolean dryRun;

    private ModifyInstanceMetadataDefaultsRequest(BuilderImpl builder) {
        super(builder);
        this.httpTokens = builder.httpTokens;
        this.httpPutResponseHopLimit = builder.httpPutResponseHopLimit;
        this.httpEndpoint = builder.httpEndpoint;
        this.instanceMetadataTags = builder.instanceMetadataTags;
        this.dryRun = builder.dryRun;
    }

    /**
     * <p>
     * Indicates whether IMDSv2 is required.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>optional</code> – IMDSv2 is optional, which means that you can use either IMDSv2 or IMDSv1.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>required</code> – IMDSv2 is required, which means that IMDSv1 is disabled, and you must use IMDSv2.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpTokens} will
     * return {@link MetadataDefaultHttpTokensState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #httpTokensAsString}.
     * </p>
     * 
     * @return Indicates whether IMDSv2 is required.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>optional</code> – IMDSv2 is optional, which means that you can use either IMDSv2 or IMDSv1.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>required</code> – IMDSv2 is required, which means that IMDSv1 is disabled, and you must use IMDSv2.
     *         </p>
     *         </li>
     * @see MetadataDefaultHttpTokensState
     */
    public final MetadataDefaultHttpTokensState httpTokens() {
        return MetadataDefaultHttpTokensState.fromValue(httpTokens);
    }

    /**
     * <p>
     * Indicates whether IMDSv2 is required.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>optional</code> – IMDSv2 is optional, which means that you can use either IMDSv2 or IMDSv1.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>required</code> – IMDSv2 is required, which means that IMDSv1 is disabled, and you must use IMDSv2.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpTokens} will
     * return {@link MetadataDefaultHttpTokensState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #httpTokensAsString}.
     * </p>
     * 
     * @return Indicates whether IMDSv2 is required.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>optional</code> – IMDSv2 is optional, which means that you can use either IMDSv2 or IMDSv1.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>required</code> – IMDSv2 is required, which means that IMDSv1 is disabled, and you must use IMDSv2.
     *         </p>
     *         </li>
     * @see MetadataDefaultHttpTokensState
     */
    public final String httpTokensAsString() {
        return httpTokens;
    }

    /**
     * <p>
     * The maximum number of hops that the metadata token can travel.
     * </p>
     * <p>
     * Minimum: <code>1</code>
     * </p>
     * <p>
     * Maximum: <code>64</code>
     * </p>
     * 
     * @return The maximum number of hops that the metadata token can travel.</p>
     *         <p>
     *         Minimum: <code>1</code>
     *         </p>
     *         <p>
     *         Maximum: <code>64</code>
     */
    public final Integer httpPutResponseHopLimit() {
        return httpPutResponseHopLimit;
    }

    /**
     * <p>
     * Enables or disables the IMDS endpoint on an instance. When disabled, the instance metadata can't be accessed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpEndpoint} will
     * return {@link DefaultInstanceMetadataEndpointState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #httpEndpointAsString}.
     * </p>
     * 
     * @return Enables or disables the IMDS endpoint on an instance. When disabled, the instance metadata can't be
     *         accessed.
     * @see DefaultInstanceMetadataEndpointState
     */
    public final DefaultInstanceMetadataEndpointState httpEndpoint() {
        return DefaultInstanceMetadataEndpointState.fromValue(httpEndpoint);
    }

    /**
     * <p>
     * Enables or disables the IMDS endpoint on an instance. When disabled, the instance metadata can't be accessed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpEndpoint} will
     * return {@link DefaultInstanceMetadataEndpointState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #httpEndpointAsString}.
     * </p>
     * 
     * @return Enables or disables the IMDS endpoint on an instance. When disabled, the instance metadata can't be
     *         accessed.
     * @see DefaultInstanceMetadataEndpointState
     */
    public final String httpEndpointAsString() {
        return httpEndpoint;
    }

    /**
     * <p>
     * Enables or disables access to an instance's tags from the instance metadata. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#work-with-tags-in-IMDS">Work with
     * instance tags using the instance metadata</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instanceMetadataTags} will return {@link DefaultInstanceMetadataTagsState#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #instanceMetadataTagsAsString}.
     * </p>
     * 
     * @return Enables or disables access to an instance's tags from the instance metadata. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#work-with-tags-in-IMDS">Work
     *         with instance tags using the instance metadata</a> in the <i>Amazon EC2 User Guide</i>.
     * @see DefaultInstanceMetadataTagsState
     */
    public final DefaultInstanceMetadataTagsState instanceMetadataTags() {
        return DefaultInstanceMetadataTagsState.fromValue(instanceMetadataTags);
    }

    /**
     * <p>
     * Enables or disables access to an instance's tags from the instance metadata. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#work-with-tags-in-IMDS">Work with
     * instance tags using the instance metadata</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instanceMetadataTags} will return {@link DefaultInstanceMetadataTagsState#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #instanceMetadataTagsAsString}.
     * </p>
     * 
     * @return Enables or disables access to an instance's tags from the instance metadata. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#work-with-tags-in-IMDS">Work
     *         with instance tags using the instance metadata</a> in the <i>Amazon EC2 User Guide</i>.
     * @see DefaultInstanceMetadataTagsState
     */
    public final String instanceMetadataTagsAsString() {
        return instanceMetadataTags;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(httpTokensAsString());
        hashCode = 31 * hashCode + Objects.hashCode(httpPutResponseHopLimit());
        hashCode = 31 * hashCode + Objects.hashCode(httpEndpointAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instanceMetadataTagsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstanceMetadataDefaultsRequest)) {
            return false;
        }
        ModifyInstanceMetadataDefaultsRequest other = (ModifyInstanceMetadataDefaultsRequest) obj;
        return Objects.equals(httpTokensAsString(), other.httpTokensAsString())
                && Objects.equals(httpPutResponseHopLimit(), other.httpPutResponseHopLimit())
                && Objects.equals(httpEndpointAsString(), other.httpEndpointAsString())
                && Objects.equals(instanceMetadataTagsAsString(), other.instanceMetadataTagsAsString())
                && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyInstanceMetadataDefaultsRequest").add("HttpTokens", httpTokensAsString())
                .add("HttpPutResponseHopLimit", httpPutResponseHopLimit()).add("HttpEndpoint", httpEndpointAsString())
                .add("InstanceMetadataTags", instanceMetadataTagsAsString()).add("DryRun", dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HttpTokens":
            return Optional.ofNullable(clazz.cast(httpTokensAsString()));
        case "HttpPutResponseHopLimit":
            return Optional.ofNullable(clazz.cast(httpPutResponseHopLimit()));
        case "HttpEndpoint":
            return Optional.ofNullable(clazz.cast(httpEndpointAsString()));
        case "InstanceMetadataTags":
            return Optional.ofNullable(clazz.cast(instanceMetadataTagsAsString()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyInstanceMetadataDefaultsRequest, T> g) {
        return obj -> g.apply((ModifyInstanceMetadataDefaultsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyInstanceMetadataDefaultsRequest> {
        /**
         * <p>
         * Indicates whether IMDSv2 is required.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>optional</code> – IMDSv2 is optional, which means that you can use either IMDSv2 or IMDSv1.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>required</code> – IMDSv2 is required, which means that IMDSv1 is disabled, and you must use IMDSv2.
         * </p>
         * </li>
         * </ul>
         * 
         * @param httpTokens
         *        Indicates whether IMDSv2 is required.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>optional</code> – IMDSv2 is optional, which means that you can use either IMDSv2 or IMDSv1.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>required</code> – IMDSv2 is required, which means that IMDSv1 is disabled, and you must use
         *        IMDSv2.
         *        </p>
         *        </li>
         * @see MetadataDefaultHttpTokensState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetadataDefaultHttpTokensState
         */
        Builder httpTokens(String httpTokens);

        /**
         * <p>
         * Indicates whether IMDSv2 is required.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>optional</code> – IMDSv2 is optional, which means that you can use either IMDSv2 or IMDSv1.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>required</code> – IMDSv2 is required, which means that IMDSv1 is disabled, and you must use IMDSv2.
         * </p>
         * </li>
         * </ul>
         * 
         * @param httpTokens
         *        Indicates whether IMDSv2 is required.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>optional</code> – IMDSv2 is optional, which means that you can use either IMDSv2 or IMDSv1.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>required</code> – IMDSv2 is required, which means that IMDSv1 is disabled, and you must use
         *        IMDSv2.
         *        </p>
         *        </li>
         * @see MetadataDefaultHttpTokensState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetadataDefaultHttpTokensState
         */
        Builder httpTokens(MetadataDefaultHttpTokensState httpTokens);

        /**
         * <p>
         * The maximum number of hops that the metadata token can travel.
         * </p>
         * <p>
         * Minimum: <code>1</code>
         * </p>
         * <p>
         * Maximum: <code>64</code>
         * </p>
         * 
         * @param httpPutResponseHopLimit
         *        The maximum number of hops that the metadata token can travel.</p>
         *        <p>
         *        Minimum: <code>1</code>
         *        </p>
         *        <p>
         *        Maximum: <code>64</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpPutResponseHopLimit(Integer httpPutResponseHopLimit);

        /**
         * <p>
         * Enables or disables the IMDS endpoint on an instance. When disabled, the instance metadata can't be accessed.
         * </p>
         * 
         * @param httpEndpoint
         *        Enables or disables the IMDS endpoint on an instance. When disabled, the instance metadata can't be
         *        accessed.
         * @see DefaultInstanceMetadataEndpointState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultInstanceMetadataEndpointState
         */
        Builder httpEndpoint(String httpEndpoint);

        /**
         * <p>
         * Enables or disables the IMDS endpoint on an instance. When disabled, the instance metadata can't be accessed.
         * </p>
         * 
         * @param httpEndpoint
         *        Enables or disables the IMDS endpoint on an instance. When disabled, the instance metadata can't be
         *        accessed.
         * @see DefaultInstanceMetadataEndpointState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultInstanceMetadataEndpointState
         */
        Builder httpEndpoint(DefaultInstanceMetadataEndpointState httpEndpoint);

        /**
         * <p>
         * Enables or disables access to an instance's tags from the instance metadata. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#work-with-tags-in-IMDS">Work with
         * instance tags using the instance metadata</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param instanceMetadataTags
         *        Enables or disables access to an instance's tags from the instance metadata. For more information, see
         *        <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#work-with-tags-in-IMDS">
         *        Work with instance tags using the instance metadata</a> in the <i>Amazon EC2 User Guide</i>.
         * @see DefaultInstanceMetadataTagsState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultInstanceMetadataTagsState
         */
        Builder instanceMetadataTags(String instanceMetadataTags);

        /**
         * <p>
         * Enables or disables access to an instance's tags from the instance metadata. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#work-with-tags-in-IMDS">Work with
         * instance tags using the instance metadata</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param instanceMetadataTags
         *        Enables or disables access to an instance's tags from the instance metadata. For more information, see
         *        <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#work-with-tags-in-IMDS">
         *        Work with instance tags using the instance metadata</a> in the <i>Amazon EC2 User Guide</i>.
         * @see DefaultInstanceMetadataTagsState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultInstanceMetadataTagsState
         */
        Builder instanceMetadataTags(DefaultInstanceMetadataTagsState instanceMetadataTags);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String httpTokens;

        private Integer httpPutResponseHopLimit;

        private String httpEndpoint;

        private String instanceMetadataTags;

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstanceMetadataDefaultsRequest model) {
            super(model);
            httpTokens(model.httpTokens);
            httpPutResponseHopLimit(model.httpPutResponseHopLimit);
            httpEndpoint(model.httpEndpoint);
            instanceMetadataTags(model.instanceMetadataTags);
            dryRun(model.dryRun);
        }

        public final String getHttpTokens() {
            return httpTokens;
        }

        public final void setHttpTokens(String httpTokens) {
            this.httpTokens = httpTokens;
        }

        @Override
        public final Builder httpTokens(String httpTokens) {
            this.httpTokens = httpTokens;
            return this;
        }

        @Override
        public final Builder httpTokens(MetadataDefaultHttpTokensState httpTokens) {
            this.httpTokens(httpTokens == null ? null : httpTokens.toString());
            return this;
        }

        public final Integer getHttpPutResponseHopLimit() {
            return httpPutResponseHopLimit;
        }

        public final void setHttpPutResponseHopLimit(Integer httpPutResponseHopLimit) {
            this.httpPutResponseHopLimit = httpPutResponseHopLimit;
        }

        @Override
        public final Builder httpPutResponseHopLimit(Integer httpPutResponseHopLimit) {
            this.httpPutResponseHopLimit = httpPutResponseHopLimit;
            return this;
        }

        public final String getHttpEndpoint() {
            return httpEndpoint;
        }

        public final void setHttpEndpoint(String httpEndpoint) {
            this.httpEndpoint = httpEndpoint;
        }

        @Override
        public final Builder httpEndpoint(String httpEndpoint) {
            this.httpEndpoint = httpEndpoint;
            return this;
        }

        @Override
        public final Builder httpEndpoint(DefaultInstanceMetadataEndpointState httpEndpoint) {
            this.httpEndpoint(httpEndpoint == null ? null : httpEndpoint.toString());
            return this;
        }

        public final String getInstanceMetadataTags() {
            return instanceMetadataTags;
        }

        public final void setInstanceMetadataTags(String instanceMetadataTags) {
            this.instanceMetadataTags = instanceMetadataTags;
        }

        @Override
        public final Builder instanceMetadataTags(String instanceMetadataTags) {
            this.instanceMetadataTags = instanceMetadataTags;
            return this;
        }

        @Override
        public final Builder instanceMetadataTags(DefaultInstanceMetadataTagsState instanceMetadataTags) {
            this.instanceMetadataTags(instanceMetadataTags == null ? null : instanceMetadataTags.toString());
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyInstanceMetadataDefaultsRequest build() {
            return new ModifyInstanceMetadataDefaultsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
