/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateIpamResourceDiscoveryRequest extends Ec2Request implements
        ToCopyableBuilder<CreateIpamResourceDiscoveryRequest.Builder, CreateIpamResourceDiscoveryRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(CreateIpamResourceDiscoveryRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(CreateIpamResourceDiscoveryRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<List<AddIpamOperatingRegion>> OPERATING_REGIONS_FIELD = SdkField
            .<List<AddIpamOperatingRegion>> builder(MarshallingType.LIST)
            .memberName("OperatingRegions")
            .getter(getter(CreateIpamResourceDiscoveryRequest::operatingRegions))
            .setter(setter(Builder::operatingRegions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingRegion")
                    .unmarshallLocationName("OperatingRegion").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AddIpamOperatingRegion> builder(MarshallingType.SDK_POJO)
                                            .constructor(AddIpamOperatingRegion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(CreateIpamResourceDiscoveryRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateIpamResourceDiscoveryRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD,
            DESCRIPTION_FIELD, OPERATING_REGIONS_FIELD, TAG_SPECIFICATIONS_FIELD, CLIENT_TOKEN_FIELD));

    private final Boolean dryRun;

    private final String description;

    private final List<AddIpamOperatingRegion> operatingRegions;

    private final List<TagSpecification> tagSpecifications;

    private final String clientToken;

    private CreateIpamResourceDiscoveryRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.description = builder.description;
        this.operatingRegions = builder.operatingRegions;
        this.tagSpecifications = builder.tagSpecifications;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * A check for whether you have the required permissions for the action without actually making the request and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return A check for whether you have the required permissions for the action without actually making the request
     *         and provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * A description for the IPAM resource discovery.
     * </p>
     * 
     * @return A description for the IPAM resource discovery.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the OperatingRegions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOperatingRegions() {
        return operatingRegions != null && !(operatingRegions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Operating Regions for the IPAM resource discovery. Operating Regions are Amazon Web Services Regions where the
     * IPAM is allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in the Amazon Web Services
     * Regions you select as operating Regions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOperatingRegions} method.
     * </p>
     * 
     * @return Operating Regions for the IPAM resource discovery. Operating Regions are Amazon Web Services Regions
     *         where the IPAM is allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in the
     *         Amazon Web Services Regions you select as operating Regions.
     */
    public final List<AddIpamOperatingRegion> operatingRegions() {
        return operatingRegions;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagSpecifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tag specifications for the IPAM resource discovery.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagSpecifications} method.
     * </p>
     * 
     * @return Tag specifications for the IPAM resource discovery.
     */
    public final List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    /**
     * <p>
     * A client token for the IPAM resource discovery.
     * </p>
     * 
     * @return A client token for the IPAM resource discovery.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasOperatingRegions() ? operatingRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIpamResourceDiscoveryRequest)) {
            return false;
        }
        CreateIpamResourceDiscoveryRequest other = (CreateIpamResourceDiscoveryRequest) obj;
        return Objects.equals(dryRun(), other.dryRun()) && Objects.equals(description(), other.description())
                && hasOperatingRegions() == other.hasOperatingRegions()
                && Objects.equals(operatingRegions(), other.operatingRegions())
                && hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateIpamResourceDiscoveryRequest").add("DryRun", dryRun()).add("Description", description())
                .add("OperatingRegions", hasOperatingRegions() ? operatingRegions() : null)
                .add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null).add("ClientToken", clientToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "OperatingRegions":
            return Optional.ofNullable(clazz.cast(operatingRegions()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateIpamResourceDiscoveryRequest, T> g) {
        return obj -> g.apply((CreateIpamResourceDiscoveryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateIpamResourceDiscoveryRequest> {
        /**
         * <p>
         * A check for whether you have the required permissions for the action without actually making the request and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        A check for whether you have the required permissions for the action without actually making the
         *        request and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * A description for the IPAM resource discovery.
         * </p>
         * 
         * @param description
         *        A description for the IPAM resource discovery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Operating Regions for the IPAM resource discovery. Operating Regions are Amazon Web Services Regions where
         * the IPAM is allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in the Amazon Web
         * Services Regions you select as operating Regions.
         * </p>
         * 
         * @param operatingRegions
         *        Operating Regions for the IPAM resource discovery. Operating Regions are Amazon Web Services Regions
         *        where the IPAM is allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in
         *        the Amazon Web Services Regions you select as operating Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingRegions(Collection<AddIpamOperatingRegion> operatingRegions);

        /**
         * <p>
         * Operating Regions for the IPAM resource discovery. Operating Regions are Amazon Web Services Regions where
         * the IPAM is allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in the Amazon Web
         * Services Regions you select as operating Regions.
         * </p>
         * 
         * @param operatingRegions
         *        Operating Regions for the IPAM resource discovery. Operating Regions are Amazon Web Services Regions
         *        where the IPAM is allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in
         *        the Amazon Web Services Regions you select as operating Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingRegions(AddIpamOperatingRegion... operatingRegions);

        /**
         * <p>
         * Operating Regions for the IPAM resource discovery. Operating Regions are Amazon Web Services Regions where
         * the IPAM is allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in the Amazon Web
         * Services Regions you select as operating Regions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.AddIpamOperatingRegion.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ec2.model.AddIpamOperatingRegion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.AddIpamOperatingRegion.Builder#build()} is called
         * immediately and its result is passed to {@link #operatingRegions(List<AddIpamOperatingRegion>)}.
         * 
         * @param operatingRegions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.AddIpamOperatingRegion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operatingRegions(java.util.Collection<AddIpamOperatingRegion>)
         */
        Builder operatingRegions(Consumer<AddIpamOperatingRegion.Builder>... operatingRegions);

        /**
         * <p>
         * Tag specifications for the IPAM resource discovery.
         * </p>
         * 
         * @param tagSpecifications
         *        Tag specifications for the IPAM resource discovery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * Tag specifications for the IPAM resource discovery.
         * </p>
         * 
         * @param tagSpecifications
         *        Tag specifications for the IPAM resource discovery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * Tag specifications for the IPAM resource discovery.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.TagSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(java.util.Collection<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        /**
         * <p>
         * A client token for the IPAM resource discovery.
         * </p>
         * 
         * @param clientToken
         *        A client token for the IPAM resource discovery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Boolean dryRun;

        private String description;

        private List<AddIpamOperatingRegion> operatingRegions = DefaultSdkAutoConstructList.getInstance();

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIpamResourceDiscoveryRequest model) {
            super(model);
            dryRun(model.dryRun);
            description(model.description);
            operatingRegions(model.operatingRegions);
            tagSpecifications(model.tagSpecifications);
            clientToken(model.clientToken);
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<AddIpamOperatingRegion.Builder> getOperatingRegions() {
            List<AddIpamOperatingRegion.Builder> result = AddIpamOperatingRegionSetCopier.copyToBuilder(this.operatingRegions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOperatingRegions(Collection<AddIpamOperatingRegion.BuilderImpl> operatingRegions) {
            this.operatingRegions = AddIpamOperatingRegionSetCopier.copyFromBuilder(operatingRegions);
        }

        @Override
        public final Builder operatingRegions(Collection<AddIpamOperatingRegion> operatingRegions) {
            this.operatingRegions = AddIpamOperatingRegionSetCopier.copy(operatingRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operatingRegions(AddIpamOperatingRegion... operatingRegions) {
            operatingRegions(Arrays.asList(operatingRegions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operatingRegions(Consumer<AddIpamOperatingRegion.Builder>... operatingRegions) {
            operatingRegions(Stream.of(operatingRegions).map(c -> AddIpamOperatingRegion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIpamResourceDiscoveryRequest build() {
            return new CreateIpamResourceDiscoveryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
