/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.query.AwsEc2ProtocolFactory;
import software.amazon.awssdk.services.ec2.internal.Ec2ServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.ec2.model.AcceptAddressTransferRequest;
import software.amazon.awssdk.services.ec2.model.AcceptAddressTransferResponse;
import software.amazon.awssdk.services.ec2.model.AcceptReservedInstancesExchangeQuoteRequest;
import software.amazon.awssdk.services.ec2.model.AcceptReservedInstancesExchangeQuoteResponse;
import software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayMulticastDomainAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayMulticastDomainAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayPeeringAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayPeeringAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayVpcAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayVpcAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.AcceptVpcEndpointConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.AcceptVpcEndpointConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.AcceptVpcPeeringConnectionRequest;
import software.amazon.awssdk.services.ec2.model.AcceptVpcPeeringConnectionResponse;
import software.amazon.awssdk.services.ec2.model.AdvertiseByoipCidrRequest;
import software.amazon.awssdk.services.ec2.model.AdvertiseByoipCidrResponse;
import software.amazon.awssdk.services.ec2.model.AllocateAddressRequest;
import software.amazon.awssdk.services.ec2.model.AllocateAddressResponse;
import software.amazon.awssdk.services.ec2.model.AllocateHostsRequest;
import software.amazon.awssdk.services.ec2.model.AllocateHostsResponse;
import software.amazon.awssdk.services.ec2.model.AllocateIpamPoolCidrRequest;
import software.amazon.awssdk.services.ec2.model.AllocateIpamPoolCidrResponse;
import software.amazon.awssdk.services.ec2.model.ApplySecurityGroupsToClientVpnTargetNetworkRequest;
import software.amazon.awssdk.services.ec2.model.ApplySecurityGroupsToClientVpnTargetNetworkResponse;
import software.amazon.awssdk.services.ec2.model.AssignIpv6AddressesRequest;
import software.amazon.awssdk.services.ec2.model.AssignIpv6AddressesResponse;
import software.amazon.awssdk.services.ec2.model.AssignPrivateIpAddressesRequest;
import software.amazon.awssdk.services.ec2.model.AssignPrivateIpAddressesResponse;
import software.amazon.awssdk.services.ec2.model.AssignPrivateNatGatewayAddressRequest;
import software.amazon.awssdk.services.ec2.model.AssignPrivateNatGatewayAddressResponse;
import software.amazon.awssdk.services.ec2.model.AssociateAddressRequest;
import software.amazon.awssdk.services.ec2.model.AssociateAddressResponse;
import software.amazon.awssdk.services.ec2.model.AssociateClientVpnTargetNetworkRequest;
import software.amazon.awssdk.services.ec2.model.AssociateClientVpnTargetNetworkResponse;
import software.amazon.awssdk.services.ec2.model.AssociateDhcpOptionsRequest;
import software.amazon.awssdk.services.ec2.model.AssociateDhcpOptionsResponse;
import software.amazon.awssdk.services.ec2.model.AssociateEnclaveCertificateIamRoleRequest;
import software.amazon.awssdk.services.ec2.model.AssociateEnclaveCertificateIamRoleResponse;
import software.amazon.awssdk.services.ec2.model.AssociateIamInstanceProfileRequest;
import software.amazon.awssdk.services.ec2.model.AssociateIamInstanceProfileResponse;
import software.amazon.awssdk.services.ec2.model.AssociateInstanceEventWindowRequest;
import software.amazon.awssdk.services.ec2.model.AssociateInstanceEventWindowResponse;
import software.amazon.awssdk.services.ec2.model.AssociateIpamByoasnRequest;
import software.amazon.awssdk.services.ec2.model.AssociateIpamByoasnResponse;
import software.amazon.awssdk.services.ec2.model.AssociateIpamResourceDiscoveryRequest;
import software.amazon.awssdk.services.ec2.model.AssociateIpamResourceDiscoveryResponse;
import software.amazon.awssdk.services.ec2.model.AssociateNatGatewayAddressRequest;
import software.amazon.awssdk.services.ec2.model.AssociateNatGatewayAddressResponse;
import software.amazon.awssdk.services.ec2.model.AssociateRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.AssociateRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.AssociateSubnetCidrBlockRequest;
import software.amazon.awssdk.services.ec2.model.AssociateSubnetCidrBlockResponse;
import software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayMulticastDomainRequest;
import software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayMulticastDomainResponse;
import software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayPolicyTableRequest;
import software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayPolicyTableResponse;
import software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.AssociateTrunkInterfaceRequest;
import software.amazon.awssdk.services.ec2.model.AssociateTrunkInterfaceResponse;
import software.amazon.awssdk.services.ec2.model.AssociateVpcCidrBlockRequest;
import software.amazon.awssdk.services.ec2.model.AssociateVpcCidrBlockResponse;
import software.amazon.awssdk.services.ec2.model.AttachClassicLinkVpcRequest;
import software.amazon.awssdk.services.ec2.model.AttachClassicLinkVpcResponse;
import software.amazon.awssdk.services.ec2.model.AttachInternetGatewayRequest;
import software.amazon.awssdk.services.ec2.model.AttachInternetGatewayResponse;
import software.amazon.awssdk.services.ec2.model.AttachNetworkInterfaceRequest;
import software.amazon.awssdk.services.ec2.model.AttachNetworkInterfaceResponse;
import software.amazon.awssdk.services.ec2.model.AttachVerifiedAccessTrustProviderRequest;
import software.amazon.awssdk.services.ec2.model.AttachVerifiedAccessTrustProviderResponse;
import software.amazon.awssdk.services.ec2.model.AttachVolumeRequest;
import software.amazon.awssdk.services.ec2.model.AttachVolumeResponse;
import software.amazon.awssdk.services.ec2.model.AttachVpnGatewayRequest;
import software.amazon.awssdk.services.ec2.model.AttachVpnGatewayResponse;
import software.amazon.awssdk.services.ec2.model.AuthorizeClientVpnIngressRequest;
import software.amazon.awssdk.services.ec2.model.AuthorizeClientVpnIngressResponse;
import software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupEgressRequest;
import software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupEgressResponse;
import software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupIngressRequest;
import software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupIngressResponse;
import software.amazon.awssdk.services.ec2.model.BundleInstanceRequest;
import software.amazon.awssdk.services.ec2.model.BundleInstanceResponse;
import software.amazon.awssdk.services.ec2.model.CancelBundleTaskRequest;
import software.amazon.awssdk.services.ec2.model.CancelBundleTaskResponse;
import software.amazon.awssdk.services.ec2.model.CancelCapacityReservationFleetsRequest;
import software.amazon.awssdk.services.ec2.model.CancelCapacityReservationFleetsResponse;
import software.amazon.awssdk.services.ec2.model.CancelCapacityReservationRequest;
import software.amazon.awssdk.services.ec2.model.CancelCapacityReservationResponse;
import software.amazon.awssdk.services.ec2.model.CancelConversionTaskRequest;
import software.amazon.awssdk.services.ec2.model.CancelConversionTaskResponse;
import software.amazon.awssdk.services.ec2.model.CancelExportTaskRequest;
import software.amazon.awssdk.services.ec2.model.CancelExportTaskResponse;
import software.amazon.awssdk.services.ec2.model.CancelImageLaunchPermissionRequest;
import software.amazon.awssdk.services.ec2.model.CancelImageLaunchPermissionResponse;
import software.amazon.awssdk.services.ec2.model.CancelImportTaskRequest;
import software.amazon.awssdk.services.ec2.model.CancelImportTaskResponse;
import software.amazon.awssdk.services.ec2.model.CancelReservedInstancesListingRequest;
import software.amazon.awssdk.services.ec2.model.CancelReservedInstancesListingResponse;
import software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsRequest;
import software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsResponse;
import software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestsRequest;
import software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestsResponse;
import software.amazon.awssdk.services.ec2.model.ConfirmProductInstanceRequest;
import software.amazon.awssdk.services.ec2.model.ConfirmProductInstanceResponse;
import software.amazon.awssdk.services.ec2.model.CopyFpgaImageRequest;
import software.amazon.awssdk.services.ec2.model.CopyFpgaImageResponse;
import software.amazon.awssdk.services.ec2.model.CopyImageRequest;
import software.amazon.awssdk.services.ec2.model.CopyImageResponse;
import software.amazon.awssdk.services.ec2.model.CopySnapshotRequest;
import software.amazon.awssdk.services.ec2.model.CopySnapshotResponse;
import software.amazon.awssdk.services.ec2.model.CreateCapacityReservationFleetRequest;
import software.amazon.awssdk.services.ec2.model.CreateCapacityReservationFleetResponse;
import software.amazon.awssdk.services.ec2.model.CreateCapacityReservationRequest;
import software.amazon.awssdk.services.ec2.model.CreateCapacityReservationResponse;
import software.amazon.awssdk.services.ec2.model.CreateCarrierGatewayRequest;
import software.amazon.awssdk.services.ec2.model.CreateCarrierGatewayResponse;
import software.amazon.awssdk.services.ec2.model.CreateClientVpnEndpointRequest;
import software.amazon.awssdk.services.ec2.model.CreateClientVpnEndpointResponse;
import software.amazon.awssdk.services.ec2.model.CreateClientVpnRouteRequest;
import software.amazon.awssdk.services.ec2.model.CreateClientVpnRouteResponse;
import software.amazon.awssdk.services.ec2.model.CreateCoipCidrRequest;
import software.amazon.awssdk.services.ec2.model.CreateCoipCidrResponse;
import software.amazon.awssdk.services.ec2.model.CreateCoipPoolRequest;
import software.amazon.awssdk.services.ec2.model.CreateCoipPoolResponse;
import software.amazon.awssdk.services.ec2.model.CreateCustomerGatewayRequest;
import software.amazon.awssdk.services.ec2.model.CreateCustomerGatewayResponse;
import software.amazon.awssdk.services.ec2.model.CreateDefaultSubnetRequest;
import software.amazon.awssdk.services.ec2.model.CreateDefaultSubnetResponse;
import software.amazon.awssdk.services.ec2.model.CreateDefaultVpcRequest;
import software.amazon.awssdk.services.ec2.model.CreateDefaultVpcResponse;
import software.amazon.awssdk.services.ec2.model.CreateDhcpOptionsRequest;
import software.amazon.awssdk.services.ec2.model.CreateDhcpOptionsResponse;
import software.amazon.awssdk.services.ec2.model.CreateEgressOnlyInternetGatewayRequest;
import software.amazon.awssdk.services.ec2.model.CreateEgressOnlyInternetGatewayResponse;
import software.amazon.awssdk.services.ec2.model.CreateFleetRequest;
import software.amazon.awssdk.services.ec2.model.CreateFleetResponse;
import software.amazon.awssdk.services.ec2.model.CreateFlowLogsRequest;
import software.amazon.awssdk.services.ec2.model.CreateFlowLogsResponse;
import software.amazon.awssdk.services.ec2.model.CreateFpgaImageRequest;
import software.amazon.awssdk.services.ec2.model.CreateFpgaImageResponse;
import software.amazon.awssdk.services.ec2.model.CreateImageRequest;
import software.amazon.awssdk.services.ec2.model.CreateImageResponse;
import software.amazon.awssdk.services.ec2.model.CreateInstanceConnectEndpointRequest;
import software.amazon.awssdk.services.ec2.model.CreateInstanceConnectEndpointResponse;
import software.amazon.awssdk.services.ec2.model.CreateInstanceEventWindowRequest;
import software.amazon.awssdk.services.ec2.model.CreateInstanceEventWindowResponse;
import software.amazon.awssdk.services.ec2.model.CreateInstanceExportTaskRequest;
import software.amazon.awssdk.services.ec2.model.CreateInstanceExportTaskResponse;
import software.amazon.awssdk.services.ec2.model.CreateInternetGatewayRequest;
import software.amazon.awssdk.services.ec2.model.CreateInternetGatewayResponse;
import software.amazon.awssdk.services.ec2.model.CreateIpamPoolRequest;
import software.amazon.awssdk.services.ec2.model.CreateIpamPoolResponse;
import software.amazon.awssdk.services.ec2.model.CreateIpamRequest;
import software.amazon.awssdk.services.ec2.model.CreateIpamResourceDiscoveryRequest;
import software.amazon.awssdk.services.ec2.model.CreateIpamResourceDiscoveryResponse;
import software.amazon.awssdk.services.ec2.model.CreateIpamResponse;
import software.amazon.awssdk.services.ec2.model.CreateIpamScopeRequest;
import software.amazon.awssdk.services.ec2.model.CreateIpamScopeResponse;
import software.amazon.awssdk.services.ec2.model.CreateKeyPairRequest;
import software.amazon.awssdk.services.ec2.model.CreateKeyPairResponse;
import software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateRequest;
import software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateResponse;
import software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateVersionRequest;
import software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateVersionResponse;
import software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteRequest;
import software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteResponse;
import software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest;
import software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse;
import software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableVpcAssociationRequest;
import software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableVpcAssociationResponse;
import software.amazon.awssdk.services.ec2.model.CreateManagedPrefixListRequest;
import software.amazon.awssdk.services.ec2.model.CreateManagedPrefixListResponse;
import software.amazon.awssdk.services.ec2.model.CreateNatGatewayRequest;
import software.amazon.awssdk.services.ec2.model.CreateNatGatewayResponse;
import software.amazon.awssdk.services.ec2.model.CreateNetworkAclEntryRequest;
import software.amazon.awssdk.services.ec2.model.CreateNetworkAclEntryResponse;
import software.amazon.awssdk.services.ec2.model.CreateNetworkAclRequest;
import software.amazon.awssdk.services.ec2.model.CreateNetworkAclResponse;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsAccessScopeRequest;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsAccessScopeResponse;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsPathRequest;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsPathResponse;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInterfacePermissionRequest;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInterfacePermissionResponse;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInterfaceRequest;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInterfaceResponse;
import software.amazon.awssdk.services.ec2.model.CreatePlacementGroupRequest;
import software.amazon.awssdk.services.ec2.model.CreatePlacementGroupResponse;
import software.amazon.awssdk.services.ec2.model.CreatePublicIpv4PoolRequest;
import software.amazon.awssdk.services.ec2.model.CreatePublicIpv4PoolResponse;
import software.amazon.awssdk.services.ec2.model.CreateReplaceRootVolumeTaskRequest;
import software.amazon.awssdk.services.ec2.model.CreateReplaceRootVolumeTaskResponse;
import software.amazon.awssdk.services.ec2.model.CreateReservedInstancesListingRequest;
import software.amazon.awssdk.services.ec2.model.CreateReservedInstancesListingResponse;
import software.amazon.awssdk.services.ec2.model.CreateRestoreImageTaskRequest;
import software.amazon.awssdk.services.ec2.model.CreateRestoreImageTaskResponse;
import software.amazon.awssdk.services.ec2.model.CreateRouteRequest;
import software.amazon.awssdk.services.ec2.model.CreateRouteResponse;
import software.amazon.awssdk.services.ec2.model.CreateRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.CreateRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.CreateSecurityGroupRequest;
import software.amazon.awssdk.services.ec2.model.CreateSecurityGroupResponse;
import software.amazon.awssdk.services.ec2.model.CreateSnapshotRequest;
import software.amazon.awssdk.services.ec2.model.CreateSnapshotResponse;
import software.amazon.awssdk.services.ec2.model.CreateSnapshotsRequest;
import software.amazon.awssdk.services.ec2.model.CreateSnapshotsResponse;
import software.amazon.awssdk.services.ec2.model.CreateSpotDatafeedSubscriptionRequest;
import software.amazon.awssdk.services.ec2.model.CreateSpotDatafeedSubscriptionResponse;
import software.amazon.awssdk.services.ec2.model.CreateStoreImageTaskRequest;
import software.amazon.awssdk.services.ec2.model.CreateStoreImageTaskResponse;
import software.amazon.awssdk.services.ec2.model.CreateSubnetCidrReservationRequest;
import software.amazon.awssdk.services.ec2.model.CreateSubnetCidrReservationResponse;
import software.amazon.awssdk.services.ec2.model.CreateSubnetRequest;
import software.amazon.awssdk.services.ec2.model.CreateSubnetResponse;
import software.amazon.awssdk.services.ec2.model.CreateTagsRequest;
import software.amazon.awssdk.services.ec2.model.CreateTagsResponse;
import software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorFilterRequest;
import software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorFilterResponse;
import software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorFilterRuleRequest;
import software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorFilterRuleResponse;
import software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorSessionRequest;
import software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorSessionResponse;
import software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorTargetRequest;
import software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorTargetResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayConnectPeerRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayConnectPeerResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayConnectRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayConnectResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayMulticastDomainRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayMulticastDomainResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPeeringAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPeeringAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPolicyTableRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPolicyTableResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPrefixListReferenceRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPrefixListReferenceResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteTableAnnouncementRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteTableAnnouncementResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayVpcAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayVpcAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessEndpointRequest;
import software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessEndpointResponse;
import software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessGroupRequest;
import software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessGroupResponse;
import software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessInstanceRequest;
import software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessInstanceResponse;
import software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessTrustProviderRequest;
import software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessTrustProviderResponse;
import software.amazon.awssdk.services.ec2.model.CreateVolumeRequest;
import software.amazon.awssdk.services.ec2.model.CreateVolumeResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpcEndpointConnectionNotificationRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpcEndpointConnectionNotificationResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpcEndpointRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpcEndpointResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpcEndpointServiceConfigurationRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpcEndpointServiceConfigurationResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpcPeeringConnectionRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpcPeeringConnectionResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpcRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpcResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpnConnectionRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpnConnectionResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpnConnectionRouteRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpnConnectionRouteResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpnGatewayRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpnGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeleteCarrierGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DeleteCarrierGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeleteClientVpnEndpointRequest;
import software.amazon.awssdk.services.ec2.model.DeleteClientVpnEndpointResponse;
import software.amazon.awssdk.services.ec2.model.DeleteClientVpnRouteRequest;
import software.amazon.awssdk.services.ec2.model.DeleteClientVpnRouteResponse;
import software.amazon.awssdk.services.ec2.model.DeleteCoipCidrRequest;
import software.amazon.awssdk.services.ec2.model.DeleteCoipCidrResponse;
import software.amazon.awssdk.services.ec2.model.DeleteCoipPoolRequest;
import software.amazon.awssdk.services.ec2.model.DeleteCoipPoolResponse;
import software.amazon.awssdk.services.ec2.model.DeleteCustomerGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DeleteCustomerGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeleteDhcpOptionsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteDhcpOptionsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteEgressOnlyInternetGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DeleteEgressOnlyInternetGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeleteFleetsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteFleetsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteFlowLogsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteFlowLogsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteFpgaImageRequest;
import software.amazon.awssdk.services.ec2.model.DeleteFpgaImageResponse;
import software.amazon.awssdk.services.ec2.model.DeleteInstanceConnectEndpointRequest;
import software.amazon.awssdk.services.ec2.model.DeleteInstanceConnectEndpointResponse;
import software.amazon.awssdk.services.ec2.model.DeleteInstanceEventWindowRequest;
import software.amazon.awssdk.services.ec2.model.DeleteInstanceEventWindowResponse;
import software.amazon.awssdk.services.ec2.model.DeleteInternetGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DeleteInternetGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeleteIpamPoolRequest;
import software.amazon.awssdk.services.ec2.model.DeleteIpamPoolResponse;
import software.amazon.awssdk.services.ec2.model.DeleteIpamRequest;
import software.amazon.awssdk.services.ec2.model.DeleteIpamResourceDiscoveryRequest;
import software.amazon.awssdk.services.ec2.model.DeleteIpamResourceDiscoveryResponse;
import software.amazon.awssdk.services.ec2.model.DeleteIpamResponse;
import software.amazon.awssdk.services.ec2.model.DeleteIpamScopeRequest;
import software.amazon.awssdk.services.ec2.model.DeleteIpamScopeResponse;
import software.amazon.awssdk.services.ec2.model.DeleteKeyPairRequest;
import software.amazon.awssdk.services.ec2.model.DeleteKeyPairResponse;
import software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateRequest;
import software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateResponse;
import software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteRequest;
import software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteResponse;
import software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest;
import software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse;
import software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableVpcAssociationRequest;
import software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableVpcAssociationResponse;
import software.amazon.awssdk.services.ec2.model.DeleteManagedPrefixListRequest;
import software.amazon.awssdk.services.ec2.model.DeleteManagedPrefixListResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNatGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNatGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkAclEntryRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkAclEntryResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkAclRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkAclResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAccessScopeAnalysisRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAccessScopeAnalysisResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAccessScopeRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAccessScopeResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAnalysisRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAnalysisResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsPathRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsPathResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInterfacePermissionRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInterfacePermissionResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInterfaceRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInterfaceResponse;
import software.amazon.awssdk.services.ec2.model.DeletePlacementGroupRequest;
import software.amazon.awssdk.services.ec2.model.DeletePlacementGroupResponse;
import software.amazon.awssdk.services.ec2.model.DeletePublicIpv4PoolRequest;
import software.amazon.awssdk.services.ec2.model.DeletePublicIpv4PoolResponse;
import software.amazon.awssdk.services.ec2.model.DeleteQueuedReservedInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DeleteQueuedReservedInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DeleteRouteRequest;
import software.amazon.awssdk.services.ec2.model.DeleteRouteResponse;
import software.amazon.awssdk.services.ec2.model.DeleteRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.DeleteRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.DeleteSecurityGroupRequest;
import software.amazon.awssdk.services.ec2.model.DeleteSecurityGroupResponse;
import software.amazon.awssdk.services.ec2.model.DeleteSnapshotRequest;
import software.amazon.awssdk.services.ec2.model.DeleteSnapshotResponse;
import software.amazon.awssdk.services.ec2.model.DeleteSpotDatafeedSubscriptionRequest;
import software.amazon.awssdk.services.ec2.model.DeleteSpotDatafeedSubscriptionResponse;
import software.amazon.awssdk.services.ec2.model.DeleteSubnetCidrReservationRequest;
import software.amazon.awssdk.services.ec2.model.DeleteSubnetCidrReservationResponse;
import software.amazon.awssdk.services.ec2.model.DeleteSubnetRequest;
import software.amazon.awssdk.services.ec2.model.DeleteSubnetResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTagsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTagsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRuleRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRuleResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorSessionRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorSessionResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorTargetRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorTargetResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayConnectPeerRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayConnectPeerResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayConnectRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayConnectResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayMulticastDomainRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayMulticastDomainResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPeeringAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPeeringAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPolicyTableRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPolicyTableResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPrefixListReferenceRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPrefixListReferenceResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteTableAnnouncementRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteTableAnnouncementResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayVpcAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayVpcAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessEndpointRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessEndpointResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessGroupRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessGroupResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessInstanceRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessInstanceResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessTrustProviderRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessTrustProviderResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVolumeRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVolumeResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointConnectionNotificationsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointConnectionNotificationsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointServiceConfigurationsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointServiceConfigurationsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpcPeeringConnectionRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpcPeeringConnectionResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpcRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpcResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpnConnectionRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpnConnectionResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpnConnectionRouteRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpnConnectionRouteResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpnGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpnGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeprovisionByoipCidrRequest;
import software.amazon.awssdk.services.ec2.model.DeprovisionByoipCidrResponse;
import software.amazon.awssdk.services.ec2.model.DeprovisionIpamByoasnRequest;
import software.amazon.awssdk.services.ec2.model.DeprovisionIpamByoasnResponse;
import software.amazon.awssdk.services.ec2.model.DeprovisionIpamPoolCidrRequest;
import software.amazon.awssdk.services.ec2.model.DeprovisionIpamPoolCidrResponse;
import software.amazon.awssdk.services.ec2.model.DeprovisionPublicIpv4PoolCidrRequest;
import software.amazon.awssdk.services.ec2.model.DeprovisionPublicIpv4PoolCidrResponse;
import software.amazon.awssdk.services.ec2.model.DeregisterImageRequest;
import software.amazon.awssdk.services.ec2.model.DeregisterImageResponse;
import software.amazon.awssdk.services.ec2.model.DeregisterInstanceEventNotificationAttributesRequest;
import software.amazon.awssdk.services.ec2.model.DeregisterInstanceEventNotificationAttributesResponse;
import software.amazon.awssdk.services.ec2.model.DeregisterTransitGatewayMulticastGroupMembersRequest;
import software.amazon.awssdk.services.ec2.model.DeregisterTransitGatewayMulticastGroupMembersResponse;
import software.amazon.awssdk.services.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesRequest;
import software.amazon.awssdk.services.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeAccountAttributesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeAccountAttributesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeAddressTransfersRequest;
import software.amazon.awssdk.services.ec2.model.DescribeAddressTransfersResponse;
import software.amazon.awssdk.services.ec2.model.DescribeAddressesAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeAddressesAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeAddressesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeAddressesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeAggregateIdFormatRequest;
import software.amazon.awssdk.services.ec2.model.DescribeAggregateIdFormatResponse;
import software.amazon.awssdk.services.ec2.model.DescribeAvailabilityZonesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeAvailabilityZonesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeAwsNetworkPerformanceMetricSubscriptionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeAwsNetworkPerformanceMetricSubscriptionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeBundleTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeBundleTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeByoipCidrsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeByoipCidrsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityBlockOfferingsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityBlockOfferingsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationFleetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationFleetsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeCarrierGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCarrierGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeClassicLinkInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeClassicLinkInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnAuthorizationRulesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnAuthorizationRulesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnEndpointsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnEndpointsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnRoutesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnRoutesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnTargetNetworksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnTargetNetworksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeCoipPoolsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCoipPoolsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeConversionTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeConversionTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeCustomerGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCustomerGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeDhcpOptionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeDhcpOptionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeEgressOnlyInternetGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeEgressOnlyInternetGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeElasticGpusRequest;
import software.amazon.awssdk.services.ec2.model.DescribeElasticGpusResponse;
import software.amazon.awssdk.services.ec2.model.DescribeExportImageTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeExportImageTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeExportTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeExportTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFastLaunchImagesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFastLaunchImagesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFastSnapshotRestoresRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFastSnapshotRestoresResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFleetHistoryRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFleetHistoryResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFleetInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFleetInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFleetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFleetsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFlowLogsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFlowLogsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFpgaImageAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFpgaImageAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFpgaImagesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFpgaImagesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeHostReservationOfferingsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeHostReservationOfferingsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeHostReservationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeHostReservationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeHostsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeHostsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIdFormatRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIdFormatResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIdentityIdFormatRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIdentityIdFormatResponse;
import software.amazon.awssdk.services.ec2.model.DescribeImageAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImageAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeImagesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImagesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeImportImageTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImportImageTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceConnectEndpointsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceConnectEndpointsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceCreditSpecificationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceCreditSpecificationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceEventNotificationAttributesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceEventNotificationAttributesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceEventWindowsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceEventWindowsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTopologyRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTopologyResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTypeOfferingsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTypeOfferingsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTypesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTypesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIpamByoasnRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpamByoasnResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIpamPoolsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpamPoolsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIpamResourceDiscoveriesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpamResourceDiscoveriesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIpamResourceDiscoveryAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpamResourceDiscoveryAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIpamScopesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpamScopesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIpamsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpamsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIpv6PoolsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpv6PoolsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeKeyPairsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeKeyPairsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplateVersionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplateVersionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplatesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplatesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVpcAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVpcAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTablesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTablesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfacesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfacesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLockedSnapshotsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLockedSnapshotsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeMacHostsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeMacHostsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeManagedPrefixListsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeManagedPrefixListsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeMovingAddressesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeMovingAddressesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkAclsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkAclsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAnalysesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAnalysesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsPathsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsPathsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfaceAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfaceAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacePermissionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacePermissionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesResponse;
import software.amazon.awssdk.services.ec2.model.DescribePlacementGroupsRequest;
import software.amazon.awssdk.services.ec2.model.DescribePlacementGroupsResponse;
import software.amazon.awssdk.services.ec2.model.DescribePrefixListsRequest;
import software.amazon.awssdk.services.ec2.model.DescribePrefixListsResponse;
import software.amazon.awssdk.services.ec2.model.DescribePrincipalIdFormatRequest;
import software.amazon.awssdk.services.ec2.model.DescribePrincipalIdFormatResponse;
import software.amazon.awssdk.services.ec2.model.DescribePublicIpv4PoolsRequest;
import software.amazon.awssdk.services.ec2.model.DescribePublicIpv4PoolsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeRegionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeRegionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeReplaceRootVolumeTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeReplaceRootVolumeTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesListingsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesListingsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesModificationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesModificationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesOfferingsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesOfferingsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeRouteTablesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeRouteTablesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeScheduledInstanceAvailabilityRequest;
import software.amazon.awssdk.services.ec2.model.DescribeScheduledInstanceAvailabilityResponse;
import software.amazon.awssdk.services.ec2.model.DescribeScheduledInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeScheduledInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupReferencesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupReferencesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupRulesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupRulesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotTierStatusRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotTierStatusResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotDatafeedSubscriptionRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotDatafeedSubscriptionResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestHistoryRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestHistoryResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotInstanceRequestsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotInstanceRequestsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotPriceHistoryRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotPriceHistoryResponse;
import software.amazon.awssdk.services.ec2.model.DescribeStaleSecurityGroupsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeStaleSecurityGroupsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeStoreImageTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeStoreImageTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSubnetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSubnetsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTagsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTagsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorFiltersRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorFiltersResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorSessionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorSessionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorTargetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorTargetsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayAttachmentsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayAttachmentsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayConnectPeersRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayConnectPeersResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayConnectsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayConnectsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayMulticastDomainsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayMulticastDomainsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayPeeringAttachmentsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayPeeringAttachmentsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayPolicyTablesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayPolicyTablesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayRouteTableAnnouncementsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayRouteTableAnnouncementsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayRouteTablesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayRouteTablesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayVpcAttachmentsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayVpcAttachmentsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTrunkInterfaceAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTrunkInterfaceAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessEndpointsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessEndpointsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessGroupsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessGroupsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessInstanceLoggingConfigurationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessInstanceLoggingConfigurationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessTrustProvidersRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessTrustProvidersResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVolumeAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumeAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVolumeStatusRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumeStatusResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesModificationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesModificationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkDnsSupportRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkDnsSupportResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionNotificationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionNotificationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServiceConfigurationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServiceConfigurationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicePermissionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicePermissionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcPeeringConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcPeeringConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpnConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpnConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpnGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpnGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DetachClassicLinkVpcRequest;
import software.amazon.awssdk.services.ec2.model.DetachClassicLinkVpcResponse;
import software.amazon.awssdk.services.ec2.model.DetachInternetGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DetachInternetGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DetachNetworkInterfaceRequest;
import software.amazon.awssdk.services.ec2.model.DetachNetworkInterfaceResponse;
import software.amazon.awssdk.services.ec2.model.DetachVerifiedAccessTrustProviderRequest;
import software.amazon.awssdk.services.ec2.model.DetachVerifiedAccessTrustProviderResponse;
import software.amazon.awssdk.services.ec2.model.DetachVolumeRequest;
import software.amazon.awssdk.services.ec2.model.DetachVolumeResponse;
import software.amazon.awssdk.services.ec2.model.DetachVpnGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DetachVpnGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DisableAddressTransferRequest;
import software.amazon.awssdk.services.ec2.model.DisableAddressTransferResponse;
import software.amazon.awssdk.services.ec2.model.DisableAwsNetworkPerformanceMetricSubscriptionRequest;
import software.amazon.awssdk.services.ec2.model.DisableAwsNetworkPerformanceMetricSubscriptionResponse;
import software.amazon.awssdk.services.ec2.model.DisableEbsEncryptionByDefaultRequest;
import software.amazon.awssdk.services.ec2.model.DisableEbsEncryptionByDefaultResponse;
import software.amazon.awssdk.services.ec2.model.DisableFastLaunchRequest;
import software.amazon.awssdk.services.ec2.model.DisableFastLaunchResponse;
import software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoresRequest;
import software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoresResponse;
import software.amazon.awssdk.services.ec2.model.DisableImageBlockPublicAccessRequest;
import software.amazon.awssdk.services.ec2.model.DisableImageBlockPublicAccessResponse;
import software.amazon.awssdk.services.ec2.model.DisableImageDeprecationRequest;
import software.amazon.awssdk.services.ec2.model.DisableImageDeprecationResponse;
import software.amazon.awssdk.services.ec2.model.DisableImageRequest;
import software.amazon.awssdk.services.ec2.model.DisableImageResponse;
import software.amazon.awssdk.services.ec2.model.DisableIpamOrganizationAdminAccountRequest;
import software.amazon.awssdk.services.ec2.model.DisableIpamOrganizationAdminAccountResponse;
import software.amazon.awssdk.services.ec2.model.DisableSerialConsoleAccessRequest;
import software.amazon.awssdk.services.ec2.model.DisableSerialConsoleAccessResponse;
import software.amazon.awssdk.services.ec2.model.DisableSnapshotBlockPublicAccessRequest;
import software.amazon.awssdk.services.ec2.model.DisableSnapshotBlockPublicAccessResponse;
import software.amazon.awssdk.services.ec2.model.DisableTransitGatewayRouteTablePropagationRequest;
import software.amazon.awssdk.services.ec2.model.DisableTransitGatewayRouteTablePropagationResponse;
import software.amazon.awssdk.services.ec2.model.DisableVgwRoutePropagationRequest;
import software.amazon.awssdk.services.ec2.model.DisableVgwRoutePropagationResponse;
import software.amazon.awssdk.services.ec2.model.DisableVpcClassicLinkDnsSupportRequest;
import software.amazon.awssdk.services.ec2.model.DisableVpcClassicLinkDnsSupportResponse;
import software.amazon.awssdk.services.ec2.model.DisableVpcClassicLinkRequest;
import software.amazon.awssdk.services.ec2.model.DisableVpcClassicLinkResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateAddressRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateAddressResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateClientVpnTargetNetworkRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateClientVpnTargetNetworkResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateEnclaveCertificateIamRoleRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateEnclaveCertificateIamRoleResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateIamInstanceProfileRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateIamInstanceProfileResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateInstanceEventWindowRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateInstanceEventWindowResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateIpamByoasnRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateIpamByoasnResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateIpamResourceDiscoveryRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateIpamResourceDiscoveryResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateNatGatewayAddressRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateNatGatewayAddressResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateSubnetCidrBlockRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateSubnetCidrBlockResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayMulticastDomainRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayMulticastDomainResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayPolicyTableRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayPolicyTableResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateTrunkInterfaceRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateTrunkInterfaceResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateVpcCidrBlockRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateVpcCidrBlockResponse;
import software.amazon.awssdk.services.ec2.model.Ec2Exception;
import software.amazon.awssdk.services.ec2.model.EnableAddressTransferRequest;
import software.amazon.awssdk.services.ec2.model.EnableAddressTransferResponse;
import software.amazon.awssdk.services.ec2.model.EnableAwsNetworkPerformanceMetricSubscriptionRequest;
import software.amazon.awssdk.services.ec2.model.EnableAwsNetworkPerformanceMetricSubscriptionResponse;
import software.amazon.awssdk.services.ec2.model.EnableEbsEncryptionByDefaultRequest;
import software.amazon.awssdk.services.ec2.model.EnableEbsEncryptionByDefaultResponse;
import software.amazon.awssdk.services.ec2.model.EnableFastLaunchRequest;
import software.amazon.awssdk.services.ec2.model.EnableFastLaunchResponse;
import software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoresRequest;
import software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoresResponse;
import software.amazon.awssdk.services.ec2.model.EnableImageBlockPublicAccessRequest;
import software.amazon.awssdk.services.ec2.model.EnableImageBlockPublicAccessResponse;
import software.amazon.awssdk.services.ec2.model.EnableImageDeprecationRequest;
import software.amazon.awssdk.services.ec2.model.EnableImageDeprecationResponse;
import software.amazon.awssdk.services.ec2.model.EnableImageRequest;
import software.amazon.awssdk.services.ec2.model.EnableImageResponse;
import software.amazon.awssdk.services.ec2.model.EnableIpamOrganizationAdminAccountRequest;
import software.amazon.awssdk.services.ec2.model.EnableIpamOrganizationAdminAccountResponse;
import software.amazon.awssdk.services.ec2.model.EnableReachabilityAnalyzerOrganizationSharingRequest;
import software.amazon.awssdk.services.ec2.model.EnableReachabilityAnalyzerOrganizationSharingResponse;
import software.amazon.awssdk.services.ec2.model.EnableSerialConsoleAccessRequest;
import software.amazon.awssdk.services.ec2.model.EnableSerialConsoleAccessResponse;
import software.amazon.awssdk.services.ec2.model.EnableSnapshotBlockPublicAccessRequest;
import software.amazon.awssdk.services.ec2.model.EnableSnapshotBlockPublicAccessResponse;
import software.amazon.awssdk.services.ec2.model.EnableTransitGatewayRouteTablePropagationRequest;
import software.amazon.awssdk.services.ec2.model.EnableTransitGatewayRouteTablePropagationResponse;
import software.amazon.awssdk.services.ec2.model.EnableVgwRoutePropagationRequest;
import software.amazon.awssdk.services.ec2.model.EnableVgwRoutePropagationResponse;
import software.amazon.awssdk.services.ec2.model.EnableVolumeIoRequest;
import software.amazon.awssdk.services.ec2.model.EnableVolumeIoResponse;
import software.amazon.awssdk.services.ec2.model.EnableVpcClassicLinkDnsSupportRequest;
import software.amazon.awssdk.services.ec2.model.EnableVpcClassicLinkDnsSupportResponse;
import software.amazon.awssdk.services.ec2.model.EnableVpcClassicLinkRequest;
import software.amazon.awssdk.services.ec2.model.EnableVpcClassicLinkResponse;
import software.amazon.awssdk.services.ec2.model.ExportClientVpnClientCertificateRevocationListRequest;
import software.amazon.awssdk.services.ec2.model.ExportClientVpnClientCertificateRevocationListResponse;
import software.amazon.awssdk.services.ec2.model.ExportClientVpnClientConfigurationRequest;
import software.amazon.awssdk.services.ec2.model.ExportClientVpnClientConfigurationResponse;
import software.amazon.awssdk.services.ec2.model.ExportImageRequest;
import software.amazon.awssdk.services.ec2.model.ExportImageResponse;
import software.amazon.awssdk.services.ec2.model.ExportTransitGatewayRoutesRequest;
import software.amazon.awssdk.services.ec2.model.ExportTransitGatewayRoutesResponse;
import software.amazon.awssdk.services.ec2.model.GetAssociatedEnclaveCertificateIamRolesRequest;
import software.amazon.awssdk.services.ec2.model.GetAssociatedEnclaveCertificateIamRolesResponse;
import software.amazon.awssdk.services.ec2.model.GetAssociatedIpv6PoolCidrsRequest;
import software.amazon.awssdk.services.ec2.model.GetAssociatedIpv6PoolCidrsResponse;
import software.amazon.awssdk.services.ec2.model.GetAwsNetworkPerformanceDataRequest;
import software.amazon.awssdk.services.ec2.model.GetAwsNetworkPerformanceDataResponse;
import software.amazon.awssdk.services.ec2.model.GetCapacityReservationUsageRequest;
import software.amazon.awssdk.services.ec2.model.GetCapacityReservationUsageResponse;
import software.amazon.awssdk.services.ec2.model.GetCoipPoolUsageRequest;
import software.amazon.awssdk.services.ec2.model.GetCoipPoolUsageResponse;
import software.amazon.awssdk.services.ec2.model.GetConsoleOutputRequest;
import software.amazon.awssdk.services.ec2.model.GetConsoleOutputResponse;
import software.amazon.awssdk.services.ec2.model.GetConsoleScreenshotRequest;
import software.amazon.awssdk.services.ec2.model.GetConsoleScreenshotResponse;
import software.amazon.awssdk.services.ec2.model.GetDefaultCreditSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.GetDefaultCreditSpecificationResponse;
import software.amazon.awssdk.services.ec2.model.GetEbsDefaultKmsKeyIdRequest;
import software.amazon.awssdk.services.ec2.model.GetEbsDefaultKmsKeyIdResponse;
import software.amazon.awssdk.services.ec2.model.GetEbsEncryptionByDefaultRequest;
import software.amazon.awssdk.services.ec2.model.GetEbsEncryptionByDefaultResponse;
import software.amazon.awssdk.services.ec2.model.GetFlowLogsIntegrationTemplateRequest;
import software.amazon.awssdk.services.ec2.model.GetFlowLogsIntegrationTemplateResponse;
import software.amazon.awssdk.services.ec2.model.GetGroupsForCapacityReservationRequest;
import software.amazon.awssdk.services.ec2.model.GetGroupsForCapacityReservationResponse;
import software.amazon.awssdk.services.ec2.model.GetHostReservationPurchasePreviewRequest;
import software.amazon.awssdk.services.ec2.model.GetHostReservationPurchasePreviewResponse;
import software.amazon.awssdk.services.ec2.model.GetImageBlockPublicAccessStateRequest;
import software.amazon.awssdk.services.ec2.model.GetImageBlockPublicAccessStateResponse;
import software.amazon.awssdk.services.ec2.model.GetInstanceMetadataDefaultsRequest;
import software.amazon.awssdk.services.ec2.model.GetInstanceMetadataDefaultsResponse;
import software.amazon.awssdk.services.ec2.model.GetInstanceTypesFromInstanceRequirementsRequest;
import software.amazon.awssdk.services.ec2.model.GetInstanceTypesFromInstanceRequirementsResponse;
import software.amazon.awssdk.services.ec2.model.GetInstanceUefiDataRequest;
import software.amazon.awssdk.services.ec2.model.GetInstanceUefiDataResponse;
import software.amazon.awssdk.services.ec2.model.GetIpamAddressHistoryRequest;
import software.amazon.awssdk.services.ec2.model.GetIpamAddressHistoryResponse;
import software.amazon.awssdk.services.ec2.model.GetIpamDiscoveredAccountsRequest;
import software.amazon.awssdk.services.ec2.model.GetIpamDiscoveredAccountsResponse;
import software.amazon.awssdk.services.ec2.model.GetIpamDiscoveredPublicAddressesRequest;
import software.amazon.awssdk.services.ec2.model.GetIpamDiscoveredPublicAddressesResponse;
import software.amazon.awssdk.services.ec2.model.GetIpamDiscoveredResourceCidrsRequest;
import software.amazon.awssdk.services.ec2.model.GetIpamDiscoveredResourceCidrsResponse;
import software.amazon.awssdk.services.ec2.model.GetIpamPoolAllocationsRequest;
import software.amazon.awssdk.services.ec2.model.GetIpamPoolAllocationsResponse;
import software.amazon.awssdk.services.ec2.model.GetIpamPoolCidrsRequest;
import software.amazon.awssdk.services.ec2.model.GetIpamPoolCidrsResponse;
import software.amazon.awssdk.services.ec2.model.GetIpamResourceCidrsRequest;
import software.amazon.awssdk.services.ec2.model.GetIpamResourceCidrsResponse;
import software.amazon.awssdk.services.ec2.model.GetLaunchTemplateDataRequest;
import software.amazon.awssdk.services.ec2.model.GetLaunchTemplateDataResponse;
import software.amazon.awssdk.services.ec2.model.GetManagedPrefixListAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.GetManagedPrefixListAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.GetManagedPrefixListEntriesRequest;
import software.amazon.awssdk.services.ec2.model.GetManagedPrefixListEntriesResponse;
import software.amazon.awssdk.services.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsRequest;
import software.amazon.awssdk.services.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsResponse;
import software.amazon.awssdk.services.ec2.model.GetNetworkInsightsAccessScopeContentRequest;
import software.amazon.awssdk.services.ec2.model.GetNetworkInsightsAccessScopeContentResponse;
import software.amazon.awssdk.services.ec2.model.GetPasswordDataRequest;
import software.amazon.awssdk.services.ec2.model.GetPasswordDataResponse;
import software.amazon.awssdk.services.ec2.model.GetReservedInstancesExchangeQuoteRequest;
import software.amazon.awssdk.services.ec2.model.GetReservedInstancesExchangeQuoteResponse;
import software.amazon.awssdk.services.ec2.model.GetSecurityGroupsForVpcRequest;
import software.amazon.awssdk.services.ec2.model.GetSecurityGroupsForVpcResponse;
import software.amazon.awssdk.services.ec2.model.GetSerialConsoleAccessStatusRequest;
import software.amazon.awssdk.services.ec2.model.GetSerialConsoleAccessStatusResponse;
import software.amazon.awssdk.services.ec2.model.GetSnapshotBlockPublicAccessStateRequest;
import software.amazon.awssdk.services.ec2.model.GetSnapshotBlockPublicAccessStateResponse;
import software.amazon.awssdk.services.ec2.model.GetSpotPlacementScoresRequest;
import software.amazon.awssdk.services.ec2.model.GetSpotPlacementScoresResponse;
import software.amazon.awssdk.services.ec2.model.GetSubnetCidrReservationsRequest;
import software.amazon.awssdk.services.ec2.model.GetSubnetCidrReservationsResponse;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayAttachmentPropagationsRequest;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayAttachmentPropagationsResponse;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayMulticastDomainAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayMulticastDomainAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayPolicyTableAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayPolicyTableAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayPolicyTableEntriesRequest;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayPolicyTableEntriesResponse;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayPrefixListReferencesRequest;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayPrefixListReferencesResponse;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayRouteTableAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayRouteTableAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayRouteTablePropagationsRequest;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayRouteTablePropagationsResponse;
import software.amazon.awssdk.services.ec2.model.GetVerifiedAccessEndpointPolicyRequest;
import software.amazon.awssdk.services.ec2.model.GetVerifiedAccessEndpointPolicyResponse;
import software.amazon.awssdk.services.ec2.model.GetVerifiedAccessGroupPolicyRequest;
import software.amazon.awssdk.services.ec2.model.GetVerifiedAccessGroupPolicyResponse;
import software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceSampleConfigurationRequest;
import software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceSampleConfigurationResponse;
import software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceTypesRequest;
import software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceTypesResponse;
import software.amazon.awssdk.services.ec2.model.GetVpnTunnelReplacementStatusRequest;
import software.amazon.awssdk.services.ec2.model.GetVpnTunnelReplacementStatusResponse;
import software.amazon.awssdk.services.ec2.model.ImportClientVpnClientCertificateRevocationListRequest;
import software.amazon.awssdk.services.ec2.model.ImportClientVpnClientCertificateRevocationListResponse;
import software.amazon.awssdk.services.ec2.model.ImportImageRequest;
import software.amazon.awssdk.services.ec2.model.ImportImageResponse;
import software.amazon.awssdk.services.ec2.model.ImportInstanceRequest;
import software.amazon.awssdk.services.ec2.model.ImportInstanceResponse;
import software.amazon.awssdk.services.ec2.model.ImportKeyPairRequest;
import software.amazon.awssdk.services.ec2.model.ImportKeyPairResponse;
import software.amazon.awssdk.services.ec2.model.ImportSnapshotRequest;
import software.amazon.awssdk.services.ec2.model.ImportSnapshotResponse;
import software.amazon.awssdk.services.ec2.model.ImportVolumeRequest;
import software.amazon.awssdk.services.ec2.model.ImportVolumeResponse;
import software.amazon.awssdk.services.ec2.model.ListImagesInRecycleBinRequest;
import software.amazon.awssdk.services.ec2.model.ListImagesInRecycleBinResponse;
import software.amazon.awssdk.services.ec2.model.ListSnapshotsInRecycleBinRequest;
import software.amazon.awssdk.services.ec2.model.ListSnapshotsInRecycleBinResponse;
import software.amazon.awssdk.services.ec2.model.LockSnapshotRequest;
import software.amazon.awssdk.services.ec2.model.LockSnapshotResponse;
import software.amazon.awssdk.services.ec2.model.ModifyAddressAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyAddressAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyAvailabilityZoneGroupRequest;
import software.amazon.awssdk.services.ec2.model.ModifyAvailabilityZoneGroupResponse;
import software.amazon.awssdk.services.ec2.model.ModifyCapacityReservationFleetRequest;
import software.amazon.awssdk.services.ec2.model.ModifyCapacityReservationFleetResponse;
import software.amazon.awssdk.services.ec2.model.ModifyCapacityReservationRequest;
import software.amazon.awssdk.services.ec2.model.ModifyCapacityReservationResponse;
import software.amazon.awssdk.services.ec2.model.ModifyClientVpnEndpointRequest;
import software.amazon.awssdk.services.ec2.model.ModifyClientVpnEndpointResponse;
import software.amazon.awssdk.services.ec2.model.ModifyDefaultCreditSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.ModifyDefaultCreditSpecificationResponse;
import software.amazon.awssdk.services.ec2.model.ModifyEbsDefaultKmsKeyIdRequest;
import software.amazon.awssdk.services.ec2.model.ModifyEbsDefaultKmsKeyIdResponse;
import software.amazon.awssdk.services.ec2.model.ModifyFleetRequest;
import software.amazon.awssdk.services.ec2.model.ModifyFleetResponse;
import software.amazon.awssdk.services.ec2.model.ModifyFpgaImageAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyFpgaImageAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyHostsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyHostsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyIdFormatRequest;
import software.amazon.awssdk.services.ec2.model.ModifyIdFormatResponse;
import software.amazon.awssdk.services.ec2.model.ModifyIdentityIdFormatRequest;
import software.amazon.awssdk.services.ec2.model.ModifyIdentityIdFormatResponse;
import software.amazon.awssdk.services.ec2.model.ModifyImageAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyImageAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceCapacityReservationAttributesRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceCapacityReservationAttributesResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceCreditSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceCreditSpecificationResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceEventStartTimeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceEventStartTimeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceEventWindowRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceEventWindowResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceMaintenanceOptionsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceMaintenanceOptionsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceMetadataDefaultsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceMetadataDefaultsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceMetadataOptionsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceMetadataOptionsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstancePlacementRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstancePlacementResponse;
import software.amazon.awssdk.services.ec2.model.ModifyIpamPoolRequest;
import software.amazon.awssdk.services.ec2.model.ModifyIpamPoolResponse;
import software.amazon.awssdk.services.ec2.model.ModifyIpamRequest;
import software.amazon.awssdk.services.ec2.model.ModifyIpamResourceCidrRequest;
import software.amazon.awssdk.services.ec2.model.ModifyIpamResourceCidrResponse;
import software.amazon.awssdk.services.ec2.model.ModifyIpamResourceDiscoveryRequest;
import software.amazon.awssdk.services.ec2.model.ModifyIpamResourceDiscoveryResponse;
import software.amazon.awssdk.services.ec2.model.ModifyIpamResponse;
import software.amazon.awssdk.services.ec2.model.ModifyIpamScopeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyIpamScopeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyLaunchTemplateRequest;
import software.amazon.awssdk.services.ec2.model.ModifyLaunchTemplateResponse;
import software.amazon.awssdk.services.ec2.model.ModifyLocalGatewayRouteRequest;
import software.amazon.awssdk.services.ec2.model.ModifyLocalGatewayRouteResponse;
import software.amazon.awssdk.services.ec2.model.ModifyManagedPrefixListRequest;
import software.amazon.awssdk.services.ec2.model.ModifyManagedPrefixListResponse;
import software.amazon.awssdk.services.ec2.model.ModifyNetworkInterfaceAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyNetworkInterfaceAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyPrivateDnsNameOptionsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyPrivateDnsNameOptionsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyReservedInstancesRequest;
import software.amazon.awssdk.services.ec2.model.ModifyReservedInstancesResponse;
import software.amazon.awssdk.services.ec2.model.ModifySecurityGroupRulesRequest;
import software.amazon.awssdk.services.ec2.model.ModifySecurityGroupRulesResponse;
import software.amazon.awssdk.services.ec2.model.ModifySnapshotAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifySnapshotAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifySnapshotTierRequest;
import software.amazon.awssdk.services.ec2.model.ModifySnapshotTierResponse;
import software.amazon.awssdk.services.ec2.model.ModifySpotFleetRequestRequest;
import software.amazon.awssdk.services.ec2.model.ModifySpotFleetRequestResponse;
import software.amazon.awssdk.services.ec2.model.ModifySubnetAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifySubnetAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterNetworkServicesRequest;
import software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterNetworkServicesResponse;
import software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterRuleRequest;
import software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterRuleResponse;
import software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorSessionRequest;
import software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorSessionResponse;
import software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayPrefixListReferenceRequest;
import software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayPrefixListReferenceResponse;
import software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayRequest;
import software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayResponse;
import software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayVpcAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayVpcAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointPolicyRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointPolicyResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessGroupPolicyRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessGroupPolicyResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessGroupRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessGroupResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessInstanceLoggingConfigurationRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessInstanceLoggingConfigurationResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessInstanceRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessInstanceResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessTrustProviderRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessTrustProviderResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVolumeAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVolumeAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVolumeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVolumeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointConnectionNotificationRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointConnectionNotificationResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServiceConfigurationRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServiceConfigurationResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServicePayerResponsibilityRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServicePayerResponsibilityResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServicePermissionsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServicePermissionsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcPeeringConnectionOptionsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcPeeringConnectionOptionsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcTenancyRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcTenancyResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionOptionsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionOptionsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelCertificateRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelCertificateResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelOptionsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelOptionsResponse;
import software.amazon.awssdk.services.ec2.model.MonitorInstancesRequest;
import software.amazon.awssdk.services.ec2.model.MonitorInstancesResponse;
import software.amazon.awssdk.services.ec2.model.MoveAddressToVpcRequest;
import software.amazon.awssdk.services.ec2.model.MoveAddressToVpcResponse;
import software.amazon.awssdk.services.ec2.model.MoveByoipCidrToIpamRequest;
import software.amazon.awssdk.services.ec2.model.MoveByoipCidrToIpamResponse;
import software.amazon.awssdk.services.ec2.model.ProvisionByoipCidrRequest;
import software.amazon.awssdk.services.ec2.model.ProvisionByoipCidrResponse;
import software.amazon.awssdk.services.ec2.model.ProvisionIpamByoasnRequest;
import software.amazon.awssdk.services.ec2.model.ProvisionIpamByoasnResponse;
import software.amazon.awssdk.services.ec2.model.ProvisionIpamPoolCidrRequest;
import software.amazon.awssdk.services.ec2.model.ProvisionIpamPoolCidrResponse;
import software.amazon.awssdk.services.ec2.model.ProvisionPublicIpv4PoolCidrRequest;
import software.amazon.awssdk.services.ec2.model.ProvisionPublicIpv4PoolCidrResponse;
import software.amazon.awssdk.services.ec2.model.PurchaseCapacityBlockRequest;
import software.amazon.awssdk.services.ec2.model.PurchaseCapacityBlockResponse;
import software.amazon.awssdk.services.ec2.model.PurchaseHostReservationRequest;
import software.amazon.awssdk.services.ec2.model.PurchaseHostReservationResponse;
import software.amazon.awssdk.services.ec2.model.PurchaseReservedInstancesOfferingRequest;
import software.amazon.awssdk.services.ec2.model.PurchaseReservedInstancesOfferingResponse;
import software.amazon.awssdk.services.ec2.model.PurchaseScheduledInstancesRequest;
import software.amazon.awssdk.services.ec2.model.PurchaseScheduledInstancesResponse;
import software.amazon.awssdk.services.ec2.model.RebootInstancesRequest;
import software.amazon.awssdk.services.ec2.model.RebootInstancesResponse;
import software.amazon.awssdk.services.ec2.model.RegisterImageRequest;
import software.amazon.awssdk.services.ec2.model.RegisterImageResponse;
import software.amazon.awssdk.services.ec2.model.RegisterInstanceEventNotificationAttributesRequest;
import software.amazon.awssdk.services.ec2.model.RegisterInstanceEventNotificationAttributesResponse;
import software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupMembersRequest;
import software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupMembersResponse;
import software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupSourcesRequest;
import software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupSourcesResponse;
import software.amazon.awssdk.services.ec2.model.RejectTransitGatewayMulticastDomainAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.RejectTransitGatewayMulticastDomainAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.RejectTransitGatewayPeeringAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.RejectTransitGatewayPeeringAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.RejectTransitGatewayVpcAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.RejectTransitGatewayVpcAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.RejectVpcEndpointConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.RejectVpcEndpointConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.RejectVpcPeeringConnectionRequest;
import software.amazon.awssdk.services.ec2.model.RejectVpcPeeringConnectionResponse;
import software.amazon.awssdk.services.ec2.model.ReleaseAddressRequest;
import software.amazon.awssdk.services.ec2.model.ReleaseAddressResponse;
import software.amazon.awssdk.services.ec2.model.ReleaseHostsRequest;
import software.amazon.awssdk.services.ec2.model.ReleaseHostsResponse;
import software.amazon.awssdk.services.ec2.model.ReleaseIpamPoolAllocationRequest;
import software.amazon.awssdk.services.ec2.model.ReleaseIpamPoolAllocationResponse;
import software.amazon.awssdk.services.ec2.model.ReplaceIamInstanceProfileAssociationRequest;
import software.amazon.awssdk.services.ec2.model.ReplaceIamInstanceProfileAssociationResponse;
import software.amazon.awssdk.services.ec2.model.ReplaceNetworkAclAssociationRequest;
import software.amazon.awssdk.services.ec2.model.ReplaceNetworkAclAssociationResponse;
import software.amazon.awssdk.services.ec2.model.ReplaceNetworkAclEntryRequest;
import software.amazon.awssdk.services.ec2.model.ReplaceNetworkAclEntryResponse;
import software.amazon.awssdk.services.ec2.model.ReplaceRouteRequest;
import software.amazon.awssdk.services.ec2.model.ReplaceRouteResponse;
import software.amazon.awssdk.services.ec2.model.ReplaceRouteTableAssociationRequest;
import software.amazon.awssdk.services.ec2.model.ReplaceRouteTableAssociationResponse;
import software.amazon.awssdk.services.ec2.model.ReplaceTransitGatewayRouteRequest;
import software.amazon.awssdk.services.ec2.model.ReplaceTransitGatewayRouteResponse;
import software.amazon.awssdk.services.ec2.model.ReplaceVpnTunnelRequest;
import software.amazon.awssdk.services.ec2.model.ReplaceVpnTunnelResponse;
import software.amazon.awssdk.services.ec2.model.ReportInstanceStatusRequest;
import software.amazon.awssdk.services.ec2.model.ReportInstanceStatusResponse;
import software.amazon.awssdk.services.ec2.model.RequestSpotFleetRequest;
import software.amazon.awssdk.services.ec2.model.RequestSpotFleetResponse;
import software.amazon.awssdk.services.ec2.model.RequestSpotInstancesRequest;
import software.amazon.awssdk.services.ec2.model.RequestSpotInstancesResponse;
import software.amazon.awssdk.services.ec2.model.ResetAddressAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ResetAddressAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ResetEbsDefaultKmsKeyIdRequest;
import software.amazon.awssdk.services.ec2.model.ResetEbsDefaultKmsKeyIdResponse;
import software.amazon.awssdk.services.ec2.model.ResetFpgaImageAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ResetFpgaImageAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ResetImageAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ResetImageAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ResetInstanceAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ResetInstanceAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ResetNetworkInterfaceAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ResetNetworkInterfaceAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ResetSnapshotAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ResetSnapshotAttributeResponse;
import software.amazon.awssdk.services.ec2.model.RestoreAddressToClassicRequest;
import software.amazon.awssdk.services.ec2.model.RestoreAddressToClassicResponse;
import software.amazon.awssdk.services.ec2.model.RestoreImageFromRecycleBinRequest;
import software.amazon.awssdk.services.ec2.model.RestoreImageFromRecycleBinResponse;
import software.amazon.awssdk.services.ec2.model.RestoreManagedPrefixListVersionRequest;
import software.amazon.awssdk.services.ec2.model.RestoreManagedPrefixListVersionResponse;
import software.amazon.awssdk.services.ec2.model.RestoreSnapshotFromRecycleBinRequest;
import software.amazon.awssdk.services.ec2.model.RestoreSnapshotFromRecycleBinResponse;
import software.amazon.awssdk.services.ec2.model.RestoreSnapshotTierRequest;
import software.amazon.awssdk.services.ec2.model.RestoreSnapshotTierResponse;
import software.amazon.awssdk.services.ec2.model.RevokeClientVpnIngressRequest;
import software.amazon.awssdk.services.ec2.model.RevokeClientVpnIngressResponse;
import software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupEgressRequest;
import software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupEgressResponse;
import software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupIngressRequest;
import software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupIngressResponse;
import software.amazon.awssdk.services.ec2.model.RunInstancesRequest;
import software.amazon.awssdk.services.ec2.model.RunInstancesResponse;
import software.amazon.awssdk.services.ec2.model.RunScheduledInstancesRequest;
import software.amazon.awssdk.services.ec2.model.RunScheduledInstancesResponse;
import software.amazon.awssdk.services.ec2.model.SearchLocalGatewayRoutesRequest;
import software.amazon.awssdk.services.ec2.model.SearchLocalGatewayRoutesResponse;
import software.amazon.awssdk.services.ec2.model.SearchTransitGatewayMulticastGroupsRequest;
import software.amazon.awssdk.services.ec2.model.SearchTransitGatewayMulticastGroupsResponse;
import software.amazon.awssdk.services.ec2.model.SearchTransitGatewayRoutesRequest;
import software.amazon.awssdk.services.ec2.model.SearchTransitGatewayRoutesResponse;
import software.amazon.awssdk.services.ec2.model.SendDiagnosticInterruptRequest;
import software.amazon.awssdk.services.ec2.model.SendDiagnosticInterruptResponse;
import software.amazon.awssdk.services.ec2.model.StartInstancesRequest;
import software.amazon.awssdk.services.ec2.model.StartInstancesResponse;
import software.amazon.awssdk.services.ec2.model.StartNetworkInsightsAccessScopeAnalysisRequest;
import software.amazon.awssdk.services.ec2.model.StartNetworkInsightsAccessScopeAnalysisResponse;
import software.amazon.awssdk.services.ec2.model.StartNetworkInsightsAnalysisRequest;
import software.amazon.awssdk.services.ec2.model.StartNetworkInsightsAnalysisResponse;
import software.amazon.awssdk.services.ec2.model.StartVpcEndpointServicePrivateDnsVerificationRequest;
import software.amazon.awssdk.services.ec2.model.StartVpcEndpointServicePrivateDnsVerificationResponse;
import software.amazon.awssdk.services.ec2.model.StopInstancesRequest;
import software.amazon.awssdk.services.ec2.model.StopInstancesResponse;
import software.amazon.awssdk.services.ec2.model.TerminateClientVpnConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.TerminateClientVpnConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.TerminateInstancesRequest;
import software.amazon.awssdk.services.ec2.model.TerminateInstancesResponse;
import software.amazon.awssdk.services.ec2.model.UnassignIpv6AddressesRequest;
import software.amazon.awssdk.services.ec2.model.UnassignIpv6AddressesResponse;
import software.amazon.awssdk.services.ec2.model.UnassignPrivateIpAddressesRequest;
import software.amazon.awssdk.services.ec2.model.UnassignPrivateIpAddressesResponse;
import software.amazon.awssdk.services.ec2.model.UnassignPrivateNatGatewayAddressRequest;
import software.amazon.awssdk.services.ec2.model.UnassignPrivateNatGatewayAddressResponse;
import software.amazon.awssdk.services.ec2.model.UnlockSnapshotRequest;
import software.amazon.awssdk.services.ec2.model.UnlockSnapshotResponse;
import software.amazon.awssdk.services.ec2.model.UnmonitorInstancesRequest;
import software.amazon.awssdk.services.ec2.model.UnmonitorInstancesResponse;
import software.amazon.awssdk.services.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressRequest;
import software.amazon.awssdk.services.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressResponse;
import software.amazon.awssdk.services.ec2.model.UpdateSecurityGroupRuleDescriptionsIngressRequest;
import software.amazon.awssdk.services.ec2.model.UpdateSecurityGroupRuleDescriptionsIngressResponse;
import software.amazon.awssdk.services.ec2.model.WithdrawByoipCidrRequest;
import software.amazon.awssdk.services.ec2.model.WithdrawByoipCidrResponse;
import software.amazon.awssdk.services.ec2.transform.AcceptAddressTransferRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AcceptReservedInstancesExchangeQuoteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AcceptTransitGatewayMulticastDomainAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AcceptTransitGatewayPeeringAttachmentRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AcceptTransitGatewayVpcAttachmentRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AcceptVpcEndpointConnectionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AcceptVpcPeeringConnectionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AdvertiseByoipCidrRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AllocateAddressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AllocateHostsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AllocateIpamPoolCidrRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ApplySecurityGroupsToClientVpnTargetNetworkRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssignIpv6AddressesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssignPrivateIpAddressesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssignPrivateNatGatewayAddressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateAddressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateClientVpnTargetNetworkRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateDhcpOptionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateEnclaveCertificateIamRoleRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateIamInstanceProfileRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateInstanceEventWindowRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateIpamByoasnRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateIpamResourceDiscoveryRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateNatGatewayAddressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateRouteTableRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateSubnetCidrBlockRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateTransitGatewayMulticastDomainRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateTransitGatewayPolicyTableRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateTransitGatewayRouteTableRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateTrunkInterfaceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateVpcCidrBlockRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AttachClassicLinkVpcRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AttachInternetGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AttachNetworkInterfaceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AttachVerifiedAccessTrustProviderRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AttachVolumeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AttachVpnGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AuthorizeClientVpnIngressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AuthorizeSecurityGroupEgressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AuthorizeSecurityGroupIngressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.BundleInstanceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelBundleTaskRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelCapacityReservationFleetsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelCapacityReservationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelConversionTaskRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelExportTaskRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelImageLaunchPermissionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelImportTaskRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelReservedInstancesListingRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelSpotFleetRequestsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelSpotInstanceRequestsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ConfirmProductInstanceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CopyFpgaImageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CopyImageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CopySnapshotRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateCapacityReservationFleetRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateCapacityReservationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateCarrierGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateClientVpnEndpointRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateClientVpnRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateCoipCidrRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateCoipPoolRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateCustomerGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateDefaultSubnetRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateDefaultVpcRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateDhcpOptionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateEgressOnlyInternetGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateFleetRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateFlowLogsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateFpgaImageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateImageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateInstanceConnectEndpointRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateInstanceEventWindowRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateInstanceExportTaskRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateInternetGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateIpamPoolRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateIpamRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateIpamResourceDiscoveryRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateIpamScopeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateKeyPairRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateLaunchTemplateRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateLaunchTemplateVersionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateLocalGatewayRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateLocalGatewayRouteTableRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateLocalGatewayRouteTableVpcAssociationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateManagedPrefixListRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateNatGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateNetworkAclEntryRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateNetworkAclRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateNetworkInsightsAccessScopeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateNetworkInsightsPathRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateNetworkInterfacePermissionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateNetworkInterfaceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreatePlacementGroupRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreatePublicIpv4PoolRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateReplaceRootVolumeTaskRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateReservedInstancesListingRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateRestoreImageTaskRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateRouteTableRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateSnapshotRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateSpotDatafeedSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateStoreImageTaskRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateSubnetCidrReservationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateSubnetRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTagsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTrafficMirrorFilterRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTrafficMirrorFilterRuleRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTrafficMirrorSessionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTrafficMirrorTargetRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTransitGatewayConnectPeerRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTransitGatewayConnectRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTransitGatewayMulticastDomainRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTransitGatewayPeeringAttachmentRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTransitGatewayPolicyTableRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTransitGatewayPrefixListReferenceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTransitGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTransitGatewayRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTransitGatewayRouteTableAnnouncementRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTransitGatewayRouteTableRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTransitGatewayVpcAttachmentRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVerifiedAccessEndpointRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVerifiedAccessGroupRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVerifiedAccessInstanceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVerifiedAccessTrustProviderRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVolumeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVpcEndpointConnectionNotificationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVpcEndpointRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVpcEndpointServiceConfigurationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVpcPeeringConnectionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVpcRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVpnConnectionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVpnConnectionRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVpnGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteCarrierGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteClientVpnEndpointRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteClientVpnRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteCoipCidrRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteCoipPoolRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteCustomerGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteDhcpOptionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteEgressOnlyInternetGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteFleetsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteFlowLogsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteFpgaImageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteInstanceConnectEndpointRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteInstanceEventWindowRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteInternetGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteIpamPoolRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteIpamRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteIpamResourceDiscoveryRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteIpamScopeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteKeyPairRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteLaunchTemplateRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteLaunchTemplateVersionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteLocalGatewayRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteLocalGatewayRouteTableRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteLocalGatewayRouteTableVpcAssociationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteManagedPrefixListRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteNatGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteNetworkAclEntryRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteNetworkAclRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteNetworkInsightsAccessScopeAnalysisRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteNetworkInsightsAccessScopeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteNetworkInsightsAnalysisRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteNetworkInsightsPathRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteNetworkInterfacePermissionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteNetworkInterfaceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeletePlacementGroupRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeletePublicIpv4PoolRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteQueuedReservedInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteRouteTableRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteSnapshotRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteSpotDatafeedSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteSubnetCidrReservationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteSubnetRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTagsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTrafficMirrorFilterRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTrafficMirrorFilterRuleRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTrafficMirrorSessionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTrafficMirrorTargetRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTransitGatewayConnectPeerRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTransitGatewayConnectRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTransitGatewayMulticastDomainRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTransitGatewayPeeringAttachmentRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTransitGatewayPolicyTableRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTransitGatewayPrefixListReferenceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTransitGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTransitGatewayRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTransitGatewayRouteTableAnnouncementRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTransitGatewayRouteTableRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTransitGatewayVpcAttachmentRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVerifiedAccessEndpointRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVerifiedAccessGroupRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVerifiedAccessInstanceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVerifiedAccessTrustProviderRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVolumeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVpcEndpointConnectionNotificationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVpcEndpointServiceConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVpcEndpointsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVpcPeeringConnectionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVpcRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVpnConnectionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVpnConnectionRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVpnGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeprovisionByoipCidrRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeprovisionIpamByoasnRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeprovisionIpamPoolCidrRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeprovisionPublicIpv4PoolCidrRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeregisterImageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeregisterInstanceEventNotificationAttributesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeregisterTransitGatewayMulticastGroupMembersRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeregisterTransitGatewayMulticastGroupSourcesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeAccountAttributesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeAddressTransfersRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeAddressesAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeAddressesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeAggregateIdFormatRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeAvailabilityZonesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeAwsNetworkPerformanceMetricSubscriptionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeBundleTasksRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeByoipCidrsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeCapacityBlockOfferingsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeCapacityReservationFleetsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeCapacityReservationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeCarrierGatewaysRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeClassicLinkInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeClientVpnAuthorizationRulesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeClientVpnConnectionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeClientVpnEndpointsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeClientVpnRoutesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeClientVpnTargetNetworksRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeCoipPoolsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeConversionTasksRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeCustomerGatewaysRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeDhcpOptionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeEgressOnlyInternetGatewaysRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeElasticGpusRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeExportImageTasksRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeExportTasksRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeFastLaunchImagesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeFastSnapshotRestoresRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeFleetHistoryRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeFleetInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeFleetsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeFlowLogsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeFpgaImageAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeFpgaImagesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeHostReservationOfferingsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeHostReservationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeHostsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeIamInstanceProfileAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeIdFormatRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeIdentityIdFormatRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeImageAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeImagesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeImportImageTasksRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeImportSnapshotTasksRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeInstanceAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeInstanceConnectEndpointsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeInstanceCreditSpecificationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeInstanceEventNotificationAttributesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeInstanceEventWindowsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeInstanceStatusRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeInstanceTopologyRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeInstanceTypeOfferingsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeInstanceTypesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeInternetGatewaysRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeIpamByoasnRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeIpamPoolsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeIpamResourceDiscoveriesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeIpamResourceDiscoveryAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeIpamScopesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeIpamsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeIpv6PoolsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeKeyPairsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeLaunchTemplateVersionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeLaunchTemplatesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeLocalGatewayRouteTableVpcAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeLocalGatewayRouteTablesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeLocalGatewayVirtualInterfaceGroupsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeLocalGatewayVirtualInterfacesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeLocalGatewaysRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeLockedSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeMacHostsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeManagedPrefixListsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeMovingAddressesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeNatGatewaysRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeNetworkAclsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeNetworkInsightsAccessScopeAnalysesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeNetworkInsightsAccessScopesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeNetworkInsightsAnalysesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeNetworkInsightsPathsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeNetworkInterfaceAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeNetworkInterfacePermissionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeNetworkInterfacesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribePlacementGroupsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribePrefixListsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribePrincipalIdFormatRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribePublicIpv4PoolsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeRegionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeReplaceRootVolumeTasksRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeReservedInstancesListingsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeReservedInstancesModificationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeReservedInstancesOfferingsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeReservedInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeRouteTablesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeScheduledInstanceAvailabilityRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeScheduledInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSecurityGroupReferencesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSecurityGroupRulesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSecurityGroupsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSnapshotAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSnapshotTierStatusRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSpotDatafeedSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSpotFleetInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSpotFleetRequestHistoryRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSpotFleetRequestsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSpotInstanceRequestsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSpotPriceHistoryRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeStaleSecurityGroupsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeStoreImageTasksRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSubnetsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTagsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTrafficMirrorFiltersRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTrafficMirrorSessionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTrafficMirrorTargetsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTransitGatewayAttachmentsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTransitGatewayConnectPeersRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTransitGatewayConnectsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTransitGatewayMulticastDomainsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTransitGatewayPeeringAttachmentsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTransitGatewayPolicyTablesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTransitGatewayRouteTableAnnouncementsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTransitGatewayRouteTablesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTransitGatewayVpcAttachmentsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTransitGatewaysRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTrunkInterfaceAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVerifiedAccessEndpointsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVerifiedAccessGroupsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVerifiedAccessInstanceLoggingConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVerifiedAccessInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVerifiedAccessTrustProvidersRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVolumeAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVolumeStatusRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVolumesModificationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVolumesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcClassicLinkDnsSupportRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcClassicLinkRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcEndpointConnectionNotificationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcEndpointConnectionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcEndpointServiceConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcEndpointServicePermissionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcEndpointServicesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcEndpointsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcPeeringConnectionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpnConnectionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpnGatewaysRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DetachClassicLinkVpcRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DetachInternetGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DetachNetworkInterfaceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DetachVerifiedAccessTrustProviderRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DetachVolumeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DetachVpnGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableAddressTransferRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableAwsNetworkPerformanceMetricSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableEbsEncryptionByDefaultRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableFastLaunchRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableFastSnapshotRestoresRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableImageBlockPublicAccessRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableImageDeprecationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableImageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableIpamOrganizationAdminAccountRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableSerialConsoleAccessRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableSnapshotBlockPublicAccessRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableTransitGatewayRouteTablePropagationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableVgwRoutePropagationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableVpcClassicLinkDnsSupportRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableVpcClassicLinkRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateAddressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateClientVpnTargetNetworkRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateEnclaveCertificateIamRoleRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateIamInstanceProfileRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateInstanceEventWindowRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateIpamByoasnRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateIpamResourceDiscoveryRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateNatGatewayAddressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateRouteTableRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateSubnetCidrBlockRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateTransitGatewayMulticastDomainRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateTransitGatewayPolicyTableRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateTransitGatewayRouteTableRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateTrunkInterfaceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateVpcCidrBlockRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableAddressTransferRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableAwsNetworkPerformanceMetricSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableEbsEncryptionByDefaultRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableFastLaunchRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableFastSnapshotRestoresRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableImageBlockPublicAccessRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableImageDeprecationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableImageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableIpamOrganizationAdminAccountRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableReachabilityAnalyzerOrganizationSharingRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableSerialConsoleAccessRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableSnapshotBlockPublicAccessRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableTransitGatewayRouteTablePropagationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableVgwRoutePropagationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableVolumeIoRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableVpcClassicLinkDnsSupportRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableVpcClassicLinkRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ExportClientVpnClientCertificateRevocationListRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ExportClientVpnClientConfigurationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ExportImageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ExportTransitGatewayRoutesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetAssociatedEnclaveCertificateIamRolesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetAssociatedIpv6PoolCidrsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetAwsNetworkPerformanceDataRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetCapacityReservationUsageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetCoipPoolUsageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetConsoleOutputRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetConsoleScreenshotRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetDefaultCreditSpecificationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetEbsDefaultKmsKeyIdRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetEbsEncryptionByDefaultRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetFlowLogsIntegrationTemplateRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetGroupsForCapacityReservationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetHostReservationPurchasePreviewRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetImageBlockPublicAccessStateRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetInstanceMetadataDefaultsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetInstanceTypesFromInstanceRequirementsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetInstanceUefiDataRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetIpamAddressHistoryRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetIpamDiscoveredAccountsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetIpamDiscoveredPublicAddressesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetIpamDiscoveredResourceCidrsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetIpamPoolAllocationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetIpamPoolCidrsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetIpamResourceCidrsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetLaunchTemplateDataRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetManagedPrefixListAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetManagedPrefixListEntriesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetNetworkInsightsAccessScopeAnalysisFindingsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetNetworkInsightsAccessScopeContentRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetPasswordDataRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetReservedInstancesExchangeQuoteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetSecurityGroupsForVpcRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetSerialConsoleAccessStatusRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetSnapshotBlockPublicAccessStateRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetSpotPlacementScoresRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetSubnetCidrReservationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetTransitGatewayAttachmentPropagationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetTransitGatewayMulticastDomainAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetTransitGatewayPolicyTableAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetTransitGatewayPolicyTableEntriesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetTransitGatewayPrefixListReferencesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetTransitGatewayRouteTableAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetTransitGatewayRouteTablePropagationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetVerifiedAccessEndpointPolicyRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetVerifiedAccessGroupPolicyRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetVpnConnectionDeviceSampleConfigurationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetVpnConnectionDeviceTypesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetVpnTunnelReplacementStatusRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ImportClientVpnClientCertificateRevocationListRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ImportImageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ImportInstanceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ImportKeyPairRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ImportSnapshotRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ImportVolumeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ListImagesInRecycleBinRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ListSnapshotsInRecycleBinRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.LockSnapshotRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyAddressAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyAvailabilityZoneGroupRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyCapacityReservationFleetRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyCapacityReservationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyClientVpnEndpointRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyDefaultCreditSpecificationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyEbsDefaultKmsKeyIdRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyFleetRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyFpgaImageAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyHostsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyIdFormatRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyIdentityIdFormatRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyImageAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyInstanceAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyInstanceCapacityReservationAttributesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyInstanceCreditSpecificationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyInstanceEventStartTimeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyInstanceEventWindowRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyInstanceMaintenanceOptionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyInstanceMetadataDefaultsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyInstanceMetadataOptionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyInstancePlacementRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyIpamPoolRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyIpamRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyIpamResourceCidrRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyIpamResourceDiscoveryRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyIpamScopeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyLaunchTemplateRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyLocalGatewayRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyManagedPrefixListRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyNetworkInterfaceAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyPrivateDnsNameOptionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyReservedInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifySecurityGroupRulesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifySnapshotAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifySnapshotTierRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifySpotFleetRequestRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifySubnetAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyTrafficMirrorFilterNetworkServicesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyTrafficMirrorFilterRuleRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyTrafficMirrorSessionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyTransitGatewayPrefixListReferenceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyTransitGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyTransitGatewayVpcAttachmentRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVerifiedAccessEndpointPolicyRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVerifiedAccessEndpointRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVerifiedAccessGroupPolicyRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVerifiedAccessGroupRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVerifiedAccessInstanceLoggingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVerifiedAccessInstanceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVerifiedAccessTrustProviderRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVolumeAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVolumeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpcAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpcEndpointConnectionNotificationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpcEndpointRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpcEndpointServiceConfigurationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpcEndpointServicePayerResponsibilityRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpcEndpointServicePermissionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpcPeeringConnectionOptionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpcTenancyRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpnConnectionOptionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpnConnectionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpnTunnelCertificateRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpnTunnelOptionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.MonitorInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.MoveAddressToVpcRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.MoveByoipCidrToIpamRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ProvisionByoipCidrRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ProvisionIpamByoasnRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ProvisionIpamPoolCidrRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ProvisionPublicIpv4PoolCidrRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.PurchaseCapacityBlockRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.PurchaseHostReservationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.PurchaseReservedInstancesOfferingRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.PurchaseScheduledInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RebootInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RegisterImageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RegisterInstanceEventNotificationAttributesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RegisterTransitGatewayMulticastGroupMembersRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RegisterTransitGatewayMulticastGroupSourcesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RejectTransitGatewayMulticastDomainAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RejectTransitGatewayPeeringAttachmentRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RejectTransitGatewayVpcAttachmentRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RejectVpcEndpointConnectionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RejectVpcPeeringConnectionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ReleaseAddressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ReleaseHostsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ReleaseIpamPoolAllocationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ReplaceIamInstanceProfileAssociationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ReplaceNetworkAclAssociationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ReplaceNetworkAclEntryRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ReplaceRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ReplaceRouteTableAssociationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ReplaceTransitGatewayRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ReplaceVpnTunnelRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ReportInstanceStatusRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RequestSpotFleetRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RequestSpotInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ResetAddressAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ResetEbsDefaultKmsKeyIdRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ResetFpgaImageAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ResetImageAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ResetInstanceAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ResetNetworkInterfaceAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ResetSnapshotAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RestoreAddressToClassicRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RestoreImageFromRecycleBinRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RestoreManagedPrefixListVersionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RestoreSnapshotFromRecycleBinRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RestoreSnapshotTierRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RevokeClientVpnIngressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RevokeSecurityGroupEgressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RevokeSecurityGroupIngressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RunInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RunScheduledInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.SearchLocalGatewayRoutesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.SearchTransitGatewayMulticastGroupsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.SearchTransitGatewayRoutesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.SendDiagnosticInterruptRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.StartInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.StartNetworkInsightsAccessScopeAnalysisRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.StartNetworkInsightsAnalysisRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.StartVpcEndpointServicePrivateDnsVerificationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.StopInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.TerminateClientVpnConnectionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.TerminateInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.UnassignIpv6AddressesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.UnassignPrivateIpAddressesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.UnassignPrivateNatGatewayAddressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.UnlockSnapshotRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.UnmonitorInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.UpdateSecurityGroupRuleDescriptionsEgressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.UpdateSecurityGroupRuleDescriptionsIngressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.WithdrawByoipCidrRequestMarshaller;
import software.amazon.awssdk.services.ec2.waiters.Ec2AsyncWaiter;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link Ec2AsyncClient}.
 *
 * @see Ec2AsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultEc2AsyncClient implements Ec2AsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultEc2AsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.EC2).build();

    private final AsyncClientHandler clientHandler;

    private final AwsEc2ProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final ScheduledExecutorService executorService;

    protected DefaultEc2AsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init();
        this.executorService = clientConfiguration.option(SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
    }

    /**
     * <p>
     * Accepts an Elastic IP address transfer. For more information, see <a href=
     * "https://docs.aws.amazon.com/vpc/latest/userguide/vpc-eips.html#using-instance-addressing-eips-transfer-accept"
     * >Accept a transferred Elastic IP address</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param acceptAddressTransferRequest
     * @return A Java Future containing the result of the AcceptAddressTransfer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AcceptAddressTransfer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptAddressTransfer" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AcceptAddressTransferResponse> acceptAddressTransfer(
            AcceptAddressTransferRequest acceptAddressTransferRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(acceptAddressTransferRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, acceptAddressTransferRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptAddressTransfer");

            HttpResponseHandler<AcceptAddressTransferResponse> responseHandler = protocolFactory
                    .createResponseHandler(AcceptAddressTransferResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AcceptAddressTransferResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AcceptAddressTransferRequest, AcceptAddressTransferResponse>()
                            .withOperationName("AcceptAddressTransfer").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AcceptAddressTransferRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(acceptAddressTransferRequest));
            CompletableFuture<AcceptAddressTransferResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Accepts the Convertible Reserved Instance exchange quote described in the
     * <a>GetReservedInstancesExchangeQuote</a> call.
     * </p>
     *
     * @param acceptReservedInstancesExchangeQuoteRequest
     *        Contains the parameters for accepting the quote.
     * @return A Java Future containing the result of the AcceptReservedInstancesExchangeQuote operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AcceptReservedInstancesExchangeQuote
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptReservedInstancesExchangeQuote"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AcceptReservedInstancesExchangeQuoteResponse> acceptReservedInstancesExchangeQuote(
            AcceptReservedInstancesExchangeQuoteRequest acceptReservedInstancesExchangeQuoteRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(acceptReservedInstancesExchangeQuoteRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                acceptReservedInstancesExchangeQuoteRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptReservedInstancesExchangeQuote");

            HttpResponseHandler<AcceptReservedInstancesExchangeQuoteResponse> responseHandler = protocolFactory
                    .createResponseHandler(AcceptReservedInstancesExchangeQuoteResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AcceptReservedInstancesExchangeQuoteResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AcceptReservedInstancesExchangeQuoteRequest, AcceptReservedInstancesExchangeQuoteResponse>()
                            .withOperationName("AcceptReservedInstancesExchangeQuote").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AcceptReservedInstancesExchangeQuoteRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(acceptReservedInstancesExchangeQuoteRequest));
            CompletableFuture<AcceptReservedInstancesExchangeQuoteResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Accepts a request to associate subnets with a transit gateway multicast domain.
     * </p>
     *
     * @param acceptTransitGatewayMulticastDomainAssociationsRequest
     * @return A Java Future containing the result of the AcceptTransitGatewayMulticastDomainAssociations operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AcceptTransitGatewayMulticastDomainAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayMulticastDomainAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AcceptTransitGatewayMulticastDomainAssociationsResponse> acceptTransitGatewayMulticastDomainAssociations(
            AcceptTransitGatewayMulticastDomainAssociationsRequest acceptTransitGatewayMulticastDomainAssociationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                acceptTransitGatewayMulticastDomainAssociationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                acceptTransitGatewayMulticastDomainAssociationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptTransitGatewayMulticastDomainAssociations");

            HttpResponseHandler<AcceptTransitGatewayMulticastDomainAssociationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(AcceptTransitGatewayMulticastDomainAssociationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AcceptTransitGatewayMulticastDomainAssociationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AcceptTransitGatewayMulticastDomainAssociationsRequest, AcceptTransitGatewayMulticastDomainAssociationsResponse>()
                            .withOperationName("AcceptTransitGatewayMulticastDomainAssociations")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AcceptTransitGatewayMulticastDomainAssociationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(acceptTransitGatewayMulticastDomainAssociationsRequest));
            CompletableFuture<AcceptTransitGatewayMulticastDomainAssociationsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Accepts a transit gateway peering attachment request. The peering attachment must be in the
     * <code>pendingAcceptance</code> state.
     * </p>
     *
     * @param acceptTransitGatewayPeeringAttachmentRequest
     * @return A Java Future containing the result of the AcceptTransitGatewayPeeringAttachment operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AcceptTransitGatewayPeeringAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayPeeringAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AcceptTransitGatewayPeeringAttachmentResponse> acceptTransitGatewayPeeringAttachment(
            AcceptTransitGatewayPeeringAttachmentRequest acceptTransitGatewayPeeringAttachmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(acceptTransitGatewayPeeringAttachmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                acceptTransitGatewayPeeringAttachmentRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptTransitGatewayPeeringAttachment");

            HttpResponseHandler<AcceptTransitGatewayPeeringAttachmentResponse> responseHandler = protocolFactory
                    .createResponseHandler(AcceptTransitGatewayPeeringAttachmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AcceptTransitGatewayPeeringAttachmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AcceptTransitGatewayPeeringAttachmentRequest, AcceptTransitGatewayPeeringAttachmentResponse>()
                            .withOperationName("AcceptTransitGatewayPeeringAttachment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AcceptTransitGatewayPeeringAttachmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(acceptTransitGatewayPeeringAttachmentRequest));
            CompletableFuture<AcceptTransitGatewayPeeringAttachmentResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Accepts a request to attach a VPC to a transit gateway.
     * </p>
     * <p>
     * The VPC attachment must be in the <code>pendingAcceptance</code> state. Use
     * <a>DescribeTransitGatewayVpcAttachments</a> to view your pending VPC attachment requests. Use
     * <a>RejectTransitGatewayVpcAttachment</a> to reject a VPC attachment request.
     * </p>
     *
     * @param acceptTransitGatewayVpcAttachmentRequest
     * @return A Java Future containing the result of the AcceptTransitGatewayVpcAttachment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AcceptTransitGatewayVpcAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayVpcAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AcceptTransitGatewayVpcAttachmentResponse> acceptTransitGatewayVpcAttachment(
            AcceptTransitGatewayVpcAttachmentRequest acceptTransitGatewayVpcAttachmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(acceptTransitGatewayVpcAttachmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                acceptTransitGatewayVpcAttachmentRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptTransitGatewayVpcAttachment");

            HttpResponseHandler<AcceptTransitGatewayVpcAttachmentResponse> responseHandler = protocolFactory
                    .createResponseHandler(AcceptTransitGatewayVpcAttachmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AcceptTransitGatewayVpcAttachmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AcceptTransitGatewayVpcAttachmentRequest, AcceptTransitGatewayVpcAttachmentResponse>()
                            .withOperationName("AcceptTransitGatewayVpcAttachment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AcceptTransitGatewayVpcAttachmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(acceptTransitGatewayVpcAttachmentRequest));
            CompletableFuture<AcceptTransitGatewayVpcAttachmentResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Accepts connection requests to your VPC endpoint service.
     * </p>
     *
     * @param acceptVpcEndpointConnectionsRequest
     * @return A Java Future containing the result of the AcceptVpcEndpointConnections operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AcceptVpcEndpointConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcEndpointConnections"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AcceptVpcEndpointConnectionsResponse> acceptVpcEndpointConnections(
            AcceptVpcEndpointConnectionsRequest acceptVpcEndpointConnectionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(acceptVpcEndpointConnectionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, acceptVpcEndpointConnectionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptVpcEndpointConnections");

            HttpResponseHandler<AcceptVpcEndpointConnectionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(AcceptVpcEndpointConnectionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AcceptVpcEndpointConnectionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AcceptVpcEndpointConnectionsRequest, AcceptVpcEndpointConnectionsResponse>()
                            .withOperationName("AcceptVpcEndpointConnections").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AcceptVpcEndpointConnectionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(acceptVpcEndpointConnectionsRequest));
            CompletableFuture<AcceptVpcEndpointConnectionsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Accept a VPC peering connection request. To accept a request, the VPC peering connection must be in the
     * <code>pending-acceptance</code> state, and you must be the owner of the peer VPC. Use
     * <a>DescribeVpcPeeringConnections</a> to view your outstanding VPC peering connection requests.
     * </p>
     * <p>
     * For an inter-Region VPC peering connection request, you must accept the VPC peering connection in the Region of
     * the accepter VPC.
     * </p>
     *
     * @param acceptVpcPeeringConnectionRequest
     * @return A Java Future containing the result of the AcceptVpcPeeringConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AcceptVpcPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AcceptVpcPeeringConnectionResponse> acceptVpcPeeringConnection(
            AcceptVpcPeeringConnectionRequest acceptVpcPeeringConnectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(acceptVpcPeeringConnectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, acceptVpcPeeringConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptVpcPeeringConnection");

            HttpResponseHandler<AcceptVpcPeeringConnectionResponse> responseHandler = protocolFactory
                    .createResponseHandler(AcceptVpcPeeringConnectionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AcceptVpcPeeringConnectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AcceptVpcPeeringConnectionRequest, AcceptVpcPeeringConnectionResponse>()
                            .withOperationName("AcceptVpcPeeringConnection").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AcceptVpcPeeringConnectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(acceptVpcPeeringConnectionRequest));
            CompletableFuture<AcceptVpcPeeringConnectionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Advertises an IPv4 or IPv6 address range that is provisioned for use with your Amazon Web Services resources
     * through bring your own IP addresses (BYOIP).
     * </p>
     * <p>
     * You can perform this operation at most once every 10 seconds, even if you specify different address ranges each
     * time.
     * </p>
     * <p>
     * We recommend that you stop advertising the BYOIP CIDR from other locations when you advertise it from Amazon Web
     * Services. To minimize down time, you can configure your Amazon Web Services resources to use an address from a
     * BYOIP CIDR before it is advertised, and then simultaneously stop advertising it from the current location and
     * start advertising it through Amazon Web Services.
     * </p>
     * <p>
     * It can take a few minutes before traffic to the specified addresses starts routing to Amazon Web Services because
     * of BGP propagation delays.
     * </p>
     * <p>
     * To stop advertising the BYOIP CIDR, use <a>WithdrawByoipCidr</a>.
     * </p>
     *
     * @param advertiseByoipCidrRequest
     * @return A Java Future containing the result of the AdvertiseByoipCidr operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AdvertiseByoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AdvertiseByoipCidr" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AdvertiseByoipCidrResponse> advertiseByoipCidr(AdvertiseByoipCidrRequest advertiseByoipCidrRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(advertiseByoipCidrRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, advertiseByoipCidrRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdvertiseByoipCidr");

            HttpResponseHandler<AdvertiseByoipCidrResponse> responseHandler = protocolFactory
                    .createResponseHandler(AdvertiseByoipCidrResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AdvertiseByoipCidrResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdvertiseByoipCidrRequest, AdvertiseByoipCidrResponse>()
                            .withOperationName("AdvertiseByoipCidr").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdvertiseByoipCidrRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(advertiseByoipCidrRequest));
            CompletableFuture<AdvertiseByoipCidrResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Allocates an Elastic IP address to your Amazon Web Services account. After you allocate the Elastic IP address
     * you can associate it with an instance or network interface. After you release an Elastic IP address, it is
     * released to the IP address pool and can be allocated to a different Amazon Web Services account.
     * </p>
     * <p>
     * You can allocate an Elastic IP address from an address pool owned by Amazon Web Services or from an address pool
     * created from a public IPv4 address range that you have brought to Amazon Web Services for use with your Amazon
     * Web Services resources using bring your own IP addresses (BYOIP). For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">Bring Your Own IP Addresses (BYOIP)</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * If you release an Elastic IP address, you might be able to recover it. You cannot recover an Elastic IP address
     * that you released after it is allocated to another Amazon Web Services account. To attempt to recover an Elastic
     * IP address that you released, specify it in this operation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * You can allocate a carrier IP address which is a public IP address from a telecommunication carrier, to a network
     * interface which resides in a subnet in a Wavelength Zone (for example an EC2 instance).
     * </p>
     *
     * @param allocateAddressRequest
     * @return A Java Future containing the result of the AllocateAddress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AllocateAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateAddress" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AllocateAddressResponse> allocateAddress(AllocateAddressRequest allocateAddressRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(allocateAddressRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, allocateAddressRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AllocateAddress");

            HttpResponseHandler<AllocateAddressResponse> responseHandler = protocolFactory
                    .createResponseHandler(AllocateAddressResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AllocateAddressResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AllocateAddressRequest, AllocateAddressResponse>()
                            .withOperationName("AllocateAddress").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AllocateAddressRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(allocateAddressRequest));
            CompletableFuture<AllocateAddressResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Allocates a Dedicated Host to your account. At a minimum, specify the supported instance type or instance family,
     * the Availability Zone in which to allocate the host, and the number of hosts to allocate.
     * </p>
     *
     * @param allocateHostsRequest
     * @return A Java Future containing the result of the AllocateHosts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AllocateHosts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateHosts" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AllocateHostsResponse> allocateHosts(AllocateHostsRequest allocateHostsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(allocateHostsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, allocateHostsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AllocateHosts");

            HttpResponseHandler<AllocateHostsResponse> responseHandler = protocolFactory
                    .createResponseHandler(AllocateHostsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AllocateHostsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AllocateHostsRequest, AllocateHostsResponse>()
                            .withOperationName("AllocateHosts").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AllocateHostsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(allocateHostsRequest));
            CompletableFuture<AllocateHostsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Allocate a CIDR from an IPAM pool. The Region you use should be the IPAM pool locale. The locale is the Amazon
     * Web Services Region where this IPAM pool is available for allocations.
     * </p>
     * <p>
     * In IPAM, an allocation is a CIDR assignment from an IPAM pool to another IPAM pool or to a resource. For more
     * information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/allocate-cidrs-ipam.html">Allocate
     * CIDRs</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This action creates an allocation with strong consistency. The returned CIDR will not overlap with any other
     * allocations from the same pool.
     * </p>
     * </note>
     *
     * @param allocateIpamPoolCidrRequest
     * @return A Java Future containing the result of the AllocateIpamPoolCidr operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AllocateIpamPoolCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateIpamPoolCidr" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AllocateIpamPoolCidrResponse> allocateIpamPoolCidr(
            AllocateIpamPoolCidrRequest allocateIpamPoolCidrRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(allocateIpamPoolCidrRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, allocateIpamPoolCidrRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AllocateIpamPoolCidr");

            HttpResponseHandler<AllocateIpamPoolCidrResponse> responseHandler = protocolFactory
                    .createResponseHandler(AllocateIpamPoolCidrResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AllocateIpamPoolCidrResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AllocateIpamPoolCidrRequest, AllocateIpamPoolCidrResponse>()
                            .withOperationName("AllocateIpamPoolCidr").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AllocateIpamPoolCidrRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(allocateIpamPoolCidrRequest));
            CompletableFuture<AllocateIpamPoolCidrResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Applies a security group to the association between the target network and the Client VPN endpoint. This action
     * replaces the existing security groups with the specified security groups.
     * </p>
     *
     * @param applySecurityGroupsToClientVpnTargetNetworkRequest
     * @return A Java Future containing the result of the ApplySecurityGroupsToClientVpnTargetNetwork operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.ApplySecurityGroupsToClientVpnTargetNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ApplySecurityGroupsToClientVpnTargetNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ApplySecurityGroupsToClientVpnTargetNetworkResponse> applySecurityGroupsToClientVpnTargetNetwork(
            ApplySecurityGroupsToClientVpnTargetNetworkRequest applySecurityGroupsToClientVpnTargetNetworkRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                applySecurityGroupsToClientVpnTargetNetworkRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                applySecurityGroupsToClientVpnTargetNetworkRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ApplySecurityGroupsToClientVpnTargetNetwork");

            HttpResponseHandler<ApplySecurityGroupsToClientVpnTargetNetworkResponse> responseHandler = protocolFactory
                    .createResponseHandler(ApplySecurityGroupsToClientVpnTargetNetworkResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ApplySecurityGroupsToClientVpnTargetNetworkResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ApplySecurityGroupsToClientVpnTargetNetworkRequest, ApplySecurityGroupsToClientVpnTargetNetworkResponse>()
                            .withOperationName("ApplySecurityGroupsToClientVpnTargetNetwork")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ApplySecurityGroupsToClientVpnTargetNetworkRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(applySecurityGroupsToClientVpnTargetNetworkRequest));
            CompletableFuture<ApplySecurityGroupsToClientVpnTargetNetworkResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Assigns one or more IPv6 addresses to the specified network interface. You can specify one or more specific IPv6
     * addresses, or you can specify the number of IPv6 addresses to be automatically assigned from within the subnet's
     * IPv6 CIDR block range. You can assign as many IPv6 addresses to a network interface as you can assign private
     * IPv4 addresses, and the limit varies per instance type. For information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI">IP Addresses Per
     * Network Interface Per Instance Type</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * You must specify either the IPv6 addresses or the IPv6 address count in the request.
     * </p>
     * <p>
     * You can optionally use Prefix Delegation on the network interface. You must specify either the IPV6 Prefix
     * Delegation prefixes, or the IPv6 Prefix Delegation count. For information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html"> Assigning prefixes to Amazon EC2
     * network interfaces</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param assignIpv6AddressesRequest
     * @return A Java Future containing the result of the AssignIpv6Addresses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssignIpv6Addresses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignIpv6Addresses" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AssignIpv6AddressesResponse> assignIpv6Addresses(
            AssignIpv6AddressesRequest assignIpv6AddressesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(assignIpv6AddressesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, assignIpv6AddressesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssignIpv6Addresses");

            HttpResponseHandler<AssignIpv6AddressesResponse> responseHandler = protocolFactory
                    .createResponseHandler(AssignIpv6AddressesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AssignIpv6AddressesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssignIpv6AddressesRequest, AssignIpv6AddressesResponse>()
                            .withOperationName("AssignIpv6Addresses").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssignIpv6AddressesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(assignIpv6AddressesRequest));
            CompletableFuture<AssignIpv6AddressesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Assigns one or more secondary private IP addresses to the specified network interface.
     * </p>
     * <p>
     * You can specify one or more specific secondary IP addresses, or you can specify the number of secondary IP
     * addresses to be automatically assigned within the subnet's CIDR block range. The number of secondary IP addresses
     * that you can assign to an instance varies by instance type. For information about instance types, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>. For more information about Elastic IP addresses, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * When you move a secondary private IP address to another network interface, any Elastic IP address that is
     * associated with the IP address is also moved.
     * </p>
     * <p>
     * Remapping an IP address is an asynchronous operation. When you move an IP address from one network interface to
     * another, check <code>network/interfaces/macs/mac/local-ipv4s</code> in the instance metadata to confirm that the
     * remapping is complete.
     * </p>
     * <p>
     * You must specify either the IP addresses or the IP address count in the request.
     * </p>
     * <p>
     * You can optionally use Prefix Delegation on the network interface. You must specify either the IPv4 Prefix
     * Delegation prefixes, or the IPv4 Prefix Delegation count. For information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html"> Assigning prefixes to Amazon EC2
     * network interfaces</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param assignPrivateIpAddressesRequest
     *        Contains the parameters for AssignPrivateIpAddresses.
     * @return A Java Future containing the result of the AssignPrivateIpAddresses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssignPrivateIpAddresses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignPrivateIpAddresses" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AssignPrivateIpAddressesResponse> assignPrivateIpAddresses(
            AssignPrivateIpAddressesRequest assignPrivateIpAddressesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(assignPrivateIpAddressesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, assignPrivateIpAddressesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssignPrivateIpAddresses");

            HttpResponseHandler<AssignPrivateIpAddressesResponse> responseHandler = protocolFactory
                    .createResponseHandler(AssignPrivateIpAddressesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AssignPrivateIpAddressesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssignPrivateIpAddressesRequest, AssignPrivateIpAddressesResponse>()
                            .withOperationName("AssignPrivateIpAddresses").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssignPrivateIpAddressesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(assignPrivateIpAddressesRequest));
            CompletableFuture<AssignPrivateIpAddressesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Assigns one or more private IPv4 addresses to a private NAT gateway. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html#nat-gateway-working-with">Work with
     * NAT gateways</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param assignPrivateNatGatewayAddressRequest
     * @return A Java Future containing the result of the AssignPrivateNatGatewayAddress operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssignPrivateNatGatewayAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignPrivateNatGatewayAddress"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssignPrivateNatGatewayAddressResponse> assignPrivateNatGatewayAddress(
            AssignPrivateNatGatewayAddressRequest assignPrivateNatGatewayAddressRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(assignPrivateNatGatewayAddressRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                assignPrivateNatGatewayAddressRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssignPrivateNatGatewayAddress");

            HttpResponseHandler<AssignPrivateNatGatewayAddressResponse> responseHandler = protocolFactory
                    .createResponseHandler(AssignPrivateNatGatewayAddressResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AssignPrivateNatGatewayAddressResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssignPrivateNatGatewayAddressRequest, AssignPrivateNatGatewayAddressResponse>()
                            .withOperationName("AssignPrivateNatGatewayAddress").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssignPrivateNatGatewayAddressRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(assignPrivateNatGatewayAddressRequest));
            CompletableFuture<AssignPrivateNatGatewayAddressResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates an Elastic IP address, or carrier IP address (for instances that are in subnets in Wavelength Zones)
     * with an instance or a network interface. Before you can use an Elastic IP address, you must allocate it to your
     * account.
     * </p>
     * <p>
     * If the Elastic IP address is already associated with a different instance, it is disassociated from that instance
     * and associated with the specified instance. If you associate an Elastic IP address with an instance that has an
     * existing Elastic IP address, the existing address is disassociated from the instance, but remains allocated to
     * your account.
     * </p>
     * <p>
     * [Subnets in Wavelength Zones] You can associate an IP address from the telecommunication carrier to the instance
     * or network interface.
     * </p>
     * <p>
     * You cannot associate an Elastic IP address with an interface in a different network border group.
     * </p>
     * <important>
     * <p>
     * This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn't return an error,
     * and you may be charged for each time the Elastic IP address is remapped to the same instance. For more
     * information, see the <i>Elastic IP Addresses</i> section of <a href="http://aws.amazon.com/ec2/pricing/">Amazon
     * EC2 Pricing</a>.
     * </p>
     * </important>
     *
     * @param associateAddressRequest
     * @return A Java Future containing the result of the AssociateAddress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateAddress" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateAddressResponse> associateAddress(AssociateAddressRequest associateAddressRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateAddressRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateAddressRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateAddress");

            HttpResponseHandler<AssociateAddressResponse> responseHandler = protocolFactory
                    .createResponseHandler(AssociateAddressResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AssociateAddressResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateAddressRequest, AssociateAddressResponse>()
                            .withOperationName("AssociateAddress").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateAddressRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateAddressRequest));
            CompletableFuture<AssociateAddressResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a target network with a Client VPN endpoint. A target network is a subnet in a VPC. You can associate
     * multiple subnets from the same VPC with a Client VPN endpoint. You can associate only one subnet in each
     * Availability Zone. We recommend that you associate at least two subnets to provide Availability Zone redundancy.
     * </p>
     * <p>
     * If you specified a VPC when you created the Client VPN endpoint or if you have previous subnet associations, the
     * specified subnet must be in the same VPC. To specify a subnet that's in a different VPC, you must first modify
     * the Client VPN endpoint (<a>ModifyClientVpnEndpoint</a>) and change the VPC that's associated with it.
     * </p>
     *
     * @param associateClientVpnTargetNetworkRequest
     * @return A Java Future containing the result of the AssociateClientVpnTargetNetwork operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateClientVpnTargetNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateClientVpnTargetNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateClientVpnTargetNetworkResponse> associateClientVpnTargetNetwork(
            AssociateClientVpnTargetNetworkRequest associateClientVpnTargetNetworkRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateClientVpnTargetNetworkRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateClientVpnTargetNetworkRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateClientVpnTargetNetwork");

            HttpResponseHandler<AssociateClientVpnTargetNetworkResponse> responseHandler = protocolFactory
                    .createResponseHandler(AssociateClientVpnTargetNetworkResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AssociateClientVpnTargetNetworkResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateClientVpnTargetNetworkRequest, AssociateClientVpnTargetNetworkResponse>()
                            .withOperationName("AssociateClientVpnTargetNetwork").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateClientVpnTargetNetworkRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateClientVpnTargetNetworkRequest));
            CompletableFuture<AssociateClientVpnTargetNetworkResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a set of DHCP options (that you've previously created) with the specified VPC, or associates no DHCP
     * options with the VPC.
     * </p>
     * <p>
     * After you associate the options with the VPC, any existing instances and all new instances that you launch in
     * that VPC use the options. You don't need to restart or relaunch the instances. They automatically pick up the
     * changes within a few hours, depending on how frequently the instance renews its DHCP lease. You can explicitly
     * renew the lease using the operating system on the instance.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP
     * options sets</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param associateDhcpOptionsRequest
     * @return A Java Future containing the result of the AssociateDhcpOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateDhcpOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateDhcpOptions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateDhcpOptionsResponse> associateDhcpOptions(
            AssociateDhcpOptionsRequest associateDhcpOptionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateDhcpOptionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateDhcpOptionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateDhcpOptions");

            HttpResponseHandler<AssociateDhcpOptionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(AssociateDhcpOptionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AssociateDhcpOptionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateDhcpOptionsRequest, AssociateDhcpOptionsResponse>()
                            .withOperationName("AssociateDhcpOptions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateDhcpOptionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateDhcpOptionsRequest));
            CompletableFuture<AssociateDhcpOptionsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates an Identity and Access Management (IAM) role with an Certificate Manager (ACM) certificate. This
     * enables the certificate to be used by the ACM for Nitro Enclaves application inside an enclave. For more
     * information, see <a href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html">Certificate
     * Manager for Nitro Enclaves</a> in the <i>Amazon Web Services Nitro Enclaves User Guide</i>.
     * </p>
     * <p>
     * When the IAM role is associated with the ACM certificate, the certificate, certificate chain, and encrypted
     * private key are placed in an Amazon S3 location that only the associated IAM role can access. The private key of
     * the certificate is encrypted with an Amazon Web Services managed key that has an attached attestation-based key
     * policy.
     * </p>
     * <p>
     * To enable the IAM role to access the Amazon S3 object, you must grant it permission to call
     * <code>s3:GetObject</code> on the Amazon S3 bucket returned by the command. To enable the IAM role to access the
     * KMS key, you must grant it permission to call <code>kms:Decrypt</code> on the KMS key returned by the command.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html#add-policy"> Grant the role
     * permission to access the certificate and encryption key</a> in the <i>Amazon Web Services Nitro Enclaves User
     * Guide</i>.
     * </p>
     *
     * @param associateEnclaveCertificateIamRoleRequest
     * @return A Java Future containing the result of the AssociateEnclaveCertificateIamRole operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateEnclaveCertificateIamRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateEnclaveCertificateIamRole"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateEnclaveCertificateIamRoleResponse> associateEnclaveCertificateIamRole(
            AssociateEnclaveCertificateIamRoleRequest associateEnclaveCertificateIamRoleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateEnclaveCertificateIamRoleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateEnclaveCertificateIamRoleRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateEnclaveCertificateIamRole");

            HttpResponseHandler<AssociateEnclaveCertificateIamRoleResponse> responseHandler = protocolFactory
                    .createResponseHandler(AssociateEnclaveCertificateIamRoleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AssociateEnclaveCertificateIamRoleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateEnclaveCertificateIamRoleRequest, AssociateEnclaveCertificateIamRoleResponse>()
                            .withOperationName("AssociateEnclaveCertificateIamRole").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateEnclaveCertificateIamRoleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateEnclaveCertificateIamRoleRequest));
            CompletableFuture<AssociateEnclaveCertificateIamRoleResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates an IAM instance profile with a running or stopped instance. You cannot associate more than one IAM
     * instance profile with an instance.
     * </p>
     *
     * @param associateIamInstanceProfileRequest
     * @return A Java Future containing the result of the AssociateIamInstanceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateIamInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIamInstanceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateIamInstanceProfileResponse> associateIamInstanceProfile(
            AssociateIamInstanceProfileRequest associateIamInstanceProfileRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateIamInstanceProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateIamInstanceProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateIamInstanceProfile");

            HttpResponseHandler<AssociateIamInstanceProfileResponse> responseHandler = protocolFactory
                    .createResponseHandler(AssociateIamInstanceProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AssociateIamInstanceProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateIamInstanceProfileRequest, AssociateIamInstanceProfileResponse>()
                            .withOperationName("AssociateIamInstanceProfile").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateIamInstanceProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateIamInstanceProfileRequest));
            CompletableFuture<AssociateIamInstanceProfileResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates one or more targets with an event window. Only one type of target (instance IDs, Dedicated Host IDs,
     * or tags) can be specified with an event window.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define
     * event windows for scheduled events</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param associateInstanceEventWindowRequest
     * @return A Java Future containing the result of the AssociateInstanceEventWindow operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateInstanceEventWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateInstanceEventWindow"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateInstanceEventWindowResponse> associateInstanceEventWindow(
            AssociateInstanceEventWindowRequest associateInstanceEventWindowRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateInstanceEventWindowRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateInstanceEventWindowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateInstanceEventWindow");

            HttpResponseHandler<AssociateInstanceEventWindowResponse> responseHandler = protocolFactory
                    .createResponseHandler(AssociateInstanceEventWindowResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AssociateInstanceEventWindowResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateInstanceEventWindowRequest, AssociateInstanceEventWindowResponse>()
                            .withOperationName("AssociateInstanceEventWindow").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateInstanceEventWindowRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateInstanceEventWindowRequest));
            CompletableFuture<AssociateInstanceEventWindowResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates your Autonomous System Number (ASN) with a BYOIP CIDR that you own in the same Amazon Web Services
     * Region. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/ipam/tutorials-byoasn.html">Tutorial: Bring your ASN to IPAM</a> in
     * the <i>Amazon VPC IPAM guide</i>.
     * </p>
     * <p>
     * After the association succeeds, the ASN is eligible for advertisement. You can view the association with <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeByoipCidrs.html">DescribeByoipCidrs</a>.
     * You can advertise the CIDR with <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AdvertiseByoipCidr.html">AdvertiseByoipCidr</a>.
     * </p>
     *
     * @param associateIpamByoasnRequest
     * @return A Java Future containing the result of the AssociateIpamByoasn operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateIpamByoasn
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIpamByoasn" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateIpamByoasnResponse> associateIpamByoasn(
            AssociateIpamByoasnRequest associateIpamByoasnRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateIpamByoasnRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateIpamByoasnRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateIpamByoasn");

            HttpResponseHandler<AssociateIpamByoasnResponse> responseHandler = protocolFactory
                    .createResponseHandler(AssociateIpamByoasnResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AssociateIpamByoasnResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateIpamByoasnRequest, AssociateIpamByoasnResponse>()
                            .withOperationName("AssociateIpamByoasn").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateIpamByoasnRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateIpamByoasnRequest));
            CompletableFuture<AssociateIpamByoasnResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates an IPAM resource discovery with an Amazon VPC IPAM. A resource discovery is an IPAM component that
     * enables IPAM to manage and monitor resources that belong to the owning account.
     * </p>
     *
     * @param associateIpamResourceDiscoveryRequest
     * @return A Java Future containing the result of the AssociateIpamResourceDiscovery operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateIpamResourceDiscovery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIpamResourceDiscovery"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateIpamResourceDiscoveryResponse> associateIpamResourceDiscovery(
            AssociateIpamResourceDiscoveryRequest associateIpamResourceDiscoveryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateIpamResourceDiscoveryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateIpamResourceDiscoveryRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateIpamResourceDiscovery");

            HttpResponseHandler<AssociateIpamResourceDiscoveryResponse> responseHandler = protocolFactory
                    .createResponseHandler(AssociateIpamResourceDiscoveryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AssociateIpamResourceDiscoveryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateIpamResourceDiscoveryRequest, AssociateIpamResourceDiscoveryResponse>()
                            .withOperationName("AssociateIpamResourceDiscovery").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateIpamResourceDiscoveryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateIpamResourceDiscoveryRequest));
            CompletableFuture<AssociateIpamResourceDiscoveryResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates Elastic IP addresses (EIPs) and private IPv4 addresses with a public NAT gateway. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html#nat-gateway-working-with">Work with
     * NAT gateways</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <p>
     * By default, you can associate up to 2 Elastic IP addresses per public NAT gateway. You can increase the limit by
     * requesting a quota adjustment. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html#vpc-limits-eips">Elastic IP address
     * quotas</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <important>
     * <p>
     * When you associate an EIP or secondary EIPs with a public NAT gateway, the network border group of the EIPs must
     * match the network border group of the Availability Zone (AZ) that the public NAT gateway is in. If it's not the
     * same, the EIP will fail to associate. You can see the network border group for the subnet's AZ by viewing the
     * details of the subnet. Similarly, you can view the network border group of an EIP by viewing the details of the
     * EIP address. For more information about network border groups and EIPs, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-eips.html#allocate-eip">Allocate an Elastic IP
     * address</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * </important>
     *
     * @param associateNatGatewayAddressRequest
     * @return A Java Future containing the result of the AssociateNatGatewayAddress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateNatGatewayAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateNatGatewayAddress"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateNatGatewayAddressResponse> associateNatGatewayAddress(
            AssociateNatGatewayAddressRequest associateNatGatewayAddressRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateNatGatewayAddressRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateNatGatewayAddressRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateNatGatewayAddress");

            HttpResponseHandler<AssociateNatGatewayAddressResponse> responseHandler = protocolFactory
                    .createResponseHandler(AssociateNatGatewayAddressResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AssociateNatGatewayAddressResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateNatGatewayAddressRequest, AssociateNatGatewayAddressResponse>()
                            .withOperationName("AssociateNatGatewayAddress").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateNatGatewayAddressRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateNatGatewayAddressRequest));
            CompletableFuture<AssociateNatGatewayAddressResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a subnet in your VPC or an internet gateway or virtual private gateway attached to your VPC with a
     * route table in your VPC. This association causes traffic from the subnet or gateway to be routed according to the
     * routes in the route table. The action returns an association ID, which you need in order to disassociate the
     * route table later. A route table can be associated with multiple subnets.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route
     * tables</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param associateRouteTableRequest
     * @return A Java Future containing the result of the AssociateRouteTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateRouteTable" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateRouteTableResponse> associateRouteTable(
            AssociateRouteTableRequest associateRouteTableRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateRouteTableRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateRouteTableRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateRouteTable");

            HttpResponseHandler<AssociateRouteTableResponse> responseHandler = protocolFactory
                    .createResponseHandler(AssociateRouteTableResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AssociateRouteTableResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateRouteTableRequest, AssociateRouteTableResponse>()
                            .withOperationName("AssociateRouteTable").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateRouteTableRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateRouteTableRequest));
            CompletableFuture<AssociateRouteTableResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a CIDR block with your subnet. You can only associate a single IPv6 CIDR block with your subnet.
     * </p>
     *
     * @param associateSubnetCidrBlockRequest
     * @return A Java Future containing the result of the AssociateSubnetCidrBlock operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateSubnetCidrBlock
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateSubnetCidrBlock" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateSubnetCidrBlockResponse> associateSubnetCidrBlock(
            AssociateSubnetCidrBlockRequest associateSubnetCidrBlockRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateSubnetCidrBlockRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateSubnetCidrBlockRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateSubnetCidrBlock");

            HttpResponseHandler<AssociateSubnetCidrBlockResponse> responseHandler = protocolFactory
                    .createResponseHandler(AssociateSubnetCidrBlockResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AssociateSubnetCidrBlockResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateSubnetCidrBlockRequest, AssociateSubnetCidrBlockResponse>()
                            .withOperationName("AssociateSubnetCidrBlock").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateSubnetCidrBlockRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateSubnetCidrBlockRequest));
            CompletableFuture<AssociateSubnetCidrBlockResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates the specified subnets and transit gateway attachments with the specified transit gateway multicast
     * domain.
     * </p>
     * <p>
     * The transit gateway attachment must be in the available state before you can add a resource. Use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayAttachments.html"
     * >DescribeTransitGatewayAttachments</a> to see the state of the attachment.
     * </p>
     *
     * @param associateTransitGatewayMulticastDomainRequest
     * @return A Java Future containing the result of the AssociateTransitGatewayMulticastDomain operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateTransitGatewayMulticastDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayMulticastDomain"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateTransitGatewayMulticastDomainResponse> associateTransitGatewayMulticastDomain(
            AssociateTransitGatewayMulticastDomainRequest associateTransitGatewayMulticastDomainRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateTransitGatewayMulticastDomainRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateTransitGatewayMulticastDomainRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateTransitGatewayMulticastDomain");

            HttpResponseHandler<AssociateTransitGatewayMulticastDomainResponse> responseHandler = protocolFactory
                    .createResponseHandler(AssociateTransitGatewayMulticastDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AssociateTransitGatewayMulticastDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateTransitGatewayMulticastDomainRequest, AssociateTransitGatewayMulticastDomainResponse>()
                            .withOperationName("AssociateTransitGatewayMulticastDomain").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateTransitGatewayMulticastDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateTransitGatewayMulticastDomainRequest));
            CompletableFuture<AssociateTransitGatewayMulticastDomainResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates the specified transit gateway attachment with a transit gateway policy table.
     * </p>
     *
     * @param associateTransitGatewayPolicyTableRequest
     * @return A Java Future containing the result of the AssociateTransitGatewayPolicyTable operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateTransitGatewayPolicyTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayPolicyTable"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateTransitGatewayPolicyTableResponse> associateTransitGatewayPolicyTable(
            AssociateTransitGatewayPolicyTableRequest associateTransitGatewayPolicyTableRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateTransitGatewayPolicyTableRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateTransitGatewayPolicyTableRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateTransitGatewayPolicyTable");

            HttpResponseHandler<AssociateTransitGatewayPolicyTableResponse> responseHandler = protocolFactory
                    .createResponseHandler(AssociateTransitGatewayPolicyTableResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AssociateTransitGatewayPolicyTableResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateTransitGatewayPolicyTableRequest, AssociateTransitGatewayPolicyTableResponse>()
                            .withOperationName("AssociateTransitGatewayPolicyTable").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateTransitGatewayPolicyTableRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateTransitGatewayPolicyTableRequest));
            CompletableFuture<AssociateTransitGatewayPolicyTableResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates the specified attachment with the specified transit gateway route table. You can associate only one
     * route table with an attachment.
     * </p>
     *
     * @param associateTransitGatewayRouteTableRequest
     * @return A Java Future containing the result of the AssociateTransitGatewayRouteTable operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateTransitGatewayRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayRouteTable"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateTransitGatewayRouteTableResponse> associateTransitGatewayRouteTable(
            AssociateTransitGatewayRouteTableRequest associateTransitGatewayRouteTableRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateTransitGatewayRouteTableRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateTransitGatewayRouteTableRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateTransitGatewayRouteTable");

            HttpResponseHandler<AssociateTransitGatewayRouteTableResponse> responseHandler = protocolFactory
                    .createResponseHandler(AssociateTransitGatewayRouteTableResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AssociateTransitGatewayRouteTableResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateTransitGatewayRouteTableRequest, AssociateTransitGatewayRouteTableResponse>()
                            .withOperationName("AssociateTransitGatewayRouteTable").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateTransitGatewayRouteTableRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateTransitGatewayRouteTableRequest));
            CompletableFuture<AssociateTransitGatewayRouteTableResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a branch network interface with a trunk network interface.
     * </p>
     * <p>
     * Before you create the association, run the <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html"
     * >create-network-interface</a> command and set <code>--interface-type</code> to <code>trunk</code>. You must also
     * create a network interface for each branch network interface that you want to associate with the trunk network
     * interface.
     * </p>
     *
     * @param associateTrunkInterfaceRequest
     * @return A Java Future containing the result of the AssociateTrunkInterface operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateTrunkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTrunkInterface" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateTrunkInterfaceResponse> associateTrunkInterface(
            AssociateTrunkInterfaceRequest associateTrunkInterfaceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateTrunkInterfaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateTrunkInterfaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateTrunkInterface");

            HttpResponseHandler<AssociateTrunkInterfaceResponse> responseHandler = protocolFactory
                    .createResponseHandler(AssociateTrunkInterfaceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AssociateTrunkInterfaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateTrunkInterfaceRequest, AssociateTrunkInterfaceResponse>()
                            .withOperationName("AssociateTrunkInterface").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateTrunkInterfaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateTrunkInterfaceRequest));
            CompletableFuture<AssociateTrunkInterfaceResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a CIDR block with your VPC. You can associate a secondary IPv4 CIDR block, an Amazon-provided IPv6
     * CIDR block, or an IPv6 CIDR block from an IPv6 address pool that you provisioned through bring your own IP
     * addresses (<a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">BYOIP</a>).
     * </p>
     * <p>
     * You must specify one of the following in the request: an IPv4 CIDR block, an IPv6 pool, or an Amazon-provided
     * IPv6 CIDR block.
     * </p>
     * <p>
     * For more information about associating CIDR blocks with your VPC and applicable restrictions, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-ip-addressing.html">IP addressing for your VPCs and
     * subnets</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param associateVpcCidrBlockRequest
     * @return A Java Future containing the result of the AssociateVpcCidrBlock operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateVpcCidrBlock
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateVpcCidrBlock" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateVpcCidrBlockResponse> associateVpcCidrBlock(
            AssociateVpcCidrBlockRequest associateVpcCidrBlockRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateVpcCidrBlockRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateVpcCidrBlockRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateVpcCidrBlock");

            HttpResponseHandler<AssociateVpcCidrBlockResponse> responseHandler = protocolFactory
                    .createResponseHandler(AssociateVpcCidrBlockResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AssociateVpcCidrBlockResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateVpcCidrBlockRequest, AssociateVpcCidrBlockResponse>()
                            .withOperationName("AssociateVpcCidrBlock").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateVpcCidrBlockRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateVpcCidrBlockRequest));
            CompletableFuture<AssociateVpcCidrBlockResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This action is deprecated.
     * </p>
     * </note>
     * <p>
     * Links an EC2-Classic instance to a ClassicLink-enabled VPC through one or more of the VPC security groups. You
     * cannot link an EC2-Classic instance to more than one VPC at a time. You can only link an instance that's in the
     * <code>running</code> state. An instance is automatically unlinked from a VPC when it's stopped - you can link it
     * to the VPC again when you restart it.
     * </p>
     * <p>
     * After you've linked an instance, you cannot change the VPC security groups that are associated with it. To change
     * the security groups, you must first unlink the instance, and then link it again.
     * </p>
     * <p>
     * Linking your instance to a VPC is sometimes referred to as <i>attaching</i> your instance.
     * </p>
     *
     * @param attachClassicLinkVpcRequest
     * @return A Java Future containing the result of the AttachClassicLinkVpc operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AttachClassicLinkVpc
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachClassicLinkVpc" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AttachClassicLinkVpcResponse> attachClassicLinkVpc(
            AttachClassicLinkVpcRequest attachClassicLinkVpcRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(attachClassicLinkVpcRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, attachClassicLinkVpcRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AttachClassicLinkVpc");

            HttpResponseHandler<AttachClassicLinkVpcResponse> responseHandler = protocolFactory
                    .createResponseHandler(AttachClassicLinkVpcResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AttachClassicLinkVpcResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AttachClassicLinkVpcRequest, AttachClassicLinkVpcResponse>()
                            .withOperationName("AttachClassicLinkVpc").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AttachClassicLinkVpcRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(attachClassicLinkVpcRequest));
            CompletableFuture<AttachClassicLinkVpcResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches an internet gateway or a virtual private gateway to a VPC, enabling connectivity between the internet
     * and the VPC. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Internet_Gateway.html">Internet gateways</a> in the
     * <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param attachInternetGatewayRequest
     * @return A Java Future containing the result of the AttachInternetGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AttachInternetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachInternetGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AttachInternetGatewayResponse> attachInternetGateway(
            AttachInternetGatewayRequest attachInternetGatewayRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(attachInternetGatewayRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, attachInternetGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AttachInternetGateway");

            HttpResponseHandler<AttachInternetGatewayResponse> responseHandler = protocolFactory
                    .createResponseHandler(AttachInternetGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AttachInternetGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AttachInternetGatewayRequest, AttachInternetGatewayResponse>()
                            .withOperationName("AttachInternetGateway").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AttachInternetGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(attachInternetGatewayRequest));
            CompletableFuture<AttachInternetGatewayResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches a network interface to an instance.
     * </p>
     *
     * @param attachNetworkInterfaceRequest
     *        Contains the parameters for AttachNetworkInterface.
     * @return A Java Future containing the result of the AttachNetworkInterface operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AttachNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachNetworkInterface" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AttachNetworkInterfaceResponse> attachNetworkInterface(
            AttachNetworkInterfaceRequest attachNetworkInterfaceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(attachNetworkInterfaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, attachNetworkInterfaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AttachNetworkInterface");

            HttpResponseHandler<AttachNetworkInterfaceResponse> responseHandler = protocolFactory
                    .createResponseHandler(AttachNetworkInterfaceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AttachNetworkInterfaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AttachNetworkInterfaceRequest, AttachNetworkInterfaceResponse>()
                            .withOperationName("AttachNetworkInterface").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AttachNetworkInterfaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(attachNetworkInterfaceRequest));
            CompletableFuture<AttachNetworkInterfaceResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches the specified Amazon Web Services Verified Access trust provider to the specified Amazon Web Services
     * Verified Access instance.
     * </p>
     *
     * @param attachVerifiedAccessTrustProviderRequest
     * @return A Java Future containing the result of the AttachVerifiedAccessTrustProvider operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AttachVerifiedAccessTrustProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVerifiedAccessTrustProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AttachVerifiedAccessTrustProviderResponse> attachVerifiedAccessTrustProvider(
            AttachVerifiedAccessTrustProviderRequest attachVerifiedAccessTrustProviderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(attachVerifiedAccessTrustProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                attachVerifiedAccessTrustProviderRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AttachVerifiedAccessTrustProvider");

            HttpResponseHandler<AttachVerifiedAccessTrustProviderResponse> responseHandler = protocolFactory
                    .createResponseHandler(AttachVerifiedAccessTrustProviderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AttachVerifiedAccessTrustProviderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AttachVerifiedAccessTrustProviderRequest, AttachVerifiedAccessTrustProviderResponse>()
                            .withOperationName("AttachVerifiedAccessTrustProvider").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AttachVerifiedAccessTrustProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(attachVerifiedAccessTrustProviderRequest));
            CompletableFuture<AttachVerifiedAccessTrustProviderResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches an EBS volume to a running or stopped instance and exposes it to the instance with the specified device
     * name.
     * </p>
     * <p>
     * Encrypted EBS volumes must be attached to instances that support Amazon EBS encryption. For more information, see
     * <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html">Amazon EBS encryption</a> in the
     * <i>Amazon EBS User Guide</i>.
     * </p>
     * <p>
     * After you attach an EBS volume, you must make it available. For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-using-volumes.html">Make an EBS volume available for
     * use</a>.
     * </p>
     * <p>
     * If a volume has an Amazon Web Services Marketplace product code:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The volume can be attached only to a stopped instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services Marketplace product codes are copied from the volume to the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * You must be subscribed to the product.
     * </p>
     * </li>
     * <li>
     * <p>
     * The instance type and operating system of the instance must support the product. For example, you can't detach a
     * volume from a Windows instance and attach it to a Linux instance.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-attaching-volume.html">Attach an Amazon EBS volume to
     * an instance</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     *
     * @param attachVolumeRequest
     * @return A Java Future containing the result of the AttachVolume operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AttachVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVolume" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AttachVolumeResponse> attachVolume(AttachVolumeRequest attachVolumeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(attachVolumeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, attachVolumeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AttachVolume");

            HttpResponseHandler<AttachVolumeResponse> responseHandler = protocolFactory
                    .createResponseHandler(AttachVolumeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AttachVolumeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AttachVolumeRequest, AttachVolumeResponse>()
                            .withOperationName("AttachVolume").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AttachVolumeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(attachVolumeRequest));
            CompletableFuture<AttachVolumeResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches a virtual private gateway to a VPC. You can attach one virtual private gateway to one VPC at a time.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web
     * Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     *
     * @param attachVpnGatewayRequest
     *        Contains the parameters for AttachVpnGateway.
     * @return A Java Future containing the result of the AttachVpnGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AttachVpnGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVpnGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AttachVpnGatewayResponse> attachVpnGateway(AttachVpnGatewayRequest attachVpnGatewayRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(attachVpnGatewayRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, attachVpnGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AttachVpnGateway");

            HttpResponseHandler<AttachVpnGatewayResponse> responseHandler = protocolFactory
                    .createResponseHandler(AttachVpnGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AttachVpnGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AttachVpnGatewayRequest, AttachVpnGatewayResponse>()
                            .withOperationName("AttachVpnGateway").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AttachVpnGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(attachVpnGatewayRequest));
            CompletableFuture<AttachVpnGatewayResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds an ingress authorization rule to a Client VPN endpoint. Ingress authorization rules act as firewall rules
     * that grant access to networks. You must configure ingress authorization rules to enable clients to access
     * resources in Amazon Web Services or on-premises networks.
     * </p>
     *
     * @param authorizeClientVpnIngressRequest
     * @return A Java Future containing the result of the AuthorizeClientVpnIngress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AuthorizeClientVpnIngress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeClientVpnIngress" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AuthorizeClientVpnIngressResponse> authorizeClientVpnIngress(
            AuthorizeClientVpnIngressRequest authorizeClientVpnIngressRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(authorizeClientVpnIngressRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, authorizeClientVpnIngressRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AuthorizeClientVpnIngress");

            HttpResponseHandler<AuthorizeClientVpnIngressResponse> responseHandler = protocolFactory
                    .createResponseHandler(AuthorizeClientVpnIngressResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AuthorizeClientVpnIngressResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AuthorizeClientVpnIngressRequest, AuthorizeClientVpnIngressResponse>()
                            .withOperationName("AuthorizeClientVpnIngress").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AuthorizeClientVpnIngressRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(authorizeClientVpnIngressRequest));
            CompletableFuture<AuthorizeClientVpnIngressResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds the specified outbound (egress) rules to a security group.
     * </p>
     * <p>
     * An outbound rule permits instances to send traffic to the specified IPv4 or IPv6 address ranges, the IP address
     * ranges specified by a prefix list, or the instances that are associated with a source security group. For more
     * information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/security-group-rules.html">Security
     * group rules</a>.
     * </p>
     * <p>
     * You must specify exactly one of the following destinations: an IPv4 or IPv6 address range, a prefix list, or a
     * security group. You must specify a protocol for each rule (for example, TCP). If the protocol is TCP or UDP, you
     * must also specify a port or port range. If the protocol is ICMP or ICMPv6, you must also specify the ICMP type
     * and code.
     * </p>
     * <p>
     * Rule changes are propagated to instances associated with the security group as quickly as possible. However, a
     * small delay might occur.
     * </p>
     * <p>
     * For examples of rules that you can add to security groups for specific access scenarios, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules-reference.html">Security group
     * rules for different use cases</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * For information about security group quotas, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC quotas</a> in the
     * <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param authorizeSecurityGroupEgressRequest
     * @return A Java Future containing the result of the AuthorizeSecurityGroupEgress operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AuthorizeSecurityGroupEgress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupEgress"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AuthorizeSecurityGroupEgressResponse> authorizeSecurityGroupEgress(
            AuthorizeSecurityGroupEgressRequest authorizeSecurityGroupEgressRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(authorizeSecurityGroupEgressRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, authorizeSecurityGroupEgressRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AuthorizeSecurityGroupEgress");

            HttpResponseHandler<AuthorizeSecurityGroupEgressResponse> responseHandler = protocolFactory
                    .createResponseHandler(AuthorizeSecurityGroupEgressResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AuthorizeSecurityGroupEgressResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AuthorizeSecurityGroupEgressRequest, AuthorizeSecurityGroupEgressResponse>()
                            .withOperationName("AuthorizeSecurityGroupEgress").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AuthorizeSecurityGroupEgressRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(authorizeSecurityGroupEgressRequest));
            CompletableFuture<AuthorizeSecurityGroupEgressResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds the specified inbound (ingress) rules to a security group.
     * </p>
     * <p>
     * An inbound rule permits instances to receive traffic from the specified IPv4 or IPv6 address range, the IP
     * address ranges that are specified by a prefix list, or the instances that are associated with a destination
     * security group. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/security-group-rules.html">Security group rules</a>.
     * </p>
     * <p>
     * You must specify exactly one of the following sources: an IPv4 or IPv6 address range, a prefix list, or a
     * security group. You must specify a protocol for each rule (for example, TCP). If the protocol is TCP or UDP, you
     * must also specify a port or port range. If the protocol is ICMP or ICMPv6, you must also specify the ICMP/ICMPv6
     * type and code.
     * </p>
     * <p>
     * Rule changes are propagated to instances associated with the security group as quickly as possible. However, a
     * small delay might occur.
     * </p>
     * <p>
     * For examples of rules that you can add to security groups for specific access scenarios, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules-reference.html">Security group
     * rules for different use cases</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * For more information about security group quotas, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC quotas</a> in the
     * <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param authorizeSecurityGroupIngressRequest
     * @return A Java Future containing the result of the AuthorizeSecurityGroupIngress operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AuthorizeSecurityGroupIngress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupIngress"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AuthorizeSecurityGroupIngressResponse> authorizeSecurityGroupIngress(
            AuthorizeSecurityGroupIngressRequest authorizeSecurityGroupIngressRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(authorizeSecurityGroupIngressRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                authorizeSecurityGroupIngressRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AuthorizeSecurityGroupIngress");

            HttpResponseHandler<AuthorizeSecurityGroupIngressResponse> responseHandler = protocolFactory
                    .createResponseHandler(AuthorizeSecurityGroupIngressResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AuthorizeSecurityGroupIngressResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AuthorizeSecurityGroupIngressRequest, AuthorizeSecurityGroupIngressResponse>()
                            .withOperationName("AuthorizeSecurityGroupIngress").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AuthorizeSecurityGroupIngressRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(authorizeSecurityGroupIngressRequest));
            CompletableFuture<AuthorizeSecurityGroupIngressResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Bundles an Amazon instance store-backed Windows instance.
     * </p>
     * <p>
     * During bundling, only the root device volume (C:\) is bundled. Data on other instance store volumes is not
     * preserved.
     * </p>
     * <note>
     * <p>
     * This action is not applicable for Linux/Unix instances or Windows instances that are backed by Amazon EBS.
     * </p>
     * </note>
     *
     * @param bundleInstanceRequest
     *        Contains the parameters for BundleInstance.
     * @return A Java Future containing the result of the BundleInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.BundleInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BundleInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<BundleInstanceResponse> bundleInstance(BundleInstanceRequest bundleInstanceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(bundleInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, bundleInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BundleInstance");

            HttpResponseHandler<BundleInstanceResponse> responseHandler = protocolFactory
                    .createResponseHandler(BundleInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<BundleInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BundleInstanceRequest, BundleInstanceResponse>()
                            .withOperationName("BundleInstance").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BundleInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(bundleInstanceRequest));
            CompletableFuture<BundleInstanceResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels a bundling operation for an instance store-backed Windows instance.
     * </p>
     *
     * @param cancelBundleTaskRequest
     *        Contains the parameters for CancelBundleTask.
     * @return A Java Future containing the result of the CancelBundleTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CancelBundleTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelBundleTask" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CancelBundleTaskResponse> cancelBundleTask(CancelBundleTaskRequest cancelBundleTaskRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelBundleTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelBundleTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelBundleTask");

            HttpResponseHandler<CancelBundleTaskResponse> responseHandler = protocolFactory
                    .createResponseHandler(CancelBundleTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CancelBundleTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelBundleTaskRequest, CancelBundleTaskResponse>()
                            .withOperationName("CancelBundleTask").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelBundleTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelBundleTaskRequest));
            CompletableFuture<CancelBundleTaskResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels the specified Capacity Reservation, releases the reserved capacity, and changes the Capacity
     * Reservation's state to <code>cancelled</code>.
     * </p>
     * <p>
     * Instances running in the reserved capacity continue running until you stop them. Stopped instances that target
     * the Capacity Reservation can no longer launch. Modify these instances to either target a different Capacity
     * Reservation, launch On-Demand Instance capacity, or run in any open Capacity Reservation that has matching
     * attributes and sufficient capacity.
     * </p>
     *
     * @param cancelCapacityReservationRequest
     * @return A Java Future containing the result of the CancelCapacityReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CancelCapacityReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelCapacityReservation" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelCapacityReservationResponse> cancelCapacityReservation(
            CancelCapacityReservationRequest cancelCapacityReservationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelCapacityReservationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelCapacityReservationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelCapacityReservation");

            HttpResponseHandler<CancelCapacityReservationResponse> responseHandler = protocolFactory
                    .createResponseHandler(CancelCapacityReservationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CancelCapacityReservationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelCapacityReservationRequest, CancelCapacityReservationResponse>()
                            .withOperationName("CancelCapacityReservation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelCapacityReservationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelCapacityReservationRequest));
            CompletableFuture<CancelCapacityReservationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels one or more Capacity Reservation Fleets. When you cancel a Capacity Reservation Fleet, the following
     * happens:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The Capacity Reservation Fleet's status changes to <code>cancelled</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The individual Capacity Reservations in the Fleet are cancelled. Instances running in the Capacity Reservations
     * at the time of cancelling the Fleet continue to run in shared capacity.
     * </p>
     * </li>
     * <li>
     * <p>
     * The Fleet stops creating new Capacity Reservations.
     * </p>
     * </li>
     * </ul>
     *
     * @param cancelCapacityReservationFleetsRequest
     * @return A Java Future containing the result of the CancelCapacityReservationFleets operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CancelCapacityReservationFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelCapacityReservationFleets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelCapacityReservationFleetsResponse> cancelCapacityReservationFleets(
            CancelCapacityReservationFleetsRequest cancelCapacityReservationFleetsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelCapacityReservationFleetsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                cancelCapacityReservationFleetsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelCapacityReservationFleets");

            HttpResponseHandler<CancelCapacityReservationFleetsResponse> responseHandler = protocolFactory
                    .createResponseHandler(CancelCapacityReservationFleetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CancelCapacityReservationFleetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelCapacityReservationFleetsRequest, CancelCapacityReservationFleetsResponse>()
                            .withOperationName("CancelCapacityReservationFleets").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelCapacityReservationFleetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelCapacityReservationFleetsRequest));
            CompletableFuture<CancelCapacityReservationFleetsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels an active conversion task. The task can be the import of an instance or volume. The action removes all
     * artifacts of the conversion, including a partially uploaded volume or instance. If the conversion is complete or
     * is in the process of transferring the final disk image, the command fails and returns an exception.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/CommandLineReference/ec2-cli-vmimport-export.html">Importing a
     * Virtual Machine Using the Amazon EC2 CLI</a>.
     * </p>
     *
     * @param cancelConversionTaskRequest
     * @return A Java Future containing the result of the CancelConversionTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CancelConversionTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelConversionTask" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CancelConversionTaskResponse> cancelConversionTask(
            CancelConversionTaskRequest cancelConversionTaskRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelConversionTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelConversionTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelConversionTask");

            HttpResponseHandler<CancelConversionTaskResponse> responseHandler = protocolFactory
                    .createResponseHandler(CancelConversionTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CancelConversionTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelConversionTaskRequest, CancelConversionTaskResponse>()
                            .withOperationName("CancelConversionTask").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelConversionTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelConversionTaskRequest));
            CompletableFuture<CancelConversionTaskResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels an active export task. The request removes all artifacts of the export, including any partially-created
     * Amazon S3 objects. If the export task is complete or is in the process of transferring the final disk image, the
     * command fails and returns an error.
     * </p>
     *
     * @param cancelExportTaskRequest
     * @return A Java Future containing the result of the CancelExportTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CancelExportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelExportTask" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CancelExportTaskResponse> cancelExportTask(CancelExportTaskRequest cancelExportTaskRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelExportTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelExportTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelExportTask");

            HttpResponseHandler<CancelExportTaskResponse> responseHandler = protocolFactory
                    .createResponseHandler(CancelExportTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CancelExportTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelExportTaskRequest, CancelExportTaskResponse>()
                            .withOperationName("CancelExportTask").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelExportTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelExportTaskRequest));
            CompletableFuture<CancelExportTaskResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes your Amazon Web Services account from the launch permissions for the specified AMI. For more information,
     * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cancel-sharing-an-AMI.html"> Cancel having an
     * AMI shared with your Amazon Web Services account</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param cancelImageLaunchPermissionRequest
     * @return A Java Future containing the result of the CancelImageLaunchPermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CancelImageLaunchPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelImageLaunchPermission"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelImageLaunchPermissionResponse> cancelImageLaunchPermission(
            CancelImageLaunchPermissionRequest cancelImageLaunchPermissionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelImageLaunchPermissionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelImageLaunchPermissionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelImageLaunchPermission");

            HttpResponseHandler<CancelImageLaunchPermissionResponse> responseHandler = protocolFactory
                    .createResponseHandler(CancelImageLaunchPermissionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CancelImageLaunchPermissionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelImageLaunchPermissionRequest, CancelImageLaunchPermissionResponse>()
                            .withOperationName("CancelImageLaunchPermission").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelImageLaunchPermissionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelImageLaunchPermissionRequest));
            CompletableFuture<CancelImageLaunchPermissionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels an in-process import virtual machine or import snapshot task.
     * </p>
     *
     * @param cancelImportTaskRequest
     * @return A Java Future containing the result of the CancelImportTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CancelImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelImportTask" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CancelImportTaskResponse> cancelImportTask(CancelImportTaskRequest cancelImportTaskRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelImportTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelImportTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelImportTask");

            HttpResponseHandler<CancelImportTaskResponse> responseHandler = protocolFactory
                    .createResponseHandler(CancelImportTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CancelImportTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelImportTaskRequest, CancelImportTaskResponse>()
                            .withOperationName("CancelImportTask").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelImportTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelImportTaskRequest));
            CompletableFuture<CancelImportTaskResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels the specified Reserved Instance listing in the Reserved Instance Marketplace.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance
     * Marketplace</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param cancelReservedInstancesListingRequest
     *        Contains the parameters for CancelReservedInstancesListing.
     * @return A Java Future containing the result of the CancelReservedInstancesListing operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CancelReservedInstancesListing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelReservedInstancesListing"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelReservedInstancesListingResponse> cancelReservedInstancesListing(
            CancelReservedInstancesListingRequest cancelReservedInstancesListingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelReservedInstancesListingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                cancelReservedInstancesListingRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelReservedInstancesListing");

            HttpResponseHandler<CancelReservedInstancesListingResponse> responseHandler = protocolFactory
                    .createResponseHandler(CancelReservedInstancesListingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CancelReservedInstancesListingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelReservedInstancesListingRequest, CancelReservedInstancesListingResponse>()
                            .withOperationName("CancelReservedInstancesListing").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelReservedInstancesListingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelReservedInstancesListingRequest));
            CompletableFuture<CancelReservedInstancesListingResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels the specified Spot Fleet requests.
     * </p>
     * <p>
     * After you cancel a Spot Fleet request, the Spot Fleet launches no new instances.
     * </p>
     * <p>
     * You must also specify whether a canceled Spot Fleet request should terminate its instances. If you choose to
     * terminate the instances, the Spot Fleet request enters the <code>cancelled_terminating</code> state. Otherwise,
     * the Spot Fleet request enters the <code>cancelled_running</code> state and the instances continue to run until
     * they are interrupted or you terminate them manually.
     * </p>
     * <p class="title">
     * <b>Restrictions</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can delete up to 100 fleets in a single request. If you exceed the specified number, no fleets are deleted.
     * </p>
     * </li>
     * </ul>
     *
     * @param cancelSpotFleetRequestsRequest
     *        Contains the parameters for CancelSpotFleetRequests.
     * @return A Java Future containing the result of the CancelSpotFleetRequests operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CancelSpotFleetRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotFleetRequests" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelSpotFleetRequestsResponse> cancelSpotFleetRequests(
            CancelSpotFleetRequestsRequest cancelSpotFleetRequestsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelSpotFleetRequestsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelSpotFleetRequestsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelSpotFleetRequests");

            HttpResponseHandler<CancelSpotFleetRequestsResponse> responseHandler = protocolFactory
                    .createResponseHandler(CancelSpotFleetRequestsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CancelSpotFleetRequestsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelSpotFleetRequestsRequest, CancelSpotFleetRequestsResponse>()
                            .withOperationName("CancelSpotFleetRequests").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelSpotFleetRequestsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelSpotFleetRequestsRequest));
            CompletableFuture<CancelSpotFleetRequestsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels one or more Spot Instance requests.
     * </p>
     * <important>
     * <p>
     * Canceling a Spot Instance request does not terminate running Spot Instances associated with the request.
     * </p>
     * </important>
     *
     * @param cancelSpotInstanceRequestsRequest
     *        Contains the parameters for CancelSpotInstanceRequests.
     * @return A Java Future containing the result of the CancelSpotInstanceRequests operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CancelSpotInstanceRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotInstanceRequests"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelSpotInstanceRequestsResponse> cancelSpotInstanceRequests(
            CancelSpotInstanceRequestsRequest cancelSpotInstanceRequestsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelSpotInstanceRequestsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelSpotInstanceRequestsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelSpotInstanceRequests");

            HttpResponseHandler<CancelSpotInstanceRequestsResponse> responseHandler = protocolFactory
                    .createResponseHandler(CancelSpotInstanceRequestsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CancelSpotInstanceRequestsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelSpotInstanceRequestsRequest, CancelSpotInstanceRequestsResponse>()
                            .withOperationName("CancelSpotInstanceRequests").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelSpotInstanceRequestsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelSpotInstanceRequestsRequest));
            CompletableFuture<CancelSpotInstanceRequestsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Determines whether a product code is associated with an instance. This action can only be used by the owner of
     * the product code. It is useful when a product code owner must verify whether another user's instance is eligible
     * for support.
     * </p>
     *
     * @param confirmProductInstanceRequest
     * @return A Java Future containing the result of the ConfirmProductInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.ConfirmProductInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ConfirmProductInstance" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ConfirmProductInstanceResponse> confirmProductInstance(
            ConfirmProductInstanceRequest confirmProductInstanceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(confirmProductInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, confirmProductInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ConfirmProductInstance");

            HttpResponseHandler<ConfirmProductInstanceResponse> responseHandler = protocolFactory
                    .createResponseHandler(ConfirmProductInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ConfirmProductInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ConfirmProductInstanceRequest, ConfirmProductInstanceResponse>()
                            .withOperationName("ConfirmProductInstance").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ConfirmProductInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(confirmProductInstanceRequest));
            CompletableFuture<ConfirmProductInstanceResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Copies the specified Amazon FPGA Image (AFI) to the current Region.
     * </p>
     *
     * @param copyFpgaImageRequest
     * @return A Java Future containing the result of the CopyFpgaImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CopyFpgaImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyFpgaImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CopyFpgaImageResponse> copyFpgaImage(CopyFpgaImageRequest copyFpgaImageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(copyFpgaImageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, copyFpgaImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CopyFpgaImage");

            HttpResponseHandler<CopyFpgaImageResponse> responseHandler = protocolFactory
                    .createResponseHandler(CopyFpgaImageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CopyFpgaImageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CopyFpgaImageRequest, CopyFpgaImageResponse>()
                            .withOperationName("CopyFpgaImage").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CopyFpgaImageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(copyFpgaImageRequest));
            CompletableFuture<CopyFpgaImageResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Initiates the copy of an AMI. You can copy an AMI from one Region to another, or from a Region to an Outpost. You
     * can't copy an AMI from an Outpost to a Region, from one Outpost to another, or within the same Outpost. To copy
     * an AMI to another partition, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateStoreImageTask.html"
     * >CreateStoreImageTask</a>.
     * </p>
     * <p>
     * To copy an AMI from one Region to another, specify the source Region using the <b>SourceRegion</b> parameter, and
     * specify the destination Region using its endpoint. Copies of encrypted backing snapshots for the AMI are
     * encrypted. Copies of unencrypted backing snapshots remain unencrypted, unless you set <code>Encrypted</code>
     * during the copy operation. You cannot create an unencrypted copy of an encrypted backing snapshot.
     * </p>
     * <p>
     * To copy an AMI from a Region to an Outpost, specify the source Region using the <b>SourceRegion</b> parameter,
     * and specify the ARN of the destination Outpost using <b>DestinationOutpostArn</b>. Backing snapshots copied to an
     * Outpost are encrypted by default using the default encryption key for the Region, or a different key that you
     * specify in the request using <b>KmsKeyId</b>. Outposts do not support unencrypted snapshots. For more
     * information, <a href="https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#ami"> Amazon EBS
     * local snapshots on Outposts</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     * <p>
     * For more information about the prerequisites and limits when copying an AMI, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/CopyingAMIs.html">Copy an AMI</a> in the <i>Amazon EC2
     * User Guide</i>.
     * </p>
     *
     * @param copyImageRequest
     *        Contains the parameters for CopyImage.
     * @return A Java Future containing the result of the CopyImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CopyImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CopyImageResponse> copyImage(CopyImageRequest copyImageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(copyImageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, copyImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CopyImage");

            HttpResponseHandler<CopyImageResponse> responseHandler = protocolFactory
                    .createResponseHandler(CopyImageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CopyImageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CopyImageRequest, CopyImageResponse>().withOperationName("CopyImage")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CopyImageRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(copyImageRequest));
            CompletableFuture<CopyImageResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Copies a point-in-time snapshot of an EBS volume and stores it in Amazon S3. You can copy a snapshot within the
     * same Region, from one Region to another, or from a Region to an Outpost. You can't copy a snapshot from an
     * Outpost to a Region, from one Outpost to another, or within the same Outpost.
     * </p>
     * <p>
     * You can use the snapshot to create EBS volumes or Amazon Machine Images (AMIs).
     * </p>
     * <p>
     * When copying snapshots to a Region, copies of encrypted EBS snapshots remain encrypted. Copies of unencrypted
     * snapshots remain unencrypted, unless you enable encryption for the snapshot copy operation. By default, encrypted
     * snapshot copies use the default Key Management Service (KMS) KMS key; however, you can specify a different KMS
     * key. To copy an encrypted snapshot that has been shared from another account, you must have permissions for the
     * KMS key used to encrypt the snapshot.
     * </p>
     * <p>
     * Snapshots copied to an Outpost are encrypted by default using the default encryption key for the Region, or a
     * different key that you specify in the request using <b>KmsKeyId</b>. Outposts do not support unencrypted
     * snapshots. For more information, <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#ami"> Amazon EBS local snapshots
     * on Outposts</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     * <p>
     * Snapshots created by copying another snapshot have an arbitrary volume ID that should not be used for any
     * purpose.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-copy-snapshot.html">Copy
     * an Amazon EBS snapshot</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     *
     * @param copySnapshotRequest
     * @return A Java Future containing the result of the CopySnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CopySnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopySnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CopySnapshotResponse> copySnapshot(CopySnapshotRequest copySnapshotRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(copySnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, copySnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CopySnapshot");

            HttpResponseHandler<CopySnapshotResponse> responseHandler = protocolFactory
                    .createResponseHandler(CopySnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CopySnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CopySnapshotRequest, CopySnapshotResponse>()
                            .withOperationName("CopySnapshot").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CopySnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(copySnapshotRequest));
            CompletableFuture<CopySnapshotResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new Capacity Reservation with the specified attributes.
     * </p>
     * <p>
     * Capacity Reservations enable you to reserve capacity for your Amazon EC2 instances in a specific Availability
     * Zone for any duration. This gives you the flexibility to selectively add capacity reservations and still get the
     * Regional RI discounts for that usage. By creating Capacity Reservations, you ensure that you always have access
     * to Amazon EC2 capacity when you need it, for as long as you need it. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html">Capacity
     * Reservations</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * Your request to create a Capacity Reservation could fail if Amazon EC2 does not have sufficient capacity to
     * fulfill the request. If your request fails due to Amazon EC2 capacity constraints, either try again at a later
     * time, try in a different Availability Zone, or request a smaller capacity reservation. If your application is
     * flexible across instance types and sizes, try to create a Capacity Reservation with different instance
     * attributes.
     * </p>
     * <p>
     * Your request could also fail if the requested quantity exceeds your On-Demand Instance limit for the selected
     * instance type. If your request fails due to limit constraints, increase your On-Demand Instance limit for the
     * required instance type and try again. For more information about increasing your instance limits, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html">Amazon EC2 Service Quotas</a>
     * in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createCapacityReservationRequest
     * @return A Java Future containing the result of the CreateCapacityReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateCapacityReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCapacityReservation" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCapacityReservationResponse> createCapacityReservation(
            CreateCapacityReservationRequest createCapacityReservationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCapacityReservationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCapacityReservationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCapacityReservation");

            HttpResponseHandler<CreateCapacityReservationResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateCapacityReservationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateCapacityReservationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCapacityReservationRequest, CreateCapacityReservationResponse>()
                            .withOperationName("CreateCapacityReservation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateCapacityReservationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createCapacityReservationRequest));
            CompletableFuture<CreateCapacityReservationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a Capacity Reservation Fleet. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/work-with-cr-fleets.html#create-crfleet">Create a
     * Capacity Reservation Fleet</a> in the Amazon EC2 User Guide.
     * </p>
     *
     * @param createCapacityReservationFleetRequest
     * @return A Java Future containing the result of the CreateCapacityReservationFleet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateCapacityReservationFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCapacityReservationFleet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCapacityReservationFleetResponse> createCapacityReservationFleet(
            CreateCapacityReservationFleetRequest createCapacityReservationFleetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCapacityReservationFleetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createCapacityReservationFleetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCapacityReservationFleet");

            HttpResponseHandler<CreateCapacityReservationFleetResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateCapacityReservationFleetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateCapacityReservationFleetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCapacityReservationFleetRequest, CreateCapacityReservationFleetResponse>()
                            .withOperationName("CreateCapacityReservationFleet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateCapacityReservationFleetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createCapacityReservationFleetRequest));
            CompletableFuture<CreateCapacityReservationFleetResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a carrier gateway. For more information about carrier gateways, see <a href=
     * "https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#wavelength-carrier-gateway"
     * >Carrier gateways</a> in the <i>Amazon Web Services Wavelength Developer Guide</i>.
     * </p>
     *
     * @param createCarrierGatewayRequest
     * @return A Java Future containing the result of the CreateCarrierGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateCarrierGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCarrierGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCarrierGatewayResponse> createCarrierGateway(
            CreateCarrierGatewayRequest createCarrierGatewayRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCarrierGatewayRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCarrierGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCarrierGateway");

            HttpResponseHandler<CreateCarrierGatewayResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateCarrierGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateCarrierGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCarrierGatewayRequest, CreateCarrierGatewayResponse>()
                            .withOperationName("CreateCarrierGateway").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateCarrierGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createCarrierGatewayRequest));
            CompletableFuture<CreateCarrierGatewayResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a Client VPN endpoint. A Client VPN endpoint is the resource you create and configure to enable and
     * manage client VPN sessions. It is the destination endpoint at which all client VPN sessions are terminated.
     * </p>
     *
     * @param createClientVpnEndpointRequest
     * @return A Java Future containing the result of the CreateClientVpnEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateClientVpnEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateClientVpnEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateClientVpnEndpointResponse> createClientVpnEndpoint(
            CreateClientVpnEndpointRequest createClientVpnEndpointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createClientVpnEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createClientVpnEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateClientVpnEndpoint");

            HttpResponseHandler<CreateClientVpnEndpointResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateClientVpnEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateClientVpnEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateClientVpnEndpointRequest, CreateClientVpnEndpointResponse>()
                            .withOperationName("CreateClientVpnEndpoint").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateClientVpnEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createClientVpnEndpointRequest));
            CompletableFuture<CreateClientVpnEndpointResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds a route to a network to a Client VPN endpoint. Each Client VPN endpoint has a route table that describes the
     * available destination network routes. Each route in the route table specifies the path for traﬃc to speciﬁc
     * resources or networks.
     * </p>
     *
     * @param createClientVpnRouteRequest
     * @return A Java Future containing the result of the CreateClientVpnRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateClientVpnRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateClientVpnRoute" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateClientVpnRouteResponse> createClientVpnRoute(
            CreateClientVpnRouteRequest createClientVpnRouteRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createClientVpnRouteRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createClientVpnRouteRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateClientVpnRoute");

            HttpResponseHandler<CreateClientVpnRouteResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateClientVpnRouteResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateClientVpnRouteResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateClientVpnRouteRequest, CreateClientVpnRouteResponse>()
                            .withOperationName("CreateClientVpnRoute").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateClientVpnRouteRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createClientVpnRouteRequest));
            CompletableFuture<CreateClientVpnRouteResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a range of customer-owned IP addresses.
     * </p>
     *
     * @param createCoipCidrRequest
     * @return A Java Future containing the result of the CreateCoipCidr operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateCoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCoipCidr" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCoipCidrResponse> createCoipCidr(CreateCoipCidrRequest createCoipCidrRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCoipCidrRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCoipCidrRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCoipCidr");

            HttpResponseHandler<CreateCoipCidrResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateCoipCidrResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateCoipCidrResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCoipCidrRequest, CreateCoipCidrResponse>()
                            .withOperationName("CreateCoipCidr").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateCoipCidrRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createCoipCidrRequest));
            CompletableFuture<CreateCoipCidrResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a pool of customer-owned IP (CoIP) addresses.
     * </p>
     *
     * @param createCoipPoolRequest
     * @return A Java Future containing the result of the CreateCoipPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateCoipPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCoipPool" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCoipPoolResponse> createCoipPool(CreateCoipPoolRequest createCoipPoolRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCoipPoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCoipPoolRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCoipPool");

            HttpResponseHandler<CreateCoipPoolResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateCoipPoolResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateCoipPoolResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCoipPoolRequest, CreateCoipPoolResponse>()
                            .withOperationName("CreateCoipPool").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateCoipPoolRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createCoipPoolRequest));
            CompletableFuture<CreateCoipPoolResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides information to Amazon Web Services about your customer gateway device. The customer gateway device is
     * the appliance at your end of the VPN connection. You must provide the IP address of the customer gateway device’s
     * external interface. The IP address must be static and can be behind a device performing network address
     * translation (NAT).
     * </p>
     * <p>
     * For devices that use Border Gateway Protocol (BGP), you can also provide the device's BGP Autonomous System
     * Number (ASN). You can use an existing ASN assigned to your network. If you don't have an ASN already, you can use
     * a private ASN. For more information, see <a
     * href="https://docs.aws.amazon.com/vpn/latest/s2svpn/cgw-options.html">Customer gateway options for your
     * Site-to-Site VPN connection</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     * <p>
     * To create more than one customer gateway with the same VPN type, IP address, and BGP ASN, specify a unique device
     * name for each customer gateway. An identical request returns information about the existing customer gateway; it
     * doesn't create a new customer gateway.
     * </p>
     *
     * @param createCustomerGatewayRequest
     *        Contains the parameters for CreateCustomerGateway.
     * @return A Java Future containing the result of the CreateCustomerGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateCustomerGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCustomerGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCustomerGatewayResponse> createCustomerGateway(
            CreateCustomerGatewayRequest createCustomerGatewayRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCustomerGatewayRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCustomerGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCustomerGateway");

            HttpResponseHandler<CreateCustomerGatewayResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateCustomerGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateCustomerGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCustomerGatewayRequest, CreateCustomerGatewayResponse>()
                            .withOperationName("CreateCustomerGateway").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateCustomerGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createCustomerGatewayRequest));
            CompletableFuture<CreateCustomerGatewayResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a default subnet with a size <code>/20</code> IPv4 CIDR block in the specified Availability Zone in your
     * default VPC. You can have only one default subnet per Availability Zone. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html#create-default-subnet">Create a default
     * subnet</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param createDefaultSubnetRequest
     * @return A Java Future containing the result of the CreateDefaultSubnet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateDefaultSubnet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultSubnet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDefaultSubnetResponse> createDefaultSubnet(
            CreateDefaultSubnetRequest createDefaultSubnetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDefaultSubnetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDefaultSubnetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDefaultSubnet");

            HttpResponseHandler<CreateDefaultSubnetResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateDefaultSubnetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateDefaultSubnetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDefaultSubnetRequest, CreateDefaultSubnetResponse>()
                            .withOperationName("CreateDefaultSubnet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateDefaultSubnetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDefaultSubnetRequest));
            CompletableFuture<CreateDefaultSubnetResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a default VPC with a size <code>/16</code> IPv4 CIDR block and a default subnet in each Availability
     * Zone. For more information about the components of a default VPC, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html">Default VPCs</a> in the <i>Amazon VPC
     * User Guide</i>. You cannot specify the components of the default VPC yourself.
     * </p>
     * <p>
     * If you deleted your previous default VPC, you can create a default VPC. You cannot have more than one default VPC
     * per Region.
     * </p>
     *
     * @param createDefaultVpcRequest
     * @return A Java Future containing the result of the CreateDefaultVpc operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateDefaultVpc
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultVpc" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDefaultVpcResponse> createDefaultVpc(CreateDefaultVpcRequest createDefaultVpcRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDefaultVpcRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDefaultVpcRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDefaultVpc");

            HttpResponseHandler<CreateDefaultVpcResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateDefaultVpcResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateDefaultVpcResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDefaultVpcRequest, CreateDefaultVpcResponse>()
                            .withOperationName("CreateDefaultVpc").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateDefaultVpcRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDefaultVpcRequest));
            CompletableFuture<CreateDefaultVpcResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a custom set of DHCP options. After you create a DHCP option set, you associate it with a VPC. After you
     * associate a DHCP option set with a VPC, all existing and newly launched instances in the VPC use this set of DHCP
     * options.
     * </p>
     * <p>
     * The following are the individual DHCP options you can specify. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP options sets</a> in the
     * <i>Amazon VPC User Guide</i>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>domain-name</code> - If you're using AmazonProvidedDNS in <code>us-east-1</code>, specify
     * <code>ec2.internal</code>. If you're using AmazonProvidedDNS in any other Region, specify
     * <code>region.compute.internal</code>. Otherwise, specify a custom domain name. This value is used to complete
     * unqualified DNS hostnames.
     * </p>
     * <p>
     * Some Linux operating systems accept multiple domain names separated by spaces. However, Windows and other Linux
     * operating systems treat the value as a single domain, which results in unexpected behavior. If your DHCP option
     * set is associated with a VPC that has instances running operating systems that treat the value as a single
     * domain, specify only one domain name.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>domain-name-servers</code> - The IP addresses of up to four DNS servers, or AmazonProvidedDNS. To specify
     * multiple domain name servers in a single parameter, separate the IP addresses using commas. To have your
     * instances receive custom DNS hostnames as specified in <code>domain-name</code>, you must specify a custom DNS
     * server.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ntp-servers</code> - The IP addresses of up to eight Network Time Protocol (NTP) servers (four IPv4
     * addresses and four IPv6 addresses).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>netbios-name-servers</code> - The IP addresses of up to four NetBIOS name servers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>netbios-node-type</code> - The NetBIOS node type (1, 2, 4, or 8). We recommend that you specify 2.
     * Broadcast and multicast are not supported. For more information about NetBIOS node types, see <a
     * href="http://www.ietf.org/rfc/rfc2132.txt">RFC 2132</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ipv6-preferred-lease-time</code> - A value (in seconds, minutes, hours, or years) for how frequently a
     * running instance with an IPv6 assigned to it goes through DHCPv6 lease renewal. Acceptable values are between 140
     * and 2147483647 seconds (approximately 68 years). If no value is entered, the default lease time is 140 seconds.
     * If you use long-term addressing for EC2 instances, you can increase the lease time and avoid frequent lease
     * renewal requests. Lease renewal typically occurs when half of the lease time has elapsed.
     * </p>
     * </li>
     * </ul>
     *
     * @param createDhcpOptionsRequest
     * @return A Java Future containing the result of the CreateDhcpOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateDhcpOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDhcpOptions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDhcpOptionsResponse> createDhcpOptions(CreateDhcpOptionsRequest createDhcpOptionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDhcpOptionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDhcpOptionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDhcpOptions");

            HttpResponseHandler<CreateDhcpOptionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateDhcpOptionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateDhcpOptionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDhcpOptionsRequest, CreateDhcpOptionsResponse>()
                            .withOperationName("CreateDhcpOptions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateDhcpOptionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDhcpOptionsRequest));
            CompletableFuture<CreateDhcpOptionsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * [IPv6 only] Creates an egress-only internet gateway for your VPC. An egress-only internet gateway is used to
     * enable outbound communication over IPv6 from instances in your VPC to the internet, and prevents hosts outside of
     * your VPC from initiating an IPv6 connection with your instance.
     * </p>
     *
     * @param createEgressOnlyInternetGatewayRequest
     * @return A Java Future containing the result of the CreateEgressOnlyInternetGateway operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateEgressOnlyInternetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateEgressOnlyInternetGateway"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateEgressOnlyInternetGatewayResponse> createEgressOnlyInternetGateway(
            CreateEgressOnlyInternetGatewayRequest createEgressOnlyInternetGatewayRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createEgressOnlyInternetGatewayRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createEgressOnlyInternetGatewayRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEgressOnlyInternetGateway");

            HttpResponseHandler<CreateEgressOnlyInternetGatewayResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateEgressOnlyInternetGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateEgressOnlyInternetGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateEgressOnlyInternetGatewayRequest, CreateEgressOnlyInternetGatewayResponse>()
                            .withOperationName("CreateEgressOnlyInternetGateway").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateEgressOnlyInternetGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createEgressOnlyInternetGatewayRequest));
            CompletableFuture<CreateEgressOnlyInternetGatewayResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an EC2 Fleet that contains the configuration information for On-Demand Instances and Spot Instances.
     * Instances are launched immediately if there is available capacity.
     * </p>
     * <p>
     * A single EC2 Fleet can include multiple launch specifications that vary by instance type, AMI, Availability Zone,
     * or subnet.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html">EC2
     * Fleet</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createFleetRequest
     * @return A Java Future containing the result of the CreateFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFleetResponse> createFleet(CreateFleetRequest createFleetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFleetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFleet");

            HttpResponseHandler<CreateFleetResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateFleetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateFleetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFleetRequest, CreateFleetResponse>()
                            .withOperationName("CreateFleet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateFleetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createFleetRequest));
            CompletableFuture<CreateFleetResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates one or more flow logs to capture information about IP traffic for a specific network interface, subnet,
     * or VPC.
     * </p>
     * <p>
     * Flow log data for a monitored network interface is recorded as flow log records, which are log events consisting
     * of fields that describe the traffic flow. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records">Flow log records</a> in
     * the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <p>
     * When publishing to CloudWatch Logs, flow log records are published to a log group, and each network interface has
     * a unique log stream in the log group. When publishing to Amazon S3, flow log records for all of the monitored
     * network interfaces are published to a single log file object that is stored in the specified bucket.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html">VPC Flow
     * Logs</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param createFlowLogsRequest
     * @return A Java Future containing the result of the CreateFlowLogs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateFlowLogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFlowLogs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFlowLogsResponse> createFlowLogs(CreateFlowLogsRequest createFlowLogsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFlowLogsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFlowLogsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFlowLogs");

            HttpResponseHandler<CreateFlowLogsResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateFlowLogsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateFlowLogsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFlowLogsRequest, CreateFlowLogsResponse>()
                            .withOperationName("CreateFlowLogs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateFlowLogsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createFlowLogsRequest));
            CompletableFuture<CreateFlowLogsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Amazon FPGA Image (AFI) from the specified design checkpoint (DCP).
     * </p>
     * <p>
     * The create operation is asynchronous. To verify that the AFI is ready for use, check the output logs.
     * </p>
     * <p>
     * An AFI contains the FPGA bitstream that is ready to download to an FPGA. You can securely deploy an AFI on
     * multiple FPGA-accelerated instances. For more information, see the <a
     * href="https://github.com/aws/aws-fpga/">Amazon Web Services FPGA Hardware Development Kit</a>.
     * </p>
     *
     * @param createFpgaImageRequest
     * @return A Java Future containing the result of the CreateFpgaImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateFpgaImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFpgaImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFpgaImageResponse> createFpgaImage(CreateFpgaImageRequest createFpgaImageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFpgaImageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFpgaImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFpgaImage");

            HttpResponseHandler<CreateFpgaImageResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateFpgaImageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateFpgaImageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFpgaImageRequest, CreateFpgaImageResponse>()
                            .withOperationName("CreateFpgaImage").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateFpgaImageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createFpgaImageRequest));
            CompletableFuture<CreateFpgaImageResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Amazon EBS-backed AMI from an Amazon EBS-backed instance that is either running or stopped.
     * </p>
     * <p>
     * If you customized your instance with instance store volumes or Amazon EBS volumes in addition to the root device
     * volume, the new AMI contains block device mapping information for those volumes. When you launch an instance from
     * this new AMI, the instance automatically launches with those additional volumes.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html">Create an Amazon EBS-backed
     * Linux AMI</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param createImageRequest
     * @return A Java Future containing the result of the CreateImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateImageResponse> createImage(CreateImageRequest createImageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createImageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateImage");

            HttpResponseHandler<CreateImageResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateImageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateImageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateImageRequest, CreateImageResponse>()
                            .withOperationName("CreateImage").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateImageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createImageRequest));
            CompletableFuture<CreateImageResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an EC2 Instance Connect Endpoint.
     * </p>
     * <p>
     * An EC2 Instance Connect Endpoint allows you to connect to an instance, without requiring the instance to have a
     * public IPv4 address. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Connect-using-EC2-Instance-Connect-Endpoint.html"
     * >Connect to your instances without requiring a public IPv4 address using EC2 Instance Connect Endpoint</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createInstanceConnectEndpointRequest
     * @return A Java Future containing the result of the CreateInstanceConnectEndpoint operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateInstanceConnectEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceConnectEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateInstanceConnectEndpointResponse> createInstanceConnectEndpoint(
            CreateInstanceConnectEndpointRequest createInstanceConnectEndpointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createInstanceConnectEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createInstanceConnectEndpointRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateInstanceConnectEndpoint");

            HttpResponseHandler<CreateInstanceConnectEndpointResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateInstanceConnectEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateInstanceConnectEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateInstanceConnectEndpointRequest, CreateInstanceConnectEndpointResponse>()
                            .withOperationName("CreateInstanceConnectEndpoint").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateInstanceConnectEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createInstanceConnectEndpointRequest));
            CompletableFuture<CreateInstanceConnectEndpointResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an event window in which scheduled events for the associated Amazon EC2 instances can run.
     * </p>
     * <p>
     * You can define either a set of time ranges or a cron expression when creating the event window, but not both. All
     * event window times are in UTC.
     * </p>
     * <p>
     * You can create up to 200 event windows per Amazon Web Services Region.
     * </p>
     * <p>
     * When you create the event window, targets (instance IDs, Dedicated Host IDs, or tags) are not yet associated with
     * it. To ensure that the event window can be used, you must associate one or more targets with it by using the
     * <a>AssociateInstanceEventWindow</a> API.
     * </p>
     * <important>
     * <p>
     * Event windows are applicable only for scheduled events that stop, reboot, or terminate instances.
     * </p>
     * <p>
     * Event windows are <i>not</i> applicable for:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Expedited scheduled events and network maintenance events.
     * </p>
     * </li>
     * <li>
     * <p>
     * Unscheduled maintenance such as AutoRecovery and unplanned reboots.
     * </p>
     * </li>
     * </ul>
     * </important>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define
     * event windows for scheduled events</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createInstanceEventWindowRequest
     * @return A Java Future containing the result of the CreateInstanceEventWindow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateInstanceEventWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceEventWindow" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateInstanceEventWindowResponse> createInstanceEventWindow(
            CreateInstanceEventWindowRequest createInstanceEventWindowRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createInstanceEventWindowRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createInstanceEventWindowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateInstanceEventWindow");

            HttpResponseHandler<CreateInstanceEventWindowResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateInstanceEventWindowResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateInstanceEventWindowResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateInstanceEventWindowRequest, CreateInstanceEventWindowResponse>()
                            .withOperationName("CreateInstanceEventWindow").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateInstanceEventWindowRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createInstanceEventWindowRequest));
            CompletableFuture<CreateInstanceEventWindowResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Exports a running or stopped instance to an Amazon S3 bucket.
     * </p>
     * <p>
     * For information about the prerequisites for your Amazon S3 bucket, supported operating systems, image formats,
     * and known limitations for the types of instances you can export, see <a
     * href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmexport.html">Exporting an instance as a VM Using
     * VM Import/Export</a> in the <i>VM Import/Export User Guide</i>.
     * </p>
     *
     * @param createInstanceExportTaskRequest
     * @return A Java Future containing the result of the CreateInstanceExportTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateInstanceExportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceExportTask" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateInstanceExportTaskResponse> createInstanceExportTask(
            CreateInstanceExportTaskRequest createInstanceExportTaskRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createInstanceExportTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createInstanceExportTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateInstanceExportTask");

            HttpResponseHandler<CreateInstanceExportTaskResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateInstanceExportTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateInstanceExportTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateInstanceExportTaskRequest, CreateInstanceExportTaskResponse>()
                            .withOperationName("CreateInstanceExportTask").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateInstanceExportTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createInstanceExportTaskRequest));
            CompletableFuture<CreateInstanceExportTaskResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an internet gateway for use with a VPC. After creating the internet gateway, you attach it to a VPC using
     * <a>AttachInternetGateway</a>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Internet_Gateway.html">Internet gateways</a> in the
     * <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param createInternetGatewayRequest
     * @return A Java Future containing the result of the CreateInternetGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateInternetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInternetGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateInternetGatewayResponse> createInternetGateway(
            CreateInternetGatewayRequest createInternetGatewayRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createInternetGatewayRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createInternetGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateInternetGateway");

            HttpResponseHandler<CreateInternetGatewayResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateInternetGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateInternetGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateInternetGatewayRequest, CreateInternetGatewayResponse>()
                            .withOperationName("CreateInternetGateway").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateInternetGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createInternetGatewayRequest));
            CompletableFuture<CreateInternetGatewayResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Create an IPAM. Amazon VPC IP Address Manager (IPAM) is a VPC feature that you can use to automate your IP
     * address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across
     * Amazon Web Services Regions and accounts throughout your Amazon Web Services Organization.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/create-ipam.html">Create an
     * IPAM</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     *
     * @param createIpamRequest
     * @return A Java Future containing the result of the CreateIpam operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateIpam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpam" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateIpamResponse> createIpam(CreateIpamRequest createIpamRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createIpamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIpamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIpam");

            HttpResponseHandler<CreateIpamResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateIpamResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateIpamResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateIpamRequest, CreateIpamResponse>().withOperationName("CreateIpam")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateIpamRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createIpamRequest));
            CompletableFuture<CreateIpamResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Create an IP address pool for Amazon VPC IP Address Manager (IPAM). In IPAM, a pool is a collection of contiguous
     * IP addresses CIDRs. Pools enable you to organize your IP addresses according to your routing and security needs.
     * For example, if you have separate routing and security needs for development and production applications, you can
     * create a pool for each.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/create-top-ipam.html">Create a
     * top-level pool</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     *
     * @param createIpamPoolRequest
     * @return A Java Future containing the result of the CreateIpamPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateIpamPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamPool" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateIpamPoolResponse> createIpamPool(CreateIpamPoolRequest createIpamPoolRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createIpamPoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIpamPoolRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIpamPool");

            HttpResponseHandler<CreateIpamPoolResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateIpamPoolResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateIpamPoolResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateIpamPoolRequest, CreateIpamPoolResponse>()
                            .withOperationName("CreateIpamPool").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateIpamPoolRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createIpamPoolRequest));
            CompletableFuture<CreateIpamPoolResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an IPAM resource discovery. A resource discovery is an IPAM component that enables IPAM to manage and
     * monitor resources that belong to the owning account.
     * </p>
     *
     * @param createIpamResourceDiscoveryRequest
     * @return A Java Future containing the result of the CreateIpamResourceDiscovery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateIpamResourceDiscovery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamResourceDiscovery"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateIpamResourceDiscoveryResponse> createIpamResourceDiscovery(
            CreateIpamResourceDiscoveryRequest createIpamResourceDiscoveryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createIpamResourceDiscoveryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIpamResourceDiscoveryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIpamResourceDiscovery");

            HttpResponseHandler<CreateIpamResourceDiscoveryResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateIpamResourceDiscoveryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateIpamResourceDiscoveryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateIpamResourceDiscoveryRequest, CreateIpamResourceDiscoveryResponse>()
                            .withOperationName("CreateIpamResourceDiscovery").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateIpamResourceDiscoveryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createIpamResourceDiscoveryRequest));
            CompletableFuture<CreateIpamResourceDiscoveryResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Create an IPAM scope. In IPAM, a scope is the highest-level container within IPAM. An IPAM contains two default
     * scopes. Each scope represents the IP space for a single network. The private scope is intended for all private IP
     * address space. The public scope is intended for all public IP address space. Scopes enable you to reuse IP
     * addresses across multiple unconnected networks without causing IP address overlap or conflict.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/add-scope-ipam.html">Add a
     * scope</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     *
     * @param createIpamScopeRequest
     * @return A Java Future containing the result of the CreateIpamScope operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateIpamScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamScope" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateIpamScopeResponse> createIpamScope(CreateIpamScopeRequest createIpamScopeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createIpamScopeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIpamScopeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIpamScope");

            HttpResponseHandler<CreateIpamScopeResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateIpamScopeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateIpamScopeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateIpamScopeRequest, CreateIpamScopeResponse>()
                            .withOperationName("CreateIpamScope").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateIpamScopeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createIpamScopeRequest));
            CompletableFuture<CreateIpamScopeResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an ED25519 or 2048-bit RSA key pair with the specified name and in the specified PEM or PPK format.
     * Amazon EC2 stores the public key and displays the private key for you to save to a file. The private key is
     * returned as an unencrypted PEM encoded PKCS#1 private key or an unencrypted PPK formatted private key for use
     * with PuTTY. If a key with the specified name already exists, Amazon EC2 returns an error.
     * </p>
     * <p>
     * The key pair returned to you is available only in the Amazon Web Services Region in which you create it. If you
     * prefer, you can create your own key pair using a third-party tool and upload it to any Region using
     * <a>ImportKeyPair</a>.
     * </p>
     * <p>
     * You can have up to 5,000 key pairs per Amazon Web Services Region.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon
     * EC2 key pairs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param createKeyPairRequest
     * @return A Java Future containing the result of the CreateKeyPair operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateKeyPair
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateKeyPairResponse> createKeyPair(CreateKeyPairRequest createKeyPairRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createKeyPairRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createKeyPairRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateKeyPair");

            HttpResponseHandler<CreateKeyPairResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateKeyPairResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateKeyPairResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateKeyPairRequest, CreateKeyPairResponse>()
                            .withOperationName("CreateKeyPair").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateKeyPairRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createKeyPairRequest));
            CompletableFuture<CreateKeyPairResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a launch template.
     * </p>
     * <p>
     * A launch template contains the parameters to launch an instance. When you launch an instance using
     * <a>RunInstances</a>, you can specify a launch template instead of providing the launch parameters in the request.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html">Launch an instance from a
     * launch template</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * If you want to clone an existing launch template as the basis for creating a new launch template, you can use the
     * Amazon EC2 console. The API, SDKs, and CLI do not support cloning a template. For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template-from-existing-launch-template"
     * >Create a launch template from an existing launch template</a> in the <i>Amazon Elastic Compute Cloud User
     * Guide</i>.
     * </p>
     *
     * @param createLaunchTemplateRequest
     * @return A Java Future containing the result of the CreateLaunchTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateLaunchTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLaunchTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateLaunchTemplateResponse> createLaunchTemplate(
            CreateLaunchTemplateRequest createLaunchTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createLaunchTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createLaunchTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLaunchTemplate");

            HttpResponseHandler<CreateLaunchTemplateResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateLaunchTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateLaunchTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateLaunchTemplateRequest, CreateLaunchTemplateResponse>()
                            .withOperationName("CreateLaunchTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateLaunchTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createLaunchTemplateRequest));
            CompletableFuture<CreateLaunchTemplateResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new version of a launch template. You can specify an existing version of launch template from which to
     * base the new version.
     * </p>
     * <p>
     * Launch template versions are numbered in the order in which they are created. You cannot specify, change, or
     * replace the numbering of launch template versions.
     * </p>
     * <p>
     * Launch templates are immutable; after you create a launch template, you can't modify it. Instead, you can create
     * a new version of the launch template that includes any changes you require.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#manage-launch-template-versions"
     * >Modify a launch template (manage launch template versions)</a> in the <i>Amazon Elastic Compute Cloud User
     * Guide</i>.
     * </p>
     *
     * @param createLaunchTemplateVersionRequest
     * @return A Java Future containing the result of the CreateLaunchTemplateVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateLaunchTemplateVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLaunchTemplateVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateLaunchTemplateVersionResponse> createLaunchTemplateVersion(
            CreateLaunchTemplateVersionRequest createLaunchTemplateVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createLaunchTemplateVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createLaunchTemplateVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLaunchTemplateVersion");

            HttpResponseHandler<CreateLaunchTemplateVersionResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateLaunchTemplateVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateLaunchTemplateVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateLaunchTemplateVersionRequest, CreateLaunchTemplateVersionResponse>()
                            .withOperationName("CreateLaunchTemplateVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateLaunchTemplateVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createLaunchTemplateVersionRequest));
            CompletableFuture<CreateLaunchTemplateVersionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a static route for the specified local gateway route table. You must specify one of the following
     * targets:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LocalGatewayVirtualInterfaceGroupId</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NetworkInterfaceId</code>
     * </p>
     * </li>
     * </ul>
     *
     * @param createLocalGatewayRouteRequest
     * @return A Java Future containing the result of the CreateLocalGatewayRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateLocalGatewayRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateLocalGatewayRouteResponse> createLocalGatewayRoute(
            CreateLocalGatewayRouteRequest createLocalGatewayRouteRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createLocalGatewayRouteRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createLocalGatewayRouteRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLocalGatewayRoute");

            HttpResponseHandler<CreateLocalGatewayRouteResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateLocalGatewayRouteResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateLocalGatewayRouteResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateLocalGatewayRouteRequest, CreateLocalGatewayRouteResponse>()
                            .withOperationName("CreateLocalGatewayRoute").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateLocalGatewayRouteRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createLocalGatewayRouteRequest));
            CompletableFuture<CreateLocalGatewayRouteResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a local gateway route table.
     * </p>
     *
     * @param createLocalGatewayRouteTableRequest
     * @return A Java Future containing the result of the CreateLocalGatewayRouteTable operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateLocalGatewayRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteTable"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateLocalGatewayRouteTableResponse> createLocalGatewayRouteTable(
            CreateLocalGatewayRouteTableRequest createLocalGatewayRouteTableRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createLocalGatewayRouteTableRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createLocalGatewayRouteTableRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLocalGatewayRouteTable");

            HttpResponseHandler<CreateLocalGatewayRouteTableResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateLocalGatewayRouteTableResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateLocalGatewayRouteTableResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateLocalGatewayRouteTableRequest, CreateLocalGatewayRouteTableResponse>()
                            .withOperationName("CreateLocalGatewayRouteTable").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateLocalGatewayRouteTableRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createLocalGatewayRouteTableRequest));
            CompletableFuture<CreateLocalGatewayRouteTableResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a local gateway route table virtual interface group association.
     * </p>
     *
     * @param createLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest
     * @return A Java Future containing the result of the CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation
     *         operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse> createLocalGatewayRouteTableVirtualInterfaceGroupAssociation(
            CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest createLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                createLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME,
                    "CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation");

            HttpResponseHandler<CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest, CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse>()
                            .withOperationName("CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(
                                    new CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequestMarshaller(
                                            protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(createLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest));
            CompletableFuture<CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates the specified VPC with the specified local gateway route table.
     * </p>
     *
     * @param createLocalGatewayRouteTableVpcAssociationRequest
     * @return A Java Future containing the result of the CreateLocalGatewayRouteTableVpcAssociation operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateLocalGatewayRouteTableVpcAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteTableVpcAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateLocalGatewayRouteTableVpcAssociationResponse> createLocalGatewayRouteTableVpcAssociation(
            CreateLocalGatewayRouteTableVpcAssociationRequest createLocalGatewayRouteTableVpcAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                createLocalGatewayRouteTableVpcAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createLocalGatewayRouteTableVpcAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLocalGatewayRouteTableVpcAssociation");

            HttpResponseHandler<CreateLocalGatewayRouteTableVpcAssociationResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateLocalGatewayRouteTableVpcAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateLocalGatewayRouteTableVpcAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateLocalGatewayRouteTableVpcAssociationRequest, CreateLocalGatewayRouteTableVpcAssociationResponse>()
                            .withOperationName("CreateLocalGatewayRouteTableVpcAssociation")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateLocalGatewayRouteTableVpcAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createLocalGatewayRouteTableVpcAssociationRequest));
            CompletableFuture<CreateLocalGatewayRouteTableVpcAssociationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a managed prefix list. You can specify one or more entries for the prefix list. Each entry consists of a
     * CIDR block and an optional description.
     * </p>
     *
     * @param createManagedPrefixListRequest
     * @return A Java Future containing the result of the CreateManagedPrefixList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateManagedPrefixList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateManagedPrefixList" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateManagedPrefixListResponse> createManagedPrefixList(
            CreateManagedPrefixListRequest createManagedPrefixListRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createManagedPrefixListRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createManagedPrefixListRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateManagedPrefixList");

            HttpResponseHandler<CreateManagedPrefixListResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateManagedPrefixListResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateManagedPrefixListResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateManagedPrefixListRequest, CreateManagedPrefixListResponse>()
                            .withOperationName("CreateManagedPrefixList").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateManagedPrefixListRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createManagedPrefixListRequest));
            CompletableFuture<CreateManagedPrefixListResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a NAT gateway in the specified subnet. This action creates a network interface in the specified subnet
     * with a private IP address from the IP address range of the subnet. You can create either a public NAT gateway or
     * a private NAT gateway.
     * </p>
     * <p>
     * With a public NAT gateway, internet-bound traffic from a private subnet can be routed to the NAT gateway, so that
     * instances in a private subnet can connect to the internet.
     * </p>
     * <p>
     * With a private NAT gateway, private communication is routed across VPCs and on-premises networks through a
     * transit gateway or virtual private gateway. Common use cases include running large workloads behind a small pool
     * of allowlisted IPv4 addresses, preserving private IPv4 addresses, and communicating between overlapping networks.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html">NAT
     * gateways</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <important>
     * <p>
     * When you create a public NAT gateway and assign it an EIP or secondary EIPs, the network border group of the EIPs
     * must match the network border group of the Availability Zone (AZ) that the public NAT gateway is in. If it's not
     * the same, the NAT gateway will fail to launch. You can see the network border group for the subnet's AZ by
     * viewing the details of the subnet. Similarly, you can view the network border group of an EIP by viewing the
     * details of the EIP address. For more information about network border groups and EIPs, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-eips.html#allocate-eip">Allocate an Elastic IP
     * address</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * </important>
     *
     * @param createNatGatewayRequest
     * @return A Java Future containing the result of the CreateNatGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateNatGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNatGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateNatGatewayResponse> createNatGateway(CreateNatGatewayRequest createNatGatewayRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createNatGatewayRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createNatGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNatGateway");

            HttpResponseHandler<CreateNatGatewayResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateNatGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateNatGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateNatGatewayRequest, CreateNatGatewayResponse>()
                            .withOperationName("CreateNatGateway").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateNatGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createNatGatewayRequest));
            CompletableFuture<CreateNatGatewayResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a network ACL in a VPC. Network ACLs provide an optional layer of security (in addition to security
     * groups) for the instances in your VPC.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-network-acls.html">Network ACLs</a> in the <i>Amazon
     * VPC User Guide</i>.
     * </p>
     *
     * @param createNetworkAclRequest
     * @return A Java Future containing the result of the CreateNetworkAcl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateNetworkAcl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAcl" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateNetworkAclResponse> createNetworkAcl(CreateNetworkAclRequest createNetworkAclRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createNetworkAclRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createNetworkAclRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNetworkAcl");

            HttpResponseHandler<CreateNetworkAclResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateNetworkAclResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateNetworkAclResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateNetworkAclRequest, CreateNetworkAclResponse>()
                            .withOperationName("CreateNetworkAcl").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateNetworkAclRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createNetworkAclRequest));
            CompletableFuture<CreateNetworkAclResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an entry (a rule) in a network ACL with the specified rule number. Each network ACL has a set of numbered
     * ingress rules and a separate set of numbered egress rules. When determining whether a packet should be allowed in
     * or out of a subnet associated with the ACL, we process the entries in the ACL according to the rule numbers, in
     * ascending order. Each network ACL has a set of ingress rules and a separate set of egress rules.
     * </p>
     * <p>
     * We recommend that you leave room between the rule numbers (for example, 100, 110, 120, ...), and not number them
     * one right after the other (for example, 101, 102, 103, ...). This makes it easier to add a rule between existing
     * ones without having to renumber the rules.
     * </p>
     * <p>
     * After you add an entry, you can't modify it; you must either replace it, or create an entry and delete the old
     * one.
     * </p>
     * <p>
     * For more information about network ACLs, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-network-acls.html">Network ACLs</a> in the <i>Amazon
     * VPC User Guide</i>.
     * </p>
     *
     * @param createNetworkAclEntryRequest
     * @return A Java Future containing the result of the CreateNetworkAclEntry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateNetworkAclEntry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAclEntry" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateNetworkAclEntryResponse> createNetworkAclEntry(
            CreateNetworkAclEntryRequest createNetworkAclEntryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createNetworkAclEntryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createNetworkAclEntryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNetworkAclEntry");

            HttpResponseHandler<CreateNetworkAclEntryResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateNetworkAclEntryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateNetworkAclEntryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateNetworkAclEntryRequest, CreateNetworkAclEntryResponse>()
                            .withOperationName("CreateNetworkAclEntry").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateNetworkAclEntryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createNetworkAclEntryRequest));
            CompletableFuture<CreateNetworkAclEntryResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a Network Access Scope.
     * </p>
     * <p>
     * Amazon Web Services Network Access Analyzer enables cloud networking and cloud operations teams to verify that
     * their networks on Amazon Web Services conform to their network security and governance objectives. For more
     * information, see the <a href="https://docs.aws.amazon.com/vpc/latest/network-access-analyzer/">Amazon Web
     * Services Network Access Analyzer Guide</a>.
     * </p>
     *
     * @param createNetworkInsightsAccessScopeRequest
     * @return A Java Future containing the result of the CreateNetworkInsightsAccessScope operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateNetworkInsightsAccessScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInsightsAccessScope"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateNetworkInsightsAccessScopeResponse> createNetworkInsightsAccessScope(
            CreateNetworkInsightsAccessScopeRequest createNetworkInsightsAccessScopeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createNetworkInsightsAccessScopeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createNetworkInsightsAccessScopeRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNetworkInsightsAccessScope");

            HttpResponseHandler<CreateNetworkInsightsAccessScopeResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateNetworkInsightsAccessScopeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateNetworkInsightsAccessScopeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateNetworkInsightsAccessScopeRequest, CreateNetworkInsightsAccessScopeResponse>()
                            .withOperationName("CreateNetworkInsightsAccessScope").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateNetworkInsightsAccessScopeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createNetworkInsightsAccessScopeRequest));
            CompletableFuture<CreateNetworkInsightsAccessScopeResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a path to analyze for reachability.
     * </p>
     * <p>
     * Reachability Analyzer enables you to analyze and debug network reachability between two resources in your virtual
     * private cloud (VPC). For more information, see the <a
     * href="https://docs.aws.amazon.com/vpc/latest/reachability/">Reachability Analyzer Guide</a>.
     * </p>
     *
     * @param createNetworkInsightsPathRequest
     * @return A Java Future containing the result of the CreateNetworkInsightsPath operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateNetworkInsightsPath
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInsightsPath" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateNetworkInsightsPathResponse> createNetworkInsightsPath(
            CreateNetworkInsightsPathRequest createNetworkInsightsPathRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createNetworkInsightsPathRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createNetworkInsightsPathRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNetworkInsightsPath");

            HttpResponseHandler<CreateNetworkInsightsPathResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateNetworkInsightsPathResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateNetworkInsightsPathResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateNetworkInsightsPathRequest, CreateNetworkInsightsPathResponse>()
                            .withOperationName("CreateNetworkInsightsPath").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateNetworkInsightsPathRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createNetworkInsightsPathRequest));
            CompletableFuture<CreateNetworkInsightsPathResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a network interface in the specified subnet.
     * </p>
     * <p>
     * The number of IP addresses you can assign to a network interface varies by instance type. For more information,
     * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI">IP Addresses
     * Per ENI Per Instance Type</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <p>
     * For more information about network interfaces, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html">Elastic network interfaces</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param createNetworkInterfaceRequest
     * @return A Java Future containing the result of the CreateNetworkInterface operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterface" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateNetworkInterfaceResponse> createNetworkInterface(
            CreateNetworkInterfaceRequest createNetworkInterfaceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createNetworkInterfaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createNetworkInterfaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNetworkInterface");

            HttpResponseHandler<CreateNetworkInterfaceResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateNetworkInterfaceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateNetworkInterfaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateNetworkInterfaceRequest, CreateNetworkInterfaceResponse>()
                            .withOperationName("CreateNetworkInterface").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateNetworkInterfaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createNetworkInterfaceRequest));
            CompletableFuture<CreateNetworkInterfaceResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Grants an Amazon Web Services-authorized account permission to attach the specified network interface to an
     * instance in their account.
     * </p>
     * <p>
     * You can grant permission to a single Amazon Web Services account only, and only one account at a time.
     * </p>
     *
     * @param createNetworkInterfacePermissionRequest
     *        Contains the parameters for CreateNetworkInterfacePermission.
     * @return A Java Future containing the result of the CreateNetworkInterfacePermission operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateNetworkInterfacePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterfacePermission"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateNetworkInterfacePermissionResponse> createNetworkInterfacePermission(
            CreateNetworkInterfacePermissionRequest createNetworkInterfacePermissionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createNetworkInterfacePermissionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createNetworkInterfacePermissionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNetworkInterfacePermission");

            HttpResponseHandler<CreateNetworkInterfacePermissionResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateNetworkInterfacePermissionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateNetworkInterfacePermissionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateNetworkInterfacePermissionRequest, CreateNetworkInterfacePermissionResponse>()
                            .withOperationName("CreateNetworkInterfacePermission").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateNetworkInterfacePermissionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createNetworkInterfacePermissionRequest));
            CompletableFuture<CreateNetworkInterfacePermissionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a placement group in which to launch instances. The strategy of the placement group determines how the
     * instances are organized within the group.
     * </p>
     * <p>
     * A <code>cluster</code> placement group is a logical grouping of instances within a single Availability Zone that
     * benefit from low network latency, high network throughput. A <code>spread</code> placement group places instances
     * on distinct hardware. A <code>partition</code> placement group places groups of instances in different
     * partitions, where instances in one partition do not share the same hardware with instances in another partition.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createPlacementGroupRequest
     * @return A Java Future containing the result of the CreatePlacementGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreatePlacementGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreatePlacementGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreatePlacementGroupResponse> createPlacementGroup(
            CreatePlacementGroupRequest createPlacementGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPlacementGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPlacementGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePlacementGroup");

            HttpResponseHandler<CreatePlacementGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreatePlacementGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreatePlacementGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreatePlacementGroupRequest, CreatePlacementGroupResponse>()
                            .withOperationName("CreatePlacementGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreatePlacementGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createPlacementGroupRequest));
            CompletableFuture<CreatePlacementGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a public IPv4 address pool. A public IPv4 pool is an EC2 IP address pool required for the public IPv4
     * CIDRs that you own and bring to Amazon Web Services to manage with IPAM. IPv6 addresses you bring to Amazon Web
     * Services, however, use IPAM pools only. To monitor the status of pool creation, use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribePublicIpv4Pools.html"
     * >DescribePublicIpv4Pools</a>.
     * </p>
     *
     * @param createPublicIpv4PoolRequest
     * @return A Java Future containing the result of the CreatePublicIpv4Pool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreatePublicIpv4Pool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreatePublicIpv4Pool" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreatePublicIpv4PoolResponse> createPublicIpv4Pool(
            CreatePublicIpv4PoolRequest createPublicIpv4PoolRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPublicIpv4PoolRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPublicIpv4PoolRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePublicIpv4Pool");

            HttpResponseHandler<CreatePublicIpv4PoolResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreatePublicIpv4PoolResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreatePublicIpv4PoolResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreatePublicIpv4PoolRequest, CreatePublicIpv4PoolResponse>()
                            .withOperationName("CreatePublicIpv4Pool").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreatePublicIpv4PoolRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createPublicIpv4PoolRequest));
            CompletableFuture<CreatePublicIpv4PoolResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Replaces the EBS-backed root volume for a <code>running</code> instance with a new volume that is restored to the
     * original root volume's launch state, that is restored to a specific snapshot taken from the original root volume,
     * or that is restored from an AMI that has the same key characteristics as that of the instance.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/replace-root.html">Replace
     * a root volume</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param createReplaceRootVolumeTaskRequest
     * @return A Java Future containing the result of the CreateReplaceRootVolumeTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateReplaceRootVolumeTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateReplaceRootVolumeTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateReplaceRootVolumeTaskResponse> createReplaceRootVolumeTask(
            CreateReplaceRootVolumeTaskRequest createReplaceRootVolumeTaskRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createReplaceRootVolumeTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createReplaceRootVolumeTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateReplaceRootVolumeTask");

            HttpResponseHandler<CreateReplaceRootVolumeTaskResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateReplaceRootVolumeTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateReplaceRootVolumeTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateReplaceRootVolumeTaskRequest, CreateReplaceRootVolumeTaskResponse>()
                            .withOperationName("CreateReplaceRootVolumeTask").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateReplaceRootVolumeTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createReplaceRootVolumeTaskRequest));
            CompletableFuture<CreateReplaceRootVolumeTaskResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a listing for Amazon EC2 Standard Reserved Instances to be sold in the Reserved Instance Marketplace. You
     * can submit one Standard Reserved Instance listing at a time. To get a list of your Standard Reserved Instances,
     * you can use the <a>DescribeReservedInstances</a> operation.
     * </p>
     * <note>
     * <p>
     * Only Standard Reserved Instances can be sold in the Reserved Instance Marketplace. Convertible Reserved Instances
     * cannot be sold.
     * </p>
     * </note>
     * <p>
     * The Reserved Instance Marketplace matches sellers who want to resell Standard Reserved Instance capacity that
     * they no longer need with buyers who want to purchase additional capacity. Reserved Instances bought and sold
     * through the Reserved Instance Marketplace work like any other Reserved Instances.
     * </p>
     * <p>
     * To sell your Standard Reserved Instances, you must first register as a seller in the Reserved Instance
     * Marketplace. After completing the registration process, you can create a Reserved Instance Marketplace listing of
     * some or all of your Standard Reserved Instances, and specify the upfront price to receive for them. Your Standard
     * Reserved Instance listings then become available for purchase. To view the details of your Standard Reserved
     * Instance listing, you can use the <a>DescribeReservedInstancesListings</a> operation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance
     * Marketplace</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createReservedInstancesListingRequest
     *        Contains the parameters for CreateReservedInstancesListing.
     * @return A Java Future containing the result of the CreateReservedInstancesListing operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateReservedInstancesListing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateReservedInstancesListing"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateReservedInstancesListingResponse> createReservedInstancesListing(
            CreateReservedInstancesListingRequest createReservedInstancesListingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createReservedInstancesListingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createReservedInstancesListingRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateReservedInstancesListing");

            HttpResponseHandler<CreateReservedInstancesListingResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateReservedInstancesListingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateReservedInstancesListingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateReservedInstancesListingRequest, CreateReservedInstancesListingResponse>()
                            .withOperationName("CreateReservedInstancesListing").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateReservedInstancesListingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createReservedInstancesListingRequest));
            CompletableFuture<CreateReservedInstancesListingResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a task that restores an AMI from an Amazon S3 object that was previously created by using <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateStoreImageTask.html"
     * >CreateStoreImageTask</a>.
     * </p>
     * <p>
     * To use this API, you must have the required permissions. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html#ami-s3-permissions">Permissions
     * for storing and restoring AMIs using Amazon S3</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html">Store and restore an AMI using
     * Amazon S3</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createRestoreImageTaskRequest
     * @return A Java Future containing the result of the CreateRestoreImageTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateRestoreImageTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRestoreImageTask" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRestoreImageTaskResponse> createRestoreImageTask(
            CreateRestoreImageTaskRequest createRestoreImageTaskRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRestoreImageTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRestoreImageTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRestoreImageTask");

            HttpResponseHandler<CreateRestoreImageTaskResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateRestoreImageTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateRestoreImageTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRestoreImageTaskRequest, CreateRestoreImageTaskResponse>()
                            .withOperationName("CreateRestoreImageTask").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateRestoreImageTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createRestoreImageTaskRequest));
            CompletableFuture<CreateRestoreImageTaskResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a route in a route table within a VPC.
     * </p>
     * <p>
     * You must specify either a destination CIDR block or a prefix list ID. You must also specify exactly one of the
     * resources from the parameter list.
     * </p>
     * <p>
     * When determining how to route traffic, we use the route with the most specific match. For example, traffic is
     * destined for the IPv4 address <code>192.0.2.3</code>, and the route table includes the following two IPv4 routes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>192.0.2.0/24</code> (goes to some target A)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>192.0.2.0/28</code> (goes to some target B)
     * </p>
     * </li>
     * </ul>
     * <p>
     * Both routes apply to the traffic destined for <code>192.0.2.3</code>. However, the second route in the list
     * covers a smaller number of IP addresses and is therefore more specific, so we use that route to determine where
     * to target the traffic.
     * </p>
     * <p>
     * For more information about route tables, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route tables</a> in the <i>Amazon
     * VPC User Guide</i>.
     * </p>
     *
     * @param createRouteRequest
     * @return A Java Future containing the result of the CreateRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRoute" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRouteResponse> createRoute(CreateRouteRequest createRouteRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRouteRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRouteRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRoute");

            HttpResponseHandler<CreateRouteResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateRouteResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateRouteResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRouteRequest, CreateRouteResponse>()
                            .withOperationName("CreateRoute").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateRouteRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createRouteRequest));
            CompletableFuture<CreateRouteResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a route table for the specified VPC. After you create a route table, you can add routes and associate the
     * table with a subnet.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route
     * tables</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param createRouteTableRequest
     * @return A Java Future containing the result of the CreateRouteTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteTable" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRouteTableResponse> createRouteTable(CreateRouteTableRequest createRouteTableRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRouteTableRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRouteTableRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRouteTable");

            HttpResponseHandler<CreateRouteTableResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateRouteTableResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateRouteTableResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRouteTableRequest, CreateRouteTableResponse>()
                            .withOperationName("CreateRouteTable").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateRouteTableRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createRouteTableRequest));
            CompletableFuture<CreateRouteTableResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a security group.
     * </p>
     * <p>
     * A security group acts as a virtual firewall for your instance to control inbound and outbound traffic. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon
     * EC2 security groups</a> in the <i>Amazon Elastic Compute Cloud User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security groups for your
     * VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <p>
     * When you create a security group, you specify a friendly name of your choice. You can't have two security groups
     * for the same VPC with the same name.
     * </p>
     * <p>
     * You have a default security group for use in your VPC. If you don't specify a security group when you launch an
     * instance, the instance is launched into the appropriate default security group. A default security group includes
     * a default rule that grants instances unrestricted network access to each other.
     * </p>
     * <p>
     * You can add or remove rules from your security groups using <a>AuthorizeSecurityGroupIngress</a>,
     * <a>AuthorizeSecurityGroupEgress</a>, <a>RevokeSecurityGroupIngress</a>, and <a>RevokeSecurityGroupEgress</a>.
     * </p>
     * <p>
     * For more information about VPC security group limits, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC Limits</a>.
     * </p>
     *
     * @param createSecurityGroupRequest
     * @return A Java Future containing the result of the CreateSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSecurityGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSecurityGroupResponse> createSecurityGroup(
            CreateSecurityGroupRequest createSecurityGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSecurityGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSecurityGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSecurityGroup");

            HttpResponseHandler<CreateSecurityGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateSecurityGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateSecurityGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSecurityGroupRequest, CreateSecurityGroupResponse>()
                            .withOperationName("CreateSecurityGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateSecurityGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createSecurityGroupRequest));
            CompletableFuture<CreateSecurityGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a snapshot of an EBS volume and stores it in Amazon S3. You can use snapshots for backups, to make copies
     * of EBS volumes, and to save data before shutting down an instance.
     * </p>
     * <p>
     * You can create snapshots of volumes in a Region and volumes on an Outpost. If you create a snapshot of a volume
     * in a Region, the snapshot must be stored in the same Region as the volume. If you create a snapshot of a volume
     * on an Outpost, the snapshot can be stored on the same Outpost as the volume, or in the Region for that Outpost.
     * </p>
     * <p>
     * When a snapshot is created, any Amazon Web Services Marketplace product codes that are associated with the source
     * volume are propagated to the snapshot.
     * </p>
     * <p>
     * You can take a snapshot of an attached volume that is in use. However, snapshots only capture data that has been
     * written to your Amazon EBS volume at the time the snapshot command is issued; this might exclude any data that
     * has been cached by any applications or the operating system. If you can pause any file systems on the volume long
     * enough to take a snapshot, your snapshot should be complete. However, if you cannot pause all file writes to the
     * volume, you should unmount the volume from within the instance, issue the snapshot command, and then remount the
     * volume to ensure a consistent and complete snapshot. You may remount and use your volume while the snapshot
     * status is <code>pending</code>.
     * </p>
     * <p>
     * When you create a snapshot for an EBS volume that serves as a root device, we recommend that you stop the
     * instance before taking the snapshot.
     * </p>
     * <p>
     * Snapshots that are taken from encrypted volumes are automatically encrypted. Volumes that are created from
     * encrypted snapshots are also automatically encrypted. Your encrypted volumes and any associated snapshots always
     * remain protected.
     * </p>
     * <p>
     * You can tag your snapshots during creation. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tag your Amazon EC2 resources</a> in
     * the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/what-is-ebs.html">Amazon
     * Elastic Block Store</a> and <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html">Amazon
     * EBS encryption</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     *
     * @param createSnapshotRequest
     * @return A Java Future containing the result of the CreateSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSnapshotResponse> createSnapshot(CreateSnapshotRequest createSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSnapshot");

            HttpResponseHandler<CreateSnapshotResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSnapshotRequest, CreateSnapshotResponse>()
                            .withOperationName("CreateSnapshot").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createSnapshotRequest));
            CompletableFuture<CreateSnapshotResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates crash-consistent snapshots of multiple EBS volumes and stores the data in S3. Volumes are chosen by
     * specifying an instance. Any attached volumes will produce one snapshot each that is crash-consistent across the
     * instance.
     * </p>
     * <p>
     * You can include all of the volumes currently attached to the instance, or you can exclude the root volume or
     * specific data (non-root) volumes from the multi-volume snapshot set.
     * </p>
     * <p>
     * You can create multi-volume snapshots of instances in a Region and instances on an Outpost. If you create
     * snapshots from an instance in a Region, the snapshots must be stored in the same Region as the instance. If you
     * create snapshots from an instance on an Outpost, the snapshots can be stored on the same Outpost as the instance,
     * or in the Region for that Outpost.
     * </p>
     *
     * @param createSnapshotsRequest
     * @return A Java Future containing the result of the CreateSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSnapshotsResponse> createSnapshots(CreateSnapshotsRequest createSnapshotsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSnapshotsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSnapshotsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSnapshots");

            HttpResponseHandler<CreateSnapshotsResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateSnapshotsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateSnapshotsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSnapshotsRequest, CreateSnapshotsResponse>()
                            .withOperationName("CreateSnapshots").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateSnapshotsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createSnapshotsRequest));
            CompletableFuture<CreateSnapshotsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a data feed for Spot Instances, enabling you to view Spot Instance usage logs. You can create one data
     * feed per Amazon Web Services account. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html">Spot Instance data feed</a> in
     * the <i>Amazon EC2 User Guide for Linux Instances</i>.
     * </p>
     *
     * @param createSpotDatafeedSubscriptionRequest
     *        Contains the parameters for CreateSpotDatafeedSubscription.
     * @return A Java Future containing the result of the CreateSpotDatafeedSubscription operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateSpotDatafeedSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSpotDatafeedSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSpotDatafeedSubscriptionResponse> createSpotDatafeedSubscription(
            CreateSpotDatafeedSubscriptionRequest createSpotDatafeedSubscriptionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSpotDatafeedSubscriptionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createSpotDatafeedSubscriptionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSpotDatafeedSubscription");

            HttpResponseHandler<CreateSpotDatafeedSubscriptionResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateSpotDatafeedSubscriptionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateSpotDatafeedSubscriptionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSpotDatafeedSubscriptionRequest, CreateSpotDatafeedSubscriptionResponse>()
                            .withOperationName("CreateSpotDatafeedSubscription").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateSpotDatafeedSubscriptionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createSpotDatafeedSubscriptionRequest));
            CompletableFuture<CreateSpotDatafeedSubscriptionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stores an AMI as a single object in an Amazon S3 bucket.
     * </p>
     * <p>
     * To use this API, you must have the required permissions. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html#ami-s3-permissions">Permissions
     * for storing and restoring AMIs using Amazon S3</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html">Store and restore an AMI using
     * Amazon S3</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createStoreImageTaskRequest
     * @return A Java Future containing the result of the CreateStoreImageTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateStoreImageTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateStoreImageTask" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateStoreImageTaskResponse> createStoreImageTask(
            CreateStoreImageTaskRequest createStoreImageTaskRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createStoreImageTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createStoreImageTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStoreImageTask");

            HttpResponseHandler<CreateStoreImageTaskResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateStoreImageTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateStoreImageTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateStoreImageTaskRequest, CreateStoreImageTaskResponse>()
                            .withOperationName("CreateStoreImageTask").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateStoreImageTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createStoreImageTaskRequest));
            CompletableFuture<CreateStoreImageTaskResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a subnet in the specified VPC. For an IPv4 only subnet, specify an IPv4 CIDR block. If the VPC has an
     * IPv6 CIDR block, you can create an IPv6 only subnet or a dual stack subnet instead. For an IPv6 only subnet,
     * specify an IPv6 CIDR block. For a dual stack subnet, specify both an IPv4 CIDR block and an IPv6 CIDR block.
     * </p>
     * <p>
     * A subnet CIDR block must not overlap the CIDR block of an existing subnet in the VPC. After you create a subnet,
     * you can't change its CIDR block.
     * </p>
     * <p>
     * The allowed size for an IPv4 subnet is between a /28 netmask (16 IP addresses) and a /16 netmask (65,536 IP
     * addresses). Amazon Web Services reserves both the first four and the last IPv4 address in each subnet's CIDR
     * block. They're not available for your use.
     * </p>
     * <p>
     * If you've associated an IPv6 CIDR block with your VPC, you can associate an IPv6 CIDR block with a subnet when
     * you create it.
     * </p>
     * <p>
     * If you add more than one subnet to a VPC, they're set up in a star topology with a logical router in the middle.
     * </p>
     * <p>
     * When you stop an instance in a subnet, it retains its private IPv4 address. It's therefore possible to have a
     * subnet with no running instances (they're all stopped), but no remaining IP addresses available.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/configure-subnets.html">Subnets</a> in the <i>Amazon VPC
     * User Guide</i>.
     * </p>
     *
     * @param createSubnetRequest
     * @return A Java Future containing the result of the CreateSubnet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateSubnet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSubnet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSubnetResponse> createSubnet(CreateSubnetRequest createSubnetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSubnetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSubnetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSubnet");

            HttpResponseHandler<CreateSubnetResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateSubnetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateSubnetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSubnetRequest, CreateSubnetResponse>()
                            .withOperationName("CreateSubnet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateSubnetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createSubnetRequest));
            CompletableFuture<CreateSubnetResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a subnet CIDR reservation. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/subnet-cidr-reservation.html">Subnet CIDR reservations</a>
     * in the <i>Amazon Virtual Private Cloud User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html">Assign prefixes to network
     * interfaces</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param createSubnetCidrReservationRequest
     * @return A Java Future containing the result of the CreateSubnetCidrReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateSubnetCidrReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSubnetCidrReservation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSubnetCidrReservationResponse> createSubnetCidrReservation(
            CreateSubnetCidrReservationRequest createSubnetCidrReservationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSubnetCidrReservationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSubnetCidrReservationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSubnetCidrReservation");

            HttpResponseHandler<CreateSubnetCidrReservationResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateSubnetCidrReservationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateSubnetCidrReservationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSubnetCidrReservationRequest, CreateSubnetCidrReservationResponse>()
                            .withOperationName("CreateSubnetCidrReservation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateSubnetCidrReservationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createSubnetCidrReservationRequest));
            CompletableFuture<CreateSubnetCidrReservationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds or overwrites only the specified tags for the specified Amazon EC2 resource or resources. When you specify
     * an existing tag key, the value is overwritten with the new value. Each resource can have a maximum of 50 tags.
     * Each tag consists of a key and optional value. Tag keys must be unique per resource.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tag your Amazon EC2 resources</a> in
     * the <i>Amazon Elastic Compute Cloud User Guide</i>. For more information about creating IAM policies that control
     * users' access to resources based on tags, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-iam-actions-resources.html">Supported
     * resource-level permissions for Amazon EC2 API actions</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param createTagsRequest
     * @return A Java Future containing the result of the CreateTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTagsResponse> createTags(CreateTagsRequest createTagsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTags");

            HttpResponseHandler<CreateTagsResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTagsRequest, CreateTagsResponse>().withOperationName("CreateTags")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateTagsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createTagsRequest));
            CompletableFuture<CreateTagsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a Traffic Mirror filter.
     * </p>
     * <p>
     * A Traffic Mirror filter is a set of rules that defines the traffic to mirror.
     * </p>
     * <p>
     * By default, no traffic is mirrored. To mirror traffic, use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilterRule.htm"
     * >CreateTrafficMirrorFilterRule</a> to add Traffic Mirror rules to the filter. The rules you add define what
     * traffic gets mirrored. You can also use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTrafficMirrorFilterNetworkServices.html"
     * >ModifyTrafficMirrorFilterNetworkServices</a> to mirror supported network services.
     * </p>
     *
     * @param createTrafficMirrorFilterRequest
     * @return A Java Future containing the result of the CreateTrafficMirrorFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTrafficMirrorFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorFilter" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTrafficMirrorFilterResponse> createTrafficMirrorFilter(
            CreateTrafficMirrorFilterRequest createTrafficMirrorFilterRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTrafficMirrorFilterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTrafficMirrorFilterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTrafficMirrorFilter");

            HttpResponseHandler<CreateTrafficMirrorFilterResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateTrafficMirrorFilterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateTrafficMirrorFilterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTrafficMirrorFilterRequest, CreateTrafficMirrorFilterResponse>()
                            .withOperationName("CreateTrafficMirrorFilter").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateTrafficMirrorFilterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createTrafficMirrorFilterRequest));
            CompletableFuture<CreateTrafficMirrorFilterResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a Traffic Mirror filter rule.
     * </p>
     * <p>
     * A Traffic Mirror rule defines the Traffic Mirror source traffic to mirror.
     * </p>
     * <p>
     * You need the Traffic Mirror filter ID when you create the rule.
     * </p>
     *
     * @param createTrafficMirrorFilterRuleRequest
     * @return A Java Future containing the result of the CreateTrafficMirrorFilterRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTrafficMirrorFilterRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorFilterRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTrafficMirrorFilterRuleResponse> createTrafficMirrorFilterRule(
            CreateTrafficMirrorFilterRuleRequest createTrafficMirrorFilterRuleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTrafficMirrorFilterRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createTrafficMirrorFilterRuleRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTrafficMirrorFilterRule");

            HttpResponseHandler<CreateTrafficMirrorFilterRuleResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateTrafficMirrorFilterRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateTrafficMirrorFilterRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTrafficMirrorFilterRuleRequest, CreateTrafficMirrorFilterRuleResponse>()
                            .withOperationName("CreateTrafficMirrorFilterRule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateTrafficMirrorFilterRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createTrafficMirrorFilterRuleRequest));
            CompletableFuture<CreateTrafficMirrorFilterRuleResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a Traffic Mirror session.
     * </p>
     * <p>
     * A Traffic Mirror session actively copies packets from a Traffic Mirror source to a Traffic Mirror target. Create
     * a filter, and then assign it to the session to define a subset of the traffic to mirror, for example all TCP
     * traffic.
     * </p>
     * <p>
     * The Traffic Mirror source and the Traffic Mirror target (monitoring appliances) can be in the same VPC, or in a
     * different VPC connected via VPC peering or a transit gateway.
     * </p>
     * <p>
     * By default, no traffic is mirrored. Use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilter.htm"
     * >CreateTrafficMirrorFilter</a> to create filter rules that specify the traffic to mirror.
     * </p>
     *
     * @param createTrafficMirrorSessionRequest
     * @return A Java Future containing the result of the CreateTrafficMirrorSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTrafficMirrorSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorSession"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTrafficMirrorSessionResponse> createTrafficMirrorSession(
            CreateTrafficMirrorSessionRequest createTrafficMirrorSessionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTrafficMirrorSessionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTrafficMirrorSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTrafficMirrorSession");

            HttpResponseHandler<CreateTrafficMirrorSessionResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateTrafficMirrorSessionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateTrafficMirrorSessionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTrafficMirrorSessionRequest, CreateTrafficMirrorSessionResponse>()
                            .withOperationName("CreateTrafficMirrorSession").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateTrafficMirrorSessionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createTrafficMirrorSessionRequest));
            CompletableFuture<CreateTrafficMirrorSessionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a target for your Traffic Mirror session.
     * </p>
     * <p>
     * A Traffic Mirror target is the destination for mirrored traffic. The Traffic Mirror source and the Traffic Mirror
     * target (monitoring appliances) can be in the same VPC, or in different VPCs connected via VPC peering or a
     * transit gateway.
     * </p>
     * <p>
     * A Traffic Mirror target can be a network interface, a Network Load Balancer, or a Gateway Load Balancer endpoint.
     * </p>
     * <p>
     * To use the target in a Traffic Mirror session, use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorSession.htm"
     * >CreateTrafficMirrorSession</a>.
     * </p>
     *
     * @param createTrafficMirrorTargetRequest
     * @return A Java Future containing the result of the CreateTrafficMirrorTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTrafficMirrorTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorTarget" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTrafficMirrorTargetResponse> createTrafficMirrorTarget(
            CreateTrafficMirrorTargetRequest createTrafficMirrorTargetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTrafficMirrorTargetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTrafficMirrorTargetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTrafficMirrorTarget");

            HttpResponseHandler<CreateTrafficMirrorTargetResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateTrafficMirrorTargetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateTrafficMirrorTargetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTrafficMirrorTargetRequest, CreateTrafficMirrorTargetResponse>()
                            .withOperationName("CreateTrafficMirrorTarget").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateTrafficMirrorTargetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createTrafficMirrorTargetRequest));
            CompletableFuture<CreateTrafficMirrorTargetResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a transit gateway.
     * </p>
     * <p>
     * You can use a transit gateway to interconnect your virtual private clouds (VPC) and on-premises networks. After
     * the transit gateway enters the <code>available</code> state, you can attach your VPCs and VPN connections to the
     * transit gateway.
     * </p>
     * <p>
     * To attach your VPCs, use <a>CreateTransitGatewayVpcAttachment</a>.
     * </p>
     * <p>
     * To attach a VPN connection, use <a>CreateCustomerGateway</a> to create a customer gateway and specify the ID of
     * the customer gateway and the ID of the transit gateway in a call to <a>CreateVpnConnection</a>.
     * </p>
     * <p>
     * When you create a transit gateway, we create a default transit gateway route table and use it as the default
     * association route table and the default propagation route table. You can use
     * <a>CreateTransitGatewayRouteTable</a> to create additional transit gateway route tables. If you disable automatic
     * route propagation, we do not create a default transit gateway route table. You can use
     * <a>EnableTransitGatewayRouteTablePropagation</a> to propagate routes from a resource attachment to a transit
     * gateway route table. If you disable automatic associations, you can use <a>AssociateTransitGatewayRouteTable</a>
     * to associate a resource attachment with a transit gateway route table.
     * </p>
     *
     * @param createTransitGatewayRequest
     * @return A Java Future containing the result of the CreateTransitGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTransitGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTransitGatewayResponse> createTransitGateway(
            CreateTransitGatewayRequest createTransitGatewayRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTransitGatewayRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTransitGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTransitGateway");

            HttpResponseHandler<CreateTransitGatewayResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateTransitGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateTransitGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTransitGatewayRequest, CreateTransitGatewayResponse>()
                            .withOperationName("CreateTransitGateway").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateTransitGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createTransitGatewayRequest));
            CompletableFuture<CreateTransitGatewayResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a Connect attachment from a specified transit gateway attachment. A Connect attachment is a GRE-based
     * tunnel attachment that you can use to establish a connection between a transit gateway and an appliance.
     * </p>
     * <p>
     * A Connect attachment uses an existing VPC or Amazon Web Services Direct Connect attachment as the underlying
     * transport mechanism.
     * </p>
     *
     * @param createTransitGatewayConnectRequest
     * @return A Java Future containing the result of the CreateTransitGatewayConnect operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTransitGatewayConnect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayConnect"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTransitGatewayConnectResponse> createTransitGatewayConnect(
            CreateTransitGatewayConnectRequest createTransitGatewayConnectRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTransitGatewayConnectRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTransitGatewayConnectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTransitGatewayConnect");

            HttpResponseHandler<CreateTransitGatewayConnectResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateTransitGatewayConnectResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateTransitGatewayConnectResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTransitGatewayConnectRequest, CreateTransitGatewayConnectResponse>()
                            .withOperationName("CreateTransitGatewayConnect").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateTransitGatewayConnectRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createTransitGatewayConnectRequest));
            CompletableFuture<CreateTransitGatewayConnectResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a Connect peer for a specified transit gateway Connect attachment between a transit gateway and an
     * appliance.
     * </p>
     * <p>
     * The peer address and transit gateway address must be the same IP address family (IPv4 or IPv6).
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/tgw/tgw-connect.html#tgw-connect-peer">Connect peers</a> in the
     * <i>Transit Gateways Guide</i>.
     * </p>
     *
     * @param createTransitGatewayConnectPeerRequest
     * @return A Java Future containing the result of the CreateTransitGatewayConnectPeer operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTransitGatewayConnectPeer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayConnectPeer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTransitGatewayConnectPeerResponse> createTransitGatewayConnectPeer(
            CreateTransitGatewayConnectPeerRequest createTransitGatewayConnectPeerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTransitGatewayConnectPeerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createTransitGatewayConnectPeerRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTransitGatewayConnectPeer");

            HttpResponseHandler<CreateTransitGatewayConnectPeerResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateTransitGatewayConnectPeerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateTransitGatewayConnectPeerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTransitGatewayConnectPeerRequest, CreateTransitGatewayConnectPeerResponse>()
                            .withOperationName("CreateTransitGatewayConnectPeer").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateTransitGatewayConnectPeerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createTransitGatewayConnectPeerRequest));
            CompletableFuture<CreateTransitGatewayConnectPeerResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a multicast domain using the specified transit gateway.
     * </p>
     * <p>
     * The transit gateway must be in the available state before you create a domain. Use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGateways.html"
     * >DescribeTransitGateways</a> to see the state of transit gateway.
     * </p>
     *
     * @param createTransitGatewayMulticastDomainRequest
     * @return A Java Future containing the result of the CreateTransitGatewayMulticastDomain operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTransitGatewayMulticastDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayMulticastDomain"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTransitGatewayMulticastDomainResponse> createTransitGatewayMulticastDomain(
            CreateTransitGatewayMulticastDomainRequest createTransitGatewayMulticastDomainRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTransitGatewayMulticastDomainRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createTransitGatewayMulticastDomainRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTransitGatewayMulticastDomain");

            HttpResponseHandler<CreateTransitGatewayMulticastDomainResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateTransitGatewayMulticastDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateTransitGatewayMulticastDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTransitGatewayMulticastDomainRequest, CreateTransitGatewayMulticastDomainResponse>()
                            .withOperationName("CreateTransitGatewayMulticastDomain").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateTransitGatewayMulticastDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createTransitGatewayMulticastDomainRequest));
            CompletableFuture<CreateTransitGatewayMulticastDomainResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Requests a transit gateway peering attachment between the specified transit gateway (requester) and a peer
     * transit gateway (accepter). The peer transit gateway can be in your account or a different Amazon Web Services
     * account.
     * </p>
     * <p>
     * After you create the peering attachment, the owner of the accepter transit gateway must accept the attachment
     * request.
     * </p>
     *
     * @param createTransitGatewayPeeringAttachmentRequest
     * @return A Java Future containing the result of the CreateTransitGatewayPeeringAttachment operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTransitGatewayPeeringAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPeeringAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTransitGatewayPeeringAttachmentResponse> createTransitGatewayPeeringAttachment(
            CreateTransitGatewayPeeringAttachmentRequest createTransitGatewayPeeringAttachmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTransitGatewayPeeringAttachmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createTransitGatewayPeeringAttachmentRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTransitGatewayPeeringAttachment");

            HttpResponseHandler<CreateTransitGatewayPeeringAttachmentResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateTransitGatewayPeeringAttachmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateTransitGatewayPeeringAttachmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTransitGatewayPeeringAttachmentRequest, CreateTransitGatewayPeeringAttachmentResponse>()
                            .withOperationName("CreateTransitGatewayPeeringAttachment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateTransitGatewayPeeringAttachmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createTransitGatewayPeeringAttachmentRequest));
            CompletableFuture<CreateTransitGatewayPeeringAttachmentResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a transit gateway policy table.
     * </p>
     *
     * @param createTransitGatewayPolicyTableRequest
     * @return A Java Future containing the result of the CreateTransitGatewayPolicyTable operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTransitGatewayPolicyTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPolicyTable"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTransitGatewayPolicyTableResponse> createTransitGatewayPolicyTable(
            CreateTransitGatewayPolicyTableRequest createTransitGatewayPolicyTableRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTransitGatewayPolicyTableRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createTransitGatewayPolicyTableRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTransitGatewayPolicyTable");

            HttpResponseHandler<CreateTransitGatewayPolicyTableResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateTransitGatewayPolicyTableResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateTransitGatewayPolicyTableResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTransitGatewayPolicyTableRequest, CreateTransitGatewayPolicyTableResponse>()
                            .withOperationName("CreateTransitGatewayPolicyTable").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateTransitGatewayPolicyTableRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createTransitGatewayPolicyTableRequest));
            CompletableFuture<CreateTransitGatewayPolicyTableResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a reference (route) to a prefix list in a specified transit gateway route table.
     * </p>
     *
     * @param createTransitGatewayPrefixListReferenceRequest
     * @return A Java Future containing the result of the CreateTransitGatewayPrefixListReference operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTransitGatewayPrefixListReference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPrefixListReference"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTransitGatewayPrefixListReferenceResponse> createTransitGatewayPrefixListReference(
            CreateTransitGatewayPrefixListReferenceRequest createTransitGatewayPrefixListReferenceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTransitGatewayPrefixListReferenceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createTransitGatewayPrefixListReferenceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTransitGatewayPrefixListReference");

            HttpResponseHandler<CreateTransitGatewayPrefixListReferenceResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateTransitGatewayPrefixListReferenceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateTransitGatewayPrefixListReferenceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTransitGatewayPrefixListReferenceRequest, CreateTransitGatewayPrefixListReferenceResponse>()
                            .withOperationName("CreateTransitGatewayPrefixListReference").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateTransitGatewayPrefixListReferenceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createTransitGatewayPrefixListReferenceRequest));
            CompletableFuture<CreateTransitGatewayPrefixListReferenceResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a static route for the specified transit gateway route table.
     * </p>
     *
     * @param createTransitGatewayRouteRequest
     * @return A Java Future containing the result of the CreateTransitGatewayRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTransitGatewayRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTransitGatewayRouteResponse> createTransitGatewayRoute(
            CreateTransitGatewayRouteRequest createTransitGatewayRouteRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTransitGatewayRouteRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTransitGatewayRouteRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTransitGatewayRoute");

            HttpResponseHandler<CreateTransitGatewayRouteResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateTransitGatewayRouteResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateTransitGatewayRouteResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTransitGatewayRouteRequest, CreateTransitGatewayRouteResponse>()
                            .withOperationName("CreateTransitGatewayRoute").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateTransitGatewayRouteRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createTransitGatewayRouteRequest));
            CompletableFuture<CreateTransitGatewayRouteResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a route table for the specified transit gateway.
     * </p>
     *
     * @param createTransitGatewayRouteTableRequest
     * @return A Java Future containing the result of the CreateTransitGatewayRouteTable operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTransitGatewayRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRouteTable"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTransitGatewayRouteTableResponse> createTransitGatewayRouteTable(
            CreateTransitGatewayRouteTableRequest createTransitGatewayRouteTableRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTransitGatewayRouteTableRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createTransitGatewayRouteTableRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTransitGatewayRouteTable");

            HttpResponseHandler<CreateTransitGatewayRouteTableResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateTransitGatewayRouteTableResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateTransitGatewayRouteTableResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTransitGatewayRouteTableRequest, CreateTransitGatewayRouteTableResponse>()
                            .withOperationName("CreateTransitGatewayRouteTable").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateTransitGatewayRouteTableRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createTransitGatewayRouteTableRequest));
            CompletableFuture<CreateTransitGatewayRouteTableResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Advertises a new transit gateway route table.
     * </p>
     *
     * @param createTransitGatewayRouteTableAnnouncementRequest
     * @return A Java Future containing the result of the CreateTransitGatewayRouteTableAnnouncement operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTransitGatewayRouteTableAnnouncement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRouteTableAnnouncement"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTransitGatewayRouteTableAnnouncementResponse> createTransitGatewayRouteTableAnnouncement(
            CreateTransitGatewayRouteTableAnnouncementRequest createTransitGatewayRouteTableAnnouncementRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                createTransitGatewayRouteTableAnnouncementRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createTransitGatewayRouteTableAnnouncementRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTransitGatewayRouteTableAnnouncement");

            HttpResponseHandler<CreateTransitGatewayRouteTableAnnouncementResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateTransitGatewayRouteTableAnnouncementResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateTransitGatewayRouteTableAnnouncementResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTransitGatewayRouteTableAnnouncementRequest, CreateTransitGatewayRouteTableAnnouncementResponse>()
                            .withOperationName("CreateTransitGatewayRouteTableAnnouncement")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateTransitGatewayRouteTableAnnouncementRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createTransitGatewayRouteTableAnnouncementRequest));
            CompletableFuture<CreateTransitGatewayRouteTableAnnouncementResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches the specified VPC to the specified transit gateway.
     * </p>
     * <p>
     * If you attach a VPC with a CIDR range that overlaps the CIDR range of a VPC that is already attached, the new VPC
     * CIDR range is not propagated to the default propagation route table.
     * </p>
     * <p>
     * To send VPC traffic to an attached transit gateway, add a route to the VPC route table using <a>CreateRoute</a>.
     * </p>
     *
     * @param createTransitGatewayVpcAttachmentRequest
     * @return A Java Future containing the result of the CreateTransitGatewayVpcAttachment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTransitGatewayVpcAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayVpcAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTransitGatewayVpcAttachmentResponse> createTransitGatewayVpcAttachment(
            CreateTransitGatewayVpcAttachmentRequest createTransitGatewayVpcAttachmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTransitGatewayVpcAttachmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createTransitGatewayVpcAttachmentRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTransitGatewayVpcAttachment");

            HttpResponseHandler<CreateTransitGatewayVpcAttachmentResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateTransitGatewayVpcAttachmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateTransitGatewayVpcAttachmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTransitGatewayVpcAttachmentRequest, CreateTransitGatewayVpcAttachmentResponse>()
                            .withOperationName("CreateTransitGatewayVpcAttachment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateTransitGatewayVpcAttachmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createTransitGatewayVpcAttachmentRequest));
            CompletableFuture<CreateTransitGatewayVpcAttachmentResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * An Amazon Web Services Verified Access endpoint is where you define your application along with an optional
     * endpoint-level access policy.
     * </p>
     *
     * @param createVerifiedAccessEndpointRequest
     * @return A Java Future containing the result of the CreateVerifiedAccessEndpoint operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateVerifiedAccessEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVerifiedAccessEndpointResponse> createVerifiedAccessEndpoint(
            CreateVerifiedAccessEndpointRequest createVerifiedAccessEndpointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVerifiedAccessEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVerifiedAccessEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVerifiedAccessEndpoint");

            HttpResponseHandler<CreateVerifiedAccessEndpointResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateVerifiedAccessEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateVerifiedAccessEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateVerifiedAccessEndpointRequest, CreateVerifiedAccessEndpointResponse>()
                            .withOperationName("CreateVerifiedAccessEndpoint").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateVerifiedAccessEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createVerifiedAccessEndpointRequest));
            CompletableFuture<CreateVerifiedAccessEndpointResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * An Amazon Web Services Verified Access group is a collection of Amazon Web Services Verified Access endpoints
     * who's associated applications have similar security requirements. Each instance within a Verified Access group
     * shares an Verified Access policy. For example, you can group all Verified Access instances associated with
     * "sales" applications together and use one common Verified Access policy.
     * </p>
     *
     * @param createVerifiedAccessGroupRequest
     * @return A Java Future containing the result of the CreateVerifiedAccessGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateVerifiedAccessGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVerifiedAccessGroupResponse> createVerifiedAccessGroup(
            CreateVerifiedAccessGroupRequest createVerifiedAccessGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVerifiedAccessGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVerifiedAccessGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVerifiedAccessGroup");

            HttpResponseHandler<CreateVerifiedAccessGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateVerifiedAccessGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateVerifiedAccessGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateVerifiedAccessGroupRequest, CreateVerifiedAccessGroupResponse>()
                            .withOperationName("CreateVerifiedAccessGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateVerifiedAccessGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createVerifiedAccessGroupRequest));
            CompletableFuture<CreateVerifiedAccessGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * An Amazon Web Services Verified Access instance is a regional entity that evaluates application requests and
     * grants access only when your security requirements are met.
     * </p>
     *
     * @param createVerifiedAccessInstanceRequest
     * @return A Java Future containing the result of the CreateVerifiedAccessInstance operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateVerifiedAccessInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVerifiedAccessInstanceResponse> createVerifiedAccessInstance(
            CreateVerifiedAccessInstanceRequest createVerifiedAccessInstanceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVerifiedAccessInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVerifiedAccessInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVerifiedAccessInstance");

            HttpResponseHandler<CreateVerifiedAccessInstanceResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateVerifiedAccessInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateVerifiedAccessInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateVerifiedAccessInstanceRequest, CreateVerifiedAccessInstanceResponse>()
                            .withOperationName("CreateVerifiedAccessInstance").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateVerifiedAccessInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createVerifiedAccessInstanceRequest));
            CompletableFuture<CreateVerifiedAccessInstanceResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * A trust provider is a third-party entity that creates, maintains, and manages identity information for users and
     * devices. When an application request is made, the identity information sent by the trust provider is evaluated by
     * Verified Access before allowing or denying the application request.
     * </p>
     *
     * @param createVerifiedAccessTrustProviderRequest
     * @return A Java Future containing the result of the CreateVerifiedAccessTrustProvider operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateVerifiedAccessTrustProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessTrustProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVerifiedAccessTrustProviderResponse> createVerifiedAccessTrustProvider(
            CreateVerifiedAccessTrustProviderRequest createVerifiedAccessTrustProviderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVerifiedAccessTrustProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createVerifiedAccessTrustProviderRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVerifiedAccessTrustProvider");

            HttpResponseHandler<CreateVerifiedAccessTrustProviderResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateVerifiedAccessTrustProviderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateVerifiedAccessTrustProviderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateVerifiedAccessTrustProviderRequest, CreateVerifiedAccessTrustProviderResponse>()
                            .withOperationName("CreateVerifiedAccessTrustProvider").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateVerifiedAccessTrustProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createVerifiedAccessTrustProviderRequest));
            CompletableFuture<CreateVerifiedAccessTrustProviderResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an EBS volume that can be attached to an instance in the same Availability Zone.
     * </p>
     * <p>
     * You can create a new empty volume or restore a volume from an EBS snapshot. Any Amazon Web Services Marketplace
     * product codes from the snapshot are propagated to the volume.
     * </p>
     * <p>
     * You can create encrypted volumes. Encrypted volumes must be attached to instances that support Amazon EBS
     * encryption. Volumes that are created from encrypted snapshots are also automatically encrypted. For more
     * information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html">Amazon EBS
     * encryption</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     * <p>
     * You can tag your volumes during creation. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tag your Amazon EC2 resources</a> in
     * the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-creating-volume.html">Create an Amazon EBS volume</a>
     * in the <i>Amazon EBS User Guide</i>.
     * </p>
     *
     * @param createVolumeRequest
     * @return A Java Future containing the result of the CreateVolume operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVolume" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVolumeResponse> createVolume(CreateVolumeRequest createVolumeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVolumeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVolumeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVolume");

            HttpResponseHandler<CreateVolumeResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateVolumeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateVolumeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateVolumeRequest, CreateVolumeResponse>()
                            .withOperationName("CreateVolume").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateVolumeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createVolumeRequest));
            CompletableFuture<CreateVolumeResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a VPC with the specified CIDR blocks. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-ip-addressing.html">IP addressing for your VPCs and
     * subnets</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <p>
     * You can optionally request an IPv6 CIDR block for the VPC. You can request an Amazon-provided IPv6 CIDR block
     * from Amazon's pool of IPv6 addresses or an IPv6 CIDR block from an IPv6 address pool that you provisioned through
     * bring your own IP addresses (<a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">BYOIP</a>).
     * </p>
     * <p>
     * By default, each instance that you launch in the VPC has the default DHCP options, which include only a default
     * DNS server that we provide (AmazonProvidedDNS). For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP option sets</a> in the
     * <i>Amazon VPC User Guide</i>.
     * </p>
     * <p>
     * You can specify the instance tenancy value for the VPC when you create it. You can't change this value for the
     * VPC after you create it. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-instance.html">Dedicated Instances</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createVpcRequest
     * @return A Java Future containing the result of the CreateVpc operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateVpc
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpc" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVpcResponse> createVpc(CreateVpcRequest createVpcRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVpcRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVpcRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVpc");

            HttpResponseHandler<CreateVpcResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateVpcResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateVpcResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateVpcRequest, CreateVpcResponse>().withOperationName("CreateVpc")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateVpcRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(createVpcRequest));
            CompletableFuture<CreateVpcResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a VPC endpoint. A VPC endpoint provides a private connection between the specified VPC and the specified
     * endpoint service. You can use an endpoint service provided by Amazon Web Services, an Amazon Web Services
     * Marketplace Partner, or another Amazon Web Services account. For more information, see the <a
     * href="https://docs.aws.amazon.com/vpc/latest/privatelink/">Amazon Web Services PrivateLink User Guide</a>.
     * </p>
     *
     * @param createVpcEndpointRequest
     * @return A Java Future containing the result of the CreateVpcEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateVpcEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVpcEndpointResponse> createVpcEndpoint(CreateVpcEndpointRequest createVpcEndpointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVpcEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVpcEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVpcEndpoint");

            HttpResponseHandler<CreateVpcEndpointResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateVpcEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateVpcEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateVpcEndpointRequest, CreateVpcEndpointResponse>()
                            .withOperationName("CreateVpcEndpoint").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateVpcEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createVpcEndpointRequest));
            CompletableFuture<CreateVpcEndpointResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a connection notification for a specified VPC endpoint or VPC endpoint service. A connection notification
     * notifies you of specific endpoint events. You must create an SNS topic to receive notifications. For more
     * information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Create a Topic</a> in the
     * <i>Amazon Simple Notification Service Developer Guide</i>.
     * </p>
     * <p>
     * You can create a connection notification for interface endpoints only.
     * </p>
     *
     * @param createVpcEndpointConnectionNotificationRequest
     * @return A Java Future containing the result of the CreateVpcEndpointConnectionNotification operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateVpcEndpointConnectionNotification
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointConnectionNotification"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVpcEndpointConnectionNotificationResponse> createVpcEndpointConnectionNotification(
            CreateVpcEndpointConnectionNotificationRequest createVpcEndpointConnectionNotificationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVpcEndpointConnectionNotificationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createVpcEndpointConnectionNotificationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVpcEndpointConnectionNotification");

            HttpResponseHandler<CreateVpcEndpointConnectionNotificationResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateVpcEndpointConnectionNotificationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateVpcEndpointConnectionNotificationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateVpcEndpointConnectionNotificationRequest, CreateVpcEndpointConnectionNotificationResponse>()
                            .withOperationName("CreateVpcEndpointConnectionNotification").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateVpcEndpointConnectionNotificationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createVpcEndpointConnectionNotificationRequest));
            CompletableFuture<CreateVpcEndpointConnectionNotificationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a VPC endpoint service to which service consumers (Amazon Web Services accounts, users, and IAM roles)
     * can connect.
     * </p>
     * <p>
     * Before you create an endpoint service, you must create one of the following for your service:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/">Network Load Balancer</a>. Service
     * consumers connect to your service using an interface endpoint.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/">Gateway Load Balancer</a>. Service
     * consumers connect to your service using a Gateway Load Balancer endpoint.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you set the private DNS name, you must prove that you own the private DNS domain name.
     * </p>
     * <p>
     * For more information, see the <a href="https://docs.aws.amazon.com/vpc/latest/privatelink/">Amazon Web Services
     * PrivateLink Guide</a>.
     * </p>
     *
     * @param createVpcEndpointServiceConfigurationRequest
     * @return A Java Future containing the result of the CreateVpcEndpointServiceConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateVpcEndpointServiceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointServiceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVpcEndpointServiceConfigurationResponse> createVpcEndpointServiceConfiguration(
            CreateVpcEndpointServiceConfigurationRequest createVpcEndpointServiceConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVpcEndpointServiceConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createVpcEndpointServiceConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVpcEndpointServiceConfiguration");

            HttpResponseHandler<CreateVpcEndpointServiceConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateVpcEndpointServiceConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateVpcEndpointServiceConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateVpcEndpointServiceConfigurationRequest, CreateVpcEndpointServiceConfigurationResponse>()
                            .withOperationName("CreateVpcEndpointServiceConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateVpcEndpointServiceConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createVpcEndpointServiceConfigurationRequest));
            CompletableFuture<CreateVpcEndpointServiceConfigurationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Requests a VPC peering connection between two VPCs: a requester VPC that you own and an accepter VPC with which
     * to create the connection. The accepter VPC can belong to another Amazon Web Services account and can be in a
     * different Region to the requester VPC. The requester VPC and accepter VPC cannot have overlapping CIDR blocks.
     * </p>
     * <note>
     * <p>
     * Limitations and rules apply to a VPC peering connection. For more information, see the <a
     * href="https://docs.aws.amazon.com/vpc/latest/peering/vpc-peering-basics.html#vpc-peering-limitations"
     * >limitations</a> section in the <i>VPC Peering Guide</i>.
     * </p>
     * </note>
     * <p>
     * The owner of the accepter VPC must accept the peering request to activate the peering connection. The VPC peering
     * connection request expires after 7 days, after which it cannot be accepted or rejected.
     * </p>
     * <p>
     * If you create a VPC peering connection request between VPCs with overlapping CIDR blocks, the VPC peering
     * connection has a status of <code>failed</code>.
     * </p>
     *
     * @param createVpcPeeringConnectionRequest
     * @return A Java Future containing the result of the CreateVpcPeeringConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateVpcPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVpcPeeringConnectionResponse> createVpcPeeringConnection(
            CreateVpcPeeringConnectionRequest createVpcPeeringConnectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVpcPeeringConnectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVpcPeeringConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVpcPeeringConnection");

            HttpResponseHandler<CreateVpcPeeringConnectionResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateVpcPeeringConnectionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateVpcPeeringConnectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateVpcPeeringConnectionRequest, CreateVpcPeeringConnectionResponse>()
                            .withOperationName("CreateVpcPeeringConnection").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateVpcPeeringConnectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createVpcPeeringConnectionRequest));
            CompletableFuture<CreateVpcPeeringConnectionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a VPN connection between an existing virtual private gateway or transit gateway and a customer gateway.
     * The supported connection type is <code>ipsec.1</code>.
     * </p>
     * <p>
     * The response includes information that you need to give to your network administrator to configure your customer
     * gateway.
     * </p>
     * <important>
     * <p>
     * We strongly recommend that you use HTTPS when calling this operation because the response contains sensitive
     * cryptographic information for configuring your customer gateway device.
     * </p>
     * </important>
     * <p>
     * If you decide to shut down your VPN connection for any reason and later create a new VPN connection, you must
     * reconfigure your customer gateway with the new information returned from this call.
     * </p>
     * <p>
     * This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn't return an error.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web
     * Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     *
     * @param createVpnConnectionRequest
     *        Contains the parameters for CreateVpnConnection.
     * @return A Java Future containing the result of the CreateVpnConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateVpnConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnection" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVpnConnectionResponse> createVpnConnection(
            CreateVpnConnectionRequest createVpnConnectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVpnConnectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVpnConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVpnConnection");

            HttpResponseHandler<CreateVpnConnectionResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateVpnConnectionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateVpnConnectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateVpnConnectionRequest, CreateVpnConnectionResponse>()
                            .withOperationName("CreateVpnConnection").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateVpnConnectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createVpnConnectionRequest));
            CompletableFuture<CreateVpnConnectionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a static route associated with a VPN connection between an existing virtual private gateway and a VPN
     * customer gateway. The static route allows traffic to be routed from the virtual private gateway to the VPN
     * customer gateway.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web
     * Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     *
     * @param createVpnConnectionRouteRequest
     *        Contains the parameters for CreateVpnConnectionRoute.
     * @return A Java Future containing the result of the CreateVpnConnectionRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateVpnConnectionRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnectionRoute" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVpnConnectionRouteResponse> createVpnConnectionRoute(
            CreateVpnConnectionRouteRequest createVpnConnectionRouteRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVpnConnectionRouteRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVpnConnectionRouteRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVpnConnectionRoute");

            HttpResponseHandler<CreateVpnConnectionRouteResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateVpnConnectionRouteResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateVpnConnectionRouteResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateVpnConnectionRouteRequest, CreateVpnConnectionRouteResponse>()
                            .withOperationName("CreateVpnConnectionRoute").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateVpnConnectionRouteRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createVpnConnectionRouteRequest));
            CompletableFuture<CreateVpnConnectionRouteResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a virtual private gateway. A virtual private gateway is the endpoint on the VPC side of your VPN
     * connection. You can create a virtual private gateway before creating the VPC itself.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web
     * Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     *
     * @param createVpnGatewayRequest
     *        Contains the parameters for CreateVpnGateway.
     * @return A Java Future containing the result of the CreateVpnGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateVpnGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVpnGatewayResponse> createVpnGateway(CreateVpnGatewayRequest createVpnGatewayRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVpnGatewayRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVpnGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVpnGateway");

            HttpResponseHandler<CreateVpnGatewayResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateVpnGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateVpnGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateVpnGatewayRequest, CreateVpnGatewayResponse>()
                            .withOperationName("CreateVpnGateway").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateVpnGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createVpnGatewayRequest));
            CompletableFuture<CreateVpnGatewayResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a carrier gateway.
     * </p>
     * <important>
     * <p>
     * If you do not delete the route that contains the carrier gateway as the Target, the route is a blackhole route.
     * For information about how to delete a route, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteRoute.html">DeleteRoute</a>.
     * </p>
     * </important>
     *
     * @param deleteCarrierGatewayRequest
     * @return A Java Future containing the result of the DeleteCarrierGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteCarrierGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCarrierGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCarrierGatewayResponse> deleteCarrierGateway(
            DeleteCarrierGatewayRequest deleteCarrierGatewayRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCarrierGatewayRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCarrierGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCarrierGateway");

            HttpResponseHandler<DeleteCarrierGatewayResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteCarrierGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteCarrierGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCarrierGatewayRequest, DeleteCarrierGatewayResponse>()
                            .withOperationName("DeleteCarrierGateway").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteCarrierGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteCarrierGatewayRequest));
            CompletableFuture<DeleteCarrierGatewayResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified Client VPN endpoint. You must disassociate all target networks before you can delete a
     * Client VPN endpoint.
     * </p>
     *
     * @param deleteClientVpnEndpointRequest
     * @return A Java Future containing the result of the DeleteClientVpnEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteClientVpnEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteClientVpnEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteClientVpnEndpointResponse> deleteClientVpnEndpoint(
            DeleteClientVpnEndpointRequest deleteClientVpnEndpointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteClientVpnEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteClientVpnEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteClientVpnEndpoint");

            HttpResponseHandler<DeleteClientVpnEndpointResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteClientVpnEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteClientVpnEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteClientVpnEndpointRequest, DeleteClientVpnEndpointResponse>()
                            .withOperationName("DeleteClientVpnEndpoint").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteClientVpnEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteClientVpnEndpointRequest));
            CompletableFuture<DeleteClientVpnEndpointResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a route from a Client VPN endpoint. You can only delete routes that you manually added using the
     * <b>CreateClientVpnRoute</b> action. You cannot delete routes that were automatically added when associating a
     * subnet. To remove routes that have been automatically added, disassociate the target subnet from the Client VPN
     * endpoint.
     * </p>
     *
     * @param deleteClientVpnRouteRequest
     * @return A Java Future containing the result of the DeleteClientVpnRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteClientVpnRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteClientVpnRoute" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteClientVpnRouteResponse> deleteClientVpnRoute(
            DeleteClientVpnRouteRequest deleteClientVpnRouteRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteClientVpnRouteRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteClientVpnRouteRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteClientVpnRoute");

            HttpResponseHandler<DeleteClientVpnRouteResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteClientVpnRouteResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteClientVpnRouteResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteClientVpnRouteRequest, DeleteClientVpnRouteResponse>()
                            .withOperationName("DeleteClientVpnRoute").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteClientVpnRouteRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteClientVpnRouteRequest));
            CompletableFuture<DeleteClientVpnRouteResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a range of customer-owned IP addresses.
     * </p>
     *
     * @param deleteCoipCidrRequest
     * @return A Java Future containing the result of the DeleteCoipCidr operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteCoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCoipCidr" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCoipCidrResponse> deleteCoipCidr(DeleteCoipCidrRequest deleteCoipCidrRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCoipCidrRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCoipCidrRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCoipCidr");

            HttpResponseHandler<DeleteCoipCidrResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteCoipCidrResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteCoipCidrResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCoipCidrRequest, DeleteCoipCidrResponse>()
                            .withOperationName("DeleteCoipCidr").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteCoipCidrRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteCoipCidrRequest));
            CompletableFuture<DeleteCoipCidrResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a pool of customer-owned IP (CoIP) addresses.
     * </p>
     *
     * @param deleteCoipPoolRequest
     * @return A Java Future containing the result of the DeleteCoipPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteCoipPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCoipPool" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCoipPoolResponse> deleteCoipPool(DeleteCoipPoolRequest deleteCoipPoolRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCoipPoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCoipPoolRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCoipPool");

            HttpResponseHandler<DeleteCoipPoolResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteCoipPoolResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteCoipPoolResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCoipPoolRequest, DeleteCoipPoolResponse>()
                            .withOperationName("DeleteCoipPool").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteCoipPoolRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteCoipPoolRequest));
            CompletableFuture<DeleteCoipPoolResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified customer gateway. You must delete the VPN connection before you can delete the customer
     * gateway.
     * </p>
     *
     * @param deleteCustomerGatewayRequest
     *        Contains the parameters for DeleteCustomerGateway.
     * @return A Java Future containing the result of the DeleteCustomerGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteCustomerGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCustomerGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCustomerGatewayResponse> deleteCustomerGateway(
            DeleteCustomerGatewayRequest deleteCustomerGatewayRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCustomerGatewayRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCustomerGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCustomerGateway");

            HttpResponseHandler<DeleteCustomerGatewayResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteCustomerGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteCustomerGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCustomerGatewayRequest, DeleteCustomerGatewayResponse>()
                            .withOperationName("DeleteCustomerGateway").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteCustomerGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteCustomerGatewayRequest));
            CompletableFuture<DeleteCustomerGatewayResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified set of DHCP options. You must disassociate the set of DHCP options before you can delete
     * it. You can disassociate the set of DHCP options by associating either a new set of options or the default set of
     * options with the VPC.
     * </p>
     *
     * @param deleteDhcpOptionsRequest
     * @return A Java Future containing the result of the DeleteDhcpOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteDhcpOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteDhcpOptions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDhcpOptionsResponse> deleteDhcpOptions(DeleteDhcpOptionsRequest deleteDhcpOptionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDhcpOptionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDhcpOptionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDhcpOptions");

            HttpResponseHandler<DeleteDhcpOptionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteDhcpOptionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteDhcpOptionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDhcpOptionsRequest, DeleteDhcpOptionsResponse>()
                            .withOperationName("DeleteDhcpOptions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteDhcpOptionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteDhcpOptionsRequest));
            CompletableFuture<DeleteDhcpOptionsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an egress-only internet gateway.
     * </p>
     *
     * @param deleteEgressOnlyInternetGatewayRequest
     * @return A Java Future containing the result of the DeleteEgressOnlyInternetGateway operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteEgressOnlyInternetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteEgressOnlyInternetGateway"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEgressOnlyInternetGatewayResponse> deleteEgressOnlyInternetGateway(
            DeleteEgressOnlyInternetGatewayRequest deleteEgressOnlyInternetGatewayRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEgressOnlyInternetGatewayRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteEgressOnlyInternetGatewayRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEgressOnlyInternetGateway");

            HttpResponseHandler<DeleteEgressOnlyInternetGatewayResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteEgressOnlyInternetGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteEgressOnlyInternetGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEgressOnlyInternetGatewayRequest, DeleteEgressOnlyInternetGatewayResponse>()
                            .withOperationName("DeleteEgressOnlyInternetGateway").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteEgressOnlyInternetGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteEgressOnlyInternetGatewayRequest));
            CompletableFuture<DeleteEgressOnlyInternetGatewayResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified EC2 Fleets.
     * </p>
     * <p>
     * After you delete an EC2 Fleet, it launches no new instances.
     * </p>
     * <p>
     * You must also specify whether a deleted EC2 Fleet should terminate its instances. If you choose to terminate the
     * instances, the EC2 Fleet enters the <code>deleted_terminating</code> state. Otherwise, the EC2 Fleet enters the
     * <code>deleted_running</code> state, and the instances continue to run until they are interrupted or you terminate
     * them manually.
     * </p>
     * <p>
     * For <code>instant</code> fleets, EC2 Fleet must terminate the instances when the fleet is deleted. Up to 1000
     * instances can be terminated in a single request to delete <code>instant</code> fleets. A deleted
     * <code>instant</code> fleet with running instances is not supported.
     * </p>
     * <p class="title">
     * <b>Restrictions</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can delete up to 25 fleets of type <code>instant</code> in a single request.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can delete up to 100 fleets of type <code>maintain</code> or <code>request</code> in a single request.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can delete up to 125 fleets in a single request, provided you do not exceed the quota for each fleet type, as
     * specified above.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you exceed the specified number of fleets to delete, no fleets are deleted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#delete-fleet">Delete an EC2
     * Fleet</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param deleteFleetsRequest
     * @return A Java Future containing the result of the DeleteFleets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFleets" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFleetsResponse> deleteFleets(DeleteFleetsRequest deleteFleetsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFleetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFleetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFleets");

            HttpResponseHandler<DeleteFleetsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteFleetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteFleetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFleetsRequest, DeleteFleetsResponse>()
                            .withOperationName("DeleteFleets").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteFleetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteFleetsRequest));
            CompletableFuture<DeleteFleetsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes one or more flow logs.
     * </p>
     *
     * @param deleteFlowLogsRequest
     * @return A Java Future containing the result of the DeleteFlowLogs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteFlowLogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFlowLogs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFlowLogsResponse> deleteFlowLogs(DeleteFlowLogsRequest deleteFlowLogsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFlowLogsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFlowLogsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFlowLogs");

            HttpResponseHandler<DeleteFlowLogsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteFlowLogsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteFlowLogsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFlowLogsRequest, DeleteFlowLogsResponse>()
                            .withOperationName("DeleteFlowLogs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteFlowLogsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteFlowLogsRequest));
            CompletableFuture<DeleteFlowLogsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified Amazon FPGA Image (AFI).
     * </p>
     *
     * @param deleteFpgaImageRequest
     * @return A Java Future containing the result of the DeleteFpgaImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteFpgaImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFpgaImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFpgaImageResponse> deleteFpgaImage(DeleteFpgaImageRequest deleteFpgaImageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFpgaImageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFpgaImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFpgaImage");

            HttpResponseHandler<DeleteFpgaImageResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteFpgaImageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteFpgaImageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFpgaImageRequest, DeleteFpgaImageResponse>()
                            .withOperationName("DeleteFpgaImage").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteFpgaImageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteFpgaImageRequest));
            CompletableFuture<DeleteFpgaImageResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified EC2 Instance Connect Endpoint.
     * </p>
     *
     * @param deleteInstanceConnectEndpointRequest
     * @return A Java Future containing the result of the DeleteInstanceConnectEndpoint operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteInstanceConnectEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInstanceConnectEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteInstanceConnectEndpointResponse> deleteInstanceConnectEndpoint(
            DeleteInstanceConnectEndpointRequest deleteInstanceConnectEndpointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteInstanceConnectEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteInstanceConnectEndpointRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInstanceConnectEndpoint");

            HttpResponseHandler<DeleteInstanceConnectEndpointResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteInstanceConnectEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteInstanceConnectEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteInstanceConnectEndpointRequest, DeleteInstanceConnectEndpointResponse>()
                            .withOperationName("DeleteInstanceConnectEndpoint").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteInstanceConnectEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteInstanceConnectEndpointRequest));
            CompletableFuture<DeleteInstanceConnectEndpointResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified event window.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define
     * event windows for scheduled events</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param deleteInstanceEventWindowRequest
     * @return A Java Future containing the result of the DeleteInstanceEventWindow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteInstanceEventWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInstanceEventWindow" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteInstanceEventWindowResponse> deleteInstanceEventWindow(
            DeleteInstanceEventWindowRequest deleteInstanceEventWindowRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteInstanceEventWindowRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteInstanceEventWindowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInstanceEventWindow");

            HttpResponseHandler<DeleteInstanceEventWindowResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteInstanceEventWindowResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteInstanceEventWindowResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteInstanceEventWindowRequest, DeleteInstanceEventWindowResponse>()
                            .withOperationName("DeleteInstanceEventWindow").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteInstanceEventWindowRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteInstanceEventWindowRequest));
            CompletableFuture<DeleteInstanceEventWindowResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified internet gateway. You must detach the internet gateway from the VPC before you can delete
     * it.
     * </p>
     *
     * @param deleteInternetGatewayRequest
     * @return A Java Future containing the result of the DeleteInternetGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteInternetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInternetGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteInternetGatewayResponse> deleteInternetGateway(
            DeleteInternetGatewayRequest deleteInternetGatewayRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteInternetGatewayRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteInternetGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInternetGateway");

            HttpResponseHandler<DeleteInternetGatewayResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteInternetGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteInternetGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteInternetGatewayRequest, DeleteInternetGatewayResponse>()
                            .withOperationName("DeleteInternetGateway").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteInternetGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteInternetGatewayRequest));
            CompletableFuture<DeleteInternetGatewayResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete an IPAM. Deleting an IPAM removes all monitored data associated with the IPAM including the historical
     * data for CIDRs.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/delete-ipam.html">Delete an
     * IPAM</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     *
     * @param deleteIpamRequest
     * @return A Java Future containing the result of the DeleteIpam operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteIpam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpam" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteIpamResponse> deleteIpam(DeleteIpamRequest deleteIpamRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteIpamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIpamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIpam");

            HttpResponseHandler<DeleteIpamResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteIpamResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteIpamResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteIpamRequest, DeleteIpamResponse>().withOperationName("DeleteIpam")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteIpamRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteIpamRequest));
            CompletableFuture<DeleteIpamResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete an IPAM pool.
     * </p>
     * <note>
     * <p>
     * You cannot delete an IPAM pool if there are allocations in it or CIDRs provisioned to it. To release allocations,
     * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReleaseIpamPoolAllocation.html">
     * ReleaseIpamPoolAllocation</a>. To deprovision pool CIDRs, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeprovisionIpamPoolCidr.html"
     * >DeprovisionIpamPoolCidr</a>.
     * </p>
     * </note>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/delete-pool-ipam.html">Delete a
     * pool</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     *
     * @param deleteIpamPoolRequest
     * @return A Java Future containing the result of the DeleteIpamPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteIpamPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamPool" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteIpamPoolResponse> deleteIpamPool(DeleteIpamPoolRequest deleteIpamPoolRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteIpamPoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIpamPoolRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIpamPool");

            HttpResponseHandler<DeleteIpamPoolResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteIpamPoolResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteIpamPoolResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteIpamPoolRequest, DeleteIpamPoolResponse>()
                            .withOperationName("DeleteIpamPool").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteIpamPoolRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteIpamPoolRequest));
            CompletableFuture<DeleteIpamPoolResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an IPAM resource discovery. A resource discovery is an IPAM component that enables IPAM to manage and
     * monitor resources that belong to the owning account.
     * </p>
     *
     * @param deleteIpamResourceDiscoveryRequest
     * @return A Java Future containing the result of the DeleteIpamResourceDiscovery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteIpamResourceDiscovery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamResourceDiscovery"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteIpamResourceDiscoveryResponse> deleteIpamResourceDiscovery(
            DeleteIpamResourceDiscoveryRequest deleteIpamResourceDiscoveryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteIpamResourceDiscoveryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIpamResourceDiscoveryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIpamResourceDiscovery");

            HttpResponseHandler<DeleteIpamResourceDiscoveryResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteIpamResourceDiscoveryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteIpamResourceDiscoveryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteIpamResourceDiscoveryRequest, DeleteIpamResourceDiscoveryResponse>()
                            .withOperationName("DeleteIpamResourceDiscovery").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteIpamResourceDiscoveryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteIpamResourceDiscoveryRequest));
            CompletableFuture<DeleteIpamResourceDiscoveryResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete the scope for an IPAM. You cannot delete the default scopes.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/delete-scope-ipam.html">Delete a
     * scope</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     *
     * @param deleteIpamScopeRequest
     * @return A Java Future containing the result of the DeleteIpamScope operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteIpamScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamScope" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteIpamScopeResponse> deleteIpamScope(DeleteIpamScopeRequest deleteIpamScopeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteIpamScopeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIpamScopeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIpamScope");

            HttpResponseHandler<DeleteIpamScopeResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteIpamScopeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteIpamScopeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteIpamScopeRequest, DeleteIpamScopeResponse>()
                            .withOperationName("DeleteIpamScope").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteIpamScopeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteIpamScopeRequest));
            CompletableFuture<DeleteIpamScopeResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified key pair, by removing the public key from Amazon EC2.
     * </p>
     *
     * @param deleteKeyPairRequest
     * @return A Java Future containing the result of the DeleteKeyPair operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteKeyPair
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteKeyPairResponse> deleteKeyPair(DeleteKeyPairRequest deleteKeyPairRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteKeyPairRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteKeyPairRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteKeyPair");

            HttpResponseHandler<DeleteKeyPairResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteKeyPairResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteKeyPairResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteKeyPairRequest, DeleteKeyPairResponse>()
                            .withOperationName("DeleteKeyPair").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteKeyPairRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteKeyPairRequest));
            CompletableFuture<DeleteKeyPairResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a launch template. Deleting a launch template deletes all of its versions.
     * </p>
     *
     * @param deleteLaunchTemplateRequest
     * @return A Java Future containing the result of the DeleteLaunchTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteLaunchTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteLaunchTemplateResponse> deleteLaunchTemplate(
            DeleteLaunchTemplateRequest deleteLaunchTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteLaunchTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteLaunchTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLaunchTemplate");

            HttpResponseHandler<DeleteLaunchTemplateResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteLaunchTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteLaunchTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteLaunchTemplateRequest, DeleteLaunchTemplateResponse>()
                            .withOperationName("DeleteLaunchTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteLaunchTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteLaunchTemplateRequest));
            CompletableFuture<DeleteLaunchTemplateResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes one or more versions of a launch template.
     * </p>
     * <p>
     * You can't delete the default version of a launch template; you must first assign a different version as the
     * default. If the default version is the only version for the launch template, you must delete the entire launch
     * template using <a>DeleteLaunchTemplate</a>.
     * </p>
     * <p>
     * You can delete up to 200 launch template versions in a single request. To delete more than 200 versions in a
     * single request, use <a>DeleteLaunchTemplate</a>, which deletes the launch template and all of its versions.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-launch-template-versions.html#delete-launch-template-version"
     * >Delete a launch template version</a> in the <i>EC2 User Guide</i>.
     * </p>
     *
     * @param deleteLaunchTemplateVersionsRequest
     * @return A Java Future containing the result of the DeleteLaunchTemplateVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteLaunchTemplateVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplateVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteLaunchTemplateVersionsResponse> deleteLaunchTemplateVersions(
            DeleteLaunchTemplateVersionsRequest deleteLaunchTemplateVersionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteLaunchTemplateVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteLaunchTemplateVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLaunchTemplateVersions");

            HttpResponseHandler<DeleteLaunchTemplateVersionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteLaunchTemplateVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteLaunchTemplateVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteLaunchTemplateVersionsRequest, DeleteLaunchTemplateVersionsResponse>()
                            .withOperationName("DeleteLaunchTemplateVersions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteLaunchTemplateVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteLaunchTemplateVersionsRequest));
            CompletableFuture<DeleteLaunchTemplateVersionsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified route from the specified local gateway route table.
     * </p>
     *
     * @param deleteLocalGatewayRouteRequest
     * @return A Java Future containing the result of the DeleteLocalGatewayRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteLocalGatewayRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteLocalGatewayRouteResponse> deleteLocalGatewayRoute(
            DeleteLocalGatewayRouteRequest deleteLocalGatewayRouteRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteLocalGatewayRouteRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteLocalGatewayRouteRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLocalGatewayRoute");

            HttpResponseHandler<DeleteLocalGatewayRouteResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteLocalGatewayRouteResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteLocalGatewayRouteResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteLocalGatewayRouteRequest, DeleteLocalGatewayRouteResponse>()
                            .withOperationName("DeleteLocalGatewayRoute").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteLocalGatewayRouteRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteLocalGatewayRouteRequest));
            CompletableFuture<DeleteLocalGatewayRouteResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a local gateway route table.
     * </p>
     *
     * @param deleteLocalGatewayRouteTableRequest
     * @return A Java Future containing the result of the DeleteLocalGatewayRouteTable operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteLocalGatewayRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRouteTable"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteLocalGatewayRouteTableResponse> deleteLocalGatewayRouteTable(
            DeleteLocalGatewayRouteTableRequest deleteLocalGatewayRouteTableRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteLocalGatewayRouteTableRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteLocalGatewayRouteTableRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLocalGatewayRouteTable");

            HttpResponseHandler<DeleteLocalGatewayRouteTableResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteLocalGatewayRouteTableResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteLocalGatewayRouteTableResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteLocalGatewayRouteTableRequest, DeleteLocalGatewayRouteTableResponse>()
                            .withOperationName("DeleteLocalGatewayRouteTable").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteLocalGatewayRouteTableRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteLocalGatewayRouteTableRequest));
            CompletableFuture<DeleteLocalGatewayRouteTableResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a local gateway route table virtual interface group association.
     * </p>
     *
     * @param deleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest
     * @return A Java Future containing the result of the DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation
     *         operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse> deleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation(
            DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest deleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                deleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME,
                    "DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation");

            HttpResponseHandler<DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest, DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse>()
                            .withOperationName("DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(
                                    new DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequestMarshaller(
                                            protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest));
            CompletableFuture<DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified association between a VPC and local gateway route table.
     * </p>
     *
     * @param deleteLocalGatewayRouteTableVpcAssociationRequest
     * @return A Java Future containing the result of the DeleteLocalGatewayRouteTableVpcAssociation operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteLocalGatewayRouteTableVpcAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRouteTableVpcAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteLocalGatewayRouteTableVpcAssociationResponse> deleteLocalGatewayRouteTableVpcAssociation(
            DeleteLocalGatewayRouteTableVpcAssociationRequest deleteLocalGatewayRouteTableVpcAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                deleteLocalGatewayRouteTableVpcAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteLocalGatewayRouteTableVpcAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLocalGatewayRouteTableVpcAssociation");

            HttpResponseHandler<DeleteLocalGatewayRouteTableVpcAssociationResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteLocalGatewayRouteTableVpcAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteLocalGatewayRouteTableVpcAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteLocalGatewayRouteTableVpcAssociationRequest, DeleteLocalGatewayRouteTableVpcAssociationResponse>()
                            .withOperationName("DeleteLocalGatewayRouteTableVpcAssociation")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteLocalGatewayRouteTableVpcAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteLocalGatewayRouteTableVpcAssociationRequest));
            CompletableFuture<DeleteLocalGatewayRouteTableVpcAssociationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified managed prefix list. You must first remove all references to the prefix list in your
     * resources.
     * </p>
     *
     * @param deleteManagedPrefixListRequest
     * @return A Java Future containing the result of the DeleteManagedPrefixList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteManagedPrefixList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteManagedPrefixList" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteManagedPrefixListResponse> deleteManagedPrefixList(
            DeleteManagedPrefixListRequest deleteManagedPrefixListRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteManagedPrefixListRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteManagedPrefixListRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteManagedPrefixList");

            HttpResponseHandler<DeleteManagedPrefixListResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteManagedPrefixListResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteManagedPrefixListResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteManagedPrefixListRequest, DeleteManagedPrefixListResponse>()
                            .withOperationName("DeleteManagedPrefixList").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteManagedPrefixListRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteManagedPrefixListRequest));
            CompletableFuture<DeleteManagedPrefixListResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified NAT gateway. Deleting a public NAT gateway disassociates its Elastic IP address, but does
     * not release the address from your account. Deleting a NAT gateway does not delete any NAT gateway routes in your
     * route tables.
     * </p>
     *
     * @param deleteNatGatewayRequest
     * @return A Java Future containing the result of the DeleteNatGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteNatGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNatGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteNatGatewayResponse> deleteNatGateway(DeleteNatGatewayRequest deleteNatGatewayRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteNatGatewayRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteNatGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNatGateway");

            HttpResponseHandler<DeleteNatGatewayResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteNatGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteNatGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteNatGatewayRequest, DeleteNatGatewayResponse>()
                            .withOperationName("DeleteNatGateway").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteNatGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteNatGatewayRequest));
            CompletableFuture<DeleteNatGatewayResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified network ACL. You can't delete the ACL if it's associated with any subnets. You can't delete
     * the default network ACL.
     * </p>
     *
     * @param deleteNetworkAclRequest
     * @return A Java Future containing the result of the DeleteNetworkAcl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteNetworkAcl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAcl" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteNetworkAclResponse> deleteNetworkAcl(DeleteNetworkAclRequest deleteNetworkAclRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteNetworkAclRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteNetworkAclRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNetworkAcl");

            HttpResponseHandler<DeleteNetworkAclResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteNetworkAclResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteNetworkAclResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteNetworkAclRequest, DeleteNetworkAclResponse>()
                            .withOperationName("DeleteNetworkAcl").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteNetworkAclRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteNetworkAclRequest));
            CompletableFuture<DeleteNetworkAclResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified ingress or egress entry (rule) from the specified network ACL.
     * </p>
     *
     * @param deleteNetworkAclEntryRequest
     * @return A Java Future containing the result of the DeleteNetworkAclEntry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteNetworkAclEntry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAclEntry" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteNetworkAclEntryResponse> deleteNetworkAclEntry(
            DeleteNetworkAclEntryRequest deleteNetworkAclEntryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteNetworkAclEntryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteNetworkAclEntryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNetworkAclEntry");

            HttpResponseHandler<DeleteNetworkAclEntryResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteNetworkAclEntryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteNetworkAclEntryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteNetworkAclEntryRequest, DeleteNetworkAclEntryResponse>()
                            .withOperationName("DeleteNetworkAclEntry").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteNetworkAclEntryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteNetworkAclEntryRequest));
            CompletableFuture<DeleteNetworkAclEntryResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified Network Access Scope.
     * </p>
     *
     * @param deleteNetworkInsightsAccessScopeRequest
     * @return A Java Future containing the result of the DeleteNetworkInsightsAccessScope operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteNetworkInsightsAccessScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsAccessScope"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteNetworkInsightsAccessScopeResponse> deleteNetworkInsightsAccessScope(
            DeleteNetworkInsightsAccessScopeRequest deleteNetworkInsightsAccessScopeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteNetworkInsightsAccessScopeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteNetworkInsightsAccessScopeRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNetworkInsightsAccessScope");

            HttpResponseHandler<DeleteNetworkInsightsAccessScopeResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteNetworkInsightsAccessScopeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteNetworkInsightsAccessScopeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteNetworkInsightsAccessScopeRequest, DeleteNetworkInsightsAccessScopeResponse>()
                            .withOperationName("DeleteNetworkInsightsAccessScope").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteNetworkInsightsAccessScopeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteNetworkInsightsAccessScopeRequest));
            CompletableFuture<DeleteNetworkInsightsAccessScopeResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified Network Access Scope analysis.
     * </p>
     *
     * @param deleteNetworkInsightsAccessScopeAnalysisRequest
     * @return A Java Future containing the result of the DeleteNetworkInsightsAccessScopeAnalysis operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteNetworkInsightsAccessScopeAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsAccessScopeAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteNetworkInsightsAccessScopeAnalysisResponse> deleteNetworkInsightsAccessScopeAnalysis(
            DeleteNetworkInsightsAccessScopeAnalysisRequest deleteNetworkInsightsAccessScopeAnalysisRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                deleteNetworkInsightsAccessScopeAnalysisRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteNetworkInsightsAccessScopeAnalysisRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNetworkInsightsAccessScopeAnalysis");

            HttpResponseHandler<DeleteNetworkInsightsAccessScopeAnalysisResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteNetworkInsightsAccessScopeAnalysisResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteNetworkInsightsAccessScopeAnalysisResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteNetworkInsightsAccessScopeAnalysisRequest, DeleteNetworkInsightsAccessScopeAnalysisResponse>()
                            .withOperationName("DeleteNetworkInsightsAccessScopeAnalysis").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteNetworkInsightsAccessScopeAnalysisRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteNetworkInsightsAccessScopeAnalysisRequest));
            CompletableFuture<DeleteNetworkInsightsAccessScopeAnalysisResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified network insights analysis.
     * </p>
     *
     * @param deleteNetworkInsightsAnalysisRequest
     * @return A Java Future containing the result of the DeleteNetworkInsightsAnalysis operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteNetworkInsightsAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteNetworkInsightsAnalysisResponse> deleteNetworkInsightsAnalysis(
            DeleteNetworkInsightsAnalysisRequest deleteNetworkInsightsAnalysisRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteNetworkInsightsAnalysisRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteNetworkInsightsAnalysisRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNetworkInsightsAnalysis");

            HttpResponseHandler<DeleteNetworkInsightsAnalysisResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteNetworkInsightsAnalysisResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteNetworkInsightsAnalysisResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteNetworkInsightsAnalysisRequest, DeleteNetworkInsightsAnalysisResponse>()
                            .withOperationName("DeleteNetworkInsightsAnalysis").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteNetworkInsightsAnalysisRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteNetworkInsightsAnalysisRequest));
            CompletableFuture<DeleteNetworkInsightsAnalysisResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified path.
     * </p>
     *
     * @param deleteNetworkInsightsPathRequest
     * @return A Java Future containing the result of the DeleteNetworkInsightsPath operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteNetworkInsightsPath
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsPath" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteNetworkInsightsPathResponse> deleteNetworkInsightsPath(
            DeleteNetworkInsightsPathRequest deleteNetworkInsightsPathRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteNetworkInsightsPathRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteNetworkInsightsPathRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNetworkInsightsPath");

            HttpResponseHandler<DeleteNetworkInsightsPathResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteNetworkInsightsPathResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteNetworkInsightsPathResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteNetworkInsightsPathRequest, DeleteNetworkInsightsPathResponse>()
                            .withOperationName("DeleteNetworkInsightsPath").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteNetworkInsightsPathRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteNetworkInsightsPathRequest));
            CompletableFuture<DeleteNetworkInsightsPathResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified network interface. You must detach the network interface before you can delete it.
     * </p>
     *
     * @param deleteNetworkInterfaceRequest
     *        Contains the parameters for DeleteNetworkInterface.
     * @return A Java Future containing the result of the DeleteNetworkInterface operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterface" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteNetworkInterfaceResponse> deleteNetworkInterface(
            DeleteNetworkInterfaceRequest deleteNetworkInterfaceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteNetworkInterfaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteNetworkInterfaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNetworkInterface");

            HttpResponseHandler<DeleteNetworkInterfaceResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteNetworkInterfaceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteNetworkInterfaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteNetworkInterfaceRequest, DeleteNetworkInterfaceResponse>()
                            .withOperationName("DeleteNetworkInterface").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteNetworkInterfaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteNetworkInterfaceRequest));
            CompletableFuture<DeleteNetworkInterfaceResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a permission for a network interface. By default, you cannot delete the permission if the account for
     * which you're removing the permission has attached the network interface to an instance. However, you can force
     * delete the permission, regardless of any attachment.
     * </p>
     *
     * @param deleteNetworkInterfacePermissionRequest
     *        Contains the parameters for DeleteNetworkInterfacePermission.
     * @return A Java Future containing the result of the DeleteNetworkInterfacePermission operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteNetworkInterfacePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterfacePermission"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteNetworkInterfacePermissionResponse> deleteNetworkInterfacePermission(
            DeleteNetworkInterfacePermissionRequest deleteNetworkInterfacePermissionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteNetworkInterfacePermissionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteNetworkInterfacePermissionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNetworkInterfacePermission");

            HttpResponseHandler<DeleteNetworkInterfacePermissionResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteNetworkInterfacePermissionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteNetworkInterfacePermissionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteNetworkInterfacePermissionRequest, DeleteNetworkInterfacePermissionResponse>()
                            .withOperationName("DeleteNetworkInterfacePermission").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteNetworkInterfacePermissionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteNetworkInterfacePermissionRequest));
            CompletableFuture<DeleteNetworkInterfacePermissionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified placement group. You must terminate all instances in the placement group before you can
     * delete the placement group. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param deletePlacementGroupRequest
     * @return A Java Future containing the result of the DeletePlacementGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeletePlacementGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeletePlacementGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeletePlacementGroupResponse> deletePlacementGroup(
            DeletePlacementGroupRequest deletePlacementGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deletePlacementGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePlacementGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePlacementGroup");

            HttpResponseHandler<DeletePlacementGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeletePlacementGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeletePlacementGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeletePlacementGroupRequest, DeletePlacementGroupResponse>()
                            .withOperationName("DeletePlacementGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeletePlacementGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deletePlacementGroupRequest));
            CompletableFuture<DeletePlacementGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete a public IPv4 pool. A public IPv4 pool is an EC2 IP address pool required for the public IPv4 CIDRs that
     * you own and bring to Amazon Web Services to manage with IPAM. IPv6 addresses you bring to Amazon Web Services,
     * however, use IPAM pools only.
     * </p>
     *
     * @param deletePublicIpv4PoolRequest
     * @return A Java Future containing the result of the DeletePublicIpv4Pool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeletePublicIpv4Pool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeletePublicIpv4Pool" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeletePublicIpv4PoolResponse> deletePublicIpv4Pool(
            DeletePublicIpv4PoolRequest deletePublicIpv4PoolRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deletePublicIpv4PoolRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePublicIpv4PoolRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePublicIpv4Pool");

            HttpResponseHandler<DeletePublicIpv4PoolResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeletePublicIpv4PoolResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeletePublicIpv4PoolResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeletePublicIpv4PoolRequest, DeletePublicIpv4PoolResponse>()
                            .withOperationName("DeletePublicIpv4Pool").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeletePublicIpv4PoolRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deletePublicIpv4PoolRequest));
            CompletableFuture<DeletePublicIpv4PoolResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the queued purchases for the specified Reserved Instances.
     * </p>
     *
     * @param deleteQueuedReservedInstancesRequest
     * @return A Java Future containing the result of the DeleteQueuedReservedInstances operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteQueuedReservedInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteQueuedReservedInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteQueuedReservedInstancesResponse> deleteQueuedReservedInstances(
            DeleteQueuedReservedInstancesRequest deleteQueuedReservedInstancesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteQueuedReservedInstancesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteQueuedReservedInstancesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteQueuedReservedInstances");

            HttpResponseHandler<DeleteQueuedReservedInstancesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteQueuedReservedInstancesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteQueuedReservedInstancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteQueuedReservedInstancesRequest, DeleteQueuedReservedInstancesResponse>()
                            .withOperationName("DeleteQueuedReservedInstances").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteQueuedReservedInstancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteQueuedReservedInstancesRequest));
            CompletableFuture<DeleteQueuedReservedInstancesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified route from the specified route table.
     * </p>
     *
     * @param deleteRouteRequest
     * @return A Java Future containing the result of the DeleteRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRoute" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRouteResponse> deleteRoute(DeleteRouteRequest deleteRouteRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRouteRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRouteRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRoute");

            HttpResponseHandler<DeleteRouteResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteRouteResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteRouteResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRouteRequest, DeleteRouteResponse>()
                            .withOperationName("DeleteRoute").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteRouteRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteRouteRequest));
            CompletableFuture<DeleteRouteResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified route table. You must disassociate the route table from any subnets before you can delete
     * it. You can't delete the main route table.
     * </p>
     *
     * @param deleteRouteTableRequest
     * @return A Java Future containing the result of the DeleteRouteTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRouteTable" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRouteTableResponse> deleteRouteTable(DeleteRouteTableRequest deleteRouteTableRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRouteTableRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRouteTableRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRouteTable");

            HttpResponseHandler<DeleteRouteTableResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteRouteTableResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteRouteTableResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRouteTableRequest, DeleteRouteTableResponse>()
                            .withOperationName("DeleteRouteTable").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteRouteTableRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteRouteTableRequest));
            CompletableFuture<DeleteRouteTableResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a security group.
     * </p>
     * <p>
     * If you attempt to delete a security group that is associated with an instance or network interface or is
     * referenced by another security group, the operation fails with <code>DependencyViolation</code>.
     * </p>
     *
     * @param deleteSecurityGroupRequest
     * @return A Java Future containing the result of the DeleteSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSecurityGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSecurityGroupResponse> deleteSecurityGroup(
            DeleteSecurityGroupRequest deleteSecurityGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSecurityGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSecurityGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSecurityGroup");

            HttpResponseHandler<DeleteSecurityGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteSecurityGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteSecurityGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSecurityGroupRequest, DeleteSecurityGroupResponse>()
                            .withOperationName("DeleteSecurityGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteSecurityGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteSecurityGroupRequest));
            CompletableFuture<DeleteSecurityGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified snapshot.
     * </p>
     * <p>
     * When you make periodic snapshots of a volume, the snapshots are incremental, and only the blocks on the device
     * that have changed since your last snapshot are saved in the new snapshot. When you delete a snapshot, only the
     * data not needed for any other snapshot is removed. So regardless of which prior snapshots have been deleted, all
     * active snapshots will have access to all the information needed to restore the volume.
     * </p>
     * <p>
     * You cannot delete a snapshot of the root device of an EBS volume used by a registered AMI. You must first
     * de-register the AMI before you can delete the snapshot.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-deleting-snapshot.html">Delete an Amazon EBS
     * snapshot</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     *
     * @param deleteSnapshotRequest
     * @return A Java Future containing the result of the DeleteSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSnapshotResponse> deleteSnapshot(DeleteSnapshotRequest deleteSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSnapshot");

            HttpResponseHandler<DeleteSnapshotResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSnapshotRequest, DeleteSnapshotResponse>()
                            .withOperationName("DeleteSnapshot").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteSnapshotRequest));
            CompletableFuture<DeleteSnapshotResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the data feed for Spot Instances.
     * </p>
     *
     * @param deleteSpotDatafeedSubscriptionRequest
     *        Contains the parameters for DeleteSpotDatafeedSubscription.
     * @return A Java Future containing the result of the DeleteSpotDatafeedSubscription operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteSpotDatafeedSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSpotDatafeedSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSpotDatafeedSubscriptionResponse> deleteSpotDatafeedSubscription(
            DeleteSpotDatafeedSubscriptionRequest deleteSpotDatafeedSubscriptionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSpotDatafeedSubscriptionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteSpotDatafeedSubscriptionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSpotDatafeedSubscription");

            HttpResponseHandler<DeleteSpotDatafeedSubscriptionResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteSpotDatafeedSubscriptionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteSpotDatafeedSubscriptionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSpotDatafeedSubscriptionRequest, DeleteSpotDatafeedSubscriptionResponse>()
                            .withOperationName("DeleteSpotDatafeedSubscription").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteSpotDatafeedSubscriptionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteSpotDatafeedSubscriptionRequest));
            CompletableFuture<DeleteSpotDatafeedSubscriptionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified subnet. You must terminate all running instances in the subnet before you can delete the
     * subnet.
     * </p>
     *
     * @param deleteSubnetRequest
     * @return A Java Future containing the result of the DeleteSubnet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteSubnet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSubnet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSubnetResponse> deleteSubnet(DeleteSubnetRequest deleteSubnetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSubnetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSubnetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSubnet");

            HttpResponseHandler<DeleteSubnetResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteSubnetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteSubnetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSubnetRequest, DeleteSubnetResponse>()
                            .withOperationName("DeleteSubnet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteSubnetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteSubnetRequest));
            CompletableFuture<DeleteSubnetResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a subnet CIDR reservation.
     * </p>
     *
     * @param deleteSubnetCidrReservationRequest
     * @return A Java Future containing the result of the DeleteSubnetCidrReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteSubnetCidrReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSubnetCidrReservation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSubnetCidrReservationResponse> deleteSubnetCidrReservation(
            DeleteSubnetCidrReservationRequest deleteSubnetCidrReservationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSubnetCidrReservationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSubnetCidrReservationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSubnetCidrReservation");

            HttpResponseHandler<DeleteSubnetCidrReservationResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteSubnetCidrReservationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteSubnetCidrReservationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSubnetCidrReservationRequest, DeleteSubnetCidrReservationResponse>()
                            .withOperationName("DeleteSubnetCidrReservation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteSubnetCidrReservationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteSubnetCidrReservationRequest));
            CompletableFuture<DeleteSubnetCidrReservationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified set of tags from the specified set of resources.
     * </p>
     * <p>
     * To list the current tags, use <a>DescribeTags</a>. For more information about tags, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tag your Amazon EC2 resources</a> in
     * the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param deleteTagsRequest
     * @return A Java Future containing the result of the DeleteTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTagsResponse> deleteTags(DeleteTagsRequest deleteTagsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTags");

            HttpResponseHandler<DeleteTagsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTagsRequest, DeleteTagsResponse>().withOperationName("DeleteTags")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteTagsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteTagsRequest));
            CompletableFuture<DeleteTagsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified Traffic Mirror filter.
     * </p>
     * <p>
     * You cannot delete a Traffic Mirror filter that is in use by a Traffic Mirror session.
     * </p>
     *
     * @param deleteTrafficMirrorFilterRequest
     * @return A Java Future containing the result of the DeleteTrafficMirrorFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTrafficMirrorFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorFilter" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTrafficMirrorFilterResponse> deleteTrafficMirrorFilter(
            DeleteTrafficMirrorFilterRequest deleteTrafficMirrorFilterRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTrafficMirrorFilterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTrafficMirrorFilterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTrafficMirrorFilter");

            HttpResponseHandler<DeleteTrafficMirrorFilterResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteTrafficMirrorFilterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteTrafficMirrorFilterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTrafficMirrorFilterRequest, DeleteTrafficMirrorFilterResponse>()
                            .withOperationName("DeleteTrafficMirrorFilter").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteTrafficMirrorFilterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteTrafficMirrorFilterRequest));
            CompletableFuture<DeleteTrafficMirrorFilterResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified Traffic Mirror rule.
     * </p>
     *
     * @param deleteTrafficMirrorFilterRuleRequest
     * @return A Java Future containing the result of the DeleteTrafficMirrorFilterRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTrafficMirrorFilterRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorFilterRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTrafficMirrorFilterRuleResponse> deleteTrafficMirrorFilterRule(
            DeleteTrafficMirrorFilterRuleRequest deleteTrafficMirrorFilterRuleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTrafficMirrorFilterRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteTrafficMirrorFilterRuleRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTrafficMirrorFilterRule");

            HttpResponseHandler<DeleteTrafficMirrorFilterRuleResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteTrafficMirrorFilterRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteTrafficMirrorFilterRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTrafficMirrorFilterRuleRequest, DeleteTrafficMirrorFilterRuleResponse>()
                            .withOperationName("DeleteTrafficMirrorFilterRule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteTrafficMirrorFilterRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteTrafficMirrorFilterRuleRequest));
            CompletableFuture<DeleteTrafficMirrorFilterRuleResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified Traffic Mirror session.
     * </p>
     *
     * @param deleteTrafficMirrorSessionRequest
     * @return A Java Future containing the result of the DeleteTrafficMirrorSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTrafficMirrorSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorSession"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTrafficMirrorSessionResponse> deleteTrafficMirrorSession(
            DeleteTrafficMirrorSessionRequest deleteTrafficMirrorSessionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTrafficMirrorSessionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTrafficMirrorSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTrafficMirrorSession");

            HttpResponseHandler<DeleteTrafficMirrorSessionResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteTrafficMirrorSessionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteTrafficMirrorSessionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTrafficMirrorSessionRequest, DeleteTrafficMirrorSessionResponse>()
                            .withOperationName("DeleteTrafficMirrorSession").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteTrafficMirrorSessionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteTrafficMirrorSessionRequest));
            CompletableFuture<DeleteTrafficMirrorSessionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified Traffic Mirror target.
     * </p>
     * <p>
     * You cannot delete a Traffic Mirror target that is in use by a Traffic Mirror session.
     * </p>
     *
     * @param deleteTrafficMirrorTargetRequest
     * @return A Java Future containing the result of the DeleteTrafficMirrorTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTrafficMirrorTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorTarget" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTrafficMirrorTargetResponse> deleteTrafficMirrorTarget(
            DeleteTrafficMirrorTargetRequest deleteTrafficMirrorTargetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTrafficMirrorTargetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTrafficMirrorTargetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTrafficMirrorTarget");

            HttpResponseHandler<DeleteTrafficMirrorTargetResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteTrafficMirrorTargetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteTrafficMirrorTargetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTrafficMirrorTargetRequest, DeleteTrafficMirrorTargetResponse>()
                            .withOperationName("DeleteTrafficMirrorTarget").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteTrafficMirrorTargetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteTrafficMirrorTargetRequest));
            CompletableFuture<DeleteTrafficMirrorTargetResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified transit gateway.
     * </p>
     *
     * @param deleteTransitGatewayRequest
     * @return A Java Future containing the result of the DeleteTransitGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTransitGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTransitGatewayResponse> deleteTransitGateway(
            DeleteTransitGatewayRequest deleteTransitGatewayRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTransitGatewayRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTransitGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTransitGateway");

            HttpResponseHandler<DeleteTransitGatewayResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteTransitGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteTransitGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTransitGatewayRequest, DeleteTransitGatewayResponse>()
                            .withOperationName("DeleteTransitGateway").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteTransitGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteTransitGatewayRequest));
            CompletableFuture<DeleteTransitGatewayResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified Connect attachment. You must first delete any Connect peers for the attachment.
     * </p>
     *
     * @param deleteTransitGatewayConnectRequest
     * @return A Java Future containing the result of the DeleteTransitGatewayConnect operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTransitGatewayConnect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayConnect"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTransitGatewayConnectResponse> deleteTransitGatewayConnect(
            DeleteTransitGatewayConnectRequest deleteTransitGatewayConnectRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTransitGatewayConnectRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTransitGatewayConnectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTransitGatewayConnect");

            HttpResponseHandler<DeleteTransitGatewayConnectResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteTransitGatewayConnectResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteTransitGatewayConnectResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTransitGatewayConnectRequest, DeleteTransitGatewayConnectResponse>()
                            .withOperationName("DeleteTransitGatewayConnect").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteTransitGatewayConnectRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteTransitGatewayConnectRequest));
            CompletableFuture<DeleteTransitGatewayConnectResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified Connect peer.
     * </p>
     *
     * @param deleteTransitGatewayConnectPeerRequest
     * @return A Java Future containing the result of the DeleteTransitGatewayConnectPeer operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTransitGatewayConnectPeer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayConnectPeer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTransitGatewayConnectPeerResponse> deleteTransitGatewayConnectPeer(
            DeleteTransitGatewayConnectPeerRequest deleteTransitGatewayConnectPeerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTransitGatewayConnectPeerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteTransitGatewayConnectPeerRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTransitGatewayConnectPeer");

            HttpResponseHandler<DeleteTransitGatewayConnectPeerResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteTransitGatewayConnectPeerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteTransitGatewayConnectPeerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTransitGatewayConnectPeerRequest, DeleteTransitGatewayConnectPeerResponse>()
                            .withOperationName("DeleteTransitGatewayConnectPeer").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteTransitGatewayConnectPeerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteTransitGatewayConnectPeerRequest));
            CompletableFuture<DeleteTransitGatewayConnectPeerResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified transit gateway multicast domain.
     * </p>
     *
     * @param deleteTransitGatewayMulticastDomainRequest
     * @return A Java Future containing the result of the DeleteTransitGatewayMulticastDomain operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTransitGatewayMulticastDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayMulticastDomain"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTransitGatewayMulticastDomainResponse> deleteTransitGatewayMulticastDomain(
            DeleteTransitGatewayMulticastDomainRequest deleteTransitGatewayMulticastDomainRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTransitGatewayMulticastDomainRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteTransitGatewayMulticastDomainRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTransitGatewayMulticastDomain");

            HttpResponseHandler<DeleteTransitGatewayMulticastDomainResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteTransitGatewayMulticastDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteTransitGatewayMulticastDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTransitGatewayMulticastDomainRequest, DeleteTransitGatewayMulticastDomainResponse>()
                            .withOperationName("DeleteTransitGatewayMulticastDomain").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteTransitGatewayMulticastDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteTransitGatewayMulticastDomainRequest));
            CompletableFuture<DeleteTransitGatewayMulticastDomainResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a transit gateway peering attachment.
     * </p>
     *
     * @param deleteTransitGatewayPeeringAttachmentRequest
     * @return A Java Future containing the result of the DeleteTransitGatewayPeeringAttachment operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTransitGatewayPeeringAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPeeringAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTransitGatewayPeeringAttachmentResponse> deleteTransitGatewayPeeringAttachment(
            DeleteTransitGatewayPeeringAttachmentRequest deleteTransitGatewayPeeringAttachmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTransitGatewayPeeringAttachmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteTransitGatewayPeeringAttachmentRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTransitGatewayPeeringAttachment");

            HttpResponseHandler<DeleteTransitGatewayPeeringAttachmentResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteTransitGatewayPeeringAttachmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteTransitGatewayPeeringAttachmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTransitGatewayPeeringAttachmentRequest, DeleteTransitGatewayPeeringAttachmentResponse>()
                            .withOperationName("DeleteTransitGatewayPeeringAttachment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteTransitGatewayPeeringAttachmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteTransitGatewayPeeringAttachmentRequest));
            CompletableFuture<DeleteTransitGatewayPeeringAttachmentResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified transit gateway policy table.
     * </p>
     *
     * @param deleteTransitGatewayPolicyTableRequest
     * @return A Java Future containing the result of the DeleteTransitGatewayPolicyTable operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTransitGatewayPolicyTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPolicyTable"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTransitGatewayPolicyTableResponse> deleteTransitGatewayPolicyTable(
            DeleteTransitGatewayPolicyTableRequest deleteTransitGatewayPolicyTableRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTransitGatewayPolicyTableRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteTransitGatewayPolicyTableRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTransitGatewayPolicyTable");

            HttpResponseHandler<DeleteTransitGatewayPolicyTableResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteTransitGatewayPolicyTableResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteTransitGatewayPolicyTableResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTransitGatewayPolicyTableRequest, DeleteTransitGatewayPolicyTableResponse>()
                            .withOperationName("DeleteTransitGatewayPolicyTable").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteTransitGatewayPolicyTableRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteTransitGatewayPolicyTableRequest));
            CompletableFuture<DeleteTransitGatewayPolicyTableResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a reference (route) to a prefix list in a specified transit gateway route table.
     * </p>
     *
     * @param deleteTransitGatewayPrefixListReferenceRequest
     * @return A Java Future containing the result of the DeleteTransitGatewayPrefixListReference operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTransitGatewayPrefixListReference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPrefixListReference"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTransitGatewayPrefixListReferenceResponse> deleteTransitGatewayPrefixListReference(
            DeleteTransitGatewayPrefixListReferenceRequest deleteTransitGatewayPrefixListReferenceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTransitGatewayPrefixListReferenceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteTransitGatewayPrefixListReferenceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTransitGatewayPrefixListReference");

            HttpResponseHandler<DeleteTransitGatewayPrefixListReferenceResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteTransitGatewayPrefixListReferenceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteTransitGatewayPrefixListReferenceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTransitGatewayPrefixListReferenceRequest, DeleteTransitGatewayPrefixListReferenceResponse>()
                            .withOperationName("DeleteTransitGatewayPrefixListReference").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteTransitGatewayPrefixListReferenceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteTransitGatewayPrefixListReferenceRequest));
            CompletableFuture<DeleteTransitGatewayPrefixListReferenceResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified route from the specified transit gateway route table.
     * </p>
     *
     * @param deleteTransitGatewayRouteRequest
     * @return A Java Future containing the result of the DeleteTransitGatewayRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTransitGatewayRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTransitGatewayRouteResponse> deleteTransitGatewayRoute(
            DeleteTransitGatewayRouteRequest deleteTransitGatewayRouteRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTransitGatewayRouteRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTransitGatewayRouteRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTransitGatewayRoute");

            HttpResponseHandler<DeleteTransitGatewayRouteResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteTransitGatewayRouteResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteTransitGatewayRouteResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTransitGatewayRouteRequest, DeleteTransitGatewayRouteResponse>()
                            .withOperationName("DeleteTransitGatewayRoute").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new 