/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a transit gateway Connect attachment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransitGatewayConnect implements SdkPojo, Serializable,
        ToCopyableBuilder<TransitGatewayConnect.Builder, TransitGatewayConnect> {
    private static final SdkField<String> TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayAttachmentId")
            .getter(getter(TransitGatewayConnect::transitGatewayAttachmentId))
            .setter(setter(Builder::transitGatewayAttachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAttachmentId")
                    .unmarshallLocationName("transitGatewayAttachmentId").build()).build();

    private static final SdkField<String> TRANSPORT_TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransportTransitGatewayAttachmentId")
            .getter(getter(TransitGatewayConnect::transportTransitGatewayAttachmentId))
            .setter(setter(Builder::transportTransitGatewayAttachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("TransportTransitGatewayAttachmentId")
                    .unmarshallLocationName("transportTransitGatewayAttachmentId").build()).build();

    private static final SdkField<String> TRANSIT_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayId")
            .getter(getter(TransitGatewayConnect::transitGatewayId))
            .setter(setter(Builder::transitGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayId")
                    .unmarshallLocationName("transitGatewayId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(TransitGatewayConnect::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime")
            .getter(getter(TransitGatewayConnect::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime")
                    .unmarshallLocationName("creationTime").build()).build();

    private static final SdkField<TransitGatewayConnectOptions> OPTIONS_FIELD = SdkField
            .<TransitGatewayConnectOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Options")
            .getter(getter(TransitGatewayConnect::options))
            .setter(setter(Builder::options))
            .constructor(TransitGatewayConnectOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options")
                    .unmarshallLocationName("options").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(TransitGatewayConnect::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD, TRANSPORT_TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD, TRANSIT_GATEWAY_ID_FIELD,
            STATE_FIELD, CREATION_TIME_FIELD, OPTIONS_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String transitGatewayAttachmentId;

    private final String transportTransitGatewayAttachmentId;

    private final String transitGatewayId;

    private final String state;

    private final Instant creationTime;

    private final TransitGatewayConnectOptions options;

    private final List<Tag> tags;

    private TransitGatewayConnect(BuilderImpl builder) {
        this.transitGatewayAttachmentId = builder.transitGatewayAttachmentId;
        this.transportTransitGatewayAttachmentId = builder.transportTransitGatewayAttachmentId;
        this.transitGatewayId = builder.transitGatewayId;
        this.state = builder.state;
        this.creationTime = builder.creationTime;
        this.options = builder.options;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the Connect attachment.
     * </p>
     * 
     * @return The ID of the Connect attachment.
     */
    public final String transitGatewayAttachmentId() {
        return transitGatewayAttachmentId;
    }

    /**
     * <p>
     * The ID of the attachment from which the Connect attachment was created.
     * </p>
     * 
     * @return The ID of the attachment from which the Connect attachment was created.
     */
    public final String transportTransitGatewayAttachmentId() {
        return transportTransitGatewayAttachmentId;
    }

    /**
     * <p>
     * The ID of the transit gateway.
     * </p>
     * 
     * @return The ID of the transit gateway.
     */
    public final String transitGatewayId() {
        return transitGatewayId;
    }

    /**
     * <p>
     * The state of the attachment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link TransitGatewayAttachmentState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the attachment.
     * @see TransitGatewayAttachmentState
     */
    public final TransitGatewayAttachmentState state() {
        return TransitGatewayAttachmentState.fromValue(state);
    }

    /**
     * <p>
     * The state of the attachment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link TransitGatewayAttachmentState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the attachment.
     * @see TransitGatewayAttachmentState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The creation time.
     * </p>
     * 
     * @return The creation time.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The Connect attachment options.
     * </p>
     * 
     * @return The Connect attachment options.
     */
    public final TransitGatewayConnectOptions options() {
        return options;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags for the attachment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags for the attachment.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(transportTransitGatewayAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(options());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayConnect)) {
            return false;
        }
        TransitGatewayConnect other = (TransitGatewayConnect) obj;
        return Objects.equals(transitGatewayAttachmentId(), other.transitGatewayAttachmentId())
                && Objects.equals(transportTransitGatewayAttachmentId(), other.transportTransitGatewayAttachmentId())
                && Objects.equals(transitGatewayId(), other.transitGatewayId())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(options(), other.options()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransitGatewayConnect").add("TransitGatewayAttachmentId", transitGatewayAttachmentId())
                .add("TransportTransitGatewayAttachmentId", transportTransitGatewayAttachmentId())
                .add("TransitGatewayId", transitGatewayId()).add("State", stateAsString()).add("CreationTime", creationTime())
                .add("Options", options()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayAttachmentId":
            return Optional.ofNullable(clazz.cast(transitGatewayAttachmentId()));
        case "TransportTransitGatewayAttachmentId":
            return Optional.ofNullable(clazz.cast(transportTransitGatewayAttachmentId()));
        case "TransitGatewayId":
            return Optional.ofNullable(clazz.cast(transitGatewayId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "Options":
            return Optional.ofNullable(clazz.cast(options()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayConnect, T> g) {
        return obj -> g.apply((TransitGatewayConnect) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransitGatewayConnect> {
        /**
         * <p>
         * The ID of the Connect attachment.
         * </p>
         * 
         * @param transitGatewayAttachmentId
         *        The ID of the Connect attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayAttachmentId(String transitGatewayAttachmentId);

        /**
         * <p>
         * The ID of the attachment from which the Connect attachment was created.
         * </p>
         * 
         * @param transportTransitGatewayAttachmentId
         *        The ID of the attachment from which the Connect attachment was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transportTransitGatewayAttachmentId(String transportTransitGatewayAttachmentId);

        /**
         * <p>
         * The ID of the transit gateway.
         * </p>
         * 
         * @param transitGatewayId
         *        The ID of the transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayId(String transitGatewayId);

        /**
         * <p>
         * The state of the attachment.
         * </p>
         * 
         * @param state
         *        The state of the attachment.
         * @see TransitGatewayAttachmentState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayAttachmentState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the attachment.
         * </p>
         * 
         * @param state
         *        The state of the attachment.
         * @see TransitGatewayAttachmentState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayAttachmentState
         */
        Builder state(TransitGatewayAttachmentState state);

        /**
         * <p>
         * The creation time.
         * </p>
         * 
         * @param creationTime
         *        The creation time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The Connect attachment options.
         * </p>
         * 
         * @param options
         *        The Connect attachment options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(TransitGatewayConnectOptions options);

        /**
         * <p>
         * The Connect attachment options.
         * </p>
         * This is a convenience method that creates an instance of the {@link TransitGatewayConnectOptions.Builder}
         * avoiding the need to create one manually via {@link TransitGatewayConnectOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TransitGatewayConnectOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #options(TransitGatewayConnectOptions)}.
         * 
         * @param options
         *        a consumer that will call methods on {@link TransitGatewayConnectOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #options(TransitGatewayConnectOptions)
         */
        default Builder options(Consumer<TransitGatewayConnectOptions.Builder> options) {
            return options(TransitGatewayConnectOptions.builder().applyMutation(options).build());
        }

        /**
         * <p>
         * The tags for the attachment.
         * </p>
         * 
         * @param tags
         *        The tags for the attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags for the attachment.
         * </p>
         * 
         * @param tags
         *        The tags for the attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags for the attachment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String transitGatewayAttachmentId;

        private String transportTransitGatewayAttachmentId;

        private String transitGatewayId;

        private String state;

        private Instant creationTime;

        private TransitGatewayConnectOptions options;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayConnect model) {
            transitGatewayAttachmentId(model.transitGatewayAttachmentId);
            transportTransitGatewayAttachmentId(model.transportTransitGatewayAttachmentId);
            transitGatewayId(model.transitGatewayId);
            state(model.state);
            creationTime(model.creationTime);
            options(model.options);
            tags(model.tags);
        }

        public final String getTransitGatewayAttachmentId() {
            return transitGatewayAttachmentId;
        }

        public final void setTransitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
        }

        @Override
        public final Builder transitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
            return this;
        }

        public final String getTransportTransitGatewayAttachmentId() {
            return transportTransitGatewayAttachmentId;
        }

        public final void setTransportTransitGatewayAttachmentId(String transportTransitGatewayAttachmentId) {
            this.transportTransitGatewayAttachmentId = transportTransitGatewayAttachmentId;
        }

        @Override
        public final Builder transportTransitGatewayAttachmentId(String transportTransitGatewayAttachmentId) {
            this.transportTransitGatewayAttachmentId = transportTransitGatewayAttachmentId;
            return this;
        }

        public final String getTransitGatewayId() {
            return transitGatewayId;
        }

        public final void setTransitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
        }

        @Override
        public final Builder transitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(TransitGatewayAttachmentState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final TransitGatewayConnectOptions.Builder getOptions() {
            return options != null ? options.toBuilder() : null;
        }

        public final void setOptions(TransitGatewayConnectOptions.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        public final Builder options(TransitGatewayConnectOptions options) {
            this.options = options;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public TransitGatewayConnect build() {
            return new TransitGatewayConnect(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
