/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a transit gateway policy table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransitGatewayPolicyTable implements SdkPojo, Serializable,
        ToCopyableBuilder<TransitGatewayPolicyTable.Builder, TransitGatewayPolicyTable> {
    private static final SdkField<String> TRANSIT_GATEWAY_POLICY_TABLE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayPolicyTableId")
            .getter(getter(TransitGatewayPolicyTable::transitGatewayPolicyTableId))
            .setter(setter(Builder::transitGatewayPolicyTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayPolicyTableId")
                    .unmarshallLocationName("transitGatewayPolicyTableId").build()).build();

    private static final SdkField<String> TRANSIT_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayId")
            .getter(getter(TransitGatewayPolicyTable::transitGatewayId))
            .setter(setter(Builder::transitGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayId")
                    .unmarshallLocationName("transitGatewayId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(TransitGatewayPolicyTable::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime")
            .getter(getter(TransitGatewayPolicyTable::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime")
                    .unmarshallLocationName("creationTime").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(TransitGatewayPolicyTable::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRANSIT_GATEWAY_POLICY_TABLE_ID_FIELD, TRANSIT_GATEWAY_ID_FIELD, STATE_FIELD, CREATION_TIME_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String transitGatewayPolicyTableId;

    private final String transitGatewayId;

    private final String state;

    private final Instant creationTime;

    private final List<Tag> tags;

    private TransitGatewayPolicyTable(BuilderImpl builder) {
        this.transitGatewayPolicyTableId = builder.transitGatewayPolicyTableId;
        this.transitGatewayId = builder.transitGatewayId;
        this.state = builder.state;
        this.creationTime = builder.creationTime;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the transit gateway policy table.
     * </p>
     * 
     * @return The ID of the transit gateway policy table.
     */
    public final String transitGatewayPolicyTableId() {
        return transitGatewayPolicyTableId;
    }

    /**
     * <p>
     * The ID of the transit gateway.
     * </p>
     * 
     * @return The ID of the transit gateway.
     */
    public final String transitGatewayId() {
        return transitGatewayId;
    }

    /**
     * <p>
     * The state of the transit gateway policy table
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link TransitGatewayPolicyTableState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the transit gateway policy table
     * @see TransitGatewayPolicyTableState
     */
    public final TransitGatewayPolicyTableState state() {
        return TransitGatewayPolicyTableState.fromValue(state);
    }

    /**
     * <p>
     * The state of the transit gateway policy table
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link TransitGatewayPolicyTableState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the transit gateway policy table
     * @see TransitGatewayPolicyTableState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The timestamp when the transit gateway policy table was created.
     * </p>
     * 
     * @return The timestamp when the transit gateway policy table was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * he key-value pairs associated with the transit gateway policy table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return he key-value pairs associated with the transit gateway policy table.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayPolicyTableId());
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayPolicyTable)) {
            return false;
        }
        TransitGatewayPolicyTable other = (TransitGatewayPolicyTable) obj;
        return Objects.equals(transitGatewayPolicyTableId(), other.transitGatewayPolicyTableId())
                && Objects.equals(transitGatewayId(), other.transitGatewayId())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(creationTime(), other.creationTime())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransitGatewayPolicyTable").add("TransitGatewayPolicyTableId", transitGatewayPolicyTableId())
                .add("TransitGatewayId", transitGatewayId()).add("State", stateAsString()).add("CreationTime", creationTime())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayPolicyTableId":
            return Optional.ofNullable(clazz.cast(transitGatewayPolicyTableId()));
        case "TransitGatewayId":
            return Optional.ofNullable(clazz.cast(transitGatewayId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayPolicyTable, T> g) {
        return obj -> g.apply((TransitGatewayPolicyTable) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransitGatewayPolicyTable> {
        /**
         * <p>
         * The ID of the transit gateway policy table.
         * </p>
         * 
         * @param transitGatewayPolicyTableId
         *        The ID of the transit gateway policy table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayPolicyTableId(String transitGatewayPolicyTableId);

        /**
         * <p>
         * The ID of the transit gateway.
         * </p>
         * 
         * @param transitGatewayId
         *        The ID of the transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayId(String transitGatewayId);

        /**
         * <p>
         * The state of the transit gateway policy table
         * </p>
         * 
         * @param state
         *        The state of the transit gateway policy table
         * @see TransitGatewayPolicyTableState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayPolicyTableState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the transit gateway policy table
         * </p>
         * 
         * @param state
         *        The state of the transit gateway policy table
         * @see TransitGatewayPolicyTableState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayPolicyTableState
         */
        Builder state(TransitGatewayPolicyTableState state);

        /**
         * <p>
         * The timestamp when the transit gateway policy table was created.
         * </p>
         * 
         * @param creationTime
         *        The timestamp when the transit gateway policy table was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * he key-value pairs associated with the transit gateway policy table.
         * </p>
         * 
         * @param tags
         *        he key-value pairs associated with the transit gateway policy table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * he key-value pairs associated with the transit gateway policy table.
         * </p>
         * 
         * @param tags
         *        he key-value pairs associated with the transit gateway policy table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * he key-value pairs associated with the transit gateway policy table.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String transitGatewayPolicyTableId;

        private String transitGatewayId;

        private String state;

        private Instant creationTime;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayPolicyTable model) {
            transitGatewayPolicyTableId(model.transitGatewayPolicyTableId);
            transitGatewayId(model.transitGatewayId);
            state(model.state);
            creationTime(model.creationTime);
            tags(model.tags);
        }

        public final String getTransitGatewayPolicyTableId() {
            return transitGatewayPolicyTableId;
        }

        public final void setTransitGatewayPolicyTableId(String transitGatewayPolicyTableId) {
            this.transitGatewayPolicyTableId = transitGatewayPolicyTableId;
        }

        @Override
        public final Builder transitGatewayPolicyTableId(String transitGatewayPolicyTableId) {
            this.transitGatewayPolicyTableId = transitGatewayPolicyTableId;
            return this;
        }

        public final String getTransitGatewayId() {
            return transitGatewayId;
        }

        public final void setTransitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
        }

        @Override
        public final Builder transitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(TransitGatewayPolicyTableState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public TransitGatewayPolicyTable build() {
            return new TransitGatewayPolicyTable(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
