/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters for a network interface.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LaunchTemplateInstanceNetworkInterfaceSpecificationRequest
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest.Builder, LaunchTemplateInstanceNetworkInterfaceSpecificationRequest> {
    private static final SdkField<Boolean> ASSOCIATE_CARRIER_IP_ADDRESS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AssociateCarrierIpAddress")
            .getter(getter(LaunchTemplateInstanceNetworkInterfaceSpecificationRequest::associateCarrierIpAddress))
            .setter(setter(Builder::associateCarrierIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociateCarrierIpAddress")
                    .unmarshallLocationName("AssociateCarrierIpAddress").build()).build();

    private static final SdkField<Boolean> ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AssociatePublicIpAddress")
            .getter(getter(LaunchTemplateInstanceNetworkInterfaceSpecificationRequest::associatePublicIpAddress))
            .setter(setter(Builder::associatePublicIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatePublicIpAddress")
                    .unmarshallLocationName("AssociatePublicIpAddress").build()).build();

    private static final SdkField<Boolean> DELETE_ON_TERMINATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeleteOnTermination")
            .getter(getter(LaunchTemplateInstanceNetworkInterfaceSpecificationRequest::deleteOnTermination))
            .setter(setter(Builder::deleteOnTermination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteOnTermination")
                    .unmarshallLocationName("DeleteOnTermination").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(LaunchTemplateInstanceNetworkInterfaceSpecificationRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<Integer> DEVICE_INDEX_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("DeviceIndex")
            .getter(getter(LaunchTemplateInstanceNetworkInterfaceSpecificationRequest::deviceIndex))
            .setter(setter(Builder::deviceIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceIndex")
                    .unmarshallLocationName("DeviceIndex").build()).build();

    private static final SdkField<List<String>> GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Groups")
            .getter(getter(LaunchTemplateInstanceNetworkInterfaceSpecificationRequest::groups))
            .setter(setter(Builder::groups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId")
                    .unmarshallLocationName("SecurityGroupId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SecurityGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SecurityGroupId").unmarshallLocationName("SecurityGroupId")
                                                    .build()).build()).build()).build();

    private static final SdkField<String> INTERFACE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InterfaceType")
            .getter(getter(LaunchTemplateInstanceNetworkInterfaceSpecificationRequest::interfaceType))
            .setter(setter(Builder::interfaceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InterfaceType")
                    .unmarshallLocationName("InterfaceType").build()).build();

    private static final SdkField<Integer> IPV6_ADDRESS_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Ipv6AddressCount")
            .getter(getter(LaunchTemplateInstanceNetworkInterfaceSpecificationRequest::ipv6AddressCount))
            .setter(setter(Builder::ipv6AddressCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6AddressCount")
                    .unmarshallLocationName("Ipv6AddressCount").build()).build();

    private static final SdkField<List<InstanceIpv6AddressRequest>> IPV6_ADDRESSES_FIELD = SdkField
            .<List<InstanceIpv6AddressRequest>> builder(MarshallingType.LIST)
            .memberName("Ipv6Addresses")
            .getter(getter(LaunchTemplateInstanceNetworkInterfaceSpecificationRequest::ipv6Addresses))
            .setter(setter(Builder::ipv6Addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Addresses")
                    .unmarshallLocationName("Ipv6Addresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("InstanceIpv6Address")
                            .memberFieldInfo(
                                    SdkField.<InstanceIpv6AddressRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceIpv6AddressRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("InstanceIpv6Address")
                                                    .unmarshallLocationName("InstanceIpv6Address").build()).build()).build())
            .build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceId")
            .getter(getter(LaunchTemplateInstanceNetworkInterfaceSpecificationRequest::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId")
                    .unmarshallLocationName("NetworkInterfaceId").build()).build();

    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrivateIpAddress")
            .getter(getter(LaunchTemplateInstanceNetworkInterfaceSpecificationRequest::privateIpAddress))
            .setter(setter(Builder::privateIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress")
                    .unmarshallLocationName("PrivateIpAddress").build()).build();

    private static final SdkField<List<PrivateIpAddressSpecification>> PRIVATE_IP_ADDRESSES_FIELD = SdkField
            .<List<PrivateIpAddressSpecification>> builder(MarshallingType.LIST)
            .memberName("PrivateIpAddresses")
            .getter(getter(LaunchTemplateInstanceNetworkInterfaceSpecificationRequest::privateIpAddresses))
            .setter(setter(Builder::privateIpAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddresses")
                    .unmarshallLocationName("PrivateIpAddresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<PrivateIpAddressSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(PrivateIpAddressSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Integer> SECONDARY_PRIVATE_IP_ADDRESS_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("SecondaryPrivateIpAddressCount")
            .getter(getter(LaunchTemplateInstanceNetworkInterfaceSpecificationRequest::secondaryPrivateIpAddressCount))
            .setter(setter(Builder::secondaryPrivateIpAddressCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryPrivateIpAddressCount")
                    .unmarshallLocationName("SecondaryPrivateIpAddressCount").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SubnetId")
            .getter(getter(LaunchTemplateInstanceNetworkInterfaceSpecificationRequest::subnetId))
            .setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId")
                    .unmarshallLocationName("SubnetId").build()).build();

    private static final SdkField<Integer> NETWORK_CARD_INDEX_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("NetworkCardIndex")
            .getter(getter(LaunchTemplateInstanceNetworkInterfaceSpecificationRequest::networkCardIndex))
            .setter(setter(Builder::networkCardIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkCardIndex")
                    .unmarshallLocationName("NetworkCardIndex").build()).build();

    private static final SdkField<List<Ipv4PrefixSpecificationRequest>> IPV4_PREFIXES_FIELD = SdkField
            .<List<Ipv4PrefixSpecificationRequest>> builder(MarshallingType.LIST)
            .memberName("Ipv4Prefixes")
            .getter(getter(LaunchTemplateInstanceNetworkInterfaceSpecificationRequest::ipv4Prefixes))
            .setter(setter(Builder::ipv4Prefixes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4Prefix")
                    .unmarshallLocationName("Ipv4Prefix").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Ipv4PrefixSpecificationRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(Ipv4PrefixSpecificationRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Integer> IPV4_PREFIX_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Ipv4PrefixCount")
            .getter(getter(LaunchTemplateInstanceNetworkInterfaceSpecificationRequest::ipv4PrefixCount))
            .setter(setter(Builder::ipv4PrefixCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4PrefixCount")
                    .unmarshallLocationName("Ipv4PrefixCount").build()).build();

    private static final SdkField<List<Ipv6PrefixSpecificationRequest>> IPV6_PREFIXES_FIELD = SdkField
            .<List<Ipv6PrefixSpecificationRequest>> builder(MarshallingType.LIST)
            .memberName("Ipv6Prefixes")
            .getter(getter(LaunchTemplateInstanceNetworkInterfaceSpecificationRequest::ipv6Prefixes))
            .setter(setter(Builder::ipv6Prefixes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Prefix")
                    .unmarshallLocationName("Ipv6Prefix").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Ipv6PrefixSpecificationRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(Ipv6PrefixSpecificationRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Integer> IPV6_PREFIX_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Ipv6PrefixCount")
            .getter(getter(LaunchTemplateInstanceNetworkInterfaceSpecificationRequest::ipv6PrefixCount))
            .setter(setter(Builder::ipv6PrefixCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6PrefixCount")
                    .unmarshallLocationName("Ipv6PrefixCount").build()).build();

    private static final SdkField<Boolean> PRIMARY_IPV6_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PrimaryIpv6")
            .getter(getter(LaunchTemplateInstanceNetworkInterfaceSpecificationRequest::primaryIpv6))
            .setter(setter(Builder::primaryIpv6))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryIpv6")
                    .unmarshallLocationName("PrimaryIpv6").build()).build();

    private static final SdkField<EnaSrdSpecificationRequest> ENA_SRD_SPECIFICATION_FIELD = SdkField
            .<EnaSrdSpecificationRequest> builder(MarshallingType.SDK_POJO)
            .memberName("EnaSrdSpecification")
            .getter(getter(LaunchTemplateInstanceNetworkInterfaceSpecificationRequest::enaSrdSpecification))
            .setter(setter(Builder::enaSrdSpecification))
            .constructor(EnaSrdSpecificationRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnaSrdSpecification")
                    .unmarshallLocationName("EnaSrdSpecification").build()).build();

    private static final SdkField<ConnectionTrackingSpecificationRequest> CONNECTION_TRACKING_SPECIFICATION_FIELD = SdkField
            .<ConnectionTrackingSpecificationRequest> builder(MarshallingType.SDK_POJO)
            .memberName("ConnectionTrackingSpecification")
            .getter(getter(LaunchTemplateInstanceNetworkInterfaceSpecificationRequest::connectionTrackingSpecification))
            .setter(setter(Builder::connectionTrackingSpecification))
            .constructor(ConnectionTrackingSpecificationRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionTrackingSpecification")
                    .unmarshallLocationName("ConnectionTrackingSpecification").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ASSOCIATE_CARRIER_IP_ADDRESS_FIELD, ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD, DELETE_ON_TERMINATION_FIELD,
            DESCRIPTION_FIELD, DEVICE_INDEX_FIELD, GROUPS_FIELD, INTERFACE_TYPE_FIELD, IPV6_ADDRESS_COUNT_FIELD,
            IPV6_ADDRESSES_FIELD, NETWORK_INTERFACE_ID_FIELD, PRIVATE_IP_ADDRESS_FIELD, PRIVATE_IP_ADDRESSES_FIELD,
            SECONDARY_PRIVATE_IP_ADDRESS_COUNT_FIELD, SUBNET_ID_FIELD, NETWORK_CARD_INDEX_FIELD, IPV4_PREFIXES_FIELD,
            IPV4_PREFIX_COUNT_FIELD, IPV6_PREFIXES_FIELD, IPV6_PREFIX_COUNT_FIELD, PRIMARY_IPV6_FIELD,
            ENA_SRD_SPECIFICATION_FIELD, CONNECTION_TRACKING_SPECIFICATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean associateCarrierIpAddress;

    private final Boolean associatePublicIpAddress;

    private final Boolean deleteOnTermination;

    private final String description;

    private final Integer deviceIndex;

    private final List<String> groups;

    private final String interfaceType;

    private final Integer ipv6AddressCount;

    private final List<InstanceIpv6AddressRequest> ipv6Addresses;

    private final String networkInterfaceId;

    private final String privateIpAddress;

    private final List<PrivateIpAddressSpecification> privateIpAddresses;

    private final Integer secondaryPrivateIpAddressCount;

    private final String subnetId;

    private final Integer networkCardIndex;

    private final List<Ipv4PrefixSpecificationRequest> ipv4Prefixes;

    private final Integer ipv4PrefixCount;

    private final List<Ipv6PrefixSpecificationRequest> ipv6Prefixes;

    private final Integer ipv6PrefixCount;

    private final Boolean primaryIpv6;

    private final EnaSrdSpecificationRequest enaSrdSpecification;

    private final ConnectionTrackingSpecificationRequest connectionTrackingSpecification;

    private LaunchTemplateInstanceNetworkInterfaceSpecificationRequest(BuilderImpl builder) {
        this.associateCarrierIpAddress = builder.associateCarrierIpAddress;
        this.associatePublicIpAddress = builder.associatePublicIpAddress;
        this.deleteOnTermination = builder.deleteOnTermination;
        this.description = builder.description;
        this.deviceIndex = builder.deviceIndex;
        this.groups = builder.groups;
        this.interfaceType = builder.interfaceType;
        this.ipv6AddressCount = builder.ipv6AddressCount;
        this.ipv6Addresses = builder.ipv6Addresses;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.privateIpAddress = builder.privateIpAddress;
        this.privateIpAddresses = builder.privateIpAddresses;
        this.secondaryPrivateIpAddressCount = builder.secondaryPrivateIpAddressCount;
        this.subnetId = builder.subnetId;
        this.networkCardIndex = builder.networkCardIndex;
        this.ipv4Prefixes = builder.ipv4Prefixes;
        this.ipv4PrefixCount = builder.ipv4PrefixCount;
        this.ipv6Prefixes = builder.ipv6Prefixes;
        this.ipv6PrefixCount = builder.ipv6PrefixCount;
        this.primaryIpv6 = builder.primaryIpv6;
        this.enaSrdSpecification = builder.enaSrdSpecification;
        this.connectionTrackingSpecification = builder.connectionTrackingSpecification;
    }

    /**
     * <p>
     * Associates a Carrier IP address with eth0 for a new network interface.
     * </p>
     * <p>
     * Use this option when you launch an instance in a Wavelength Zone and want to associate a Carrier IP address with
     * the network interface. For more information about Carrier IP addresses, see <a
     * href="https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#provider-owned-ip"
     * >Carrier IP addresses</a> in the <i>Wavelength Developer Guide</i>.
     * </p>
     * 
     * @return Associates a Carrier IP address with eth0 for a new network interface.</p>
     *         <p>
     *         Use this option when you launch an instance in a Wavelength Zone and want to associate a Carrier IP
     *         address with the network interface. For more information about Carrier IP addresses, see <a href=
     *         "https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#provider-owned-ip"
     *         >Carrier IP addresses</a> in the <i>Wavelength Developer Guide</i>.
     */
    public final Boolean associateCarrierIpAddress() {
        return associateCarrierIpAddress;
    }

    /**
     * <p>
     * Associates a public IPv4 address with eth0 for a new network interface.
     * </p>
     * <p>
     * Amazon Web Services charges for all public IPv4 addresses, including public IPv4 addresses associated with
     * running instances and Elastic IP addresses. For more information, see the <i>Public IPv4 Address</i> tab on the
     * <a href="http://aws.amazon.com/vpc/pricing/">Amazon VPC pricing page</a>.
     * </p>
     * 
     * @return Associates a public IPv4 address with eth0 for a new network interface.</p>
     *         <p>
     *         Amazon Web Services charges for all public IPv4 addresses, including public IPv4 addresses associated
     *         with running instances and Elastic IP addresses. For more information, see the <i>Public IPv4 Address</i>
     *         tab on the <a href="http://aws.amazon.com/vpc/pricing/">Amazon VPC pricing page</a>.
     */
    public final Boolean associatePublicIpAddress() {
        return associatePublicIpAddress;
    }

    /**
     * <p>
     * Indicates whether the network interface is deleted when the instance is terminated.
     * </p>
     * 
     * @return Indicates whether the network interface is deleted when the instance is terminated.
     */
    public final Boolean deleteOnTermination() {
        return deleteOnTermination;
    }

    /**
     * <p>
     * A description for the network interface.
     * </p>
     * 
     * @return A description for the network interface.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The device index for the network interface attachment. Each network interface requires a device index. If you
     * create a launch template that includes secondary network interfaces but not a primary network interface, then you
     * must add a primary network interface as a launch parameter when you launch an instance from the template.
     * </p>
     * 
     * @return The device index for the network interface attachment. Each network interface requires a device index. If
     *         you create a launch template that includes secondary network interfaces but not a primary network
     *         interface, then you must add a primary network interface as a launch parameter when you launch an
     *         instance from the template.
     */
    public final Integer deviceIndex() {
        return deviceIndex;
    }

    /**
     * For responses, this returns true if the service returned a value for the Groups property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroups() {
        return groups != null && !(groups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of one or more security groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroups} method.
     * </p>
     * 
     * @return The IDs of one or more security groups.
     */
    public final List<String> groups() {
        return groups;
    }

    /**
     * <p>
     * The type of network interface. To create an Elastic Fabric Adapter (EFA), specify <code>efa</code>. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/efa.html">Elastic Fabric
     * Adapter</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * If you are not creating an EFA, specify <code>interface</code> or omit this parameter.
     * </p>
     * <p>
     * Valid values: <code>interface</code> | <code>efa</code>
     * </p>
     * 
     * @return The type of network interface. To create an Elastic Fabric Adapter (EFA), specify <code>efa</code>. For
     *         more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/efa.html">Elastic
     *         Fabric Adapter</a> in the <i>Amazon EC2 User Guide</i>.</p>
     *         <p>
     *         If you are not creating an EFA, specify <code>interface</code> or omit this parameter.
     *         </p>
     *         <p>
     *         Valid values: <code>interface</code> | <code>efa</code>
     */
    public final String interfaceType() {
        return interfaceType;
    }

    /**
     * <p>
     * The number of IPv6 addresses to assign to a network interface. Amazon EC2 automatically selects the IPv6
     * addresses from the subnet range. You can't use this option if specifying specific IPv6 addresses.
     * </p>
     * 
     * @return The number of IPv6 addresses to assign to a network interface. Amazon EC2 automatically selects the IPv6
     *         addresses from the subnet range. You can't use this option if specifying specific IPv6 addresses.
     */
    public final Integer ipv6AddressCount() {
        return ipv6AddressCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ipv6Addresses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpv6Addresses() {
        return ipv6Addresses != null && !(ipv6Addresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. You can't use this option if
     * you're specifying a number of IPv6 addresses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpv6Addresses} method.
     * </p>
     * 
     * @return One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. You can't use this
     *         option if you're specifying a number of IPv6 addresses.
     */
    public final List<InstanceIpv6AddressRequest> ipv6Addresses() {
        return ipv6Addresses;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public final String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * The primary private IPv4 address of the network interface.
     * </p>
     * 
     * @return The primary private IPv4 address of the network interface.
     */
    public final String privateIpAddress() {
        return privateIpAddress;
    }

    /**
     * For responses, this returns true if the service returned a value for the PrivateIpAddresses property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPrivateIpAddresses() {
        return privateIpAddresses != null && !(privateIpAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more private IPv4 addresses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrivateIpAddresses} method.
     * </p>
     * 
     * @return One or more private IPv4 addresses.
     */
    public final List<PrivateIpAddressSpecification> privateIpAddresses() {
        return privateIpAddresses;
    }

    /**
     * <p>
     * The number of secondary private IPv4 addresses to assign to a network interface.
     * </p>
     * 
     * @return The number of secondary private IPv4 addresses to assign to a network interface.
     */
    public final Integer secondaryPrivateIpAddressCount() {
        return secondaryPrivateIpAddressCount;
    }

    /**
     * <p>
     * The ID of the subnet for the network interface.
     * </p>
     * 
     * @return The ID of the subnet for the network interface.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The index of the network card. Some instance types support multiple network cards. The primary network interface
     * must be assigned to network card index 0. The default is network card index 0.
     * </p>
     * 
     * @return The index of the network card. Some instance types support multiple network cards. The primary network
     *         interface must be assigned to network card index 0. The default is network card index 0.
     */
    public final Integer networkCardIndex() {
        return networkCardIndex;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ipv4Prefixes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpv4Prefixes() {
        return ipv4Prefixes != null && !(ipv4Prefixes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more IPv4 prefixes to be assigned to the network interface. You cannot use this option if you use the
     * <code>Ipv4PrefixCount</code> option.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpv4Prefixes} method.
     * </p>
     * 
     * @return One or more IPv4 prefixes to be assigned to the network interface. You cannot use this option if you use
     *         the <code>Ipv4PrefixCount</code> option.
     */
    public final List<Ipv4PrefixSpecificationRequest> ipv4Prefixes() {
        return ipv4Prefixes;
    }

    /**
     * <p>
     * The number of IPv4 prefixes to be automatically assigned to the network interface. You cannot use this option if
     * you use the <code>Ipv4Prefix</code> option.
     * </p>
     * 
     * @return The number of IPv4 prefixes to be automatically assigned to the network interface. You cannot use this
     *         option if you use the <code>Ipv4Prefix</code> option.
     */
    public final Integer ipv4PrefixCount() {
        return ipv4PrefixCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ipv6Prefixes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpv6Prefixes() {
        return ipv6Prefixes != null && !(ipv6Prefixes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more IPv6 prefixes to be assigned to the network interface. You cannot use this option if you use the
     * <code>Ipv6PrefixCount</code> option.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpv6Prefixes} method.
     * </p>
     * 
     * @return One or more IPv6 prefixes to be assigned to the network interface. You cannot use this option if you use
     *         the <code>Ipv6PrefixCount</code> option.
     */
    public final List<Ipv6PrefixSpecificationRequest> ipv6Prefixes() {
        return ipv6Prefixes;
    }

    /**
     * <p>
     * The number of IPv6 prefixes to be automatically assigned to the network interface. You cannot use this option if
     * you use the <code>Ipv6Prefix</code> option.
     * </p>
     * 
     * @return The number of IPv6 prefixes to be automatically assigned to the network interface. You cannot use this
     *         option if you use the <code>Ipv6Prefix</code> option.
     */
    public final Integer ipv6PrefixCount() {
        return ipv6PrefixCount;
    }

    /**
     * <p>
     * The primary IPv6 address of the network interface. When you enable an IPv6 GUA address to be a primary IPv6, the
     * first IPv6 GUA will be made the primary IPv6 address until the instance is terminated or the network interface is
     * detached. For more information about primary IPv6 addresses, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a>.
     * </p>
     * 
     * @return The primary IPv6 address of the network interface. When you enable an IPv6 GUA address to be a primary
     *         IPv6, the first IPv6 GUA will be made the primary IPv6 address until the instance is terminated or the
     *         network interface is detached. For more information about primary IPv6 addresses, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a>.
     */
    public final Boolean primaryIpv6() {
        return primaryIpv6;
    }

    /**
     * <p>
     * Configure ENA Express settings for your launch template.
     * </p>
     * 
     * @return Configure ENA Express settings for your launch template.
     */
    public final EnaSrdSpecificationRequest enaSrdSpecification() {
        return enaSrdSpecification;
    }

    /**
     * <p>
     * A security group connection tracking specification that enables you to set the timeout for connection tracking on
     * an Elastic network interface. For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-connection-tracking.html#connection-tracking-timeouts"
     * >Idle connection tracking timeout</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @return A security group connection tracking specification that enables you to set the timeout for connection
     *         tracking on an Elastic network interface. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-connection-tracking.html#connection-tracking-timeouts"
     *         >Idle connection tracking timeout</a> in the <i>Amazon EC2 User Guide</i>.
     */
    public final ConnectionTrackingSpecificationRequest connectionTrackingSpecification() {
        return connectionTrackingSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associateCarrierIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(associatePublicIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(deleteOnTermination());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(deviceIndex());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroups() ? groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(interfaceType());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6AddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpv6Addresses() ? ipv6Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrivateIpAddresses() ? privateIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(secondaryPrivateIpAddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(networkCardIndex());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpv4Prefixes() ? ipv4Prefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ipv4PrefixCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpv6Prefixes() ? ipv6Prefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ipv6PrefixCount());
        hashCode = 31 * hashCode + Objects.hashCode(primaryIpv6());
        hashCode = 31 * hashCode + Objects.hashCode(enaSrdSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(connectionTrackingSpecification());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchTemplateInstanceNetworkInterfaceSpecificationRequest)) {
            return false;
        }
        LaunchTemplateInstanceNetworkInterfaceSpecificationRequest other = (LaunchTemplateInstanceNetworkInterfaceSpecificationRequest) obj;
        return Objects.equals(associateCarrierIpAddress(), other.associateCarrierIpAddress())
                && Objects.equals(associatePublicIpAddress(), other.associatePublicIpAddress())
                && Objects.equals(deleteOnTermination(), other.deleteOnTermination())
                && Objects.equals(description(), other.description()) && Objects.equals(deviceIndex(), other.deviceIndex())
                && hasGroups() == other.hasGroups() && Objects.equals(groups(), other.groups())
                && Objects.equals(interfaceType(), other.interfaceType())
                && Objects.equals(ipv6AddressCount(), other.ipv6AddressCount()) && hasIpv6Addresses() == other.hasIpv6Addresses()
                && Objects.equals(ipv6Addresses(), other.ipv6Addresses())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(privateIpAddress(), other.privateIpAddress())
                && hasPrivateIpAddresses() == other.hasPrivateIpAddresses()
                && Objects.equals(privateIpAddresses(), other.privateIpAddresses())
                && Objects.equals(secondaryPrivateIpAddressCount(), other.secondaryPrivateIpAddressCount())
                && Objects.equals(subnetId(), other.subnetId()) && Objects.equals(networkCardIndex(), other.networkCardIndex())
                && hasIpv4Prefixes() == other.hasIpv4Prefixes() && Objects.equals(ipv4Prefixes(), other.ipv4Prefixes())
                && Objects.equals(ipv4PrefixCount(), other.ipv4PrefixCount()) && hasIpv6Prefixes() == other.hasIpv6Prefixes()
                && Objects.equals(ipv6Prefixes(), other.ipv6Prefixes())
                && Objects.equals(ipv6PrefixCount(), other.ipv6PrefixCount())
                && Objects.equals(primaryIpv6(), other.primaryIpv6())
                && Objects.equals(enaSrdSpecification(), other.enaSrdSpecification())
                && Objects.equals(connectionTrackingSpecification(), other.connectionTrackingSpecification());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LaunchTemplateInstanceNetworkInterfaceSpecificationRequest")
                .add("AssociateCarrierIpAddress", associateCarrierIpAddress())
                .add("AssociatePublicIpAddress", associatePublicIpAddress()).add("DeleteOnTermination", deleteOnTermination())
                .add("Description", description()).add("DeviceIndex", deviceIndex()).add("Groups", hasGroups() ? groups() : null)
                .add("InterfaceType", interfaceType()).add("Ipv6AddressCount", ipv6AddressCount())
                .add("Ipv6Addresses", hasIpv6Addresses() ? ipv6Addresses() : null)
                .add("NetworkInterfaceId", networkInterfaceId()).add("PrivateIpAddress", privateIpAddress())
                .add("PrivateIpAddresses", hasPrivateIpAddresses() ? privateIpAddresses() : null)
                .add("SecondaryPrivateIpAddressCount", secondaryPrivateIpAddressCount()).add("SubnetId", subnetId())
                .add("NetworkCardIndex", networkCardIndex()).add("Ipv4Prefixes", hasIpv4Prefixes() ? ipv4Prefixes() : null)
                .add("Ipv4PrefixCount", ipv4PrefixCount()).add("Ipv6Prefixes", hasIpv6Prefixes() ? ipv6Prefixes() : null)
                .add("Ipv6PrefixCount", ipv6PrefixCount()).add("PrimaryIpv6", primaryIpv6())
                .add("EnaSrdSpecification", enaSrdSpecification())
                .add("ConnectionTrackingSpecification", connectionTrackingSpecification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociateCarrierIpAddress":
            return Optional.ofNullable(clazz.cast(associateCarrierIpAddress()));
        case "AssociatePublicIpAddress":
            return Optional.ofNullable(clazz.cast(associatePublicIpAddress()));
        case "DeleteOnTermination":
            return Optional.ofNullable(clazz.cast(deleteOnTermination()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DeviceIndex":
            return Optional.ofNullable(clazz.cast(deviceIndex()));
        case "Groups":
            return Optional.ofNullable(clazz.cast(groups()));
        case "InterfaceType":
            return Optional.ofNullable(clazz.cast(interfaceType()));
        case "Ipv6AddressCount":
            return Optional.ofNullable(clazz.cast(ipv6AddressCount()));
        case "Ipv6Addresses":
            return Optional.ofNullable(clazz.cast(ipv6Addresses()));
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "PrivateIpAddress":
            return Optional.ofNullable(clazz.cast(privateIpAddress()));
        case "PrivateIpAddresses":
            return Optional.ofNullable(clazz.cast(privateIpAddresses()));
        case "SecondaryPrivateIpAddressCount":
            return Optional.ofNullable(clazz.cast(secondaryPrivateIpAddressCount()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "NetworkCardIndex":
            return Optional.ofNullable(clazz.cast(networkCardIndex()));
        case "Ipv4Prefixes":
            return Optional.ofNullable(clazz.cast(ipv4Prefixes()));
        case "Ipv4PrefixCount":
            return Optional.ofNullable(clazz.cast(ipv4PrefixCount()));
        case "Ipv6Prefixes":
            return Optional.ofNullable(clazz.cast(ipv6Prefixes()));
        case "Ipv6PrefixCount":
            return Optional.ofNullable(clazz.cast(ipv6PrefixCount()));
        case "PrimaryIpv6":
            return Optional.ofNullable(clazz.cast(primaryIpv6()));
        case "EnaSrdSpecification":
            return Optional.ofNullable(clazz.cast(enaSrdSpecification()));
        case "ConnectionTrackingSpecification":
            return Optional.ofNullable(clazz.cast(connectionTrackingSpecification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest, T> g) {
        return obj -> g.apply((LaunchTemplateInstanceNetworkInterfaceSpecificationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo,
            CopyableBuilder<Builder, LaunchTemplateInstanceNetworkInterfaceSpecificationRequest> {
        /**
         * <p>
         * Associates a Carrier IP address with eth0 for a new network interface.
         * </p>
         * <p>
         * Use this option when you launch an instance in a Wavelength Zone and want to associate a Carrier IP address
         * with the network interface. For more information about Carrier IP addresses, see <a href=
         * "https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#provider-owned-ip"
         * >Carrier IP addresses</a> in the <i>Wavelength Developer Guide</i>.
         * </p>
         * 
         * @param associateCarrierIpAddress
         *        Associates a Carrier IP address with eth0 for a new network interface.</p>
         *        <p>
         *        Use this option when you launch an instance in a Wavelength Zone and want to associate a Carrier IP
         *        address with the network interface. For more information about Carrier IP addresses, see <a href=
         *        "https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#provider-owned-ip"
         *        >Carrier IP addresses</a> in the <i>Wavelength Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associateCarrierIpAddress(Boolean associateCarrierIpAddress);

        /**
         * <p>
         * Associates a public IPv4 address with eth0 for a new network interface.
         * </p>
         * <p>
         * Amazon Web Services charges for all public IPv4 addresses, including public IPv4 addresses associated with
         * running instances and Elastic IP addresses. For more information, see the <i>Public IPv4 Address</i> tab on
         * the <a href="http://aws.amazon.com/vpc/pricing/">Amazon VPC pricing page</a>.
         * </p>
         * 
         * @param associatePublicIpAddress
         *        Associates a public IPv4 address with eth0 for a new network interface.</p>
         *        <p>
         *        Amazon Web Services charges for all public IPv4 addresses, including public IPv4 addresses associated
         *        with running instances and Elastic IP addresses. For more information, see the <i>Public IPv4
         *        Address</i> tab on the <a href="http://aws.amazon.com/vpc/pricing/">Amazon VPC pricing page</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatePublicIpAddress(Boolean associatePublicIpAddress);

        /**
         * <p>
         * Indicates whether the network interface is deleted when the instance is terminated.
         * </p>
         * 
         * @param deleteOnTermination
         *        Indicates whether the network interface is deleted when the instance is terminated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteOnTermination(Boolean deleteOnTermination);

        /**
         * <p>
         * A description for the network interface.
         * </p>
         * 
         * @param description
         *        A description for the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The device index for the network interface attachment. Each network interface requires a device index. If you
         * create a launch template that includes secondary network interfaces but not a primary network interface, then
         * you must add a primary network interface as a launch parameter when you launch an instance from the template.
         * </p>
         * 
         * @param deviceIndex
         *        The device index for the network interface attachment. Each network interface requires a device index.
         *        If you create a launch template that includes secondary network interfaces but not a primary network
         *        interface, then you must add a primary network interface as a launch parameter when you launch an
         *        instance from the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceIndex(Integer deviceIndex);

        /**
         * <p>
         * The IDs of one or more security groups.
         * </p>
         * 
         * @param groups
         *        The IDs of one or more security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<String> groups);

        /**
         * <p>
         * The IDs of one or more security groups.
         * </p>
         * 
         * @param groups
         *        The IDs of one or more security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(String... groups);

        /**
         * <p>
         * The type of network interface. To create an Elastic Fabric Adapter (EFA), specify <code>efa</code>. For more
         * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/efa.html">Elastic Fabric
         * Adapter</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * <p>
         * If you are not creating an EFA, specify <code>interface</code> or omit this parameter.
         * </p>
         * <p>
         * Valid values: <code>interface</code> | <code>efa</code>
         * </p>
         * 
         * @param interfaceType
         *        The type of network interface. To create an Elastic Fabric Adapter (EFA), specify <code>efa</code>.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/efa.html">Elastic Fabric Adapter</a> in the
         *        <i>Amazon EC2 User Guide</i>.</p>
         *        <p>
         *        If you are not creating an EFA, specify <code>interface</code> or omit this parameter.
         *        </p>
         *        <p>
         *        Valid values: <code>interface</code> | <code>efa</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interfaceType(String interfaceType);

        /**
         * <p>
         * The number of IPv6 addresses to assign to a network interface. Amazon EC2 automatically selects the IPv6
         * addresses from the subnet range. You can't use this option if specifying specific IPv6 addresses.
         * </p>
         * 
         * @param ipv6AddressCount
         *        The number of IPv6 addresses to assign to a network interface. Amazon EC2 automatically selects the
         *        IPv6 addresses from the subnet range. You can't use this option if specifying specific IPv6 addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6AddressCount(Integer ipv6AddressCount);

        /**
         * <p>
         * One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. You can't use this option
         * if you're specifying a number of IPv6 addresses.
         * </p>
         * 
         * @param ipv6Addresses
         *        One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. You can't use this
         *        option if you're specifying a number of IPv6 addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(Collection<InstanceIpv6AddressRequest> ipv6Addresses);

        /**
         * <p>
         * One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. You can't use this option
         * if you're specifying a number of IPv6 addresses.
         * </p>
         * 
         * @param ipv6Addresses
         *        One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. You can't use this
         *        option if you're specifying a number of IPv6 addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(InstanceIpv6AddressRequest... ipv6Addresses);

        /**
         * <p>
         * One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. You can't use this option
         * if you're specifying a number of IPv6 addresses.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.InstanceIpv6AddressRequest.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.InstanceIpv6AddressRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.InstanceIpv6AddressRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #ipv6Addresses(List<InstanceIpv6AddressRequest>)}.
         * 
         * @param ipv6Addresses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.InstanceIpv6AddressRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipv6Addresses(java.util.Collection<InstanceIpv6AddressRequest>)
         */
        Builder ipv6Addresses(Consumer<InstanceIpv6AddressRequest.Builder>... ipv6Addresses);

        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The primary private IPv4 address of the network interface.
         * </p>
         * 
         * @param privateIpAddress
         *        The primary private IPv4 address of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);

        /**
         * <p>
         * One or more private IPv4 addresses.
         * </p>
         * 
         * @param privateIpAddresses
         *        One or more private IPv4 addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(Collection<PrivateIpAddressSpecification> privateIpAddresses);

        /**
         * <p>
         * One or more private IPv4 addresses.
         * </p>
         * 
         * @param privateIpAddresses
         *        One or more private IPv4 addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(PrivateIpAddressSpecification... privateIpAddresses);

        /**
         * <p>
         * One or more private IPv4 addresses.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.PrivateIpAddressSpecification.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.PrivateIpAddressSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.PrivateIpAddressSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #privateIpAddresses(List<PrivateIpAddressSpecification>)}.
         * 
         * @param privateIpAddresses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.PrivateIpAddressSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #privateIpAddresses(java.util.Collection<PrivateIpAddressSpecification>)
         */
        Builder privateIpAddresses(Consumer<PrivateIpAddressSpecification.Builder>... privateIpAddresses);

        /**
         * <p>
         * The number of secondary private IPv4 addresses to assign to a network interface.
         * </p>
         * 
         * @param secondaryPrivateIpAddressCount
         *        The number of secondary private IPv4 addresses to assign to a network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount);

        /**
         * <p>
         * The ID of the subnet for the network interface.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet for the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The index of the network card. Some instance types support multiple network cards. The primary network
         * interface must be assigned to network card index 0. The default is network card index 0.
         * </p>
         * 
         * @param networkCardIndex
         *        The index of the network card. Some instance types support multiple network cards. The primary network
         *        interface must be assigned to network card index 0. The default is network card index 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkCardIndex(Integer networkCardIndex);

        /**
         * <p>
         * One or more IPv4 prefixes to be assigned to the network interface. You cannot use this option if you use the
         * <code>Ipv4PrefixCount</code> option.
         * </p>
         * 
         * @param ipv4Prefixes
         *        One or more IPv4 prefixes to be assigned to the network interface. You cannot use this option if you
         *        use the <code>Ipv4PrefixCount</code> option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4Prefixes(Collection<Ipv4PrefixSpecificationRequest> ipv4Prefixes);

        /**
         * <p>
         * One or more IPv4 prefixes to be assigned to the network interface. You cannot use this option if you use the
         * <code>Ipv4PrefixCount</code> option.
         * </p>
         * 
         * @param ipv4Prefixes
         *        One or more IPv4 prefixes to be assigned to the network interface. You cannot use this option if you
         *        use the <code>Ipv4PrefixCount</code> option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4Prefixes(Ipv4PrefixSpecificationRequest... ipv4Prefixes);

        /**
         * <p>
         * One or more IPv4 prefixes to be assigned to the network interface. You cannot use this option if you use the
         * <code>Ipv4PrefixCount</code> option.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Ipv4PrefixSpecificationRequest.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Ipv4PrefixSpecificationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.Ipv4PrefixSpecificationRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #ipv4Prefixes(List<Ipv4PrefixSpecificationRequest>)}.
         * 
         * @param ipv4Prefixes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.Ipv4PrefixSpecificationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipv4Prefixes(java.util.Collection<Ipv4PrefixSpecificationRequest>)
         */
        Builder ipv4Prefixes(Consumer<Ipv4PrefixSpecificationRequest.Builder>... ipv4Prefixes);

        /**
         * <p>
         * The number of IPv4 prefixes to be automatically assigned to the network interface. You cannot use this option
         * if you use the <code>Ipv4Prefix</code> option.
         * </p>
         * 
         * @param ipv4PrefixCount
         *        The number of IPv4 prefixes to be automatically assigned to the network interface. You cannot use this
         *        option if you use the <code>Ipv4Prefix</code> option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4PrefixCount(Integer ipv4PrefixCount);

        /**
         * <p>
         * One or more IPv6 prefixes to be assigned to the network interface. You cannot use this option if you use the
         * <code>Ipv6PrefixCount</code> option.
         * </p>
         * 
         * @param ipv6Prefixes
         *        One or more IPv6 prefixes to be assigned to the network interface. You cannot use this option if you
         *        use the <code>Ipv6PrefixCount</code> option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Prefixes(Collection<Ipv6PrefixSpecificationRequest> ipv6Prefixes);

        /**
         * <p>
         * One or more IPv6 prefixes to be assigned to the network interface. You cannot use this option if you use the
         * <code>Ipv6PrefixCount</code> option.
         * </p>
         * 
         * @param ipv6Prefixes
         *        One or more IPv6 prefixes to be assigned to the network interface. You cannot use this option if you
         *        use the <code>Ipv6PrefixCount</code> option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Prefixes(Ipv6PrefixSpecificationRequest... ipv6Prefixes);

        /**
         * <p>
         * One or more IPv6 prefixes to be assigned to the network interface. You cannot use this option if you use the
         * <code>Ipv6PrefixCount</code> option.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Ipv6PrefixSpecificationRequest.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Ipv6PrefixSpecificationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.Ipv6PrefixSpecificationRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #ipv6Prefixes(List<Ipv6PrefixSpecificationRequest>)}.
         * 
         * @param ipv6Prefixes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.Ipv6PrefixSpecificationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipv6Prefixes(java.util.Collection<Ipv6PrefixSpecificationRequest>)
         */
        Builder ipv6Prefixes(Consumer<Ipv6PrefixSpecificationRequest.Builder>... ipv6Prefixes);

        /**
         * <p>
         * The number of IPv6 prefixes to be automatically assigned to the network interface. You cannot use this option
         * if you use the <code>Ipv6Prefix</code> option.
         * </p>
         * 
         * @param ipv6PrefixCount
         *        The number of IPv6 prefixes to be automatically assigned to the network interface. You cannot use this
         *        option if you use the <code>Ipv6Prefix</code> option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6PrefixCount(Integer ipv6PrefixCount);

        /**
         * <p>
         * The primary IPv6 address of the network interface. When you enable an IPv6 GUA address to be a primary IPv6,
         * the first IPv6 GUA will be made the primary IPv6 address until the instance is terminated or the network
         * interface is detached. For more information about primary IPv6 addresses, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a>.
         * </p>
         * 
         * @param primaryIpv6
         *        The primary IPv6 address of the network interface. When you enable an IPv6 GUA address to be a primary
         *        IPv6, the first IPv6 GUA will be made the primary IPv6 address until the instance is terminated or the
         *        network interface is detached. For more information about primary IPv6 addresses, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryIpv6(Boolean primaryIpv6);

        /**
         * <p>
         * Configure ENA Express settings for your launch template.
         * </p>
         * 
         * @param enaSrdSpecification
         *        Configure ENA Express settings for your launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enaSrdSpecification(EnaSrdSpecificationRequest enaSrdSpecification);

        /**
         * <p>
         * Configure ENA Express settings for your launch template.
         * </p>
         * This is a convenience method that creates an instance of the {@link EnaSrdSpecificationRequest.Builder}
         * avoiding the need to create one manually via {@link EnaSrdSpecificationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnaSrdSpecificationRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #enaSrdSpecification(EnaSrdSpecificationRequest)}.
         * 
         * @param enaSrdSpecification
         *        a consumer that will call methods on {@link EnaSrdSpecificationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enaSrdSpecification(EnaSrdSpecificationRequest)
         */
        default Builder enaSrdSpecification(Consumer<EnaSrdSpecificationRequest.Builder> enaSrdSpecification) {
            return enaSrdSpecification(EnaSrdSpecificationRequest.builder().applyMutation(enaSrdSpecification).build());
        }

        /**
         * <p>
         * A security group connection tracking specification that enables you to set the timeout for connection
         * tracking on an Elastic network interface. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-connection-tracking.html#connection-tracking-timeouts"
         * >Idle connection tracking timeout</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param connectionTrackingSpecification
         *        A security group connection tracking specification that enables you to set the timeout for connection
         *        tracking on an Elastic network interface. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-connection-tracking.html#connection-tracking-timeouts"
         *        >Idle connection tracking timeout</a> in the <i>Amazon EC2 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionTrackingSpecification(ConnectionTrackingSpecificationRequest connectionTrackingSpecification);

        /**
         * <p>
         * A security group connection tracking specification that enables you to set the timeout for connection
         * tracking on an Elastic network interface. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-connection-tracking.html#connection-tracking-timeouts"
         * >Idle connection tracking timeout</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ConnectionTrackingSpecificationRequest.Builder} avoiding the need to create one manually via
         * {@link ConnectionTrackingSpecificationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectionTrackingSpecificationRequest.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #connectionTrackingSpecification(ConnectionTrackingSpecificationRequest)}.
         * 
         * @param connectionTrackingSpecification
         *        a consumer that will call methods on {@link ConnectionTrackingSpecificationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectionTrackingSpecification(ConnectionTrackingSpecificationRequest)
         */
        default Builder connectionTrackingSpecification(
                Consumer<ConnectionTrackingSpecificationRequest.Builder> connectionTrackingSpecification) {
            return connectionTrackingSpecification(ConnectionTrackingSpecificationRequest.builder()
                    .applyMutation(connectionTrackingSpecification).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean associateCarrierIpAddress;

        private Boolean associatePublicIpAddress;

        private Boolean deleteOnTermination;

        private String description;

        private Integer deviceIndex;

        private List<String> groups = DefaultSdkAutoConstructList.getInstance();

        private String interfaceType;

        private Integer ipv6AddressCount;

        private List<InstanceIpv6AddressRequest> ipv6Addresses = DefaultSdkAutoConstructList.getInstance();

        private String networkInterfaceId;

        private String privateIpAddress;

        private List<PrivateIpAddressSpecification> privateIpAddresses = DefaultSdkAutoConstructList.getInstance();

        private Integer secondaryPrivateIpAddressCount;

        private String subnetId;

        private Integer networkCardIndex;

        private List<Ipv4PrefixSpecificationRequest> ipv4Prefixes = DefaultSdkAutoConstructList.getInstance();

        private Integer ipv4PrefixCount;

        private List<Ipv6PrefixSpecificationRequest> ipv6Prefixes = DefaultSdkAutoConstructList.getInstance();

        private Integer ipv6PrefixCount;

        private Boolean primaryIpv6;

        private EnaSrdSpecificationRequest enaSrdSpecification;

        private ConnectionTrackingSpecificationRequest connectionTrackingSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchTemplateInstanceNetworkInterfaceSpecificationRequest model) {
            associateCarrierIpAddress(model.associateCarrierIpAddress);
            associatePublicIpAddress(model.associatePublicIpAddress);
            deleteOnTermination(model.deleteOnTermination);
            description(model.description);
            deviceIndex(model.deviceIndex);
            groups(model.groups);
            interfaceType(model.interfaceType);
            ipv6AddressCount(model.ipv6AddressCount);
            ipv6Addresses(model.ipv6Addresses);
            networkInterfaceId(model.networkInterfaceId);
            privateIpAddress(model.privateIpAddress);
            privateIpAddresses(model.privateIpAddresses);
            secondaryPrivateIpAddressCount(model.secondaryPrivateIpAddressCount);
            subnetId(model.subnetId);
            networkCardIndex(model.networkCardIndex);
            ipv4Prefixes(model.ipv4Prefixes);
            ipv4PrefixCount(model.ipv4PrefixCount);
            ipv6Prefixes(model.ipv6Prefixes);
            ipv6PrefixCount(model.ipv6PrefixCount);
            primaryIpv6(model.primaryIpv6);
            enaSrdSpecification(model.enaSrdSpecification);
            connectionTrackingSpecification(model.connectionTrackingSpecification);
        }

        public final Boolean getAssociateCarrierIpAddress() {
            return associateCarrierIpAddress;
        }

        public final void setAssociateCarrierIpAddress(Boolean associateCarrierIpAddress) {
            this.associateCarrierIpAddress = associateCarrierIpAddress;
        }

        @Override
        public final Builder associateCarrierIpAddress(Boolean associateCarrierIpAddress) {
            this.associateCarrierIpAddress = associateCarrierIpAddress;
            return this;
        }

        public final Boolean getAssociatePublicIpAddress() {
            return associatePublicIpAddress;
        }

        public final void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
        }

        @Override
        public final Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public final Boolean getDeleteOnTermination() {
            return deleteOnTermination;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getDeviceIndex() {
            return deviceIndex;
        }

        public final void setDeviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
        }

        @Override
        public final Builder deviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
            return this;
        }

        public final Collection<String> getGroups() {
            if (groups instanceof SdkAutoConstructList) {
                return null;
            }
            return groups;
        }

        public final void setGroups(Collection<String> groups) {
            this.groups = SecurityGroupIdStringListCopier.copy(groups);
        }

        @Override
        public final Builder groups(Collection<String> groups) {
            this.groups = SecurityGroupIdStringListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(String... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        public final String getInterfaceType() {
            return interfaceType;
        }

        public final void setInterfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
        }

        @Override
        public final Builder interfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
            return this;
        }

        public final Integer getIpv6AddressCount() {
            return ipv6AddressCount;
        }

        public final void setIpv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
        }

        @Override
        public final Builder ipv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
            return this;
        }

        public final List<InstanceIpv6AddressRequest.Builder> getIpv6Addresses() {
            List<InstanceIpv6AddressRequest.Builder> result = InstanceIpv6AddressListRequestCopier
                    .copyToBuilder(this.ipv6Addresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv6Addresses(Collection<InstanceIpv6AddressRequest.BuilderImpl> ipv6Addresses) {
            this.ipv6Addresses = InstanceIpv6AddressListRequestCopier.copyFromBuilder(ipv6Addresses);
        }

        @Override
        public final Builder ipv6Addresses(Collection<InstanceIpv6AddressRequest> ipv6Addresses) {
            this.ipv6Addresses = InstanceIpv6AddressListRequestCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(InstanceIpv6AddressRequest... ipv6Addresses) {
            ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(Consumer<InstanceIpv6AddressRequest.Builder>... ipv6Addresses) {
            ipv6Addresses(Stream.of(ipv6Addresses).map(c -> InstanceIpv6AddressRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final List<PrivateIpAddressSpecification.Builder> getPrivateIpAddresses() {
            List<PrivateIpAddressSpecification.Builder> result = PrivateIpAddressSpecificationListCopier
                    .copyToBuilder(this.privateIpAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrivateIpAddresses(Collection<PrivateIpAddressSpecification.BuilderImpl> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressSpecificationListCopier.copyFromBuilder(privateIpAddresses);
        }

        @Override
        public final Builder privateIpAddresses(Collection<PrivateIpAddressSpecification> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressSpecificationListCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(PrivateIpAddressSpecification... privateIpAddresses) {
            privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(Consumer<PrivateIpAddressSpecification.Builder>... privateIpAddresses) {
            privateIpAddresses(Stream.of(privateIpAddresses)
                    .map(c -> PrivateIpAddressSpecification.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getSecondaryPrivateIpAddressCount() {
            return secondaryPrivateIpAddressCount;
        }

        public final void setSecondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
        }

        @Override
        public final Builder secondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final Integer getNetworkCardIndex() {
            return networkCardIndex;
        }

        public final void setNetworkCardIndex(Integer networkCardIndex) {
            this.networkCardIndex = networkCardIndex;
        }

        @Override
        public final Builder networkCardIndex(Integer networkCardIndex) {
            this.networkCardIndex = networkCardIndex;
            return this;
        }

        public final List<Ipv4PrefixSpecificationRequest.Builder> getIpv4Prefixes() {
            List<Ipv4PrefixSpecificationRequest.Builder> result = Ipv4PrefixListCopier.copyToBuilder(this.ipv4Prefixes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv4Prefixes(Collection<Ipv4PrefixSpecificationRequest.BuilderImpl> ipv4Prefixes) {
            this.ipv4Prefixes = Ipv4PrefixListCopier.copyFromBuilder(ipv4Prefixes);
        }

        @Override
        public final Builder ipv4Prefixes(Collection<Ipv4PrefixSpecificationRequest> ipv4Prefixes) {
            this.ipv4Prefixes = Ipv4PrefixListCopier.copy(ipv4Prefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv4Prefixes(Ipv4PrefixSpecificationRequest... ipv4Prefixes) {
            ipv4Prefixes(Arrays.asList(ipv4Prefixes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv4Prefixes(Consumer<Ipv4PrefixSpecificationRequest.Builder>... ipv4Prefixes) {
            ipv4Prefixes(Stream.of(ipv4Prefixes).map(c -> Ipv4PrefixSpecificationRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getIpv4PrefixCount() {
            return ipv4PrefixCount;
        }

        public final void setIpv4PrefixCount(Integer ipv4PrefixCount) {
            this.ipv4PrefixCount = ipv4PrefixCount;
        }

        @Override
        public final Builder ipv4PrefixCount(Integer ipv4PrefixCount) {
            this.ipv4PrefixCount = ipv4PrefixCount;
            return this;
        }

        public final List<Ipv6PrefixSpecificationRequest.Builder> getIpv6Prefixes() {
            List<Ipv6PrefixSpecificationRequest.Builder> result = Ipv6PrefixListCopier.copyToBuilder(this.ipv6Prefixes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv6Prefixes(Collection<Ipv6PrefixSpecificationRequest.BuilderImpl> ipv6Prefixes) {
            this.ipv6Prefixes = Ipv6PrefixListCopier.copyFromBuilder(ipv6Prefixes);
        }

        @Override
        public final Builder ipv6Prefixes(Collection<Ipv6PrefixSpecificationRequest> ipv6Prefixes) {
            this.ipv6Prefixes = Ipv6PrefixListCopier.copy(ipv6Prefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Prefixes(Ipv6PrefixSpecificationRequest... ipv6Prefixes) {
            ipv6Prefixes(Arrays.asList(ipv6Prefixes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Prefixes(Consumer<Ipv6PrefixSpecificationRequest.Builder>... ipv6Prefixes) {
            ipv6Prefixes(Stream.of(ipv6Prefixes).map(c -> Ipv6PrefixSpecificationRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getIpv6PrefixCount() {
            return ipv6PrefixCount;
        }

        public final void setIpv6PrefixCount(Integer ipv6PrefixCount) {
            this.ipv6PrefixCount = ipv6PrefixCount;
        }

        @Override
        public final Builder ipv6PrefixCount(Integer ipv6PrefixCount) {
            this.ipv6PrefixCount = ipv6PrefixCount;
            return this;
        }

        public final Boolean getPrimaryIpv6() {
            return primaryIpv6;
        }

        public final void setPrimaryIpv6(Boolean primaryIpv6) {
            this.primaryIpv6 = primaryIpv6;
        }

        @Override
        public final Builder primaryIpv6(Boolean primaryIpv6) {
            this.primaryIpv6 = primaryIpv6;
            return this;
        }

        public final EnaSrdSpecificationRequest.Builder getEnaSrdSpecification() {
            return enaSrdSpecification != null ? enaSrdSpecification.toBuilder() : null;
        }

        public final void setEnaSrdSpecification(EnaSrdSpecificationRequest.BuilderImpl enaSrdSpecification) {
            this.enaSrdSpecification = enaSrdSpecification != null ? enaSrdSpecification.build() : null;
        }

        @Override
        public final Builder enaSrdSpecification(EnaSrdSpecificationRequest enaSrdSpecification) {
            this.enaSrdSpecification = enaSrdSpecification;
            return this;
        }

        public final ConnectionTrackingSpecificationRequest.Builder getConnectionTrackingSpecification() {
            return connectionTrackingSpecification != null ? connectionTrackingSpecification.toBuilder() : null;
        }

        public final void setConnectionTrackingSpecification(
                ConnectionTrackingSpecificationRequest.BuilderImpl connectionTrackingSpecification) {
            this.connectionTrackingSpecification = connectionTrackingSpecification != null ? connectionTrackingSpecification
                    .build() : null;
        }

        @Override
        public final Builder connectionTrackingSpecification(
                ConnectionTrackingSpecificationRequest connectionTrackingSpecification) {
            this.connectionTrackingSpecification = connectionTrackingSpecification;
            return this;
        }

        @Override
        public LaunchTemplateInstanceNetworkInterfaceSpecificationRequest build() {
            return new LaunchTemplateInstanceNetworkInterfaceSpecificationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
