/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the Traffic Mirror rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrafficMirrorFilterRule implements SdkPojo, Serializable,
        ToCopyableBuilder<TrafficMirrorFilterRule.Builder, TrafficMirrorFilterRule> {
    private static final SdkField<String> TRAFFIC_MIRROR_FILTER_RULE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TrafficMirrorFilterRuleId")
            .getter(getter(TrafficMirrorFilterRule::trafficMirrorFilterRuleId))
            .setter(setter(Builder::trafficMirrorFilterRuleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorFilterRuleId")
                    .unmarshallLocationName("trafficMirrorFilterRuleId").build()).build();

    private static final SdkField<String> TRAFFIC_MIRROR_FILTER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TrafficMirrorFilterId")
            .getter(getter(TrafficMirrorFilterRule::trafficMirrorFilterId))
            .setter(setter(Builder::trafficMirrorFilterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorFilterId")
                    .unmarshallLocationName("trafficMirrorFilterId").build()).build();

    private static final SdkField<String> TRAFFIC_DIRECTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TrafficDirection")
            .getter(getter(TrafficMirrorFilterRule::trafficDirectionAsString))
            .setter(setter(Builder::trafficDirection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficDirection")
                    .unmarshallLocationName("trafficDirection").build()).build();

    private static final SdkField<Integer> RULE_NUMBER_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("RuleNumber")
            .getter(getter(TrafficMirrorFilterRule::ruleNumber))
            .setter(setter(Builder::ruleNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleNumber")
                    .unmarshallLocationName("ruleNumber").build()).build();

    private static final SdkField<String> RULE_ACTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RuleAction")
            .getter(getter(TrafficMirrorFilterRule::ruleActionAsString))
            .setter(setter(Builder::ruleAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleAction")
                    .unmarshallLocationName("ruleAction").build()).build();

    private static final SdkField<Integer> PROTOCOL_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Protocol")
            .getter(getter(TrafficMirrorFilterRule::protocol))
            .setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol")
                    .unmarshallLocationName("protocol").build()).build();

    private static final SdkField<TrafficMirrorPortRange> DESTINATION_PORT_RANGE_FIELD = SdkField
            .<TrafficMirrorPortRange> builder(MarshallingType.SDK_POJO)
            .memberName("DestinationPortRange")
            .getter(getter(TrafficMirrorFilterRule::destinationPortRange))
            .setter(setter(Builder::destinationPortRange))
            .constructor(TrafficMirrorPortRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPortRange")
                    .unmarshallLocationName("destinationPortRange").build()).build();

    private static final SdkField<TrafficMirrorPortRange> SOURCE_PORT_RANGE_FIELD = SdkField
            .<TrafficMirrorPortRange> builder(MarshallingType.SDK_POJO)
            .memberName("SourcePortRange")
            .getter(getter(TrafficMirrorFilterRule::sourcePortRange))
            .setter(setter(Builder::sourcePortRange))
            .constructor(TrafficMirrorPortRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePortRange")
                    .unmarshallLocationName("sourcePortRange").build()).build();

    private static final SdkField<String> DESTINATION_CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DestinationCidrBlock")
            .getter(getter(TrafficMirrorFilterRule::destinationCidrBlock))
            .setter(setter(Builder::destinationCidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidrBlock")
                    .unmarshallLocationName("destinationCidrBlock").build()).build();

    private static final SdkField<String> SOURCE_CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceCidrBlock")
            .getter(getter(TrafficMirrorFilterRule::sourceCidrBlock))
            .setter(setter(Builder::sourceCidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceCidrBlock")
                    .unmarshallLocationName("sourceCidrBlock").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(TrafficMirrorFilterRule::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(TrafficMirrorFilterRule::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRAFFIC_MIRROR_FILTER_RULE_ID_FIELD, TRAFFIC_MIRROR_FILTER_ID_FIELD, TRAFFIC_DIRECTION_FIELD, RULE_NUMBER_FIELD,
            RULE_ACTION_FIELD, PROTOCOL_FIELD, DESTINATION_PORT_RANGE_FIELD, SOURCE_PORT_RANGE_FIELD,
            DESTINATION_CIDR_BLOCK_FIELD, SOURCE_CIDR_BLOCK_FIELD, DESCRIPTION_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String trafficMirrorFilterRuleId;

    private final String trafficMirrorFilterId;

    private final String trafficDirection;

    private final Integer ruleNumber;

    private final String ruleAction;

    private final Integer protocol;

    private final TrafficMirrorPortRange destinationPortRange;

    private final TrafficMirrorPortRange sourcePortRange;

    private final String destinationCidrBlock;

    private final String sourceCidrBlock;

    private final String description;

    private final List<Tag> tags;

    private TrafficMirrorFilterRule(BuilderImpl builder) {
        this.trafficMirrorFilterRuleId = builder.trafficMirrorFilterRuleId;
        this.trafficMirrorFilterId = builder.trafficMirrorFilterId;
        this.trafficDirection = builder.trafficDirection;
        this.ruleNumber = builder.ruleNumber;
        this.ruleAction = builder.ruleAction;
        this.protocol = builder.protocol;
        this.destinationPortRange = builder.destinationPortRange;
        this.sourcePortRange = builder.sourcePortRange;
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.sourceCidrBlock = builder.sourceCidrBlock;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the Traffic Mirror rule.
     * </p>
     * 
     * @return The ID of the Traffic Mirror rule.
     */
    public final String trafficMirrorFilterRuleId() {
        return trafficMirrorFilterRuleId;
    }

    /**
     * <p>
     * The ID of the Traffic Mirror filter that the rule is associated with.
     * </p>
     * 
     * @return The ID of the Traffic Mirror filter that the rule is associated with.
     */
    public final String trafficMirrorFilterId() {
        return trafficMirrorFilterId;
    }

    /**
     * <p>
     * The traffic direction assigned to the Traffic Mirror rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trafficDirection}
     * will return {@link TrafficDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #trafficDirectionAsString}.
     * </p>
     * 
     * @return The traffic direction assigned to the Traffic Mirror rule.
     * @see TrafficDirection
     */
    public final TrafficDirection trafficDirection() {
        return TrafficDirection.fromValue(trafficDirection);
    }

    /**
     * <p>
     * The traffic direction assigned to the Traffic Mirror rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trafficDirection}
     * will return {@link TrafficDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #trafficDirectionAsString}.
     * </p>
     * 
     * @return The traffic direction assigned to the Traffic Mirror rule.
     * @see TrafficDirection
     */
    public final String trafficDirectionAsString() {
        return trafficDirection;
    }

    /**
     * <p>
     * The rule number of the Traffic Mirror rule.
     * </p>
     * 
     * @return The rule number of the Traffic Mirror rule.
     */
    public final Integer ruleNumber() {
        return ruleNumber;
    }

    /**
     * <p>
     * The action assigned to the Traffic Mirror rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleAction} will
     * return {@link TrafficMirrorRuleAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ruleActionAsString}.
     * </p>
     * 
     * @return The action assigned to the Traffic Mirror rule.
     * @see TrafficMirrorRuleAction
     */
    public final TrafficMirrorRuleAction ruleAction() {
        return TrafficMirrorRuleAction.fromValue(ruleAction);
    }

    /**
     * <p>
     * The action assigned to the Traffic Mirror rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleAction} will
     * return {@link TrafficMirrorRuleAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ruleActionAsString}.
     * </p>
     * 
     * @return The action assigned to the Traffic Mirror rule.
     * @see TrafficMirrorRuleAction
     */
    public final String ruleActionAsString() {
        return ruleAction;
    }

    /**
     * <p>
     * The protocol assigned to the Traffic Mirror rule.
     * </p>
     * 
     * @return The protocol assigned to the Traffic Mirror rule.
     */
    public final Integer protocol() {
        return protocol;
    }

    /**
     * <p>
     * The destination port range assigned to the Traffic Mirror rule.
     * </p>
     * 
     * @return The destination port range assigned to the Traffic Mirror rule.
     */
    public final TrafficMirrorPortRange destinationPortRange() {
        return destinationPortRange;
    }

    /**
     * <p>
     * The source port range assigned to the Traffic Mirror rule.
     * </p>
     * 
     * @return The source port range assigned to the Traffic Mirror rule.
     */
    public final TrafficMirrorPortRange sourcePortRange() {
        return sourcePortRange;
    }

    /**
     * <p>
     * The destination CIDR block assigned to the Traffic Mirror rule.
     * </p>
     * 
     * @return The destination CIDR block assigned to the Traffic Mirror rule.
     */
    public final String destinationCidrBlock() {
        return destinationCidrBlock;
    }

    /**
     * <p>
     * The source CIDR block assigned to the Traffic Mirror rule.
     * </p>
     * 
     * @return The source CIDR block assigned to the Traffic Mirror rule.
     */
    public final String sourceCidrBlock() {
        return sourceCidrBlock;
    }

    /**
     * <p>
     * The description of the Traffic Mirror rule.
     * </p>
     * 
     * @return The description of the Traffic Mirror rule.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tags on Traffic Mirroring filter rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags on Traffic Mirroring filter rules.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trafficMirrorFilterRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(trafficMirrorFilterId());
        hashCode = 31 * hashCode + Objects.hashCode(trafficDirectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ruleNumber());
        hashCode = 31 * hashCode + Objects.hashCode(ruleActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(protocol());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPortRange());
        hashCode = 31 * hashCode + Objects.hashCode(sourcePortRange());
        hashCode = 31 * hashCode + Objects.hashCode(destinationCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(sourceCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrafficMirrorFilterRule)) {
            return false;
        }
        TrafficMirrorFilterRule other = (TrafficMirrorFilterRule) obj;
        return Objects.equals(trafficMirrorFilterRuleId(), other.trafficMirrorFilterRuleId())
                && Objects.equals(trafficMirrorFilterId(), other.trafficMirrorFilterId())
                && Objects.equals(trafficDirectionAsString(), other.trafficDirectionAsString())
                && Objects.equals(ruleNumber(), other.ruleNumber())
                && Objects.equals(ruleActionAsString(), other.ruleActionAsString())
                && Objects.equals(protocol(), other.protocol())
                && Objects.equals(destinationPortRange(), other.destinationPortRange())
                && Objects.equals(sourcePortRange(), other.sourcePortRange())
                && Objects.equals(destinationCidrBlock(), other.destinationCidrBlock())
                && Objects.equals(sourceCidrBlock(), other.sourceCidrBlock())
                && Objects.equals(description(), other.description()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrafficMirrorFilterRule").add("TrafficMirrorFilterRuleId", trafficMirrorFilterRuleId())
                .add("TrafficMirrorFilterId", trafficMirrorFilterId()).add("TrafficDirection", trafficDirectionAsString())
                .add("RuleNumber", ruleNumber()).add("RuleAction", ruleActionAsString()).add("Protocol", protocol())
                .add("DestinationPortRange", destinationPortRange()).add("SourcePortRange", sourcePortRange())
                .add("DestinationCidrBlock", destinationCidrBlock()).add("SourceCidrBlock", sourceCidrBlock())
                .add("Description", description()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrafficMirrorFilterRuleId":
            return Optional.ofNullable(clazz.cast(trafficMirrorFilterRuleId()));
        case "TrafficMirrorFilterId":
            return Optional.ofNullable(clazz.cast(trafficMirrorFilterId()));
        case "TrafficDirection":
            return Optional.ofNullable(clazz.cast(trafficDirectionAsString()));
        case "RuleNumber":
            return Optional.ofNullable(clazz.cast(ruleNumber()));
        case "RuleAction":
            return Optional.ofNullable(clazz.cast(ruleActionAsString()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocol()));
        case "DestinationPortRange":
            return Optional.ofNullable(clazz.cast(destinationPortRange()));
        case "SourcePortRange":
            return Optional.ofNullable(clazz.cast(sourcePortRange()));
        case "DestinationCidrBlock":
            return Optional.ofNullable(clazz.cast(destinationCidrBlock()));
        case "SourceCidrBlock":
            return Optional.ofNullable(clazz.cast(sourceCidrBlock()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrafficMirrorFilterRule, T> g) {
        return obj -> g.apply((TrafficMirrorFilterRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrafficMirrorFilterRule> {
        /**
         * <p>
         * The ID of the Traffic Mirror rule.
         * </p>
         * 
         * @param trafficMirrorFilterRuleId
         *        The ID of the Traffic Mirror rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficMirrorFilterRuleId(String trafficMirrorFilterRuleId);

        /**
         * <p>
         * The ID of the Traffic Mirror filter that the rule is associated with.
         * </p>
         * 
         * @param trafficMirrorFilterId
         *        The ID of the Traffic Mirror filter that the rule is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficMirrorFilterId(String trafficMirrorFilterId);

        /**
         * <p>
         * The traffic direction assigned to the Traffic Mirror rule.
         * </p>
         * 
         * @param trafficDirection
         *        The traffic direction assigned to the Traffic Mirror rule.
         * @see TrafficDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrafficDirection
         */
        Builder trafficDirection(String trafficDirection);

        /**
         * <p>
         * The traffic direction assigned to the Traffic Mirror rule.
         * </p>
         * 
         * @param trafficDirection
         *        The traffic direction assigned to the Traffic Mirror rule.
         * @see TrafficDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrafficDirection
         */
        Builder trafficDirection(TrafficDirection trafficDirection);

        /**
         * <p>
         * The rule number of the Traffic Mirror rule.
         * </p>
         * 
         * @param ruleNumber
         *        The rule number of the Traffic Mirror rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleNumber(Integer ruleNumber);

        /**
         * <p>
         * The action assigned to the Traffic Mirror rule.
         * </p>
         * 
         * @param ruleAction
         *        The action assigned to the Traffic Mirror rule.
         * @see TrafficMirrorRuleAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrafficMirrorRuleAction
         */
        Builder ruleAction(String ruleAction);

        /**
         * <p>
         * The action assigned to the Traffic Mirror rule.
         * </p>
         * 
         * @param ruleAction
         *        The action assigned to the Traffic Mirror rule.
         * @see TrafficMirrorRuleAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrafficMirrorRuleAction
         */
        Builder ruleAction(TrafficMirrorRuleAction ruleAction);

        /**
         * <p>
         * The protocol assigned to the Traffic Mirror rule.
         * </p>
         * 
         * @param protocol
         *        The protocol assigned to the Traffic Mirror rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(Integer protocol);

        /**
         * <p>
         * The destination port range assigned to the Traffic Mirror rule.
         * </p>
         * 
         * @param destinationPortRange
         *        The destination port range assigned to the Traffic Mirror rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPortRange(TrafficMirrorPortRange destinationPortRange);

        /**
         * <p>
         * The destination port range assigned to the Traffic Mirror rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrafficMirrorPortRange.Builder} avoiding
         * the need to create one manually via {@link TrafficMirrorPortRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrafficMirrorPortRange.Builder#build()} is called immediately and
         * its result is passed to {@link #destinationPortRange(TrafficMirrorPortRange)}.
         * 
         * @param destinationPortRange
         *        a consumer that will call methods on {@link TrafficMirrorPortRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationPortRange(TrafficMirrorPortRange)
         */
        default Builder destinationPortRange(Consumer<TrafficMirrorPortRange.Builder> destinationPortRange) {
            return destinationPortRange(TrafficMirrorPortRange.builder().applyMutation(destinationPortRange).build());
        }

        /**
         * <p>
         * The source port range assigned to the Traffic Mirror rule.
         * </p>
         * 
         * @param sourcePortRange
         *        The source port range assigned to the Traffic Mirror rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePortRange(TrafficMirrorPortRange sourcePortRange);

        /**
         * <p>
         * The source port range assigned to the Traffic Mirror rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrafficMirrorPortRange.Builder} avoiding
         * the need to create one manually via {@link TrafficMirrorPortRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrafficMirrorPortRange.Builder#build()} is called immediately and
         * its result is passed to {@link #sourcePortRange(TrafficMirrorPortRange)}.
         * 
         * @param sourcePortRange
         *        a consumer that will call methods on {@link TrafficMirrorPortRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourcePortRange(TrafficMirrorPortRange)
         */
        default Builder sourcePortRange(Consumer<TrafficMirrorPortRange.Builder> sourcePortRange) {
            return sourcePortRange(TrafficMirrorPortRange.builder().applyMutation(sourcePortRange).build());
        }

        /**
         * <p>
         * The destination CIDR block assigned to the Traffic Mirror rule.
         * </p>
         * 
         * @param destinationCidrBlock
         *        The destination CIDR block assigned to the Traffic Mirror rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCidrBlock(String destinationCidrBlock);

        /**
         * <p>
         * The source CIDR block assigned to the Traffic Mirror rule.
         * </p>
         * 
         * @param sourceCidrBlock
         *        The source CIDR block assigned to the Traffic Mirror rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCidrBlock(String sourceCidrBlock);

        /**
         * <p>
         * The description of the Traffic Mirror rule.
         * </p>
         * 
         * @param description
         *        The description of the Traffic Mirror rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Tags on Traffic Mirroring filter rules.
         * </p>
         * 
         * @param tags
         *        Tags on Traffic Mirroring filter rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Tags on Traffic Mirroring filter rules.
         * </p>
         * 
         * @param tags
         *        Tags on Traffic Mirroring filter rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Tags on Traffic Mirroring filter rules.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String trafficMirrorFilterRuleId;

        private String trafficMirrorFilterId;

        private String trafficDirection;

        private Integer ruleNumber;

        private String ruleAction;

        private Integer protocol;

        private TrafficMirrorPortRange destinationPortRange;

        private TrafficMirrorPortRange sourcePortRange;

        private String destinationCidrBlock;

        private String sourceCidrBlock;

        private String description;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TrafficMirrorFilterRule model) {
            trafficMirrorFilterRuleId(model.trafficMirrorFilterRuleId);
            trafficMirrorFilterId(model.trafficMirrorFilterId);
            trafficDirection(model.trafficDirection);
            ruleNumber(model.ruleNumber);
            ruleAction(model.ruleAction);
            protocol(model.protocol);
            destinationPortRange(model.destinationPortRange);
            sourcePortRange(model.sourcePortRange);
            destinationCidrBlock(model.destinationCidrBlock);
            sourceCidrBlock(model.sourceCidrBlock);
            description(model.description);
            tags(model.tags);
        }

        public final String getTrafficMirrorFilterRuleId() {
            return trafficMirrorFilterRuleId;
        }

        public final void setTrafficMirrorFilterRuleId(String trafficMirrorFilterRuleId) {
            this.trafficMirrorFilterRuleId = trafficMirrorFilterRuleId;
        }

        @Override
        public final Builder trafficMirrorFilterRuleId(String trafficMirrorFilterRuleId) {
            this.trafficMirrorFilterRuleId = trafficMirrorFilterRuleId;
            return this;
        }

        public final String getTrafficMirrorFilterId() {
            return trafficMirrorFilterId;
        }

        public final void setTrafficMirrorFilterId(String trafficMirrorFilterId) {
            this.trafficMirrorFilterId = trafficMirrorFilterId;
        }

        @Override
        public final Builder trafficMirrorFilterId(String trafficMirrorFilterId) {
            this.trafficMirrorFilterId = trafficMirrorFilterId;
            return this;
        }

        public final String getTrafficDirection() {
            return trafficDirection;
        }

        public final void setTrafficDirection(String trafficDirection) {
            this.trafficDirection = trafficDirection;
        }

        @Override
        public final Builder trafficDirection(String trafficDirection) {
            this.trafficDirection = trafficDirection;
            return this;
        }

        @Override
        public final Builder trafficDirection(TrafficDirection trafficDirection) {
            this.trafficDirection(trafficDirection == null ? null : trafficDirection.toString());
            return this;
        }

        public final Integer getRuleNumber() {
            return ruleNumber;
        }

        public final void setRuleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
        }

        @Override
        public final Builder ruleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
            return this;
        }

        public final String getRuleAction() {
            return ruleAction;
        }

        public final void setRuleAction(String ruleAction) {
            this.ruleAction = ruleAction;
        }

        @Override
        public final Builder ruleAction(String ruleAction) {
            this.ruleAction = ruleAction;
            return this;
        }

        @Override
        public final Builder ruleAction(TrafficMirrorRuleAction ruleAction) {
            this.ruleAction(ruleAction == null ? null : ruleAction.toString());
            return this;
        }

        public final Integer getProtocol() {
            return protocol;
        }

        public final void setProtocol(Integer protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(Integer protocol) {
            this.protocol = protocol;
            return this;
        }

        public final TrafficMirrorPortRange.Builder getDestinationPortRange() {
            return destinationPortRange != null ? destinationPortRange.toBuilder() : null;
        }

        public final void setDestinationPortRange(TrafficMirrorPortRange.BuilderImpl destinationPortRange) {
            this.destinationPortRange = destinationPortRange != null ? destinationPortRange.build() : null;
        }

        @Override
        public final Builder destinationPortRange(TrafficMirrorPortRange destinationPortRange) {
            this.destinationPortRange = destinationPortRange;
            return this;
        }

        public final TrafficMirrorPortRange.Builder getSourcePortRange() {
            return sourcePortRange != null ? sourcePortRange.toBuilder() : null;
        }

        public final void setSourcePortRange(TrafficMirrorPortRange.BuilderImpl sourcePortRange) {
            this.sourcePortRange = sourcePortRange != null ? sourcePortRange.build() : null;
        }

        @Override
        public final Builder sourcePortRange(TrafficMirrorPortRange sourcePortRange) {
            this.sourcePortRange = sourcePortRange;
            return this;
        }

        public final String getDestinationCidrBlock() {
            return destinationCidrBlock;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final String getSourceCidrBlock() {
            return sourceCidrBlock;
        }

        public final void setSourceCidrBlock(String sourceCidrBlock) {
            this.sourceCidrBlock = sourceCidrBlock;
        }

        @Override
        public final Builder sourceCidrBlock(String sourceCidrBlock) {
            this.sourceCidrBlock = sourceCidrBlock;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public TrafficMirrorFilterRule build() {
            return new TrafficMirrorFilterRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
