/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes information used to set up an EBS volume specified in a block device mapping.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EbsInstanceBlockDeviceSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<EbsInstanceBlockDeviceSpecification.Builder, EbsInstanceBlockDeviceSpecification> {
    private static final SdkField<String> VOLUME_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VolumeId")
            .getter(getter(EbsInstanceBlockDeviceSpecification::volumeId))
            .setter(setter(Builder::volumeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId")
                    .unmarshallLocationName("volumeId").build()).build();

    private static final SdkField<Boolean> DELETE_ON_TERMINATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeleteOnTermination")
            .getter(getter(EbsInstanceBlockDeviceSpecification::deleteOnTermination))
            .setter(setter(Builder::deleteOnTermination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteOnTermination")
                    .unmarshallLocationName("deleteOnTermination").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_ID_FIELD,
            DELETE_ON_TERMINATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String volumeId;

    private final Boolean deleteOnTermination;

    private EbsInstanceBlockDeviceSpecification(BuilderImpl builder) {
        this.volumeId = builder.volumeId;
        this.deleteOnTermination = builder.deleteOnTermination;
    }

    /**
     * <p>
     * The ID of the EBS volume.
     * </p>
     * 
     * @return The ID of the EBS volume.
     */
    public final String volumeId() {
        return volumeId;
    }

    /**
     * <p>
     * Indicates whether the volume is deleted on instance termination.
     * </p>
     * 
     * @return Indicates whether the volume is deleted on instance termination.
     */
    public final Boolean deleteOnTermination() {
        return deleteOnTermination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(deleteOnTermination());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsInstanceBlockDeviceSpecification)) {
            return false;
        }
        EbsInstanceBlockDeviceSpecification other = (EbsInstanceBlockDeviceSpecification) obj;
        return Objects.equals(volumeId(), other.volumeId()) && Objects.equals(deleteOnTermination(), other.deleteOnTermination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EbsInstanceBlockDeviceSpecification").add("VolumeId", volumeId())
                .add("DeleteOnTermination", deleteOnTermination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VolumeId":
            return Optional.ofNullable(clazz.cast(volumeId()));
        case "DeleteOnTermination":
            return Optional.ofNullable(clazz.cast(deleteOnTermination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EbsInstanceBlockDeviceSpecification, T> g) {
        return obj -> g.apply((EbsInstanceBlockDeviceSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EbsInstanceBlockDeviceSpecification> {
        /**
         * <p>
         * The ID of the EBS volume.
         * </p>
         * 
         * @param volumeId
         *        The ID of the EBS volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        /**
         * <p>
         * Indicates whether the volume is deleted on instance termination.
         * </p>
         * 
         * @param deleteOnTermination
         *        Indicates whether the volume is deleted on instance termination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteOnTermination(Boolean deleteOnTermination);
    }

    static final class BuilderImpl implements Builder {
        private String volumeId;

        private Boolean deleteOnTermination;

        private BuilderImpl() {
        }

        private BuilderImpl(EbsInstanceBlockDeviceSpecification model) {
            volumeId(model.volumeId);
            deleteOnTermination(model.deleteOnTermination);
        }

        public final String getVolumeId() {
            return volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final Boolean getDeleteOnTermination() {
            return deleteOnTermination;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        @Override
        public EbsInstanceBlockDeviceSpecification build() {
            return new EbsInstanceBlockDeviceSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
