/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyInstanceCpuOptionsResponse extends Ec2Response implements
        ToCopyableBuilder<ModifyInstanceCpuOptionsResponse.Builder, ModifyInstanceCpuOptionsResponse> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceId")
            .getter(getter(ModifyInstanceCpuOptionsResponse::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("instanceId").build()).build();

    private static final SdkField<Integer> CORE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("CoreCount")
            .getter(getter(ModifyInstanceCpuOptionsResponse::coreCount))
            .setter(setter(Builder::coreCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreCount")
                    .unmarshallLocationName("coreCount").build()).build();

    private static final SdkField<Integer> THREADS_PER_CORE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("ThreadsPerCore")
            .getter(getter(ModifyInstanceCpuOptionsResponse::threadsPerCore))
            .setter(setter(Builder::threadsPerCore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThreadsPerCore")
                    .unmarshallLocationName("threadsPerCore").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            CORE_COUNT_FIELD, THREADS_PER_CORE_FIELD));

    private final String instanceId;

    private final Integer coreCount;

    private final Integer threadsPerCore;

    private ModifyInstanceCpuOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.coreCount = builder.coreCount;
        this.threadsPerCore = builder.threadsPerCore;
    }

    /**
     * <p>
     * The ID of the instance that was updated.
     * </p>
     * 
     * @return The ID of the instance that was updated.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The number of CPU cores that are running for the specified instance after the update.
     * </p>
     * 
     * @return The number of CPU cores that are running for the specified instance after the update.
     */
    public final Integer coreCount() {
        return coreCount;
    }

    /**
     * <p>
     * The number of threads that are running per CPU core for the specified instance after the update.
     * </p>
     * 
     * @return The number of threads that are running per CPU core for the specified instance after the update.
     */
    public final Integer threadsPerCore() {
        return threadsPerCore;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(coreCount());
        hashCode = 31 * hashCode + Objects.hashCode(threadsPerCore());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstanceCpuOptionsResponse)) {
            return false;
        }
        ModifyInstanceCpuOptionsResponse other = (ModifyInstanceCpuOptionsResponse) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(coreCount(), other.coreCount())
                && Objects.equals(threadsPerCore(), other.threadsPerCore());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyInstanceCpuOptionsResponse").add("InstanceId", instanceId()).add("CoreCount", coreCount())
                .add("ThreadsPerCore", threadsPerCore()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "CoreCount":
            return Optional.ofNullable(clazz.cast(coreCount()));
        case "ThreadsPerCore":
            return Optional.ofNullable(clazz.cast(threadsPerCore()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyInstanceCpuOptionsResponse, T> g) {
        return obj -> g.apply((ModifyInstanceCpuOptionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, ModifyInstanceCpuOptionsResponse> {
        /**
         * <p>
         * The ID of the instance that was updated.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance that was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The number of CPU cores that are running for the specified instance after the update.
         * </p>
         * 
         * @param coreCount
         *        The number of CPU cores that are running for the specified instance after the update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreCount(Integer coreCount);

        /**
         * <p>
         * The number of threads that are running per CPU core for the specified instance after the update.
         * </p>
         * 
         * @param threadsPerCore
         *        The number of threads that are running per CPU core for the specified instance after the update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threadsPerCore(Integer threadsPerCore);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String instanceId;

        private Integer coreCount;

        private Integer threadsPerCore;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstanceCpuOptionsResponse model) {
            super(model);
            instanceId(model.instanceId);
            coreCount(model.coreCount);
            threadsPerCore(model.threadsPerCore);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final Integer getCoreCount() {
            return coreCount;
        }

        public final void setCoreCount(Integer coreCount) {
            this.coreCount = coreCount;
        }

        @Override
        public final Builder coreCount(Integer coreCount) {
            this.coreCount = coreCount;
            return this;
        }

        public final Integer getThreadsPerCore() {
            return threadsPerCore;
        }

        public final void setThreadsPerCore(Integer threadsPerCore) {
            this.threadsPerCore = threadsPerCore;
        }

        @Override
        public final Builder threadsPerCore(Integer threadsPerCore) {
            this.threadsPerCore = threadsPerCore;
            return this;
        }

        @Override
        public ModifyInstanceCpuOptionsResponse build() {
            return new ModifyInstanceCpuOptionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
