/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a VPC.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Vpc implements SdkPojo, Serializable, ToCopyableBuilder<Vpc.Builder, Vpc> {
    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OwnerId")
            .getter(getter(Vpc::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final SdkField<String> INSTANCE_TENANCY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceTenancy")
            .getter(getter(Vpc::instanceTenancyAsString))
            .setter(setter(Builder::instanceTenancy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceTenancy")
                    .unmarshallLocationName("instanceTenancy").build()).build();

    private static final SdkField<List<VpcIpv6CidrBlockAssociation>> IPV6_CIDR_BLOCK_ASSOCIATION_SET_FIELD = SdkField
            .<List<VpcIpv6CidrBlockAssociation>> builder(MarshallingType.LIST)
            .memberName("Ipv6CidrBlockAssociationSet")
            .getter(getter(Vpc::ipv6CidrBlockAssociationSet))
            .setter(setter(Builder::ipv6CidrBlockAssociationSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlockAssociationSet")
                    .unmarshallLocationName("ipv6CidrBlockAssociationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<VpcIpv6CidrBlockAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(VpcIpv6CidrBlockAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<VpcCidrBlockAssociation>> CIDR_BLOCK_ASSOCIATION_SET_FIELD = SdkField
            .<List<VpcCidrBlockAssociation>> builder(MarshallingType.LIST)
            .memberName("CidrBlockAssociationSet")
            .getter(getter(Vpc::cidrBlockAssociationSet))
            .setter(setter(Builder::cidrBlockAssociationSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlockAssociationSet")
                    .unmarshallLocationName("cidrBlockAssociationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<VpcCidrBlockAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(VpcCidrBlockAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> IS_DEFAULT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsDefault")
            .getter(getter(Vpc::isDefault))
            .setter(setter(Builder::isDefault))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefault")
                    .unmarshallLocationName("isDefault").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(Vpc::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcId")
            .getter(getter(Vpc::vpcId))
            .setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId")
                    .unmarshallLocationName("vpcId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(Vpc::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<String> CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CidrBlock")
            .getter(getter(Vpc::cidrBlock))
            .setter(setter(Builder::cidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlock")
                    .unmarshallLocationName("cidrBlock").build()).build();

    private static final SdkField<String> DHCP_OPTIONS_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DhcpOptionsId")
            .getter(getter(Vpc::dhcpOptionsId))
            .setter(setter(Builder::dhcpOptionsId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DhcpOptionsId")
                    .unmarshallLocationName("dhcpOptionsId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ID_FIELD,
            INSTANCE_TENANCY_FIELD, IPV6_CIDR_BLOCK_ASSOCIATION_SET_FIELD, CIDR_BLOCK_ASSOCIATION_SET_FIELD, IS_DEFAULT_FIELD,
            TAGS_FIELD, VPC_ID_FIELD, STATE_FIELD, CIDR_BLOCK_FIELD, DHCP_OPTIONS_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ownerId;

    private final String instanceTenancy;

    private final List<VpcIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet;

    private final List<VpcCidrBlockAssociation> cidrBlockAssociationSet;

    private final Boolean isDefault;

    private final List<Tag> tags;

    private final String vpcId;

    private final String state;

    private final String cidrBlock;

    private final String dhcpOptionsId;

    private Vpc(BuilderImpl builder) {
        this.ownerId = builder.ownerId;
        this.instanceTenancy = builder.instanceTenancy;
        this.ipv6CidrBlockAssociationSet = builder.ipv6CidrBlockAssociationSet;
        this.cidrBlockAssociationSet = builder.cidrBlockAssociationSet;
        this.isDefault = builder.isDefault;
        this.tags = builder.tags;
        this.vpcId = builder.vpcId;
        this.state = builder.state;
        this.cidrBlock = builder.cidrBlock;
        this.dhcpOptionsId = builder.dhcpOptionsId;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the VPC.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that owns the VPC.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The allowed tenancy of instances launched into the VPC.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceTenancy}
     * will return {@link Tenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTenancyAsString}.
     * </p>
     * 
     * @return The allowed tenancy of instances launched into the VPC.
     * @see Tenancy
     */
    public final Tenancy instanceTenancy() {
        return Tenancy.fromValue(instanceTenancy);
    }

    /**
     * <p>
     * The allowed tenancy of instances launched into the VPC.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceTenancy}
     * will return {@link Tenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTenancyAsString}.
     * </p>
     * 
     * @return The allowed tenancy of instances launched into the VPC.
     * @see Tenancy
     */
    public final String instanceTenancyAsString() {
        return instanceTenancy;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ipv6CidrBlockAssociationSet property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasIpv6CidrBlockAssociationSet() {
        return ipv6CidrBlockAssociationSet != null && !(ipv6CidrBlockAssociationSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the IPv6 CIDR blocks associated with the VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpv6CidrBlockAssociationSet} method.
     * </p>
     * 
     * @return Information about the IPv6 CIDR blocks associated with the VPC.
     */
    public final List<VpcIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet() {
        return ipv6CidrBlockAssociationSet;
    }

    /**
     * For responses, this returns true if the service returned a value for the CidrBlockAssociationSet property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCidrBlockAssociationSet() {
        return cidrBlockAssociationSet != null && !(cidrBlockAssociationSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the IPv4 CIDR blocks associated with the VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCidrBlockAssociationSet} method.
     * </p>
     * 
     * @return Information about the IPv4 CIDR blocks associated with the VPC.
     */
    public final List<VpcCidrBlockAssociation> cidrBlockAssociationSet() {
        return cidrBlockAssociationSet;
    }

    /**
     * <p>
     * Indicates whether the VPC is the default VPC.
     * </p>
     * 
     * @return Indicates whether the VPC is the default VPC.
     */
    public final Boolean isDefault() {
        return isDefault;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any tags assigned to the VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Any tags assigned to the VPC.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The current state of the VPC.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link VpcState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the VPC.
     * @see VpcState
     */
    public final VpcState state() {
        return VpcState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the VPC.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link VpcState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the VPC.
     * @see VpcState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The primary IPv4 CIDR block for the VPC.
     * </p>
     * 
     * @return The primary IPv4 CIDR block for the VPC.
     */
    public final String cidrBlock() {
        return cidrBlock;
    }

    /**
     * <p>
     * The ID of the set of DHCP options you've associated with the VPC.
     * </p>
     * 
     * @return The ID of the set of DHCP options you've associated with the VPC.
     */
    public final String dhcpOptionsId() {
        return dhcpOptionsId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpv6CidrBlockAssociationSet() ? ipv6CidrBlockAssociationSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCidrBlockAssociationSet() ? cidrBlockAssociationSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isDefault());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(dhcpOptionsId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Vpc)) {
            return false;
        }
        Vpc other = (Vpc) obj;
        return Objects.equals(ownerId(), other.ownerId())
                && Objects.equals(instanceTenancyAsString(), other.instanceTenancyAsString())
                && hasIpv6CidrBlockAssociationSet() == other.hasIpv6CidrBlockAssociationSet()
                && Objects.equals(ipv6CidrBlockAssociationSet(), other.ipv6CidrBlockAssociationSet())
                && hasCidrBlockAssociationSet() == other.hasCidrBlockAssociationSet()
                && Objects.equals(cidrBlockAssociationSet(), other.cidrBlockAssociationSet())
                && Objects.equals(isDefault(), other.isDefault()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(cidrBlock(), other.cidrBlock())
                && Objects.equals(dhcpOptionsId(), other.dhcpOptionsId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Vpc").add("OwnerId", ownerId()).add("InstanceTenancy", instanceTenancyAsString())
                .add("Ipv6CidrBlockAssociationSet", hasIpv6CidrBlockAssociationSet() ? ipv6CidrBlockAssociationSet() : null)
                .add("CidrBlockAssociationSet", hasCidrBlockAssociationSet() ? cidrBlockAssociationSet() : null)
                .add("IsDefault", isDefault()).add("Tags", hasTags() ? tags() : null).add("VpcId", vpcId())
                .add("State", stateAsString()).add("CidrBlock", cidrBlock()).add("DhcpOptionsId", dhcpOptionsId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "InstanceTenancy":
            return Optional.ofNullable(clazz.cast(instanceTenancyAsString()));
        case "Ipv6CidrBlockAssociationSet":
            return Optional.ofNullable(clazz.cast(ipv6CidrBlockAssociationSet()));
        case "CidrBlockAssociationSet":
            return Optional.ofNullable(clazz.cast(cidrBlockAssociationSet()));
        case "IsDefault":
            return Optional.ofNullable(clazz.cast(isDefault()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "CidrBlock":
            return Optional.ofNullable(clazz.cast(cidrBlock()));
        case "DhcpOptionsId":
            return Optional.ofNullable(clazz.cast(dhcpOptionsId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Vpc, T> g) {
        return obj -> g.apply((Vpc) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Vpc> {
        /**
         * <p>
         * The ID of the Amazon Web Services account that owns the VPC.
         * </p>
         * 
         * @param ownerId
         *        The ID of the Amazon Web Services account that owns the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The allowed tenancy of instances launched into the VPC.
         * </p>
         * 
         * @param instanceTenancy
         *        The allowed tenancy of instances launched into the VPC.
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder instanceTenancy(String instanceTenancy);

        /**
         * <p>
         * The allowed tenancy of instances launched into the VPC.
         * </p>
         * 
         * @param instanceTenancy
         *        The allowed tenancy of instances launched into the VPC.
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder instanceTenancy(Tenancy instanceTenancy);

        /**
         * <p>
         * Information about the IPv6 CIDR blocks associated with the VPC.
         * </p>
         * 
         * @param ipv6CidrBlockAssociationSet
         *        Information about the IPv6 CIDR blocks associated with the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlockAssociationSet(Collection<VpcIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet);

        /**
         * <p>
         * Information about the IPv6 CIDR blocks associated with the VPC.
         * </p>
         * 
         * @param ipv6CidrBlockAssociationSet
         *        Information about the IPv6 CIDR blocks associated with the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlockAssociationSet(VpcIpv6CidrBlockAssociation... ipv6CidrBlockAssociationSet);

        /**
         * <p>
         * Information about the IPv6 CIDR blocks associated with the VPC.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.VpcIpv6CidrBlockAssociation.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.VpcIpv6CidrBlockAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.VpcIpv6CidrBlockAssociation.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #ipv6CidrBlockAssociationSet(List<VpcIpv6CidrBlockAssociation>)}.
         * 
         * @param ipv6CidrBlockAssociationSet
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.VpcIpv6CidrBlockAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipv6CidrBlockAssociationSet(java.util.Collection<VpcIpv6CidrBlockAssociation>)
         */
        Builder ipv6CidrBlockAssociationSet(Consumer<VpcIpv6CidrBlockAssociation.Builder>... ipv6CidrBlockAssociationSet);

        /**
         * <p>
         * Information about the IPv4 CIDR blocks associated with the VPC.
         * </p>
         * 
         * @param cidrBlockAssociationSet
         *        Information about the IPv4 CIDR blocks associated with the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlockAssociationSet(Collection<VpcCidrBlockAssociation> cidrBlockAssociationSet);

        /**
         * <p>
         * Information about the IPv4 CIDR blocks associated with the VPC.
         * </p>
         * 
         * @param cidrBlockAssociationSet
         *        Information about the IPv4 CIDR blocks associated with the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlockAssociationSet(VpcCidrBlockAssociation... cidrBlockAssociationSet);

        /**
         * <p>
         * Information about the IPv4 CIDR blocks associated with the VPC.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.VpcCidrBlockAssociation.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ec2.model.VpcCidrBlockAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.VpcCidrBlockAssociation.Builder#build()} is called
         * immediately and its result is passed to {@link #cidrBlockAssociationSet(List<VpcCidrBlockAssociation>)}.
         * 
         * @param cidrBlockAssociationSet
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.VpcCidrBlockAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cidrBlockAssociationSet(java.util.Collection<VpcCidrBlockAssociation>)
         */
        Builder cidrBlockAssociationSet(Consumer<VpcCidrBlockAssociation.Builder>... cidrBlockAssociationSet);

        /**
         * <p>
         * Indicates whether the VPC is the default VPC.
         * </p>
         * 
         * @param isDefault
         *        Indicates whether the VPC is the default VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDefault(Boolean isDefault);

        /**
         * <p>
         * Any tags assigned to the VPC.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the VPC.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags assigned to the VPC.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The current state of the VPC.
         * </p>
         * 
         * @param state
         *        The current state of the VPC.
         * @see VpcState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the VPC.
         * </p>
         * 
         * @param state
         *        The current state of the VPC.
         * @see VpcState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcState
         */
        Builder state(VpcState state);

        /**
         * <p>
         * The primary IPv4 CIDR block for the VPC.
         * </p>
         * 
         * @param cidrBlock
         *        The primary IPv4 CIDR block for the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlock(String cidrBlock);

        /**
         * <p>
         * The ID of the set of DHCP options you've associated with the VPC.
         * </p>
         * 
         * @param dhcpOptionsId
         *        The ID of the set of DHCP options you've associated with the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dhcpOptionsId(String dhcpOptionsId);
    }

    static final class BuilderImpl implements Builder {
        private String ownerId;

        private String instanceTenancy;

        private List<VpcIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet = DefaultSdkAutoConstructList.getInstance();

        private List<VpcCidrBlockAssociation> cidrBlockAssociationSet = DefaultSdkAutoConstructList.getInstance();

        private Boolean isDefault;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String vpcId;

        private String state;

        private String cidrBlock;

        private String dhcpOptionsId;

        private BuilderImpl() {
        }

        private BuilderImpl(Vpc model) {
            ownerId(model.ownerId);
            instanceTenancy(model.instanceTenancy);
            ipv6CidrBlockAssociationSet(model.ipv6CidrBlockAssociationSet);
            cidrBlockAssociationSet(model.cidrBlockAssociationSet);
            isDefault(model.isDefault);
            tags(model.tags);
            vpcId(model.vpcId);
            state(model.state);
            cidrBlock(model.cidrBlock);
            dhcpOptionsId(model.dhcpOptionsId);
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getInstanceTenancy() {
            return instanceTenancy;
        }

        public final void setInstanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
        }

        @Override
        public final Builder instanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
            return this;
        }

        @Override
        public final Builder instanceTenancy(Tenancy instanceTenancy) {
            this.instanceTenancy(instanceTenancy == null ? null : instanceTenancy.toString());
            return this;
        }

        public final List<VpcIpv6CidrBlockAssociation.Builder> getIpv6CidrBlockAssociationSet() {
            List<VpcIpv6CidrBlockAssociation.Builder> result = VpcIpv6CidrBlockAssociationSetCopier
                    .copyToBuilder(this.ipv6CidrBlockAssociationSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv6CidrBlockAssociationSet(
                Collection<VpcIpv6CidrBlockAssociation.BuilderImpl> ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet = VpcIpv6CidrBlockAssociationSetCopier.copyFromBuilder(ipv6CidrBlockAssociationSet);
        }

        @Override
        public final Builder ipv6CidrBlockAssociationSet(Collection<VpcIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet = VpcIpv6CidrBlockAssociationSetCopier.copy(ipv6CidrBlockAssociationSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6CidrBlockAssociationSet(VpcIpv6CidrBlockAssociation... ipv6CidrBlockAssociationSet) {
            ipv6CidrBlockAssociationSet(Arrays.asList(ipv6CidrBlockAssociationSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6CidrBlockAssociationSet(
                Consumer<VpcIpv6CidrBlockAssociation.Builder>... ipv6CidrBlockAssociationSet) {
            ipv6CidrBlockAssociationSet(Stream.of(ipv6CidrBlockAssociationSet)
                    .map(c -> VpcIpv6CidrBlockAssociation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<VpcCidrBlockAssociation.Builder> getCidrBlockAssociationSet() {
            List<VpcCidrBlockAssociation.Builder> result = VpcCidrBlockAssociationSetCopier
                    .copyToBuilder(this.cidrBlockAssociationSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCidrBlockAssociationSet(Collection<VpcCidrBlockAssociation.BuilderImpl> cidrBlockAssociationSet) {
            this.cidrBlockAssociationSet = VpcCidrBlockAssociationSetCopier.copyFromBuilder(cidrBlockAssociationSet);
        }

        @Override
        public final Builder cidrBlockAssociationSet(Collection<VpcCidrBlockAssociation> cidrBlockAssociationSet) {
            this.cidrBlockAssociationSet = VpcCidrBlockAssociationSetCopier.copy(cidrBlockAssociationSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrBlockAssociationSet(VpcCidrBlockAssociation... cidrBlockAssociationSet) {
            cidrBlockAssociationSet(Arrays.asList(cidrBlockAssociationSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrBlockAssociationSet(Consumer<VpcCidrBlockAssociation.Builder>... cidrBlockAssociationSet) {
            cidrBlockAssociationSet(Stream.of(cidrBlockAssociationSet)
                    .map(c -> VpcCidrBlockAssociation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIsDefault() {
            return isDefault;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VpcState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getCidrBlock() {
            return cidrBlock;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final String getDhcpOptionsId() {
            return dhcpOptionsId;
        }

        public final void setDhcpOptionsId(String dhcpOptionsId) {
            this.dhcpOptionsId = dhcpOptionsId;
        }

        @Override
        public final Builder dhcpOptionsId(String dhcpOptionsId) {
            this.dhcpOptionsId = dhcpOptionsId;
            return this;
        }

        @Override
        public Vpc build() {
            return new Vpc(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
