/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for AttachNetworkInterface.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttachNetworkInterfaceRequest extends Ec2Request implements
        ToCopyableBuilder<AttachNetworkInterfaceRequest.Builder, AttachNetworkInterfaceRequest> {
    private static final SdkField<Integer> NETWORK_CARD_INDEX_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("NetworkCardIndex")
            .getter(getter(AttachNetworkInterfaceRequest::networkCardIndex))
            .setter(setter(Builder::networkCardIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkCardIndex")
                    .unmarshallLocationName("NetworkCardIndex").build()).build();

    private static final SdkField<EnaSrdSpecification> ENA_SRD_SPECIFICATION_FIELD = SdkField
            .<EnaSrdSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("EnaSrdSpecification")
            .getter(getter(AttachNetworkInterfaceRequest::enaSrdSpecification))
            .setter(setter(Builder::enaSrdSpecification))
            .constructor(EnaSrdSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnaSrdSpecification")
                    .unmarshallLocationName("EnaSrdSpecification").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(AttachNetworkInterfaceRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("dryRun").build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceId")
            .getter(getter(AttachNetworkInterfaceRequest::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId")
                    .unmarshallLocationName("networkInterfaceId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceId")
            .getter(getter(AttachNetworkInterfaceRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("instanceId").build()).build();

    private static final SdkField<Integer> DEVICE_INDEX_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("DeviceIndex")
            .getter(getter(AttachNetworkInterfaceRequest::deviceIndex))
            .setter(setter(Builder::deviceIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceIndex")
                    .unmarshallLocationName("deviceIndex").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_CARD_INDEX_FIELD,
            ENA_SRD_SPECIFICATION_FIELD, DRY_RUN_FIELD, NETWORK_INTERFACE_ID_FIELD, INSTANCE_ID_FIELD, DEVICE_INDEX_FIELD));

    private final Integer networkCardIndex;

    private final EnaSrdSpecification enaSrdSpecification;

    private final Boolean dryRun;

    private final String networkInterfaceId;

    private final String instanceId;

    private final Integer deviceIndex;

    private AttachNetworkInterfaceRequest(BuilderImpl builder) {
        super(builder);
        this.networkCardIndex = builder.networkCardIndex;
        this.enaSrdSpecification = builder.enaSrdSpecification;
        this.dryRun = builder.dryRun;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.instanceId = builder.instanceId;
        this.deviceIndex = builder.deviceIndex;
    }

    /**
     * <p>
     * The index of the network card. Some instance types support multiple network cards. The primary network interface
     * must be assigned to network card index 0. The default is network card index 0.
     * </p>
     * 
     * @return The index of the network card. Some instance types support multiple network cards. The primary network
     *         interface must be assigned to network card index 0. The default is network card index 0.
     */
    public final Integer networkCardIndex() {
        return networkCardIndex;
    }

    /**
     * <p>
     * Configures ENA Express for the network interface that this action attaches to the instance.
     * </p>
     * 
     * @return Configures ENA Express for the network interface that this action attaches to the instance.
     */
    public final EnaSrdSpecification enaSrdSpecification() {
        return enaSrdSpecification;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public final String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The index of the device for the network interface attachment.
     * </p>
     * 
     * @return The index of the device for the network interface attachment.
     */
    public final Integer deviceIndex() {
        return deviceIndex;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(networkCardIndex());
        hashCode = 31 * hashCode + Objects.hashCode(enaSrdSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(deviceIndex());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachNetworkInterfaceRequest)) {
            return false;
        }
        AttachNetworkInterfaceRequest other = (AttachNetworkInterfaceRequest) obj;
        return Objects.equals(networkCardIndex(), other.networkCardIndex())
                && Objects.equals(enaSrdSpecification(), other.enaSrdSpecification()) && Objects.equals(dryRun(), other.dryRun())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(instanceId(), other.instanceId()) && Objects.equals(deviceIndex(), other.deviceIndex());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttachNetworkInterfaceRequest").add("NetworkCardIndex", networkCardIndex())
                .add("EnaSrdSpecification", enaSrdSpecification()).add("DryRun", dryRun())
                .add("NetworkInterfaceId", networkInterfaceId()).add("InstanceId", instanceId())
                .add("DeviceIndex", deviceIndex()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkCardIndex":
            return Optional.ofNullable(clazz.cast(networkCardIndex()));
        case "EnaSrdSpecification":
            return Optional.ofNullable(clazz.cast(enaSrdSpecification()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "DeviceIndex":
            return Optional.ofNullable(clazz.cast(deviceIndex()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttachNetworkInterfaceRequest, T> g) {
        return obj -> g.apply((AttachNetworkInterfaceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, AttachNetworkInterfaceRequest> {
        /**
         * <p>
         * The index of the network card. Some instance types support multiple network cards. The primary network
         * interface must be assigned to network card index 0. The default is network card index 0.
         * </p>
         * 
         * @param networkCardIndex
         *        The index of the network card. Some instance types support multiple network cards. The primary network
         *        interface must be assigned to network card index 0. The default is network card index 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkCardIndex(Integer networkCardIndex);

        /**
         * <p>
         * Configures ENA Express for the network interface that this action attaches to the instance.
         * </p>
         * 
         * @param enaSrdSpecification
         *        Configures ENA Express for the network interface that this action attaches to the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enaSrdSpecification(EnaSrdSpecification enaSrdSpecification);

        /**
         * <p>
         * Configures ENA Express for the network interface that this action attaches to the instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link EnaSrdSpecification.Builder} avoiding the
         * need to create one manually via {@link EnaSrdSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnaSrdSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #enaSrdSpecification(EnaSrdSpecification)}.
         * 
         * @param enaSrdSpecification
         *        a consumer that will call methods on {@link EnaSrdSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enaSrdSpecification(EnaSrdSpecification)
         */
        default Builder enaSrdSpecification(Consumer<EnaSrdSpecification.Builder> enaSrdSpecification) {
            return enaSrdSpecification(EnaSrdSpecification.builder().applyMutation(enaSrdSpecification).build());
        }

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The index of the device for the network interface attachment.
         * </p>
         * 
         * @param deviceIndex
         *        The index of the device for the network interface attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceIndex(Integer deviceIndex);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Integer networkCardIndex;

        private EnaSrdSpecification enaSrdSpecification;

        private Boolean dryRun;

        private String networkInterfaceId;

        private String instanceId;

        private Integer deviceIndex;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachNetworkInterfaceRequest model) {
            super(model);
            networkCardIndex(model.networkCardIndex);
            enaSrdSpecification(model.enaSrdSpecification);
            dryRun(model.dryRun);
            networkInterfaceId(model.networkInterfaceId);
            instanceId(model.instanceId);
            deviceIndex(model.deviceIndex);
        }

        public final Integer getNetworkCardIndex() {
            return networkCardIndex;
        }

        public final void setNetworkCardIndex(Integer networkCardIndex) {
            this.networkCardIndex = networkCardIndex;
        }

        @Override
        public final Builder networkCardIndex(Integer networkCardIndex) {
            this.networkCardIndex = networkCardIndex;
            return this;
        }

        public final EnaSrdSpecification.Builder getEnaSrdSpecification() {
            return enaSrdSpecification != null ? enaSrdSpecification.toBuilder() : null;
        }

        public final void setEnaSrdSpecification(EnaSrdSpecification.BuilderImpl enaSrdSpecification) {
            this.enaSrdSpecification = enaSrdSpecification != null ? enaSrdSpecification.build() : null;
        }

        @Override
        public final Builder enaSrdSpecification(EnaSrdSpecification enaSrdSpecification) {
            this.enaSrdSpecification = enaSrdSpecification;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final Integer getDeviceIndex() {
            return deviceIndex;
        }

        public final void setDeviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
        }

        @Override
        public final Builder deviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AttachNetworkInterfaceRequest build() {
            return new AttachNetworkInterfaceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
