/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CreateReservedInstancesListing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateReservedInstancesListingRequest extends Ec2Request implements
        ToCopyableBuilder<CreateReservedInstancesListingRequest.Builder, CreateReservedInstancesListingRequest> {
    private static final SdkField<String> RESERVED_INSTANCES_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReservedInstancesId")
            .getter(getter(CreateReservedInstancesListingRequest::reservedInstancesId))
            .setter(setter(Builder::reservedInstancesId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesId")
                    .unmarshallLocationName("reservedInstancesId").build()).build();

    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstanceCount")
            .getter(getter(CreateReservedInstancesListingRequest::instanceCount))
            .setter(setter(Builder::instanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount")
                    .unmarshallLocationName("instanceCount").build()).build();

    private static final SdkField<List<PriceScheduleSpecification>> PRICE_SCHEDULES_FIELD = SdkField
            .<List<PriceScheduleSpecification>> builder(MarshallingType.LIST)
            .memberName("PriceSchedules")
            .getter(getter(CreateReservedInstancesListingRequest::priceSchedules))
            .setter(setter(Builder::priceSchedules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PriceSchedules")
                    .unmarshallLocationName("priceSchedules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<PriceScheduleSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(PriceScheduleSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateReservedInstancesListingRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("clientToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_INSTANCES_ID_FIELD,
            INSTANCE_COUNT_FIELD, PRICE_SCHEDULES_FIELD, CLIENT_TOKEN_FIELD));

    private final String reservedInstancesId;

    private final Integer instanceCount;

    private final List<PriceScheduleSpecification> priceSchedules;

    private final String clientToken;

    private CreateReservedInstancesListingRequest(BuilderImpl builder) {
        super(builder);
        this.reservedInstancesId = builder.reservedInstancesId;
        this.instanceCount = builder.instanceCount;
        this.priceSchedules = builder.priceSchedules;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The ID of the active Standard Reserved Instance.
     * </p>
     * 
     * @return The ID of the active Standard Reserved Instance.
     */
    public final String reservedInstancesId() {
        return reservedInstancesId;
    }

    /**
     * <p>
     * The number of instances that are a part of a Reserved Instance account to be listed in the Reserved Instance
     * Marketplace. This number should be less than or equal to the instance count associated with the Reserved Instance
     * ID specified in this call.
     * </p>
     * 
     * @return The number of instances that are a part of a Reserved Instance account to be listed in the Reserved
     *         Instance Marketplace. This number should be less than or equal to the instance count associated with the
     *         Reserved Instance ID specified in this call.
     */
    public final Integer instanceCount() {
        return instanceCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the PriceSchedules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPriceSchedules() {
        return priceSchedules != null && !(priceSchedules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list specifying the price of the Standard Reserved Instance for each month remaining in the Reserved Instance
     * term.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPriceSchedules} method.
     * </p>
     * 
     * @return A list specifying the price of the Standard Reserved Instance for each month remaining in the Reserved
     *         Instance term.
     */
    public final List<PriceScheduleSpecification> priceSchedules() {
        return priceSchedules;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier you provide to ensure idempotency of your listings. This helps avoid duplicate
     * listings. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier you provide to ensure idempotency of your listings. This helps avoid
     *         duplicate listings. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         Idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstancesId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasPriceSchedules() ? priceSchedules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReservedInstancesListingRequest)) {
            return false;
        }
        CreateReservedInstancesListingRequest other = (CreateReservedInstancesListingRequest) obj;
        return Objects.equals(reservedInstancesId(), other.reservedInstancesId())
                && Objects.equals(instanceCount(), other.instanceCount()) && hasPriceSchedules() == other.hasPriceSchedules()
                && Objects.equals(priceSchedules(), other.priceSchedules()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateReservedInstancesListingRequest").add("ReservedInstancesId", reservedInstancesId())
                .add("InstanceCount", instanceCount()).add("PriceSchedules", hasPriceSchedules() ? priceSchedules() : null)
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedInstancesId":
            return Optional.ofNullable(clazz.cast(reservedInstancesId()));
        case "InstanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        case "PriceSchedules":
            return Optional.ofNullable(clazz.cast(priceSchedules()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateReservedInstancesListingRequest, T> g) {
        return obj -> g.apply((CreateReservedInstancesListingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateReservedInstancesListingRequest> {
        /**
         * <p>
         * The ID of the active Standard Reserved Instance.
         * </p>
         * 
         * @param reservedInstancesId
         *        The ID of the active Standard Reserved Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesId(String reservedInstancesId);

        /**
         * <p>
         * The number of instances that are a part of a Reserved Instance account to be listed in the Reserved Instance
         * Marketplace. This number should be less than or equal to the instance count associated with the Reserved
         * Instance ID specified in this call.
         * </p>
         * 
         * @param instanceCount
         *        The number of instances that are a part of a Reserved Instance account to be listed in the Reserved
         *        Instance Marketplace. This number should be less than or equal to the instance count associated with
         *        the Reserved Instance ID specified in this call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * A list specifying the price of the Standard Reserved Instance for each month remaining in the Reserved
         * Instance term.
         * </p>
         * 
         * @param priceSchedules
         *        A list specifying the price of the Standard Reserved Instance for each month remaining in the Reserved
         *        Instance term.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priceSchedules(Collection<PriceScheduleSpecification> priceSchedules);

        /**
         * <p>
         * A list specifying the price of the Standard Reserved Instance for each month remaining in the Reserved
         * Instance term.
         * </p>
         * 
         * @param priceSchedules
         *        A list specifying the price of the Standard Reserved Instance for each month remaining in the Reserved
         *        Instance term.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priceSchedules(PriceScheduleSpecification... priceSchedules);

        /**
         * <p>
         * A list specifying the price of the Standard Reserved Instance for each month remaining in the Reserved
         * Instance term.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.PriceScheduleSpecification.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.PriceScheduleSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.PriceScheduleSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #priceSchedules(List<PriceScheduleSpecification>)}.
         * 
         * @param priceSchedules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.PriceScheduleSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #priceSchedules(java.util.Collection<PriceScheduleSpecification>)
         */
        Builder priceSchedules(Consumer<PriceScheduleSpecification.Builder>... priceSchedules);

        /**
         * <p>
         * Unique, case-sensitive identifier you provide to ensure idempotency of your listings. This helps avoid
         * duplicate listings. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier you provide to ensure idempotency of your listings. This helps avoid
         *        duplicate listings. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String reservedInstancesId;

        private Integer instanceCount;

        private List<PriceScheduleSpecification> priceSchedules = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReservedInstancesListingRequest model) {
            super(model);
            reservedInstancesId(model.reservedInstancesId);
            instanceCount(model.instanceCount);
            priceSchedules(model.priceSchedules);
            clientToken(model.clientToken);
        }

        public final String getReservedInstancesId() {
            return reservedInstancesId;
        }

        public final void setReservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
        }

        @Override
        public final Builder reservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
            return this;
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final List<PriceScheduleSpecification.Builder> getPriceSchedules() {
            List<PriceScheduleSpecification.Builder> result = PriceScheduleSpecificationListCopier
                    .copyToBuilder(this.priceSchedules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPriceSchedules(Collection<PriceScheduleSpecification.BuilderImpl> priceSchedules) {
            this.priceSchedules = PriceScheduleSpecificationListCopier.copyFromBuilder(priceSchedules);
        }

        @Override
        public final Builder priceSchedules(Collection<PriceScheduleSpecification> priceSchedules) {
            this.priceSchedules = PriceScheduleSpecificationListCopier.copy(priceSchedules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder priceSchedules(PriceScheduleSpecification... priceSchedules) {
            priceSchedules(Arrays.asList(priceSchedules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder priceSchedules(Consumer<PriceScheduleSpecification.Builder>... priceSchedules) {
            priceSchedules(Stream.of(priceSchedules).map(c -> PriceScheduleSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateReservedInstancesListingRequest build() {
            return new CreateReservedInstancesListingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
