/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifySubnetAttributeRequest extends Ec2Request implements
        ToCopyableBuilder<ModifySubnetAttributeRequest.Builder, ModifySubnetAttributeRequest> {
    private static final SdkField<AttributeBooleanValue> ASSIGN_IPV6_ADDRESS_ON_CREATION_FIELD = SdkField
            .<AttributeBooleanValue> builder(MarshallingType.SDK_POJO)
            .memberName("AssignIpv6AddressOnCreation")
            .getter(getter(ModifySubnetAttributeRequest::assignIpv6AddressOnCreation))
            .setter(setter(Builder::assignIpv6AddressOnCreation))
            .constructor(AttributeBooleanValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignIpv6AddressOnCreation")
                    .unmarshallLocationName("AssignIpv6AddressOnCreation").build()).build();

    private static final SdkField<AttributeBooleanValue> MAP_PUBLIC_IP_ON_LAUNCH_FIELD = SdkField
            .<AttributeBooleanValue> builder(MarshallingType.SDK_POJO)
            .memberName("MapPublicIpOnLaunch")
            .getter(getter(ModifySubnetAttributeRequest::mapPublicIpOnLaunch))
            .setter(setter(Builder::mapPublicIpOnLaunch))
            .constructor(AttributeBooleanValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapPublicIpOnLaunch")
                    .unmarshallLocationName("MapPublicIpOnLaunch").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SubnetId")
            .getter(getter(ModifySubnetAttributeRequest::subnetId))
            .setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId")
                    .unmarshallLocationName("subnetId").build()).build();

    private static final SdkField<AttributeBooleanValue> MAP_CUSTOMER_OWNED_IP_ON_LAUNCH_FIELD = SdkField
            .<AttributeBooleanValue> builder(MarshallingType.SDK_POJO)
            .memberName("MapCustomerOwnedIpOnLaunch")
            .getter(getter(ModifySubnetAttributeRequest::mapCustomerOwnedIpOnLaunch))
            .setter(setter(Builder::mapCustomerOwnedIpOnLaunch))
            .constructor(AttributeBooleanValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapCustomerOwnedIpOnLaunch")
                    .unmarshallLocationName("MapCustomerOwnedIpOnLaunch").build()).build();

    private static final SdkField<String> CUSTOMER_OWNED_IPV4_POOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CustomerOwnedIpv4Pool")
            .getter(getter(ModifySubnetAttributeRequest::customerOwnedIpv4Pool))
            .setter(setter(Builder::customerOwnedIpv4Pool))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerOwnedIpv4Pool")
                    .unmarshallLocationName("CustomerOwnedIpv4Pool").build()).build();

    private static final SdkField<AttributeBooleanValue> ENABLE_DNS64_FIELD = SdkField
            .<AttributeBooleanValue> builder(MarshallingType.SDK_POJO)
            .memberName("EnableDns64")
            .getter(getter(ModifySubnetAttributeRequest::enableDns64))
            .setter(setter(Builder::enableDns64))
            .constructor(AttributeBooleanValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableDns64")
                    .unmarshallLocationName("EnableDns64").build()).build();

    private static final SdkField<String> PRIVATE_DNS_HOSTNAME_TYPE_ON_LAUNCH_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrivateDnsHostnameTypeOnLaunch")
            .getter(getter(ModifySubnetAttributeRequest::privateDnsHostnameTypeOnLaunchAsString))
            .setter(setter(Builder::privateDnsHostnameTypeOnLaunch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsHostnameTypeOnLaunch")
                    .unmarshallLocationName("PrivateDnsHostnameTypeOnLaunch").build()).build();

    private static final SdkField<AttributeBooleanValue> ENABLE_RESOURCE_NAME_DNS_A_RECORD_ON_LAUNCH_FIELD = SdkField
            .<AttributeBooleanValue> builder(MarshallingType.SDK_POJO)
            .memberName("EnableResourceNameDnsARecordOnLaunch")
            .getter(getter(ModifySubnetAttributeRequest::enableResourceNameDnsARecordOnLaunch))
            .setter(setter(Builder::enableResourceNameDnsARecordOnLaunch))
            .constructor(AttributeBooleanValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("EnableResourceNameDnsARecordOnLaunch")
                    .unmarshallLocationName("EnableResourceNameDnsARecordOnLaunch").build()).build();

    private static final SdkField<AttributeBooleanValue> ENABLE_RESOURCE_NAME_DNS_AAAA_RECORD_ON_LAUNCH_FIELD = SdkField
            .<AttributeBooleanValue> builder(MarshallingType.SDK_POJO)
            .memberName("EnableResourceNameDnsAAAARecordOnLaunch")
            .getter(getter(ModifySubnetAttributeRequest::enableResourceNameDnsAAAARecordOnLaunch))
            .setter(setter(Builder::enableResourceNameDnsAAAARecordOnLaunch))
            .constructor(AttributeBooleanValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("EnableResourceNameDnsAAAARecordOnLaunch")
                    .unmarshallLocationName("EnableResourceNameDnsAAAARecordOnLaunch").build()).build();

    private static final SdkField<Integer> ENABLE_LNI_AT_DEVICE_INDEX_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("EnableLniAtDeviceIndex")
            .getter(getter(ModifySubnetAttributeRequest::enableLniAtDeviceIndex))
            .setter(setter(Builder::enableLniAtDeviceIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableLniAtDeviceIndex")
                    .unmarshallLocationName("EnableLniAtDeviceIndex").build()).build();

    private static final SdkField<AttributeBooleanValue> DISABLE_LNI_AT_DEVICE_INDEX_FIELD = SdkField
            .<AttributeBooleanValue> builder(MarshallingType.SDK_POJO)
            .memberName("DisableLniAtDeviceIndex")
            .getter(getter(ModifySubnetAttributeRequest::disableLniAtDeviceIndex))
            .setter(setter(Builder::disableLniAtDeviceIndex))
            .constructor(AttributeBooleanValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableLniAtDeviceIndex")
                    .unmarshallLocationName("DisableLniAtDeviceIndex").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ASSIGN_IPV6_ADDRESS_ON_CREATION_FIELD, MAP_PUBLIC_IP_ON_LAUNCH_FIELD, SUBNET_ID_FIELD,
            MAP_CUSTOMER_OWNED_IP_ON_LAUNCH_FIELD, CUSTOMER_OWNED_IPV4_POOL_FIELD, ENABLE_DNS64_FIELD,
            PRIVATE_DNS_HOSTNAME_TYPE_ON_LAUNCH_FIELD, ENABLE_RESOURCE_NAME_DNS_A_RECORD_ON_LAUNCH_FIELD,
            ENABLE_RESOURCE_NAME_DNS_AAAA_RECORD_ON_LAUNCH_FIELD, ENABLE_LNI_AT_DEVICE_INDEX_FIELD,
            DISABLE_LNI_AT_DEVICE_INDEX_FIELD));

    private final AttributeBooleanValue assignIpv6AddressOnCreation;

    private final AttributeBooleanValue mapPublicIpOnLaunch;

    private final String subnetId;

    private final AttributeBooleanValue mapCustomerOwnedIpOnLaunch;

    private final String customerOwnedIpv4Pool;

    private final AttributeBooleanValue enableDns64;

    private final String privateDnsHostnameTypeOnLaunch;

    private final AttributeBooleanValue enableResourceNameDnsARecordOnLaunch;

    private final AttributeBooleanValue enableResourceNameDnsAAAARecordOnLaunch;

    private final Integer enableLniAtDeviceIndex;

    private final AttributeBooleanValue disableLniAtDeviceIndex;

    private ModifySubnetAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.assignIpv6AddressOnCreation = builder.assignIpv6AddressOnCreation;
        this.mapPublicIpOnLaunch = builder.mapPublicIpOnLaunch;
        this.subnetId = builder.subnetId;
        this.mapCustomerOwnedIpOnLaunch = builder.mapCustomerOwnedIpOnLaunch;
        this.customerOwnedIpv4Pool = builder.customerOwnedIpv4Pool;
        this.enableDns64 = builder.enableDns64;
        this.privateDnsHostnameTypeOnLaunch = builder.privateDnsHostnameTypeOnLaunch;
        this.enableResourceNameDnsARecordOnLaunch = builder.enableResourceNameDnsARecordOnLaunch;
        this.enableResourceNameDnsAAAARecordOnLaunch = builder.enableResourceNameDnsAAAARecordOnLaunch;
        this.enableLniAtDeviceIndex = builder.enableLniAtDeviceIndex;
        this.disableLniAtDeviceIndex = builder.disableLniAtDeviceIndex;
    }

    /**
     * <p>
     * Specify <code>true</code> to indicate that network interfaces created in the specified subnet should be assigned
     * an IPv6 address. This includes a network interface that's created when launching an instance into the subnet (the
     * instance therefore receives an IPv6 address).
     * </p>
     * <p>
     * If you enable the IPv6 addressing feature for your subnet, your network interface or instance only receives an
     * IPv6 address if it's created using version <code>2016-11-15</code> or later of the Amazon EC2 API.
     * </p>
     * 
     * @return Specify <code>true</code> to indicate that network interfaces created in the specified subnet should be
     *         assigned an IPv6 address. This includes a network interface that's created when launching an instance
     *         into the subnet (the instance therefore receives an IPv6 address). </p>
     *         <p>
     *         If you enable the IPv6 addressing feature for your subnet, your network interface or instance only
     *         receives an IPv6 address if it's created using version <code>2016-11-15</code> or later of the Amazon EC2
     *         API.
     */
    public final AttributeBooleanValue assignIpv6AddressOnCreation() {
        return assignIpv6AddressOnCreation;
    }

    /**
     * <p>
     * Specify <code>true</code> to indicate that network interfaces attached to instances created in the specified
     * subnet should be assigned a public IPv4 address.
     * </p>
     * <p>
     * Amazon Web Services charges for all public IPv4 addresses, including public IPv4 addresses associated with
     * running instances and Elastic IP addresses. For more information, see the <i>Public IPv4 Address</i> tab on the
     * <a href="http://aws.amazon.com/vpc/pricing/">Amazon VPC pricing page</a>.
     * </p>
     * 
     * @return Specify <code>true</code> to indicate that network interfaces attached to instances created in the
     *         specified subnet should be assigned a public IPv4 address.</p>
     *         <p>
     *         Amazon Web Services charges for all public IPv4 addresses, including public IPv4 addresses associated
     *         with running instances and Elastic IP addresses. For more information, see the <i>Public IPv4 Address</i>
     *         tab on the <a href="http://aws.amazon.com/vpc/pricing/">Amazon VPC pricing page</a>.
     */
    public final AttributeBooleanValue mapPublicIpOnLaunch() {
        return mapPublicIpOnLaunch;
    }

    /**
     * <p>
     * The ID of the subnet.
     * </p>
     * 
     * @return The ID of the subnet.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * Specify <code>true</code> to indicate that network interfaces attached to instances created in the specified
     * subnet should be assigned a customer-owned IPv4 address.
     * </p>
     * <p>
     * When this value is <code>true</code>, you must specify the customer-owned IP pool using
     * <code>CustomerOwnedIpv4Pool</code>.
     * </p>
     * 
     * @return Specify <code>true</code> to indicate that network interfaces attached to instances created in the
     *         specified subnet should be assigned a customer-owned IPv4 address.</p>
     *         <p>
     *         When this value is <code>true</code>, you must specify the customer-owned IP pool using
     *         <code>CustomerOwnedIpv4Pool</code>.
     */
    public final AttributeBooleanValue mapCustomerOwnedIpOnLaunch() {
        return mapCustomerOwnedIpOnLaunch;
    }

    /**
     * <p>
     * The customer-owned IPv4 address pool associated with the subnet.
     * </p>
     * <p>
     * You must set this value when you specify <code>true</code> for <code>MapCustomerOwnedIpOnLaunch</code>.
     * </p>
     * 
     * @return The customer-owned IPv4 address pool associated with the subnet.</p>
     *         <p>
     *         You must set this value when you specify <code>true</code> for <code>MapCustomerOwnedIpOnLaunch</code>.
     */
    public final String customerOwnedIpv4Pool() {
        return customerOwnedIpv4Pool;
    }

    /**
     * <p>
     * Indicates whether DNS queries made to the Amazon-provided DNS Resolver in this subnet should return synthetic
     * IPv6 addresses for IPv4-only destinations.
     * </p>
     * <p>
     * You must first configure a NAT gateway in a public subnet (separate from the subnet containing the IPv6-only
     * workloads). For example, the subnet containing the NAT gateway should have a <code>0.0.0.0/0</code> route
     * pointing to the internet gateway. For more information, see <a href=
     * "https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-nat64-dns64.html#nat-gateway-nat64-dns64-walkthrough"
     * >Configure DNS64 and NAT64</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * 
     * @return Indicates whether DNS queries made to the Amazon-provided DNS Resolver in this subnet should return
     *         synthetic IPv6 addresses for IPv4-only destinations.</p>
     *         <p>
     *         You must first configure a NAT gateway in a public subnet (separate from the subnet containing the
     *         IPv6-only workloads). For example, the subnet containing the NAT gateway should have a
     *         <code>0.0.0.0/0</code> route pointing to the internet gateway. For more information, see <a href=
     *         "https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-nat64-dns64.html#nat-gateway-nat64-dns64-walkthrough"
     *         >Configure DNS64 and NAT64</a> in the <i>Amazon VPC User Guide</i>.
     */
    public final AttributeBooleanValue enableDns64() {
        return enableDns64;
    }

    /**
     * <p>
     * The type of hostname to assign to instances in the subnet at launch. For IPv4-only and dual-stack (IPv4 and IPv6)
     * subnets, an instance DNS name can be based on the instance IPv4 address (ip-name) or the instance ID
     * (resource-name). For IPv6 only subnets, an instance DNS name must be based on the instance ID (resource-name).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #privateDnsHostnameTypeOnLaunch} will return {@link HostnameType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #privateDnsHostnameTypeOnLaunchAsString}.
     * </p>
     * 
     * @return The type of hostname to assign to instances in the subnet at launch. For IPv4-only and dual-stack (IPv4
     *         and IPv6) subnets, an instance DNS name can be based on the instance IPv4 address (ip-name) or the
     *         instance ID (resource-name). For IPv6 only subnets, an instance DNS name must be based on the instance ID
     *         (resource-name).
     * @see HostnameType
     */
    public final HostnameType privateDnsHostnameTypeOnLaunch() {
        return HostnameType.fromValue(privateDnsHostnameTypeOnLaunch);
    }

    /**
     * <p>
     * The type of hostname to assign to instances in the subnet at launch. For IPv4-only and dual-stack (IPv4 and IPv6)
     * subnets, an instance DNS name can be based on the instance IPv4 address (ip-name) or the instance ID
     * (resource-name). For IPv6 only subnets, an instance DNS name must be based on the instance ID (resource-name).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #privateDnsHostnameTypeOnLaunch} will return {@link HostnameType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #privateDnsHostnameTypeOnLaunchAsString}.
     * </p>
     * 
     * @return The type of hostname to assign to instances in the subnet at launch. For IPv4-only and dual-stack (IPv4
     *         and IPv6) subnets, an instance DNS name can be based on the instance IPv4 address (ip-name) or the
     *         instance ID (resource-name). For IPv6 only subnets, an instance DNS name must be based on the instance ID
     *         (resource-name).
     * @see HostnameType
     */
    public final String privateDnsHostnameTypeOnLaunchAsString() {
        return privateDnsHostnameTypeOnLaunch;
    }

    /**
     * <p>
     * Indicates whether to respond to DNS queries for instance hostnames with DNS A records.
     * </p>
     * 
     * @return Indicates whether to respond to DNS queries for instance hostnames with DNS A records.
     */
    public final AttributeBooleanValue enableResourceNameDnsARecordOnLaunch() {
        return enableResourceNameDnsARecordOnLaunch;
    }

    /**
     * <p>
     * Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.
     * </p>
     * 
     * @return Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.
     */
    public final AttributeBooleanValue enableResourceNameDnsAAAARecordOnLaunch() {
        return enableResourceNameDnsAAAARecordOnLaunch;
    }

    /**
     * <p>
     * Indicates the device position for local network interfaces in this subnet. For example, <code>1</code> indicates
     * local network interfaces in this subnet are the secondary network interface (eth1). A local network interface
     * cannot be the primary network interface (eth0).
     * </p>
     * 
     * @return Indicates the device position for local network interfaces in this subnet. For example, <code>1</code>
     *         indicates local network interfaces in this subnet are the secondary network interface (eth1). A local
     *         network interface cannot be the primary network interface (eth0).
     */
    public final Integer enableLniAtDeviceIndex() {
        return enableLniAtDeviceIndex;
    }

    /**
     * <p>
     * Specify <code>true</code> to indicate that local network interfaces at the current position should be disabled.
     * </p>
     * 
     * @return Specify <code>true</code> to indicate that local network interfaces at the current position should be
     *         disabled.
     */
    public final AttributeBooleanValue disableLniAtDeviceIndex() {
        return disableLniAtDeviceIndex;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assignIpv6AddressOnCreation());
        hashCode = 31 * hashCode + Objects.hashCode(mapPublicIpOnLaunch());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(mapCustomerOwnedIpOnLaunch());
        hashCode = 31 * hashCode + Objects.hashCode(customerOwnedIpv4Pool());
        hashCode = 31 * hashCode + Objects.hashCode(enableDns64());
        hashCode = 31 * hashCode + Objects.hashCode(privateDnsHostnameTypeOnLaunchAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enableResourceNameDnsARecordOnLaunch());
        hashCode = 31 * hashCode + Objects.hashCode(enableResourceNameDnsAAAARecordOnLaunch());
        hashCode = 31 * hashCode + Objects.hashCode(enableLniAtDeviceIndex());
        hashCode = 31 * hashCode + Objects.hashCode(disableLniAtDeviceIndex());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifySubnetAttributeRequest)) {
            return false;
        }
        ModifySubnetAttributeRequest other = (ModifySubnetAttributeRequest) obj;
        return Objects.equals(assignIpv6AddressOnCreation(), other.assignIpv6AddressOnCreation())
                && Objects.equals(mapPublicIpOnLaunch(), other.mapPublicIpOnLaunch())
                && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(mapCustomerOwnedIpOnLaunch(), other.mapCustomerOwnedIpOnLaunch())
                && Objects.equals(customerOwnedIpv4Pool(), other.customerOwnedIpv4Pool())
                && Objects.equals(enableDns64(), other.enableDns64())
                && Objects.equals(privateDnsHostnameTypeOnLaunchAsString(), other.privateDnsHostnameTypeOnLaunchAsString())
                && Objects.equals(enableResourceNameDnsARecordOnLaunch(), other.enableResourceNameDnsARecordOnLaunch())
                && Objects.equals(enableResourceNameDnsAAAARecordOnLaunch(), other.enableResourceNameDnsAAAARecordOnLaunch())
                && Objects.equals(enableLniAtDeviceIndex(), other.enableLniAtDeviceIndex())
                && Objects.equals(disableLniAtDeviceIndex(), other.disableLniAtDeviceIndex());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifySubnetAttributeRequest").add("AssignIpv6AddressOnCreation", assignIpv6AddressOnCreation())
                .add("MapPublicIpOnLaunch", mapPublicIpOnLaunch()).add("SubnetId", subnetId())
                .add("MapCustomerOwnedIpOnLaunch", mapCustomerOwnedIpOnLaunch())
                .add("CustomerOwnedIpv4Pool", customerOwnedIpv4Pool()).add("EnableDns64", enableDns64())
                .add("PrivateDnsHostnameTypeOnLaunch", privateDnsHostnameTypeOnLaunchAsString())
                .add("EnableResourceNameDnsARecordOnLaunch", enableResourceNameDnsARecordOnLaunch())
                .add("EnableResourceNameDnsAAAARecordOnLaunch", enableResourceNameDnsAAAARecordOnLaunch())
                .add("EnableLniAtDeviceIndex", enableLniAtDeviceIndex())
                .add("DisableLniAtDeviceIndex", disableLniAtDeviceIndex()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssignIpv6AddressOnCreation":
            return Optional.ofNullable(clazz.cast(assignIpv6AddressOnCreation()));
        case "MapPublicIpOnLaunch":
            return Optional.ofNullable(clazz.cast(mapPublicIpOnLaunch()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "MapCustomerOwnedIpOnLaunch":
            return Optional.ofNullable(clazz.cast(mapCustomerOwnedIpOnLaunch()));
        case "CustomerOwnedIpv4Pool":
            return Optional.ofNullable(clazz.cast(customerOwnedIpv4Pool()));
        case "EnableDns64":
            return Optional.ofNullable(clazz.cast(enableDns64()));
        case "PrivateDnsHostnameTypeOnLaunch":
            return Optional.ofNullable(clazz.cast(privateDnsHostnameTypeOnLaunchAsString()));
        case "EnableResourceNameDnsARecordOnLaunch":
            return Optional.ofNullable(clazz.cast(enableResourceNameDnsARecordOnLaunch()));
        case "EnableResourceNameDnsAAAARecordOnLaunch":
            return Optional.ofNullable(clazz.cast(enableResourceNameDnsAAAARecordOnLaunch()));
        case "EnableLniAtDeviceIndex":
            return Optional.ofNullable(clazz.cast(enableLniAtDeviceIndex()));
        case "DisableLniAtDeviceIndex":
            return Optional.ofNullable(clazz.cast(disableLniAtDeviceIndex()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifySubnetAttributeRequest, T> g) {
        return obj -> g.apply((ModifySubnetAttributeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifySubnetAttributeRequest> {
        /**
         * <p>
         * Specify <code>true</code> to indicate that network interfaces created in the specified subnet should be
         * assigned an IPv6 address. This includes a network interface that's created when launching an instance into
         * the subnet (the instance therefore receives an IPv6 address).
         * </p>
         * <p>
         * If you enable the IPv6 addressing feature for your subnet, your network interface or instance only receives
         * an IPv6 address if it's created using version <code>2016-11-15</code> or later of the Amazon EC2 API.
         * </p>
         * 
         * @param assignIpv6AddressOnCreation
         *        Specify <code>true</code> to indicate that network interfaces created in the specified subnet should
         *        be assigned an IPv6 address. This includes a network interface that's created when launching an
         *        instance into the subnet (the instance therefore receives an IPv6 address). </p>
         *        <p>
         *        If you enable the IPv6 addressing feature for your subnet, your network interface or instance only
         *        receives an IPv6 address if it's created using version <code>2016-11-15</code> or later of the Amazon
         *        EC2 API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignIpv6AddressOnCreation(AttributeBooleanValue assignIpv6AddressOnCreation);

        /**
         * <p>
         * Specify <code>true</code> to indicate that network interfaces created in the specified subnet should be
         * assigned an IPv6 address. This includes a network interface that's created when launching an instance into
         * the subnet (the instance therefore receives an IPv6 address).
         * </p>
         * <p>
         * If you enable the IPv6 addressing feature for your subnet, your network interface or instance only receives
         * an IPv6 address if it's created using version <code>2016-11-15</code> or later of the Amazon EC2 API.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeBooleanValue.Builder} avoiding
         * the need to create one manually via {@link AttributeBooleanValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeBooleanValue.Builder#build()} is called immediately and
         * its result is passed to {@link #assignIpv6AddressOnCreation(AttributeBooleanValue)}.
         * 
         * @param assignIpv6AddressOnCreation
         *        a consumer that will call methods on {@link AttributeBooleanValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assignIpv6AddressOnCreation(AttributeBooleanValue)
         */
        default Builder assignIpv6AddressOnCreation(Consumer<AttributeBooleanValue.Builder> assignIpv6AddressOnCreation) {
            return assignIpv6AddressOnCreation(AttributeBooleanValue.builder().applyMutation(assignIpv6AddressOnCreation).build());
        }

        /**
         * <p>
         * Specify <code>true</code> to indicate that network interfaces attached to instances created in the specified
         * subnet should be assigned a public IPv4 address.
         * </p>
         * <p>
         * Amazon Web Services charges for all public IPv4 addresses, including public IPv4 addresses associated with
         * running instances and Elastic IP addresses. For more information, see the <i>Public IPv4 Address</i> tab on
         * the <a href="http://aws.amazon.com/vpc/pricing/">Amazon VPC pricing page</a>.
         * </p>
         * 
         * @param mapPublicIpOnLaunch
         *        Specify <code>true</code> to indicate that network interfaces attached to instances created in the
         *        specified subnet should be assigned a public IPv4 address.</p>
         *        <p>
         *        Amazon Web Services charges for all public IPv4 addresses, including public IPv4 addresses associated
         *        with running instances and Elastic IP addresses. For more information, see the <i>Public IPv4
         *        Address</i> tab on the <a href="http://aws.amazon.com/vpc/pricing/">Amazon VPC pricing page</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapPublicIpOnLaunch(AttributeBooleanValue mapPublicIpOnLaunch);

        /**
         * <p>
         * Specify <code>true</code> to indicate that network interfaces attached to instances created in the specified
         * subnet should be assigned a public IPv4 address.
         * </p>
         * <p>
         * Amazon Web Services charges for all public IPv4 addresses, including public IPv4 addresses associated with
         * running instances and Elastic IP addresses. For more information, see the <i>Public IPv4 Address</i> tab on
         * the <a href="http://aws.amazon.com/vpc/pricing/">Amazon VPC pricing page</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeBooleanValue.Builder} avoiding
         * the need to create one manually via {@link AttributeBooleanValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeBooleanValue.Builder#build()} is called immediately and
         * its result is passed to {@link #mapPublicIpOnLaunch(AttributeBooleanValue)}.
         * 
         * @param mapPublicIpOnLaunch
         *        a consumer that will call methods on {@link AttributeBooleanValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mapPublicIpOnLaunch(AttributeBooleanValue)
         */
        default Builder mapPublicIpOnLaunch(Consumer<AttributeBooleanValue.Builder> mapPublicIpOnLaunch) {
            return mapPublicIpOnLaunch(AttributeBooleanValue.builder().applyMutation(mapPublicIpOnLaunch).build());
        }

        /**
         * <p>
         * The ID of the subnet.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * Specify <code>true</code> to indicate that network interfaces attached to instances created in the specified
         * subnet should be assigned a customer-owned IPv4 address.
         * </p>
         * <p>
         * When this value is <code>true</code>, you must specify the customer-owned IP pool using
         * <code>CustomerOwnedIpv4Pool</code>.
         * </p>
         * 
         * @param mapCustomerOwnedIpOnLaunch
         *        Specify <code>true</code> to indicate that network interfaces attached to instances created in the
         *        specified subnet should be assigned a customer-owned IPv4 address.</p>
         *        <p>
         *        When this value is <code>true</code>, you must specify the customer-owned IP pool using
         *        <code>CustomerOwnedIpv4Pool</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapCustomerOwnedIpOnLaunch(AttributeBooleanValue mapCustomerOwnedIpOnLaunch);

        /**
         * <p>
         * Specify <code>true</code> to indicate that network interfaces attached to instances created in the specified
         * subnet should be assigned a customer-owned IPv4 address.
         * </p>
         * <p>
         * When this value is <code>true</code>, you must specify the customer-owned IP pool using
         * <code>CustomerOwnedIpv4Pool</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeBooleanValue.Builder} avoiding
         * the need to create one manually via {@link AttributeBooleanValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeBooleanValue.Builder#build()} is called immediately and
         * its result is passed to {@link #mapCustomerOwnedIpOnLaunch(AttributeBooleanValue)}.
         * 
         * @param mapCustomerOwnedIpOnLaunch
         *        a consumer that will call methods on {@link AttributeBooleanValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mapCustomerOwnedIpOnLaunch(AttributeBooleanValue)
         */
        default Builder mapCustomerOwnedIpOnLaunch(Consumer<AttributeBooleanValue.Builder> mapCustomerOwnedIpOnLaunch) {
            return mapCustomerOwnedIpOnLaunch(AttributeBooleanValue.builder().applyMutation(mapCustomerOwnedIpOnLaunch).build());
        }

        /**
         * <p>
         * The customer-owned IPv4 address pool associated with the subnet.
         * </p>
         * <p>
         * You must set this value when you specify <code>true</code> for <code>MapCustomerOwnedIpOnLaunch</code>.
         * </p>
         * 
         * @param customerOwnedIpv4Pool
         *        The customer-owned IPv4 address pool associated with the subnet.</p>
         *        <p>
         *        You must set this value when you specify <code>true</code> for <code>MapCustomerOwnedIpOnLaunch</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerOwnedIpv4Pool(String customerOwnedIpv4Pool);

        /**
         * <p>
         * Indicates whether DNS queries made to the Amazon-provided DNS Resolver in this subnet should return synthetic
         * IPv6 addresses for IPv4-only destinations.
         * </p>
         * <p>
         * You must first configure a NAT gateway in a public subnet (separate from the subnet containing the IPv6-only
         * workloads). For example, the subnet containing the NAT gateway should have a <code>0.0.0.0/0</code> route
         * pointing to the internet gateway. For more information, see <a href=
         * "https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-nat64-dns64.html#nat-gateway-nat64-dns64-walkthrough"
         * >Configure DNS64 and NAT64</a> in the <i>Amazon VPC User Guide</i>.
         * </p>
         * 
         * @param enableDns64
         *        Indicates whether DNS queries made to the Amazon-provided DNS Resolver in this subnet should return
         *        synthetic IPv6 addresses for IPv4-only destinations.</p>
         *        <p>
         *        You must first configure a NAT gateway in a public subnet (separate from the subnet containing the
         *        IPv6-only workloads). For example, the subnet containing the NAT gateway should have a
         *        <code>0.0.0.0/0</code> route pointing to the internet gateway. For more information, see <a href=
         *        "https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-nat64-dns64.html#nat-gateway-nat64-dns64-walkthrough"
         *        >Configure DNS64 and NAT64</a> in the <i>Amazon VPC User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableDns64(AttributeBooleanValue enableDns64);

        /**
         * <p>
         * Indicates whether DNS queries made to the Amazon-provided DNS Resolver in this subnet should return synthetic
         * IPv6 addresses for IPv4-only destinations.
         * </p>
         * <p>
         * You must first configure a NAT gateway in a public subnet (separate from the subnet containing the IPv6-only
         * workloads). For example, the subnet containing the NAT gateway should have a <code>0.0.0.0/0</code> route
         * pointing to the internet gateway. For more information, see <a href=
         * "https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-nat64-dns64.html#nat-gateway-nat64-dns64-walkthrough"
         * >Configure DNS64 and NAT64</a> in the <i>Amazon VPC User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeBooleanValue.Builder} avoiding
         * the need to create one manually via {@link AttributeBooleanValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeBooleanValue.Builder#build()} is called immediately and
         * its result is passed to {@link #enableDns64(AttributeBooleanValue)}.
         * 
         * @param enableDns64
         *        a consumer that will call methods on {@link AttributeBooleanValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enableDns64(AttributeBooleanValue)
         */
        default Builder enableDns64(Consumer<AttributeBooleanValue.Builder> enableDns64) {
            return enableDns64(AttributeBooleanValue.builder().applyMutation(enableDns64).build());
        }

        /**
         * <p>
         * The type of hostname to assign to instances in the subnet at launch. For IPv4-only and dual-stack (IPv4 and
         * IPv6) subnets, an instance DNS name can be based on the instance IPv4 address (ip-name) or the instance ID
         * (resource-name). For IPv6 only subnets, an instance DNS name must be based on the instance ID
         * (resource-name).
         * </p>
         * 
         * @param privateDnsHostnameTypeOnLaunch
         *        The type of hostname to assign to instances in the subnet at launch. For IPv4-only and dual-stack
         *        (IPv4 and IPv6) subnets, an instance DNS name can be based on the instance IPv4 address (ip-name) or
         *        the instance ID (resource-name). For IPv6 only subnets, an instance DNS name must be based on the
         *        instance ID (resource-name).
         * @see HostnameType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HostnameType
         */
        Builder privateDnsHostnameTypeOnLaunch(String privateDnsHostnameTypeOnLaunch);

        /**
         * <p>
         * The type of hostname to assign to instances in the subnet at launch. For IPv4-only and dual-stack (IPv4 and
         * IPv6) subnets, an instance DNS name can be based on the instance IPv4 address (ip-name) or the instance ID
         * (resource-name). For IPv6 only subnets, an instance DNS name must be based on the instance ID
         * (resource-name).
         * </p>
         * 
         * @param privateDnsHostnameTypeOnLaunch
         *        The type of hostname to assign to instances in the subnet at launch. For IPv4-only and dual-stack
         *        (IPv4 and IPv6) subnets, an instance DNS name can be based on the instance IPv4 address (ip-name) or
         *        the instance ID (resource-name). For IPv6 only subnets, an instance DNS name must be based on the
         *        instance ID (resource-name).
         * @see HostnameType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HostnameType
         */
        Builder privateDnsHostnameTypeOnLaunch(HostnameType privateDnsHostnameTypeOnLaunch);

        /**
         * <p>
         * Indicates whether to respond to DNS queries for instance hostnames with DNS A records.
         * </p>
         * 
         * @param enableResourceNameDnsARecordOnLaunch
         *        Indicates whether to respond to DNS queries for instance hostnames with DNS A records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableResourceNameDnsARecordOnLaunch(AttributeBooleanValue enableResourceNameDnsARecordOnLaunch);

        /**
         * <p>
         * Indicates whether to respond to DNS queries for instance hostnames with DNS A records.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeBooleanValue.Builder} avoiding
         * the need to create one manually via {@link AttributeBooleanValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeBooleanValue.Builder#build()} is called immediately and
         * its result is passed to {@link #enableResourceNameDnsARecordOnLaunch(AttributeBooleanValue)}.
         * 
         * @param enableResourceNameDnsARecordOnLaunch
         *        a consumer that will call methods on {@link AttributeBooleanValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enableResourceNameDnsARecordOnLaunch(AttributeBooleanValue)
         */
        default Builder enableResourceNameDnsARecordOnLaunch(
                Consumer<AttributeBooleanValue.Builder> enableResourceNameDnsARecordOnLaunch) {
            return enableResourceNameDnsARecordOnLaunch(AttributeBooleanValue.builder()
                    .applyMutation(enableResourceNameDnsARecordOnLaunch).build());
        }

        /**
         * <p>
         * Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.
         * </p>
         * 
         * @param enableResourceNameDnsAAAARecordOnLaunch
         *        Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableResourceNameDnsAAAARecordOnLaunch(AttributeBooleanValue enableResourceNameDnsAAAARecordOnLaunch);

        /**
         * <p>
         * Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeBooleanValue.Builder} avoiding
         * the need to create one manually via {@link AttributeBooleanValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeBooleanValue.Builder#build()} is called immediately and
         * its result is passed to {@link #enableResourceNameDnsAAAARecordOnLaunch(AttributeBooleanValue)}.
         * 
         * @param enableResourceNameDnsAAAARecordOnLaunch
         *        a consumer that will call methods on {@link AttributeBooleanValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enableResourceNameDnsAAAARecordOnLaunch(AttributeBooleanValue)
         */
        default Builder enableResourceNameDnsAAAARecordOnLaunch(
                Consumer<AttributeBooleanValue.Builder> enableResourceNameDnsAAAARecordOnLaunch) {
            return enableResourceNameDnsAAAARecordOnLaunch(AttributeBooleanValue.builder()
                    .applyMutation(enableResourceNameDnsAAAARecordOnLaunch).build());
        }

        /**
         * <p>
         * Indicates the device position for local network interfaces in this subnet. For example, <code>1</code>
         * indicates local network interfaces in this subnet are the secondary network interface (eth1). A local network
         * interface cannot be the primary network interface (eth0).
         * </p>
         * 
         * @param enableLniAtDeviceIndex
         *        Indicates the device position for local network interfaces in this subnet. For example, <code>1</code>
         *        indicates local network interfaces in this subnet are the secondary network interface (eth1). A local
         *        network interface cannot be the primary network interface (eth0).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableLniAtDeviceIndex(Integer enableLniAtDeviceIndex);

        /**
         * <p>
         * Specify <code>true</code> to indicate that local network interfaces at the current position should be
         * disabled.
         * </p>
         * 
         * @param disableLniAtDeviceIndex
         *        Specify <code>true</code> to indicate that local network interfaces at the current position should be
         *        disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableLniAtDeviceIndex(AttributeBooleanValue disableLniAtDeviceIndex);

        /**
         * <p>
         * Specify <code>true</code> to indicate that local network interfaces at the current position should be
         * disabled.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeBooleanValue.Builder} avoiding
         * the need to create one manually via {@link AttributeBooleanValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeBooleanValue.Builder#build()} is called immediately and
         * its result is passed to {@link #disableLniAtDeviceIndex(AttributeBooleanValue)}.
         * 
         * @param disableLniAtDeviceIndex
         *        a consumer that will call methods on {@link AttributeBooleanValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #disableLniAtDeviceIndex(AttributeBooleanValue)
         */
        default Builder disableLniAtDeviceIndex(Consumer<AttributeBooleanValue.Builder> disableLniAtDeviceIndex) {
            return disableLniAtDeviceIndex(AttributeBooleanValue.builder().applyMutation(disableLniAtDeviceIndex).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private AttributeBooleanValue assignIpv6AddressOnCreation;

        private AttributeBooleanValue mapPublicIpOnLaunch;

        private String subnetId;

        private AttributeBooleanValue mapCustomerOwnedIpOnLaunch;

        private String customerOwnedIpv4Pool;

        private AttributeBooleanValue enableDns64;

        private String privateDnsHostnameTypeOnLaunch;

        private AttributeBooleanValue enableResourceNameDnsARecordOnLaunch;

        private AttributeBooleanValue enableResourceNameDnsAAAARecordOnLaunch;

        private Integer enableLniAtDeviceIndex;

        private AttributeBooleanValue disableLniAtDeviceIndex;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifySubnetAttributeRequest model) {
            super(model);
            assignIpv6AddressOnCreation(model.assignIpv6AddressOnCreation);
            mapPublicIpOnLaunch(model.mapPublicIpOnLaunch);
            subnetId(model.subnetId);
            mapCustomerOwnedIpOnLaunch(model.mapCustomerOwnedIpOnLaunch);
            customerOwnedIpv4Pool(model.customerOwnedIpv4Pool);
            enableDns64(model.enableDns64);
            privateDnsHostnameTypeOnLaunch(model.privateDnsHostnameTypeOnLaunch);
            enableResourceNameDnsARecordOnLaunch(model.enableResourceNameDnsARecordOnLaunch);
            enableResourceNameDnsAAAARecordOnLaunch(model.enableResourceNameDnsAAAARecordOnLaunch);
            enableLniAtDeviceIndex(model.enableLniAtDeviceIndex);
            disableLniAtDeviceIndex(model.disableLniAtDeviceIndex);
        }

        public final AttributeBooleanValue.Builder getAssignIpv6AddressOnCreation() {
            return assignIpv6AddressOnCreation != null ? assignIpv6AddressOnCreation.toBuilder() : null;
        }

        public final void setAssignIpv6AddressOnCreation(AttributeBooleanValue.BuilderImpl assignIpv6AddressOnCreation) {
            this.assignIpv6AddressOnCreation = assignIpv6AddressOnCreation != null ? assignIpv6AddressOnCreation.build() : null;
        }

        @Override
        public final Builder assignIpv6AddressOnCreation(AttributeBooleanValue assignIpv6AddressOnCreation) {
            this.assignIpv6AddressOnCreation = assignIpv6AddressOnCreation;
            return this;
        }

        public final AttributeBooleanValue.Builder getMapPublicIpOnLaunch() {
            return mapPublicIpOnLaunch != null ? mapPublicIpOnLaunch.toBuilder() : null;
        }

        public final void setMapPublicIpOnLaunch(AttributeBooleanValue.BuilderImpl mapPublicIpOnLaunch) {
            this.mapPublicIpOnLaunch = mapPublicIpOnLaunch != null ? mapPublicIpOnLaunch.build() : null;
        }

        @Override
        public final Builder mapPublicIpOnLaunch(AttributeBooleanValue mapPublicIpOnLaunch) {
            this.mapPublicIpOnLaunch = mapPublicIpOnLaunch;
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final AttributeBooleanValue.Builder getMapCustomerOwnedIpOnLaunch() {
            return mapCustomerOwnedIpOnLaunch != null ? mapCustomerOwnedIpOnLaunch.toBuilder() : null;
        }

        public final void setMapCustomerOwnedIpOnLaunch(AttributeBooleanValue.BuilderImpl mapCustomerOwnedIpOnLaunch) {
            this.mapCustomerOwnedIpOnLaunch = mapCustomerOwnedIpOnLaunch != null ? mapCustomerOwnedIpOnLaunch.build() : null;
        }

        @Override
        public final Builder mapCustomerOwnedIpOnLaunch(AttributeBooleanValue mapCustomerOwnedIpOnLaunch) {
            this.mapCustomerOwnedIpOnLaunch = mapCustomerOwnedIpOnLaunch;
            return this;
        }

        public final String getCustomerOwnedIpv4Pool() {
            return customerOwnedIpv4Pool;
        }

        public final void setCustomerOwnedIpv4Pool(String customerOwnedIpv4Pool) {
            this.customerOwnedIpv4Pool = customerOwnedIpv4Pool;
        }

        @Override
        public final Builder customerOwnedIpv4Pool(String customerOwnedIpv4Pool) {
            this.customerOwnedIpv4Pool = customerOwnedIpv4Pool;
            return this;
        }

        public final AttributeBooleanValue.Builder getEnableDns64() {
            return enableDns64 != null ? enableDns64.toBuilder() : null;
        }

        public final void setEnableDns64(AttributeBooleanValue.BuilderImpl enableDns64) {
            this.enableDns64 = enableDns64 != null ? enableDns64.build() : null;
        }

        @Override
        public final Builder enableDns64(AttributeBooleanValue enableDns64) {
            this.enableDns64 = enableDns64;
            return this;
        }

        public final String getPrivateDnsHostnameTypeOnLaunch() {
            return privateDnsHostnameTypeOnLaunch;
        }

        public final void setPrivateDnsHostnameTypeOnLaunch(String privateDnsHostnameTypeOnLaunch) {
            this.privateDnsHostnameTypeOnLaunch = privateDnsHostnameTypeOnLaunch;
        }

        @Override
        public final Builder privateDnsHostnameTypeOnLaunch(String privateDnsHostnameTypeOnLaunch) {
            this.privateDnsHostnameTypeOnLaunch = privateDnsHostnameTypeOnLaunch;
            return this;
        }

        @Override
        public final Builder privateDnsHostnameTypeOnLaunch(HostnameType privateDnsHostnameTypeOnLaunch) {
            this.privateDnsHostnameTypeOnLaunch(privateDnsHostnameTypeOnLaunch == null ? null : privateDnsHostnameTypeOnLaunch
                    .toString());
            return this;
        }

        public final AttributeBooleanValue.Builder getEnableResourceNameDnsARecordOnLaunch() {
            return enableResourceNameDnsARecordOnLaunch != null ? enableResourceNameDnsARecordOnLaunch.toBuilder() : null;
        }

        public final void setEnableResourceNameDnsARecordOnLaunch(
                AttributeBooleanValue.BuilderImpl enableResourceNameDnsARecordOnLaunch) {
            this.enableResourceNameDnsARecordOnLaunch = enableResourceNameDnsARecordOnLaunch != null ? enableResourceNameDnsARecordOnLaunch
                    .build() : null;
        }

        @Override
        public final Builder enableResourceNameDnsARecordOnLaunch(AttributeBooleanValue enableResourceNameDnsARecordOnLaunch) {
            this.enableResourceNameDnsARecordOnLaunch = enableResourceNameDnsARecordOnLaunch;
            return this;
        }

        public final AttributeBooleanValue.Builder getEnableResourceNameDnsAAAARecordOnLaunch() {
            return enableResourceNameDnsAAAARecordOnLaunch != null ? enableResourceNameDnsAAAARecordOnLaunch.toBuilder() : null;
        }

        public final void setEnableResourceNameDnsAAAARecordOnLaunch(
                AttributeBooleanValue.BuilderImpl enableResourceNameDnsAAAARecordOnLaunch) {
            this.enableResourceNameDnsAAAARecordOnLaunch = enableResourceNameDnsAAAARecordOnLaunch != null ? enableResourceNameDnsAAAARecordOnLaunch
                    .build() : null;
        }

        @Override
        public final Builder enableResourceNameDnsAAAARecordOnLaunch(AttributeBooleanValue enableResourceNameDnsAAAARecordOnLaunch) {
            this.enableResourceNameDnsAAAARecordOnLaunch = enableResourceNameDnsAAAARecordOnLaunch;
            return this;
        }

        public final Integer getEnableLniAtDeviceIndex() {
            return enableLniAtDeviceIndex;
        }

        public final void setEnableLniAtDeviceIndex(Integer enableLniAtDeviceIndex) {
            this.enableLniAtDeviceIndex = enableLniAtDeviceIndex;
        }

        @Override
        public final Builder enableLniAtDeviceIndex(Integer enableLniAtDeviceIndex) {
            this.enableLniAtDeviceIndex = enableLniAtDeviceIndex;
            return this;
        }

        public final AttributeBooleanValue.Builder getDisableLniAtDeviceIndex() {
            return disableLniAtDeviceIndex != null ? disableLniAtDeviceIndex.toBuilder() : null;
        }

        public final void setDisableLniAtDeviceIndex(AttributeBooleanValue.BuilderImpl disableLniAtDeviceIndex) {
            this.disableLniAtDeviceIndex = disableLniAtDeviceIndex != null ? disableLniAtDeviceIndex.build() : null;
        }

        @Override
        public final Builder disableLniAtDeviceIndex(AttributeBooleanValue disableLniAtDeviceIndex) {
            this.disableLniAtDeviceIndex = disableLniAtDeviceIndex;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifySubnetAttributeRequest build() {
            return new ModifySubnetAttributeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
