/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the options for a transit gateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransitGatewayOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<TransitGatewayOptions.Builder, TransitGatewayOptions> {
    private static final SdkField<Long> AMAZON_SIDE_ASN_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("AmazonSideAsn")
            .getter(getter(TransitGatewayOptions::amazonSideAsn))
            .setter(setter(Builder::amazonSideAsn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonSideAsn")
                    .unmarshallLocationName("amazonSideAsn").build()).build();

    private static final SdkField<List<String>> TRANSIT_GATEWAY_CIDR_BLOCKS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TransitGatewayCidrBlocks")
            .getter(getter(TransitGatewayOptions::transitGatewayCidrBlocks))
            .setter(setter(Builder::transitGatewayCidrBlocks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayCidrBlocks")
                    .unmarshallLocationName("transitGatewayCidrBlocks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> AUTO_ACCEPT_SHARED_ATTACHMENTS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AutoAcceptSharedAttachments")
            .getter(getter(TransitGatewayOptions::autoAcceptSharedAttachmentsAsString))
            .setter(setter(Builder::autoAcceptSharedAttachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoAcceptSharedAttachments")
                    .unmarshallLocationName("autoAcceptSharedAttachments").build()).build();

    private static final SdkField<String> DEFAULT_ROUTE_TABLE_ASSOCIATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DefaultRouteTableAssociation")
            .getter(getter(TransitGatewayOptions::defaultRouteTableAssociationAsString))
            .setter(setter(Builder::defaultRouteTableAssociation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRouteTableAssociation")
                    .unmarshallLocationName("defaultRouteTableAssociation").build()).build();

    private static final SdkField<String> ASSOCIATION_DEFAULT_ROUTE_TABLE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AssociationDefaultRouteTableId")
            .getter(getter(TransitGatewayOptions::associationDefaultRouteTableId))
            .setter(setter(Builder::associationDefaultRouteTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationDefaultRouteTableId")
                    .unmarshallLocationName("associationDefaultRouteTableId").build()).build();

    private static final SdkField<String> DEFAULT_ROUTE_TABLE_PROPAGATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DefaultRouteTablePropagation")
            .getter(getter(TransitGatewayOptions::defaultRouteTablePropagationAsString))
            .setter(setter(Builder::defaultRouteTablePropagation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRouteTablePropagation")
                    .unmarshallLocationName("defaultRouteTablePropagation").build()).build();

    private static final SdkField<String> PROPAGATION_DEFAULT_ROUTE_TABLE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PropagationDefaultRouteTableId")
            .getter(getter(TransitGatewayOptions::propagationDefaultRouteTableId))
            .setter(setter(Builder::propagationDefaultRouteTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropagationDefaultRouteTableId")
                    .unmarshallLocationName("propagationDefaultRouteTableId").build()).build();

    private static final SdkField<String> VPN_ECMP_SUPPORT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpnEcmpSupport")
            .getter(getter(TransitGatewayOptions::vpnEcmpSupportAsString))
            .setter(setter(Builder::vpnEcmpSupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnEcmpSupport")
                    .unmarshallLocationName("vpnEcmpSupport").build()).build();

    private static final SdkField<String> DNS_SUPPORT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DnsSupport")
            .getter(getter(TransitGatewayOptions::dnsSupportAsString))
            .setter(setter(Builder::dnsSupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsSupport")
                    .unmarshallLocationName("dnsSupport").build()).build();

    private static final SdkField<String> SECURITY_GROUP_REFERENCING_SUPPORT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecurityGroupReferencingSupport")
            .getter(getter(TransitGatewayOptions::securityGroupReferencingSupportAsString))
            .setter(setter(Builder::securityGroupReferencingSupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupReferencingSupport")
                    .unmarshallLocationName("securityGroupReferencingSupport").build()).build();

    private static final SdkField<String> MULTICAST_SUPPORT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MulticastSupport")
            .getter(getter(TransitGatewayOptions::multicastSupportAsString))
            .setter(setter(Builder::multicastSupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MulticastSupport")
                    .unmarshallLocationName("multicastSupport").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMAZON_SIDE_ASN_FIELD,
            TRANSIT_GATEWAY_CIDR_BLOCKS_FIELD, AUTO_ACCEPT_SHARED_ATTACHMENTS_FIELD, DEFAULT_ROUTE_TABLE_ASSOCIATION_FIELD,
            ASSOCIATION_DEFAULT_ROUTE_TABLE_ID_FIELD, DEFAULT_ROUTE_TABLE_PROPAGATION_FIELD,
            PROPAGATION_DEFAULT_ROUTE_TABLE_ID_FIELD, VPN_ECMP_SUPPORT_FIELD, DNS_SUPPORT_FIELD,
            SECURITY_GROUP_REFERENCING_SUPPORT_FIELD, MULTICAST_SUPPORT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long amazonSideAsn;

    private final List<String> transitGatewayCidrBlocks;

    private final String autoAcceptSharedAttachments;

    private final String defaultRouteTableAssociation;

    private final String associationDefaultRouteTableId;

    private final String defaultRouteTablePropagation;

    private final String propagationDefaultRouteTableId;

    private final String vpnEcmpSupport;

    private final String dnsSupport;

    private final String securityGroupReferencingSupport;

    private final String multicastSupport;

    private TransitGatewayOptions(BuilderImpl builder) {
        this.amazonSideAsn = builder.amazonSideAsn;
        this.transitGatewayCidrBlocks = builder.transitGatewayCidrBlocks;
        this.autoAcceptSharedAttachments = builder.autoAcceptSharedAttachments;
        this.defaultRouteTableAssociation = builder.defaultRouteTableAssociation;
        this.associationDefaultRouteTableId = builder.associationDefaultRouteTableId;
        this.defaultRouteTablePropagation = builder.defaultRouteTablePropagation;
        this.propagationDefaultRouteTableId = builder.propagationDefaultRouteTableId;
        this.vpnEcmpSupport = builder.vpnEcmpSupport;
        this.dnsSupport = builder.dnsSupport;
        this.securityGroupReferencingSupport = builder.securityGroupReferencingSupport;
        this.multicastSupport = builder.multicastSupport;
    }

    /**
     * <p>
     * A private Autonomous System Number (ASN) for the Amazon side of a BGP session. The range is 64512 to 65534 for
     * 16-bit ASNs and 4200000000 to 4294967294 for 32-bit ASNs.
     * </p>
     * 
     * @return A private Autonomous System Number (ASN) for the Amazon side of a BGP session. The range is 64512 to
     *         65534 for 16-bit ASNs and 4200000000 to 4294967294 for 32-bit ASNs.
     */
    public final Long amazonSideAsn() {
        return amazonSideAsn;
    }

    /**
     * For responses, this returns true if the service returned a value for the TransitGatewayCidrBlocks property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTransitGatewayCidrBlocks() {
        return transitGatewayCidrBlocks != null && !(transitGatewayCidrBlocks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The transit gateway CIDR blocks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTransitGatewayCidrBlocks} method.
     * </p>
     * 
     * @return The transit gateway CIDR blocks.
     */
    public final List<String> transitGatewayCidrBlocks() {
        return transitGatewayCidrBlocks;
    }

    /**
     * <p>
     * Indicates whether attachment requests are automatically accepted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autoAcceptSharedAttachments} will return {@link AutoAcceptSharedAttachmentsValue#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #autoAcceptSharedAttachmentsAsString}.
     * </p>
     * 
     * @return Indicates whether attachment requests are automatically accepted.
     * @see AutoAcceptSharedAttachmentsValue
     */
    public final AutoAcceptSharedAttachmentsValue autoAcceptSharedAttachments() {
        return AutoAcceptSharedAttachmentsValue.fromValue(autoAcceptSharedAttachments);
    }

    /**
     * <p>
     * Indicates whether attachment requests are automatically accepted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autoAcceptSharedAttachments} will return {@link AutoAcceptSharedAttachmentsValue#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #autoAcceptSharedAttachmentsAsString}.
     * </p>
     * 
     * @return Indicates whether attachment requests are automatically accepted.
     * @see AutoAcceptSharedAttachmentsValue
     */
    public final String autoAcceptSharedAttachmentsAsString() {
        return autoAcceptSharedAttachments;
    }

    /**
     * <p>
     * Indicates whether resource attachments are automatically associated with the default association route table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultRouteTableAssociation} will return
     * {@link DefaultRouteTableAssociationValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #defaultRouteTableAssociationAsString}.
     * </p>
     * 
     * @return Indicates whether resource attachments are automatically associated with the default association route
     *         table.
     * @see DefaultRouteTableAssociationValue
     */
    public final DefaultRouteTableAssociationValue defaultRouteTableAssociation() {
        return DefaultRouteTableAssociationValue.fromValue(defaultRouteTableAssociation);
    }

    /**
     * <p>
     * Indicates whether resource attachments are automatically associated with the default association route table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultRouteTableAssociation} will return
     * {@link DefaultRouteTableAssociationValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #defaultRouteTableAssociationAsString}.
     * </p>
     * 
     * @return Indicates whether resource attachments are automatically associated with the default association route
     *         table.
     * @see DefaultRouteTableAssociationValue
     */
    public final String defaultRouteTableAssociationAsString() {
        return defaultRouteTableAssociation;
    }

    /**
     * <p>
     * The ID of the default association route table.
     * </p>
     * 
     * @return The ID of the default association route table.
     */
    public final String associationDefaultRouteTableId() {
        return associationDefaultRouteTableId;
    }

    /**
     * <p>
     * Indicates whether resource attachments automatically propagate routes to the default propagation route table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultRouteTablePropagation} will return
     * {@link DefaultRouteTablePropagationValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #defaultRouteTablePropagationAsString}.
     * </p>
     * 
     * @return Indicates whether resource attachments automatically propagate routes to the default propagation route
     *         table.
     * @see DefaultRouteTablePropagationValue
     */
    public final DefaultRouteTablePropagationValue defaultRouteTablePropagation() {
        return DefaultRouteTablePropagationValue.fromValue(defaultRouteTablePropagation);
    }

    /**
     * <p>
     * Indicates whether resource attachments automatically propagate routes to the default propagation route table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultRouteTablePropagation} will return
     * {@link DefaultRouteTablePropagationValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #defaultRouteTablePropagationAsString}.
     * </p>
     * 
     * @return Indicates whether resource attachments automatically propagate routes to the default propagation route
     *         table.
     * @see DefaultRouteTablePropagationValue
     */
    public final String defaultRouteTablePropagationAsString() {
        return defaultRouteTablePropagation;
    }

    /**
     * <p>
     * The ID of the default propagation route table.
     * </p>
     * 
     * @return The ID of the default propagation route table.
     */
    public final String propagationDefaultRouteTableId() {
        return propagationDefaultRouteTableId;
    }

    /**
     * <p>
     * Indicates whether Equal Cost Multipath Protocol support is enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vpnEcmpSupport}
     * will return {@link VpnEcmpSupportValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #vpnEcmpSupportAsString}.
     * </p>
     * 
     * @return Indicates whether Equal Cost Multipath Protocol support is enabled.
     * @see VpnEcmpSupportValue
     */
    public final VpnEcmpSupportValue vpnEcmpSupport() {
        return VpnEcmpSupportValue.fromValue(vpnEcmpSupport);
    }

    /**
     * <p>
     * Indicates whether Equal Cost Multipath Protocol support is enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vpnEcmpSupport}
     * will return {@link VpnEcmpSupportValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #vpnEcmpSupportAsString}.
     * </p>
     * 
     * @return Indicates whether Equal Cost Multipath Protocol support is enabled.
     * @see VpnEcmpSupportValue
     */
    public final String vpnEcmpSupportAsString() {
        return vpnEcmpSupport;
    }

    /**
     * <p>
     * Indicates whether DNS support is enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dnsSupport} will
     * return {@link DnsSupportValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dnsSupportAsString}.
     * </p>
     * 
     * @return Indicates whether DNS support is enabled.
     * @see DnsSupportValue
     */
    public final DnsSupportValue dnsSupport() {
        return DnsSupportValue.fromValue(dnsSupport);
    }

    /**
     * <p>
     * Indicates whether DNS support is enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dnsSupport} will
     * return {@link DnsSupportValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dnsSupportAsString}.
     * </p>
     * 
     * @return Indicates whether DNS support is enabled.
     * @see DnsSupportValue
     */
    public final String dnsSupportAsString() {
        return dnsSupport;
    }

    /**
     * <p>
     * Enables you to reference a security group across VPCs attached to a transit gateway to simplify security group
     * management.
     * </p>
     * <p>
     * This option is disabled by default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #securityGroupReferencingSupport} will return
     * {@link SecurityGroupReferencingSupportValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #securityGroupReferencingSupportAsString}.
     * </p>
     * 
     * @return Enables you to reference a security group across VPCs attached to a transit gateway to simplify security
     *         group management. </p>
     *         <p>
     *         This option is disabled by default.
     * @see SecurityGroupReferencingSupportValue
     */
    public final SecurityGroupReferencingSupportValue securityGroupReferencingSupport() {
        return SecurityGroupReferencingSupportValue.fromValue(securityGroupReferencingSupport);
    }

    /**
     * <p>
     * Enables you to reference a security group across VPCs attached to a transit gateway to simplify security group
     * management.
     * </p>
     * <p>
     * This option is disabled by default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #securityGroupReferencingSupport} will return
     * {@link SecurityGroupReferencingSupportValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #securityGroupReferencingSupportAsString}.
     * </p>
     * 
     * @return Enables you to reference a security group across VPCs attached to a transit gateway to simplify security
     *         group management. </p>
     *         <p>
     *         This option is disabled by default.
     * @see SecurityGroupReferencingSupportValue
     */
    public final String securityGroupReferencingSupportAsString() {
        return securityGroupReferencingSupport;
    }

    /**
     * <p>
     * Indicates whether multicast is enabled on the transit gateway
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #multicastSupport}
     * will return {@link MulticastSupportValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #multicastSupportAsString}.
     * </p>
     * 
     * @return Indicates whether multicast is enabled on the transit gateway
     * @see MulticastSupportValue
     */
    public final MulticastSupportValue multicastSupport() {
        return MulticastSupportValue.fromValue(multicastSupport);
    }

    /**
     * <p>
     * Indicates whether multicast is enabled on the transit gateway
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #multicastSupport}
     * will return {@link MulticastSupportValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #multicastSupportAsString}.
     * </p>
     * 
     * @return Indicates whether multicast is enabled on the transit gateway
     * @see MulticastSupportValue
     */
    public final String multicastSupportAsString() {
        return multicastSupport;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amazonSideAsn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTransitGatewayCidrBlocks() ? transitGatewayCidrBlocks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(autoAcceptSharedAttachmentsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(defaultRouteTableAssociationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(associationDefaultRouteTableId());
        hashCode = 31 * hashCode + Objects.hashCode(defaultRouteTablePropagationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(propagationDefaultRouteTableId());
        hashCode = 31 * hashCode + Objects.hashCode(vpnEcmpSupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dnsSupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroupReferencingSupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(multicastSupportAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayOptions)) {
            return false;
        }
        TransitGatewayOptions other = (TransitGatewayOptions) obj;
        return Objects.equals(amazonSideAsn(), other.amazonSideAsn())
                && hasTransitGatewayCidrBlocks() == other.hasTransitGatewayCidrBlocks()
                && Objects.equals(transitGatewayCidrBlocks(), other.transitGatewayCidrBlocks())
                && Objects.equals(autoAcceptSharedAttachmentsAsString(), other.autoAcceptSharedAttachmentsAsString())
                && Objects.equals(defaultRouteTableAssociationAsString(), other.defaultRouteTableAssociationAsString())
                && Objects.equals(associationDefaultRouteTableId(), other.associationDefaultRouteTableId())
                && Objects.equals(defaultRouteTablePropagationAsString(), other.defaultRouteTablePropagationAsString())
                && Objects.equals(propagationDefaultRouteTableId(), other.propagationDefaultRouteTableId())
                && Objects.equals(vpnEcmpSupportAsString(), other.vpnEcmpSupportAsString())
                && Objects.equals(dnsSupportAsString(), other.dnsSupportAsString())
                && Objects.equals(securityGroupReferencingSupportAsString(), other.securityGroupReferencingSupportAsString())
                && Objects.equals(multicastSupportAsString(), other.multicastSupportAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransitGatewayOptions").add("AmazonSideAsn", amazonSideAsn())
                .add("TransitGatewayCidrBlocks", hasTransitGatewayCidrBlocks() ? transitGatewayCidrBlocks() : null)
                .add("AutoAcceptSharedAttachments", autoAcceptSharedAttachmentsAsString())
                .add("DefaultRouteTableAssociation", defaultRouteTableAssociationAsString())
                .add("AssociationDefaultRouteTableId", associationDefaultRouteTableId())
                .add("DefaultRouteTablePropagation", defaultRouteTablePropagationAsString())
                .add("PropagationDefaultRouteTableId", propagationDefaultRouteTableId())
                .add("VpnEcmpSupport", vpnEcmpSupportAsString()).add("DnsSupport", dnsSupportAsString())
                .add("SecurityGroupReferencingSupport", securityGroupReferencingSupportAsString())
                .add("MulticastSupport", multicastSupportAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AmazonSideAsn":
            return Optional.ofNullable(clazz.cast(amazonSideAsn()));
        case "TransitGatewayCidrBlocks":
            return Optional.ofNullable(clazz.cast(transitGatewayCidrBlocks()));
        case "AutoAcceptSharedAttachments":
            return Optional.ofNullable(clazz.cast(autoAcceptSharedAttachmentsAsString()));
        case "DefaultRouteTableAssociation":
            return Optional.ofNullable(clazz.cast(defaultRouteTableAssociationAsString()));
        case "AssociationDefaultRouteTableId":
            return Optional.ofNullable(clazz.cast(associationDefaultRouteTableId()));
        case "DefaultRouteTablePropagation":
            return Optional.ofNullable(clazz.cast(defaultRouteTablePropagationAsString()));
        case "PropagationDefaultRouteTableId":
            return Optional.ofNullable(clazz.cast(propagationDefaultRouteTableId()));
        case "VpnEcmpSupport":
            return Optional.ofNullable(clazz.cast(vpnEcmpSupportAsString()));
        case "DnsSupport":
            return Optional.ofNullable(clazz.cast(dnsSupportAsString()));
        case "SecurityGroupReferencingSupport":
            return Optional.ofNullable(clazz.cast(securityGroupReferencingSupportAsString()));
        case "MulticastSupport":
            return Optional.ofNullable(clazz.cast(multicastSupportAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayOptions, T> g) {
        return obj -> g.apply((TransitGatewayOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransitGatewayOptions> {
        /**
         * <p>
         * A private Autonomous System Number (ASN) for the Amazon side of a BGP session. The range is 64512 to 65534
         * for 16-bit ASNs and 4200000000 to 4294967294 for 32-bit ASNs.
         * </p>
         * 
         * @param amazonSideAsn
         *        A private Autonomous System Number (ASN) for the Amazon side of a BGP session. The range is 64512 to
         *        65534 for 16-bit ASNs and 4200000000 to 4294967294 for 32-bit ASNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonSideAsn(Long amazonSideAsn);

        /**
         * <p>
         * The transit gateway CIDR blocks.
         * </p>
         * 
         * @param transitGatewayCidrBlocks
         *        The transit gateway CIDR blocks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayCidrBlocks(Collection<String> transitGatewayCidrBlocks);

        /**
         * <p>
         * The transit gateway CIDR blocks.
         * </p>
         * 
         * @param transitGatewayCidrBlocks
         *        The transit gateway CIDR blocks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayCidrBlocks(String... transitGatewayCidrBlocks);

        /**
         * <p>
         * Indicates whether attachment requests are automatically accepted.
         * </p>
         * 
         * @param autoAcceptSharedAttachments
         *        Indicates whether attachment requests are automatically accepted.
         * @see AutoAcceptSharedAttachmentsValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoAcceptSharedAttachmentsValue
         */
        Builder autoAcceptSharedAttachments(String autoAcceptSharedAttachments);

        /**
         * <p>
         * Indicates whether attachment requests are automatically accepted.
         * </p>
         * 
         * @param autoAcceptSharedAttachments
         *        Indicates whether attachment requests are automatically accepted.
         * @see AutoAcceptSharedAttachmentsValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoAcceptSharedAttachmentsValue
         */
        Builder autoAcceptSharedAttachments(AutoAcceptSharedAttachmentsValue autoAcceptSharedAttachments);

        /**
         * <p>
         * Indicates whether resource attachments are automatically associated with the default association route table.
         * </p>
         * 
         * @param defaultRouteTableAssociation
         *        Indicates whether resource attachments are automatically associated with the default association route
         *        table.
         * @see DefaultRouteTableAssociationValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultRouteTableAssociationValue
         */
        Builder defaultRouteTableAssociation(String defaultRouteTableAssociation);

        /**
         * <p>
         * Indicates whether resource attachments are automatically associated with the default association route table.
         * </p>
         * 
         * @param defaultRouteTableAssociation
         *        Indicates whether resource attachments are automatically associated with the default association route
         *        table.
         * @see DefaultRouteTableAssociationValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultRouteTableAssociationValue
         */
        Builder defaultRouteTableAssociation(DefaultRouteTableAssociationValue defaultRouteTableAssociation);

        /**
         * <p>
         * The ID of the default association route table.
         * </p>
         * 
         * @param associationDefaultRouteTableId
         *        The ID of the default association route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationDefaultRouteTableId(String associationDefaultRouteTableId);

        /**
         * <p>
         * Indicates whether resource attachments automatically propagate routes to the default propagation route table.
         * </p>
         * 
         * @param defaultRouteTablePropagation
         *        Indicates whether resource attachments automatically propagate routes to the default propagation route
         *        table.
         * @see DefaultRouteTablePropagationValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultRouteTablePropagationValue
         */
        Builder defaultRouteTablePropagation(String defaultRouteTablePropagation);

        /**
         * <p>
         * Indicates whether resource attachments automatically propagate routes to the default propagation route table.
         * </p>
         * 
         * @param defaultRouteTablePropagation
         *        Indicates whether resource attachments automatically propagate routes to the default propagation route
         *        table.
         * @see DefaultRouteTablePropagationValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultRouteTablePropagationValue
         */
        Builder defaultRouteTablePropagation(DefaultRouteTablePropagationValue defaultRouteTablePropagation);

        /**
         * <p>
         * The ID of the default propagation route table.
         * </p>
         * 
         * @param propagationDefaultRouteTableId
         *        The ID of the default propagation route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propagationDefaultRouteTableId(String propagationDefaultRouteTableId);

        /**
         * <p>
         * Indicates whether Equal Cost Multipath Protocol support is enabled.
         * </p>
         * 
         * @param vpnEcmpSupport
         *        Indicates whether Equal Cost Multipath Protocol support is enabled.
         * @see VpnEcmpSupportValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpnEcmpSupportValue
         */
        Builder vpnEcmpSupport(String vpnEcmpSupport);

        /**
         * <p>
         * Indicates whether Equal Cost Multipath Protocol support is enabled.
         * </p>
         * 
         * @param vpnEcmpSupport
         *        Indicates whether Equal Cost Multipath Protocol support is enabled.
         * @see VpnEcmpSupportValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpnEcmpSupportValue
         */
        Builder vpnEcmpSupport(VpnEcmpSupportValue vpnEcmpSupport);

        /**
         * <p>
         * Indicates whether DNS support is enabled.
         * </p>
         * 
         * @param dnsSupport
         *        Indicates whether DNS support is enabled.
         * @see DnsSupportValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsSupportValue
         */
        Builder dnsSupport(String dnsSupport);

        /**
         * <p>
         * Indicates whether DNS support is enabled.
         * </p>
         * 
         * @param dnsSupport
         *        Indicates whether DNS support is enabled.
         * @see DnsSupportValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsSupportValue
         */
        Builder dnsSupport(DnsSupportValue dnsSupport);

        /**
         * <p>
         * Enables you to reference a security group across VPCs attached to a transit gateway to simplify security
         * group management.
         * </p>
         * <p>
         * This option is disabled by default.
         * </p>
         * 
         * @param securityGroupReferencingSupport
         *        Enables you to reference a security group across VPCs attached to a transit gateway to simplify
         *        security group management. </p>
         *        <p>
         *        This option is disabled by default.
         * @see SecurityGroupReferencingSupportValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecurityGroupReferencingSupportValue
         */
        Builder securityGroupReferencingSupport(String securityGroupReferencingSupport);

        /**
         * <p>
         * Enables you to reference a security group across VPCs attached to a transit gateway to simplify security
         * group management.
         * </p>
         * <p>
         * This option is disabled by default.
         * </p>
         * 
         * @param securityGroupReferencingSupport
         *        Enables you to reference a security group across VPCs attached to a transit gateway to simplify
         *        security group management. </p>
         *        <p>
         *        This option is disabled by default.
         * @see SecurityGroupReferencingSupportValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecurityGroupReferencingSupportValue
         */
        Builder securityGroupReferencingSupport(SecurityGroupReferencingSupportValue securityGroupReferencingSupport);

        /**
         * <p>
         * Indicates whether multicast is enabled on the transit gateway
         * </p>
         * 
         * @param multicastSupport
         *        Indicates whether multicast is enabled on the transit gateway
         * @see MulticastSupportValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MulticastSupportValue
         */
        Builder multicastSupport(String multicastSupport);

        /**
         * <p>
         * Indicates whether multicast is enabled on the transit gateway
         * </p>
         * 
         * @param multicastSupport
         *        Indicates whether multicast is enabled on the transit gateway
         * @see MulticastSupportValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MulticastSupportValue
         */
        Builder multicastSupport(MulticastSupportValue multicastSupport);
    }

    static final class BuilderImpl implements Builder {
        private Long amazonSideAsn;

        private List<String> transitGatewayCidrBlocks = DefaultSdkAutoConstructList.getInstance();

        private String autoAcceptSharedAttachments;

        private String defaultRouteTableAssociation;

        private String associationDefaultRouteTableId;

        private String defaultRouteTablePropagation;

        private String propagationDefaultRouteTableId;

        private String vpnEcmpSupport;

        private String dnsSupport;

        private String securityGroupReferencingSupport;

        private String multicastSupport;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayOptions model) {
            amazonSideAsn(model.amazonSideAsn);
            transitGatewayCidrBlocks(model.transitGatewayCidrBlocks);
            autoAcceptSharedAttachments(model.autoAcceptSharedAttachments);
            defaultRouteTableAssociation(model.defaultRouteTableAssociation);
            associationDefaultRouteTableId(model.associationDefaultRouteTableId);
            defaultRouteTablePropagation(model.defaultRouteTablePropagation);
            propagationDefaultRouteTableId(model.propagationDefaultRouteTableId);
            vpnEcmpSupport(model.vpnEcmpSupport);
            dnsSupport(model.dnsSupport);
            securityGroupReferencingSupport(model.securityGroupReferencingSupport);
            multicastSupport(model.multicastSupport);
        }

        public final Long getAmazonSideAsn() {
            return amazonSideAsn;
        }

        public final void setAmazonSideAsn(Long amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
        }

        @Override
        public final Builder amazonSideAsn(Long amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
            return this;
        }

        public final Collection<String> getTransitGatewayCidrBlocks() {
            if (transitGatewayCidrBlocks instanceof SdkAutoConstructList) {
                return null;
            }
            return transitGatewayCidrBlocks;
        }

        public final void setTransitGatewayCidrBlocks(Collection<String> transitGatewayCidrBlocks) {
            this.transitGatewayCidrBlocks = ValueStringListCopier.copy(transitGatewayCidrBlocks);
        }

        @Override
        public final Builder transitGatewayCidrBlocks(Collection<String> transitGatewayCidrBlocks) {
            this.transitGatewayCidrBlocks = ValueStringListCopier.copy(transitGatewayCidrBlocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitGatewayCidrBlocks(String... transitGatewayCidrBlocks) {
            transitGatewayCidrBlocks(Arrays.asList(transitGatewayCidrBlocks));
            return this;
        }

        public final String getAutoAcceptSharedAttachments() {
            return autoAcceptSharedAttachments;
        }

        public final void setAutoAcceptSharedAttachments(String autoAcceptSharedAttachments) {
            this.autoAcceptSharedAttachments = autoAcceptSharedAttachments;
        }

        @Override
        public final Builder autoAcceptSharedAttachments(String autoAcceptSharedAttachments) {
            this.autoAcceptSharedAttachments = autoAcceptSharedAttachments;
            return this;
        }

        @Override
        public final Builder autoAcceptSharedAttachments(AutoAcceptSharedAttachmentsValue autoAcceptSharedAttachments) {
            this.autoAcceptSharedAttachments(autoAcceptSharedAttachments == null ? null : autoAcceptSharedAttachments.toString());
            return this;
        }

        public final String getDefaultRouteTableAssociation() {
            return defaultRouteTableAssociation;
        }

        public final void setDefaultRouteTableAssociation(String defaultRouteTableAssociation) {
            this.defaultRouteTableAssociation = defaultRouteTableAssociation;
        }

        @Override
        public final Builder defaultRouteTableAssociation(String defaultRouteTableAssociation) {
            this.defaultRouteTableAssociation = defaultRouteTableAssociation;
            return this;
        }

        @Override
        public final Builder defaultRouteTableAssociation(DefaultRouteTableAssociationValue defaultRouteTableAssociation) {
            this.defaultRouteTableAssociation(defaultRouteTableAssociation == null ? null : defaultRouteTableAssociation
                    .toString());
            return this;
        }

        public final String getAssociationDefaultRouteTableId() {
            return associationDefaultRouteTableId;
        }

        public final void setAssociationDefaultRouteTableId(String associationDefaultRouteTableId) {
            this.associationDefaultRouteTableId = associationDefaultRouteTableId;
        }

        @Override
        public final Builder associationDefaultRouteTableId(String associationDefaultRouteTableId) {
            this.associationDefaultRouteTableId = associationDefaultRouteTableId;
            return this;
        }

        public final String getDefaultRouteTablePropagation() {
            return defaultRouteTablePropagation;
        }

        public final void setDefaultRouteTablePropagation(String defaultRouteTablePropagation) {
            this.defaultRouteTablePropagation = defaultRouteTablePropagation;
        }

        @Override
        public final Builder defaultRouteTablePropagation(String defaultRouteTablePropagation) {
            this.defaultRouteTablePropagation = defaultRouteTablePropagation;
            return this;
        }

        @Override
        public final Builder defaultRouteTablePropagation(DefaultRouteTablePropagationValue defaultRouteTablePropagation) {
            this.defaultRouteTablePropagation(defaultRouteTablePropagation == null ? null : defaultRouteTablePropagation
                    .toString());
            return this;
        }

        public final String getPropagationDefaultRouteTableId() {
            return propagationDefaultRouteTableId;
        }

        public final void setPropagationDefaultRouteTableId(String propagationDefaultRouteTableId) {
            this.propagationDefaultRouteTableId = propagationDefaultRouteTableId;
        }

        @Override
        public final Builder propagationDefaultRouteTableId(String propagationDefaultRouteTableId) {
            this.propagationDefaultRouteTableId = propagationDefaultRouteTableId;
            return this;
        }

        public final String getVpnEcmpSupport() {
            return vpnEcmpSupport;
        }

        public final void setVpnEcmpSupport(String vpnEcmpSupport) {
            this.vpnEcmpSupport = vpnEcmpSupport;
        }

        @Override
        public final Builder vpnEcmpSupport(String vpnEcmpSupport) {
            this.vpnEcmpSupport = vpnEcmpSupport;
            return this;
        }

        @Override
        public final Builder vpnEcmpSupport(VpnEcmpSupportValue vpnEcmpSupport) {
            this.vpnEcmpSupport(vpnEcmpSupport == null ? null : vpnEcmpSupport.toString());
            return this;
        }

        public final String getDnsSupport() {
            return dnsSupport;
        }

        public final void setDnsSupport(String dnsSupport) {
            this.dnsSupport = dnsSupport;
        }

        @Override
        public final Builder dnsSupport(String dnsSupport) {
            this.dnsSupport = dnsSupport;
            return this;
        }

        @Override
        public final Builder dnsSupport(DnsSupportValue dnsSupport) {
            this.dnsSupport(dnsSupport == null ? null : dnsSupport.toString());
            return this;
        }

        public final String getSecurityGroupReferencingSupport() {
            return securityGroupReferencingSupport;
        }

        public final void setSecurityGroupReferencingSupport(String securityGroupReferencingSupport) {
            this.securityGroupReferencingSupport = securityGroupReferencingSupport;
        }

        @Override
        public final Builder securityGroupReferencingSupport(String securityGroupReferencingSupport) {
            this.securityGroupReferencingSupport = securityGroupReferencingSupport;
            return this;
        }

        @Override
        public final Builder securityGroupReferencingSupport(SecurityGroupReferencingSupportValue securityGroupReferencingSupport) {
            this.securityGroupReferencingSupport(securityGroupReferencingSupport == null ? null : securityGroupReferencingSupport
                    .toString());
            return this;
        }

        public final String getMulticastSupport() {
            return multicastSupport;
        }

        public final void setMulticastSupport(String multicastSupport) {
            this.multicastSupport = multicastSupport;
        }

        @Override
        public final Builder multicastSupport(String multicastSupport) {
            this.multicastSupport = multicastSupport;
            return this;
        }

        @Override
        public final Builder multicastSupport(MulticastSupportValue multicastSupport) {
            this.multicastSupport(multicastSupport == null ? null : multicastSupport.toString());
            return this;
        }

        @Override
        public TransitGatewayOptions build() {
            return new TransitGatewayOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
