/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a virtual private gateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpnGateway implements SdkPojo, Serializable, ToCopyableBuilder<VpnGateway.Builder, VpnGateway> {
    private static final SdkField<Long> AMAZON_SIDE_ASN_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("AmazonSideAsn")
            .getter(getter(VpnGateway::amazonSideAsn))
            .setter(setter(Builder::amazonSideAsn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonSideAsn")
                    .unmarshallLocationName("amazonSideAsn").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(VpnGateway::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> VPN_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpnGatewayId")
            .getter(getter(VpnGateway::vpnGatewayId))
            .setter(setter(Builder::vpnGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnGatewayId")
                    .unmarshallLocationName("vpnGatewayId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(VpnGateway::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Type")
            .getter(getter(VpnGateway::typeAsString))
            .setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type")
                    .unmarshallLocationName("type").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone")
            .getter(getter(VpnGateway::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("availabilityZone").build()).build();

    private static final SdkField<List<VpcAttachment>> VPC_ATTACHMENTS_FIELD = SdkField
            .<List<VpcAttachment>> builder(MarshallingType.LIST)
            .memberName("VpcAttachments")
            .getter(getter(VpnGateway::vpcAttachments))
            .setter(setter(Builder::vpcAttachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachments")
                    .unmarshallLocationName("attachments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<VpcAttachment> builder(MarshallingType.SDK_POJO)
                                            .constructor(VpcAttachment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMAZON_SIDE_ASN_FIELD,
            TAGS_FIELD, VPN_GATEWAY_ID_FIELD, STATE_FIELD, TYPE_FIELD, AVAILABILITY_ZONE_FIELD, VPC_ATTACHMENTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long amazonSideAsn;

    private final List<Tag> tags;

    private final String vpnGatewayId;

    private final String state;

    private final String type;

    private final String availabilityZone;

    private final List<VpcAttachment> vpcAttachments;

    private VpnGateway(BuilderImpl builder) {
        this.amazonSideAsn = builder.amazonSideAsn;
        this.tags = builder.tags;
        this.vpnGatewayId = builder.vpnGatewayId;
        this.state = builder.state;
        this.type = builder.type;
        this.availabilityZone = builder.availabilityZone;
        this.vpcAttachments = builder.vpcAttachments;
    }

    /**
     * <p>
     * The private Autonomous System Number (ASN) for the Amazon side of a BGP session.
     * </p>
     * 
     * @return The private Autonomous System Number (ASN) for the Amazon side of a BGP session.
     */
    public final Long amazonSideAsn() {
        return amazonSideAsn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any tags assigned to the virtual private gateway.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Any tags assigned to the virtual private gateway.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The ID of the virtual private gateway.
     * </p>
     * 
     * @return The ID of the virtual private gateway.
     */
    public final String vpnGatewayId() {
        return vpnGatewayId;
    }

    /**
     * <p>
     * The current state of the virtual private gateway.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link VpnState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the virtual private gateway.
     * @see VpnState
     */
    public final VpnState state() {
        return VpnState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the virtual private gateway.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link VpnState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the virtual private gateway.
     * @see VpnState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The type of VPN connection the virtual private gateway supports.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link GatewayType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of VPN connection the virtual private gateway supports.
     * @see GatewayType
     */
    public final GatewayType type() {
        return GatewayType.fromValue(type);
    }

    /**
     * <p>
     * The type of VPN connection the virtual private gateway supports.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link GatewayType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of VPN connection the virtual private gateway supports.
     * @see GatewayType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The Availability Zone where the virtual private gateway was created, if applicable. This field may be empty or
     * not returned.
     * </p>
     * 
     * @return The Availability Zone where the virtual private gateway was created, if applicable. This field may be
     *         empty or not returned.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcAttachments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcAttachments() {
        return vpcAttachments != null && !(vpcAttachments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any VPCs attached to the virtual private gateway.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcAttachments} method.
     * </p>
     * 
     * @return Any VPCs attached to the virtual private gateway.
     */
    public final List<VpcAttachment> vpcAttachments() {
        return vpcAttachments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amazonSideAsn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpnGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcAttachments() ? vpcAttachments() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpnGateway)) {
            return false;
        }
        VpnGateway other = (VpnGateway) obj;
        return Objects.equals(amazonSideAsn(), other.amazonSideAsn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(vpnGatewayId(), other.vpnGatewayId())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && hasVpcAttachments() == other.hasVpcAttachments() && Objects.equals(vpcAttachments(), other.vpcAttachments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpnGateway").add("AmazonSideAsn", amazonSideAsn()).add("Tags", hasTags() ? tags() : null)
                .add("VpnGatewayId", vpnGatewayId()).add("State", stateAsString()).add("Type", typeAsString())
                .add("AvailabilityZone", availabilityZone()).add("VpcAttachments", hasVpcAttachments() ? vpcAttachments() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AmazonSideAsn":
            return Optional.ofNullable(clazz.cast(amazonSideAsn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "VpnGatewayId":
            return Optional.ofNullable(clazz.cast(vpnGatewayId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "VpcAttachments":
            return Optional.ofNullable(clazz.cast(vpcAttachments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VpnGateway, T> g) {
        return obj -> g.apply((VpnGateway) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpnGateway> {
        /**
         * <p>
         * The private Autonomous System Number (ASN) for the Amazon side of a BGP session.
         * </p>
         * 
         * @param amazonSideAsn
         *        The private Autonomous System Number (ASN) for the Amazon side of a BGP session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonSideAsn(Long amazonSideAsn);

        /**
         * <p>
         * Any tags assigned to the virtual private gateway.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the virtual private gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the virtual private gateway.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the virtual private gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags assigned to the virtual private gateway.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The ID of the virtual private gateway.
         * </p>
         * 
         * @param vpnGatewayId
         *        The ID of the virtual private gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnGatewayId(String vpnGatewayId);

        /**
         * <p>
         * The current state of the virtual private gateway.
         * </p>
         * 
         * @param state
         *        The current state of the virtual private gateway.
         * @see VpnState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpnState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the virtual private gateway.
         * </p>
         * 
         * @param state
         *        The current state of the virtual private gateway.
         * @see VpnState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpnState
         */
        Builder state(VpnState state);

        /**
         * <p>
         * The type of VPN connection the virtual private gateway supports.
         * </p>
         * 
         * @param type
         *        The type of VPN connection the virtual private gateway supports.
         * @see GatewayType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of VPN connection the virtual private gateway supports.
         * </p>
         * 
         * @param type
         *        The type of VPN connection the virtual private gateway supports.
         * @see GatewayType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayType
         */
        Builder type(GatewayType type);

        /**
         * <p>
         * The Availability Zone where the virtual private gateway was created, if applicable. This field may be empty
         * or not returned.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone where the virtual private gateway was created, if applicable. This field may be
         *        empty or not returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * Any VPCs attached to the virtual private gateway.
         * </p>
         * 
         * @param vpcAttachments
         *        Any VPCs attached to the virtual private gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcAttachments(Collection<VpcAttachment> vpcAttachments);

        /**
         * <p>
         * Any VPCs attached to the virtual private gateway.
         * </p>
         * 
         * @param vpcAttachments
         *        Any VPCs attached to the virtual private gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcAttachments(VpcAttachment... vpcAttachments);

        /**
         * <p>
         * Any VPCs attached to the virtual private gateway.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.VpcAttachment.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.VpcAttachment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.VpcAttachment.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcAttachments(List<VpcAttachment>)}.
         * 
         * @param vpcAttachments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.VpcAttachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcAttachments(java.util.Collection<VpcAttachment>)
         */
        Builder vpcAttachments(Consumer<VpcAttachment.Builder>... vpcAttachments);
    }

    static final class BuilderImpl implements Builder {
        private Long amazonSideAsn;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String vpnGatewayId;

        private String state;

        private String type;

        private String availabilityZone;

        private List<VpcAttachment> vpcAttachments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VpnGateway model) {
            amazonSideAsn(model.amazonSideAsn);
            tags(model.tags);
            vpnGatewayId(model.vpnGatewayId);
            state(model.state);
            type(model.type);
            availabilityZone(model.availabilityZone);
            vpcAttachments(model.vpcAttachments);
        }

        public final Long getAmazonSideAsn() {
            return amazonSideAsn;
        }

        public final void setAmazonSideAsn(Long amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
        }

        @Override
        public final Builder amazonSideAsn(Long amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getVpnGatewayId() {
            return vpnGatewayId;
        }

        public final void setVpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
        }

        @Override
        public final Builder vpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VpnState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(GatewayType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final List<VpcAttachment.Builder> getVpcAttachments() {
            List<VpcAttachment.Builder> result = VpcAttachmentListCopier.copyToBuilder(this.vpcAttachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcAttachments(Collection<VpcAttachment.BuilderImpl> vpcAttachments) {
            this.vpcAttachments = VpcAttachmentListCopier.copyFromBuilder(vpcAttachments);
        }

        @Override
        public final Builder vpcAttachments(Collection<VpcAttachment> vpcAttachments) {
            this.vpcAttachments = VpcAttachmentListCopier.copy(vpcAttachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcAttachments(VpcAttachment... vpcAttachments) {
            vpcAttachments(Arrays.asList(vpcAttachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcAttachments(Consumer<VpcAttachment.Builder>... vpcAttachments) {
            vpcAttachments(Stream.of(vpcAttachments).map(c -> VpcAttachment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public VpnGateway build() {
            return new VpnGateway(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
