/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ModifyImageAttribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyImageAttributeRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyImageAttributeRequest.Builder, ModifyImageAttributeRequest> {
    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Attribute")
            .getter(getter(ModifyImageAttributeRequest::attribute))
            .setter(setter(Builder::attribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute")
                    .unmarshallLocationName("Attribute").build()).build();

    private static final SdkField<AttributeValue> DESCRIPTION_FIELD = SdkField
            .<AttributeValue> builder(MarshallingType.SDK_POJO)
            .memberName("Description")
            .getter(getter(ModifyImageAttributeRequest::description))
            .setter(setter(Builder::description))
            .constructor(AttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ImageId")
            .getter(getter(ModifyImageAttributeRequest::imageId))
            .setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId")
                    .unmarshallLocationName("ImageId").build()).build();

    private static final SdkField<LaunchPermissionModifications> LAUNCH_PERMISSION_FIELD = SdkField
            .<LaunchPermissionModifications> builder(MarshallingType.SDK_POJO)
            .memberName("LaunchPermission")
            .getter(getter(ModifyImageAttributeRequest::launchPermission))
            .setter(setter(Builder::launchPermission))
            .constructor(LaunchPermissionModifications::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchPermission")
                    .unmarshallLocationName("LaunchPermission").build()).build();

    private static final SdkField<String> OPERATION_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OperationType")
            .getter(getter(ModifyImageAttributeRequest::operationTypeAsString))
            .setter(setter(Builder::operationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationType")
                    .unmarshallLocationName("OperationType").build()).build();

    private static final SdkField<List<String>> PRODUCT_CODES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ProductCodes")
            .getter(getter(ModifyImageAttributeRequest::productCodes))
            .setter(setter(Builder::productCodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCode")
                    .unmarshallLocationName("ProductCode").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ProductCode")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ProductCode").unmarshallLocationName("ProductCode").build())
                                            .build()).build()).build();

    private static final SdkField<List<String>> USER_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("UserGroups")
            .getter(getter(ModifyImageAttributeRequest::userGroups))
            .setter(setter(Builder::userGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroup")
                    .unmarshallLocationName("UserGroup").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("UserGroup")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("UserGroup").unmarshallLocationName("UserGroup").build())
                                            .build()).build()).build();

    private static final SdkField<List<String>> USER_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("UserIds")
            .getter(getter(ModifyImageAttributeRequest::userIds))
            .setter(setter(Builder::userIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId")
                    .unmarshallLocationName("UserId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("UserId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("UserId").unmarshallLocationName("UserId").build()).build())
                            .build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Value")
            .getter(getter(ModifyImageAttributeRequest::value))
            .setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value")
                    .unmarshallLocationName("Value").build()).build();

    private static final SdkField<List<String>> ORGANIZATION_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("OrganizationArns")
            .getter(getter(ModifyImageAttributeRequest::organizationArns))
            .setter(setter(Builder::organizationArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationArn")
                    .unmarshallLocationName("OrganizationArn").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("OrganizationArn")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("OrganizationArn").unmarshallLocationName("OrganizationArn")
                                                    .build()).build()).build()).build();

    private static final SdkField<List<String>> ORGANIZATIONAL_UNIT_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("OrganizationalUnitArns")
            .getter(getter(ModifyImageAttributeRequest::organizationalUnitArns))
            .setter(setter(Builder::organizationalUnitArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnitArn")
                    .unmarshallLocationName("OrganizationalUnitArn").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("OrganizationalUnitArn")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("OrganizationalUnitArn")
                                                    .unmarshallLocationName("OrganizationalUnitArn").build()).build()).build())
            .build();

    private static final SdkField<AttributeValue> IMDS_SUPPORT_FIELD = SdkField
            .<AttributeValue> builder(MarshallingType.SDK_POJO)
            .memberName("ImdsSupport")
            .getter(getter(ModifyImageAttributeRequest::imdsSupport))
            .setter(setter(Builder::imdsSupport))
            .constructor(AttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImdsSupport")
                    .unmarshallLocationName("ImdsSupport").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(ModifyImageAttributeRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("dryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FIELD,
            DESCRIPTION_FIELD, IMAGE_ID_FIELD, LAUNCH_PERMISSION_FIELD, OPERATION_TYPE_FIELD, PRODUCT_CODES_FIELD,
            USER_GROUPS_FIELD, USER_IDS_FIELD, VALUE_FIELD, ORGANIZATION_ARNS_FIELD, ORGANIZATIONAL_UNIT_ARNS_FIELD,
            IMDS_SUPPORT_FIELD, DRY_RUN_FIELD));

    private final String attribute;

    private final AttributeValue description;

    private final String imageId;

    private final LaunchPermissionModifications launchPermission;

    private final String operationType;

    private final List<String> productCodes;

    private final List<String> userGroups;

    private final List<String> userIds;

    private final String value;

    private final List<String> organizationArns;

    private final List<String> organizationalUnitArns;

    private final AttributeValue imdsSupport;

    private final Boolean dryRun;

    private ModifyImageAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.attribute = builder.attribute;
        this.description = builder.description;
        this.imageId = builder.imageId;
        this.launchPermission = builder.launchPermission;
        this.operationType = builder.operationType;
        this.productCodes = builder.productCodes;
        this.userGroups = builder.userGroups;
        this.userIds = builder.userIds;
        this.value = builder.value;
        this.organizationArns = builder.organizationArns;
        this.organizationalUnitArns = builder.organizationalUnitArns;
        this.imdsSupport = builder.imdsSupport;
        this.dryRun = builder.dryRun;
    }

    /**
     * <p>
     * The name of the attribute to modify.
     * </p>
     * <p>
     * Valid values: <code>description</code> | <code>imdsSupport</code> | <code>launchPermission</code>
     * </p>
     * 
     * @return The name of the attribute to modify.</p>
     *         <p>
     *         Valid values: <code>description</code> | <code>imdsSupport</code> | <code>launchPermission</code>
     */
    public final String attribute() {
        return attribute;
    }

    /**
     * <p>
     * A new description for the AMI.
     * </p>
     * 
     * @return A new description for the AMI.
     */
    public final AttributeValue description() {
        return description;
    }

    /**
     * <p>
     * The ID of the AMI.
     * </p>
     * 
     * @return The ID of the AMI.
     */
    public final String imageId() {
        return imageId;
    }

    /**
     * <p>
     * A new launch permission for the AMI.
     * </p>
     * 
     * @return A new launch permission for the AMI.
     */
    public final LaunchPermissionModifications launchPermission() {
        return launchPermission;
    }

    /**
     * <p>
     * The operation type. This parameter can be used only when the <code>Attribute</code> parameter is
     * <code>launchPermission</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationType}
     * will return {@link OperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operationTypeAsString}.
     * </p>
     * 
     * @return The operation type. This parameter can be used only when the <code>Attribute</code> parameter is
     *         <code>launchPermission</code>.
     * @see OperationType
     */
    public final OperationType operationType() {
        return OperationType.fromValue(operationType);
    }

    /**
     * <p>
     * The operation type. This parameter can be used only when the <code>Attribute</code> parameter is
     * <code>launchPermission</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationType}
     * will return {@link OperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operationTypeAsString}.
     * </p>
     * 
     * @return The operation type. This parameter can be used only when the <code>Attribute</code> parameter is
     *         <code>launchPermission</code>.
     * @see OperationType
     */
    public final String operationTypeAsString() {
        return operationType;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProductCodes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProductCodes() {
        return productCodes != null && !(productCodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Not supported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProductCodes} method.
     * </p>
     * 
     * @return Not supported.
     */
    public final List<String> productCodes() {
        return productCodes;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserGroups property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasUserGroups() {
        return userGroups != null && !(userGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The user groups. This parameter can be used only when the <code>Attribute</code> parameter is
     * <code>launchPermission</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserGroups} method.
     * </p>
     * 
     * @return The user groups. This parameter can be used only when the <code>Attribute</code> parameter is
     *         <code>launchPermission</code>.
     */
    public final List<String> userGroups() {
        return userGroups;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasUserIds() {
        return userIds != null && !(userIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Web Services account IDs. This parameter can be used only when the <code>Attribute</code> parameter is
     * <code>launchPermission</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserIds} method.
     * </p>
     * 
     * @return The Amazon Web Services account IDs. This parameter can be used only when the <code>Attribute</code>
     *         parameter is <code>launchPermission</code>.
     */
    public final List<String> userIds() {
        return userIds;
    }

    /**
     * <p>
     * The value of the attribute being modified. This parameter can be used only when the <code>Attribute</code>
     * parameter is <code>description</code> or <code>imdsSupport</code>.
     * </p>
     * 
     * @return The value of the attribute being modified. This parameter can be used only when the
     *         <code>Attribute</code> parameter is <code>description</code> or <code>imdsSupport</code>.
     */
    public final String value() {
        return value;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrganizationArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOrganizationArns() {
        return organizationArns != null && !(organizationArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an organization. This parameter can be used only when the
     * <code>Attribute</code> parameter is <code>launchPermission</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrganizationArns} method.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an organization. This parameter can be used only when the
     *         <code>Attribute</code> parameter is <code>launchPermission</code>.
     */
    public final List<String> organizationArns() {
        return organizationArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrganizationalUnitArns property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasOrganizationalUnitArns() {
        return organizationalUnitArns != null && !(organizationalUnitArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an organizational unit (OU). This parameter can be used only when the
     * <code>Attribute</code> parameter is <code>launchPermission</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrganizationalUnitArns} method.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an organizational unit (OU). This parameter can be used only when the
     *         <code>Attribute</code> parameter is <code>launchPermission</code>.
     */
    public final List<String> organizationalUnitArns() {
        return organizationalUnitArns;
    }

    /**
     * <p>
     * Set to <code>v2.0</code> to indicate that IMDSv2 is specified in the AMI. Instances launched from this AMI will
     * have <code>HttpTokens</code> automatically set to <code>required</code> so that, by default, the instance
     * requires that IMDSv2 is used when requesting instance metadata. In addition, <code>HttpPutResponseHopLimit</code>
     * is set to <code>2</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration"
     * >Configure the AMI</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <important>
     * <p>
     * Do not use this parameter unless your AMI software supports IMDSv2. After you set the value to <code>v2.0</code>,
     * you can't undo it. The only way to “reset” your AMI is to create a new AMI from the underlying snapshot.
     * </p>
     * </important>
     * 
     * @return Set to <code>v2.0</code> to indicate that IMDSv2 is specified in the AMI. Instances launched from this
     *         AMI will have <code>HttpTokens</code> automatically set to <code>required</code> so that, by default, the
     *         instance requires that IMDSv2 is used when requesting instance metadata. In addition,
     *         <code>HttpPutResponseHopLimit</code> is set to <code>2</code>. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration"
     *         >Configure the AMI</a> in the <i>Amazon EC2 User Guide</i>.</p> <important>
     *         <p>
     *         Do not use this parameter unless your AMI software supports IMDSv2. After you set the value to
     *         <code>v2.0</code>, you can't undo it. The only way to “reset” your AMI is to create a new AMI from the
     *         underlying snapshot.
     *         </p>
     */
    public final AttributeValue imdsSupport() {
        return imdsSupport;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(attribute());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(launchPermission());
        hashCode = 31 * hashCode + Objects.hashCode(operationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasProductCodes() ? productCodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUserGroups() ? userGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUserIds() ? userIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(hasOrganizationArns() ? organizationArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOrganizationalUnitArns() ? organizationalUnitArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(imdsSupport());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyImageAttributeRequest)) {
            return false;
        }
        ModifyImageAttributeRequest other = (ModifyImageAttributeRequest) obj;
        return Objects.equals(attribute(), other.attribute()) && Objects.equals(description(), other.description())
                && Objects.equals(imageId(), other.imageId()) && Objects.equals(launchPermission(), other.launchPermission())
                && Objects.equals(operationTypeAsString(), other.operationTypeAsString())
                && hasProductCodes() == other.hasProductCodes() && Objects.equals(productCodes(), other.productCodes())
                && hasUserGroups() == other.hasUserGroups() && Objects.equals(userGroups(), other.userGroups())
                && hasUserIds() == other.hasUserIds() && Objects.equals(userIds(), other.userIds())
                && Objects.equals(value(), other.value()) && hasOrganizationArns() == other.hasOrganizationArns()
                && Objects.equals(organizationArns(), other.organizationArns())
                && hasOrganizationalUnitArns() == other.hasOrganizationalUnitArns()
                && Objects.equals(organizationalUnitArns(), other.organizationalUnitArns())
                && Objects.equals(imdsSupport(), other.imdsSupport()) && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyImageAttributeRequest").add("Attribute", attribute()).add("Description", description())
                .add("ImageId", imageId()).add("LaunchPermission", launchPermission())
                .add("OperationType", operationTypeAsString()).add("ProductCodes", hasProductCodes() ? productCodes() : null)
                .add("UserGroups", hasUserGroups() ? userGroups() : null).add("UserIds", hasUserIds() ? userIds() : null)
                .add("Value", value()).add("OrganizationArns", hasOrganizationArns() ? organizationArns() : null)
                .add("OrganizationalUnitArns", hasOrganizationalUnitArns() ? organizationalUnitArns() : null)
                .add("ImdsSupport", imdsSupport()).add("DryRun", dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attribute":
            return Optional.ofNullable(clazz.cast(attribute()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "LaunchPermission":
            return Optional.ofNullable(clazz.cast(launchPermission()));
        case "OperationType":
            return Optional.ofNullable(clazz.cast(operationTypeAsString()));
        case "ProductCodes":
            return Optional.ofNullable(clazz.cast(productCodes()));
        case "UserGroups":
            return Optional.ofNullable(clazz.cast(userGroups()));
        case "UserIds":
            return Optional.ofNullable(clazz.cast(userIds()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "OrganizationArns":
            return Optional.ofNullable(clazz.cast(organizationArns()));
        case "OrganizationalUnitArns":
            return Optional.ofNullable(clazz.cast(organizationalUnitArns()));
        case "ImdsSupport":
            return Optional.ofNullable(clazz.cast(imdsSupport()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyImageAttributeRequest, T> g) {
        return obj -> g.apply((ModifyImageAttributeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyImageAttributeRequest> {
        /**
         * <p>
         * The name of the attribute to modify.
         * </p>
         * <p>
         * Valid values: <code>description</code> | <code>imdsSupport</code> | <code>launchPermission</code>
         * </p>
         * 
         * @param attribute
         *        The name of the attribute to modify.</p>
         *        <p>
         *        Valid values: <code>description</code> | <code>imdsSupport</code> | <code>launchPermission</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * A new description for the AMI.
         * </p>
         * 
         * @param description
         *        A new description for the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(AttributeValue description);

        /**
         * <p>
         * A new description for the AMI.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeValue.Builder} avoiding the need
         * to create one manually via {@link AttributeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeValue.Builder#build()} is called immediately and its
         * result is passed to {@link #description(AttributeValue)}.
         * 
         * @param description
         *        a consumer that will call methods on {@link AttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #description(AttributeValue)
         */
        default Builder description(Consumer<AttributeValue.Builder> description) {
            return description(AttributeValue.builder().applyMutation(description).build());
        }

        /**
         * <p>
         * The ID of the AMI.
         * </p>
         * 
         * @param imageId
         *        The ID of the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * A new launch permission for the AMI.
         * </p>
         * 
         * @param launchPermission
         *        A new launch permission for the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchPermission(LaunchPermissionModifications launchPermission);

        /**
         * <p>
         * A new launch permission for the AMI.
         * </p>
         * This is a convenience method that creates an instance of the {@link LaunchPermissionModifications.Builder}
         * avoiding the need to create one manually via {@link LaunchPermissionModifications#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LaunchPermissionModifications.Builder#build()} is called
         * immediately and its result is passed to {@link #launchPermission(LaunchPermissionModifications)}.
         * 
         * @param launchPermission
         *        a consumer that will call methods on {@link LaunchPermissionModifications.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchPermission(LaunchPermissionModifications)
         */
        default Builder launchPermission(Consumer<LaunchPermissionModifications.Builder> launchPermission) {
            return launchPermission(LaunchPermissionModifications.builder().applyMutation(launchPermission).build());
        }

        /**
         * <p>
         * The operation type. This parameter can be used only when the <code>Attribute</code> parameter is
         * <code>launchPermission</code>.
         * </p>
         * 
         * @param operationType
         *        The operation type. This parameter can be used only when the <code>Attribute</code> parameter is
         *        <code>launchPermission</code>.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder operationType(String operationType);

        /**
         * <p>
         * The operation type. This parameter can be used only when the <code>Attribute</code> parameter is
         * <code>launchPermission</code>.
         * </p>
         * 
         * @param operationType
         *        The operation type. This parameter can be used only when the <code>Attribute</code> parameter is
         *        <code>launchPermission</code>.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder operationType(OperationType operationType);

        /**
         * <p>
         * Not supported.
         * </p>
         * 
         * @param productCodes
         *        Not supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(Collection<String> productCodes);

        /**
         * <p>
         * Not supported.
         * </p>
         * 
         * @param productCodes
         *        Not supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(String... productCodes);

        /**
         * <p>
         * The user groups. This parameter can be used only when the <code>Attribute</code> parameter is
         * <code>launchPermission</code>.
         * </p>
         * 
         * @param userGroups
         *        The user groups. This parameter can be used only when the <code>Attribute</code> parameter is
         *        <code>launchPermission</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroups(Collection<String> userGroups);

        /**
         * <p>
         * The user groups. This parameter can be used only when the <code>Attribute</code> parameter is
         * <code>launchPermission</code>.
         * </p>
         * 
         * @param userGroups
         *        The user groups. This parameter can be used only when the <code>Attribute</code> parameter is
         *        <code>launchPermission</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroups(String... userGroups);

        /**
         * <p>
         * The Amazon Web Services account IDs. This parameter can be used only when the <code>Attribute</code>
         * parameter is <code>launchPermission</code>.
         * </p>
         * 
         * @param userIds
         *        The Amazon Web Services account IDs. This parameter can be used only when the <code>Attribute</code>
         *        parameter is <code>launchPermission</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIds(Collection<String> userIds);

        /**
         * <p>
         * The Amazon Web Services account IDs. This parameter can be used only when the <code>Attribute</code>
         * parameter is <code>launchPermission</code>.
         * </p>
         * 
         * @param userIds
         *        The Amazon Web Services account IDs. This parameter can be used only when the <code>Attribute</code>
         *        parameter is <code>launchPermission</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIds(String... userIds);

        /**
         * <p>
         * The value of the attribute being modified. This parameter can be used only when the <code>Attribute</code>
         * parameter is <code>description</code> or <code>imdsSupport</code>.
         * </p>
         * 
         * @param value
         *        The value of the attribute being modified. This parameter can be used only when the
         *        <code>Attribute</code> parameter is <code>description</code> or <code>imdsSupport</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an organization. This parameter can be used only when the
         * <code>Attribute</code> parameter is <code>launchPermission</code>.
         * </p>
         * 
         * @param organizationArns
         *        The Amazon Resource Name (ARN) of an organization. This parameter can be used only when the
         *        <code>Attribute</code> parameter is <code>launchPermission</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationArns(Collection<String> organizationArns);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an organization. This parameter can be used only when the
         * <code>Attribute</code> parameter is <code>launchPermission</code>.
         * </p>
         * 
         * @param organizationArns
         *        The Amazon Resource Name (ARN) of an organization. This parameter can be used only when the
         *        <code>Attribute</code> parameter is <code>launchPermission</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationArns(String... organizationArns);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an organizational unit (OU). This parameter can be used only when the
         * <code>Attribute</code> parameter is <code>launchPermission</code>.
         * </p>
         * 
         * @param organizationalUnitArns
         *        The Amazon Resource Name (ARN) of an organizational unit (OU). This parameter can be used only when
         *        the <code>Attribute</code> parameter is <code>launchPermission</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitArns(Collection<String> organizationalUnitArns);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an organizational unit (OU). This parameter can be used only when the
         * <code>Attribute</code> parameter is <code>launchPermission</code>.
         * </p>
         * 
         * @param organizationalUnitArns
         *        The Amazon Resource Name (ARN) of an organizational unit (OU). This parameter can be used only when
         *        the <code>Attribute</code> parameter is <code>launchPermission</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitArns(String... organizationalUnitArns);

        /**
         * <p>
         * Set to <code>v2.0</code> to indicate that IMDSv2 is specified in the AMI. Instances launched from this AMI
         * will have <code>HttpTokens</code> automatically set to <code>required</code> so that, by default, the
         * instance requires that IMDSv2 is used when requesting instance metadata. In addition,
         * <code>HttpPutResponseHopLimit</code> is set to <code>2</code>. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration"
         * >Configure the AMI</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * <important>
         * <p>
         * Do not use this parameter unless your AMI software supports IMDSv2. After you set the value to
         * <code>v2.0</code>, you can't undo it. The only way to “reset” your AMI is to create a new AMI from the
         * underlying snapshot.
         * </p>
         * </important>
         * 
         * @param imdsSupport
         *        Set to <code>v2.0</code> to indicate that IMDSv2 is specified in the AMI. Instances launched from this
         *        AMI will have <code>HttpTokens</code> automatically set to <code>required</code> so that, by default,
         *        the instance requires that IMDSv2 is used when requesting instance metadata. In addition,
         *        <code>HttpPutResponseHopLimit</code> is set to <code>2</code>. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration"
         *        >Configure the AMI</a> in the <i>Amazon EC2 User Guide</i>.</p> <important>
         *        <p>
         *        Do not use this parameter unless your AMI software supports IMDSv2. After you set the value to
         *        <code>v2.0</code>, you can't undo it. The only way to “reset” your AMI is to create a new AMI from the
         *        underlying snapshot.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imdsSupport(AttributeValue imdsSupport);

        /**
         * <p>
         * Set to <code>v2.0</code> to indicate that IMDSv2 is specified in the AMI. Instances launched from this AMI
         * will have <code>HttpTokens</code> automatically set to <code>required</code> so that, by default, the
         * instance requires that IMDSv2 is used when requesting instance metadata. In addition,
         * <code>HttpPutResponseHopLimit</code> is set to <code>2</code>. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration"
         * >Configure the AMI</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * <important>
         * <p>
         * Do not use this parameter unless your AMI software supports IMDSv2. After you set the value to
         * <code>v2.0</code>, you can't undo it. The only way to “reset” your AMI is to create a new AMI from the
         * underlying snapshot.
         * </p>
         * </important> This is a convenience method that creates an instance of the {@link AttributeValue.Builder}
         * avoiding the need to create one manually via {@link AttributeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeValue.Builder#build()} is called immediately and its
         * result is passed to {@link #imdsSupport(AttributeValue)}.
         * 
         * @param imdsSupport
         *        a consumer that will call methods on {@link AttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imdsSupport(AttributeValue)
         */
        default Builder imdsSupport(Consumer<AttributeValue.Builder> imdsSupport) {
            return imdsSupport(AttributeValue.builder().applyMutation(imdsSupport).build());
        }

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String attribute;

        private AttributeValue description;

        private String imageId;

        private LaunchPermissionModifications launchPermission;

        private String operationType;

        private List<String> productCodes = DefaultSdkAutoConstructList.getInstance();

        private List<String> userGroups = DefaultSdkAutoConstructList.getInstance();

        private List<String> userIds = DefaultSdkAutoConstructList.getInstance();

        private String value;

        private List<String> organizationArns = DefaultSdkAutoConstructList.getInstance();

        private List<String> organizationalUnitArns = DefaultSdkAutoConstructList.getInstance();

        private AttributeValue imdsSupport;

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyImageAttributeRequest model) {
            super(model);
            attribute(model.attribute);
            description(model.description);
            imageId(model.imageId);
            launchPermission(model.launchPermission);
            operationType(model.operationType);
            productCodes(model.productCodes);
            userGroups(model.userGroups);
            userIds(model.userIds);
            value(model.value);
            organizationArns(model.organizationArns);
            organizationalUnitArns(model.organizationalUnitArns);
            imdsSupport(model.imdsSupport);
            dryRun(model.dryRun);
        }

        public final String getAttribute() {
            return attribute;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        public final AttributeValue.Builder getDescription() {
            return description != null ? description.toBuilder() : null;
        }

        public final void setDescription(AttributeValue.BuilderImpl description) {
            this.description = description != null ? description.build() : null;
        }

        @Override
        public final Builder description(AttributeValue description) {
            this.description = description;
            return this;
        }

        public final String getImageId() {
            return imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final LaunchPermissionModifications.Builder getLaunchPermission() {
            return launchPermission != null ? launchPermission.toBuilder() : null;
        }

        public final void setLaunchPermission(LaunchPermissionModifications.BuilderImpl launchPermission) {
            this.launchPermission = launchPermission != null ? launchPermission.build() : null;
        }

        @Override
        public final Builder launchPermission(LaunchPermissionModifications launchPermission) {
            this.launchPermission = launchPermission;
            return this;
        }

        public final String getOperationType() {
            return operationType;
        }

        public final void setOperationType(String operationType) {
            this.operationType = operationType;
        }

        @Override
        public final Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        @Override
        public final Builder operationType(OperationType operationType) {
            this.operationType(operationType == null ? null : operationType.toString());
            return this;
        }

        public final Collection<String> getProductCodes() {
            if (productCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return productCodes;
        }

        public final void setProductCodes(Collection<String> productCodes) {
            this.productCodes = ProductCodeStringListCopier.copy(productCodes);
        }

        @Override
        public final Builder productCodes(Collection<String> productCodes) {
            this.productCodes = ProductCodeStringListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(String... productCodes) {
            productCodes(Arrays.asList(productCodes));
            return this;
        }

        public final Collection<String> getUserGroups() {
            if (userGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return userGroups;
        }

        public final void setUserGroups(Collection<String> userGroups) {
            this.userGroups = UserGroupStringListCopier.copy(userGroups);
        }

        @Override
        public final Builder userGroups(Collection<String> userGroups) {
            this.userGroups = UserGroupStringListCopier.copy(userGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userGroups(String... userGroups) {
            userGroups(Arrays.asList(userGroups));
            return this;
        }

        public final Collection<String> getUserIds() {
            if (userIds instanceof SdkAutoConstructList) {
                return null;
            }
            return userIds;
        }

        public final void setUserIds(Collection<String> userIds) {
            this.userIds = UserIdStringListCopier.copy(userIds);
        }

        @Override
        public final Builder userIds(Collection<String> userIds) {
            this.userIds = UserIdStringListCopier.copy(userIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIds(String... userIds) {
            userIds(Arrays.asList(userIds));
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final Collection<String> getOrganizationArns() {
            if (organizationArns instanceof SdkAutoConstructList) {
                return null;
            }
            return organizationArns;
        }

        public final void setOrganizationArns(Collection<String> organizationArns) {
            this.organizationArns = OrganizationArnStringListCopier.copy(organizationArns);
        }

        @Override
        public final Builder organizationArns(Collection<String> organizationArns) {
            this.organizationArns = OrganizationArnStringListCopier.copy(organizationArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationArns(String... organizationArns) {
            organizationArns(Arrays.asList(organizationArns));
            return this;
        }

        public final Collection<String> getOrganizationalUnitArns() {
            if (organizationalUnitArns instanceof SdkAutoConstructList) {
                return null;
            }
            return organizationalUnitArns;
        }

        public final void setOrganizationalUnitArns(Collection<String> organizationalUnitArns) {
            this.organizationalUnitArns = OrganizationalUnitArnStringListCopier.copy(organizationalUnitArns);
        }

        @Override
        public final Builder organizationalUnitArns(Collection<String> organizationalUnitArns) {
            this.organizationalUnitArns = OrganizationalUnitArnStringListCopier.copy(organizationalUnitArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationalUnitArns(String... organizationalUnitArns) {
            organizationalUnitArns(Arrays.asList(organizationalUnitArns));
            return this;
        }

        public final AttributeValue.Builder getImdsSupport() {
            return imdsSupport != null ? imdsSupport.toBuilder() : null;
        }

        public final void setImdsSupport(AttributeValue.BuilderImpl imdsSupport) {
            this.imdsSupport = imdsSupport != null ? imdsSupport.build() : null;
        }

        @Override
        public final Builder imdsSupport(AttributeValue imdsSupport) {
            this.imdsSupport = imdsSupport;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyImageAttributeRequest build() {
            return new ModifyImageAttributeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
