/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The transit gateway options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyTransitGatewayOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<ModifyTransitGatewayOptions.Builder, ModifyTransitGatewayOptions> {
    private static final SdkField<List<String>> ADD_TRANSIT_GATEWAY_CIDR_BLOCKS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AddTransitGatewayCidrBlocks")
            .getter(getter(ModifyTransitGatewayOptions::addTransitGatewayCidrBlocks))
            .setter(setter(Builder::addTransitGatewayCidrBlocks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddTransitGatewayCidrBlocks")
                    .unmarshallLocationName("AddTransitGatewayCidrBlocks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> REMOVE_TRANSIT_GATEWAY_CIDR_BLOCKS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RemoveTransitGatewayCidrBlocks")
            .getter(getter(ModifyTransitGatewayOptions::removeTransitGatewayCidrBlocks))
            .setter(setter(Builder::removeTransitGatewayCidrBlocks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveTransitGatewayCidrBlocks")
                    .unmarshallLocationName("RemoveTransitGatewayCidrBlocks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> VPN_ECMP_SUPPORT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpnEcmpSupport")
            .getter(getter(ModifyTransitGatewayOptions::vpnEcmpSupportAsString))
            .setter(setter(Builder::vpnEcmpSupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnEcmpSupport")
                    .unmarshallLocationName("VpnEcmpSupport").build()).build();

    private static final SdkField<String> DNS_SUPPORT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DnsSupport")
            .getter(getter(ModifyTransitGatewayOptions::dnsSupportAsString))
            .setter(setter(Builder::dnsSupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsSupport")
                    .unmarshallLocationName("DnsSupport").build()).build();

    private static final SdkField<String> SECURITY_GROUP_REFERENCING_SUPPORT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecurityGroupReferencingSupport")
            .getter(getter(ModifyTransitGatewayOptions::securityGroupReferencingSupportAsString))
            .setter(setter(Builder::securityGroupReferencingSupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupReferencingSupport")
                    .unmarshallLocationName("SecurityGroupReferencingSupport").build()).build();

    private static final SdkField<String> AUTO_ACCEPT_SHARED_ATTACHMENTS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AutoAcceptSharedAttachments")
            .getter(getter(ModifyTransitGatewayOptions::autoAcceptSharedAttachmentsAsString))
            .setter(setter(Builder::autoAcceptSharedAttachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoAcceptSharedAttachments")
                    .unmarshallLocationName("AutoAcceptSharedAttachments").build()).build();

    private static final SdkField<String> DEFAULT_ROUTE_TABLE_ASSOCIATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DefaultRouteTableAssociation")
            .getter(getter(ModifyTransitGatewayOptions::defaultRouteTableAssociationAsString))
            .setter(setter(Builder::defaultRouteTableAssociation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRouteTableAssociation")
                    .unmarshallLocationName("DefaultRouteTableAssociation").build()).build();

    private static final SdkField<String> ASSOCIATION_DEFAULT_ROUTE_TABLE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AssociationDefaultRouteTableId")
            .getter(getter(ModifyTransitGatewayOptions::associationDefaultRouteTableId))
            .setter(setter(Builder::associationDefaultRouteTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationDefaultRouteTableId")
                    .unmarshallLocationName("AssociationDefaultRouteTableId").build()).build();

    private static final SdkField<String> DEFAULT_ROUTE_TABLE_PROPAGATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DefaultRouteTablePropagation")
            .getter(getter(ModifyTransitGatewayOptions::defaultRouteTablePropagationAsString))
            .setter(setter(Builder::defaultRouteTablePropagation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRouteTablePropagation")
                    .unmarshallLocationName("DefaultRouteTablePropagation").build()).build();

    private static final SdkField<String> PROPAGATION_DEFAULT_ROUTE_TABLE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PropagationDefaultRouteTableId")
            .getter(getter(ModifyTransitGatewayOptions::propagationDefaultRouteTableId))
            .setter(setter(Builder::propagationDefaultRouteTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropagationDefaultRouteTableId")
                    .unmarshallLocationName("PropagationDefaultRouteTableId").build()).build();

    private static final SdkField<Long> AMAZON_SIDE_ASN_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("AmazonSideAsn")
            .getter(getter(ModifyTransitGatewayOptions::amazonSideAsn))
            .setter(setter(Builder::amazonSideAsn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonSideAsn")
                    .unmarshallLocationName("AmazonSideAsn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ADD_TRANSIT_GATEWAY_CIDR_BLOCKS_FIELD, REMOVE_TRANSIT_GATEWAY_CIDR_BLOCKS_FIELD, VPN_ECMP_SUPPORT_FIELD,
            DNS_SUPPORT_FIELD, SECURITY_GROUP_REFERENCING_SUPPORT_FIELD, AUTO_ACCEPT_SHARED_ATTACHMENTS_FIELD,
            DEFAULT_ROUTE_TABLE_ASSOCIATION_FIELD, ASSOCIATION_DEFAULT_ROUTE_TABLE_ID_FIELD,
            DEFAULT_ROUTE_TABLE_PROPAGATION_FIELD, PROPAGATION_DEFAULT_ROUTE_TABLE_ID_FIELD, AMAZON_SIDE_ASN_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> addTransitGatewayCidrBlocks;

    private final List<String> removeTransitGatewayCidrBlocks;

    private final String vpnEcmpSupport;

    private final String dnsSupport;

    private final String securityGroupReferencingSupport;

    private final String autoAcceptSharedAttachments;

    private final String defaultRouteTableAssociation;

    private final String associationDefaultRouteTableId;

    private final String defaultRouteTablePropagation;

    private final String propagationDefaultRouteTableId;

    private final Long amazonSideAsn;

    private ModifyTransitGatewayOptions(BuilderImpl builder) {
        this.addTransitGatewayCidrBlocks = builder.addTransitGatewayCidrBlocks;
        this.removeTransitGatewayCidrBlocks = builder.removeTransitGatewayCidrBlocks;
        this.vpnEcmpSupport = builder.vpnEcmpSupport;
        this.dnsSupport = builder.dnsSupport;
        this.securityGroupReferencingSupport = builder.securityGroupReferencingSupport;
        this.autoAcceptSharedAttachments = builder.autoAcceptSharedAttachments;
        this.defaultRouteTableAssociation = builder.defaultRouteTableAssociation;
        this.associationDefaultRouteTableId = builder.associationDefaultRouteTableId;
        this.defaultRouteTablePropagation = builder.defaultRouteTablePropagation;
        this.propagationDefaultRouteTableId = builder.propagationDefaultRouteTableId;
        this.amazonSideAsn = builder.amazonSideAsn;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddTransitGatewayCidrBlocks property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAddTransitGatewayCidrBlocks() {
        return addTransitGatewayCidrBlocks != null && !(addTransitGatewayCidrBlocks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Adds IPv4 or IPv6 CIDR blocks for the transit gateway. Must be a size /24 CIDR block or larger for IPv4, or a
     * size /64 CIDR block or larger for IPv6.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddTransitGatewayCidrBlocks} method.
     * </p>
     * 
     * @return Adds IPv4 or IPv6 CIDR blocks for the transit gateway. Must be a size /24 CIDR block or larger for IPv4,
     *         or a size /64 CIDR block or larger for IPv6.
     */
    public final List<String> addTransitGatewayCidrBlocks() {
        return addTransitGatewayCidrBlocks;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoveTransitGatewayCidrBlocks property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRemoveTransitGatewayCidrBlocks() {
        return removeTransitGatewayCidrBlocks != null && !(removeTransitGatewayCidrBlocks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Removes CIDR blocks for the transit gateway.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveTransitGatewayCidrBlocks} method.
     * </p>
     * 
     * @return Removes CIDR blocks for the transit gateway.
     */
    public final List<String> removeTransitGatewayCidrBlocks() {
        return removeTransitGatewayCidrBlocks;
    }

    /**
     * <p>
     * Enable or disable Equal Cost Multipath Protocol support.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vpnEcmpSupport}
     * will return {@link VpnEcmpSupportValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #vpnEcmpSupportAsString}.
     * </p>
     * 
     * @return Enable or disable Equal Cost Multipath Protocol support.
     * @see VpnEcmpSupportValue
     */
    public final VpnEcmpSupportValue vpnEcmpSupport() {
        return VpnEcmpSupportValue.fromValue(vpnEcmpSupport);
    }

    /**
     * <p>
     * Enable or disable Equal Cost Multipath Protocol support.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vpnEcmpSupport}
     * will return {@link VpnEcmpSupportValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #vpnEcmpSupportAsString}.
     * </p>
     * 
     * @return Enable or disable Equal Cost Multipath Protocol support.
     * @see VpnEcmpSupportValue
     */
    public final String vpnEcmpSupportAsString() {
        return vpnEcmpSupport;
    }

    /**
     * <p>
     * Enable or disable DNS support.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dnsSupport} will
     * return {@link DnsSupportValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dnsSupportAsString}.
     * </p>
     * 
     * @return Enable or disable DNS support.
     * @see DnsSupportValue
     */
    public final DnsSupportValue dnsSupport() {
        return DnsSupportValue.fromValue(dnsSupport);
    }

    /**
     * <p>
     * Enable or disable DNS support.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dnsSupport} will
     * return {@link DnsSupportValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dnsSupportAsString}.
     * </p>
     * 
     * @return Enable or disable DNS support.
     * @see DnsSupportValue
     */
    public final String dnsSupportAsString() {
        return dnsSupport;
    }

    /**
     * <p>
     * Enables you to reference a security group across VPCs attached to a transit gateway to simplify security group
     * management.
     * </p>
     * <p>
     * This option is disabled by default.
     * </p>
     * <p>
     * For more information about security group referencing, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/tgw/tgw-vpc-attachments.html#vpc-attachment-security">Security group
     * referencing</a> in the <i>Amazon Web Services Transit Gateways Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #securityGroupReferencingSupport} will return
     * {@link SecurityGroupReferencingSupportValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #securityGroupReferencingSupportAsString}.
     * </p>
     * 
     * @return Enables you to reference a security group across VPCs attached to a transit gateway to simplify security
     *         group management. </p>
     *         <p>
     *         This option is disabled by default.
     *         </p>
     *         <p>
     *         For more information about security group referencing, see <a
     *         href="https://docs.aws.amazon.com/vpc/latest/tgw/tgw-vpc-attachments.html#vpc-attachment-security"
     *         >Security group referencing</a> in the <i>Amazon Web Services Transit Gateways Guide</i>.
     * @see SecurityGroupReferencingSupportValue
     */
    public final SecurityGroupReferencingSupportValue securityGroupReferencingSupport() {
        return SecurityGroupReferencingSupportValue.fromValue(securityGroupReferencingSupport);
    }

    /**
     * <p>
     * Enables you to reference a security group across VPCs attached to a transit gateway to simplify security group
     * management.
     * </p>
     * <p>
     * This option is disabled by default.
     * </p>
     * <p>
     * For more information about security group referencing, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/tgw/tgw-vpc-attachments.html#vpc-attachment-security">Security group
     * referencing</a> in the <i>Amazon Web Services Transit Gateways Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #securityGroupReferencingSupport} will return
     * {@link SecurityGroupReferencingSupportValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #securityGroupReferencingSupportAsString}.
     * </p>
     * 
     * @return Enables you to reference a security group across VPCs attached to a transit gateway to simplify security
     *         group management. </p>
     *         <p>
     *         This option is disabled by default.
     *         </p>
     *         <p>
     *         For more information about security group referencing, see <a
     *         href="https://docs.aws.amazon.com/vpc/latest/tgw/tgw-vpc-attachments.html#vpc-attachment-security"
     *         >Security group referencing</a> in the <i>Amazon Web Services Transit Gateways Guide</i>.
     * @see SecurityGroupReferencingSupportValue
     */
    public final String securityGroupReferencingSupportAsString() {
        return securityGroupReferencingSupport;
    }

    /**
     * <p>
     * Enable or disable automatic acceptance of attachment requests.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autoAcceptSharedAttachments} will return {@link AutoAcceptSharedAttachmentsValue#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #autoAcceptSharedAttachmentsAsString}.
     * </p>
     * 
     * @return Enable or disable automatic acceptance of attachment requests.
     * @see AutoAcceptSharedAttachmentsValue
     */
    public final AutoAcceptSharedAttachmentsValue autoAcceptSharedAttachments() {
        return AutoAcceptSharedAttachmentsValue.fromValue(autoAcceptSharedAttachments);
    }

    /**
     * <p>
     * Enable or disable automatic acceptance of attachment requests.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autoAcceptSharedAttachments} will return {@link AutoAcceptSharedAttachmentsValue#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #autoAcceptSharedAttachmentsAsString}.
     * </p>
     * 
     * @return Enable or disable automatic acceptance of attachment requests.
     * @see AutoAcceptSharedAttachmentsValue
     */
    public final String autoAcceptSharedAttachmentsAsString() {
        return autoAcceptSharedAttachments;
    }

    /**
     * <p>
     * Enable or disable automatic association with the default association route table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultRouteTableAssociation} will return
     * {@link DefaultRouteTableAssociationValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #defaultRouteTableAssociationAsString}.
     * </p>
     * 
     * @return Enable or disable automatic association with the default association route table.
     * @see DefaultRouteTableAssociationValue
     */
    public final DefaultRouteTableAssociationValue defaultRouteTableAssociation() {
        return DefaultRouteTableAssociationValue.fromValue(defaultRouteTableAssociation);
    }

    /**
     * <p>
     * Enable or disable automatic association with the default association route table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultRouteTableAssociation} will return
     * {@link DefaultRouteTableAssociationValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #defaultRouteTableAssociationAsString}.
     * </p>
     * 
     * @return Enable or disable automatic association with the default association route table.
     * @see DefaultRouteTableAssociationValue
     */
    public final String defaultRouteTableAssociationAsString() {
        return defaultRouteTableAssociation;
    }

    /**
     * <p>
     * The ID of the default association route table.
     * </p>
     * 
     * @return The ID of the default association route table.
     */
    public final String associationDefaultRouteTableId() {
        return associationDefaultRouteTableId;
    }

    /**
     * <p>
     * Enable or disable automatic propagation of routes to the default propagation route table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultRouteTablePropagation} will return
     * {@link DefaultRouteTablePropagationValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #defaultRouteTablePropagationAsString}.
     * </p>
     * 
     * @return Enable or disable automatic propagation of routes to the default propagation route table.
     * @see DefaultRouteTablePropagationValue
     */
    public final DefaultRouteTablePropagationValue defaultRouteTablePropagation() {
        return DefaultRouteTablePropagationValue.fromValue(defaultRouteTablePropagation);
    }

    /**
     * <p>
     * Enable or disable automatic propagation of routes to the default propagation route table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultRouteTablePropagation} will return
     * {@link DefaultRouteTablePropagationValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #defaultRouteTablePropagationAsString}.
     * </p>
     * 
     * @return Enable or disable automatic propagation of routes to the default propagation route table.
     * @see DefaultRouteTablePropagationValue
     */
    public final String defaultRouteTablePropagationAsString() {
        return defaultRouteTablePropagation;
    }

    /**
     * <p>
     * The ID of the default propagation route table.
     * </p>
     * 
     * @return The ID of the default propagation route table.
     */
    public final String propagationDefaultRouteTableId() {
        return propagationDefaultRouteTableId;
    }

    /**
     * <p>
     * A private Autonomous System Number (ASN) for the Amazon side of a BGP session. The range is 64512 to 65534 for
     * 16-bit ASNs and 4200000000 to 4294967294 for 32-bit ASNs.
     * </p>
     * <p>
     * The modify ASN operation is not allowed on a transit gateway if it has the following attachments:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Dynamic VPN
     * </p>
     * </li>
     * <li>
     * <p>
     * Static VPN
     * </p>
     * </li>
     * <li>
     * <p>
     * Direct Connect Gateway
     * </p>
     * </li>
     * <li>
     * <p>
     * Connect
     * </p>
     * </li>
     * </ul>
     * <p>
     * You must first delete all transit gateway attachments configured prior to modifying the ASN on the transit
     * gateway.
     * </p>
     * 
     * @return A private Autonomous System Number (ASN) for the Amazon side of a BGP session. The range is 64512 to
     *         65534 for 16-bit ASNs and 4200000000 to 4294967294 for 32-bit ASNs.</p>
     *         <p>
     *         The modify ASN operation is not allowed on a transit gateway if it has the following attachments:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Dynamic VPN
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Static VPN
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Direct Connect Gateway
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Connect
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You must first delete all transit gateway attachments configured prior to modifying the ASN on the
     *         transit gateway.
     */
    public final Long amazonSideAsn() {
        return amazonSideAsn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAddTransitGatewayCidrBlocks() ? addTransitGatewayCidrBlocks() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasRemoveTransitGatewayCidrBlocks() ? removeTransitGatewayCidrBlocks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpnEcmpSupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dnsSupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroupReferencingSupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(autoAcceptSharedAttachmentsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(defaultRouteTableAssociationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(associationDefaultRouteTableId());
        hashCode = 31 * hashCode + Objects.hashCode(defaultRouteTablePropagationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(propagationDefaultRouteTableId());
        hashCode = 31 * hashCode + Objects.hashCode(amazonSideAsn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyTransitGatewayOptions)) {
            return false;
        }
        ModifyTransitGatewayOptions other = (ModifyTransitGatewayOptions) obj;
        return hasAddTransitGatewayCidrBlocks() == other.hasAddTransitGatewayCidrBlocks()
                && Objects.equals(addTransitGatewayCidrBlocks(), other.addTransitGatewayCidrBlocks())
                && hasRemoveTransitGatewayCidrBlocks() == other.hasRemoveTransitGatewayCidrBlocks()
                && Objects.equals(removeTransitGatewayCidrBlocks(), other.removeTransitGatewayCidrBlocks())
                && Objects.equals(vpnEcmpSupportAsString(), other.vpnEcmpSupportAsString())
                && Objects.equals(dnsSupportAsString(), other.dnsSupportAsString())
                && Objects.equals(securityGroupReferencingSupportAsString(), other.securityGroupReferencingSupportAsString())
                && Objects.equals(autoAcceptSharedAttachmentsAsString(), other.autoAcceptSharedAttachmentsAsString())
                && Objects.equals(defaultRouteTableAssociationAsString(), other.defaultRouteTableAssociationAsString())
                && Objects.equals(associationDefaultRouteTableId(), other.associationDefaultRouteTableId())
                && Objects.equals(defaultRouteTablePropagationAsString(), other.defaultRouteTablePropagationAsString())
                && Objects.equals(propagationDefaultRouteTableId(), other.propagationDefaultRouteTableId())
                && Objects.equals(amazonSideAsn(), other.amazonSideAsn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ModifyTransitGatewayOptions")
                .add("AddTransitGatewayCidrBlocks", hasAddTransitGatewayCidrBlocks() ? addTransitGatewayCidrBlocks() : null)
                .add("RemoveTransitGatewayCidrBlocks",
                        hasRemoveTransitGatewayCidrBlocks() ? removeTransitGatewayCidrBlocks() : null)
                .add("VpnEcmpSupport", vpnEcmpSupportAsString()).add("DnsSupport", dnsSupportAsString())
                .add("SecurityGroupReferencingSupport", securityGroupReferencingSupportAsString())
                .add("AutoAcceptSharedAttachments", autoAcceptSharedAttachmentsAsString())
                .add("DefaultRouteTableAssociation", defaultRouteTableAssociationAsString())
                .add("AssociationDefaultRouteTableId", associationDefaultRouteTableId())
                .add("DefaultRouteTablePropagation", defaultRouteTablePropagationAsString())
                .add("PropagationDefaultRouteTableId", propagationDefaultRouteTableId()).add("AmazonSideAsn", amazonSideAsn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AddTransitGatewayCidrBlocks":
            return Optional.ofNullable(clazz.cast(addTransitGatewayCidrBlocks()));
        case "RemoveTransitGatewayCidrBlocks":
            return Optional.ofNullable(clazz.cast(removeTransitGatewayCidrBlocks()));
        case "VpnEcmpSupport":
            return Optional.ofNullable(clazz.cast(vpnEcmpSupportAsString()));
        case "DnsSupport":
            return Optional.ofNullable(clazz.cast(dnsSupportAsString()));
        case "SecurityGroupReferencingSupport":
            return Optional.ofNullable(clazz.cast(securityGroupReferencingSupportAsString()));
        case "AutoAcceptSharedAttachments":
            return Optional.ofNullable(clazz.cast(autoAcceptSharedAttachmentsAsString()));
        case "DefaultRouteTableAssociation":
            return Optional.ofNullable(clazz.cast(defaultRouteTableAssociationAsString()));
        case "AssociationDefaultRouteTableId":
            return Optional.ofNullable(clazz.cast(associationDefaultRouteTableId()));
        case "DefaultRouteTablePropagation":
            return Optional.ofNullable(clazz.cast(defaultRouteTablePropagationAsString()));
        case "PropagationDefaultRouteTableId":
            return Optional.ofNullable(clazz.cast(propagationDefaultRouteTableId()));
        case "AmazonSideAsn":
            return Optional.ofNullable(clazz.cast(amazonSideAsn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyTransitGatewayOptions, T> g) {
        return obj -> g.apply((ModifyTransitGatewayOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModifyTransitGatewayOptions> {
        /**
         * <p>
         * Adds IPv4 or IPv6 CIDR blocks for the transit gateway. Must be a size /24 CIDR block or larger for IPv4, or a
         * size /64 CIDR block or larger for IPv6.
         * </p>
         * 
         * @param addTransitGatewayCidrBlocks
         *        Adds IPv4 or IPv6 CIDR blocks for the transit gateway. Must be a size /24 CIDR block or larger for
         *        IPv4, or a size /64 CIDR block or larger for IPv6.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addTransitGatewayCidrBlocks(Collection<String> addTransitGatewayCidrBlocks);

        /**
         * <p>
         * Adds IPv4 or IPv6 CIDR blocks for the transit gateway. Must be a size /24 CIDR block or larger for IPv4, or a
         * size /64 CIDR block or larger for IPv6.
         * </p>
         * 
         * @param addTransitGatewayCidrBlocks
         *        Adds IPv4 or IPv6 CIDR blocks for the transit gateway. Must be a size /24 CIDR block or larger for
         *        IPv4, or a size /64 CIDR block or larger for IPv6.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addTransitGatewayCidrBlocks(String... addTransitGatewayCidrBlocks);

        /**
         * <p>
         * Removes CIDR blocks for the transit gateway.
         * </p>
         * 
         * @param removeTransitGatewayCidrBlocks
         *        Removes CIDR blocks for the transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeTransitGatewayCidrBlocks(Collection<String> removeTransitGatewayCidrBlocks);

        /**
         * <p>
         * Removes CIDR blocks for the transit gateway.
         * </p>
         * 
         * @param removeTransitGatewayCidrBlocks
         *        Removes CIDR blocks for the transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeTransitGatewayCidrBlocks(String... removeTransitGatewayCidrBlocks);

        /**
         * <p>
         * Enable or disable Equal Cost Multipath Protocol support.
         * </p>
         * 
         * @param vpnEcmpSupport
         *        Enable or disable Equal Cost Multipath Protocol support.
         * @see VpnEcmpSupportValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpnEcmpSupportValue
         */
        Builder vpnEcmpSupport(String vpnEcmpSupport);

        /**
         * <p>
         * Enable or disable Equal Cost Multipath Protocol support.
         * </p>
         * 
         * @param vpnEcmpSupport
         *        Enable or disable Equal Cost Multipath Protocol support.
         * @see VpnEcmpSupportValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpnEcmpSupportValue
         */
        Builder vpnEcmpSupport(VpnEcmpSupportValue vpnEcmpSupport);

        /**
         * <p>
         * Enable or disable DNS support.
         * </p>
         * 
         * @param dnsSupport
         *        Enable or disable DNS support.
         * @see DnsSupportValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsSupportValue
         */
        Builder dnsSupport(String dnsSupport);

        /**
         * <p>
         * Enable or disable DNS support.
         * </p>
         * 
         * @param dnsSupport
         *        Enable or disable DNS support.
         * @see DnsSupportValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsSupportValue
         */
        Builder dnsSupport(DnsSupportValue dnsSupport);

        /**
         * <p>
         * Enables you to reference a security group across VPCs attached to a transit gateway to simplify security
         * group management.
         * </p>
         * <p>
         * This option is disabled by default.
         * </p>
         * <p>
         * For more information about security group referencing, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/tgw/tgw-vpc-attachments.html#vpc-attachment-security">Security
         * group referencing</a> in the <i>Amazon Web Services Transit Gateways Guide</i>.
         * </p>
         * 
         * @param securityGroupReferencingSupport
         *        Enables you to reference a security group across VPCs attached to a transit gateway to simplify
         *        security group management. </p>
         *        <p>
         *        This option is disabled by default.
         *        </p>
         *        <p>
         *        For more information about security group referencing, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/tgw/tgw-vpc-attachments.html#vpc-attachment-security"
         *        >Security group referencing</a> in the <i>Amazon Web Services Transit Gateways Guide</i>.
         * @see SecurityGroupReferencingSupportValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecurityGroupReferencingSupportValue
         */
        Builder securityGroupReferencingSupport(String securityGroupReferencingSupport);

        /**
         * <p>
         * Enables you to reference a security group across VPCs attached to a transit gateway to simplify security
         * group management.
         * </p>
         * <p>
         * This option is disabled by default.
         * </p>
         * <p>
         * For more information about security group referencing, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/tgw/tgw-vpc-attachments.html#vpc-attachment-security">Security
         * group referencing</a> in the <i>Amazon Web Services Transit Gateways Guide</i>.
         * </p>
         * 
         * @param securityGroupReferencingSupport
         *        Enables you to reference a security group across VPCs attached to a transit gateway to simplify
         *        security group management. </p>
         *        <p>
         *        This option is disabled by default.
         *        </p>
         *        <p>
         *        For more information about security group referencing, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/tgw/tgw-vpc-attachments.html#vpc-attachment-security"
         *        >Security group referencing</a> in the <i>Amazon Web Services Transit Gateways Guide</i>.
         * @see SecurityGroupReferencingSupportValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecurityGroupReferencingSupportValue
         */
        Builder securityGroupReferencingSupport(SecurityGroupReferencingSupportValue securityGroupReferencingSupport);

        /**
         * <p>
         * Enable or disable automatic acceptance of attachment requests.
         * </p>
         * 
         * @param autoAcceptSharedAttachments
         *        Enable or disable automatic acceptance of attachment requests.
         * @see AutoAcceptSharedAttachmentsValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoAcceptSharedAttachmentsValue
         */
        Builder autoAcceptSharedAttachments(String autoAcceptSharedAttachments);

        /**
         * <p>
         * Enable or disable automatic acceptance of attachment requests.
         * </p>
         * 
         * @param autoAcceptSharedAttachments
         *        Enable or disable automatic acceptance of attachment requests.
         * @see AutoAcceptSharedAttachmentsValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoAcceptSharedAttachmentsValue
         */
        Builder autoAcceptSharedAttachments(AutoAcceptSharedAttachmentsValue autoAcceptSharedAttachments);

        /**
         * <p>
         * Enable or disable automatic association with the default association route table.
         * </p>
         * 
         * @param defaultRouteTableAssociation
         *        Enable or disable automatic association with the default association route table.
         * @see DefaultRouteTableAssociationValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultRouteTableAssociationValue
         */
        Builder defaultRouteTableAssociation(String defaultRouteTableAssociation);

        /**
         * <p>
         * Enable or disable automatic association with the default association route table.
         * </p>
         * 
         * @param defaultRouteTableAssociation
         *        Enable or disable automatic association with the default association route table.
         * @see DefaultRouteTableAssociationValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultRouteTableAssociationValue
         */
        Builder defaultRouteTableAssociation(DefaultRouteTableAssociationValue defaultRouteTableAssociation);

        /**
         * <p>
         * The ID of the default association route table.
         * </p>
         * 
         * @param associationDefaultRouteTableId
         *        The ID of the default association route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationDefaultRouteTableId(String associationDefaultRouteTableId);

        /**
         * <p>
         * Enable or disable automatic propagation of routes to the default propagation route table.
         * </p>
         * 
         * @param defaultRouteTablePropagation
         *        Enable or disable automatic propagation of routes to the default propagation route table.
         * @see DefaultRouteTablePropagationValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultRouteTablePropagationValue
         */
        Builder defaultRouteTablePropagation(String defaultRouteTablePropagation);

        /**
         * <p>
         * Enable or disable automatic propagation of routes to the default propagation route table.
         * </p>
         * 
         * @param defaultRouteTablePropagation
         *        Enable or disable automatic propagation of routes to the default propagation route table.
         * @see DefaultRouteTablePropagationValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultRouteTablePropagationValue
         */
        Builder defaultRouteTablePropagation(DefaultRouteTablePropagationValue defaultRouteTablePropagation);

        /**
         * <p>
         * The ID of the default propagation route table.
         * </p>
         * 
         * @param propagationDefaultRouteTableId
         *        The ID of the default propagation route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propagationDefaultRouteTableId(String propagationDefaultRouteTableId);

        /**
         * <p>
         * A private Autonomous System Number (ASN) for the Amazon side of a BGP session. The range is 64512 to 65534
         * for 16-bit ASNs and 4200000000 to 4294967294 for 32-bit ASNs.
         * </p>
         * <p>
         * The modify ASN operation is not allowed on a transit gateway if it has the following attachments:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Dynamic VPN
         * </p>
         * </li>
         * <li>
         * <p>
         * Static VPN
         * </p>
         * </li>
         * <li>
         * <p>
         * Direct Connect Gateway
         * </p>
         * </li>
         * <li>
         * <p>
         * Connect
         * </p>
         * </li>
         * </ul>
         * <p>
         * You must first delete all transit gateway attachments configured prior to modifying the ASN on the transit
         * gateway.
         * </p>
         * 
         * @param amazonSideAsn
         *        A private Autonomous System Number (ASN) for the Amazon side of a BGP session. The range is 64512 to
         *        65534 for 16-bit ASNs and 4200000000 to 4294967294 for 32-bit ASNs.</p>
         *        <p>
         *        The modify ASN operation is not allowed on a transit gateway if it has the following attachments:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Dynamic VPN
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Static VPN
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Direct Connect Gateway
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Connect
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You must first delete all transit gateway attachments configured prior to modifying the ASN on the
         *        transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonSideAsn(Long amazonSideAsn);
    }

    static final class BuilderImpl implements Builder {
        private List<String> addTransitGatewayCidrBlocks = DefaultSdkAutoConstructList.getInstance();

        private List<String> removeTransitGatewayCidrBlocks = DefaultSdkAutoConstructList.getInstance();

        private String vpnEcmpSupport;

        private String dnsSupport;

        private String securityGroupReferencingSupport;

        private String autoAcceptSharedAttachments;

        private String defaultRouteTableAssociation;

        private String associationDefaultRouteTableId;

        private String defaultRouteTablePropagation;

        private String propagationDefaultRouteTableId;

        private Long amazonSideAsn;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyTransitGatewayOptions model) {
            addTransitGatewayCidrBlocks(model.addTransitGatewayCidrBlocks);
            removeTransitGatewayCidrBlocks(model.removeTransitGatewayCidrBlocks);
            vpnEcmpSupport(model.vpnEcmpSupport);
            dnsSupport(model.dnsSupport);
            securityGroupReferencingSupport(model.securityGroupReferencingSupport);
            autoAcceptSharedAttachments(model.autoAcceptSharedAttachments);
            defaultRouteTableAssociation(model.defaultRouteTableAssociation);
            associationDefaultRouteTableId(model.associationDefaultRouteTableId);
            defaultRouteTablePropagation(model.defaultRouteTablePropagation);
            propagationDefaultRouteTableId(model.propagationDefaultRouteTableId);
            amazonSideAsn(model.amazonSideAsn);
        }

        public final Collection<String> getAddTransitGatewayCidrBlocks() {
            if (addTransitGatewayCidrBlocks instanceof SdkAutoConstructList) {
                return null;
            }
            return addTransitGatewayCidrBlocks;
        }

        public final void setAddTransitGatewayCidrBlocks(Collection<String> addTransitGatewayCidrBlocks) {
            this.addTransitGatewayCidrBlocks = TransitGatewayCidrBlockStringListCopier.copy(addTransitGatewayCidrBlocks);
        }

        @Override
        public final Builder addTransitGatewayCidrBlocks(Collection<String> addTransitGatewayCidrBlocks) {
            this.addTransitGatewayCidrBlocks = TransitGatewayCidrBlockStringListCopier.copy(addTransitGatewayCidrBlocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addTransitGatewayCidrBlocks(String... addTransitGatewayCidrBlocks) {
            addTransitGatewayCidrBlocks(Arrays.asList(addTransitGatewayCidrBlocks));
            return this;
        }

        public final Collection<String> getRemoveTransitGatewayCidrBlocks() {
            if (removeTransitGatewayCidrBlocks instanceof SdkAutoConstructList) {
                return null;
            }
            return removeTransitGatewayCidrBlocks;
        }

        public final void setRemoveTransitGatewayCidrBlocks(Collection<String> removeTransitGatewayCidrBlocks) {
            this.removeTransitGatewayCidrBlocks = TransitGatewayCidrBlockStringListCopier.copy(removeTransitGatewayCidrBlocks);
        }

        @Override
        public final Builder removeTransitGatewayCidrBlocks(Collection<String> removeTransitGatewayCidrBlocks) {
            this.removeTransitGatewayCidrBlocks = TransitGatewayCidrBlockStringListCopier.copy(removeTransitGatewayCidrBlocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeTransitGatewayCidrBlocks(String... removeTransitGatewayCidrBlocks) {
            removeTransitGatewayCidrBlocks(Arrays.asList(removeTransitGatewayCidrBlocks));
            return this;
        }

        public final String getVpnEcmpSupport() {
            return vpnEcmpSupport;
        }

        public final void setVpnEcmpSupport(String vpnEcmpSupport) {
            this.vpnEcmpSupport = vpnEcmpSupport;
        }

        @Override
        public final Builder vpnEcmpSupport(String vpnEcmpSupport) {
            this.vpnEcmpSupport = vpnEcmpSupport;
            return this;
        }

        @Override
        public final Builder vpnEcmpSupport(VpnEcmpSupportValue vpnEcmpSupport) {
            this.vpnEcmpSupport(vpnEcmpSupport == null ? null : vpnEcmpSupport.toString());
            return this;
        }

        public final String getDnsSupport() {
            return dnsSupport;
        }

        public final void setDnsSupport(String dnsSupport) {
            this.dnsSupport = dnsSupport;
        }

        @Override
        public final Builder dnsSupport(String dnsSupport) {
            this.dnsSupport = dnsSupport;
            return this;
        }

        @Override
        public final Builder dnsSupport(DnsSupportValue dnsSupport) {
            this.dnsSupport(dnsSupport == null ? null : dnsSupport.toString());
            return this;
        }

        public final String getSecurityGroupReferencingSupport() {
            return securityGroupReferencingSupport;
        }

        public final void setSecurityGroupReferencingSupport(String securityGroupReferencingSupport) {
            this.securityGroupReferencingSupport = securityGroupReferencingSupport;
        }

        @Override
        public final Builder securityGroupReferencingSupport(String securityGroupReferencingSupport) {
            this.securityGroupReferencingSupport = securityGroupReferencingSupport;
            return this;
        }

        @Override
        public final Builder securityGroupReferencingSupport(SecurityGroupReferencingSupportValue securityGroupReferencingSupport) {
            this.securityGroupReferencingSupport(securityGroupReferencingSupport == null ? null : securityGroupReferencingSupport
                    .toString());
            return this;
        }

        public final String getAutoAcceptSharedAttachments() {
            return autoAcceptSharedAttachments;
        }

        public final void setAutoAcceptSharedAttachments(String autoAcceptSharedAttachments) {
            this.autoAcceptSharedAttachments = autoAcceptSharedAttachments;
        }

        @Override
        public final Builder autoAcceptSharedAttachments(String autoAcceptSharedAttachments) {
            this.autoAcceptSharedAttachments = autoAcceptSharedAttachments;
            return this;
        }

        @Override
        public final Builder autoAcceptSharedAttachments(AutoAcceptSharedAttachmentsValue autoAcceptSharedAttachments) {
            this.autoAcceptSharedAttachments(autoAcceptSharedAttachments == null ? null : autoAcceptSharedAttachments.toString());
            return this;
        }

        public final String getDefaultRouteTableAssociation() {
            return defaultRouteTableAssociation;
        }

        public final void setDefaultRouteTableAssociation(String defaultRouteTableAssociation) {
            this.defaultRouteTableAssociation = defaultRouteTableAssociation;
        }

        @Override
        public final Builder defaultRouteTableAssociation(String defaultRouteTableAssociation) {
            this.defaultRouteTableAssociation = defaultRouteTableAssociation;
            return this;
        }

        @Override
        public final Builder defaultRouteTableAssociation(DefaultRouteTableAssociationValue defaultRouteTableAssociation) {
            this.defaultRouteTableAssociation(defaultRouteTableAssociation == null ? null : defaultRouteTableAssociation
                    .toString());
            return this;
        }

        public final String getAssociationDefaultRouteTableId() {
            return associationDefaultRouteTableId;
        }

        public final void setAssociationDefaultRouteTableId(String associationDefaultRouteTableId) {
            this.associationDefaultRouteTableId = associationDefaultRouteTableId;
        }

        @Override
        public final Builder associationDefaultRouteTableId(String associationDefaultRouteTableId) {
            this.associationDefaultRouteTableId = associationDefaultRouteTableId;
            return this;
        }

        public final String getDefaultRouteTablePropagation() {
            return defaultRouteTablePropagation;
        }

        public final void setDefaultRouteTablePropagation(String defaultRouteTablePropagation) {
            this.defaultRouteTablePropagation = defaultRouteTablePropagation;
        }

        @Override
        public final Builder defaultRouteTablePropagation(String defaultRouteTablePropagation) {
            this.defaultRouteTablePropagation = defaultRouteTablePropagation;
            return this;
        }

        @Override
        public final Builder defaultRouteTablePropagation(DefaultRouteTablePropagationValue defaultRouteTablePropagation) {
            this.defaultRouteTablePropagation(defaultRouteTablePropagation == null ? null : defaultRouteTablePropagation
                    .toString());
            return this;
        }

        public final String getPropagationDefaultRouteTableId() {
            return propagationDefaultRouteTableId;
        }

        public final void setPropagationDefaultRouteTableId(String propagationDefaultRouteTableId) {
            this.propagationDefaultRouteTableId = propagationDefaultRouteTableId;
        }

        @Override
        public final Builder propagationDefaultRouteTableId(String propagationDefaultRouteTableId) {
            this.propagationDefaultRouteTableId = propagationDefaultRouteTableId;
            return this;
        }

        public final Long getAmazonSideAsn() {
            return amazonSideAsn;
        }

        public final void setAmazonSideAsn(Long amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
        }

        @Override
        public final Builder amazonSideAsn(Long amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
            return this;
        }

        @Override
        public ModifyTransitGatewayOptions build() {
            return new ModifyTransitGatewayOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
