/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAddressesRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeAddressesRequest.Builder, DescribeAddressesRequest> {
    private static final SdkField<List<String>> PUBLIC_IPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PublicIps")
            .getter(getter(DescribeAddressesRequest::publicIps))
            .setter(setter(Builder::publicIps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIp")
                    .unmarshallLocationName("PublicIp").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("PublicIp")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("PublicIp").unmarshallLocationName("PublicIp").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(DescribeAddressesRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("dryRun").build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeAddressesRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> ALLOCATION_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AllocationIds")
            .getter(getter(DescribeAddressesRequest::allocationIds))
            .setter(setter(Builder::allocationIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationId")
                    .unmarshallLocationName("AllocationId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("AllocationId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("AllocationId").unmarshallLocationName("AllocationId").build())
                                            .build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLIC_IPS_FIELD,
            DRY_RUN_FIELD, FILTERS_FIELD, ALLOCATION_IDS_FIELD));

    private final List<String> publicIps;

    private final Boolean dryRun;

    private final List<Filter> filters;

    private final List<String> allocationIds;

    private DescribeAddressesRequest(BuilderImpl builder) {
        super(builder);
        this.publicIps = builder.publicIps;
        this.dryRun = builder.dryRun;
        this.filters = builder.filters;
        this.allocationIds = builder.allocationIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the PublicIps property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPublicIps() {
        return publicIps != null && !(publicIps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more Elastic IP addresses.
     * </p>
     * <p>
     * Default: Describes all your Elastic IP addresses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPublicIps} method.
     * </p>
     * 
     * @return One or more Elastic IP addresses.</p>
     *         <p>
     *         Default: Describes all your Elastic IP addresses.
     */
    public final List<String> publicIps() {
        return publicIps;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more filters. Filter names and values are case-sensitive.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>allocation-id</code> - The allocation ID for the address.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>association-id</code> - The association ID for the address.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-id</code> - The ID of the instance the address is associated with, if any.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-border-group</code> - A unique set of Availability Zones, Local Zones, or Wavelength Zones from
     * where Amazon Web Services advertises IP addresses.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface-id</code> - The ID of the network interface that the address is associated with, if any.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface-owner-id</code> - The Amazon Web Services account ID of the owner.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>private-ip-address</code> - The private IP address associated with the Elastic IP address.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>public-ip</code> - The Elastic IP address, or the carrier IP address.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in
     * the filter name and the tag value as the filter value. For example, to find all resources that have a tag with
     * the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name
     * and <code>TeamA</code> for the filter value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned
     * a tag with a specific key, regardless of the tag value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return One or more filters. Filter names and values are case-sensitive.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>allocation-id</code> - The allocation ID for the address.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>association-id</code> - The association ID for the address.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-id</code> - The ID of the instance the address is associated with, if any.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-border-group</code> - A unique set of Availability Zones, Local Zones, or Wavelength Zones
     *         from where Amazon Web Services advertises IP addresses.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface-id</code> - The ID of the network interface that the address is associated with,
     *         if any.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface-owner-id</code> - The Amazon Web Services account ID of the owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>private-ip-address</code> - The private IP address associated with the Elastic IP address.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>public-ip</code> - The Elastic IP address, or the carrier IP address.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag
     *         key in the filter name and the tag value as the filter value. For example, to find all resources that
     *         have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
     *         <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
     *         assigned a tag with a specific key, regardless of the tag value.
     *         </p>
     *         </li>
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllocationIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllocationIds() {
        return allocationIds != null && !(allocationIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the allocation IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllocationIds} method.
     * </p>
     * 
     * @return Information about the allocation IDs.
     */
    public final List<String> allocationIds() {
        return allocationIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPublicIps() ? publicIps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAllocationIds() ? allocationIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAddressesRequest)) {
            return false;
        }
        DescribeAddressesRequest other = (DescribeAddressesRequest) obj;
        return hasPublicIps() == other.hasPublicIps() && Objects.equals(publicIps(), other.publicIps())
                && Objects.equals(dryRun(), other.dryRun()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters()) && hasAllocationIds() == other.hasAllocationIds()
                && Objects.equals(allocationIds(), other.allocationIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAddressesRequest").add("PublicIps", hasPublicIps() ? publicIps() : null)
                .add("DryRun", dryRun()).add("Filters", hasFilters() ? filters() : null)
                .add("AllocationIds", hasAllocationIds() ? allocationIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PublicIps":
            return Optional.ofNullable(clazz.cast(publicIps()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "AllocationIds":
            return Optional.ofNullable(clazz.cast(allocationIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAddressesRequest, T> g) {
        return obj -> g.apply((DescribeAddressesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAddressesRequest> {
        /**
         * <p>
         * One or more Elastic IP addresses.
         * </p>
         * <p>
         * Default: Describes all your Elastic IP addresses.
         * </p>
         * 
         * @param publicIps
         *        One or more Elastic IP addresses.</p>
         *        <p>
         *        Default: Describes all your Elastic IP addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIps(Collection<String> publicIps);

        /**
         * <p>
         * One or more Elastic IP addresses.
         * </p>
         * <p>
         * Default: Describes all your Elastic IP addresses.
         * </p>
         * 
         * @param publicIps
         *        One or more Elastic IP addresses.</p>
         *        <p>
         *        Default: Describes all your Elastic IP addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIps(String... publicIps);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * One or more filters. Filter names and values are case-sensitive.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>allocation-id</code> - The allocation ID for the address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association-id</code> - The association ID for the address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-id</code> - The ID of the instance the address is associated with, if any.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-border-group</code> - A unique set of Availability Zones, Local Zones, or Wavelength Zones from
         * where Amazon Web Services advertises IP addresses.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface-id</code> - The ID of the network interface that the address is associated with, if
         * any.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface-owner-id</code> - The Amazon Web Services account ID of the owner.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-ip-address</code> - The private IP address associated with the Elastic IP address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>public-ip</code> - The Elastic IP address, or the carrier IP address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters. Filter names and values are case-sensitive.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>allocation-id</code> - The allocation ID for the address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association-id</code> - The association ID for the address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-id</code> - The ID of the instance the address is associated with, if any.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-border-group</code> - A unique set of Availability Zones, Local Zones, or Wavelength
         *        Zones from where Amazon Web Services advertises IP addresses.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface-id</code> - The ID of the network interface that the address is associated
         *        with, if any.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface-owner-id</code> - The Amazon Web Services account ID of the owner.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>private-ip-address</code> - The private IP address associated with the Elastic IP address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>public-ip</code> - The Elastic IP address, or the carrier IP address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the
         *        tag key in the filter name and the tag value as the filter value. For example, to find all resources
         *        that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
         *        <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all
         *        resources assigned a tag with a specific key, regardless of the tag value.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters. Filter names and values are case-sensitive.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>allocation-id</code> - The allocation ID for the address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association-id</code> - The association ID for the address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-id</code> - The ID of the instance the address is associated with, if any.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-border-group</code> - A unique set of Availability Zones, Local Zones, or Wavelength Zones from
         * where Amazon Web Services advertises IP addresses.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface-id</code> - The ID of the network interface that the address is associated with, if
         * any.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface-owner-id</code> - The Amazon Web Services account ID of the owner.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-ip-address</code> - The private IP address associated with the Elastic IP address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>public-ip</code> - The Elastic IP address, or the carrier IP address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters. Filter names and values are case-sensitive.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>allocation-id</code> - The allocation ID for the address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association-id</code> - The association ID for the address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-id</code> - The ID of the instance the address is associated with, if any.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-border-group</code> - A unique set of Availability Zones, Local Zones, or Wavelength
         *        Zones from where Amazon Web Services advertises IP addresses.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface-id</code> - The ID of the network interface that the address is associated
         *        with, if any.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface-owner-id</code> - The Amazon Web Services account ID of the owner.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>private-ip-address</code> - The private IP address associated with the Elastic IP address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>public-ip</code> - The Elastic IP address, or the carrier IP address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the
         *        tag key in the filter name and the tag value as the filter value. For example, to find all resources
         *        that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
         *        <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all
         *        resources assigned a tag with a specific key, regardless of the tag value.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more filters. Filter names and values are case-sensitive.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>allocation-id</code> - The allocation ID for the address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association-id</code> - The association ID for the address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-id</code> - The ID of the instance the address is associated with, if any.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-border-group</code> - A unique set of Availability Zones, Local Zones, or Wavelength Zones from
         * where Amazon Web Services advertises IP addresses.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface-id</code> - The ID of the network interface that the address is associated with, if
         * any.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface-owner-id</code> - The Amazon Web Services account ID of the owner.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-ip-address</code> - The private IP address associated with the Elastic IP address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>public-ip</code> - The Elastic IP address, or the carrier IP address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Filter.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Filter.Builder#build()}
         * is called immediately and its result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * Information about the allocation IDs.
         * </p>
         * 
         * @param allocationIds
         *        Information about the allocation IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocationIds(Collection<String> allocationIds);

        /**
         * <p>
         * Information about the allocation IDs.
         * </p>
         * 
         * @param allocationIds
         *        Information about the allocation IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocationIds(String... allocationIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<String> publicIps = DefaultSdkAutoConstructList.getInstance();

        private Boolean dryRun;

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private List<String> allocationIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAddressesRequest model) {
            super(model);
            publicIps(model.publicIps);
            dryRun(model.dryRun);
            filters(model.filters);
            allocationIds(model.allocationIds);
        }

        public final Collection<String> getPublicIps() {
            if (publicIps instanceof SdkAutoConstructList) {
                return null;
            }
            return publicIps;
        }

        public final void setPublicIps(Collection<String> publicIps) {
            this.publicIps = PublicIpStringListCopier.copy(publicIps);
        }

        @Override
        public final Builder publicIps(Collection<String> publicIps) {
            this.publicIps = PublicIpStringListCopier.copy(publicIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder publicIps(String... publicIps) {
            publicIps(Arrays.asList(publicIps));
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAllocationIds() {
            if (allocationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return allocationIds;
        }

        public final void setAllocationIds(Collection<String> allocationIds) {
            this.allocationIds = AllocationIdListCopier.copy(allocationIds);
        }

        @Override
        public final Builder allocationIds(Collection<String> allocationIds) {
            this.allocationIds = AllocationIdListCopier.copy(allocationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allocationIds(String... allocationIds) {
            allocationIds(Arrays.asList(allocationIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAddressesRequest build() {
            return new DescribeAddressesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
