/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for UnassignPrivateIpAddresses.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UnassignPrivateIpAddressesRequest extends Ec2Request implements
        ToCopyableBuilder<UnassignPrivateIpAddressesRequest.Builder, UnassignPrivateIpAddressesRequest> {
    private static final SdkField<List<String>> IPV4_PREFIXES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Ipv4Prefixes")
            .getter(getter(UnassignPrivateIpAddressesRequest::ipv4Prefixes))
            .setter(setter(Builder::ipv4Prefixes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4Prefix")
                    .unmarshallLocationName("Ipv4Prefix").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceId")
            .getter(getter(UnassignPrivateIpAddressesRequest::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId")
                    .unmarshallLocationName("networkInterfaceId").build()).build();

    private static final SdkField<List<String>> PRIVATE_IP_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PrivateIpAddresses")
            .getter(getter(UnassignPrivateIpAddressesRequest::privateIpAddresses))
            .setter(setter(Builder::privateIpAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress")
                    .unmarshallLocationName("privateIpAddress").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("PrivateIpAddress")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("PrivateIpAddress").unmarshallLocationName("PrivateIpAddress")
                                                    .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPV4_PREFIXES_FIELD,
            NETWORK_INTERFACE_ID_FIELD, PRIVATE_IP_ADDRESSES_FIELD));

    private final List<String> ipv4Prefixes;

    private final String networkInterfaceId;

    private final List<String> privateIpAddresses;

    private UnassignPrivateIpAddressesRequest(BuilderImpl builder) {
        super(builder);
        this.ipv4Prefixes = builder.ipv4Prefixes;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.privateIpAddresses = builder.privateIpAddresses;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ipv4Prefixes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpv4Prefixes() {
        return ipv4Prefixes != null && !(ipv4Prefixes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IPv4 prefixes to unassign from the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpv4Prefixes} method.
     * </p>
     * 
     * @return The IPv4 prefixes to unassign from the network interface.
     */
    public final List<String> ipv4Prefixes() {
        return ipv4Prefixes;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public final String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the PrivateIpAddresses property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPrivateIpAddresses() {
        return privateIpAddresses != null && !(privateIpAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The secondary private IP addresses to unassign from the network interface. You can specify this option multiple
     * times to unassign more than one IP address.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrivateIpAddresses} method.
     * </p>
     * 
     * @return The secondary private IP addresses to unassign from the network interface. You can specify this option
     *         multiple times to unassign more than one IP address.
     */
    public final List<String> privateIpAddresses() {
        return privateIpAddresses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasIpv4Prefixes() ? ipv4Prefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrivateIpAddresses() ? privateIpAddresses() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnassignPrivateIpAddressesRequest)) {
            return false;
        }
        UnassignPrivateIpAddressesRequest other = (UnassignPrivateIpAddressesRequest) obj;
        return hasIpv4Prefixes() == other.hasIpv4Prefixes() && Objects.equals(ipv4Prefixes(), other.ipv4Prefixes())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && hasPrivateIpAddresses() == other.hasPrivateIpAddresses()
                && Objects.equals(privateIpAddresses(), other.privateIpAddresses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UnassignPrivateIpAddressesRequest")
                .add("Ipv4Prefixes", hasIpv4Prefixes() ? ipv4Prefixes() : null).add("NetworkInterfaceId", networkInterfaceId())
                .add("PrivateIpAddresses", hasPrivateIpAddresses() ? privateIpAddresses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ipv4Prefixes":
            return Optional.ofNullable(clazz.cast(ipv4Prefixes()));
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "PrivateIpAddresses":
            return Optional.ofNullable(clazz.cast(privateIpAddresses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UnassignPrivateIpAddressesRequest, T> g) {
        return obj -> g.apply((UnassignPrivateIpAddressesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, UnassignPrivateIpAddressesRequest> {
        /**
         * <p>
         * The IPv4 prefixes to unassign from the network interface.
         * </p>
         * 
         * @param ipv4Prefixes
         *        The IPv4 prefixes to unassign from the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4Prefixes(Collection<String> ipv4Prefixes);

        /**
         * <p>
         * The IPv4 prefixes to unassign from the network interface.
         * </p>
         * 
         * @param ipv4Prefixes
         *        The IPv4 prefixes to unassign from the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4Prefixes(String... ipv4Prefixes);

        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The secondary private IP addresses to unassign from the network interface. You can specify this option
         * multiple times to unassign more than one IP address.
         * </p>
         * 
         * @param privateIpAddresses
         *        The secondary private IP addresses to unassign from the network interface. You can specify this option
         *        multiple times to unassign more than one IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(Collection<String> privateIpAddresses);

        /**
         * <p>
         * The secondary private IP addresses to unassign from the network interface. You can specify this option
         * multiple times to unassign more than one IP address.
         * </p>
         * 
         * @param privateIpAddresses
         *        The secondary private IP addresses to unassign from the network interface. You can specify this option
         *        multiple times to unassign more than one IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(String... privateIpAddresses);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<String> ipv4Prefixes = DefaultSdkAutoConstructList.getInstance();

        private String networkInterfaceId;

        private List<String> privateIpAddresses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UnassignPrivateIpAddressesRequest model) {
            super(model);
            ipv4Prefixes(model.ipv4Prefixes);
            networkInterfaceId(model.networkInterfaceId);
            privateIpAddresses(model.privateIpAddresses);
        }

        public final Collection<String> getIpv4Prefixes() {
            if (ipv4Prefixes instanceof SdkAutoConstructList) {
                return null;
            }
            return ipv4Prefixes;
        }

        public final void setIpv4Prefixes(Collection<String> ipv4Prefixes) {
            this.ipv4Prefixes = IpPrefixListCopier.copy(ipv4Prefixes);
        }

        @Override
        public final Builder ipv4Prefixes(Collection<String> ipv4Prefixes) {
            this.ipv4Prefixes = IpPrefixListCopier.copy(ipv4Prefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv4Prefixes(String... ipv4Prefixes) {
            ipv4Prefixes(Arrays.asList(ipv4Prefixes));
            return this;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final Collection<String> getPrivateIpAddresses() {
            if (privateIpAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return privateIpAddresses;
        }

        public final void setPrivateIpAddresses(Collection<String> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressStringListCopier.copy(privateIpAddresses);
        }

        @Override
        public final Builder privateIpAddresses(Collection<String> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressStringListCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(String... privateIpAddresses) {
            privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UnassignPrivateIpAddressesRequest build() {
            return new UnassignPrivateIpAddressesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
