/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a security group and Amazon Web Services account ID pair.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserIdGroupPair implements SdkPojo, Serializable, ToCopyableBuilder<UserIdGroupPair.Builder, UserIdGroupPair> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(UserIdGroupPair::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("UserId")
            .getter(getter(UserIdGroupPair::userId))
            .setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId")
                    .unmarshallLocationName("userId").build()).build();

    private static final SdkField<String> GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupName")
            .getter(getter(UserIdGroupPair::groupName))
            .setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName")
                    .unmarshallLocationName("groupName").build()).build();

    private static final SdkField<String> GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupId")
            .getter(getter(UserIdGroupPair::groupId))
            .setter(setter(Builder::groupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId")
                    .unmarshallLocationName("groupId").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcId")
            .getter(getter(UserIdGroupPair::vpcId))
            .setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId")
                    .unmarshallLocationName("vpcId").build()).build();

    private static final SdkField<String> VPC_PEERING_CONNECTION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcPeeringConnectionId")
            .getter(getter(UserIdGroupPair::vpcPeeringConnectionId))
            .setter(setter(Builder::vpcPeeringConnectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcPeeringConnectionId")
                    .unmarshallLocationName("vpcPeeringConnectionId").build()).build();

    private static final SdkField<String> PEERING_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PeeringStatus")
            .getter(getter(UserIdGroupPair::peeringStatus))
            .setter(setter(Builder::peeringStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeeringStatus")
                    .unmarshallLocationName("peeringStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, USER_ID_FIELD, GROUP_NAME_FIELD, GROUP_ID_FIELD, VPC_ID_FIELD,
                    VPC_PEERING_CONNECTION_ID_FIELD, PEERING_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String description;

    private final String userId;

    private final String groupName;

    private final String groupId;

    private final String vpcId;

    private final String vpcPeeringConnectionId;

    private final String peeringStatus;

    private UserIdGroupPair(BuilderImpl builder) {
        this.description = builder.description;
        this.userId = builder.userId;
        this.groupName = builder.groupName;
        this.groupId = builder.groupId;
        this.vpcId = builder.vpcId;
        this.vpcPeeringConnectionId = builder.vpcPeeringConnectionId;
        this.peeringStatus = builder.peeringStatus;
    }

    /**
     * <p>
     * A description for the security group rule that references this user ID group pair.
     * </p>
     * <p>
     * Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9, spaces, and
     * ._-:/()#,@[]+=;{}!$*
     * </p>
     * 
     * @return A description for the security group rule that references this user ID group pair.</p>
     *         <p>
     *         Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9, spaces, and
     *         ._-:/()#,@[]+=;{}!$*
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of an Amazon Web Services account.
     * </p>
     * <p>
     * For a referenced security group in another VPC, the account ID of the referenced security group is returned in
     * the response. If the referenced security group is deleted, this value is not returned.
     * </p>
     * 
     * @return The ID of an Amazon Web Services account.</p>
     *         <p>
     *         For a referenced security group in another VPC, the account ID of the referenced security group is
     *         returned in the response. If the referenced security group is deleted, this value is not returned.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * [Default VPC] The name of the security group. For a security group in a nondefault VPC, use the security group
     * ID.
     * </p>
     * <p>
     * For a referenced security group in another VPC, this value is not returned if the referenced security group is
     * deleted.
     * </p>
     * 
     * @return [Default VPC] The name of the security group. For a security group in a nondefault VPC, use the security
     *         group ID. </p>
     *         <p>
     *         For a referenced security group in another VPC, this value is not returned if the referenced security
     *         group is deleted.
     */
    public final String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The ID of the security group.
     * </p>
     * 
     * @return The ID of the security group.
     */
    public final String groupId() {
        return groupId;
    }

    /**
     * <p>
     * The ID of the VPC for the referenced security group, if applicable.
     * </p>
     * 
     * @return The ID of the VPC for the referenced security group, if applicable.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The ID of the VPC peering connection, if applicable.
     * </p>
     * 
     * @return The ID of the VPC peering connection, if applicable.
     */
    public final String vpcPeeringConnectionId() {
        return vpcPeeringConnectionId;
    }

    /**
     * <p>
     * The status of a VPC peering connection, if applicable.
     * </p>
     * 
     * @return The status of a VPC peering connection, if applicable.
     */
    public final String peeringStatus() {
        return peeringStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcPeeringConnectionId());
        hashCode = 31 * hashCode + Objects.hashCode(peeringStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserIdGroupPair)) {
            return false;
        }
        UserIdGroupPair other = (UserIdGroupPair) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(userId(), other.userId())
                && Objects.equals(groupName(), other.groupName()) && Objects.equals(groupId(), other.groupId())
                && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(vpcPeeringConnectionId(), other.vpcPeeringConnectionId())
                && Objects.equals(peeringStatus(), other.peeringStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserIdGroupPair").add("Description", description()).add("UserId", userId())
                .add("GroupName", groupName()).add("GroupId", groupId()).add("VpcId", vpcId())
                .add("VpcPeeringConnectionId", vpcPeeringConnectionId()).add("PeeringStatus", peeringStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "GroupId":
            return Optional.ofNullable(clazz.cast(groupId()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "VpcPeeringConnectionId":
            return Optional.ofNullable(clazz.cast(vpcPeeringConnectionId()));
        case "PeeringStatus":
            return Optional.ofNullable(clazz.cast(peeringStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserIdGroupPair, T> g) {
        return obj -> g.apply((UserIdGroupPair) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserIdGroupPair> {
        /**
         * <p>
         * A description for the security group rule that references this user ID group pair.
         * </p>
         * <p>
         * Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9, spaces, and
         * ._-:/()#,@[]+=;{}!$*
         * </p>
         * 
         * @param description
         *        A description for the security group rule that references this user ID group pair.</p>
         *        <p>
         *        Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9, spaces, and
         *        ._-:/()#,@[]+=;{}!$*
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of an Amazon Web Services account.
         * </p>
         * <p>
         * For a referenced security group in another VPC, the account ID of the referenced security group is returned
         * in the response. If the referenced security group is deleted, this value is not returned.
         * </p>
         * 
         * @param userId
         *        The ID of an Amazon Web Services account.</p>
         *        <p>
         *        For a referenced security group in another VPC, the account ID of the referenced security group is
         *        returned in the response. If the referenced security group is deleted, this value is not returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * [Default VPC] The name of the security group. For a security group in a nondefault VPC, use the security
         * group ID.
         * </p>
         * <p>
         * For a referenced security group in another VPC, this value is not returned if the referenced security group
         * is deleted.
         * </p>
         * 
         * @param groupName
         *        [Default VPC] The name of the security group. For a security group in a nondefault VPC, use the
         *        security group ID. </p>
         *        <p>
         *        For a referenced security group in another VPC, this value is not returned if the referenced security
         *        group is deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The ID of the security group.
         * </p>
         * 
         * @param groupId
         *        The ID of the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * The ID of the VPC for the referenced security group, if applicable.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC for the referenced security group, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The ID of the VPC peering connection, if applicable.
         * </p>
         * 
         * @param vpcPeeringConnectionId
         *        The ID of the VPC peering connection, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcPeeringConnectionId(String vpcPeeringConnectionId);

        /**
         * <p>
         * The status of a VPC peering connection, if applicable.
         * </p>
         * 
         * @param peeringStatus
         *        The status of a VPC peering connection, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peeringStatus(String peeringStatus);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private String userId;

        private String groupName;

        private String groupId;

        private String vpcId;

        private String vpcPeeringConnectionId;

        private String peeringStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UserIdGroupPair model) {
            description(model.description);
            userId(model.userId);
            groupName(model.groupName);
            groupId(model.groupId);
            vpcId(model.vpcId);
            vpcPeeringConnectionId(model.vpcPeeringConnectionId);
            peeringStatus(model.peeringStatus);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getGroupName() {
            return groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getGroupId() {
            return groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getVpcPeeringConnectionId() {
            return vpcPeeringConnectionId;
        }

        public final void setVpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
        }

        @Override
        public final Builder vpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
            return this;
        }

        public final String getPeeringStatus() {
            return peeringStatus;
        }

        public final void setPeeringStatus(String peeringStatus) {
            this.peeringStatus = peeringStatus;
        }

        @Override
        public final Builder peeringStatus(String peeringStatus) {
            this.peeringStatus = peeringStatus;
            return this;
        }

        @Override
        public UserIdGroupPair build() {
            return new UserIdGroupPair(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
