/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateVpcCidrBlockRequest extends Ec2Request implements
        ToCopyableBuilder<AssociateVpcCidrBlockRequest.Builder, AssociateVpcCidrBlockRequest> {
    private static final SdkField<String> CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CidrBlock")
            .getter(getter(AssociateVpcCidrBlockRequest::cidrBlock))
            .setter(setter(Builder::cidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlock")
                    .unmarshallLocationName("CidrBlock").build()).build();

    private static final SdkField<String> IPV6_CIDR_BLOCK_NETWORK_BORDER_GROUP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Ipv6CidrBlockNetworkBorderGroup")
            .getter(getter(AssociateVpcCidrBlockRequest::ipv6CidrBlockNetworkBorderGroup))
            .setter(setter(Builder::ipv6CidrBlockNetworkBorderGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlockNetworkBorderGroup")
                    .unmarshallLocationName("Ipv6CidrBlockNetworkBorderGroup").build()).build();

    private static final SdkField<String> IPV6_POOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Ipv6Pool")
            .getter(getter(AssociateVpcCidrBlockRequest::ipv6Pool))
            .setter(setter(Builder::ipv6Pool))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Pool")
                    .unmarshallLocationName("Ipv6Pool").build()).build();

    private static final SdkField<String> IPV6_CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Ipv6CidrBlock")
            .getter(getter(AssociateVpcCidrBlockRequest::ipv6CidrBlock))
            .setter(setter(Builder::ipv6CidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlock")
                    .unmarshallLocationName("Ipv6CidrBlock").build()).build();

    private static final SdkField<String> IPV4_IPAM_POOL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Ipv4IpamPoolId")
            .getter(getter(AssociateVpcCidrBlockRequest::ipv4IpamPoolId))
            .setter(setter(Builder::ipv4IpamPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4IpamPoolId")
                    .unmarshallLocationName("Ipv4IpamPoolId").build()).build();

    private static final SdkField<Integer> IPV4_NETMASK_LENGTH_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Ipv4NetmaskLength")
            .getter(getter(AssociateVpcCidrBlockRequest::ipv4NetmaskLength))
            .setter(setter(Builder::ipv4NetmaskLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4NetmaskLength")
                    .unmarshallLocationName("Ipv4NetmaskLength").build()).build();

    private static final SdkField<String> IPV6_IPAM_POOL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Ipv6IpamPoolId")
            .getter(getter(AssociateVpcCidrBlockRequest::ipv6IpamPoolId))
            .setter(setter(Builder::ipv6IpamPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6IpamPoolId")
                    .unmarshallLocationName("Ipv6IpamPoolId").build()).build();

    private static final SdkField<Integer> IPV6_NETMASK_LENGTH_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Ipv6NetmaskLength")
            .getter(getter(AssociateVpcCidrBlockRequest::ipv6NetmaskLength))
            .setter(setter(Builder::ipv6NetmaskLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6NetmaskLength")
                    .unmarshallLocationName("Ipv6NetmaskLength").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcId")
            .getter(getter(AssociateVpcCidrBlockRequest::vpcId))
            .setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId")
                    .unmarshallLocationName("vpcId").build()).build();

    private static final SdkField<Boolean> AMAZON_PROVIDED_IPV6_CIDR_BLOCK_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AmazonProvidedIpv6CidrBlock")
            .getter(getter(AssociateVpcCidrBlockRequest::amazonProvidedIpv6CidrBlock))
            .setter(setter(Builder::amazonProvidedIpv6CidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonProvidedIpv6CidrBlock")
                    .unmarshallLocationName("amazonProvidedIpv6CidrBlock").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_BLOCK_FIELD,
            IPV6_CIDR_BLOCK_NETWORK_BORDER_GROUP_FIELD, IPV6_POOL_FIELD, IPV6_CIDR_BLOCK_FIELD, IPV4_IPAM_POOL_ID_FIELD,
            IPV4_NETMASK_LENGTH_FIELD, IPV6_IPAM_POOL_ID_FIELD, IPV6_NETMASK_LENGTH_FIELD, VPC_ID_FIELD,
            AMAZON_PROVIDED_IPV6_CIDR_BLOCK_FIELD));

    private final String cidrBlock;

    private final String ipv6CidrBlockNetworkBorderGroup;

    private final String ipv6Pool;

    private final String ipv6CidrBlock;

    private final String ipv4IpamPoolId;

    private final Integer ipv4NetmaskLength;

    private final String ipv6IpamPoolId;

    private final Integer ipv6NetmaskLength;

    private final String vpcId;

    private final Boolean amazonProvidedIpv6CidrBlock;

    private AssociateVpcCidrBlockRequest(BuilderImpl builder) {
        super(builder);
        this.cidrBlock = builder.cidrBlock;
        this.ipv6CidrBlockNetworkBorderGroup = builder.ipv6CidrBlockNetworkBorderGroup;
        this.ipv6Pool = builder.ipv6Pool;
        this.ipv6CidrBlock = builder.ipv6CidrBlock;
        this.ipv4IpamPoolId = builder.ipv4IpamPoolId;
        this.ipv4NetmaskLength = builder.ipv4NetmaskLength;
        this.ipv6IpamPoolId = builder.ipv6IpamPoolId;
        this.ipv6NetmaskLength = builder.ipv6NetmaskLength;
        this.vpcId = builder.vpcId;
        this.amazonProvidedIpv6CidrBlock = builder.amazonProvidedIpv6CidrBlock;
    }

    /**
     * <p>
     * An IPv4 CIDR block to associate with the VPC.
     * </p>
     * 
     * @return An IPv4 CIDR block to associate with the VPC.
     */
    public final String cidrBlock() {
        return cidrBlock;
    }

    /**
     * <p>
     * The name of the location from which we advertise the IPV6 CIDR block. Use this parameter to limit the CIDR block
     * to this location.
     * </p>
     * <p>
     * You must set <code>AmazonProvidedIpv6CidrBlock</code> to <code>true</code> to use this parameter.
     * </p>
     * <p>
     * You can have one IPv6 CIDR block association per network border group.
     * </p>
     * 
     * @return The name of the location from which we advertise the IPV6 CIDR block. Use this parameter to limit the
     *         CIDR block to this location.</p>
     *         <p>
     *         You must set <code>AmazonProvidedIpv6CidrBlock</code> to <code>true</code> to use this parameter.
     *         </p>
     *         <p>
     *         You can have one IPv6 CIDR block association per network border group.
     */
    public final String ipv6CidrBlockNetworkBorderGroup() {
        return ipv6CidrBlockNetworkBorderGroup;
    }

    /**
     * <p>
     * The ID of an IPv6 address pool from which to allocate the IPv6 CIDR block.
     * </p>
     * 
     * @return The ID of an IPv6 address pool from which to allocate the IPv6 CIDR block.
     */
    public final String ipv6Pool() {
        return ipv6Pool;
    }

    /**
     * <p>
     * An IPv6 CIDR block from the IPv6 address pool. You must also specify <code>Ipv6Pool</code> in the request.
     * </p>
     * <p>
     * To let Amazon choose the IPv6 CIDR block for you, omit this parameter.
     * </p>
     * 
     * @return An IPv6 CIDR block from the IPv6 address pool. You must also specify <code>Ipv6Pool</code> in the
     *         request.</p>
     *         <p>
     *         To let Amazon choose the IPv6 CIDR block for you, omit this parameter.
     */
    public final String ipv6CidrBlock() {
        return ipv6CidrBlock;
    }

    /**
     * <p>
     * Associate a CIDR allocated from an IPv4 IPAM pool to a VPC. For more information about Amazon VPC IP Address
     * Manager (IPAM), see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a>
     * in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * 
     * @return Associate a CIDR allocated from an IPv4 IPAM pool to a VPC. For more information about Amazon VPC IP
     *         Address Manager (IPAM), see <a
     *         href="https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the
     *         <i>Amazon VPC IPAM User Guide</i>.
     */
    public final String ipv4IpamPoolId() {
        return ipv4IpamPoolId;
    }

    /**
     * <p>
     * The netmask length of the IPv4 CIDR you would like to associate from an Amazon VPC IP Address Manager (IPAM)
     * pool. For more information about IPAM, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <i>Amazon VPC
     * IPAM User Guide</i>.
     * </p>
     * 
     * @return The netmask length of the IPv4 CIDR you would like to associate from an Amazon VPC IP Address Manager
     *         (IPAM) pool. For more information about IPAM, see <a
     *         href="https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the
     *         <i>Amazon VPC IPAM User Guide</i>.
     */
    public final Integer ipv4NetmaskLength() {
        return ipv4NetmaskLength;
    }

    /**
     * <p>
     * Associates a CIDR allocated from an IPv6 IPAM pool to a VPC. For more information about Amazon VPC IP Address
     * Manager (IPAM), see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a>
     * in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * 
     * @return Associates a CIDR allocated from an IPv6 IPAM pool to a VPC. For more information about Amazon VPC IP
     *         Address Manager (IPAM), see <a
     *         href="https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the
     *         <i>Amazon VPC IPAM User Guide</i>.
     */
    public final String ipv6IpamPoolId() {
        return ipv6IpamPoolId;
    }

    /**
     * <p>
     * The netmask length of the IPv6 CIDR you would like to associate from an Amazon VPC IP Address Manager (IPAM)
     * pool. For more information about IPAM, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <i>Amazon VPC
     * IPAM User Guide</i>.
     * </p>
     * 
     * @return The netmask length of the IPv6 CIDR you would like to associate from an Amazon VPC IP Address Manager
     *         (IPAM) pool. For more information about IPAM, see <a
     *         href="https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the
     *         <i>Amazon VPC IPAM User Guide</i>.
     */
    public final Integer ipv6NetmaskLength() {
        return ipv6NetmaskLength;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the range of
     * IPv6 addresses or the size of the CIDR block.
     * </p>
     * 
     * @return Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the
     *         range of IPv6 addresses or the size of the CIDR block.
     */
    public final Boolean amazonProvidedIpv6CidrBlock() {
        return amazonProvidedIpv6CidrBlock;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6CidrBlockNetworkBorderGroup());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6Pool());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(ipv4IpamPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(ipv4NetmaskLength());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6IpamPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6NetmaskLength());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(amazonProvidedIpv6CidrBlock());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateVpcCidrBlockRequest)) {
            return false;
        }
        AssociateVpcCidrBlockRequest other = (AssociateVpcCidrBlockRequest) obj;
        return Objects.equals(cidrBlock(), other.cidrBlock())
                && Objects.equals(ipv6CidrBlockNetworkBorderGroup(), other.ipv6CidrBlockNetworkBorderGroup())
                && Objects.equals(ipv6Pool(), other.ipv6Pool()) && Objects.equals(ipv6CidrBlock(), other.ipv6CidrBlock())
                && Objects.equals(ipv4IpamPoolId(), other.ipv4IpamPoolId())
                && Objects.equals(ipv4NetmaskLength(), other.ipv4NetmaskLength())
                && Objects.equals(ipv6IpamPoolId(), other.ipv6IpamPoolId())
                && Objects.equals(ipv6NetmaskLength(), other.ipv6NetmaskLength()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(amazonProvidedIpv6CidrBlock(), other.amazonProvidedIpv6CidrBlock());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateVpcCidrBlockRequest").add("CidrBlock", cidrBlock())
                .add("Ipv6CidrBlockNetworkBorderGroup", ipv6CidrBlockNetworkBorderGroup()).add("Ipv6Pool", ipv6Pool())
                .add("Ipv6CidrBlock", ipv6CidrBlock()).add("Ipv4IpamPoolId", ipv4IpamPoolId())
                .add("Ipv4NetmaskLength", ipv4NetmaskLength()).add("Ipv6IpamPoolId", ipv6IpamPoolId())
                .add("Ipv6NetmaskLength", ipv6NetmaskLength()).add("VpcId", vpcId())
                .add("AmazonProvidedIpv6CidrBlock", amazonProvidedIpv6CidrBlock()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CidrBlock":
            return Optional.ofNullable(clazz.cast(cidrBlock()));
        case "Ipv6CidrBlockNetworkBorderGroup":
            return Optional.ofNullable(clazz.cast(ipv6CidrBlockNetworkBorderGroup()));
        case "Ipv6Pool":
            return Optional.ofNullable(clazz.cast(ipv6Pool()));
        case "Ipv6CidrBlock":
            return Optional.ofNullable(clazz.cast(ipv6CidrBlock()));
        case "Ipv4IpamPoolId":
            return Optional.ofNullable(clazz.cast(ipv4IpamPoolId()));
        case "Ipv4NetmaskLength":
            return Optional.ofNullable(clazz.cast(ipv4NetmaskLength()));
        case "Ipv6IpamPoolId":
            return Optional.ofNullable(clazz.cast(ipv6IpamPoolId()));
        case "Ipv6NetmaskLength":
            return Optional.ofNullable(clazz.cast(ipv6NetmaskLength()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "AmazonProvidedIpv6CidrBlock":
            return Optional.ofNullable(clazz.cast(amazonProvidedIpv6CidrBlock()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateVpcCidrBlockRequest, T> g) {
        return obj -> g.apply((AssociateVpcCidrBlockRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, AssociateVpcCidrBlockRequest> {
        /**
         * <p>
         * An IPv4 CIDR block to associate with the VPC.
         * </p>
         * 
         * @param cidrBlock
         *        An IPv4 CIDR block to associate with the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlock(String cidrBlock);

        /**
         * <p>
         * The name of the location from which we advertise the IPV6 CIDR block. Use this parameter to limit the CIDR
         * block to this location.
         * </p>
         * <p>
         * You must set <code>AmazonProvidedIpv6CidrBlock</code> to <code>true</code> to use this parameter.
         * </p>
         * <p>
         * You can have one IPv6 CIDR block association per network border group.
         * </p>
         * 
         * @param ipv6CidrBlockNetworkBorderGroup
         *        The name of the location from which we advertise the IPV6 CIDR block. Use this parameter to limit the
         *        CIDR block to this location.</p>
         *        <p>
         *        You must set <code>AmazonProvidedIpv6CidrBlock</code> to <code>true</code> to use this parameter.
         *        </p>
         *        <p>
         *        You can have one IPv6 CIDR block association per network border group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlockNetworkBorderGroup(String ipv6CidrBlockNetworkBorderGroup);

        /**
         * <p>
         * The ID of an IPv6 address pool from which to allocate the IPv6 CIDR block.
         * </p>
         * 
         * @param ipv6Pool
         *        The ID of an IPv6 address pool from which to allocate the IPv6 CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Pool(String ipv6Pool);

        /**
         * <p>
         * An IPv6 CIDR block from the IPv6 address pool. You must also specify <code>Ipv6Pool</code> in the request.
         * </p>
         * <p>
         * To let Amazon choose the IPv6 CIDR block for you, omit this parameter.
         * </p>
         * 
         * @param ipv6CidrBlock
         *        An IPv6 CIDR block from the IPv6 address pool. You must also specify <code>Ipv6Pool</code> in the
         *        request.</p>
         *        <p>
         *        To let Amazon choose the IPv6 CIDR block for you, omit this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlock(String ipv6CidrBlock);

        /**
         * <p>
         * Associate a CIDR allocated from an IPv4 IPAM pool to a VPC. For more information about Amazon VPC IP Address
         * Manager (IPAM), see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html">What is
         * IPAM?</a> in the <i>Amazon VPC IPAM User Guide</i>.
         * </p>
         * 
         * @param ipv4IpamPoolId
         *        Associate a CIDR allocated from an IPv4 IPAM pool to a VPC. For more information about Amazon VPC IP
         *        Address Manager (IPAM), see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the
         *        <i>Amazon VPC IPAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4IpamPoolId(String ipv4IpamPoolId);

        /**
         * <p>
         * The netmask length of the IPv4 CIDR you would like to associate from an Amazon VPC IP Address Manager (IPAM)
         * pool. For more information about IPAM, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <i>Amazon
         * VPC IPAM User Guide</i>.
         * </p>
         * 
         * @param ipv4NetmaskLength
         *        The netmask length of the IPv4 CIDR you would like to associate from an Amazon VPC IP Address Manager
         *        (IPAM) pool. For more information about IPAM, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the
         *        <i>Amazon VPC IPAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4NetmaskLength(Integer ipv4NetmaskLength);

        /**
         * <p>
         * Associates a CIDR allocated from an IPv6 IPAM pool to a VPC. For more information about Amazon VPC IP Address
         * Manager (IPAM), see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html">What is
         * IPAM?</a> in the <i>Amazon VPC IPAM User Guide</i>.
         * </p>
         * 
         * @param ipv6IpamPoolId
         *        Associates a CIDR allocated from an IPv6 IPAM pool to a VPC. For more information about Amazon VPC IP
         *        Address Manager (IPAM), see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the
         *        <i>Amazon VPC IPAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6IpamPoolId(String ipv6IpamPoolId);

        /**
         * <p>
         * The netmask length of the IPv6 CIDR you would like to associate from an Amazon VPC IP Address Manager (IPAM)
         * pool. For more information about IPAM, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <i>Amazon
         * VPC IPAM User Guide</i>.
         * </p>
         * 
         * @param ipv6NetmaskLength
         *        The netmask length of the IPv6 CIDR you would like to associate from an Amazon VPC IP Address Manager
         *        (IPAM) pool. For more information about IPAM, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the
         *        <i>Amazon VPC IPAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6NetmaskLength(Integer ipv6NetmaskLength);

        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the
         * range of IPv6 addresses or the size of the CIDR block.
         * </p>
         * 
         * @param amazonProvidedIpv6CidrBlock
         *        Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify
         *        the range of IPv6 addresses or the size of the CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonProvidedIpv6CidrBlock(Boolean amazonProvidedIpv6CidrBlock);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String cidrBlock;

        private String ipv6CidrBlockNetworkBorderGroup;

        private String ipv6Pool;

        private String ipv6CidrBlock;

        private String ipv4IpamPoolId;

        private Integer ipv4NetmaskLength;

        private String ipv6IpamPoolId;

        private Integer ipv6NetmaskLength;

        private String vpcId;

        private Boolean amazonProvidedIpv6CidrBlock;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateVpcCidrBlockRequest model) {
            super(model);
            cidrBlock(model.cidrBlock);
            ipv6CidrBlockNetworkBorderGroup(model.ipv6CidrBlockNetworkBorderGroup);
            ipv6Pool(model.ipv6Pool);
            ipv6CidrBlock(model.ipv6CidrBlock);
            ipv4IpamPoolId(model.ipv4IpamPoolId);
            ipv4NetmaskLength(model.ipv4NetmaskLength);
            ipv6IpamPoolId(model.ipv6IpamPoolId);
            ipv6NetmaskLength(model.ipv6NetmaskLength);
            vpcId(model.vpcId);
            amazonProvidedIpv6CidrBlock(model.amazonProvidedIpv6CidrBlock);
        }

        public final String getCidrBlock() {
            return cidrBlock;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final String getIpv6CidrBlockNetworkBorderGroup() {
            return ipv6CidrBlockNetworkBorderGroup;
        }

        public final void setIpv6CidrBlockNetworkBorderGroup(String ipv6CidrBlockNetworkBorderGroup) {
            this.ipv6CidrBlockNetworkBorderGroup = ipv6CidrBlockNetworkBorderGroup;
        }

        @Override
        public final Builder ipv6CidrBlockNetworkBorderGroup(String ipv6CidrBlockNetworkBorderGroup) {
            this.ipv6CidrBlockNetworkBorderGroup = ipv6CidrBlockNetworkBorderGroup;
            return this;
        }

        public final String getIpv6Pool() {
            return ipv6Pool;
        }

        public final void setIpv6Pool(String ipv6Pool) {
            this.ipv6Pool = ipv6Pool;
        }

        @Override
        public final Builder ipv6Pool(String ipv6Pool) {
            this.ipv6Pool = ipv6Pool;
            return this;
        }

        public final String getIpv6CidrBlock() {
            return ipv6CidrBlock;
        }

        public final void setIpv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
        }

        @Override
        public final Builder ipv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
            return this;
        }

        public final String getIpv4IpamPoolId() {
            return ipv4IpamPoolId;
        }

        public final void setIpv4IpamPoolId(String ipv4IpamPoolId) {
            this.ipv4IpamPoolId = ipv4IpamPoolId;
        }

        @Override
        public final Builder ipv4IpamPoolId(String ipv4IpamPoolId) {
            this.ipv4IpamPoolId = ipv4IpamPoolId;
            return this;
        }

        public final Integer getIpv4NetmaskLength() {
            return ipv4NetmaskLength;
        }

        public final void setIpv4NetmaskLength(Integer ipv4NetmaskLength) {
            this.ipv4NetmaskLength = ipv4NetmaskLength;
        }

        @Override
        public final Builder ipv4NetmaskLength(Integer ipv4NetmaskLength) {
            this.ipv4NetmaskLength = ipv4NetmaskLength;
            return this;
        }

        public final String getIpv6IpamPoolId() {
            return ipv6IpamPoolId;
        }

        public final void setIpv6IpamPoolId(String ipv6IpamPoolId) {
            this.ipv6IpamPoolId = ipv6IpamPoolId;
        }

        @Override
        public final Builder ipv6IpamPoolId(String ipv6IpamPoolId) {
            this.ipv6IpamPoolId = ipv6IpamPoolId;
            return this;
        }

        public final Integer getIpv6NetmaskLength() {
            return ipv6NetmaskLength;
        }

        public final void setIpv6NetmaskLength(Integer ipv6NetmaskLength) {
            this.ipv6NetmaskLength = ipv6NetmaskLength;
        }

        @Override
        public final Builder ipv6NetmaskLength(Integer ipv6NetmaskLength) {
            this.ipv6NetmaskLength = ipv6NetmaskLength;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final Boolean getAmazonProvidedIpv6CidrBlock() {
            return amazonProvidedIpv6CidrBlock;
        }

        public final void setAmazonProvidedIpv6CidrBlock(Boolean amazonProvidedIpv6CidrBlock) {
            this.amazonProvidedIpv6CidrBlock = amazonProvidedIpv6CidrBlock;
        }

        @Override
        public final Builder amazonProvidedIpv6CidrBlock(Boolean amazonProvidedIpv6CidrBlock) {
            this.amazonProvidedIpv6CidrBlock = amazonProvidedIpv6CidrBlock;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateVpcCidrBlockRequest build() {
            return new AssociateVpcCidrBlockRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
