/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a load balancer listener.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalysisLoadBalancerListener implements SdkPojo, Serializable,
        ToCopyableBuilder<AnalysisLoadBalancerListener.Builder, AnalysisLoadBalancerListener> {
    private static final SdkField<Integer> LOAD_BALANCER_PORT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("LoadBalancerPort")
            .getter(getter(AnalysisLoadBalancerListener::loadBalancerPort))
            .setter(setter(Builder::loadBalancerPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerPort")
                    .unmarshallLocationName("loadBalancerPort").build()).build();

    private static final SdkField<Integer> INSTANCE_PORT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstancePort")
            .getter(getter(AnalysisLoadBalancerListener::instancePort))
            .setter(setter(Builder::instancePort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancePort")
                    .unmarshallLocationName("instancePort").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_PORT_FIELD,
            INSTANCE_PORT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("LoadBalancerPort", LOAD_BALANCER_PORT_FIELD);
                    put("InstancePort", INSTANCE_PORT_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Integer loadBalancerPort;

    private final Integer instancePort;

    private AnalysisLoadBalancerListener(BuilderImpl builder) {
        this.loadBalancerPort = builder.loadBalancerPort;
        this.instancePort = builder.instancePort;
    }

    /**
     * <p>
     * The port on which the load balancer is listening.
     * </p>
     * 
     * @return The port on which the load balancer is listening.
     */
    public final Integer loadBalancerPort() {
        return loadBalancerPort;
    }

    /**
     * <p>
     * [Classic Load Balancers] The back-end port for the listener.
     * </p>
     * 
     * @return [Classic Load Balancers] The back-end port for the listener.
     */
    public final Integer instancePort() {
        return instancePort;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerPort());
        hashCode = 31 * hashCode + Objects.hashCode(instancePort());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisLoadBalancerListener)) {
            return false;
        }
        AnalysisLoadBalancerListener other = (AnalysisLoadBalancerListener) obj;
        return Objects.equals(loadBalancerPort(), other.loadBalancerPort())
                && Objects.equals(instancePort(), other.instancePort());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalysisLoadBalancerListener").add("LoadBalancerPort", loadBalancerPort())
                .add("InstancePort", instancePort()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoadBalancerPort":
            return Optional.ofNullable(clazz.cast(loadBalancerPort()));
        case "InstancePort":
            return Optional.ofNullable(clazz.cast(instancePort()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AnalysisLoadBalancerListener, T> g) {
        return obj -> g.apply((AnalysisLoadBalancerListener) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalysisLoadBalancerListener> {
        /**
         * <p>
         * The port on which the load balancer is listening.
         * </p>
         * 
         * @param loadBalancerPort
         *        The port on which the load balancer is listening.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerPort(Integer loadBalancerPort);

        /**
         * <p>
         * [Classic Load Balancers] The back-end port for the listener.
         * </p>
         * 
         * @param instancePort
         *        [Classic Load Balancers] The back-end port for the listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancePort(Integer instancePort);
    }

    static final class BuilderImpl implements Builder {
        private Integer loadBalancerPort;

        private Integer instancePort;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisLoadBalancerListener model) {
            loadBalancerPort(model.loadBalancerPort);
            instancePort(model.instancePort);
        }

        public final Integer getLoadBalancerPort() {
            return loadBalancerPort;
        }

        public final void setLoadBalancerPort(Integer loadBalancerPort) {
            this.loadBalancerPort = loadBalancerPort;
        }

        @Override
        public final Builder loadBalancerPort(Integer loadBalancerPort) {
            this.loadBalancerPort = loadBalancerPort;
            return this;
        }

        public final Integer getInstancePort() {
            return instancePort;
        }

        public final void setInstancePort(Integer instancePort) {
            this.instancePort = instancePort;
        }

        @Override
        public final Builder instancePort(Integer instancePort) {
            this.instancePort = instancePort;
            return this;
        }

        @Override
        public AnalysisLoadBalancerListener build() {
            return new AnalysisLoadBalancerListener(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
