/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeIamInstanceProfileAssociationsResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeIamInstanceProfileAssociationsResponse.Builder, DescribeIamInstanceProfileAssociationsResponse> {
    private static final SdkField<List<IamInstanceProfileAssociation>> IAM_INSTANCE_PROFILE_ASSOCIATIONS_FIELD = SdkField
            .<List<IamInstanceProfileAssociation>> builder(MarshallingType.LIST)
            .memberName("IamInstanceProfileAssociations")
            .getter(getter(DescribeIamInstanceProfileAssociationsResponse::iamInstanceProfileAssociations))
            .setter(setter(Builder::iamInstanceProfileAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamInstanceProfileAssociationSet")
                    .unmarshallLocationName("iamInstanceProfileAssociationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<IamInstanceProfileAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(IamInstanceProfileAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeIamInstanceProfileAssociationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            IAM_INSTANCE_PROFILE_ASSOCIATIONS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("IamInstanceProfileAssociationSet", IAM_INSTANCE_PROFILE_ASSOCIATIONS_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<IamInstanceProfileAssociation> iamInstanceProfileAssociations;

    private final String nextToken;

    private DescribeIamInstanceProfileAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.iamInstanceProfileAssociations = builder.iamInstanceProfileAssociations;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the IamInstanceProfileAssociations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasIamInstanceProfileAssociations() {
        return iamInstanceProfileAssociations != null && !(iamInstanceProfileAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the IAM instance profile associations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIamInstanceProfileAssociations} method.
     * </p>
     * 
     * @return Information about the IAM instance profile associations.
     */
    public final List<IamInstanceProfileAssociation> iamInstanceProfileAssociations() {
        return iamInstanceProfileAssociations;
    }

    /**
     * <p>
     * The token to include in another request to get the next page of items. This value is <code>null</code> when there
     * are no more items to return.
     * </p>
     * 
     * @return The token to include in another request to get the next page of items. This value is <code>null</code>
     *         when there are no more items to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasIamInstanceProfileAssociations() ? iamInstanceProfileAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIamInstanceProfileAssociationsResponse)) {
            return false;
        }
        DescribeIamInstanceProfileAssociationsResponse other = (DescribeIamInstanceProfileAssociationsResponse) obj;
        return hasIamInstanceProfileAssociations() == other.hasIamInstanceProfileAssociations()
                && Objects.equals(iamInstanceProfileAssociations(), other.iamInstanceProfileAssociations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeIamInstanceProfileAssociationsResponse")
                .add("IamInstanceProfileAssociations",
                        hasIamInstanceProfileAssociations() ? iamInstanceProfileAssociations() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IamInstanceProfileAssociations":
            return Optional.ofNullable(clazz.cast(iamInstanceProfileAssociations()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeIamInstanceProfileAssociationsResponse, T> g) {
        return obj -> g.apply((DescribeIamInstanceProfileAssociationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeIamInstanceProfileAssociationsResponse> {
        /**
         * <p>
         * Information about the IAM instance profile associations.
         * </p>
         * 
         * @param iamInstanceProfileAssociations
         *        Information about the IAM instance profile associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamInstanceProfileAssociations(Collection<IamInstanceProfileAssociation> iamInstanceProfileAssociations);

        /**
         * <p>
         * Information about the IAM instance profile associations.
         * </p>
         * 
         * @param iamInstanceProfileAssociations
         *        Information about the IAM instance profile associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamInstanceProfileAssociations(IamInstanceProfileAssociation... iamInstanceProfileAssociations);

        /**
         * <p>
         * Information about the IAM instance profile associations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.IamInstanceProfileAssociation.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.IamInstanceProfileAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.IamInstanceProfileAssociation.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #iamInstanceProfileAssociations(List<IamInstanceProfileAssociation>)}.
         * 
         * @param iamInstanceProfileAssociations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.IamInstanceProfileAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamInstanceProfileAssociations(java.util.Collection<IamInstanceProfileAssociation>)
         */
        Builder iamInstanceProfileAssociations(Consumer<IamInstanceProfileAssociation.Builder>... iamInstanceProfileAssociations);

        /**
         * <p>
         * The token to include in another request to get the next page of items. This value is <code>null</code> when
         * there are no more items to return.
         * </p>
         * 
         * @param nextToken
         *        The token to include in another request to get the next page of items. This value is <code>null</code>
         *        when there are no more items to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<IamInstanceProfileAssociation> iamInstanceProfileAssociations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIamInstanceProfileAssociationsResponse model) {
            super(model);
            iamInstanceProfileAssociations(model.iamInstanceProfileAssociations);
            nextToken(model.nextToken);
        }

        public final List<IamInstanceProfileAssociation.Builder> getIamInstanceProfileAssociations() {
            List<IamInstanceProfileAssociation.Builder> result = IamInstanceProfileAssociationSetCopier
                    .copyToBuilder(this.iamInstanceProfileAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIamInstanceProfileAssociations(
                Collection<IamInstanceProfileAssociation.BuilderImpl> iamInstanceProfileAssociations) {
            this.iamInstanceProfileAssociations = IamInstanceProfileAssociationSetCopier
                    .copyFromBuilder(iamInstanceProfileAssociations);
        }

        @Override
        public final Builder iamInstanceProfileAssociations(
                Collection<IamInstanceProfileAssociation> iamInstanceProfileAssociations) {
            this.iamInstanceProfileAssociations = IamInstanceProfileAssociationSetCopier.copy(iamInstanceProfileAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iamInstanceProfileAssociations(IamInstanceProfileAssociation... iamInstanceProfileAssociations) {
            iamInstanceProfileAssociations(Arrays.asList(iamInstanceProfileAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iamInstanceProfileAssociations(
                Consumer<IamInstanceProfileAssociation.Builder>... iamInstanceProfileAssociations) {
            iamInstanceProfileAssociations(Stream.of(iamInstanceProfileAssociations)
                    .map(c -> IamInstanceProfileAssociation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeIamInstanceProfileAssociationsResponse build() {
            return new DescribeIamInstanceProfileAssociationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
