/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class LockSnapshotRequest extends Ec2Request implements
        ToCopyableBuilder<LockSnapshotRequest.Builder, LockSnapshotRequest> {
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId")
            .getter(getter(LockSnapshotRequest::snapshotId))
            .setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId")
                    .unmarshallLocationName("SnapshotId").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(LockSnapshotRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<String> LOCK_MODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LockMode")
            .getter(getter(LockSnapshotRequest::lockModeAsString))
            .setter(setter(Builder::lockMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockMode")
                    .unmarshallLocationName("LockMode").build()).build();

    private static final SdkField<Integer> COOL_OFF_PERIOD_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("CoolOffPeriod")
            .getter(getter(LockSnapshotRequest::coolOffPeriod))
            .setter(setter(Builder::coolOffPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoolOffPeriod")
                    .unmarshallLocationName("CoolOffPeriod").build()).build();

    private static final SdkField<Integer> LOCK_DURATION_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("LockDuration")
            .getter(getter(LockSnapshotRequest::lockDuration))
            .setter(setter(Builder::lockDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockDuration")
                    .unmarshallLocationName("LockDuration").build()).build();

    private static final SdkField<Instant> EXPIRATION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExpirationDate")
            .getter(getter(LockSnapshotRequest::expirationDate))
            .setter(setter(Builder::expirationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationDate")
                    .unmarshallLocationName("ExpirationDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_ID_FIELD,
            DRY_RUN_FIELD, LOCK_MODE_FIELD, COOL_OFF_PERIOD_FIELD, LOCK_DURATION_FIELD, EXPIRATION_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("SnapshotId", SNAPSHOT_ID_FIELD);
                    put("DryRun", DRY_RUN_FIELD);
                    put("LockMode", LOCK_MODE_FIELD);
                    put("CoolOffPeriod", COOL_OFF_PERIOD_FIELD);
                    put("LockDuration", LOCK_DURATION_FIELD);
                    put("ExpirationDate", EXPIRATION_DATE_FIELD);
                }
            });

    private final String snapshotId;

    private final Boolean dryRun;

    private final String lockMode;

    private final Integer coolOffPeriod;

    private final Integer lockDuration;

    private final Instant expirationDate;

    private LockSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.snapshotId = builder.snapshotId;
        this.dryRun = builder.dryRun;
        this.lockMode = builder.lockMode;
        this.coolOffPeriod = builder.coolOffPeriod;
        this.lockDuration = builder.lockDuration;
        this.expirationDate = builder.expirationDate;
    }

    /**
     * <p>
     * The ID of the snapshot to lock.
     * </p>
     * 
     * @return The ID of the snapshot to lock.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The mode in which to lock the snapshot. Specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>governance</code> - Locks the snapshot in governance mode. Snapshots locked in governance mode can't be
     * deleted until one of the following conditions are met:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The lock duration expires.
     * </p>
     * </li>
     * <li>
     * <p>
     * The snapshot is unlocked by a user with the appropriate permissions.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Users with the appropriate IAM permissions can unlock the snapshot, increase or decrease the lock duration, and
     * change the lock mode to <code>compliance</code> at any time.
     * </p>
     * <p>
     * If you lock a snapshot in <code>governance</code> mode, omit <b> CoolOffPeriod</b>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>compliance</code> - Locks the snapshot in compliance mode. Snapshots locked in compliance mode can't be
     * unlocked by any user. They can be deleted only after the lock duration expires. Users can't decrease the lock
     * duration or change the lock mode to <code>governance</code>. However, users with appropriate IAM permissions can
     * increase the lock duration at any time.
     * </p>
     * <p>
     * If you lock a snapshot in <code>compliance</code> mode, you can optionally specify <b>CoolOffPeriod</b>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lockMode} will
     * return {@link LockMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lockModeAsString}.
     * </p>
     * 
     * @return The mode in which to lock the snapshot. Specify one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>governance</code> - Locks the snapshot in governance mode. Snapshots locked in governance mode
     *         can't be deleted until one of the following conditions are met:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The lock duration expires.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The snapshot is unlocked by a user with the appropriate permissions.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Users with the appropriate IAM permissions can unlock the snapshot, increase or decrease the lock
     *         duration, and change the lock mode to <code>compliance</code> at any time.
     *         </p>
     *         <p>
     *         If you lock a snapshot in <code>governance</code> mode, omit <b> CoolOffPeriod</b>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>compliance</code> - Locks the snapshot in compliance mode. Snapshots locked in compliance mode
     *         can't be unlocked by any user. They can be deleted only after the lock duration expires. Users can't
     *         decrease the lock duration or change the lock mode to <code>governance</code>. However, users with
     *         appropriate IAM permissions can increase the lock duration at any time.
     *         </p>
     *         <p>
     *         If you lock a snapshot in <code>compliance</code> mode, you can optionally specify <b>CoolOffPeriod</b>.
     *         </p>
     *         </li>
     * @see LockMode
     */
    public final LockMode lockMode() {
        return LockMode.fromValue(lockMode);
    }

    /**
     * <p>
     * The mode in which to lock the snapshot. Specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>governance</code> - Locks the snapshot in governance mode. Snapshots locked in governance mode can't be
     * deleted until one of the following conditions are met:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The lock duration expires.
     * </p>
     * </li>
     * <li>
     * <p>
     * The snapshot is unlocked by a user with the appropriate permissions.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Users with the appropriate IAM permissions can unlock the snapshot, increase or decrease the lock duration, and
     * change the lock mode to <code>compliance</code> at any time.
     * </p>
     * <p>
     * If you lock a snapshot in <code>governance</code> mode, omit <b> CoolOffPeriod</b>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>compliance</code> - Locks the snapshot in compliance mode. Snapshots locked in compliance mode can't be
     * unlocked by any user. They can be deleted only after the lock duration expires. Users can't decrease the lock
     * duration or change the lock mode to <code>governance</code>. However, users with appropriate IAM permissions can
     * increase the lock duration at any time.
     * </p>
     * <p>
     * If you lock a snapshot in <code>compliance</code> mode, you can optionally specify <b>CoolOffPeriod</b>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lockMode} will
     * return {@link LockMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lockModeAsString}.
     * </p>
     * 
     * @return The mode in which to lock the snapshot. Specify one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>governance</code> - Locks the snapshot in governance mode. Snapshots locked in governance mode
     *         can't be deleted until one of the following conditions are met:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The lock duration expires.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The snapshot is unlocked by a user with the appropriate permissions.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Users with the appropriate IAM permissions can unlock the snapshot, increase or decrease the lock
     *         duration, and change the lock mode to <code>compliance</code> at any time.
     *         </p>
     *         <p>
     *         If you lock a snapshot in <code>governance</code> mode, omit <b> CoolOffPeriod</b>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>compliance</code> - Locks the snapshot in compliance mode. Snapshots locked in compliance mode
     *         can't be unlocked by any user. They can be deleted only after the lock duration expires. Users can't
     *         decrease the lock duration or change the lock mode to <code>governance</code>. However, users with
     *         appropriate IAM permissions can increase the lock duration at any time.
     *         </p>
     *         <p>
     *         If you lock a snapshot in <code>compliance</code> mode, you can optionally specify <b>CoolOffPeriod</b>.
     *         </p>
     *         </li>
     * @see LockMode
     */
    public final String lockModeAsString() {
        return lockMode;
    }

    /**
     * <p>
     * The cooling-off period during which you can unlock the snapshot or modify the lock settings after locking the
     * snapshot in compliance mode, in hours. After the cooling-off period expires, you can't unlock or delete the
     * snapshot, decrease the lock duration, or change the lock mode. You can increase the lock duration after the
     * cooling-off period expires.
     * </p>
     * <p>
     * The cooling-off period is optional when locking a snapshot in compliance mode. If you are locking the snapshot in
     * governance mode, omit this parameter.
     * </p>
     * <p>
     * To lock the snapshot in compliance mode immediately without a cooling-off period, omit this parameter.
     * </p>
     * <p>
     * If you are extending the lock duration for a snapshot that is locked in compliance mode after the cooling-off
     * period has expired, omit this parameter. If you specify a cooling-period in a such a request, the request fails.
     * </p>
     * <p>
     * Allowed values: Min 1, max 72.
     * </p>
     * 
     * @return The cooling-off period during which you can unlock the snapshot or modify the lock settings after locking
     *         the snapshot in compliance mode, in hours. After the cooling-off period expires, you can't unlock or
     *         delete the snapshot, decrease the lock duration, or change the lock mode. You can increase the lock
     *         duration after the cooling-off period expires.</p>
     *         <p>
     *         The cooling-off period is optional when locking a snapshot in compliance mode. If you are locking the
     *         snapshot in governance mode, omit this parameter.
     *         </p>
     *         <p>
     *         To lock the snapshot in compliance mode immediately without a cooling-off period, omit this parameter.
     *         </p>
     *         <p>
     *         If you are extending the lock duration for a snapshot that is locked in compliance mode after the
     *         cooling-off period has expired, omit this parameter. If you specify a cooling-period in a such a request,
     *         the request fails.
     *         </p>
     *         <p>
     *         Allowed values: Min 1, max 72.
     */
    public final Integer coolOffPeriod() {
        return coolOffPeriod;
    }

    /**
     * <p>
     * The period of time for which to lock the snapshot, in days. The snapshot lock will automatically expire after
     * this period lapses.
     * </p>
     * <p>
     * You must specify either this parameter or <b>ExpirationDate</b>, but not both.
     * </p>
     * <p>
     * Allowed values: Min: 1, max 36500
     * </p>
     * 
     * @return The period of time for which to lock the snapshot, in days. The snapshot lock will automatically expire
     *         after this period lapses.</p>
     *         <p>
     *         You must specify either this parameter or <b>ExpirationDate</b>, but not both.
     *         </p>
     *         <p>
     *         Allowed values: Min: 1, max 36500
     */
    public final Integer lockDuration() {
        return lockDuration;
    }

    /**
     * <p>
     * The date and time at which the snapshot lock is to automatically expire, in the UTC time zone (
     * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>).
     * </p>
     * <p>
     * You must specify either this parameter or <b>LockDuration</b>, but not both.
     * </p>
     * 
     * @return The date and time at which the snapshot lock is to automatically expire, in the UTC time zone (
     *         <code>YYYY-MM-DDThh:mm:ss.sssZ</code>).</p>
     *         <p>
     *         You must specify either this parameter or <b>LockDuration</b>, but not both.
     */
    public final Instant expirationDate() {
        return expirationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(lockModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(coolOffPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(lockDuration());
        hashCode = 31 * hashCode + Objects.hashCode(expirationDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LockSnapshotRequest)) {
            return false;
        }
        LockSnapshotRequest other = (LockSnapshotRequest) obj;
        return Objects.equals(snapshotId(), other.snapshotId()) && Objects.equals(dryRun(), other.dryRun())
                && Objects.equals(lockModeAsString(), other.lockModeAsString())
                && Objects.equals(coolOffPeriod(), other.coolOffPeriod()) && Objects.equals(lockDuration(), other.lockDuration())
                && Objects.equals(expirationDate(), other.expirationDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LockSnapshotRequest").add("SnapshotId", snapshotId()).add("DryRun", dryRun())
                .add("LockMode", lockModeAsString()).add("CoolOffPeriod", coolOffPeriod()).add("LockDuration", lockDuration())
                .add("ExpirationDate", expirationDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "LockMode":
            return Optional.ofNullable(clazz.cast(lockModeAsString()));
        case "CoolOffPeriod":
            return Optional.ofNullable(clazz.cast(coolOffPeriod()));
        case "LockDuration":
            return Optional.ofNullable(clazz.cast(lockDuration()));
        case "ExpirationDate":
            return Optional.ofNullable(clazz.cast(expirationDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LockSnapshotRequest, T> g) {
        return obj -> g.apply((LockSnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, LockSnapshotRequest> {
        /**
         * <p>
         * The ID of the snapshot to lock.
         * </p>
         * 
         * @param snapshotId
         *        The ID of the snapshot to lock.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The mode in which to lock the snapshot. Specify one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>governance</code> - Locks the snapshot in governance mode. Snapshots locked in governance mode can't be
         * deleted until one of the following conditions are met:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The lock duration expires.
         * </p>
         * </li>
         * <li>
         * <p>
         * The snapshot is unlocked by a user with the appropriate permissions.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Users with the appropriate IAM permissions can unlock the snapshot, increase or decrease the lock duration,
         * and change the lock mode to <code>compliance</code> at any time.
         * </p>
         * <p>
         * If you lock a snapshot in <code>governance</code> mode, omit <b> CoolOffPeriod</b>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>compliance</code> - Locks the snapshot in compliance mode. Snapshots locked in compliance mode can't be
         * unlocked by any user. They can be deleted only after the lock duration expires. Users can't decrease the lock
         * duration or change the lock mode to <code>governance</code>. However, users with appropriate IAM permissions
         * can increase the lock duration at any time.
         * </p>
         * <p>
         * If you lock a snapshot in <code>compliance</code> mode, you can optionally specify <b>CoolOffPeriod</b>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lockMode
         *        The mode in which to lock the snapshot. Specify one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>governance</code> - Locks the snapshot in governance mode. Snapshots locked in governance mode
         *        can't be deleted until one of the following conditions are met:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The lock duration expires.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The snapshot is unlocked by a user with the appropriate permissions.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Users with the appropriate IAM permissions can unlock the snapshot, increase or decrease the lock
         *        duration, and change the lock mode to <code>compliance</code> at any time.
         *        </p>
         *        <p>
         *        If you lock a snapshot in <code>governance</code> mode, omit <b> CoolOffPeriod</b>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>compliance</code> - Locks the snapshot in compliance mode. Snapshots locked in compliance mode
         *        can't be unlocked by any user. They can be deleted only after the lock duration expires. Users can't
         *        decrease the lock duration or change the lock mode to <code>governance</code>. However, users with
         *        appropriate IAM permissions can increase the lock duration at any time.
         *        </p>
         *        <p>
         *        If you lock a snapshot in <code>compliance</code> mode, you can optionally specify
         *        <b>CoolOffPeriod</b>.
         *        </p>
         *        </li>
         * @see LockMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LockMode
         */
        Builder lockMode(String lockMode);

        /**
         * <p>
         * The mode in which to lock the snapshot. Specify one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>governance</code> - Locks the snapshot in governance mode. Snapshots locked in governance mode can't be
         * deleted until one of the following conditions are met:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The lock duration expires.
         * </p>
         * </li>
         * <li>
         * <p>
         * The snapshot is unlocked by a user with the appropriate permissions.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Users with the appropriate IAM permissions can unlock the snapshot, increase or decrease the lock duration,
         * and change the lock mode to <code>compliance</code> at any time.
         * </p>
         * <p>
         * If you lock a snapshot in <code>governance</code> mode, omit <b> CoolOffPeriod</b>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>compliance</code> - Locks the snapshot in compliance mode. Snapshots locked in compliance mode can't be
         * unlocked by any user. They can be deleted only after the lock duration expires. Users can't decrease the lock
         * duration or change the lock mode to <code>governance</code>. However, users with appropriate IAM permissions
         * can increase the lock duration at any time.
         * </p>
         * <p>
         * If you lock a snapshot in <code>compliance</code> mode, you can optionally specify <b>CoolOffPeriod</b>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lockMode
         *        The mode in which to lock the snapshot. Specify one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>governance</code> - Locks the snapshot in governance mode. Snapshots locked in governance mode
         *        can't be deleted until one of the following conditions are met:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The lock duration expires.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The snapshot is unlocked by a user with the appropriate permissions.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Users with the appropriate IAM permissions can unlock the snapshot, increase or decrease the lock
         *        duration, and change the lock mode to <code>compliance</code> at any time.
         *        </p>
         *        <p>
         *        If you lock a snapshot in <code>governance</code> mode, omit <b> CoolOffPeriod</b>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>compliance</code> - Locks the snapshot in compliance mode. Snapshots locked in compliance mode
         *        can't be unlocked by any user. They can be deleted only after the lock duration expires. Users can't
         *        decrease the lock duration or change the lock mode to <code>governance</code>. However, users with
         *        appropriate IAM permissions can increase the lock duration at any time.
         *        </p>
         *        <p>
         *        If you lock a snapshot in <code>compliance</code> mode, you can optionally specify
         *        <b>CoolOffPeriod</b>.
         *        </p>
         *        </li>
         * @see LockMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LockMode
         */
        Builder lockMode(LockMode lockMode);

        /**
         * <p>
         * The cooling-off period during which you can unlock the snapshot or modify the lock settings after locking the
         * snapshot in compliance mode, in hours. After the cooling-off period expires, you can't unlock or delete the
         * snapshot, decrease the lock duration, or change the lock mode. You can increase the lock duration after the
         * cooling-off period expires.
         * </p>
         * <p>
         * The cooling-off period is optional when locking a snapshot in compliance mode. If you are locking the
         * snapshot in governance mode, omit this parameter.
         * </p>
         * <p>
         * To lock the snapshot in compliance mode immediately without a cooling-off period, omit this parameter.
         * </p>
         * <p>
         * If you are extending the lock duration for a snapshot that is locked in compliance mode after the cooling-off
         * period has expired, omit this parameter. If you specify a cooling-period in a such a request, the request
         * fails.
         * </p>
         * <p>
         * Allowed values: Min 1, max 72.
         * </p>
         * 
         * @param coolOffPeriod
         *        The cooling-off period during which you can unlock the snapshot or modify the lock settings after
         *        locking the snapshot in compliance mode, in hours. After the cooling-off period expires, you can't
         *        unlock or delete the snapshot, decrease the lock duration, or change the lock mode. You can increase
         *        the lock duration after the cooling-off period expires.</p>
         *        <p>
         *        The cooling-off period is optional when locking a snapshot in compliance mode. If you are locking the
         *        snapshot in governance mode, omit this parameter.
         *        </p>
         *        <p>
         *        To lock the snapshot in compliance mode immediately without a cooling-off period, omit this parameter.
         *        </p>
         *        <p>
         *        If you are extending the lock duration for a snapshot that is locked in compliance mode after the
         *        cooling-off period has expired, omit this parameter. If you specify a cooling-period in a such a
         *        request, the request fails.
         *        </p>
         *        <p>
         *        Allowed values: Min 1, max 72.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coolOffPeriod(Integer coolOffPeriod);

        /**
         * <p>
         * The period of time for which to lock the snapshot, in days. The snapshot lock will automatically expire after
         * this period lapses.
         * </p>
         * <p>
         * You must specify either this parameter or <b>ExpirationDate</b>, but not both.
         * </p>
         * <p>
         * Allowed values: Min: 1, max 36500
         * </p>
         * 
         * @param lockDuration
         *        The period of time for which to lock the snapshot, in days. The snapshot lock will automatically
         *        expire after this period lapses.</p>
         *        <p>
         *        You must specify either this parameter or <b>ExpirationDate</b>, but not both.
         *        </p>
         *        <p>
         *        Allowed values: Min: 1, max 36500
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lockDuration(Integer lockDuration);

        /**
         * <p>
         * The date and time at which the snapshot lock is to automatically expire, in the UTC time zone (
         * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>).
         * </p>
         * <p>
         * You must specify either this parameter or <b>LockDuration</b>, but not both.
         * </p>
         * 
         * @param expirationDate
         *        The date and time at which the snapshot lock is to automatically expire, in the UTC time zone (
         *        <code>YYYY-MM-DDThh:mm:ss.sssZ</code>).</p>
         *        <p>
         *        You must specify either this parameter or <b>LockDuration</b>, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationDate(Instant expirationDate);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String snapshotId;

        private Boolean dryRun;

        private String lockMode;

        private Integer coolOffPeriod;

        private Integer lockDuration;

        private Instant expirationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(LockSnapshotRequest model) {
            super(model);
            snapshotId(model.snapshotId);
            dryRun(model.dryRun);
            lockMode(model.lockMode);
            coolOffPeriod(model.coolOffPeriod);
            lockDuration(model.lockDuration);
            expirationDate(model.expirationDate);
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getLockMode() {
            return lockMode;
        }

        public final void setLockMode(String lockMode) {
            this.lockMode = lockMode;
        }

        @Override
        public final Builder lockMode(String lockMode) {
            this.lockMode = lockMode;
            return this;
        }

        @Override
        public final Builder lockMode(LockMode lockMode) {
            this.lockMode(lockMode == null ? null : lockMode.toString());
            return this;
        }

        public final Integer getCoolOffPeriod() {
            return coolOffPeriod;
        }

        public final void setCoolOffPeriod(Integer coolOffPeriod) {
            this.coolOffPeriod = coolOffPeriod;
        }

        @Override
        public final Builder coolOffPeriod(Integer coolOffPeriod) {
            this.coolOffPeriod = coolOffPeriod;
            return this;
        }

        public final Integer getLockDuration() {
            return lockDuration;
        }

        public final void setLockDuration(Integer lockDuration) {
            this.lockDuration = lockDuration;
        }

        @Override
        public final Builder lockDuration(Integer lockDuration) {
            this.lockDuration = lockDuration;
            return this;
        }

        public final Instant getExpirationDate() {
            return expirationDate;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        @Override
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public LockSnapshotRequest build() {
            return new LockSnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
