/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvisionPublicIpv4PoolCidrResponse extends Ec2Response implements
        ToCopyableBuilder<ProvisionPublicIpv4PoolCidrResponse.Builder, ProvisionPublicIpv4PoolCidrResponse> {
    private static final SdkField<String> POOL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PoolId")
            .getter(getter(ProvisionPublicIpv4PoolCidrResponse::poolId))
            .setter(setter(Builder::poolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId")
                    .unmarshallLocationName("poolId").build()).build();

    private static final SdkField<PublicIpv4PoolRange> POOL_ADDRESS_RANGE_FIELD = SdkField
            .<PublicIpv4PoolRange> builder(MarshallingType.SDK_POJO)
            .memberName("PoolAddressRange")
            .getter(getter(ProvisionPublicIpv4PoolCidrResponse::poolAddressRange))
            .setter(setter(Builder::poolAddressRange))
            .constructor(PublicIpv4PoolRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolAddressRange")
                    .unmarshallLocationName("poolAddressRange").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_ID_FIELD,
            POOL_ADDRESS_RANGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("PoolId", POOL_ID_FIELD);
                    put("PoolAddressRange", POOL_ADDRESS_RANGE_FIELD);
                }
            });

    private final String poolId;

    private final PublicIpv4PoolRange poolAddressRange;

    private ProvisionPublicIpv4PoolCidrResponse(BuilderImpl builder) {
        super(builder);
        this.poolId = builder.poolId;
        this.poolAddressRange = builder.poolAddressRange;
    }

    /**
     * <p>
     * The ID of the pool that you want to provision the CIDR to.
     * </p>
     * 
     * @return The ID of the pool that you want to provision the CIDR to.
     */
    public final String poolId() {
        return poolId;
    }

    /**
     * <p>
     * Information about the address range of the public IPv4 pool.
     * </p>
     * 
     * @return Information about the address range of the public IPv4 pool.
     */
    public final PublicIpv4PoolRange poolAddressRange() {
        return poolAddressRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(poolId());
        hashCode = 31 * hashCode + Objects.hashCode(poolAddressRange());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionPublicIpv4PoolCidrResponse)) {
            return false;
        }
        ProvisionPublicIpv4PoolCidrResponse other = (ProvisionPublicIpv4PoolCidrResponse) obj;
        return Objects.equals(poolId(), other.poolId()) && Objects.equals(poolAddressRange(), other.poolAddressRange());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProvisionPublicIpv4PoolCidrResponse").add("PoolId", poolId())
                .add("PoolAddressRange", poolAddressRange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PoolId":
            return Optional.ofNullable(clazz.cast(poolId()));
        case "PoolAddressRange":
            return Optional.ofNullable(clazz.cast(poolAddressRange()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ProvisionPublicIpv4PoolCidrResponse, T> g) {
        return obj -> g.apply((ProvisionPublicIpv4PoolCidrResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, ProvisionPublicIpv4PoolCidrResponse> {
        /**
         * <p>
         * The ID of the pool that you want to provision the CIDR to.
         * </p>
         * 
         * @param poolId
         *        The ID of the pool that you want to provision the CIDR to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolId(String poolId);

        /**
         * <p>
         * Information about the address range of the public IPv4 pool.
         * </p>
         * 
         * @param poolAddressRange
         *        Information about the address range of the public IPv4 pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolAddressRange(PublicIpv4PoolRange poolAddressRange);

        /**
         * <p>
         * Information about the address range of the public IPv4 pool.
         * </p>
         * This is a convenience method that creates an instance of the {@link PublicIpv4PoolRange.Builder} avoiding the
         * need to create one manually via {@link PublicIpv4PoolRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PublicIpv4PoolRange.Builder#build()} is called immediately and
         * its result is passed to {@link #poolAddressRange(PublicIpv4PoolRange)}.
         * 
         * @param poolAddressRange
         *        a consumer that will call methods on {@link PublicIpv4PoolRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #poolAddressRange(PublicIpv4PoolRange)
         */
        default Builder poolAddressRange(Consumer<PublicIpv4PoolRange.Builder> poolAddressRange) {
            return poolAddressRange(PublicIpv4PoolRange.builder().applyMutation(poolAddressRange).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String poolId;

        private PublicIpv4PoolRange poolAddressRange;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionPublicIpv4PoolCidrResponse model) {
            super(model);
            poolId(model.poolId);
            poolAddressRange(model.poolAddressRange);
        }

        public final String getPoolId() {
            return poolId;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final PublicIpv4PoolRange.Builder getPoolAddressRange() {
            return poolAddressRange != null ? poolAddressRange.toBuilder() : null;
        }

        public final void setPoolAddressRange(PublicIpv4PoolRange.BuilderImpl poolAddressRange) {
            this.poolAddressRange = poolAddressRange != null ? poolAddressRange.build() : null;
        }

        @Override
        public final Builder poolAddressRange(PublicIpv4PoolRange poolAddressRange) {
            this.poolAddressRange = poolAddressRange;
            return this;
        }

        @Override
        public ProvisionPublicIpv4PoolCidrResponse build() {
            return new ProvisionPublicIpv4PoolCidrResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
