/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a route in a transit gateway route table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransitGatewayRouteTableRoute implements SdkPojo, Serializable,
        ToCopyableBuilder<TransitGatewayRouteTableRoute.Builder, TransitGatewayRouteTableRoute> {
    private static final SdkField<String> DESTINATION_CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DestinationCidr")
            .getter(getter(TransitGatewayRouteTableRoute::destinationCidr))
            .setter(setter(Builder::destinationCidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidr")
                    .unmarshallLocationName("destinationCidr").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(TransitGatewayRouteTableRoute::state))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<String> ROUTE_ORIGIN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RouteOrigin")
            .getter(getter(TransitGatewayRouteTableRoute::routeOrigin))
            .setter(setter(Builder::routeOrigin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteOrigin")
                    .unmarshallLocationName("routeOrigin").build()).build();

    private static final SdkField<String> PREFIX_LIST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrefixListId")
            .getter(getter(TransitGatewayRouteTableRoute::prefixListId))
            .setter(setter(Builder::prefixListId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListId")
                    .unmarshallLocationName("prefixListId").build()).build();

    private static final SdkField<String> ATTACHMENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AttachmentId")
            .getter(getter(TransitGatewayRouteTableRoute::attachmentId))
            .setter(setter(Builder::attachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentId")
                    .unmarshallLocationName("attachmentId").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceId")
            .getter(getter(TransitGatewayRouteTableRoute::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId")
                    .unmarshallLocationName("resourceId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceType")
            .getter(getter(TransitGatewayRouteTableRoute::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType")
                    .unmarshallLocationName("resourceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_CIDR_FIELD,
            STATE_FIELD, ROUTE_ORIGIN_FIELD, PREFIX_LIST_ID_FIELD, ATTACHMENT_ID_FIELD, RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("DestinationCidr", DESTINATION_CIDR_FIELD);
                    put("State", STATE_FIELD);
                    put("RouteOrigin", ROUTE_ORIGIN_FIELD);
                    put("PrefixListId", PREFIX_LIST_ID_FIELD);
                    put("AttachmentId", ATTACHMENT_ID_FIELD);
                    put("ResourceId", RESOURCE_ID_FIELD);
                    put("ResourceType", RESOURCE_TYPE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String destinationCidr;

    private final String state;

    private final String routeOrigin;

    private final String prefixListId;

    private final String attachmentId;

    private final String resourceId;

    private final String resourceType;

    private TransitGatewayRouteTableRoute(BuilderImpl builder) {
        this.destinationCidr = builder.destinationCidr;
        this.state = builder.state;
        this.routeOrigin = builder.routeOrigin;
        this.prefixListId = builder.prefixListId;
        this.attachmentId = builder.attachmentId;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
    }

    /**
     * <p>
     * The CIDR block used for destination matches.
     * </p>
     * 
     * @return The CIDR block used for destination matches.
     */
    public final String destinationCidr() {
        return destinationCidr;
    }

    /**
     * <p>
     * The state of the route.
     * </p>
     * 
     * @return The state of the route.
     */
    public final String state() {
        return state;
    }

    /**
     * <p>
     * The route origin. The following are the possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * static
     * </p>
     * </li>
     * <li>
     * <p>
     * propagated
     * </p>
     * </li>
     * </ul>
     * 
     * @return The route origin. The following are the possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         static
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         propagated
     *         </p>
     *         </li>
     */
    public final String routeOrigin() {
        return routeOrigin;
    }

    /**
     * <p>
     * The ID of the prefix list.
     * </p>
     * 
     * @return The ID of the prefix list.
     */
    public final String prefixListId() {
        return prefixListId;
    }

    /**
     * <p>
     * The ID of the route attachment.
     * </p>
     * 
     * @return The ID of the route attachment.
     */
    public final String attachmentId() {
        return attachmentId;
    }

    /**
     * <p>
     * The ID of the resource for the route attachment.
     * </p>
     * 
     * @return The ID of the resource for the route attachment.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The resource type for the route attachment.
     * </p>
     * 
     * @return The resource type for the route attachment.
     */
    public final String resourceType() {
        return resourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationCidr());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(routeOrigin());
        hashCode = 31 * hashCode + Objects.hashCode(prefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(attachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayRouteTableRoute)) {
            return false;
        }
        TransitGatewayRouteTableRoute other = (TransitGatewayRouteTableRoute) obj;
        return Objects.equals(destinationCidr(), other.destinationCidr()) && Objects.equals(state(), other.state())
                && Objects.equals(routeOrigin(), other.routeOrigin()) && Objects.equals(prefixListId(), other.prefixListId())
                && Objects.equals(attachmentId(), other.attachmentId()) && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(resourceType(), other.resourceType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransitGatewayRouteTableRoute").add("DestinationCidr", destinationCidr()).add("State", state())
                .add("RouteOrigin", routeOrigin()).add("PrefixListId", prefixListId()).add("AttachmentId", attachmentId())
                .add("ResourceId", resourceId()).add("ResourceType", resourceType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationCidr":
            return Optional.ofNullable(clazz.cast(destinationCidr()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "RouteOrigin":
            return Optional.ofNullable(clazz.cast(routeOrigin()));
        case "PrefixListId":
            return Optional.ofNullable(clazz.cast(prefixListId()));
        case "AttachmentId":
            return Optional.ofNullable(clazz.cast(attachmentId()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayRouteTableRoute, T> g) {
        return obj -> g.apply((TransitGatewayRouteTableRoute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransitGatewayRouteTableRoute> {
        /**
         * <p>
         * The CIDR block used for destination matches.
         * </p>
         * 
         * @param destinationCidr
         *        The CIDR block used for destination matches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCidr(String destinationCidr);

        /**
         * <p>
         * The state of the route.
         * </p>
         * 
         * @param state
         *        The state of the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * The route origin. The following are the possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * static
         * </p>
         * </li>
         * <li>
         * <p>
         * propagated
         * </p>
         * </li>
         * </ul>
         * 
         * @param routeOrigin
         *        The route origin. The following are the possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        static
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        propagated
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeOrigin(String routeOrigin);

        /**
         * <p>
         * The ID of the prefix list.
         * </p>
         * 
         * @param prefixListId
         *        The ID of the prefix list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListId(String prefixListId);

        /**
         * <p>
         * The ID of the route attachment.
         * </p>
         * 
         * @param attachmentId
         *        The ID of the route attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentId(String attachmentId);

        /**
         * <p>
         * The ID of the resource for the route attachment.
         * </p>
         * 
         * @param resourceId
         *        The ID of the resource for the route attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The resource type for the route attachment.
         * </p>
         * 
         * @param resourceType
         *        The resource type for the route attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);
    }

    static final class BuilderImpl implements Builder {
        private String destinationCidr;

        private String state;

        private String routeOrigin;

        private String prefixListId;

        private String attachmentId;

        private String resourceId;

        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayRouteTableRoute model) {
            destinationCidr(model.destinationCidr);
            state(model.state);
            routeOrigin(model.routeOrigin);
            prefixListId(model.prefixListId);
            attachmentId(model.attachmentId);
            resourceId(model.resourceId);
            resourceType(model.resourceType);
        }

        public final String getDestinationCidr() {
            return destinationCidr;
        }

        public final void setDestinationCidr(String destinationCidr) {
            this.destinationCidr = destinationCidr;
        }

        @Override
        public final Builder destinationCidr(String destinationCidr) {
            this.destinationCidr = destinationCidr;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getRouteOrigin() {
            return routeOrigin;
        }

        public final void setRouteOrigin(String routeOrigin) {
            this.routeOrigin = routeOrigin;
        }

        @Override
        public final Builder routeOrigin(String routeOrigin) {
            this.routeOrigin = routeOrigin;
            return this;
        }

        public final String getPrefixListId() {
            return prefixListId;
        }

        public final void setPrefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
        }

        @Override
        public final Builder prefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
            return this;
        }

        public final String getAttachmentId() {
            return attachmentId;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        @Override
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public TransitGatewayRouteTableRoute build() {
            return new TransitGatewayRouteTableRoute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
