/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.SecurityGroupIdListCopier;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpointAttachmentType;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpointEniOptions;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpointLoadBalancerOptions;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpointStatus;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpointType;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessSseSpecificationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VerifiedAccessEndpoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VerifiedAccessEndpoint> {
    private static final SdkField<String> VERIFIED_ACCESS_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VerifiedAccessInstanceId").getter(VerifiedAccessEndpoint.getter(VerifiedAccessEndpoint::verifiedAccessInstanceId)).setter(VerifiedAccessEndpoint.setter(Builder::verifiedAccessInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessInstanceId").unmarshallLocationName("verifiedAccessInstanceId").build()}).build();
    private static final SdkField<String> VERIFIED_ACCESS_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VerifiedAccessGroupId").getter(VerifiedAccessEndpoint.getter(VerifiedAccessEndpoint::verifiedAccessGroupId)).setter(VerifiedAccessEndpoint.setter(Builder::verifiedAccessGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessGroupId").unmarshallLocationName("verifiedAccessGroupId").build()}).build();
    private static final SdkField<String> VERIFIED_ACCESS_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VerifiedAccessEndpointId").getter(VerifiedAccessEndpoint.getter(VerifiedAccessEndpoint::verifiedAccessEndpointId)).setter(VerifiedAccessEndpoint.setter(Builder::verifiedAccessEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessEndpointId").unmarshallLocationName("verifiedAccessEndpointId").build()}).build();
    private static final SdkField<String> APPLICATION_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationDomain").getter(VerifiedAccessEndpoint.getter(VerifiedAccessEndpoint::applicationDomain)).setter(VerifiedAccessEndpoint.setter(Builder::applicationDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationDomain").unmarshallLocationName("applicationDomain").build()}).build();
    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointType").getter(VerifiedAccessEndpoint.getter(VerifiedAccessEndpoint::endpointTypeAsString)).setter(VerifiedAccessEndpoint.setter(Builder::endpointType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").unmarshallLocationName("endpointType").build()}).build();
    private static final SdkField<String> ATTACHMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttachmentType").getter(VerifiedAccessEndpoint.getter(VerifiedAccessEndpoint::attachmentTypeAsString)).setter(VerifiedAccessEndpoint.setter(Builder::attachmentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentType").unmarshallLocationName("attachmentType").build()}).build();
    private static final SdkField<String> DOMAIN_CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainCertificateArn").getter(VerifiedAccessEndpoint.getter(VerifiedAccessEndpoint::domainCertificateArn)).setter(VerifiedAccessEndpoint.setter(Builder::domainCertificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainCertificateArn").unmarshallLocationName("domainCertificateArn").build()}).build();
    private static final SdkField<String> ENDPOINT_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointDomain").getter(VerifiedAccessEndpoint.getter(VerifiedAccessEndpoint::endpointDomain)).setter(VerifiedAccessEndpoint.setter(Builder::endpointDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointDomain").unmarshallLocationName("endpointDomain").build()}).build();
    private static final SdkField<String> DEVICE_VALIDATION_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceValidationDomain").getter(VerifiedAccessEndpoint.getter(VerifiedAccessEndpoint::deviceValidationDomain)).setter(VerifiedAccessEndpoint.setter(Builder::deviceValidationDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceValidationDomain").unmarshallLocationName("deviceValidationDomain").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(VerifiedAccessEndpoint.getter(VerifiedAccessEndpoint::securityGroupIds)).setter(VerifiedAccessEndpoint.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIdSet").unmarshallLocationName("securityGroupIdSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<VerifiedAccessEndpointLoadBalancerOptions> LOAD_BALANCER_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoadBalancerOptions").getter(VerifiedAccessEndpoint.getter(VerifiedAccessEndpoint::loadBalancerOptions)).setter(VerifiedAccessEndpoint.setter(Builder::loadBalancerOptions)).constructor(VerifiedAccessEndpointLoadBalancerOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerOptions").unmarshallLocationName("loadBalancerOptions").build()}).build();
    private static final SdkField<VerifiedAccessEndpointEniOptions> NETWORK_INTERFACE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkInterfaceOptions").getter(VerifiedAccessEndpoint.getter(VerifiedAccessEndpoint::networkInterfaceOptions)).setter(VerifiedAccessEndpoint.setter(Builder::networkInterfaceOptions)).constructor(VerifiedAccessEndpointEniOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceOptions").unmarshallLocationName("networkInterfaceOptions").build()}).build();
    private static final SdkField<VerifiedAccessEndpointStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Status").getter(VerifiedAccessEndpoint.getter(VerifiedAccessEndpoint::status)).setter(VerifiedAccessEndpoint.setter(Builder::status)).constructor(VerifiedAccessEndpointStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(VerifiedAccessEndpoint.getter(VerifiedAccessEndpoint::description)).setter(VerifiedAccessEndpoint.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationTime").getter(VerifiedAccessEndpoint.getter(VerifiedAccessEndpoint::creationTime)).setter(VerifiedAccessEndpoint.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").unmarshallLocationName("creationTime").build()}).build();
    private static final SdkField<String> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastUpdatedTime").getter(VerifiedAccessEndpoint.getter(VerifiedAccessEndpoint::lastUpdatedTime)).setter(VerifiedAccessEndpoint.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").unmarshallLocationName("lastUpdatedTime").build()}).build();
    private static final SdkField<String> DELETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeletionTime").getter(VerifiedAccessEndpoint.getter(VerifiedAccessEndpoint::deletionTime)).setter(VerifiedAccessEndpoint.setter(Builder::deletionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionTime").unmarshallLocationName("deletionTime").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(VerifiedAccessEndpoint.getter(VerifiedAccessEndpoint::tags)).setter(VerifiedAccessEndpoint.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<VerifiedAccessSseSpecificationResponse> SSE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SseSpecification").getter(VerifiedAccessEndpoint.getter(VerifiedAccessEndpoint::sseSpecification)).setter(VerifiedAccessEndpoint.setter(Builder::sseSpecification)).constructor(VerifiedAccessSseSpecificationResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SseSpecification").unmarshallLocationName("sseSpecification").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERIFIED_ACCESS_INSTANCE_ID_FIELD, VERIFIED_ACCESS_GROUP_ID_FIELD, VERIFIED_ACCESS_ENDPOINT_ID_FIELD, APPLICATION_DOMAIN_FIELD, ENDPOINT_TYPE_FIELD, ATTACHMENT_TYPE_FIELD, DOMAIN_CERTIFICATE_ARN_FIELD, ENDPOINT_DOMAIN_FIELD, DEVICE_VALIDATION_DOMAIN_FIELD, SECURITY_GROUP_IDS_FIELD, LOAD_BALANCER_OPTIONS_FIELD, NETWORK_INTERFACE_OPTIONS_FIELD, STATUS_FIELD, DESCRIPTION_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_TIME_FIELD, DELETION_TIME_FIELD, TAGS_FIELD, SSE_SPECIFICATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("VerifiedAccessInstanceId", VERIFIED_ACCESS_INSTANCE_ID_FIELD);
            this.put("VerifiedAccessGroupId", VERIFIED_ACCESS_GROUP_ID_FIELD);
            this.put("VerifiedAccessEndpointId", VERIFIED_ACCESS_ENDPOINT_ID_FIELD);
            this.put("ApplicationDomain", APPLICATION_DOMAIN_FIELD);
            this.put("EndpointType", ENDPOINT_TYPE_FIELD);
            this.put("AttachmentType", ATTACHMENT_TYPE_FIELD);
            this.put("DomainCertificateArn", DOMAIN_CERTIFICATE_ARN_FIELD);
            this.put("EndpointDomain", ENDPOINT_DOMAIN_FIELD);
            this.put("DeviceValidationDomain", DEVICE_VALIDATION_DOMAIN_FIELD);
            this.put("SecurityGroupIdSet", SECURITY_GROUP_IDS_FIELD);
            this.put("LoadBalancerOptions", LOAD_BALANCER_OPTIONS_FIELD);
            this.put("NetworkInterfaceOptions", NETWORK_INTERFACE_OPTIONS_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
            this.put("DeletionTime", DELETION_TIME_FIELD);
            this.put("TagSet", TAGS_FIELD);
            this.put("SseSpecification", SSE_SPECIFICATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String verifiedAccessInstanceId;
    private final String verifiedAccessGroupId;
    private final String verifiedAccessEndpointId;
    private final String applicationDomain;
    private final String endpointType;
    private final String attachmentType;
    private final String domainCertificateArn;
    private final String endpointDomain;
    private final String deviceValidationDomain;
    private final List<String> securityGroupIds;
    private final VerifiedAccessEndpointLoadBalancerOptions loadBalancerOptions;
    private final VerifiedAccessEndpointEniOptions networkInterfaceOptions;
    private final VerifiedAccessEndpointStatus status;
    private final String description;
    private final String creationTime;
    private final String lastUpdatedTime;
    private final String deletionTime;
    private final List<Tag> tags;
    private final VerifiedAccessSseSpecificationResponse sseSpecification;

    private VerifiedAccessEndpoint(BuilderImpl builder) {
        this.verifiedAccessInstanceId = builder.verifiedAccessInstanceId;
        this.verifiedAccessGroupId = builder.verifiedAccessGroupId;
        this.verifiedAccessEndpointId = builder.verifiedAccessEndpointId;
        this.applicationDomain = builder.applicationDomain;
        this.endpointType = builder.endpointType;
        this.attachmentType = builder.attachmentType;
        this.domainCertificateArn = builder.domainCertificateArn;
        this.endpointDomain = builder.endpointDomain;
        this.deviceValidationDomain = builder.deviceValidationDomain;
        this.securityGroupIds = builder.securityGroupIds;
        this.loadBalancerOptions = builder.loadBalancerOptions;
        this.networkInterfaceOptions = builder.networkInterfaceOptions;
        this.status = builder.status;
        this.description = builder.description;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.deletionTime = builder.deletionTime;
        this.tags = builder.tags;
        this.sseSpecification = builder.sseSpecification;
    }

    public final String verifiedAccessInstanceId() {
        return this.verifiedAccessInstanceId;
    }

    public final String verifiedAccessGroupId() {
        return this.verifiedAccessGroupId;
    }

    public final String verifiedAccessEndpointId() {
        return this.verifiedAccessEndpointId;
    }

    public final String applicationDomain() {
        return this.applicationDomain;
    }

    public final VerifiedAccessEndpointType endpointType() {
        return VerifiedAccessEndpointType.fromValue(this.endpointType);
    }

    public final String endpointTypeAsString() {
        return this.endpointType;
    }

    public final VerifiedAccessEndpointAttachmentType attachmentType() {
        return VerifiedAccessEndpointAttachmentType.fromValue(this.attachmentType);
    }

    public final String attachmentTypeAsString() {
        return this.attachmentType;
    }

    public final String domainCertificateArn() {
        return this.domainCertificateArn;
    }

    public final String endpointDomain() {
        return this.endpointDomain;
    }

    public final String deviceValidationDomain() {
        return this.deviceValidationDomain;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final VerifiedAccessEndpointLoadBalancerOptions loadBalancerOptions() {
        return this.loadBalancerOptions;
    }

    public final VerifiedAccessEndpointEniOptions networkInterfaceOptions() {
        return this.networkInterfaceOptions;
    }

    public final VerifiedAccessEndpointStatus status() {
        return this.status;
    }

    public final String description() {
        return this.description;
    }

    public final String creationTime() {
        return this.creationTime;
    }

    public final String lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final String deletionTime() {
        return this.deletionTime;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final VerifiedAccessSseSpecificationResponse sseSpecification() {
        return this.sseSpecification;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.verifiedAccessInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.verifiedAccessGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.verifiedAccessEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainCertificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceValidationDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sseSpecification());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifiedAccessEndpoint)) {
            return false;
        }
        VerifiedAccessEndpoint other = (VerifiedAccessEndpoint)obj;
        return Objects.equals(this.verifiedAccessInstanceId(), other.verifiedAccessInstanceId()) && Objects.equals(this.verifiedAccessGroupId(), other.verifiedAccessGroupId()) && Objects.equals(this.verifiedAccessEndpointId(), other.verifiedAccessEndpointId()) && Objects.equals(this.applicationDomain(), other.applicationDomain()) && Objects.equals(this.endpointTypeAsString(), other.endpointTypeAsString()) && Objects.equals(this.attachmentTypeAsString(), other.attachmentTypeAsString()) && Objects.equals(this.domainCertificateArn(), other.domainCertificateArn()) && Objects.equals(this.endpointDomain(), other.endpointDomain()) && Objects.equals(this.deviceValidationDomain(), other.deviceValidationDomain()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.loadBalancerOptions(), other.loadBalancerOptions()) && Objects.equals(this.networkInterfaceOptions(), other.networkInterfaceOptions()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.deletionTime(), other.deletionTime()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.sseSpecification(), other.sseSpecification());
    }

    public final String toString() {
        return ToString.builder((String)"VerifiedAccessEndpoint").add("VerifiedAccessInstanceId", (Object)this.verifiedAccessInstanceId()).add("VerifiedAccessGroupId", (Object)this.verifiedAccessGroupId()).add("VerifiedAccessEndpointId", (Object)this.verifiedAccessEndpointId()).add("ApplicationDomain", (Object)this.applicationDomain()).add("EndpointType", (Object)this.endpointTypeAsString()).add("AttachmentType", (Object)this.attachmentTypeAsString()).add("DomainCertificateArn", (Object)this.domainCertificateArn()).add("EndpointDomain", (Object)this.endpointDomain()).add("DeviceValidationDomain", (Object)this.deviceValidationDomain()).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("LoadBalancerOptions", (Object)this.loadBalancerOptions()).add("NetworkInterfaceOptions", (Object)this.networkInterfaceOptions()).add("Status", (Object)this.status()).add("Description", (Object)this.description()).add("CreationTime", (Object)this.creationTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("DeletionTime", (Object)this.deletionTime()).add("Tags", this.hasTags() ? this.tags() : null).add("SseSpecification", (Object)this.sseSpecification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VerifiedAccessInstanceId": {
                return Optional.ofNullable(clazz.cast(this.verifiedAccessInstanceId()));
            }
            case "VerifiedAccessGroupId": {
                return Optional.ofNullable(clazz.cast(this.verifiedAccessGroupId()));
            }
            case "VerifiedAccessEndpointId": {
                return Optional.ofNullable(clazz.cast(this.verifiedAccessEndpointId()));
            }
            case "ApplicationDomain": {
                return Optional.ofNullable(clazz.cast(this.applicationDomain()));
            }
            case "EndpointType": {
                return Optional.ofNullable(clazz.cast(this.endpointTypeAsString()));
            }
            case "AttachmentType": {
                return Optional.ofNullable(clazz.cast(this.attachmentTypeAsString()));
            }
            case "DomainCertificateArn": {
                return Optional.ofNullable(clazz.cast(this.domainCertificateArn()));
            }
            case "EndpointDomain": {
                return Optional.ofNullable(clazz.cast(this.endpointDomain()));
            }
            case "DeviceValidationDomain": {
                return Optional.ofNullable(clazz.cast(this.deviceValidationDomain()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "LoadBalancerOptions": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerOptions()));
            }
            case "NetworkInterfaceOptions": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceOptions()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "DeletionTime": {
                return Optional.ofNullable(clazz.cast(this.deletionTime()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "SseSpecification": {
                return Optional.ofNullable(clazz.cast(this.sseSpecification()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VerifiedAccessEndpoint, T> g) {
        return obj -> g.apply((VerifiedAccessEndpoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String verifiedAccessInstanceId;
        private String verifiedAccessGroupId;
        private String verifiedAccessEndpointId;
        private String applicationDomain;
        private String endpointType;
        private String attachmentType;
        private String domainCertificateArn;
        private String endpointDomain;
        private String deviceValidationDomain;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private VerifiedAccessEndpointLoadBalancerOptions loadBalancerOptions;
        private VerifiedAccessEndpointEniOptions networkInterfaceOptions;
        private VerifiedAccessEndpointStatus status;
        private String description;
        private String creationTime;
        private String lastUpdatedTime;
        private String deletionTime;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private VerifiedAccessSseSpecificationResponse sseSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifiedAccessEndpoint model) {
            this.verifiedAccessInstanceId(model.verifiedAccessInstanceId);
            this.verifiedAccessGroupId(model.verifiedAccessGroupId);
            this.verifiedAccessEndpointId(model.verifiedAccessEndpointId);
            this.applicationDomain(model.applicationDomain);
            this.endpointType(model.endpointType);
            this.attachmentType(model.attachmentType);
            this.domainCertificateArn(model.domainCertificateArn);
            this.endpointDomain(model.endpointDomain);
            this.deviceValidationDomain(model.deviceValidationDomain);
            this.securityGroupIds(model.securityGroupIds);
            this.loadBalancerOptions(model.loadBalancerOptions);
            this.networkInterfaceOptions(model.networkInterfaceOptions);
            this.status(model.status);
            this.description(model.description);
            this.creationTime(model.creationTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.deletionTime(model.deletionTime);
            this.tags(model.tags);
            this.sseSpecification(model.sseSpecification);
        }

        public final String getVerifiedAccessInstanceId() {
            return this.verifiedAccessInstanceId;
        }

        public final void setVerifiedAccessInstanceId(String verifiedAccessInstanceId) {
            this.verifiedAccessInstanceId = verifiedAccessInstanceId;
        }

        @Override
        public final Builder verifiedAccessInstanceId(String verifiedAccessInstanceId) {
            this.verifiedAccessInstanceId = verifiedAccessInstanceId;
            return this;
        }

        public final String getVerifiedAccessGroupId() {
            return this.verifiedAccessGroupId;
        }

        public final void setVerifiedAccessGroupId(String verifiedAccessGroupId) {
            this.verifiedAccessGroupId = verifiedAccessGroupId;
        }

        @Override
        public final Builder verifiedAccessGroupId(String verifiedAccessGroupId) {
            this.verifiedAccessGroupId = verifiedAccessGroupId;
            return this;
        }

        public final String getVerifiedAccessEndpointId() {
            return this.verifiedAccessEndpointId;
        }

        public final void setVerifiedAccessEndpointId(String verifiedAccessEndpointId) {
            this.verifiedAccessEndpointId = verifiedAccessEndpointId;
        }

        @Override
        public final Builder verifiedAccessEndpointId(String verifiedAccessEndpointId) {
            this.verifiedAccessEndpointId = verifiedAccessEndpointId;
            return this;
        }

        public final String getApplicationDomain() {
            return this.applicationDomain;
        }

        public final void setApplicationDomain(String applicationDomain) {
            this.applicationDomain = applicationDomain;
        }

        @Override
        public final Builder applicationDomain(String applicationDomain) {
            this.applicationDomain = applicationDomain;
            return this;
        }

        public final String getEndpointType() {
            return this.endpointType;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        @Override
        public final Builder endpointType(VerifiedAccessEndpointType endpointType) {
            this.endpointType(endpointType == null ? null : endpointType.toString());
            return this;
        }

        public final String getAttachmentType() {
            return this.attachmentType;
        }

        public final void setAttachmentType(String attachmentType) {
            this.attachmentType = attachmentType;
        }

        @Override
        public final Builder attachmentType(String attachmentType) {
            this.attachmentType = attachmentType;
            return this;
        }

        @Override
        public final Builder attachmentType(VerifiedAccessEndpointAttachmentType attachmentType) {
            this.attachmentType(attachmentType == null ? null : attachmentType.toString());
            return this;
        }

        public final String getDomainCertificateArn() {
            return this.domainCertificateArn;
        }

        public final void setDomainCertificateArn(String domainCertificateArn) {
            this.domainCertificateArn = domainCertificateArn;
        }

        @Override
        public final Builder domainCertificateArn(String domainCertificateArn) {
            this.domainCertificateArn = domainCertificateArn;
            return this;
        }

        public final String getEndpointDomain() {
            return this.endpointDomain;
        }

        public final void setEndpointDomain(String endpointDomain) {
            this.endpointDomain = endpointDomain;
        }

        @Override
        public final Builder endpointDomain(String endpointDomain) {
            this.endpointDomain = endpointDomain;
            return this;
        }

        public final String getDeviceValidationDomain() {
            return this.deviceValidationDomain;
        }

        public final void setDeviceValidationDomain(String deviceValidationDomain) {
            this.deviceValidationDomain = deviceValidationDomain;
        }

        @Override
        public final Builder deviceValidationDomain(String deviceValidationDomain) {
            this.deviceValidationDomain = deviceValidationDomain;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final VerifiedAccessEndpointLoadBalancerOptions.Builder getLoadBalancerOptions() {
            return this.loadBalancerOptions != null ? this.loadBalancerOptions.toBuilder() : null;
        }

        public final void setLoadBalancerOptions(VerifiedAccessEndpointLoadBalancerOptions.BuilderImpl loadBalancerOptions) {
            this.loadBalancerOptions = loadBalancerOptions != null ? loadBalancerOptions.build() : null;
        }

        @Override
        public final Builder loadBalancerOptions(VerifiedAccessEndpointLoadBalancerOptions loadBalancerOptions) {
            this.loadBalancerOptions = loadBalancerOptions;
            return this;
        }

        public final VerifiedAccessEndpointEniOptions.Builder getNetworkInterfaceOptions() {
            return this.networkInterfaceOptions != null ? this.networkInterfaceOptions.toBuilder() : null;
        }

        public final void setNetworkInterfaceOptions(VerifiedAccessEndpointEniOptions.BuilderImpl networkInterfaceOptions) {
            this.networkInterfaceOptions = networkInterfaceOptions != null ? networkInterfaceOptions.build() : null;
        }

        @Override
        public final Builder networkInterfaceOptions(VerifiedAccessEndpointEniOptions networkInterfaceOptions) {
            this.networkInterfaceOptions = networkInterfaceOptions;
            return this;
        }

        public final VerifiedAccessEndpointStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(VerifiedAccessEndpointStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(VerifiedAccessEndpointStatus status) {
            this.status = status;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getDeletionTime() {
            return this.deletionTime;
        }

        public final void setDeletionTime(String deletionTime) {
            this.deletionTime = deletionTime;
        }

        @Override
        public final Builder deletionTime(String deletionTime) {
            this.deletionTime = deletionTime;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final VerifiedAccessSseSpecificationResponse.Builder getSseSpecification() {
            return this.sseSpecification != null ? this.sseSpecification.toBuilder() : null;
        }

        public final void setSseSpecification(VerifiedAccessSseSpecificationResponse.BuilderImpl sseSpecification) {
            this.sseSpecification = sseSpecification != null ? sseSpecification.build() : null;
        }

        @Override
        public final Builder sseSpecification(VerifiedAccessSseSpecificationResponse sseSpecification) {
            this.sseSpecification = sseSpecification;
            return this;
        }

        public VerifiedAccessEndpoint build() {
            return new VerifiedAccessEndpoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VerifiedAccessEndpoint> {
        public Builder verifiedAccessInstanceId(String var1);

        public Builder verifiedAccessGroupId(String var1);

        public Builder verifiedAccessEndpointId(String var1);

        public Builder applicationDomain(String var1);

        public Builder endpointType(String var1);

        public Builder endpointType(VerifiedAccessEndpointType var1);

        public Builder attachmentType(String var1);

        public Builder attachmentType(VerifiedAccessEndpointAttachmentType var1);

        public Builder domainCertificateArn(String var1);

        public Builder endpointDomain(String var1);

        public Builder deviceValidationDomain(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder loadBalancerOptions(VerifiedAccessEndpointLoadBalancerOptions var1);

        default public Builder loadBalancerOptions(Consumer<VerifiedAccessEndpointLoadBalancerOptions.Builder> loadBalancerOptions) {
            return this.loadBalancerOptions((VerifiedAccessEndpointLoadBalancerOptions)((VerifiedAccessEndpointLoadBalancerOptions.Builder)VerifiedAccessEndpointLoadBalancerOptions.builder().applyMutation(loadBalancerOptions)).build());
        }

        public Builder networkInterfaceOptions(VerifiedAccessEndpointEniOptions var1);

        default public Builder networkInterfaceOptions(Consumer<VerifiedAccessEndpointEniOptions.Builder> networkInterfaceOptions) {
            return this.networkInterfaceOptions((VerifiedAccessEndpointEniOptions)((VerifiedAccessEndpointEniOptions.Builder)VerifiedAccessEndpointEniOptions.builder().applyMutation(networkInterfaceOptions)).build());
        }

        public Builder status(VerifiedAccessEndpointStatus var1);

        default public Builder status(Consumer<VerifiedAccessEndpointStatus.Builder> status) {
            return this.status((VerifiedAccessEndpointStatus)((VerifiedAccessEndpointStatus.Builder)VerifiedAccessEndpointStatus.builder().applyMutation(status)).build());
        }

        public Builder description(String var1);

        public Builder creationTime(String var1);

        public Builder lastUpdatedTime(String var1);

        public Builder deletionTime(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder sseSpecification(VerifiedAccessSseSpecificationResponse var1);

        default public Builder sseSpecification(Consumer<VerifiedAccessSseSpecificationResponse.Builder> sseSpecification) {
            return this.sseSpecification((VerifiedAccessSseSpecificationResponse)((VerifiedAccessSseSpecificationResponse.Builder)VerifiedAccessSseSpecificationResponse.builder().applyMutation(sseSpecification)).build());
        }
    }
}

