/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the DNS options for an endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DnsOptions implements SdkPojo, Serializable, ToCopyableBuilder<DnsOptions.Builder, DnsOptions> {
    private static final SdkField<String> DNS_RECORD_IP_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DnsRecordIpType")
            .getter(getter(DnsOptions::dnsRecordIpTypeAsString))
            .setter(setter(Builder::dnsRecordIpType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsRecordIpType")
                    .unmarshallLocationName("dnsRecordIpType").build()).build();

    private static final SdkField<Boolean> PRIVATE_DNS_ONLY_FOR_INBOUND_RESOLVER_ENDPOINT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PrivateDnsOnlyForInboundResolverEndpoint")
            .getter(getter(DnsOptions::privateDnsOnlyForInboundResolverEndpoint))
            .setter(setter(Builder::privateDnsOnlyForInboundResolverEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("PrivateDnsOnlyForInboundResolverEndpoint")
                    .unmarshallLocationName("privateDnsOnlyForInboundResolverEndpoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DNS_RECORD_IP_TYPE_FIELD,
            PRIVATE_DNS_ONLY_FOR_INBOUND_RESOLVER_ENDPOINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("DnsRecordIpType", DNS_RECORD_IP_TYPE_FIELD);
                    put("PrivateDnsOnlyForInboundResolverEndpoint", PRIVATE_DNS_ONLY_FOR_INBOUND_RESOLVER_ENDPOINT_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String dnsRecordIpType;

    private final Boolean privateDnsOnlyForInboundResolverEndpoint;

    private DnsOptions(BuilderImpl builder) {
        this.dnsRecordIpType = builder.dnsRecordIpType;
        this.privateDnsOnlyForInboundResolverEndpoint = builder.privateDnsOnlyForInboundResolverEndpoint;
    }

    /**
     * <p>
     * The DNS records created for the endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dnsRecordIpType}
     * will return {@link DnsRecordIpType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dnsRecordIpTypeAsString}.
     * </p>
     * 
     * @return The DNS records created for the endpoint.
     * @see DnsRecordIpType
     */
    public final DnsRecordIpType dnsRecordIpType() {
        return DnsRecordIpType.fromValue(dnsRecordIpType);
    }

    /**
     * <p>
     * The DNS records created for the endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dnsRecordIpType}
     * will return {@link DnsRecordIpType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dnsRecordIpTypeAsString}.
     * </p>
     * 
     * @return The DNS records created for the endpoint.
     * @see DnsRecordIpType
     */
    public final String dnsRecordIpTypeAsString() {
        return dnsRecordIpType;
    }

    /**
     * <p>
     * Indicates whether to enable private DNS only for inbound endpoints.
     * </p>
     * 
     * @return Indicates whether to enable private DNS only for inbound endpoints.
     */
    public final Boolean privateDnsOnlyForInboundResolverEndpoint() {
        return privateDnsOnlyForInboundResolverEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dnsRecordIpTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(privateDnsOnlyForInboundResolverEndpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DnsOptions)) {
            return false;
        }
        DnsOptions other = (DnsOptions) obj;
        return Objects.equals(dnsRecordIpTypeAsString(), other.dnsRecordIpTypeAsString())
                && Objects.equals(privateDnsOnlyForInboundResolverEndpoint(), other.privateDnsOnlyForInboundResolverEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DnsOptions").add("DnsRecordIpType", dnsRecordIpTypeAsString())
                .add("PrivateDnsOnlyForInboundResolverEndpoint", privateDnsOnlyForInboundResolverEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DnsRecordIpType":
            return Optional.ofNullable(clazz.cast(dnsRecordIpTypeAsString()));
        case "PrivateDnsOnlyForInboundResolverEndpoint":
            return Optional.ofNullable(clazz.cast(privateDnsOnlyForInboundResolverEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DnsOptions, T> g) {
        return obj -> g.apply((DnsOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DnsOptions> {
        /**
         * <p>
         * The DNS records created for the endpoint.
         * </p>
         * 
         * @param dnsRecordIpType
         *        The DNS records created for the endpoint.
         * @see DnsRecordIpType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsRecordIpType
         */
        Builder dnsRecordIpType(String dnsRecordIpType);

        /**
         * <p>
         * The DNS records created for the endpoint.
         * </p>
         * 
         * @param dnsRecordIpType
         *        The DNS records created for the endpoint.
         * @see DnsRecordIpType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsRecordIpType
         */
        Builder dnsRecordIpType(DnsRecordIpType dnsRecordIpType);

        /**
         * <p>
         * Indicates whether to enable private DNS only for inbound endpoints.
         * </p>
         * 
         * @param privateDnsOnlyForInboundResolverEndpoint
         *        Indicates whether to enable private DNS only for inbound endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsOnlyForInboundResolverEndpoint(Boolean privateDnsOnlyForInboundResolverEndpoint);
    }

    static final class BuilderImpl implements Builder {
        private String dnsRecordIpType;

        private Boolean privateDnsOnlyForInboundResolverEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(DnsOptions model) {
            dnsRecordIpType(model.dnsRecordIpType);
            privateDnsOnlyForInboundResolverEndpoint(model.privateDnsOnlyForInboundResolverEndpoint);
        }

        public final String getDnsRecordIpType() {
            return dnsRecordIpType;
        }

        public final void setDnsRecordIpType(String dnsRecordIpType) {
            this.dnsRecordIpType = dnsRecordIpType;
        }

        @Override
        public final Builder dnsRecordIpType(String dnsRecordIpType) {
            this.dnsRecordIpType = dnsRecordIpType;
            return this;
        }

        @Override
        public final Builder dnsRecordIpType(DnsRecordIpType dnsRecordIpType) {
            this.dnsRecordIpType(dnsRecordIpType == null ? null : dnsRecordIpType.toString());
            return this;
        }

        public final Boolean getPrivateDnsOnlyForInboundResolverEndpoint() {
            return privateDnsOnlyForInboundResolverEndpoint;
        }

        public final void setPrivateDnsOnlyForInboundResolverEndpoint(Boolean privateDnsOnlyForInboundResolverEndpoint) {
            this.privateDnsOnlyForInboundResolverEndpoint = privateDnsOnlyForInboundResolverEndpoint;
        }

        @Override
        public final Builder privateDnsOnlyForInboundResolverEndpoint(Boolean privateDnsOnlyForInboundResolverEndpoint) {
            this.privateDnsOnlyForInboundResolverEndpoint = privateDnsOnlyForInboundResolverEndpoint;
            return this;
        }

        @Override
        public DnsOptions build() {
            return new DnsOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
