/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An IPAM discovered account. A discovered account is an Amazon Web Services account that is monitored under a resource
 * discovery. If you have integrated IPAM with Amazon Web Services Organizations, all accounts in the organization are
 * discovered accounts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IpamDiscoveredAccount implements SdkPojo, Serializable,
        ToCopyableBuilder<IpamDiscoveredAccount.Builder, IpamDiscoveredAccount> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccountId")
            .getter(getter(IpamDiscoveredAccount::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId")
                    .unmarshallLocationName("accountId").build()).build();

    private static final SdkField<String> DISCOVERY_REGION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DiscoveryRegion")
            .getter(getter(IpamDiscoveredAccount::discoveryRegion))
            .setter(setter(Builder::discoveryRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscoveryRegion")
                    .unmarshallLocationName("discoveryRegion").build()).build();

    private static final SdkField<IpamDiscoveryFailureReason> FAILURE_REASON_FIELD = SdkField
            .<IpamDiscoveryFailureReason> builder(MarshallingType.SDK_POJO)
            .memberName("FailureReason")
            .getter(getter(IpamDiscoveredAccount::failureReason))
            .setter(setter(Builder::failureReason))
            .constructor(IpamDiscoveryFailureReason::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason")
                    .unmarshallLocationName("failureReason").build()).build();

    private static final SdkField<Instant> LAST_ATTEMPTED_DISCOVERY_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastAttemptedDiscoveryTime")
            .getter(getter(IpamDiscoveredAccount::lastAttemptedDiscoveryTime))
            .setter(setter(Builder::lastAttemptedDiscoveryTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAttemptedDiscoveryTime")
                    .unmarshallLocationName("lastAttemptedDiscoveryTime").build()).build();

    private static final SdkField<Instant> LAST_SUCCESSFUL_DISCOVERY_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastSuccessfulDiscoveryTime")
            .getter(getter(IpamDiscoveredAccount::lastSuccessfulDiscoveryTime))
            .setter(setter(Builder::lastSuccessfulDiscoveryTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSuccessfulDiscoveryTime")
                    .unmarshallLocationName("lastSuccessfulDiscoveryTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            DISCOVERY_REGION_FIELD, FAILURE_REASON_FIELD, LAST_ATTEMPTED_DISCOVERY_TIME_FIELD,
            LAST_SUCCESSFUL_DISCOVERY_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("AccountId", ACCOUNT_ID_FIELD);
                    put("DiscoveryRegion", DISCOVERY_REGION_FIELD);
                    put("FailureReason", FAILURE_REASON_FIELD);
                    put("LastAttemptedDiscoveryTime", LAST_ATTEMPTED_DISCOVERY_TIME_FIELD);
                    put("LastSuccessfulDiscoveryTime", LAST_SUCCESSFUL_DISCOVERY_TIME_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String discoveryRegion;

    private final IpamDiscoveryFailureReason failureReason;

    private final Instant lastAttemptedDiscoveryTime;

    private final Instant lastSuccessfulDiscoveryTime;

    private IpamDiscoveredAccount(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.discoveryRegion = builder.discoveryRegion;
        this.failureReason = builder.failureReason;
        this.lastAttemptedDiscoveryTime = builder.lastAttemptedDiscoveryTime;
        this.lastSuccessfulDiscoveryTime = builder.lastSuccessfulDiscoveryTime;
    }

    /**
     * <p>
     * The account ID.
     * </p>
     * 
     * @return The account ID.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The Amazon Web Services Region that the account information is returned from. An account can be discovered in
     * multiple regions and will have a separate discovered account for each Region.
     * </p>
     * 
     * @return The Amazon Web Services Region that the account information is returned from. An account can be
     *         discovered in multiple regions and will have a separate discovered account for each Region.
     */
    public final String discoveryRegion() {
        return discoveryRegion;
    }

    /**
     * <p>
     * The resource discovery failure reason.
     * </p>
     * 
     * @return The resource discovery failure reason.
     */
    public final IpamDiscoveryFailureReason failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The last attempted resource discovery time.
     * </p>
     * 
     * @return The last attempted resource discovery time.
     */
    public final Instant lastAttemptedDiscoveryTime() {
        return lastAttemptedDiscoveryTime;
    }

    /**
     * <p>
     * The last successful resource discovery time.
     * </p>
     * 
     * @return The last successful resource discovery time.
     */
    public final Instant lastSuccessfulDiscoveryTime() {
        return lastSuccessfulDiscoveryTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(discoveryRegion());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(lastAttemptedDiscoveryTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastSuccessfulDiscoveryTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpamDiscoveredAccount)) {
            return false;
        }
        IpamDiscoveredAccount other = (IpamDiscoveredAccount) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(discoveryRegion(), other.discoveryRegion())
                && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(lastAttemptedDiscoveryTime(), other.lastAttemptedDiscoveryTime())
                && Objects.equals(lastSuccessfulDiscoveryTime(), other.lastSuccessfulDiscoveryTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IpamDiscoveredAccount").add("AccountId", accountId()).add("DiscoveryRegion", discoveryRegion())
                .add("FailureReason", failureReason()).add("LastAttemptedDiscoveryTime", lastAttemptedDiscoveryTime())
                .add("LastSuccessfulDiscoveryTime", lastSuccessfulDiscoveryTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "DiscoveryRegion":
            return Optional.ofNullable(clazz.cast(discoveryRegion()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "LastAttemptedDiscoveryTime":
            return Optional.ofNullable(clazz.cast(lastAttemptedDiscoveryTime()));
        case "LastSuccessfulDiscoveryTime":
            return Optional.ofNullable(clazz.cast(lastSuccessfulDiscoveryTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IpamDiscoveredAccount, T> g) {
        return obj -> g.apply((IpamDiscoveredAccount) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IpamDiscoveredAccount> {
        /**
         * <p>
         * The account ID.
         * </p>
         * 
         * @param accountId
         *        The account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The Amazon Web Services Region that the account information is returned from. An account can be discovered in
         * multiple regions and will have a separate discovered account for each Region.
         * </p>
         * 
         * @param discoveryRegion
         *        The Amazon Web Services Region that the account information is returned from. An account can be
         *        discovered in multiple regions and will have a separate discovered account for each Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder discoveryRegion(String discoveryRegion);

        /**
         * <p>
         * The resource discovery failure reason.
         * </p>
         * 
         * @param failureReason
         *        The resource discovery failure reason.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(IpamDiscoveryFailureReason failureReason);

        /**
         * <p>
         * The resource discovery failure reason.
         * </p>
         * This is a convenience method that creates an instance of the {@link IpamDiscoveryFailureReason.Builder}
         * avoiding the need to create one manually via {@link IpamDiscoveryFailureReason#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IpamDiscoveryFailureReason.Builder#build()} is called immediately
         * and its result is passed to {@link #failureReason(IpamDiscoveryFailureReason)}.
         * 
         * @param failureReason
         *        a consumer that will call methods on {@link IpamDiscoveryFailureReason.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failureReason(IpamDiscoveryFailureReason)
         */
        default Builder failureReason(Consumer<IpamDiscoveryFailureReason.Builder> failureReason) {
            return failureReason(IpamDiscoveryFailureReason.builder().applyMutation(failureReason).build());
        }

        /**
         * <p>
         * The last attempted resource discovery time.
         * </p>
         * 
         * @param lastAttemptedDiscoveryTime
         *        The last attempted resource discovery time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAttemptedDiscoveryTime(Instant lastAttemptedDiscoveryTime);

        /**
         * <p>
         * The last successful resource discovery time.
         * </p>
         * 
         * @param lastSuccessfulDiscoveryTime
         *        The last successful resource discovery time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSuccessfulDiscoveryTime(Instant lastSuccessfulDiscoveryTime);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String discoveryRegion;

        private IpamDiscoveryFailureReason failureReason;

        private Instant lastAttemptedDiscoveryTime;

        private Instant lastSuccessfulDiscoveryTime;

        private BuilderImpl() {
        }

        private BuilderImpl(IpamDiscoveredAccount model) {
            accountId(model.accountId);
            discoveryRegion(model.discoveryRegion);
            failureReason(model.failureReason);
            lastAttemptedDiscoveryTime(model.lastAttemptedDiscoveryTime);
            lastSuccessfulDiscoveryTime(model.lastSuccessfulDiscoveryTime);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getDiscoveryRegion() {
            return discoveryRegion;
        }

        public final void setDiscoveryRegion(String discoveryRegion) {
            this.discoveryRegion = discoveryRegion;
        }

        @Override
        public final Builder discoveryRegion(String discoveryRegion) {
            this.discoveryRegion = discoveryRegion;
            return this;
        }

        public final IpamDiscoveryFailureReason.Builder getFailureReason() {
            return failureReason != null ? failureReason.toBuilder() : null;
        }

        public final void setFailureReason(IpamDiscoveryFailureReason.BuilderImpl failureReason) {
            this.failureReason = failureReason != null ? failureReason.build() : null;
        }

        @Override
        public final Builder failureReason(IpamDiscoveryFailureReason failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final Instant getLastAttemptedDiscoveryTime() {
            return lastAttemptedDiscoveryTime;
        }

        public final void setLastAttemptedDiscoveryTime(Instant lastAttemptedDiscoveryTime) {
            this.lastAttemptedDiscoveryTime = lastAttemptedDiscoveryTime;
        }

        @Override
        public final Builder lastAttemptedDiscoveryTime(Instant lastAttemptedDiscoveryTime) {
            this.lastAttemptedDiscoveryTime = lastAttemptedDiscoveryTime;
            return this;
        }

        public final Instant getLastSuccessfulDiscoveryTime() {
            return lastSuccessfulDiscoveryTime;
        }

        public final void setLastSuccessfulDiscoveryTime(Instant lastSuccessfulDiscoveryTime) {
            this.lastSuccessfulDiscoveryTime = lastSuccessfulDiscoveryTime;
        }

        @Override
        public final Builder lastSuccessfulDiscoveryTime(Instant lastSuccessfulDiscoveryTime) {
            this.lastSuccessfulDiscoveryTime = lastSuccessfulDiscoveryTime;
            return this;
        }

        @Override
        public IpamDiscoveredAccount build() {
            return new IpamDiscoveredAccount(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
