/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <note>
 * <p>
 * This action is deprecated.
 * </p>
 * </note>
 * <p>
 * Describes the status of a moving Elastic IP address.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MovingAddressStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<MovingAddressStatus.Builder, MovingAddressStatus> {
    private static final SdkField<String> MOVE_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MoveStatus")
            .getter(getter(MovingAddressStatus::moveStatusAsString))
            .setter(setter(Builder::moveStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MoveStatus")
                    .unmarshallLocationName("moveStatus").build()).build();

    private static final SdkField<String> PUBLIC_IP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PublicIp")
            .getter(getter(MovingAddressStatus::publicIp))
            .setter(setter(Builder::publicIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIp")
                    .unmarshallLocationName("publicIp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MOVE_STATUS_FIELD,
            PUBLIC_IP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("MoveStatus", MOVE_STATUS_FIELD);
                    put("PublicIp", PUBLIC_IP_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String moveStatus;

    private final String publicIp;

    private MovingAddressStatus(BuilderImpl builder) {
        this.moveStatus = builder.moveStatus;
        this.publicIp = builder.publicIp;
    }

    /**
     * <p>
     * The status of the Elastic IP address that's being moved or restored.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #moveStatus} will
     * return {@link MoveStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #moveStatusAsString}.
     * </p>
     * 
     * @return The status of the Elastic IP address that's being moved or restored.
     * @see MoveStatus
     */
    public final MoveStatus moveStatus() {
        return MoveStatus.fromValue(moveStatus);
    }

    /**
     * <p>
     * The status of the Elastic IP address that's being moved or restored.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #moveStatus} will
     * return {@link MoveStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #moveStatusAsString}.
     * </p>
     * 
     * @return The status of the Elastic IP address that's being moved or restored.
     * @see MoveStatus
     */
    public final String moveStatusAsString() {
        return moveStatus;
    }

    /**
     * <p>
     * The Elastic IP address.
     * </p>
     * 
     * @return The Elastic IP address.
     */
    public final String publicIp() {
        return publicIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(moveStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(publicIp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MovingAddressStatus)) {
            return false;
        }
        MovingAddressStatus other = (MovingAddressStatus) obj;
        return Objects.equals(moveStatusAsString(), other.moveStatusAsString()) && Objects.equals(publicIp(), other.publicIp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MovingAddressStatus").add("MoveStatus", moveStatusAsString()).add("PublicIp", publicIp())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MoveStatus":
            return Optional.ofNullable(clazz.cast(moveStatusAsString()));
        case "PublicIp":
            return Optional.ofNullable(clazz.cast(publicIp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MovingAddressStatus, T> g) {
        return obj -> g.apply((MovingAddressStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MovingAddressStatus> {
        /**
         * <p>
         * The status of the Elastic IP address that's being moved or restored.
         * </p>
         * 
         * @param moveStatus
         *        The status of the Elastic IP address that's being moved or restored.
         * @see MoveStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MoveStatus
         */
        Builder moveStatus(String moveStatus);

        /**
         * <p>
         * The status of the Elastic IP address that's being moved or restored.
         * </p>
         * 
         * @param moveStatus
         *        The status of the Elastic IP address that's being moved or restored.
         * @see MoveStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MoveStatus
         */
        Builder moveStatus(MoveStatus moveStatus);

        /**
         * <p>
         * The Elastic IP address.
         * </p>
         * 
         * @param publicIp
         *        The Elastic IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIp(String publicIp);
    }

    static final class BuilderImpl implements Builder {
        private String moveStatus;

        private String publicIp;

        private BuilderImpl() {
        }

        private BuilderImpl(MovingAddressStatus model) {
            moveStatus(model.moveStatus);
            publicIp(model.publicIp);
        }

        public final String getMoveStatus() {
            return moveStatus;
        }

        public final void setMoveStatus(String moveStatus) {
            this.moveStatus = moveStatus;
        }

        @Override
        public final Builder moveStatus(String moveStatus) {
            this.moveStatus = moveStatus;
            return this;
        }

        @Override
        public final Builder moveStatus(MoveStatus moveStatus) {
            this.moveStatus(moveStatus == null ? null : moveStatus.toString());
            return this;
        }

        public final String getPublicIp() {
            return publicIp;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        @Override
        public MovingAddressStatus build() {
            return new MovingAddressStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
