/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the data that identifies an Amazon FPGA image (AFI) on the PCI bus.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PciId implements SdkPojo, Serializable, ToCopyableBuilder<PciId.Builder, PciId> {
    private static final SdkField<String> DEVICE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DeviceId")
            .getter(getter(PciId::deviceId))
            .setter(setter(Builder::deviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId")
                    .unmarshallLocationName("DeviceId").build()).build();

    private static final SdkField<String> VENDOR_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VendorId")
            .getter(getter(PciId::vendorId))
            .setter(setter(Builder::vendorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VendorId")
                    .unmarshallLocationName("VendorId").build()).build();

    private static final SdkField<String> SUBSYSTEM_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SubsystemId")
            .getter(getter(PciId::subsystemId))
            .setter(setter(Builder::subsystemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubsystemId")
                    .unmarshallLocationName("SubsystemId").build()).build();

    private static final SdkField<String> SUBSYSTEM_VENDOR_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SubsystemVendorId")
            .getter(getter(PciId::subsystemVendorId))
            .setter(setter(Builder::subsystemVendorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubsystemVendorId")
                    .unmarshallLocationName("SubsystemVendorId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_ID_FIELD,
            VENDOR_ID_FIELD, SUBSYSTEM_ID_FIELD, SUBSYSTEM_VENDOR_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("DeviceId", DEVICE_ID_FIELD);
                    put("VendorId", VENDOR_ID_FIELD);
                    put("SubsystemId", SUBSYSTEM_ID_FIELD);
                    put("SubsystemVendorId", SUBSYSTEM_VENDOR_ID_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String deviceId;

    private final String vendorId;

    private final String subsystemId;

    private final String subsystemVendorId;

    private PciId(BuilderImpl builder) {
        this.deviceId = builder.deviceId;
        this.vendorId = builder.vendorId;
        this.subsystemId = builder.subsystemId;
        this.subsystemVendorId = builder.subsystemVendorId;
    }

    /**
     * <p>
     * The ID of the device.
     * </p>
     * 
     * @return The ID of the device.
     */
    public final String deviceId() {
        return deviceId;
    }

    /**
     * <p>
     * The ID of the vendor.
     * </p>
     * 
     * @return The ID of the vendor.
     */
    public final String vendorId() {
        return vendorId;
    }

    /**
     * <p>
     * The ID of the subsystem.
     * </p>
     * 
     * @return The ID of the subsystem.
     */
    public final String subsystemId() {
        return subsystemId;
    }

    /**
     * <p>
     * The ID of the vendor for the subsystem.
     * </p>
     * 
     * @return The ID of the vendor for the subsystem.
     */
    public final String subsystemVendorId() {
        return subsystemVendorId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(vendorId());
        hashCode = 31 * hashCode + Objects.hashCode(subsystemId());
        hashCode = 31 * hashCode + Objects.hashCode(subsystemVendorId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PciId)) {
            return false;
        }
        PciId other = (PciId) obj;
        return Objects.equals(deviceId(), other.deviceId()) && Objects.equals(vendorId(), other.vendorId())
                && Objects.equals(subsystemId(), other.subsystemId())
                && Objects.equals(subsystemVendorId(), other.subsystemVendorId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PciId").add("DeviceId", deviceId()).add("VendorId", vendorId())
                .add("SubsystemId", subsystemId()).add("SubsystemVendorId", subsystemVendorId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceId":
            return Optional.ofNullable(clazz.cast(deviceId()));
        case "VendorId":
            return Optional.ofNullable(clazz.cast(vendorId()));
        case "SubsystemId":
            return Optional.ofNullable(clazz.cast(subsystemId()));
        case "SubsystemVendorId":
            return Optional.ofNullable(clazz.cast(subsystemVendorId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PciId, T> g) {
        return obj -> g.apply((PciId) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PciId> {
        /**
         * <p>
         * The ID of the device.
         * </p>
         * 
         * @param deviceId
         *        The ID of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceId(String deviceId);

        /**
         * <p>
         * The ID of the vendor.
         * </p>
         * 
         * @param vendorId
         *        The ID of the vendor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vendorId(String vendorId);

        /**
         * <p>
         * The ID of the subsystem.
         * </p>
         * 
         * @param subsystemId
         *        The ID of the subsystem.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subsystemId(String subsystemId);

        /**
         * <p>
         * The ID of the vendor for the subsystem.
         * </p>
         * 
         * @param subsystemVendorId
         *        The ID of the vendor for the subsystem.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subsystemVendorId(String subsystemVendorId);
    }

    static final class BuilderImpl implements Builder {
        private String deviceId;

        private String vendorId;

        private String subsystemId;

        private String subsystemVendorId;

        private BuilderImpl() {
        }

        private BuilderImpl(PciId model) {
            deviceId(model.deviceId);
            vendorId(model.vendorId);
            subsystemId(model.subsystemId);
            subsystemVendorId(model.subsystemVendorId);
        }

        public final String getDeviceId() {
            return deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final String getVendorId() {
            return vendorId;
        }

        public final void setVendorId(String vendorId) {
            this.vendorId = vendorId;
        }

        @Override
        public final Builder vendorId(String vendorId) {
            this.vendorId = vendorId;
            return this;
        }

        public final String getSubsystemId() {
            return subsystemId;
        }

        public final void setSubsystemId(String subsystemId) {
            this.subsystemId = subsystemId;
        }

        @Override
        public final Builder subsystemId(String subsystemId) {
            this.subsystemId = subsystemId;
            return this;
        }

        public final String getSubsystemVendorId() {
            return subsystemVendorId;
        }

        public final void setSubsystemVendorId(String subsystemVendorId) {
            this.subsystemVendorId = subsystemVendorId;
        }

        @Override
        public final Builder subsystemVendorId(String subsystemVendorId) {
            this.subsystemVendorId = subsystemVendorId;
            return this;
        }

        @Override
        public PciId build() {
            return new PciId(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
