/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Verified Access provides server side encryption by default to data at rest using Amazon Web Services-owned KMS keys.
 * You also have the option of using customer managed KMS keys, which can be specified using the options below.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VerifiedAccessSseSpecificationRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<VerifiedAccessSseSpecificationRequest.Builder, VerifiedAccessSseSpecificationRequest> {
    private static final SdkField<Boolean> CUSTOMER_MANAGED_KEY_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CustomerManagedKeyEnabled")
            .getter(getter(VerifiedAccessSseSpecificationRequest::customerManagedKeyEnabled))
            .setter(setter(Builder::customerManagedKeyEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerManagedKeyEnabled")
                    .unmarshallLocationName("CustomerManagedKeyEnabled").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyArn")
            .getter(getter(VerifiedAccessSseSpecificationRequest::kmsKeyArn))
            .setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn")
                    .unmarshallLocationName("KmsKeyArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CUSTOMER_MANAGED_KEY_ENABLED_FIELD, KMS_KEY_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("CustomerManagedKeyEnabled", CUSTOMER_MANAGED_KEY_ENABLED_FIELD);
                    put("KmsKeyArn", KMS_KEY_ARN_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Boolean customerManagedKeyEnabled;

    private final String kmsKeyArn;

    private VerifiedAccessSseSpecificationRequest(BuilderImpl builder) {
        this.customerManagedKeyEnabled = builder.customerManagedKeyEnabled;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    /**
     * <p>
     * Enable or disable the use of customer managed KMS keys for server side encryption.
     * </p>
     * <p>
     * Valid values: <code>True</code> | <code>False</code>
     * </p>
     * 
     * @return Enable or disable the use of customer managed KMS keys for server side encryption. </p>
     *         <p>
     *         Valid values: <code>True</code> | <code>False</code>
     */
    public final Boolean customerManagedKeyEnabled() {
        return customerManagedKeyEnabled;
    }

    /**
     * <p>
     * The ARN of the KMS key.
     * </p>
     * 
     * @return The ARN of the KMS key.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customerManagedKeyEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifiedAccessSseSpecificationRequest)) {
            return false;
        }
        VerifiedAccessSseSpecificationRequest other = (VerifiedAccessSseSpecificationRequest) obj;
        return Objects.equals(customerManagedKeyEnabled(), other.customerManagedKeyEnabled())
                && Objects.equals(kmsKeyArn(), other.kmsKeyArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VerifiedAccessSseSpecificationRequest")
                .add("CustomerManagedKeyEnabled", customerManagedKeyEnabled()).add("KmsKeyArn", kmsKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomerManagedKeyEnabled":
            return Optional.ofNullable(clazz.cast(customerManagedKeyEnabled()));
        case "KmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VerifiedAccessSseSpecificationRequest, T> g) {
        return obj -> g.apply((VerifiedAccessSseSpecificationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VerifiedAccessSseSpecificationRequest> {
        /**
         * <p>
         * Enable or disable the use of customer managed KMS keys for server side encryption.
         * </p>
         * <p>
         * Valid values: <code>True</code> | <code>False</code>
         * </p>
         * 
         * @param customerManagedKeyEnabled
         *        Enable or disable the use of customer managed KMS keys for server side encryption. </p>
         *        <p>
         *        Valid values: <code>True</code> | <code>False</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerManagedKeyEnabled(Boolean customerManagedKeyEnabled);

        /**
         * <p>
         * The ARN of the KMS key.
         * </p>
         * 
         * @param kmsKeyArn
         *        The ARN of the KMS key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);
    }

    static final class BuilderImpl implements Builder {
        private Boolean customerManagedKeyEnabled;

        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifiedAccessSseSpecificationRequest model) {
            customerManagedKeyEnabled(model.customerManagedKeyEnabled);
            kmsKeyArn(model.kmsKeyArn);
        }

        public final Boolean getCustomerManagedKeyEnabled() {
            return customerManagedKeyEnabled;
        }

        public final void setCustomerManagedKeyEnabled(Boolean customerManagedKeyEnabled) {
            this.customerManagedKeyEnabled = customerManagedKeyEnabled;
        }

        @Override
        public final Builder customerManagedKeyEnabled(Boolean customerManagedKeyEnabled) {
            this.customerManagedKeyEnabled = customerManagedKeyEnabled;
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        @Override
        public VerifiedAccessSseSpecificationRequest build() {
            return new VerifiedAccessSseSpecificationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
