/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateVersion;
import software.amazon.awssdk.services.ec2.model.ValidationWarning;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLaunchTemplateVersionResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, CreateLaunchTemplateVersionResponse> {
    private static final SdkField<LaunchTemplateVersion> LAUNCH_TEMPLATE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LaunchTemplateVersion").getter(CreateLaunchTemplateVersionResponse.getter(CreateLaunchTemplateVersionResponse::launchTemplateVersion)).setter(CreateLaunchTemplateVersionResponse.setter(Builder::launchTemplateVersion)).constructor(LaunchTemplateVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateVersion").unmarshallLocationName("launchTemplateVersion").build()}).build();
    private static final SdkField<ValidationWarning> WARNING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Warning").getter(CreateLaunchTemplateVersionResponse.getter(CreateLaunchTemplateVersionResponse::warning)).setter(CreateLaunchTemplateVersionResponse.setter(Builder::warning)).constructor(ValidationWarning::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Warning").unmarshallLocationName("warning").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_TEMPLATE_VERSION_FIELD, WARNING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("LaunchTemplateVersion", LAUNCH_TEMPLATE_VERSION_FIELD);
            this.put("Warning", WARNING_FIELD);
        }
    });
    private final LaunchTemplateVersion launchTemplateVersion;
    private final ValidationWarning warning;

    private CreateLaunchTemplateVersionResponse(BuilderImpl builder) {
        super(builder);
        this.launchTemplateVersion = builder.launchTemplateVersion;
        this.warning = builder.warning;
    }

    public final LaunchTemplateVersion launchTemplateVersion() {
        return this.launchTemplateVersion;
    }

    public final ValidationWarning warning() {
        return this.warning;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplateVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.warning());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLaunchTemplateVersionResponse)) {
            return false;
        }
        CreateLaunchTemplateVersionResponse other = (CreateLaunchTemplateVersionResponse)((Object)obj);
        return Objects.equals(this.launchTemplateVersion(), other.launchTemplateVersion()) && Objects.equals(this.warning(), other.warning());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLaunchTemplateVersionResponse").add("LaunchTemplateVersion", (Object)this.launchTemplateVersion()).add("Warning", (Object)this.warning()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LaunchTemplateVersion": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateVersion()));
            }
            case "Warning": {
                return Optional.ofNullable(clazz.cast(this.warning()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateLaunchTemplateVersionResponse, T> g) {
        return obj -> g.apply((CreateLaunchTemplateVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private LaunchTemplateVersion launchTemplateVersion;
        private ValidationWarning warning;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLaunchTemplateVersionResponse model) {
            super(model);
            this.launchTemplateVersion(model.launchTemplateVersion);
            this.warning(model.warning);
        }

        public final LaunchTemplateVersion.Builder getLaunchTemplateVersion() {
            return this.launchTemplateVersion != null ? this.launchTemplateVersion.toBuilder() : null;
        }

        public final void setLaunchTemplateVersion(LaunchTemplateVersion.BuilderImpl launchTemplateVersion) {
            this.launchTemplateVersion = launchTemplateVersion != null ? launchTemplateVersion.build() : null;
        }

        @Override
        public final Builder launchTemplateVersion(LaunchTemplateVersion launchTemplateVersion) {
            this.launchTemplateVersion = launchTemplateVersion;
            return this;
        }

        public final ValidationWarning.Builder getWarning() {
            return this.warning != null ? this.warning.toBuilder() : null;
        }

        public final void setWarning(ValidationWarning.BuilderImpl warning) {
            this.warning = warning != null ? warning.build() : null;
        }

        @Override
        public final Builder warning(ValidationWarning warning) {
            this.warning = warning;
            return this;
        }

        @Override
        public CreateLaunchTemplateVersionResponse build() {
            return new CreateLaunchTemplateVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLaunchTemplateVersionResponse> {
        public Builder launchTemplateVersion(LaunchTemplateVersion var1);

        default public Builder launchTemplateVersion(Consumer<LaunchTemplateVersion.Builder> launchTemplateVersion) {
            return this.launchTemplateVersion((LaunchTemplateVersion)((LaunchTemplateVersion.Builder)LaunchTemplateVersion.builder().applyMutation(launchTemplateVersion)).build());
        }

        public Builder warning(ValidationWarning var1);

        default public Builder warning(Consumer<ValidationWarning.Builder> warning) {
            return this.warning((ValidationWarning)((ValidationWarning.Builder)ValidationWarning.builder().applyMutation(warning)).build());
        }
    }
}

