/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthorizeSecurityGroupEgressRequest extends Ec2Request implements
        ToCopyableBuilder<AuthorizeSecurityGroupEgressRequest.Builder, AuthorizeSecurityGroupEgressRequest> {
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(AuthorizeSecurityGroupEgressRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(AuthorizeSecurityGroupEgressRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("dryRun").build()).build();

    private static final SdkField<String> GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupId")
            .getter(getter(AuthorizeSecurityGroupEgressRequest::groupId))
            .setter(setter(Builder::groupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId")
                    .unmarshallLocationName("groupId").build()).build();

    private static final SdkField<String> SOURCE_SECURITY_GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceSecurityGroupName")
            .getter(getter(AuthorizeSecurityGroupEgressRequest::sourceSecurityGroupName))
            .setter(setter(Builder::sourceSecurityGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceSecurityGroupName")
                    .unmarshallLocationName("sourceSecurityGroupName").build()).build();

    private static final SdkField<String> SOURCE_SECURITY_GROUP_OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceSecurityGroupOwnerId")
            .getter(getter(AuthorizeSecurityGroupEgressRequest::sourceSecurityGroupOwnerId))
            .setter(setter(Builder::sourceSecurityGroupOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceSecurityGroupOwnerId")
                    .unmarshallLocationName("sourceSecurityGroupOwnerId").build()).build();

    private static final SdkField<String> IP_PROTOCOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpProtocol")
            .getter(getter(AuthorizeSecurityGroupEgressRequest::ipProtocol))
            .setter(setter(Builder::ipProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpProtocol")
                    .unmarshallLocationName("ipProtocol").build()).build();

    private static final SdkField<Integer> FROM_PORT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("FromPort")
            .getter(getter(AuthorizeSecurityGroupEgressRequest::fromPort))
            .setter(setter(Builder::fromPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromPort")
                    .unmarshallLocationName("fromPort").build()).build();

    private static final SdkField<Integer> TO_PORT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("ToPort")
            .getter(getter(AuthorizeSecurityGroupEgressRequest::toPort))
            .setter(setter(Builder::toPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToPort")
                    .unmarshallLocationName("toPort").build()).build();

    private static final SdkField<String> CIDR_IP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CidrIp")
            .getter(getter(AuthorizeSecurityGroupEgressRequest::cidrIp))
            .setter(setter(Builder::cidrIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrIp")
                    .unmarshallLocationName("cidrIp").build()).build();

    private static final SdkField<List<IpPermission>> IP_PERMISSIONS_FIELD = SdkField
            .<List<IpPermission>> builder(MarshallingType.LIST)
            .memberName("IpPermissions")
            .getter(getter(AuthorizeSecurityGroupEgressRequest::ipPermissions))
            .setter(setter(Builder::ipPermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpPermissions")
                    .unmarshallLocationName("ipPermissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<IpPermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpPermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAG_SPECIFICATIONS_FIELD,
            DRY_RUN_FIELD, GROUP_ID_FIELD, SOURCE_SECURITY_GROUP_NAME_FIELD, SOURCE_SECURITY_GROUP_OWNER_ID_FIELD,
            IP_PROTOCOL_FIELD, FROM_PORT_FIELD, TO_PORT_FIELD, CIDR_IP_FIELD, IP_PERMISSIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
                    put("DryRun", DRY_RUN_FIELD);
                    put("GroupId", GROUP_ID_FIELD);
                    put("SourceSecurityGroupName", SOURCE_SECURITY_GROUP_NAME_FIELD);
                    put("SourceSecurityGroupOwnerId", SOURCE_SECURITY_GROUP_OWNER_ID_FIELD);
                    put("IpProtocol", IP_PROTOCOL_FIELD);
                    put("FromPort", FROM_PORT_FIELD);
                    put("ToPort", TO_PORT_FIELD);
                    put("CidrIp", CIDR_IP_FIELD);
                    put("IpPermissions", IP_PERMISSIONS_FIELD);
                }
            });

    private final List<TagSpecification> tagSpecifications;

    private final Boolean dryRun;

    private final String groupId;

    private final String sourceSecurityGroupName;

    private final String sourceSecurityGroupOwnerId;

    private final String ipProtocol;

    private final Integer fromPort;

    private final Integer toPort;

    private final String cidrIp;

    private final List<IpPermission> ipPermissions;

    private AuthorizeSecurityGroupEgressRequest(BuilderImpl builder) {
        super(builder);
        this.tagSpecifications = builder.tagSpecifications;
        this.dryRun = builder.dryRun;
        this.groupId = builder.groupId;
        this.sourceSecurityGroupName = builder.sourceSecurityGroupName;
        this.sourceSecurityGroupOwnerId = builder.sourceSecurityGroupOwnerId;
        this.ipProtocol = builder.ipProtocol;
        this.fromPort = builder.fromPort;
        this.toPort = builder.toPort;
        this.cidrIp = builder.cidrIp;
        this.ipPermissions = builder.ipPermissions;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagSpecifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags applied to the security group rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagSpecifications} method.
     * </p>
     * 
     * @return The tags applied to the security group rule.
     */
    public final List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The ID of the security group.
     * </p>
     * 
     * @return The ID of the security group.
     */
    public final String groupId() {
        return groupId;
    }

    /**
     * <p>
     * Not supported. Use IP permissions instead.
     * </p>
     * 
     * @return Not supported. Use IP permissions instead.
     */
    public final String sourceSecurityGroupName() {
        return sourceSecurityGroupName;
    }

    /**
     * <p>
     * Not supported. Use IP permissions instead.
     * </p>
     * 
     * @return Not supported. Use IP permissions instead.
     */
    public final String sourceSecurityGroupOwnerId() {
        return sourceSecurityGroupOwnerId;
    }

    /**
     * <p>
     * Not supported. Use IP permissions instead.
     * </p>
     * 
     * @return Not supported. Use IP permissions instead.
     */
    public final String ipProtocol() {
        return ipProtocol;
    }

    /**
     * <p>
     * Not supported. Use IP permissions instead.
     * </p>
     * 
     * @return Not supported. Use IP permissions instead.
     */
    public final Integer fromPort() {
        return fromPort;
    }

    /**
     * <p>
     * Not supported. Use IP permissions instead.
     * </p>
     * 
     * @return Not supported. Use IP permissions instead.
     */
    public final Integer toPort() {
        return toPort;
    }

    /**
     * <p>
     * Not supported. Use IP permissions instead.
     * </p>
     * 
     * @return Not supported. Use IP permissions instead.
     */
    public final String cidrIp() {
        return cidrIp;
    }

    /**
     * For responses, this returns true if the service returned a value for the IpPermissions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpPermissions() {
        return ipPermissions != null && !(ipPermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The permissions for the security group rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpPermissions} method.
     * </p>
     * 
     * @return The permissions for the security group rules.
     */
    public final List<IpPermission> ipPermissions() {
        return ipPermissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceSecurityGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceSecurityGroupOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(ipProtocol());
        hashCode = 31 * hashCode + Objects.hashCode(fromPort());
        hashCode = 31 * hashCode + Objects.hashCode(toPort());
        hashCode = 31 * hashCode + Objects.hashCode(cidrIp());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpPermissions() ? ipPermissions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizeSecurityGroupEgressRequest)) {
            return false;
        }
        AuthorizeSecurityGroupEgressRequest other = (AuthorizeSecurityGroupEgressRequest) obj;
        return hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications()) && Objects.equals(dryRun(), other.dryRun())
                && Objects.equals(groupId(), other.groupId())
                && Objects.equals(sourceSecurityGroupName(), other.sourceSecurityGroupName())
                && Objects.equals(sourceSecurityGroupOwnerId(), other.sourceSecurityGroupOwnerId())
                && Objects.equals(ipProtocol(), other.ipProtocol()) && Objects.equals(fromPort(), other.fromPort())
                && Objects.equals(toPort(), other.toPort()) && Objects.equals(cidrIp(), other.cidrIp())
                && hasIpPermissions() == other.hasIpPermissions() && Objects.equals(ipPermissions(), other.ipPermissions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuthorizeSecurityGroupEgressRequest")
                .add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null).add("DryRun", dryRun())
                .add("GroupId", groupId()).add("SourceSecurityGroupName", sourceSecurityGroupName())
                .add("SourceSecurityGroupOwnerId", sourceSecurityGroupOwnerId()).add("IpProtocol", ipProtocol())
                .add("FromPort", fromPort()).add("ToPort", toPort()).add("CidrIp", cidrIp())
                .add("IpPermissions", hasIpPermissions() ? ipPermissions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "GroupId":
            return Optional.ofNullable(clazz.cast(groupId()));
        case "SourceSecurityGroupName":
            return Optional.ofNullable(clazz.cast(sourceSecurityGroupName()));
        case "SourceSecurityGroupOwnerId":
            return Optional.ofNullable(clazz.cast(sourceSecurityGroupOwnerId()));
        case "IpProtocol":
            return Optional.ofNullable(clazz.cast(ipProtocol()));
        case "FromPort":
            return Optional.ofNullable(clazz.cast(fromPort()));
        case "ToPort":
            return Optional.ofNullable(clazz.cast(toPort()));
        case "CidrIp":
            return Optional.ofNullable(clazz.cast(cidrIp()));
        case "IpPermissions":
            return Optional.ofNullable(clazz.cast(ipPermissions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AuthorizeSecurityGroupEgressRequest, T> g) {
        return obj -> g.apply((AuthorizeSecurityGroupEgressRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, AuthorizeSecurityGroupEgressRequest> {
        /**
         * <p>
         * The tags applied to the security group rule.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags applied to the security group rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags applied to the security group rule.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags applied to the security group rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags applied to the security group rule.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.TagSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(java.util.Collection<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The ID of the security group.
         * </p>
         * 
         * @param groupId
         *        The ID of the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * Not supported. Use IP permissions instead.
         * </p>
         * 
         * @param sourceSecurityGroupName
         *        Not supported. Use IP permissions instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceSecurityGroupName(String sourceSecurityGroupName);

        /**
         * <p>
         * Not supported. Use IP permissions instead.
         * </p>
         * 
         * @param sourceSecurityGroupOwnerId
         *        Not supported. Use IP permissions instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceSecurityGroupOwnerId(String sourceSecurityGroupOwnerId);

        /**
         * <p>
         * Not supported. Use IP permissions instead.
         * </p>
         * 
         * @param ipProtocol
         *        Not supported. Use IP permissions instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipProtocol(String ipProtocol);

        /**
         * <p>
         * Not supported. Use IP permissions instead.
         * </p>
         * 
         * @param fromPort
         *        Not supported. Use IP permissions instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromPort(Integer fromPort);

        /**
         * <p>
         * Not supported. Use IP permissions instead.
         * </p>
         * 
         * @param toPort
         *        Not supported. Use IP permissions instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toPort(Integer toPort);

        /**
         * <p>
         * Not supported. Use IP permissions instead.
         * </p>
         * 
         * @param cidrIp
         *        Not supported. Use IP permissions instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrIp(String cidrIp);

        /**
         * <p>
         * The permissions for the security group rules.
         * </p>
         * 
         * @param ipPermissions
         *        The permissions for the security group rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipPermissions(Collection<IpPermission> ipPermissions);

        /**
         * <p>
         * The permissions for the security group rules.
         * </p>
         * 
         * @param ipPermissions
         *        The permissions for the security group rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipPermissions(IpPermission... ipPermissions);

        /**
         * <p>
         * The permissions for the security group rules.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.IpPermission.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.IpPermission#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.IpPermission.Builder#build()} is called immediately and its
         * result is passed to {@link #ipPermissions(List<IpPermission>)}.
         * 
         * @param ipPermissions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.IpPermission.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipPermissions(java.util.Collection<IpPermission>)
         */
        Builder ipPermissions(Consumer<IpPermission.Builder>... ipPermissions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private Boolean dryRun;

        private String groupId;

        private String sourceSecurityGroupName;

        private String sourceSecurityGroupOwnerId;

        private String ipProtocol;

        private Integer fromPort;

        private Integer toPort;

        private String cidrIp;

        private List<IpPermission> ipPermissions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizeSecurityGroupEgressRequest model) {
            super(model);
            tagSpecifications(model.tagSpecifications);
            dryRun(model.dryRun);
            groupId(model.groupId);
            sourceSecurityGroupName(model.sourceSecurityGroupName);
            sourceSecurityGroupOwnerId(model.sourceSecurityGroupOwnerId);
            ipProtocol(model.ipProtocol);
            fromPort(model.fromPort);
            toPort(model.toPort);
            cidrIp(model.cidrIp);
            ipPermissions(model.ipPermissions);
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getGroupId() {
            return groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final String getSourceSecurityGroupName() {
            return sourceSecurityGroupName;
        }

        public final void setSourceSecurityGroupName(String sourceSecurityGroupName) {
            this.sourceSecurityGroupName = sourceSecurityGroupName;
        }

        @Override
        public final Builder sourceSecurityGroupName(String sourceSecurityGroupName) {
            this.sourceSecurityGroupName = sourceSecurityGroupName;
            return this;
        }

        public final String getSourceSecurityGroupOwnerId() {
            return sourceSecurityGroupOwnerId;
        }

        public final void setSourceSecurityGroupOwnerId(String sourceSecurityGroupOwnerId) {
            this.sourceSecurityGroupOwnerId = sourceSecurityGroupOwnerId;
        }

        @Override
        public final Builder sourceSecurityGroupOwnerId(String sourceSecurityGroupOwnerId) {
            this.sourceSecurityGroupOwnerId = sourceSecurityGroupOwnerId;
            return this;
        }

        public final String getIpProtocol() {
            return ipProtocol;
        }

        public final void setIpProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
        }

        @Override
        public final Builder ipProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
            return this;
        }

        public final Integer getFromPort() {
            return fromPort;
        }

        public final void setFromPort(Integer fromPort) {
            this.fromPort = fromPort;
        }

        @Override
        public final Builder fromPort(Integer fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public final Integer getToPort() {
            return toPort;
        }

        public final void setToPort(Integer toPort) {
            this.toPort = toPort;
        }

        @Override
        public final Builder toPort(Integer toPort) {
            this.toPort = toPort;
            return this;
        }

        public final String getCidrIp() {
            return cidrIp;
        }

        public final void setCidrIp(String cidrIp) {
            this.cidrIp = cidrIp;
        }

        @Override
        public final Builder cidrIp(String cidrIp) {
            this.cidrIp = cidrIp;
            return this;
        }

        public final List<IpPermission.Builder> getIpPermissions() {
            List<IpPermission.Builder> result = IpPermissionListCopier.copyToBuilder(this.ipPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpPermissions(Collection<IpPermission.BuilderImpl> ipPermissions) {
            this.ipPermissions = IpPermissionListCopier.copyFromBuilder(ipPermissions);
        }

        @Override
        public final Builder ipPermissions(Collection<IpPermission> ipPermissions) {
            this.ipPermissions = IpPermissionListCopier.copy(ipPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissions(IpPermission... ipPermissions) {
            ipPermissions(Arrays.asList(ipPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissions(Consumer<IpPermission.Builder>... ipPermissions) {
            ipPermissions(Stream.of(ipPermissions).map(c -> IpPermission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AuthorizeSecurityGroupEgressRequest build() {
            return new AuthorizeSecurityGroupEgressRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
