/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTransitGatewayConnectPeerRequest extends Ec2Request implements
        ToCopyableBuilder<CreateTransitGatewayConnectPeerRequest.Builder, CreateTransitGatewayConnectPeerRequest> {
    private static final SdkField<String> TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayAttachmentId")
            .getter(getter(CreateTransitGatewayConnectPeerRequest::transitGatewayAttachmentId))
            .setter(setter(Builder::transitGatewayAttachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAttachmentId")
                    .unmarshallLocationName("TransitGatewayAttachmentId").build()).build();

    private static final SdkField<String> TRANSIT_GATEWAY_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayAddress")
            .getter(getter(CreateTransitGatewayConnectPeerRequest::transitGatewayAddress))
            .setter(setter(Builder::transitGatewayAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAddress")
                    .unmarshallLocationName("TransitGatewayAddress").build()).build();

    private static final SdkField<String> PEER_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PeerAddress")
            .getter(getter(CreateTransitGatewayConnectPeerRequest::peerAddress))
            .setter(setter(Builder::peerAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerAddress")
                    .unmarshallLocationName("PeerAddress").build()).build();

    private static final SdkField<TransitGatewayConnectRequestBgpOptions> BGP_OPTIONS_FIELD = SdkField
            .<TransitGatewayConnectRequestBgpOptions> builder(MarshallingType.SDK_POJO)
            .memberName("BgpOptions")
            .getter(getter(CreateTransitGatewayConnectPeerRequest::bgpOptions))
            .setter(setter(Builder::bgpOptions))
            .constructor(TransitGatewayConnectRequestBgpOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BgpOptions")
                    .unmarshallLocationName("BgpOptions").build()).build();

    private static final SdkField<List<String>> INSIDE_CIDR_BLOCKS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InsideCidrBlocks")
            .getter(getter(CreateTransitGatewayConnectPeerRequest::insideCidrBlocks))
            .setter(setter(Builder::insideCidrBlocks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsideCidrBlocks")
                    .unmarshallLocationName("InsideCidrBlocks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(CreateTransitGatewayConnectPeerRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(CreateTransitGatewayConnectPeerRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD, TRANSIT_GATEWAY_ADDRESS_FIELD, PEER_ADDRESS_FIELD, BGP_OPTIONS_FIELD,
            INSIDE_CIDR_BLOCKS_FIELD, TAG_SPECIFICATIONS_FIELD, DRY_RUN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("TransitGatewayAttachmentId", TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD);
                    put("TransitGatewayAddress", TRANSIT_GATEWAY_ADDRESS_FIELD);
                    put("PeerAddress", PEER_ADDRESS_FIELD);
                    put("BgpOptions", BGP_OPTIONS_FIELD);
                    put("InsideCidrBlocks", INSIDE_CIDR_BLOCKS_FIELD);
                    put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
                    put("DryRun", DRY_RUN_FIELD);
                }
            });

    private final String transitGatewayAttachmentId;

    private final String transitGatewayAddress;

    private final String peerAddress;

    private final TransitGatewayConnectRequestBgpOptions bgpOptions;

    private final List<String> insideCidrBlocks;

    private final List<TagSpecification> tagSpecifications;

    private final Boolean dryRun;

    private CreateTransitGatewayConnectPeerRequest(BuilderImpl builder) {
        super(builder);
        this.transitGatewayAttachmentId = builder.transitGatewayAttachmentId;
        this.transitGatewayAddress = builder.transitGatewayAddress;
        this.peerAddress = builder.peerAddress;
        this.bgpOptions = builder.bgpOptions;
        this.insideCidrBlocks = builder.insideCidrBlocks;
        this.tagSpecifications = builder.tagSpecifications;
        this.dryRun = builder.dryRun;
    }

    /**
     * <p>
     * The ID of the Connect attachment.
     * </p>
     * 
     * @return The ID of the Connect attachment.
     */
    public final String transitGatewayAttachmentId() {
        return transitGatewayAttachmentId;
    }

    /**
     * <p>
     * The peer IP address (GRE outer IP address) on the transit gateway side of the Connect peer, which must be
     * specified from a transit gateway CIDR block. If not specified, Amazon automatically assigns the first available
     * IP address from the transit gateway CIDR block.
     * </p>
     * 
     * @return The peer IP address (GRE outer IP address) on the transit gateway side of the Connect peer, which must be
     *         specified from a transit gateway CIDR block. If not specified, Amazon automatically assigns the first
     *         available IP address from the transit gateway CIDR block.
     */
    public final String transitGatewayAddress() {
        return transitGatewayAddress;
    }

    /**
     * <p>
     * The peer IP address (GRE outer IP address) on the appliance side of the Connect peer.
     * </p>
     * 
     * @return The peer IP address (GRE outer IP address) on the appliance side of the Connect peer.
     */
    public final String peerAddress() {
        return peerAddress;
    }

    /**
     * <p>
     * The BGP options for the Connect peer.
     * </p>
     * 
     * @return The BGP options for the Connect peer.
     */
    public final TransitGatewayConnectRequestBgpOptions bgpOptions() {
        return bgpOptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the InsideCidrBlocks property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInsideCidrBlocks() {
        return insideCidrBlocks != null && !(insideCidrBlocks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The range of inside IP addresses that are used for BGP peering. You must specify a size /29 IPv4 CIDR block from
     * the <code>169.254.0.0/16</code> range. The first address from the range must be configured on the appliance as
     * the BGP IP address. You can also optionally specify a size /125 IPv6 CIDR block from the <code>fd00::/8</code>
     * range.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInsideCidrBlocks} method.
     * </p>
     * 
     * @return The range of inside IP addresses that are used for BGP peering. You must specify a size /29 IPv4 CIDR
     *         block from the <code>169.254.0.0/16</code> range. The first address from the range must be configured on
     *         the appliance as the BGP IP address. You can also optionally specify a size /125 IPv6 CIDR block from the
     *         <code>fd00::/8</code> range.
     */
    public final List<String> insideCidrBlocks() {
        return insideCidrBlocks;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagSpecifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to apply to the Connect peer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagSpecifications} method.
     * </p>
     * 
     * @return The tags to apply to the Connect peer.
     */
    public final List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayAddress());
        hashCode = 31 * hashCode + Objects.hashCode(peerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(bgpOptions());
        hashCode = 31 * hashCode + Objects.hashCode(hasInsideCidrBlocks() ? insideCidrBlocks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTransitGatewayConnectPeerRequest)) {
            return false;
        }
        CreateTransitGatewayConnectPeerRequest other = (CreateTransitGatewayConnectPeerRequest) obj;
        return Objects.equals(transitGatewayAttachmentId(), other.transitGatewayAttachmentId())
                && Objects.equals(transitGatewayAddress(), other.transitGatewayAddress())
                && Objects.equals(peerAddress(), other.peerAddress()) && Objects.equals(bgpOptions(), other.bgpOptions())
                && hasInsideCidrBlocks() == other.hasInsideCidrBlocks()
                && Objects.equals(insideCidrBlocks(), other.insideCidrBlocks())
                && hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications()) && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTransitGatewayConnectPeerRequest")
                .add("TransitGatewayAttachmentId", transitGatewayAttachmentId())
                .add("TransitGatewayAddress", transitGatewayAddress()).add("PeerAddress", peerAddress())
                .add("BgpOptions", bgpOptions()).add("InsideCidrBlocks", hasInsideCidrBlocks() ? insideCidrBlocks() : null)
                .add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null).add("DryRun", dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayAttachmentId":
            return Optional.ofNullable(clazz.cast(transitGatewayAttachmentId()));
        case "TransitGatewayAddress":
            return Optional.ofNullable(clazz.cast(transitGatewayAddress()));
        case "PeerAddress":
            return Optional.ofNullable(clazz.cast(peerAddress()));
        case "BgpOptions":
            return Optional.ofNullable(clazz.cast(bgpOptions()));
        case "InsideCidrBlocks":
            return Optional.ofNullable(clazz.cast(insideCidrBlocks()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateTransitGatewayConnectPeerRequest, T> g) {
        return obj -> g.apply((CreateTransitGatewayConnectPeerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateTransitGatewayConnectPeerRequest> {
        /**
         * <p>
         * The ID of the Connect attachment.
         * </p>
         * 
         * @param transitGatewayAttachmentId
         *        The ID of the Connect attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayAttachmentId(String transitGatewayAttachmentId);

        /**
         * <p>
         * The peer IP address (GRE outer IP address) on the transit gateway side of the Connect peer, which must be
         * specified from a transit gateway CIDR block. If not specified, Amazon automatically assigns the first
         * available IP address from the transit gateway CIDR block.
         * </p>
         * 
         * @param transitGatewayAddress
         *        The peer IP address (GRE outer IP address) on the transit gateway side of the Connect peer, which must
         *        be specified from a transit gateway CIDR block. If not specified, Amazon automatically assigns the
         *        first available IP address from the transit gateway CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayAddress(String transitGatewayAddress);

        /**
         * <p>
         * The peer IP address (GRE outer IP address) on the appliance side of the Connect peer.
         * </p>
         * 
         * @param peerAddress
         *        The peer IP address (GRE outer IP address) on the appliance side of the Connect peer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerAddress(String peerAddress);

        /**
         * <p>
         * The BGP options for the Connect peer.
         * </p>
         * 
         * @param bgpOptions
         *        The BGP options for the Connect peer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bgpOptions(TransitGatewayConnectRequestBgpOptions bgpOptions);

        /**
         * <p>
         * The BGP options for the Connect peer.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link TransitGatewayConnectRequestBgpOptions.Builder} avoiding the need to create one manually via
         * {@link TransitGatewayConnectRequestBgpOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TransitGatewayConnectRequestBgpOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #bgpOptions(TransitGatewayConnectRequestBgpOptions)}.
         * 
         * @param bgpOptions
         *        a consumer that will call methods on {@link TransitGatewayConnectRequestBgpOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bgpOptions(TransitGatewayConnectRequestBgpOptions)
         */
        default Builder bgpOptions(Consumer<TransitGatewayConnectRequestBgpOptions.Builder> bgpOptions) {
            return bgpOptions(TransitGatewayConnectRequestBgpOptions.builder().applyMutation(bgpOptions).build());
        }

        /**
         * <p>
         * The range of inside IP addresses that are used for BGP peering. You must specify a size /29 IPv4 CIDR block
         * from the <code>169.254.0.0/16</code> range. The first address from the range must be configured on the
         * appliance as the BGP IP address. You can also optionally specify a size /125 IPv6 CIDR block from the
         * <code>fd00::/8</code> range.
         * </p>
         * 
         * @param insideCidrBlocks
         *        The range of inside IP addresses that are used for BGP peering. You must specify a size /29 IPv4 CIDR
         *        block from the <code>169.254.0.0/16</code> range. The first address from the range must be configured
         *        on the appliance as the BGP IP address. You can also optionally specify a size /125 IPv6 CIDR block
         *        from the <code>fd00::/8</code> range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insideCidrBlocks(Collection<String> insideCidrBlocks);

        /**
         * <p>
         * The range of inside IP addresses that are used for BGP peering. You must specify a size /29 IPv4 CIDR block
         * from the <code>169.254.0.0/16</code> range. The first address from the range must be configured on the
         * appliance as the BGP IP address. You can also optionally specify a size /125 IPv6 CIDR block from the
         * <code>fd00::/8</code> range.
         * </p>
         * 
         * @param insideCidrBlocks
         *        The range of inside IP addresses that are used for BGP peering. You must specify a size /29 IPv4 CIDR
         *        block from the <code>169.254.0.0/16</code> range. The first address from the range must be configured
         *        on the appliance as the BGP IP address. You can also optionally specify a size /125 IPv6 CIDR block
         *        from the <code>fd00::/8</code> range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insideCidrBlocks(String... insideCidrBlocks);

        /**
         * <p>
         * The tags to apply to the Connect peer.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the Connect peer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to apply to the Connect peer.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the Connect peer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to apply to the Connect peer.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.TagSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(java.util.Collection<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String transitGatewayAttachmentId;

        private String transitGatewayAddress;

        private String peerAddress;

        private TransitGatewayConnectRequestBgpOptions bgpOptions;

        private List<String> insideCidrBlocks = DefaultSdkAutoConstructList.getInstance();

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTransitGatewayConnectPeerRequest model) {
            super(model);
            transitGatewayAttachmentId(model.transitGatewayAttachmentId);
            transitGatewayAddress(model.transitGatewayAddress);
            peerAddress(model.peerAddress);
            bgpOptions(model.bgpOptions);
            insideCidrBlocks(model.insideCidrBlocks);
            tagSpecifications(model.tagSpecifications);
            dryRun(model.dryRun);
        }

        public final String getTransitGatewayAttachmentId() {
            return transitGatewayAttachmentId;
        }

        public final void setTransitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
        }

        @Override
        public final Builder transitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
            return this;
        }

        public final String getTransitGatewayAddress() {
            return transitGatewayAddress;
        }

        public final void setTransitGatewayAddress(String transitGatewayAddress) {
            this.transitGatewayAddress = transitGatewayAddress;
        }

        @Override
        public final Builder transitGatewayAddress(String transitGatewayAddress) {
            this.transitGatewayAddress = transitGatewayAddress;
            return this;
        }

        public final String getPeerAddress() {
            return peerAddress;
        }

        public final void setPeerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
        }

        @Override
        public final Builder peerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
            return this;
        }

        public final TransitGatewayConnectRequestBgpOptions.Builder getBgpOptions() {
            return bgpOptions != null ? bgpOptions.toBuilder() : null;
        }

        public final void setBgpOptions(TransitGatewayConnectRequestBgpOptions.BuilderImpl bgpOptions) {
            this.bgpOptions = bgpOptions != null ? bgpOptions.build() : null;
        }

        @Override
        public final Builder bgpOptions(TransitGatewayConnectRequestBgpOptions bgpOptions) {
            this.bgpOptions = bgpOptions;
            return this;
        }

        public final Collection<String> getInsideCidrBlocks() {
            if (insideCidrBlocks instanceof SdkAutoConstructList) {
                return null;
            }
            return insideCidrBlocks;
        }

        public final void setInsideCidrBlocks(Collection<String> insideCidrBlocks) {
            this.insideCidrBlocks = InsideCidrBlocksStringListCopier.copy(insideCidrBlocks);
        }

        @Override
        public final Builder insideCidrBlocks(Collection<String> insideCidrBlocks) {
            this.insideCidrBlocks = InsideCidrBlocksStringListCopier.copy(insideCidrBlocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insideCidrBlocks(String... insideCidrBlocks) {
            insideCidrBlocks(Arrays.asList(insideCidrBlocks));
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTransitGatewayConnectPeerRequest build() {
            return new CreateTransitGatewayConnectPeerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
