/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The discovery failure reason.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IpamDiscoveryFailureReason implements SdkPojo, Serializable,
        ToCopyableBuilder<IpamDiscoveryFailureReason.Builder, IpamDiscoveryFailureReason> {
    private static final SdkField<String> CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Code")
            .getter(getter(IpamDiscoveryFailureReason::codeAsString))
            .setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code")
                    .unmarshallLocationName("code").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Message")
            .getter(getter(IpamDiscoveryFailureReason::message))
            .setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message")
                    .unmarshallLocationName("message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Code", CODE_FIELD);
                    put("Message", MESSAGE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String code;

    private final String message;

    private IpamDiscoveryFailureReason(BuilderImpl builder) {
        this.code = builder.code;
        this.message = builder.message;
    }

    /**
     * <p>
     * The discovery failure code.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>assume-role-failure</code> - IPAM could not assume the Amazon Web Services IAM service-linked role. This
     * could be because of any of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * SLR has not been created yet and IPAM is still creating it.
     * </p>
     * </li>
     * <li>
     * <p>
     * You have opted-out of the IPAM home Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * Account you are using as your IPAM account has been suspended.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>throttling-failure</code> - IPAM account is already using the allotted transactions per second and IPAM is
     * receiving a throttling error when assuming the Amazon Web Services IAM SLR.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>unauthorized-failure</code> - Amazon Web Services account making the request is not authorized. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html">AuthFailure</a> in the
     * <i>Amazon Elastic Compute Cloud API Reference</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link IpamDiscoveryFailureCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codeAsString}.
     * </p>
     * 
     * @return The discovery failure code.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>assume-role-failure</code> - IPAM could not assume the Amazon Web Services IAM service-linked role.
     *         This could be because of any of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         SLR has not been created yet and IPAM is still creating it.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have opted-out of the IPAM home Region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Account you are using as your IPAM account has been suspended.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>throttling-failure</code> - IPAM account is already using the allotted transactions per second and
     *         IPAM is receiving a throttling error when assuming the Amazon Web Services IAM SLR.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>unauthorized-failure</code> - Amazon Web Services account making the request is not authorized. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html">AuthFailure</a> in the
     *         <i>Amazon Elastic Compute Cloud API Reference</i>.
     *         </p>
     *         </li>
     * @see IpamDiscoveryFailureCode
     */
    public final IpamDiscoveryFailureCode code() {
        return IpamDiscoveryFailureCode.fromValue(code);
    }

    /**
     * <p>
     * The discovery failure code.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>assume-role-failure</code> - IPAM could not assume the Amazon Web Services IAM service-linked role. This
     * could be because of any of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * SLR has not been created yet and IPAM is still creating it.
     * </p>
     * </li>
     * <li>
     * <p>
     * You have opted-out of the IPAM home Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * Account you are using as your IPAM account has been suspended.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>throttling-failure</code> - IPAM account is already using the allotted transactions per second and IPAM is
     * receiving a throttling error when assuming the Amazon Web Services IAM SLR.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>unauthorized-failure</code> - Amazon Web Services account making the request is not authorized. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html">AuthFailure</a> in the
     * <i>Amazon Elastic Compute Cloud API Reference</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link IpamDiscoveryFailureCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codeAsString}.
     * </p>
     * 
     * @return The discovery failure code.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>assume-role-failure</code> - IPAM could not assume the Amazon Web Services IAM service-linked role.
     *         This could be because of any of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         SLR has not been created yet and IPAM is still creating it.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have opted-out of the IPAM home Region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Account you are using as your IPAM account has been suspended.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>throttling-failure</code> - IPAM account is already using the allotted transactions per second and
     *         IPAM is receiving a throttling error when assuming the Amazon Web Services IAM SLR.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>unauthorized-failure</code> - Amazon Web Services account making the request is not authorized. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html">AuthFailure</a> in the
     *         <i>Amazon Elastic Compute Cloud API Reference</i>.
     *         </p>
     *         </li>
     * @see IpamDiscoveryFailureCode
     */
    public final String codeAsString() {
        return code;
    }

    /**
     * <p>
     * The discovery failure message.
     * </p>
     * 
     * @return The discovery failure message.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpamDiscoveryFailureReason)) {
            return false;
        }
        IpamDiscoveryFailureReason other = (IpamDiscoveryFailureReason) obj;
        return Objects.equals(codeAsString(), other.codeAsString()) && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IpamDiscoveryFailureReason").add("Code", codeAsString()).add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Code":
            return Optional.ofNullable(clazz.cast(codeAsString()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IpamDiscoveryFailureReason, T> g) {
        return obj -> g.apply((IpamDiscoveryFailureReason) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IpamDiscoveryFailureReason> {
        /**
         * <p>
         * The discovery failure code.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>assume-role-failure</code> - IPAM could not assume the Amazon Web Services IAM service-linked role.
         * This could be because of any of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * SLR has not been created yet and IPAM is still creating it.
         * </p>
         * </li>
         * <li>
         * <p>
         * You have opted-out of the IPAM home Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * Account you are using as your IPAM account has been suspended.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>throttling-failure</code> - IPAM account is already using the allotted transactions per second and IPAM
         * is receiving a throttling error when assuming the Amazon Web Services IAM SLR.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>unauthorized-failure</code> - Amazon Web Services account making the request is not authorized. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html">AuthFailure</a> in the
         * <i>Amazon Elastic Compute Cloud API Reference</i>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param code
         *        The discovery failure code.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>assume-role-failure</code> - IPAM could not assume the Amazon Web Services IAM service-linked
         *        role. This could be because of any of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        SLR has not been created yet and IPAM is still creating it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You have opted-out of the IPAM home Region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Account you are using as your IPAM account has been suspended.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>throttling-failure</code> - IPAM account is already using the allotted transactions per second
         *        and IPAM is receiving a throttling error when assuming the Amazon Web Services IAM SLR.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>unauthorized-failure</code> - Amazon Web Services account making the request is not authorized.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html">AuthFailure</a> in
         *        the <i>Amazon Elastic Compute Cloud API Reference</i>.
         *        </p>
         *        </li>
         * @see IpamDiscoveryFailureCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpamDiscoveryFailureCode
         */
        Builder code(String code);

        /**
         * <p>
         * The discovery failure code.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>assume-role-failure</code> - IPAM could not assume the Amazon Web Services IAM service-linked role.
         * This could be because of any of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * SLR has not been created yet and IPAM is still creating it.
         * </p>
         * </li>
         * <li>
         * <p>
         * You have opted-out of the IPAM home Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * Account you are using as your IPAM account has been suspended.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>throttling-failure</code> - IPAM account is already using the allotted transactions per second and IPAM
         * is receiving a throttling error when assuming the Amazon Web Services IAM SLR.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>unauthorized-failure</code> - Amazon Web Services account making the request is not authorized. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html">AuthFailure</a> in the
         * <i>Amazon Elastic Compute Cloud API Reference</i>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param code
         *        The discovery failure code.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>assume-role-failure</code> - IPAM could not assume the Amazon Web Services IAM service-linked
         *        role. This could be because of any of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        SLR has not been created yet and IPAM is still creating it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You have opted-out of the IPAM home Region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Account you are using as your IPAM account has been suspended.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>throttling-failure</code> - IPAM account is already using the allotted transactions per second
         *        and IPAM is receiving a throttling error when assuming the Amazon Web Services IAM SLR.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>unauthorized-failure</code> - Amazon Web Services account making the request is not authorized.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html">AuthFailure</a> in
         *        the <i>Amazon Elastic Compute Cloud API Reference</i>.
         *        </p>
         *        </li>
         * @see IpamDiscoveryFailureCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpamDiscoveryFailureCode
         */
        Builder code(IpamDiscoveryFailureCode code);

        /**
         * <p>
         * The discovery failure message.
         * </p>
         * 
         * @param message
         *        The discovery failure message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(IpamDiscoveryFailureReason model) {
            code(model.code);
            message(model.message);
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(IpamDiscoveryFailureCode code) {
            this.code(code == null ? null : code.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public IpamDiscoveryFailureReason build() {
            return new IpamDiscoveryFailureReason(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
