/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Tags for a public IP address discovered by IPAM.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IpamPublicAddressTags implements SdkPojo, Serializable,
        ToCopyableBuilder<IpamPublicAddressTags.Builder, IpamPublicAddressTags> {
    private static final SdkField<List<IpamPublicAddressTag>> EIP_TAGS_FIELD = SdkField
            .<List<IpamPublicAddressTag>> builder(MarshallingType.LIST)
            .memberName("EipTags")
            .getter(getter(IpamPublicAddressTags::eipTags))
            .setter(setter(Builder::eipTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EipTagSet")
                    .unmarshallLocationName("eipTagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<IpamPublicAddressTag> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpamPublicAddressTag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EIP_TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("EipTagSet", EIP_TAGS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final List<IpamPublicAddressTag> eipTags;

    private IpamPublicAddressTags(BuilderImpl builder) {
        this.eipTags = builder.eipTags;
    }

    /**
     * For responses, this returns true if the service returned a value for the EipTags property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEipTags() {
        return eipTags != null && !(eipTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tags for an Elastic IP address.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEipTags} method.
     * </p>
     * 
     * @return Tags for an Elastic IP address.
     */
    public final List<IpamPublicAddressTag> eipTags() {
        return eipTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasEipTags() ? eipTags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpamPublicAddressTags)) {
            return false;
        }
        IpamPublicAddressTags other = (IpamPublicAddressTags) obj;
        return hasEipTags() == other.hasEipTags() && Objects.equals(eipTags(), other.eipTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IpamPublicAddressTags").add("EipTags", hasEipTags() ? eipTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EipTags":
            return Optional.ofNullable(clazz.cast(eipTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IpamPublicAddressTags, T> g) {
        return obj -> g.apply((IpamPublicAddressTags) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IpamPublicAddressTags> {
        /**
         * <p>
         * Tags for an Elastic IP address.
         * </p>
         * 
         * @param eipTags
         *        Tags for an Elastic IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eipTags(Collection<IpamPublicAddressTag> eipTags);

        /**
         * <p>
         * Tags for an Elastic IP address.
         * </p>
         * 
         * @param eipTags
         *        Tags for an Elastic IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eipTags(IpamPublicAddressTag... eipTags);

        /**
         * <p>
         * Tags for an Elastic IP address.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.IpamPublicAddressTag.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ec2.model.IpamPublicAddressTag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.IpamPublicAddressTag.Builder#build()} is called immediately
         * and its result is passed to {@link #eipTags(List<IpamPublicAddressTag>)}.
         * 
         * @param eipTags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.IpamPublicAddressTag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eipTags(java.util.Collection<IpamPublicAddressTag>)
         */
        Builder eipTags(Consumer<IpamPublicAddressTag.Builder>... eipTags);
    }

    static final class BuilderImpl implements Builder {
        private List<IpamPublicAddressTag> eipTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IpamPublicAddressTags model) {
            eipTags(model.eipTags);
        }

        public final List<IpamPublicAddressTag.Builder> getEipTags() {
            List<IpamPublicAddressTag.Builder> result = IpamPublicAddressTagListCopier.copyToBuilder(this.eipTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEipTags(Collection<IpamPublicAddressTag.BuilderImpl> eipTags) {
            this.eipTags = IpamPublicAddressTagListCopier.copyFromBuilder(eipTags);
        }

        @Override
        public final Builder eipTags(Collection<IpamPublicAddressTag> eipTags) {
            this.eipTags = IpamPublicAddressTagListCopier.copy(eipTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eipTags(IpamPublicAddressTag... eipTags) {
            eipTags(Arrays.asList(eipTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eipTags(Consumer<IpamPublicAddressTag.Builder>... eipTags) {
            eipTags(Stream.of(eipTags).map(c -> IpamPublicAddressTag.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public IpamPublicAddressTags build() {
            return new IpamPublicAddressTags(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
