/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the EC2 Mac Dedicated Host.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MacHost implements SdkPojo, Serializable, ToCopyableBuilder<MacHost.Builder, MacHost> {
    private static final SdkField<String> HOST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HostId")
            .getter(getter(MacHost::hostId))
            .setter(setter(Builder::hostId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostId")
                    .unmarshallLocationName("hostId").build()).build();

    private static final SdkField<List<String>> MAC_OS_LATEST_SUPPORTED_VERSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MacOSLatestSupportedVersions")
            .getter(getter(MacHost::macOSLatestSupportedVersions))
            .setter(setter(Builder::macOSLatestSupportedVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MacOSLatestSupportedVersionSet")
                    .unmarshallLocationName("macOSLatestSupportedVersionSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_ID_FIELD,
            MAC_OS_LATEST_SUPPORTED_VERSIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("HostId", HOST_ID_FIELD);
                    put("MacOSLatestSupportedVersionSet", MAC_OS_LATEST_SUPPORTED_VERSIONS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String hostId;

    private final List<String> macOSLatestSupportedVersions;

    private MacHost(BuilderImpl builder) {
        this.hostId = builder.hostId;
        this.macOSLatestSupportedVersions = builder.macOSLatestSupportedVersions;
    }

    /**
     * <p>
     * The EC2 Mac Dedicated Host ID.
     * </p>
     * 
     * @return The EC2 Mac Dedicated Host ID.
     */
    public final String hostId() {
        return hostId;
    }

    /**
     * For responses, this returns true if the service returned a value for the MacOSLatestSupportedVersions property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasMacOSLatestSupportedVersions() {
        return macOSLatestSupportedVersions != null && !(macOSLatestSupportedVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The latest macOS versions that the EC2 Mac Dedicated Host can launch without being upgraded.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMacOSLatestSupportedVersions} method.
     * </p>
     * 
     * @return The latest macOS versions that the EC2 Mac Dedicated Host can launch without being upgraded.
     */
    public final List<String> macOSLatestSupportedVersions() {
        return macOSLatestSupportedVersions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostId());
        hashCode = 31 * hashCode + Objects.hashCode(hasMacOSLatestSupportedVersions() ? macOSLatestSupportedVersions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MacHost)) {
            return false;
        }
        MacHost other = (MacHost) obj;
        return Objects.equals(hostId(), other.hostId())
                && hasMacOSLatestSupportedVersions() == other.hasMacOSLatestSupportedVersions()
                && Objects.equals(macOSLatestSupportedVersions(), other.macOSLatestSupportedVersions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MacHost").add("HostId", hostId())
                .add("MacOSLatestSupportedVersions", hasMacOSLatestSupportedVersions() ? macOSLatestSupportedVersions() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostId":
            return Optional.ofNullable(clazz.cast(hostId()));
        case "MacOSLatestSupportedVersions":
            return Optional.ofNullable(clazz.cast(macOSLatestSupportedVersions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MacHost, T> g) {
        return obj -> g.apply((MacHost) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MacHost> {
        /**
         * <p>
         * The EC2 Mac Dedicated Host ID.
         * </p>
         * 
         * @param hostId
         *        The EC2 Mac Dedicated Host ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostId(String hostId);

        /**
         * <p>
         * The latest macOS versions that the EC2 Mac Dedicated Host can launch without being upgraded.
         * </p>
         * 
         * @param macOSLatestSupportedVersions
         *        The latest macOS versions that the EC2 Mac Dedicated Host can launch without being upgraded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder macOSLatestSupportedVersions(Collection<String> macOSLatestSupportedVersions);

        /**
         * <p>
         * The latest macOS versions that the EC2 Mac Dedicated Host can launch without being upgraded.
         * </p>
         * 
         * @param macOSLatestSupportedVersions
         *        The latest macOS versions that the EC2 Mac Dedicated Host can launch without being upgraded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder macOSLatestSupportedVersions(String... macOSLatestSupportedVersions);
    }

    static final class BuilderImpl implements Builder {
        private String hostId;

        private List<String> macOSLatestSupportedVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MacHost model) {
            hostId(model.hostId);
            macOSLatestSupportedVersions(model.macOSLatestSupportedVersions);
        }

        public final String getHostId() {
            return hostId;
        }

        public final void setHostId(String hostId) {
            this.hostId = hostId;
        }

        @Override
        public final Builder hostId(String hostId) {
            this.hostId = hostId;
            return this;
        }

        public final Collection<String> getMacOSLatestSupportedVersions() {
            if (macOSLatestSupportedVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return macOSLatestSupportedVersions;
        }

        public final void setMacOSLatestSupportedVersions(Collection<String> macOSLatestSupportedVersions) {
            this.macOSLatestSupportedVersions = MacOSVersionStringListCopier.copy(macOSLatestSupportedVersions);
        }

        @Override
        public final Builder macOSLatestSupportedVersions(Collection<String> macOSLatestSupportedVersions) {
            this.macOSLatestSupportedVersions = MacOSVersionStringListCopier.copy(macOSLatestSupportedVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder macOSLatestSupportedVersions(String... macOSLatestSupportedVersions) {
            macOSLatestSupportedVersions(Arrays.asList(macOSLatestSupportedVersions));
            return this;
        }

        @Override
        public MacHost build() {
            return new MacHost(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
