/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyIdFormatRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyIdFormatRequest.Builder, ModifyIdFormatRequest> {
    private static final SdkField<String> RESOURCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Resource")
            .getter(getter(ModifyIdFormatRequest::resource))
            .setter(setter(Builder::resource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resource")
                    .unmarshallLocationName("Resource").build()).build();

    private static final SdkField<Boolean> USE_LONG_IDS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UseLongIds")
            .getter(getter(ModifyIdFormatRequest::useLongIds))
            .setter(setter(Builder::useLongIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseLongIds")
                    .unmarshallLocationName("UseLongIds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_FIELD,
            USE_LONG_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Resource", RESOURCE_FIELD);
                    put("UseLongIds", USE_LONG_IDS_FIELD);
                }
            });

    private final String resource;

    private final Boolean useLongIds;

    private ModifyIdFormatRequest(BuilderImpl builder) {
        super(builder);
        this.resource = builder.resource;
        this.useLongIds = builder.useLongIds;
    }

    /**
     * <p>
     * The type of resource: <code>bundle</code> | <code>conversion-task</code> | <code>customer-gateway</code> |
     * <code>dhcp-options</code> | <code>elastic-ip-allocation</code> | <code>elastic-ip-association</code> |
     * <code>export-task</code> | <code>flow-log</code> | <code>image</code> | <code>import-task</code> |
     * <code>internet-gateway</code> | <code>network-acl</code> | <code>network-acl-association</code> |
     * <code>network-interface</code> | <code>network-interface-attachment</code> | <code>prefix-list</code> |
     * <code>route-table</code> | <code>route-table-association</code> | <code>security-group</code> |
     * <code>subnet</code> | <code>subnet-cidr-block-association</code> | <code>vpc</code> |
     * <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> |
     * <code>vpn-connection</code> | <code>vpn-gateway</code>.
     * </p>
     * <p>
     * Alternatively, use the <code>all-current</code> option to include all resource types that are currently within
     * their opt-in period for longer IDs.
     * </p>
     * 
     * @return The type of resource: <code>bundle</code> | <code>conversion-task</code> | <code>customer-gateway</code>
     *         | <code>dhcp-options</code> | <code>elastic-ip-allocation</code> | <code>elastic-ip-association</code> |
     *         <code>export-task</code> | <code>flow-log</code> | <code>image</code> | <code>import-task</code> |
     *         <code>internet-gateway</code> | <code>network-acl</code> | <code>network-acl-association</code> |
     *         <code>network-interface</code> | <code>network-interface-attachment</code> | <code>prefix-list</code> |
     *         <code>route-table</code> | <code>route-table-association</code> | <code>security-group</code> |
     *         <code>subnet</code> | <code>subnet-cidr-block-association</code> | <code>vpc</code> |
     *         <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code>
     *         | <code>vpn-connection</code> | <code>vpn-gateway</code>.</p>
     *         <p>
     *         Alternatively, use the <code>all-current</code> option to include all resource types that are currently
     *         within their opt-in period for longer IDs.
     */
    public final String resource() {
        return resource;
    }

    /**
     * <p>
     * Indicate whether the resource should use longer IDs (17-character IDs).
     * </p>
     * 
     * @return Indicate whether the resource should use longer IDs (17-character IDs).
     */
    public final Boolean useLongIds() {
        return useLongIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(useLongIds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyIdFormatRequest)) {
            return false;
        }
        ModifyIdFormatRequest other = (ModifyIdFormatRequest) obj;
        return Objects.equals(resource(), other.resource()) && Objects.equals(useLongIds(), other.useLongIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyIdFormatRequest").add("Resource", resource()).add("UseLongIds", useLongIds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "UseLongIds":
            return Optional.ofNullable(clazz.cast(useLongIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ModifyIdFormatRequest, T> g) {
        return obj -> g.apply((ModifyIdFormatRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyIdFormatRequest> {
        /**
         * <p>
         * The type of resource: <code>bundle</code> | <code>conversion-task</code> | <code>customer-gateway</code> |
         * <code>dhcp-options</code> | <code>elastic-ip-allocation</code> | <code>elastic-ip-association</code> |
         * <code>export-task</code> | <code>flow-log</code> | <code>image</code> | <code>import-task</code> |
         * <code>internet-gateway</code> | <code>network-acl</code> | <code>network-acl-association</code> |
         * <code>network-interface</code> | <code>network-interface-attachment</code> | <code>prefix-list</code> |
         * <code>route-table</code> | <code>route-table-association</code> | <code>security-group</code> |
         * <code>subnet</code> | <code>subnet-cidr-block-association</code> | <code>vpc</code> |
         * <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> |
         * <code>vpn-connection</code> | <code>vpn-gateway</code>.
         * </p>
         * <p>
         * Alternatively, use the <code>all-current</code> option to include all resource types that are currently
         * within their opt-in period for longer IDs.
         * </p>
         * 
         * @param resource
         *        The type of resource: <code>bundle</code> | <code>conversion-task</code> |
         *        <code>customer-gateway</code> | <code>dhcp-options</code> | <code>elastic-ip-allocation</code> |
         *        <code>elastic-ip-association</code> | <code>export-task</code> | <code>flow-log</code> |
         *        <code>image</code> | <code>import-task</code> | <code>internet-gateway</code> |
         *        <code>network-acl</code> | <code>network-acl-association</code> | <code>network-interface</code> |
         *        <code>network-interface-attachment</code> | <code>prefix-list</code> | <code>route-table</code> |
         *        <code>route-table-association</code> | <code>security-group</code> | <code>subnet</code> |
         *        <code>subnet-cidr-block-association</code> | <code>vpc</code> |
         *        <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> |
         *        <code>vpc-peering-connection</code> | <code>vpn-connection</code> | <code>vpn-gateway</code>.</p>
         *        <p>
         *        Alternatively, use the <code>all-current</code> option to include all resource types that are
         *        currently within their opt-in period for longer IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(String resource);

        /**
         * <p>
         * Indicate whether the resource should use longer IDs (17-character IDs).
         * </p>
         * 
         * @param useLongIds
         *        Indicate whether the resource should use longer IDs (17-character IDs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useLongIds(Boolean useLongIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String resource;

        private Boolean useLongIds;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyIdFormatRequest model) {
            super(model);
            resource(model.resource);
            useLongIds(model.useLongIds);
        }

        public final String getResource() {
            return resource;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final Boolean getUseLongIds() {
            return useLongIds;
        }

        public final void setUseLongIds(Boolean useLongIds) {
            this.useLongIds = useLongIds;
        }

        @Override
        public final Builder useLongIds(Boolean useLongIds) {
            this.useLongIds = useLongIds;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyIdFormatRequest build() {
            return new ModifyIdFormatRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
