/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyIpamResourceDiscoveryResponse extends Ec2Response implements
        ToCopyableBuilder<ModifyIpamResourceDiscoveryResponse.Builder, ModifyIpamResourceDiscoveryResponse> {
    private static final SdkField<IpamResourceDiscovery> IPAM_RESOURCE_DISCOVERY_FIELD = SdkField
            .<IpamResourceDiscovery> builder(MarshallingType.SDK_POJO)
            .memberName("IpamResourceDiscovery")
            .getter(getter(ModifyIpamResourceDiscoveryResponse::ipamResourceDiscovery))
            .setter(setter(Builder::ipamResourceDiscovery))
            .constructor(IpamResourceDiscovery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamResourceDiscovery")
                    .unmarshallLocationName("ipamResourceDiscovery").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(IPAM_RESOURCE_DISCOVERY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("IpamResourceDiscovery", IPAM_RESOURCE_DISCOVERY_FIELD);
                }
            });

    private final IpamResourceDiscovery ipamResourceDiscovery;

    private ModifyIpamResourceDiscoveryResponse(BuilderImpl builder) {
        super(builder);
        this.ipamResourceDiscovery = builder.ipamResourceDiscovery;
    }

    /**
     * <p>
     * A resource discovery.
     * </p>
     * 
     * @return A resource discovery.
     */
    public final IpamResourceDiscovery ipamResourceDiscovery() {
        return ipamResourceDiscovery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ipamResourceDiscovery());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyIpamResourceDiscoveryResponse)) {
            return false;
        }
        ModifyIpamResourceDiscoveryResponse other = (ModifyIpamResourceDiscoveryResponse) obj;
        return Objects.equals(ipamResourceDiscovery(), other.ipamResourceDiscovery());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyIpamResourceDiscoveryResponse").add("IpamResourceDiscovery", ipamResourceDiscovery())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpamResourceDiscovery":
            return Optional.ofNullable(clazz.cast(ipamResourceDiscovery()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ModifyIpamResourceDiscoveryResponse, T> g) {
        return obj -> g.apply((ModifyIpamResourceDiscoveryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, ModifyIpamResourceDiscoveryResponse> {
        /**
         * <p>
         * A resource discovery.
         * </p>
         * 
         * @param ipamResourceDiscovery
         *        A resource discovery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamResourceDiscovery(IpamResourceDiscovery ipamResourceDiscovery);

        /**
         * <p>
         * A resource discovery.
         * </p>
         * This is a convenience method that creates an instance of the {@link IpamResourceDiscovery.Builder} avoiding
         * the need to create one manually via {@link IpamResourceDiscovery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IpamResourceDiscovery.Builder#build()} is called immediately and
         * its result is passed to {@link #ipamResourceDiscovery(IpamResourceDiscovery)}.
         * 
         * @param ipamResourceDiscovery
         *        a consumer that will call methods on {@link IpamResourceDiscovery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipamResourceDiscovery(IpamResourceDiscovery)
         */
        default Builder ipamResourceDiscovery(Consumer<IpamResourceDiscovery.Builder> ipamResourceDiscovery) {
            return ipamResourceDiscovery(IpamResourceDiscovery.builder().applyMutation(ipamResourceDiscovery).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private IpamResourceDiscovery ipamResourceDiscovery;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyIpamResourceDiscoveryResponse model) {
            super(model);
            ipamResourceDiscovery(model.ipamResourceDiscovery);
        }

        public final IpamResourceDiscovery.Builder getIpamResourceDiscovery() {
            return ipamResourceDiscovery != null ? ipamResourceDiscovery.toBuilder() : null;
        }

        public final void setIpamResourceDiscovery(IpamResourceDiscovery.BuilderImpl ipamResourceDiscovery) {
            this.ipamResourceDiscovery = ipamResourceDiscovery != null ? ipamResourceDiscovery.build() : null;
        }

        @Override
        public final Builder ipamResourceDiscovery(IpamResourceDiscovery ipamResourceDiscovery) {
            this.ipamResourceDiscovery = ipamResourceDiscovery;
            return this;
        }

        @Override
        public ModifyIpamResourceDiscoveryResponse build() {
            return new ModifyIpamResourceDiscoveryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
