/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the meta data tags associated with a transit gateway policy rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransitGatewayPolicyRuleMetaData implements SdkPojo, Serializable,
        ToCopyableBuilder<TransitGatewayPolicyRuleMetaData.Builder, TransitGatewayPolicyRuleMetaData> {
    private static final SdkField<String> META_DATA_KEY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MetaDataKey")
            .getter(getter(TransitGatewayPolicyRuleMetaData::metaDataKey))
            .setter(setter(Builder::metaDataKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetaDataKey")
                    .unmarshallLocationName("metaDataKey").build()).build();

    private static final SdkField<String> META_DATA_VALUE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MetaDataValue")
            .getter(getter(TransitGatewayPolicyRuleMetaData::metaDataValue))
            .setter(setter(Builder::metaDataValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetaDataValue")
                    .unmarshallLocationName("metaDataValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(META_DATA_KEY_FIELD,
            META_DATA_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("MetaDataKey", META_DATA_KEY_FIELD);
                    put("MetaDataValue", META_DATA_VALUE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String metaDataKey;

    private final String metaDataValue;

    private TransitGatewayPolicyRuleMetaData(BuilderImpl builder) {
        this.metaDataKey = builder.metaDataKey;
        this.metaDataValue = builder.metaDataValue;
    }

    /**
     * <p>
     * The key name for the transit gateway policy rule meta data tag.
     * </p>
     * 
     * @return The key name for the transit gateway policy rule meta data tag.
     */
    public final String metaDataKey() {
        return metaDataKey;
    }

    /**
     * <p>
     * The value of the key for the transit gateway policy rule meta data tag.
     * </p>
     * 
     * @return The value of the key for the transit gateway policy rule meta data tag.
     */
    public final String metaDataValue() {
        return metaDataValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metaDataKey());
        hashCode = 31 * hashCode + Objects.hashCode(metaDataValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayPolicyRuleMetaData)) {
            return false;
        }
        TransitGatewayPolicyRuleMetaData other = (TransitGatewayPolicyRuleMetaData) obj;
        return Objects.equals(metaDataKey(), other.metaDataKey()) && Objects.equals(metaDataValue(), other.metaDataValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransitGatewayPolicyRuleMetaData").add("MetaDataKey", metaDataKey())
                .add("MetaDataValue", metaDataValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetaDataKey":
            return Optional.ofNullable(clazz.cast(metaDataKey()));
        case "MetaDataValue":
            return Optional.ofNullable(clazz.cast(metaDataValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayPolicyRuleMetaData, T> g) {
        return obj -> g.apply((TransitGatewayPolicyRuleMetaData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransitGatewayPolicyRuleMetaData> {
        /**
         * <p>
         * The key name for the transit gateway policy rule meta data tag.
         * </p>
         * 
         * @param metaDataKey
         *        The key name for the transit gateway policy rule meta data tag.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metaDataKey(String metaDataKey);

        /**
         * <p>
         * The value of the key for the transit gateway policy rule meta data tag.
         * </p>
         * 
         * @param metaDataValue
         *        The value of the key for the transit gateway policy rule meta data tag.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metaDataValue(String metaDataValue);
    }

    static final class BuilderImpl implements Builder {
        private String metaDataKey;

        private String metaDataValue;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayPolicyRuleMetaData model) {
            metaDataKey(model.metaDataKey);
            metaDataValue(model.metaDataValue);
        }

        public final String getMetaDataKey() {
            return metaDataKey;
        }

        public final void setMetaDataKey(String metaDataKey) {
            this.metaDataKey = metaDataKey;
        }

        @Override
        public final Builder metaDataKey(String metaDataKey) {
            this.metaDataKey = metaDataKey;
            return this;
        }

        public final String getMetaDataValue() {
            return metaDataValue;
        }

        public final void setMetaDataValue(String metaDataValue) {
            this.metaDataValue = metaDataValue;
        }

        @Override
        public final Builder metaDataValue(String metaDataValue) {
            this.metaDataValue = metaDataValue;
            return this;
        }

        @Override
        public TransitGatewayPolicyRuleMetaData build() {
            return new TransitGatewayPolicyRuleMetaData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
