/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdvertiseByoipCidrRequest extends Ec2Request implements
        ToCopyableBuilder<AdvertiseByoipCidrRequest.Builder, AdvertiseByoipCidrRequest> {
    private static final SdkField<String> CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Cidr")
            .getter(getter(AdvertiseByoipCidrRequest::cidr))
            .setter(setter(Builder::cidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidr")
                    .unmarshallLocationName("Cidr").build()).build();

    private static final SdkField<String> ASN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Asn")
            .getter(getter(AdvertiseByoipCidrRequest::asn))
            .setter(setter(Builder::asn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Asn").unmarshallLocationName("Asn")
                    .build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(AdvertiseByoipCidrRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<String> NETWORK_BORDER_GROUP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkBorderGroup")
            .getter(getter(AdvertiseByoipCidrRequest::networkBorderGroup))
            .setter(setter(Builder::networkBorderGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkBorderGroup")
                    .unmarshallLocationName("NetworkBorderGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_FIELD, ASN_FIELD,
            DRY_RUN_FIELD, NETWORK_BORDER_GROUP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Cidr", CIDR_FIELD);
                    put("Asn", ASN_FIELD);
                    put("DryRun", DRY_RUN_FIELD);
                    put("NetworkBorderGroup", NETWORK_BORDER_GROUP_FIELD);
                }
            });

    private final String cidr;

    private final String asn;

    private final Boolean dryRun;

    private final String networkBorderGroup;

    private AdvertiseByoipCidrRequest(BuilderImpl builder) {
        super(builder);
        this.cidr = builder.cidr;
        this.asn = builder.asn;
        this.dryRun = builder.dryRun;
        this.networkBorderGroup = builder.networkBorderGroup;
    }

    /**
     * <p>
     * The address range, in CIDR notation. This must be the exact range that you provisioned. You can't advertise only
     * a portion of the provisioned range.
     * </p>
     * 
     * @return The address range, in CIDR notation. This must be the exact range that you provisioned. You can't
     *         advertise only a portion of the provisioned range.
     */
    public final String cidr() {
        return cidr;
    }

    /**
     * <p>
     * The public 2-byte or 4-byte ASN that you want to advertise.
     * </p>
     * 
     * @return The public 2-byte or 4-byte ASN that you want to advertise.
     */
    public final String asn() {
        return asn;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * If you have <a href="https://docs.aws.amazon.com/local-zones/latest/ug/how-local-zones-work.html">Local Zones</a>
     * enabled, you can choose a network border group for Local Zones when you provision and advertise a BYOIPv4 CIDR.
     * Choose the network border group carefully as the EIP and the Amazon Web Services resource it is associated with
     * must reside in the same network border group.
     * </p>
     * <p>
     * You can provision BYOIP address ranges to and advertise them in the following Local Zone network border groups:
     * </p>
     * <ul>
     * <li>
     * <p>
     * us-east-1-dfw-2
     * </p>
     * </li>
     * <li>
     * <p>
     * us-west-2-lax-1
     * </p>
     * </li>
     * <li>
     * <p>
     * us-west-2-phx-2
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * You cannot provision or advertise BYOIPv6 address ranges in Local Zones at this time.
     * </p>
     * </note>
     * 
     * @return If you have <a href="https://docs.aws.amazon.com/local-zones/latest/ug/how-local-zones-work.html">Local
     *         Zones</a> enabled, you can choose a network border group for Local Zones when you provision and advertise
     *         a BYOIPv4 CIDR. Choose the network border group carefully as the EIP and the Amazon Web Services resource
     *         it is associated with must reside in the same network border group.</p>
     *         <p>
     *         You can provision BYOIP address ranges to and advertise them in the following Local Zone network border
     *         groups:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         us-east-1-dfw-2
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         us-west-2-lax-1
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         us-west-2-phx-2
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         You cannot provision or advertise BYOIPv6 address ranges in Local Zones at this time.
     *         </p>
     */
    public final String networkBorderGroup() {
        return networkBorderGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cidr());
        hashCode = 31 * hashCode + Objects.hashCode(asn());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(networkBorderGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdvertiseByoipCidrRequest)) {
            return false;
        }
        AdvertiseByoipCidrRequest other = (AdvertiseByoipCidrRequest) obj;
        return Objects.equals(cidr(), other.cidr()) && Objects.equals(asn(), other.asn())
                && Objects.equals(dryRun(), other.dryRun()) && Objects.equals(networkBorderGroup(), other.networkBorderGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AdvertiseByoipCidrRequest").add("Cidr", cidr()).add("Asn", asn()).add("DryRun", dryRun())
                .add("NetworkBorderGroup", networkBorderGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Cidr":
            return Optional.ofNullable(clazz.cast(cidr()));
        case "Asn":
            return Optional.ofNullable(clazz.cast(asn()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "NetworkBorderGroup":
            return Optional.ofNullable(clazz.cast(networkBorderGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AdvertiseByoipCidrRequest, T> g) {
        return obj -> g.apply((AdvertiseByoipCidrRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, AdvertiseByoipCidrRequest> {
        /**
         * <p>
         * The address range, in CIDR notation. This must be the exact range that you provisioned. You can't advertise
         * only a portion of the provisioned range.
         * </p>
         * 
         * @param cidr
         *        The address range, in CIDR notation. This must be the exact range that you provisioned. You can't
         *        advertise only a portion of the provisioned range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidr(String cidr);

        /**
         * <p>
         * The public 2-byte or 4-byte ASN that you want to advertise.
         * </p>
         * 
         * @param asn
         *        The public 2-byte or 4-byte ASN that you want to advertise.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asn(String asn);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * If you have <a href="https://docs.aws.amazon.com/local-zones/latest/ug/how-local-zones-work.html">Local
         * Zones</a> enabled, you can choose a network border group for Local Zones when you provision and advertise a
         * BYOIPv4 CIDR. Choose the network border group carefully as the EIP and the Amazon Web Services resource it is
         * associated with must reside in the same network border group.
         * </p>
         * <p>
         * You can provision BYOIP address ranges to and advertise them in the following Local Zone network border
         * groups:
         * </p>
         * <ul>
         * <li>
         * <p>
         * us-east-1-dfw-2
         * </p>
         * </li>
         * <li>
         * <p>
         * us-west-2-lax-1
         * </p>
         * </li>
         * <li>
         * <p>
         * us-west-2-phx-2
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * You cannot provision or advertise BYOIPv6 address ranges in Local Zones at this time.
         * </p>
         * </note>
         * 
         * @param networkBorderGroup
         *        If you have <a
         *        href="https://docs.aws.amazon.com/local-zones/latest/ug/how-local-zones-work.html">Local Zones</a>
         *        enabled, you can choose a network border group for Local Zones when you provision and advertise a
         *        BYOIPv4 CIDR. Choose the network border group carefully as the EIP and the Amazon Web Services
         *        resource it is associated with must reside in the same network border group.</p>
         *        <p>
         *        You can provision BYOIP address ranges to and advertise them in the following Local Zone network
         *        border groups:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        us-east-1-dfw-2
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        us-west-2-lax-1
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        us-west-2-phx-2
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        You cannot provision or advertise BYOIPv6 address ranges in Local Zones at this time.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkBorderGroup(String networkBorderGroup);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String cidr;

        private String asn;

        private Boolean dryRun;

        private String networkBorderGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(AdvertiseByoipCidrRequest model) {
            super(model);
            cidr(model.cidr);
            asn(model.asn);
            dryRun(model.dryRun);
            networkBorderGroup(model.networkBorderGroup);
        }

        public final String getCidr() {
            return cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final String getAsn() {
            return asn;
        }

        public final void setAsn(String asn) {
            this.asn = asn;
        }

        @Override
        public final Builder asn(String asn) {
            this.asn = asn;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getNetworkBorderGroup() {
            return networkBorderGroup;
        }

        public final void setNetworkBorderGroup(String networkBorderGroup) {
            this.networkBorderGroup = networkBorderGroup;
        }

        @Override
        public final Builder networkBorderGroup(String networkBorderGroup) {
            this.networkBorderGroup = networkBorderGroup;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AdvertiseByoipCidrRequest build() {
            return new AdvertiseByoipCidrRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
